/*
 * $Description: veeData RPC API function definitions $
 *
 * $Revision: 1.35 $
 *
 * $Date: 97/02/03 16:25:35 $
 *
 * $Copyright: 1996 Hewlett-Packard Company.  All rights reserved. $
 * 
 * Supported on HP-UX 9.x, 10.x, Solaris, Win95, WinNT only.
 * Released with VEE version 3.2
 * 
*/

#if !defined(_vRpcIncluded_)
#define _vRpcIncluded_

/*
** Attributes
*/
#define		VRPC_WAIT_SLEEPING 		0x01 /* default behaviour */
#define     VRPC_WAIT_SPINNING 		0x02
#define     VRPC_BUFFER_EXPAND 		0x04
#define     VRPC_NO_WAITING    		0x08
#define     VRPC_CREATE_NEW    		0x10
#define     VRPC_DEBUG_EXECUTION 	0x20
#define		VRPC_NORMAL_EXECUTION	0x40


/*
** Error codes
*/

#ifndef VEE_INTERNAL

/** Returned when a connection to the VEE server cannot be made **/
#define	eUnknownHost         	850 /* host name or IP address unresolvable */
#define	eNoServiceManager       851 /* veesm cannot be found on server host */
#define eServiceManagerTO   	861 /* service manager timed-out */
#define	eServiceNotFound        863 /* unable to find  VEE service */
#define	eServiceNotStarted      864 /* unable to start VEE service */
#define	eConnectRefused     	866 /* connection to veesm or inetd refused */
#define	eFailedSecurity     	868 /* failed security check on UNIX */

/** Fatal errors that occur after connection to a VEE server **/
/** This means the connection has been terminated **/
#define	eHostDown           	852 /* VEE server host down */    
#define	eConnectTimedOut        853 /* connection has timed out */
#define	eConnectBroken      	855 /* connection has broken */

/** Errors that reflect an internal non-fatal state within the service **/
#define eSomeInternalError      865 /* An inon-fatal internal error */
#define	eVeeServiceError    	869 /* error within the user function */
#define eWouldBlock             870 /* returned for non-blocking rpc */
#define	eDebugTermination   	871 /* user pressed stop during debug session */

/** Error returned by a RPC Function call */
#define eInvalidArgument    	630

#endif


typedef void* VRPC_SERVICE;
typedef void* VRPC_LIBRARY;
typedef void* VRPC_FUNCTION;

/*
** Following types need veeData.h
*/
typedef struct VRPC_FUNC_INFO {
	char *functionName;

	long 			numArguments;
	veeType	*argumentTypes;
	veeShape 		*argumentShapes;
	char 			**argumentNames;

	long 			numResults;
	veeType	*resultTypes;
	veeShape 		*resultShapes;
	char 			**resultNames;

	char 			**description;
};

/*
** The following structure is used in the calls to
** vrpcGetFunctionNamesEx() and vrpcFreeFunctionNamesEx().
*/

typedef struct _VRPC_FUNCTION_PAIR{
	long numberOfFunctions;
	char **functionNames;
} VRPC_FUNCTION_PAIR;

/*
** The following structure is used in the vrpcGetVersion()
** function.
*/

typedef struct _VRPC_VERSION{
	unsigned short major;
	unsigned short minor;
} VRPC_VERSION;

/* See if C++ or not */
#if defined(__cplusplus)
   extern "C" {
#endif

#if defined(__STDC__) || defined(__cplusplus)

/*
** Service routines.
*/
VRPC_SERVICE vrpcCreateService(char *, char *, char *, double, unsigned long);
VRPC_SERVICE vrpcDeleteService(VRPC_SERVICE);

/*
** Library routines.
*/
VRPC_LIBRARY vrpcLoadLibrary(VRPC_SERVICE, char *);
VRPC_LIBRARY vrpcUnLoadLibrary(VRPC_LIBRARY);
void vrpcSetExecutionMode(VRPC_LIBRARY, unsigned long);

/*
** Function routines
*/
VRPC_FUNCTION vrpcFindFunction(VRPC_LIBRARY, char *);
char** vrpcGetFunctionNames(VRPC_LIBRARY, long *);
char** vrpcFreeFunctionNames(VRPC_LIBRARY aLibraryPtr, char **functionNames);
VRPC_FUNCTION_PAIR* vrpcGetFunctionNamesEx(VRPC_LIBRARY aLibraryPtr);
VRPC_FUNCTION_PAIR* vrpcFreeFunctionNamesEx(VRPC_FUNCTION_PAIR *funcInfoStruct);
struct VRPC_FUNC_INFO* vrpcFunctionInfo(VRPC_FUNCTION);
struct VRPC_FUNC_INFO* vrpcFreeFunctionInfo(struct VRPC_FUNC_INFO*);


/*
** Utility routines
*/
long vrpcSetTimeout(VRPC_SERVICE, double);
long vrpcSetBehavior(VRPC_SERVICE, unsigned long);
long vrpcGetServerVersion(VRPC_SERVICE);
char *vdcStrForShape(veeShape aShape);
char *vdcStrForType(veeType aType);
VRPC_VERSION* vrpcGetVersion(void);

/*
** Call and Receive
*/
VDC* vrpcCallAndReceive(VRPC_FUNCTION, VDC*);
long vrpcCall(VRPC_FUNCTION, VDC*);
VDC* vrpcReceive(VRPC_FUNCTION, unsigned long);

#else

VRPC_SERVICE vrpcCreateService();
VRPC_SERVICE vrpcDeleteService();

VRPC_LIBRARY vrpcLoadLibrary();
VRPC_LIBRARY vrpcUnLoadLibrary();
void vrpcSetExecutionMode();
char *vdcStrForType();
char *vdcStrForShape();

VRPC_FUNCTION vrpcFindFunction();
char** vrpcGetFunctionNames();
char** vrpcFreeFunctionNames();
VRPC_FUNCTION_PAIR* vrpcGetFunctionNamesEx();
VRPC_FUNCTION_PAIR* vrpcFreeFunctionNamesEx();
struct VRPC_FUNC_INFO* vrpcFunctionInfo();
struct VRPC_FUNC_INFO* vrpcFreeFunctionInfo();

long vrpcSetTimeout();
long vrpcSetBehavior();
long vrpcGetServerVersion();
VRPC_VERSION* vrpcGetVersion();

VDC* vrpcCallAndReceive();
long vrpcCall();
VDC* vrpcReceive();

#endif /* __STDC__ */

#if defined(__cplusplus)
   };
#endif
#endif
