/*
 * $Description: veeData API function definitions $
 *
 * $Revision: 1.49 $
 *
 * $Date: 97/02/03 16:25:22 $
 *
 * $Copyright: 1996 Hewlett-Packard Company.  All rights reserved. $
 * 
 * Supported on HP-UX 9.x, 10.x, Solaris, Win95, WinNT only.
 * Released with VEE version 3.2
 * 
 * 
*/
#if !defined(_vDataIncluded_)
#define _vDataIncluded_

#ifndef VEE_INTERNAL
typedef short int16;
typedef long  int32;
typedef struct {double rval, ival;} veeComplex;
typedef struct {double mag, phase;} veePComplex;
typedef struct {double xval, yval;} vee2DCoord;
typedef struct {double xval, yval, zval;} vee3DCoord;
typedef void veeDataContainer;
typedef veeDataContainer* VDC;

enum veeMapType {
	VEE_MAPPING_NONE,
	VEE_MAPPING_LINEAR,
	VEE_MAPPING_LOG
	};
typedef enum veeMapType VMT;

enum _veeType {
	VEE_TYPE_ANY = 0,			/* the default without constraints */
	VEE_NOT_DEFINED1,			/* leave space */
	VEE_LONG ,
	VEE_NOT_DEFINED2,           /* leave space */
	VEE_DOUBLE,
	VEE_COMPLEX,
	VEE_PCOMPLEX,
	VEE_STRING,
	VEE_NIL,
	VEE_NOT_DEFINED3,			/* leave space */
	VEE_COORD, 
	VEE_ENUM,
	VEE_RECORD,
	VEE_NOT_DEFINED4,			/* leave space */
	VEE_WAVEFORM,
	VEE_SPECTRUM
	};
typedef enum _veeType veeType;

enum _veeShape {
	VEE_SHAPE_SCALAR,			/* implies numDims = 0 */
	VEE_SHAPE_ARRAY1D,			/* implies numDims = 1 */
	VEE_SHAPE_ARRAY2D,			/* implies numDims = 2 */
	VEE_SHAPE_ARRAY3D,			/* implies numDims = 3 */
	VEE_SHAPE_ARRAY,			/* implies numDims >= 1 */
	VEE_SHAPE_ANY				/* numDims unspecified */ 
	};

typedef enum _veeShape veeShape;

#endif

/* See if C++ or not */
#if defined(__cplusplus)
   extern "C" {
#endif

#if defined(__STDC__) || defined(__cplusplus) 

/* veeDataContainer utility routines */
VDC  vdcCopy(VDC oldVD);
VDC  vdcFree(VDC aVD);
void vdcPrint(VDC aVD);
void *veeFree(void *data);
void *veeMalloc(int32 numBytes);
void *veeRealloc(void *block, int32 newNumBytes);
					   
/* Error msg and number support */
int16 veeGetErrorNumber(void);
char*   veeGetErrorString(void);

/* create scalar veedata container */
VDC vdcCreateLongScalar(int32 aLong);
VDC vdcCreateDoubleScalar(double aReal);
VDC vdcCreateStringScalar(char *aString);
VDC vdcCreateComplexScalar(double realPart, double imaginaryPart);
VDC vdcCreatePComplexScalar(double magnitude, double phase);
VDC vdcCreate2DCoordScalar(double xval, double yval);
VDC vdcCreate3DCoordScalar(double xval, double yval, double zval);
VDC vdcCreateCoordScalar(int16 fieldCount, double *values);

/* set value of scalar veedata container */
int32 vdcSetLongScalar(VDC aVD, int32 aLong) ;
int32 vdcSetDoubleScalar(VDC aVD, double aReal) ;
int32 vdcSetStringScalar(VDC aVD, char *aStr) ;
int32 vdcSetComplexScalar(VDC aVD, double realPart, double imaginaryPart) ;
int32 vdcSetPComplexScalar(VDC aVD, double magnitude, double phase) ;
int32 vdcSet2DCoordScalar(VDC aVD, double xval, double yval) ;
int32 vdcSet3DCoordScalar(VDC aVD, double xval, double yval, double zval) ;
int32 vdcSetCoordScalar(VDC aVD, int16 aFieldCount,  double* values) ; 

/* Get a value from veedata container */
int32 vdcGetLongScalarValue(VDC aVD, int32 *aLong);
int32 vdcGetDoubleScalarValue(VDC aVD, double *aReal);
char* vdcGetStringScalarValue(VDC aVD);
int32 vdcGetComplexScalarValue(VDC aVD, veeComplex *aComplex);
int32 vdcGetPComplexScalarValue(VDC aVD, veePComplex *aPComplex);
int32 vdcGet2DCoordScalarValue(VDC aVD, vee2DCoord *aCoord);
int32 vdcGet3DCoordScalarValue(VDC aVD, vee3DCoord *aCoord);
double* vdcGetCoordScalarValue(VDC aVD, int16 *aFieldCount);
void* vdcGetValue(VDC aVD);

/*
** Return type of container.  
** Generic arrays return basetype.  Waveforms and Spectrums do not.
*/
veeType vdcType(VDC aVD);
veeShape vdcShape(VDC aVD);
 
/* array vdcCreates */
VDC vdcCreateLong1DArray(int32 numpts, int32 *values); 
VDC vdcCreateString1DArray(int32 num_strings, char **strings); 
VDC vdcCreateDouble1DArray(int32 numpts, double *values);
VDC vdcCreateComplex1DArray(int32 numpts, veeComplex *values); 
VDC vdcCreatePComplex1DArray(int32 numpts, veePComplex *values);
VDC vdcCreate2DCoord1DArray(int32 numpts, vee2DCoord *values);
VDC vdcCreate3DCoord1DArray(int32 numpts, vee3DCoord *values);
VDC vdcCreateCoord1DArray(int32 numpts, int16 aFieldCount, double *values);
VDC vdcCreateWaveform(int32 numpts, double from, double thru, VMT mapType, double *data);
VDC vdcCreateSpectrum(int32 numpts, double from, double thru, VMT mapType, veePComplex *data);

/* array vdc Get Values */
int32* vdcGetLong1DArray(VDC aVD, int32 *numpts);
double* vdcGetDouble1DArray(VDC aVD, int32 *numpts);
char** vdcGetString1DArray(VDC aVD, int32 *num_strings);
veeComplex* vdcGetComplex1DArray(VDC aVD, int32 *numpts);
veePComplex* vdcGetPComplex1DArray(VDC aVD, int32 *numpts);
vee2DCoord* vdcGet2DCoord1DArray(VDC aVD, int32 *numpts);
vee3DCoord* vdcGet3DCoord1DArray(VDC aVD, int32 *numpts);
double* vdcGetCoord1DArray(VDC aVD, int32 *numpts, int16 *aFieldCount);
double* vdcGetWaveform(VDC aVD,int32 *numpts,double *from,double *thru, VMT *maptype);
veePComplex* vdcGetSpectrum(VDC aVD,int32 *numpts,double *from,double *thru,VMT *maptype);


/* Enum support (creation, destruction and query) */
int32 vdcGetEnumOrdinal(VDC aVD);
char* vdcGetEnumString(VDC aVD);
int32 vdcSetEnumScalar(VDC aVD, int32 anOrdinal) ;
VDC vdcCreateEnumScalar(int16 numberOfPairs);
int32 vdcEnumAddEnumPair(VDC aVD, char* aString, int32 aValue) ;
int32 vdcEnumDeleteEnumPairWithStr(VDC aVD, char* aString) ;
int32 vdcEnumDeleteEnumPairWithOrdinal(VDC aVD, int32 anOrd) ;
	 
/* For coord type, change number of coord dimensions. */
int16 vdcNumCoordDims(VDC aVD) ;
int32 vdcCoordSetNumCoordDims(VDC, int16);

/* Change number of dimensions and size of dimensions of a VDC */
int32 vdcSetNumDims(VDC, int16);  /* between 0 and 10 */
int16 vdcGetNumDims(VDC); /* returns value between 0 and 10 */
int32 vdcSetDimSizes(VDC, int32*); 
int32* vdcGetDimSizes(VDC); 
int32 vdcCurNumElements(VDC); /* return number of elements in the VDC */

/* mappings information */
int32 vdcAtDimPutLowerLimit(VDC aVD, int16 aDim, double aValue);
int32 vdcAtDimPutMapping(VDC aVD, int16 aDim, VMT aMapping);
int32 vdcAtDimPutRange(VDC aVD, int16 aDim, double lowerLimit, double upperLimit);
int32 vdcAtDimPutUpperLimit(VDC aVD, int16 aDim, double aValue);
int32 vdcMakeMappingsSame(VDC VD1, VDC VD2);
int32 vdcUnMap(VDC aVD);

#else

VDC  vdcCopy();
VDC  vdcFree();
void vdcPrint();
void *veeFree();
void *veeMalloc();
void *veeRealloc();
int16 veeGetErrorNumber();
char*  veeGetErrorString();
VDC vdcCreateLongScalar();
VDC vdcCreateDoubleScalar();
VDC vdcCreateStringScalar();
VDC vdcCreateComplexScalar();
VDC vdcCreatePComplexScalar();
VDC vdcCreate2DCoordScalar();
VDC vdcCreate3DCoordScalar();
VDC vdcCreateCoordScalar();
int32 vdcSetLongScalar();
int32 vdcSetDoubleScalar();
int32 vdcSetStringScalar();
int32 vdcSetComplexScalar();
int32 vdcSetPComplexScalar();
int32 vdcSet2DCoordScalar();
int32 vdcSet3DCoordScalar();
int32 vdcSetCoordScalar(); 
int32 vdcGetLongScalarValue();
int32 vdcGetDoubleScalarValue();
char* vdcGetStringScalarValue();
int32 vdcGetComplexScalarValue();
int32 vdcGetPComplexScalarValue();
int32 vdcGet2DCoordScalarValue();
int32 vdcGet3DCoordScalarValue();
double* vdcGetCoordScalarValue();
void* vdcGetValue();
enum _veeType vdcType();
enum _veeShape vdcShape();
VDC vdcCreateLong1DArray(); 
VDC vdcCreateString1DArray(); 
VDC vdcCreateDouble1DArray();
VDC vdcCreateComplex1DArray(); 
VDC vdcCreatePComplex1DArray();
VDC vdcCreate2DCoord1DArray();
VDC vdcCreate3DCoord1DArray();
VDC vdcCreateCoord1DArray();
VDC vdcCreateWaveform();
VDC vdcCreateSpectrum();
int32* vdcGetLong1DArray();
double* vdcGetDouble1DArray();
char** vdcGetString1DArray();
veeComplex* vdcGetComplex1DArray();
veePComplex* vdcGetPComplex1DArray();
vee2DCoord* vdcGet2DCoord1DArray();
vee3DCoord* vdcGet3DCoord1DArray();
double* vdcGetCoord1DArray();
double* vdcGetWaveform();
veePComplex* vdcGetSpectrum();
int32 vdcGetEnumOrdinal();
char* vdcGetEnumString();
int32 vdcSetEnumScalar();
VDC vdcCreateEnumScalar();
int32 vdcEnumAddEnumPair();
int32 vdcEnumDeleteEnumPairWithStr();
int32 vdcEnumDeleteEnumPairWithOrdinal();
int16 vdcNumCoordDims();
int32 vdcCoordSetNumCoordDims();
int32 vdcSetNumDims();
int16 vdcGetNumDims(); 
int32 vdcSetDimSizes(); 
int32* vdcGetDimSizes(); 
int32 vdcCurNumElements(); 
int32 vdcAtDimPutLowerLimit();
int32 vdcAtDimPutMapping();
int32 vdcAtDimPutRange();
int32 vdcAtDimPutUpperLimit();
int32 vdcMakeMappingsSame();
int32 vdcUnMap();

#endif /* __STDC__ et. all*/

#if defined(__cplusplus)
   };
#endif
#endif
