/****************************************************************************
	echo.c

	Purpose: An example that shows a 'C' program that communicates with
	         an HP VEE - Execute Program object.  Used in the escape2.ex 
	         example.

	Compile this C program with the command: "cc -o echo.exe echo.c"
*****************************************************************************/
#include <stdio.h>

void main(void)
{
	/* Use an int so EOF can fit (EOF = -1, 32-bit Integer)     */
    /* type char is 8-bit unsigned                              */
	int c;                     
	
	/* Set stdout to be unbuffered.  Communication back to parent
	** Process only works if buffering is off.
	*/
	setbuf( stdout, NULL);        

	while(( c = getchar()) != EOF)   /* receive character from  */
	{                                /* stdin. Exit if EOF is   */
		putchar(c);                  /* received. Putchar()     */
	}                                /* sends back character.   */
}

