/*
 * $Description: veeData API function definitions $
 *
 * $Revision: 1.39 $
 *
 * $Date: 96/02/20 10:26:43 $
 *
 * $Copyright: 1996 Hewlett-Packard Company.  All rights reserved. $
 * 
 * Supported on HP-UX 9.x, 10.x, Solaris, Win95, WinNT only.
 * Released with VEE version 3.2
 * 
 * 
*/
#ifndef VEE_INTERNAL
typedef short int16;
typedef long  int32;
typedef struct {double rval, ival;} veeComplex;
typedef struct {double mag, phase;} veePComplex;
typedef struct {double xval, yval;} vee2DCoord;
typedef struct {double xval, yval, zval;} vee3DCoord;
typedef void veeDataContainer;
typedef veeDataContainer* VDC;

enum veeMapType {
	VEE_MAPPING_NONE,
	VEE_MAPPING_LINEAR,
	VEE_MAPPING_LOG
	};
typedef enum veeMapType VMT;

enum veeType {
	VEE_NOT_DEFINED1 = 1,		/* leave space */
	VEE_LONG ,
	VEE_NOT_DEFINED2,           /* leave space */
	VEE_DOUBLE,
	VEE_COMPLEX,
	VEE_PCOMPLEX,
	VEE_STRING,
	VEE_NIL,
	VEE_NOT_DEFINED3,			/* leave space */
	VEE_COORD, 
	VEE_ENUM,
	VEE_RECORD,
	VEE_NOT_DEFINED4,			/* leave space */
	VEE_WAVEFORM,
	VEE_SPECTRUM
	};

enum _veeShape {
	VEE_SHAPE_SCALAR,			/* implies numDims = 0 */
	VEE_SHAPE_ARRAY1D,			/* implies numDims = 1 */
	VEE_SHAPE_ARRAY2D,			/* implies numDims = 2 */
	VEE_SHAPE_ARRAY3D,			/* implies numDims = 3 */
	VEE_SHAPE_ARRAY,			/* implies numDims >= 1 */
	VEE_SHAPE_ANY				/* numDims unspecified */ 
	};

typedef enum _veeShape veeShape;

#endif

/* See if C++ or not */
#if defined(__cplusplus)
   extern "C" {
#endif
	   
#ifndef VEEAPI
#   if defined(WIN32) || defined(_WIN32) || defined(__WIN32__)
#       define VEEAPI __cdecl
#   else
#       define VEEAPI
#   endif
#endif

#if defined(__STDC__) || defined(__cplusplus) 

/* veeDataContainer utility routines */
VDC VEEAPI  vdcCopy(VDC oldVD);
VDC VEEAPI  vdcFree(VDC aVD);
void VEEAPI vdcPrint(VDC aVD);

/* Error msg and number support */
int16 VEEAPI veeGetErrorNumber(void);
char*  VEEAPI  veeGetErrorString(void);

/* create scalar veedata container */
VDC VEEAPI vdcCreateLongScalar(int32 aLong);
VDC VEEAPI vdcCreateDoubleScalar(double aReal);
VDC VEEAPI vdcCreateStringScalar(char *aString);
VDC VEEAPI vdcCreateComplexScalar(double realPart, double imaginaryPart);
VDC VEEAPI vdcCreatePComplexScalar(double magnitude, double phase);
VDC VEEAPI vdcCreate2DCoordScalar(double xval, double yval);
VDC VEEAPI vdcCreate3DCoordScalar(double xval, double yval, double zval);
VDC VEEAPI vdcCreateCoordScalar(int16 fieldCount, double *values);

/* set value of scalar veedata container */
int32 VEEAPI vdcSetLongScalar(VDC aVD, int32 aLong) ;
int32 VEEAPI vdcSetDoubleScalar(VDC aVD, double aReal) ;
int32 VEEAPI vdcSetStringScalar(VDC aVD, char *aStr) ;
int32 VEEAPI vdcSetComplexScalar(VDC aVD, double realPart, double imaginaryPart) ;
int32 VEEAPI vdcSetPComplexScalar(VDC aVD, double magnitude, double phase) ;
int32 VEEAPI vdcSet2DCoordScalar(VDC aVD, double xval, double yval) ;
int32 VEEAPI vdcSet3DCoordScalar(VDC aVD, double xval, double yval, double zval) ;
int32 VEEAPI vdcSetCoordScalar(VDC aVD, int16 aFieldCount,  double* values) ; 

/* Get a value from veedata container */
int32 VEEAPI vdcGetLongScalarValue(VDC aVD, int32 *aLong);
int32 VEEAPI vdcGetDoubleScalarValue(VDC aVD, double *aReal);
char* VEEAPI vdcGetStringScalarValue(VDC aVD);
int32 VEEAPI vdcGetComplexScalarValue(VDC aVD, veeComplex *aComplex);
int32 VEEAPI vdcGetPComplexScalarValue(VDC aVD, veePComplex *aPComplex);
int32 VEEAPI vdcGet2DCoordScalarValue(VDC aVD, vee2DCoord *aCoord);
int32 VEEAPI vdcGet3DCoordScalarValue(VDC aVD, vee3DCoord *aCoord);
double* VEEAPI vdcGetCoordScalarValue(VDC aVD, int16 *aFieldCount);
void* VEEAPI vdcGetValue(VDC aVD);

/*
** Return type of container.  
**	Generic arrays return basetype.  Waveforms and Spectrums do not.
*/
enum veeType VEEAPI vdcType(VDC aVD);
 
/* array vdcCreates */
VDC VEEAPI vdcCreateLong1DArray(int32 numpts, int32 *values); 
VDC VEEAPI vdcCreateString1DArray(int32 numpts, char **strings); 
VDC VEEAPI vdcCreateDouble1DArray(int32 numpts, double *values);
VDC VEEAPI vdcCreateComplex1DArray(int32 numpts, veeComplex *values); 
VDC VEEAPI vdcCreatePComplex1DArray(int32 numpts, veePComplex *values);
VDC VEEAPI vdcCreate2DCoord1DArray(int32 numpts, vee2DCoord *values);
VDC VEEAPI vdcCreate3DCoord1DArray(int32 numpts, vee3DCoord *values);
VDC VEEAPI vdcCreateCoord1DArray(int32 numpts, int16 aFieldCount, double *values);
VDC VEEAPI vdcCreateWaveform(int32 numpts, double from, double thru, VMT mapType, double *data);
VDC VEEAPI vdcCreateSpectrum(int32 numpts, double from, double thru, VMT mapType, veePComplex *data);

/* array vdc Get Values */
int32* VEEAPI vdcGetLong1DArray(VDC aVD, int32 *numpts);
double* VEEAPI vdcGetDouble1DArray(VDC aVD, int32 *numpts);
char** VEEAPI vdcGetString1DArray(VDC aVD, int32 *numpts);
veeComplex* VEEAPI vdcGetComplex1DArray(VDC aVD, int32 *numpts);
veePComplex* VEEAPI vdcGetPComplex1DArray(VDC aVD, int32 *numpts);
vee2DCoord* VEEAPI vdcGet2DCoord1DArray(VDC aVD, int32 *numpts);
vee3DCoord* VEEAPI vdcGet3DCoord1DArray(VDC aVD, int32 *numpts);
double* VEEAPI vdcGetCoord1DArray(VDC aVD, int32 *numpts, int16 *aFieldCount);
double* VEEAPI vdcGetWaveform(VDC aVD,int32 *numpts,double *from,double *thru, VMT *maptype);
veePComplex* VEEAPI vdcGetSpectrum(VDC aVD,int32 *numpts,double *from,double *thru,VMT *maptype);


/* Enum support (creation, destruction and query) */
int32 VEEAPI vdcGetEnumOrdinal(VDC aVD);
char* VEEAPI vdcGetEnumString(VDC aVD);
int32 VEEAPI vdcSetEnumScalar(VDC aVD, int32 anOrdinal) ;
VDC VEEAPI vdcCreateEnumScalar(int16 numberOfPairs);
int32 VEEAPI vdcEnumAddEnumPair(VDC aVD, char* aString, int32 aValue) ;
int32 VEEAPI vdcEnumDeleteEnumPairWithStr(VDC aVD, char* aString) ;
int32 VEEAPI vdcEnumDeleteEnumPairWithOrdinal(VDC aVD, int32 anOrd) ;
	 
/* For coord type, change number of coord dimensions. */
int16 VEEAPI vdcNumCoordDims(VDC aVD) ;
int32 VEEAPI vdcCoordSetNumCoordDims(VDC, int16);

/* Change number of dimensions and size of dimensions of a VDC */
int32 VEEAPI vdcSetNumDims(VDC, int16);  /* between 0 and 10 */
int16 VEEAPI vdcGetNumDims(VDC); /* returns value between 0 and 10 */
int32 VEEAPI vdcSetDimSizes(VDC, int32*); 
int32* VEEAPI vdcGetDimSizes(VDC); 
int32 VEEAPI vdcCurNumElements(VDC); /* return number of elements in the VDC */

/* mappings information */
int32 VEEAPI vdcAtDimPutLowerLimit(VDC aVD, int16 aDim, double aValue);
int32 VEEAPI vdcAtDimPutMapping(VDC aVD, int16 aDim, VMT aMapping);
int32 VEEAPI vdcAtDimPutRange(VDC aVD, int16 aDim, double lowerLimit, double upperLimit);
int32 VEEAPI vdcAtDimPutUpperLimit(VDC aVD, int16 aDim, double aValue);
int32 VEEAPI vdcMakeMappingsSame(VDC VD1, VDC VD2);
int32 VEEAPI vdcUnMap(VDC aVD);

#else

VDC VEEAPI  vdcCopy();
VDC VEEAPI  vdcFree();
void VEEAPI vdcPrint();
int16 VEEAPI veeGetErrorNumber();
char* VEEAPI  veeGetErrorString();
VDC VEEAPI vdcCreateLongScalar();
VDC VEEAPI vdcCreateDoubleScalar();
VDC VEEAPI vdcCreateStringScalar();
VDC VEEAPI vdcCreateComplexScalar();
VDC VEEAPI vdcCreatePComplexScalar();
VDC VEEAPI vdcCreate2DCoordScalar();
VDC VEEAPI vdcCreate3DCoordScalar();
VDC VEEAPI vdcCreateCoordScalar();
int32 VEEAPI vdcSetLongScalar();
int32 VEEAPI vdcSetDoubleScalar();
int32 VEEAPI vdcSetStringScalar();
int32 VEEAPI vdcSetComplexScalar();
int32 VEEAPI vdcSetPComplexScalar();
int32 VEEAPI vdcSet2DCoordScalar();
int32 VEEAPI vdcSet3DCoordScalar();
int32 VEEAPI vdcSetCoordScalar(); 
int32 VEEAPI vdcGetLongScalarValue();
int32 VEEAPI vdcGetDoubleScalarValue();
char* VEEAPI vdcGetStringScalarValue();
int32 VEEAPI vdcGetComplexScalarValue();
int32 VEEAPI vdcGetPComplexScalarValue();
int32 VEEAPI vdcGet2DCoordScalarValue();
int32 VEEAPI vdcGet3DCoordScalarValue();
double* VEEAPI vdcGetCoordScalarValue();
void* VEEAPI vdcGetValue();
enum veeType VEEAPI vdcType();
VDC VEEAPI vdcCreateLong1DArray(); 
VDC VEEAPI vdcCreateString1DArray(); 
VDC VEEAPI vdcCreateDouble1DArray();
VDC VEEAPI vdcCreateComplex1DArray(); 
VDC VEEAPI vdcCreatePComplex1DArray();
VDC VEEAPI vdcCreate2DCoord1DArray();
VDC VEEAPI vdcCreate3DCoord1DArray();
VDC VEEAPI vdcCreateCoord1DArray();
VDC VEEAPI vdcCreateWaveform();
VDC VEEAPI vdcCreateSpectrum();
int32* VEEAPI vdcGetLong1DArray();
double* VEEAPI vdcGetDouble1DArray();
char** VEEAPI vdcGetString1DArray();
veeComplex* VEEAPI vdcGetComplex1DArray();
veePComplex* VEEAPI vdcGetPComplex1DArray();
vee2DCoord* VEEAPI vdcGet2DCoord1DArray();
vee3DCoord* VEEAPI vdcGet3DCoord1DArray();
double* VEEAPI vdcGetCoord1DArray();
double* VEEAPI vdcGetWaveform();
veePComplex* VEEAPI vdcGetSpectrum();
int32 VEEAPI vdcGetEnumOrdinal();
char* VEEAPI vdcGetEnumString();
int32 VEEAPI vdcSetEnumScalar();
VDC VEEAPI vdcCreateEnumScalar();
int32 VEEAPI vdcEnumAddEnumPair();
int32 VEEAPI vdcEnumDeleteEnumPairWithStr();
int32 VEEAPI vdcEnumDeleteEnumPairWithOrdinal();
int16 VEEAPI vdcNumCoordDims();
int32 VEEAPI vdcCoordSetNumCoordDims();
int32 VEEAPI vdcSetNumDims();
int16 VEEAPI vdcGetNumDims(); 
int32 VEEAPI vdcSetDimSizes(); 
int32* VEEAPI vdcGetDimSizes(); 
int32 VEEAPI vdcCurNumElements(); 
int32 VEEAPI vdcAtDimPutLowerLimit();
int32 VEEAPI vdcAtDimPutMapping();
int32 VEEAPI vdcAtDimPutRange();
int32 VEEAPI vdcAtDimPutUpperLimit();
int32 VEEAPI vdcMakeMappingsSame();
int32 VEEAPI vdcUnMap();

#endif /* __STDC__ */

#if defined(__cplusplus)
   };
#endif

