#!/bin/ksh

# If there is anything in the pipe which HP BASIC/UX puts stuff into, empty it. 
#
# "test -s" checks if the pipe is empty
while test -s /tmp/from_rmb 

# while the pipe is not empty, read lines from it
  do  read </tmp/from_rmb 
  done

# We're now fairly certain that the pipe is empty.

# See if an HP BASIC/UX process is running the program passed as the first
# parameter.  If not, start one up. 

RUN=`ps -ef | grep 'rmb[ ]*'"$1" | grep -v 'grep' | wc -l`

if [ $RUN = 0 ]
 then 
	echo "HP BASIC/UX not running"
#
# The following line uses an hpterm so that an HP BASIC/UX window will
# appear.  If the hperm is not used, no window or icon will appear.
#
	hpterm -iconic -e rmb -display $DISPLAY -iconic $* &
 else 
	echo "HP BASIC/UX running"
 fi

exit






