/*
 * $Description: veeData RPC API function definitions $
 *
 * $Revision: 1.20 $
 *
 * $Date: 96/02/20 10:26:48 $
 *
 * $Copyright: 1996 Hewlett-Packard Company.  All rights reserved. $
 * 
 * Supported on HP-UX 9.x, 10.x, Solaris, Win95, WinNT only.
 * Released with VEE version 3.2
 * 
*/

/*
** Attributes
*/
#define		VRPC_WAIT_SLEEPING 		0x01 /* default behaviour */
#define     VRPC_WAIT_SPINNING 		0x02
#define     VRPC_BUFFER_EXPAND 		0x04
#define     VRPC_NO_WAITING    		0x08
#define     VRPC_CREATE_NEW    		0x10
#define     VRPC_DEBUG_EXECUTION 	0x20
#define		VRPC_NORMAL_EXECUTION	0x40


/*
** Error codes
*/

#ifndef VEE_INTERNAL

/** Returned when a connection to the VEE server cannot be made **/
#define	eUnknownHost         	850 /* host name or IP address unresolvable */
#define	eNoServiceManager       851 /* veesm cannot be found on server host */
#define eServiceManagerTO   	861 /* service manager timed-out */
#define	eServiceNotFound        863 /* unable to find  VEE service */
#define	eServiceNotStarted      864 /* unable to start VEE service */
#define	eConnectRefused     	866 /* connection to veesm or inetd refused */
#define	eFailedSecurity     	868 /* failed security check on UNIX */

/** Fatal errors that occur after connection to a VEE server **/
/** This means the connection has been terminated **/
#define	eHostDown           	852 /* VEE server host down */    
#define	eConnectTimedOut        853 /* connection has timed out */
#define	eConnectBroken      	855 /* connection has broken */

/** Errors that reflect an internal non-fatal state within the service **/
#define eSomeInternalError      865 /* An inon-fatal internal error */
#define	eVeeServiceError    	869 /* error within the user function */
#define eWouldBlock             870 /* returned for non-blocking rpc */
#define	eDebugTermination   	871 /* user pressed stop during debug session */

/** Error returned by a RPC Function call */
#define eInvalidArgument    	630

#endif


typedef void* VRPC_SERVICE;
typedef void* VRPC_LIBRARY;
typedef void* VRPC_FUNCTION;

/*
** Following types need veeData.h
*/
typedef struct VRPC_FUNC_INFO {
	char *functionName;

	long 			numArguments;
	enum veeType 	*argumentTypes;
	veeShape 		*argumentShapes;

	long 			numResults;
	enum veeType 	*resultTypes;
	veeShape 		*resultShapes;
};

#ifndef VEEAPI
#	if defined(WIN32) || defined(_WIN32) || defined(__WIN32__)
#   	define VEEAPI __cdecl
#	else
#   	define VEEAPI
#	endif
#endif


/* See if C++ or not */
#if defined(__cplusplus)
   extern "C" {
#endif

#if defined(__STDC__) || defined(__cplusplus)

/*
** Service routines.
*/
VRPC_SERVICE VEEAPI vrpcCreateService(char *, char *, char *, double, unsigned long);
VRPC_SERVICE VEEAPI vrpcDeleteService(VRPC_SERVICE);

/*
** Library routines.
*/
VRPC_LIBRARY VEEAPI vrpcLoadLibrary(VRPC_SERVICE, char *);
VRPC_LIBRARY VEEAPI vrpcUnLoadLibrary(VRPC_LIBRARY);
void VEEAPI vrpcSetExecutionMode(VRPC_LIBRARY, unsigned long);

/*
** Function routines
*/
VRPC_FUNCTION VEEAPI vrpcFindFunction(VRPC_LIBRARY, char *);
char** VEEAPI vrpcGetFunctionNames(VRPC_LIBRARY, long *);
struct VRPC_FUNC_INFO* VEEAPI vrpcFunctionInfo(VRPC_FUNCTION);
struct VRPC_FUNC_INFO* VEEAPI vrpcFreeFunctionInfo(struct VRPC_FUNC_INFO*);


/*
** Utility routines
*/
long VEEAPI vrpcSetTimeout(VRPC_SERVICE, double);
long VEEAPI vrpcSetBehavior(VRPC_SERVICE, unsigned long);
long VEEAPI vrpcGetServerVersion(VRPC_SERVICE);

/*
** Call and Receive
*/
VDC* VEEAPI vrpcCallAndReceive(VRPC_FUNCTION, VDC*);
long VEEAPI vrpcCall(VRPC_FUNCTION, VDC*);
VDC* VEEAPI vrpcReceive(VRPC_FUNCTION, unsigned long);

#else

VRPC_SERVICE VEEAPI vrpcCreateService();
VRPC_SERVICE VEEAPI vrpcDeleteService();

VRPC_LIBRARY VEEAPI vrpcLoadLibrary();
VRPC_LIBRARY VEEAPI vrpcUnLoadLibrary();
void VEEAPI vrpcSetExecutionMode();

VRPC_FUNCTION VEEAPI vrpcFindFunction();
char** VEEAPI vrpcGetFunctionNames();
struct VRPC_FUNC_INFO* VEEAPI vrpcFunctionInfo();
struct VRPC_FUNC_INFO* VEEAPI vrpcFreeFunctionInfo();

long VEEAPI vrpcSetTimeout();
long VEEAPI vrpcSetBehavior();
long VEEAPI vrpcGetServerVersion();

VDC* VEEAPI vrpcCallAndReceive();
long VEEAPI vrpcCall();
VDC* VEEAPI vrpcReceive();

#endif /* __STDC__ */

#if defined(__cplusplus)
   };
#endif
