10! RE-SAVE "function.bas"
20    ! Example program to illustrate how an HP BASIC/UX program can
30    ! be used to apply a function to data supplied by HP VEE Test and
40    ! return the processed data back.
50    !
60    ! Establish a path to the named pipe normal used by HP VEE Test
70    ! to send data to an HP BASIC/UX process.
80    ASSIGN @In TO "/tmp/to_rmb"
90    ! Establish a path to the named pipe normal used by HP VEE Test
100   ! to receive data from an HP BASIC/UX process.
110   ASSIGN @Out TO "/tmp/from_rmb"
120   !
130   ! Dimension arrays to hold the data coming in and out.
140   DIM In_array(99),Out_array(99)
150   !
160   ! Enter an array from the pipe.
170   ENTER @In;In_array(*)
180   !
190   CALL Data_changer(In_array(*),Out_array(*))
200   !
210   ! Send the results back through another pipe.
220   OUTPUT @Out;Out_array(*)
230   !
240   ! Go back and wait for more data.
250   GOTO 170
260   ! The program has purposely been put in an infinite loop.
270   ! We do not want the program to stop as that would cause the
280   ! HP VEE Test to hang.  We don't want to QUIT because of the
290   ! overhead involved with re-starting HP BASIC/UX each time the
300   ! HP VEE Test model is run.
310   END
320   !
330   ! The following subroutine could do anything.  It could be a
340   ! program written long ago that works well.  It could be a CSUB.
350   ! It could be supplied by a 3rd party.  This example performs a
360   ! simple math operation on every element of the array.  The result
370   ! of subroutine could larger or smaller data structures as long
380   ! as the receiving HP VEE Test model is configured for the proper
390   ! amount.
400   SUB Data_changer(Original(*),Processed(*))
410     FOR I=0 TO 99
420       Processed(I)=Original(I)^2
430     NEXT I
440   SUBEND
