/*
  C code for manual49 example.
  This file is use to create a Shared Library.

  Use the following commands to make a shared library on HP-UX machines.
  cc -Aa +z -c manual49.c
  ld -b -o manual49.sl manual49.o

  Use the following commands to make a shared library on SunOS machines.
  cc -pic -c manual49.c
  ld -assert pure-text -o manual49.so manual49.o

  Use the following commands to make a dynamic link library on Windows machines.
  (This assumes MSC 6.0).
	cl -c -EM -ALw -Gsw -Zpi -W3 manual49.c
	link /NOE /NOD manual49 libentry /align:16,manual49.dll,,libw ldllcew,manual49.def
	rc manual49.dll

*/
#include <stdlib.h>

/* The dummy routine is added to get around a bug in the Sun C compiler.
 *  Sun's C compiler does not correctly handle passing in a pointer to a 
 *  double and modifying it if you make the routine into a shared library.  
 *  If you call another routine, it seems to work.  If you do not call 
 *  dummy(), the routine would segmentation fault.
 *  You may remove dummy() and its call on HP-UX machines - they work fine.
*/

double dummy()
{
	return 0.0;
}

long myFunc(arraySize, array)
	 long arraySize;
	 double *array;
{
	long i;

	dummy();			/* kludge to get around SUN bug */
	for(i=0; i<arraySize; i++, array++){
		*array += 1.0;
	} /* for */

	return(arraySize);
} /* end myFunc() */

#ifdef MSDOS

#include <windows.h>

int FAR PASCAL LibMain( HANDLE  hModule, WORD    wDataSeg,
			WORD    cbHeapSize, LPSTR   lpszCmdLine)
{
	// instance = hModule;
	return 1;
}

int FAR PASCAL WEP (int nParm)
{
    return 1;
}

#endif
