/****************************************************************************
	manual33.c

	Purpose: An example that shows a 'C' program that communicates with
		 an HP VEE - Execute Program object.  Used in the manual33.ex 
                 example.

    Compile this C program with the command: "cc -o manual33.exe manual33.c"

	There are two ways to make sure you are communicating with your parent 
	process (HP VEE).  The first is to turn off buffering for the stdout 
	file descriptor.  The second is to put "fflush" whenever you want to 
	force output back to the parent process.
*****************************************************************************/
#include <stdio.h>
main ()
{
	int c;
	double val;
	setbuf(stdout,NULL);  /* turn stdout buffering off */

	while (((c=scanf("%lf",&val)) != EOF) && c > 0) { /* read a value */
		fprintf(stdout,"%g\n",val+1);  /* add one to the input value */
		fflush(stdout);  /* force output back to main pgm */
	}
	exit(0);
}
