#! /usr/lib/veetest/veetest -r
(revision "A.00.01")
(date "Wed 01/Jan/1992")
(component 0 "Context"
 (name "Comparative Bar Chart")
 (interface
 )
 (implementation
  (trigMode deg)
  (locked no)
  (component 0 "Context"
   (name "Generate Data")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Result")
     (lock constraints)
     (optional yes)
    )
    (output 2
     (type data)
     (name "X")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "Context"
     (name "100 random #s")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Array")
       (lock constraints)
       (optional yes)
      )
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Collector"
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "Data")
         (tag "Data")
        )
        (input 2
         (type trigger)
         (name "XEQ")
         (lock name constraints)
        )
        (output 1
         (type data)
         (name "Array")
         (tag "Array")
         (lock constraints)
        )
       )
       (implementation
        (component clearAtPrerun 1)
        (component clearAtActivate 1)
       )
       (views
        (icon
         (origin 280 248)
         (extent 110 25)
        )
        (detail
         (origin 265 455)
         (extent 60 110)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "RandomNumber"
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Rand Val")
         (lock name constraints)
        )
       )
       (implementation
        (component lowerLimit 0)
        (component upperLimit 1)
       )
       (views
        (icon
         (origin 107 258)
         (extent 127 25)
        )
        (detail
         (origin 109 410)
         (extent 222 60)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 2 "ForCount"
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Count")
         (lock name constraints)
        )
       )
       (implementation
        (component count 100)
       )
       (views
        (icon
         (origin 90 168)
         (extent 110 64)
         (iconImage "loop.icon")
        )
        (detail
         (origin 60 183)
         (extent 170 34)
        )
        (active detail)
       )
      )
      (configuration
       (connect D1:1 D0:1)
       (connect D2:0 D0:2)
       (connect D2:1 D1:0)
       (connect D0:1 O1:1)
      )
     )
     (views
      (icon
       (origin 25 285)
       (extent 127 25)
      )
      (detail
       (origin 31 130)
       (extent 388 200)
       (configuration
        (connect D1:1 D0:1
         (Point 236 270)
         (Point 250 270)
         (Point 250 250)
         (Point 277 250)
        )
        (connect D2:0 D0:2
         (Point 145 219)
         (Point 145 240)
         (Point 85 240)
         (Point 85 300)
         (Point 255 300)
         (Point 255 270)
         (Point 277 270)
        )
        (connect D2:1 D1:0
         (Point 232 200)
         (Point 250 200)
         (Point 250 240)
         (Point 170 240)
         (Point 170 255)
        )
        (connect D0:1 O1:1
         (Point 392 260)
         (Point 416 240)
        )
       )
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "Context"
     (name "100 random #s")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Array")
       (lock constraints)
       (optional yes)
      )
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Collector"
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "Data")
         (tag "Data")
        )
        (input 2
         (type trigger)
         (name "XEQ")
         (lock name constraints)
        )
        (output 1
         (type data)
         (name "Array")
         (tag "Array")
         (lock constraints)
        )
       )
       (implementation
        (component clearAtPrerun 1)
        (component clearAtActivate 1)
       )
       (views
        (icon
         (origin 280 248)
         (extent 110 25)
        )
        (detail
         (origin 265 455)
         (extent 60 110)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "RandomNumber"
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Rand Val")
         (lock name constraints)
        )
       )
       (implementation
        (component lowerLimit 0)
        (component upperLimit 1)
       )
       (views
        (icon
         (origin 107 258)
         (extent 127 25)
        )
        (detail
         (origin 109 410)
         (extent 222 60)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 2 "ForCount"
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Count")
         (lock name constraints)
        )
       )
       (implementation
        (component count 100)
       )
       (views
        (icon
         (origin 90 168)
         (extent 110 64)
         (iconImage "loop.icon")
        )
        (detail
         (origin 60 183)
         (extent 170 34)
        )
        (active detail)
       )
      )
      (configuration
       (connect D1:1 D0:1)
       (connect D2:0 D0:2)
       (connect D2:1 D1:0)
       (connect D0:1 O1:1)
      )
     )
     (views
      (icon
       (origin 5 395)
       (extent 127 25)
      )
      (detail
       (origin 31 130)
       (extent 388 200)
       (configuration
        (connect D1:1 D0:1
         (Point 236 270)
         (Point 250 270)
         (Point 250 250)
         (Point 277 250)
        )
        (connect D2:0 D0:2
         (Point 145 219)
         (Point 145 240)
         (Point 85 240)
         (Point 85 300)
         (Point 255 300)
         (Point 255 270)
         (Point 277 270)
        )
        (connect D2:1 D1:0
         (Point 232 200)
         (Point 250 200)
         (Point 250 240)
         (Point 170 240)
         (Point 170 255)
        )
        (connect D0:1 O1:1
         (Point 392 260)
         (Point 416 240)
        )
       )
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "Formula"
     (name "magDist()")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "X")
       (lock name constraints)
      )
      (input 2
       (type data)
       (name "From")
       (lock name constraints)
      )
      (input 3
       (type data)
       (name "Thru")
       (lock name constraints)
      )
      (input 4
       (type data)
       (name "Step")
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked yes)
      (component expr 1 "magDist(x,from,thru,step)")
     )
     (views
      (icon
       (origin 203 355)
       (extent 110 45)
      )
      (detail
       (origin 421 305)
       (extent 259 210)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 3 "Formula"
     (name "magDist()")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "X")
       (lock name constraints)
      )
      (input 2
       (type data)
       (name "From")
       (lock name constraints)
      )
      (input 3
       (type data)
       (name "Thru")
       (lock name constraints)
      )
      (input 4
       (type data)
       (name "Step")
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked yes)
      (component expr 1 "magDist(x,from,thru,step)")
     )
     (views
      (icon
       (origin 203 455)
       (extent 110 45)
      )
      (detail
       (origin 421 305)
       (extent 259 210)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 4 "Constant"
     (name "Low Lim")
     (subType "Real")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Real")
       (lock name constraints)
      )
     )
     (implementation
      (component value Real
       (name "Low Lim")
       (datum 0)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Real
       (datum 0)
      )
     )
     (views
      (icon
       (extent 78 0)
      )
      (detail
       (origin 3 354)
       (extent 130 27)
       (showFormat real)
      )
      (active detail)
     )
    )
    (component 5 "Constant"
     (name "High Lim")
     (subType "Real")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Real")
       (lock name constraints)
      )
     )
     (implementation
      (component value Real
       (name "High Lim")
       (datum 1)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Real
       (datum 0)
      )
     )
     (views
      (icon
       (extent 110 0)
      )
      (detail
       (origin 0 463)
       (extent 137 28)
       (showFormat real)
      )
      (active detail)
     )
    )
    (component 6 "Constant"
     (name "step")
     (subType "Real")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Real")
       (lock name constraints)
      )
     )
     (implementation
      (component value Real
       (name "step")
       (datum 0.1)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Real
       (datum 0)
      )
     )
     (views
      (icon
       (origin 487 708)
       (extent 46 25)
      )
      (detail
       (origin 7 533)
       (extent 122 28)
       (showFormat real)
      )
      (active detail)
     )
    )
    (configuration
     (connect D0:1 D2:1)
     (connect D4:1 D2:2)
     (connect D5:1 D2:3)
     (connect D6:1 D2:4)
     (connect D1:1 D3:1)
     (connect D4:1 D3:2)
     (connect D5:1 D3:3)
     (connect D6:1 D3:4)
     (connect D2:1 O1:1)
     (connect D3:1 O2:1)
    )
   )
   (views
    (icon
     (origin 127 348)
     (extent 127 25)
    )
    (detail
     (origin 14 273)
     (extent 332 294)
     (configuration
      (connect D0:1 D2:1
       (Point 154 297)
       (Point 168 297)
       (Point 168 357)
       (Point 200 357)
      )
      (connect D4:1 D2:2
       (Point 135 367)
       (Point 200 367)
      )
      (connect D5:1 D2:3
       (Point 139 477)
       (Point 168 477)
       (Point 168 377)
       (Point 200 377)
      )
      (connect D6:1 D2:4
       (Point 131 547)
       (Point 158 547)
       (Point 158 497)
       (Point 208 497)
       (Point 208 437)
       (Point 188 437)
       (Point 188 387)
       (Point 200 387)
      )
      (connect D1:1 D3:1
       (Point 134 407)
       (Point 158 407)
       (Point 158 457)
       (Point 200 457)
      )
      (connect D4:1 D3:2
       (Point 135 367)
       (Point 178 367)
       (Point 178 467)
       (Point 200 467)
      )
      (connect D5:1 D3:3
       (Point 139 477)
       (Point 200 477)
      )
      (connect D6:1 D3:4
       (Point 131 547)
       (Point 158 547)
       (Point 158 487)
       (Point 200 487)
      )
      (connect D2:1 O1:1
       (Point 315 377)
       (Point 327 377)
       (Point 327 350)
       (Point 343 350)
      )
      (connect D3:1 O2:1
       (Point 315 477)
       (Point 327 477)
       (Point 327 510)
       (Point 343 510)
      )
     )
    )
    (active detail)
   )
  )
  (component 1 "Note"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 4 5
     This example is provided as an
     illustration "as is", and Hewlett-Packard
     Company makes no warranty of any kind
     with regard to this example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 402 119)
     (extent 397 82)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 2 "TextDisplay"
   (name "Trace 1")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 78 0)
    )
    (detail
     (origin 857 150)
     (extent 147 240)
    )
    (active detail)
   )
  )
  (component 3 "TextDisplay"
   (name "Trace 2")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 78 0)
    )
    (detail
     (origin 847 460)
     (extent 147 240)
    )
    (active detail)
   )
  )
  (component 4 "Context"
   (name "Comparative Bars")
   (description 28 4
    Generates and displays a comparative bar chart
    using two 1-D arrays of input data.  The number
    of bars is equal to the number of array elements
    (arrays must be same size), and the "length" of
    each bar is set by the corresponding element data,
    which may be a positive or negative real or int32
    number.  Each corresponding input array element
    generates a pair of different-colored adjacent
    bars. 
    
    The display is autoscaled after plotting the bars
    using the maximum and minumum array data values
    and the number of bars.
    
    The display and data labels, bar color, grid type,
    etc. can be set by clicking the Right Button over
    the display area and selecting the "Traces and
    Scales" entry from the resulting menu.  The gap
    between bars can be set using the "Spacing" box
    in the Bar Chart Detail view.
    
    It may prove useful to Secure the BarChart User
    Object after customizing, since this eliminates
    the Panel/Detail buttons and some menu selections
    that are no longer needed.  Be sure to save the
    unsecured object so you can make changes at a
    later date, however. 
    
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "First")
     (requires
      (shape "Array 1D")
     )
     (optional yes)
    )
    (input 2
     (type data)
     (name "Second")
     (requires
      (shape "Array 1D")
     )
     (optional yes)
    )
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "YPlot"
     (name "XY Trace")
     (subType "XY_Trace")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Trace1")
       (lock constraints)
      )
      (input 2
       (type data)
       (name "Trace2")
       (lock constraints)
       (optional yes)
      )
      (input 3
       (type control)
       (name "Auto Scale")
       (lock name constraints)
       (optional yes)
      )
      (input 4
       (type control)
       (name "Next Curve")
       (lock name constraints)
       (optional yes)
      )
     )
     (implementation
      (component clearAtPrerun 1)
      (component clearAtActivate 0)
      (component tracePin 1)
      (component tracePin 2)
      (component graphMode rectangular)
     )
     (views
      (icon
       (iconImage "display.icon")
      )
      (detail
       (origin 500 384)
       (extent 280 253)
       (displayMode scrollGraph)
       (graphType cartesian)
       (gridType frame)
       (scale 0
        (name "Y name")
        (domainName "X name")
        (pen 9)
        (show 1)
        (range 4 18 4 linear)
       )
       (domain 0 10 4 linear)
       (trace 0 onScale 0
        (name "Trace1")
        (pen 7)
        (lineType 1)
        (pointType 6)
       )
       (trace 1 onScale 0
        (name "Trace2")
        (pen 2)
        (lineType 1)
        (pointType 6)
       )
      )
      (active detail)
     )
    )
    (component 1 "Formula"
     (name "Calculate Bar 2 coords")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (input 2
       (type data)
       (name "I")
       (optional yes)
      )
      (input 3
       (type data)
       (name "z")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "[coord(I+0.5,A[i]) coord(I+1-z/2,A[i])]")
     )
     (views
      (icon
       (origin 206 403)
       (extent 208 34)
      )
      (detail
       (origin 185 443)
       (extent 421 154)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "ForCount"
     (name "For Count")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Count")
       (tag "Count")
       (requires
        (datatype Int32)
        (shape "Scalar")
       )
       (lock constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (name "Count")
       (lock name constraints)
      )
      (buffers in
       (buffer "Count")
      )
     )
     (implementation
      (component count 10)
     )
     (views
      (icon
       (origin 325 588)
       (extent 110 64)
       (iconImage "loop.icon")
      )
      (detail
       (origin 615 253)
       (extent 170 34)
      )
      (active icon)
     )
    )
    (component 3 "FromArray"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Ary")
       (tag "Ary")
      )
      (output 1
       (type data)
       (name "SubAry")
       (tag "Result")
       (lock constraints)
      )
      (output 2
       (type data)
       (name "Type")
       (tag "Type")
       (lock constraints)
      )
      (output 3
       (type data)
       (name "NumDims")
       (tag "NumDims")
       (lock constraints)
      )
      (output 4
       (type data)
       (name "DimSizes")
       (tag "DimSizes")
       (lock constraints)
      )
      (output 5
       (type data)
       (name "TotSize")
       (tag "TotSize")
       (lock constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "Ary")
     )
     (views
      (icon
       (origin 165 568)
       (extent 110 64)
       (iconImage "unbuild.icon")
      )
      (detail
       (origin 252 110)
       (extent 147 160)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 4 "Constant"
     (name "Spacing")
     (subType "Real")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Real")
       (lock name constraints)
      )
     )
     (implementation
      (component value Real
       (name "Spacing")
       (datum 0.45)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Real
       (datum 0)
      )
     )
     (views
      (icon
       (origin 241 458)
       (extent 78 25)
      )
      (detail
       (origin 237 484)
       (extent 147 32)
       (showFormat real)
      )
      (active detail)
     )
    )
    (component 5 "Formula"
     (name "Calculate Bar 1 coords")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (input 2
       (type data)
       (name "I")
       (optional yes)
      )
      (input 3
       (type data)
       (name "z")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "[coord(I+z/2,A[i]) coord(I+0.5,A[i])]")
     )
     (views
      (icon
       (origin 206 353)
       (extent 208 34)
      )
      (detail
       (origin 154 393)
       (extent 403 154)
      )
      (terminals on)
      (active icon)
     )
    )
    (configuration
     (connect D5:1 D0:1)
     (connect D1:1 D0:2)
     (connect D2:0 D0:3)
     (connect D0:0 D0:4)
     (connect I2:1 D1:1)
     (connect D2:1 D1:2)
     (connect D4:1 D1:3)
     (connect D3:5 D2:1)
     (connect I1:1 D3:1)
     (connect I1:1 D5:1)
     (connect D2:1 D5:2)
     (connect D4:1 D5:3)
    )
   )
   (views
    (icon
     (extent 154 0)
    )
    (panel
     (origin 411 290)
     (extent 419 280)
     (widget 0 detail
      (title off)
      (origin 415 294)
      (extent 414 274)
      (displayMode annotGraph)
      (graphType cartesian)
      (gridType frame)
      (scale 0
       (name "Y name")
       (domainName "X name")
       (pen 1)
       (show 1)
       (range 4 18 4 linear)
      )
      (domain 0 10 4 linear)
      (trace 0 onScale 0
       (name "Trace1")
       (pen 5)
       (lineType 1)
       (pointType 6)
      )
      (trace 1 onScale 0
       (name "Trace2")
       (pen 2)
       (lineType 1)
       (pointType 6)
      )
     )
    )
    (detail
     (origin 111 345)
     (extent 678 330)
     (configuration
      (connect D5:1 D0:1
       (Point 416 370)
       (Point 440 370)
       (Point 440 420)
       (Point 497 420)
      )
      (connect D1:1 D0:2
       (Point 416 420)
       (Point 430 420)
       (Point 430 480)
       (Point 497 480)
      )
      (connect D2:0 D0:3
       (Point 380 654)
       (Point 380 660)
       (Point 450 660)
       (Point 450 540)
       (Point 497 540)
      )
      (connect D0:0 D0:4
       (Point 640 639)
       (Point 640 660)
       (Point 480 660)
       (Point 480 600)
       (Point 497 600)
      )
      (connect I2:1 D1:1
       (Point 113 610)
       (Point 140 610)
       (Point 140 410)
       (Point 203 410)
      )
      (connect D2:1 D1:2
       (Point 437 620)
       (Point 460 620)
       (Point 460 670)
       (Point 370 670)
       (Point 370 660)
       (Point 150 660)
       (Point 150 420)
       (Point 203 420)
      )
      (connect D4:1 D1:3
       (Point 386 500)
       (Point 410 500)
       (Point 410 540)
       (Point 190 540)
       (Point 190 430)
       (Point 203 430)
      )
      (connect D3:5 D2:1
       (Point 277 620)
       (Point 322 620)
      )
      (connect I1:1 D3:1
       (Point 113 430)
       (Point 130 430)
       (Point 130 600)
       (Point 162 600)
      )
      (connect I1:1 D5:1
       (Point 113 430)
       (Point 130 430)
       (Point 130 360)
       (Point 203 360)
      )
      (connect D2:1 D5:2
       (Point 437 620)
       (Point 460 620)
       (Point 460 670)
       (Point 370 670)
       (Point 370 660)
       (Point 150 660)
       (Point 150 420)
       (Point 170 420)
       (Point 170 370)
       (Point 203 370)
      )
      (connect D4:1 D5:3
       (Point 386 500)
       (Point 410 500)
       (Point 410 540)
       (Point 190 540)
       (Point 190 380)
       (Point 203 380)
      )
     )
    )
    (active panel)
    (active panel)
   )
  )
  (component 5 "Context"
   (name "Press For")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "IfThenElse"
     (name "!= 0")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a!=0")
     )
     (views
      (icon
       (origin 365 350)
       (extent 46 25)
      )
      (detail
       (origin 209 308)
       (extent 73 64)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "Toggle"
     (name "Info About")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Reset")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Info About")
       (values range 0 1)
       (datum 0)
      )
      (component autoTrigger on)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (datum 0)
      )
     )
     (views
      (icon
       (origin 201 343)
       (extent 114 39)
       (format button)
      )
      (detail
       (origin 320 203)
       (extent 42 54)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "Context"
     (name "Info About This Example")
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Confirm"
       (name "DONE")
       (description 7 8
        This tiny "thread" begins running when the 
        enclosing UserObject is executed.  When the user
        acknowledges the OK/DONE button, there is nothing
        left to execute, so the thread ends.  Since there
        are not other threads running, the User Object
        is completed and will exit, removing the Show on
        Execute pop-up display.
       )
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 421 482)
         (extent 58 37)
        )
        (detail
         (origin 156 253)
         (extent 79 34)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "Note"
       (name "NotePad")
       (description 2 8
        This notepad is displayed as a Show on Execute
        panel to present the information to the reader.
       )
       (interface
       )
       (implementation
        (component text 21 9
         PURPOSE:     Illustrates use of the CompBarChart library object to display two arrays
                      of data simultaneously.
         
         USER INPUT REQUIRED: Press Run to display the Bar Chart.
         
         EXPLANATION: To generate some interesting data to display, two array of 100 random numbers
                      between 0 and 1.0 are analyzed to get the magnitude Distribution in 10 "bins"
                      between 0 and 1.  The resulting arrays each have 10 elements representing the
                      number of numbers in each of the 10 bins.  The arrays are given to the 
                      CompBarChart library object to generate the display.
         
         IMPLEMENTATION: The CompBarChart library object provides additional usage information from
                      the Show Description choice in the object menu.  Setting colors, etc. is
                      described here, along with a description of the input requirements.  When
                      using the BarChart object in your models, you may want to place and size it,
                      then secure the User Object to prevent inadvertent changes.
         
                      Since CompBarChart is a User Object, you may want to examine it to see how
                      the barchart is generated.  Some advanced techniques are used to generate
                      the bar fill using the YPlot "Traces & Scales" menu to set the "Point" style
                      to fill-mode.
        )
       )
       (views
        (icon
         (origin 410 415)
         (extent 78 25)
        )
        (detail
         (origin 25 209)
         (extent 848 437)
         (editing disabled)
        )
        (active icon)
       )
      )
      (configuration
      )
      (ShowOnExecPanel
       (origin 3 41)
       (extent 849 571)
       (panel
        (origin 38 164)
        (extent 845 533)
        (widget 0 icon
         (title off)
         (origin 437 649)
         (extent 58 37)
        )
        (widget 1 detail
         (title off)
         (origin 46 175)
         (extent 832 463)
         (editing disabled)
        )
       )
      )
     )
     (views
      (icon
       (origin 352 418)
       (extent 217 25)
      )
      (detail
       (origin 17 160)
       (extent 866 520)
       (configuration
       )
      )
      (active icon)
     )
    )
    (configuration
     (connect D1:1 D0:1)
     (connect D2:0 D1:1)
     (connect D0:1 D2:0)
    )
   )
   (views
    (icon
     (origin 415 408)
     (extent 110 25)
    )
    (panel
     (origin 21 122)
     (extent 319 77)
     (widget 1 icon
      (title off)
      (origin 123 135)
      (extent 114 39)
      (format button)
     )
    )
    (detail
     (origin 4 115)
     (extent 912 591)
     (configuration
      (connect D1:1 D0:1
       (Point 317 362)
       (Point 362 362)
      )
      (connect D2:0 D1:1
       (Point 460 445)
       (Point 460 460)
       (Point 180 460)
       (Point 180 362)
       (Point 198 362)
      )
      (connect D0:1 D2:0
       (Point 413 352)
       (Point 460 352)
       (Point 460 415)
      )
     )
    )
    (active panel)
    (active panel)
   )
  )
  (configuration
   (connect D0:1 D2:1)
   (connect D0:2 D3:1)
   (connect D0:1 D4:1)
   (connect D0:2 D4:2)
  )
 )
 (views
  (panel
   (origin 0 67)
   (extent 862 547)
   (widget 1 detail
    (title on)
    (origin 430 121)
    (extent 397 82)
    (editing disabled)
   )
   (widget 2 detail
    (title on)
    (origin 29 279)
    (extent 135 279)
   )
   (widget 3 detail
    (title on)
    (origin 183 280)
    (extent 138 276)
   )
   (widget 5 panel
    (title on)
    (origin 30 123)
    (extent 319 77)
    (widget 1 icon
     (title off)
     (origin 132 136)
     (extent 114 39)
     (format button)
    )
   )
   (widget 4 panel
    (title on)
    (origin 344 280)
    (extent 481 277)
    (widget 0 detail
     (title off)
     (origin 348 284)
     (extent 473 269)
     (displayMode annotGraph)
     (graphType cartesian)
     (gridType frame)
     (scale 0
      (name "Y name")
      (domainName "X name")
      (pen 1)
      (show 1)
      (range 4 18 4 linear)
     )
     (domain 0 10 4 linear)
     (trace 0 onScale 0
      (name "Trace1")
      (pen 5)
      (lineType 1)
      (pointType 6)
     )
     (trace 1 onScale 0
      (name "Trace2")
      (pen 2)
      (lineType 1)
      (pointType 6)
     )
    )
   )
  )
  (detail
   (origin 0 67)
   (extent 935 615)
   (configuration
    (connect D0:1 D2:1
     (Point 368 350)
     (Point 390 350)
     (Point 390 230)
     (Point 840 230)
     (Point 840 270)
     (Point 854 270)
    )
    (connect D0:2 D3:1
     (Point 368 510)
     (Point 390 510)
     (Point 390 580)
     (Point 844 580)
    )
    (connect D0:1 D4:1
     (Point 368 350)
     (Point 390 350)
     (Point 390 360)
     (Point 408 360)
    )
    (connect D0:2 D4:2
     (Point 368 510)
     (Point 390 510)
     (Point 390 500)
     (Point 408 500)
    )
   )
  )
  (active panel)
  (active panel)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
