#! /usr/lib/veetest/veetest -r
(revision "B.00.00")
(date "Mon 26/Oct/1992")
(component 0 "ROOTCONTEXT"
 (name "Running a C Program")
 (interface
 )
 (implementation
  (locked no)
  (trigMode deg)
  (nextID 5)
  (component 0 "NOTE"
   (name "Info About")
   (interface
   )
   (implementation
    (component text 32 5
     Overview:
     This model illustrates how to communicate with a C program 
     using Execute Program.
     
     Details:
     To operate this model, simply move the slider titled "Number".
     
     The "Execute Program" object runs the executable "manual33.exe"
     as a child process.  Within "Execute Program", WRITE 
     transactions write data to standard input of the child process 
     and READ transactions read data from standard output of the 
     child process.  The behavior of "manual33.exe" is very simple;
     it reads a number from standard input, adds one to the number,
     and writes the result to standard output.  Thus the value
     displayed in "Result" is the value of "Number" plus one.
     
     You may wish to use the C source code saved in "manual33.c"
     as a template for your own programs.   For your convenience,
     here is a listing of "manual33.c": 
     
     #include <stdio.h>
     main ()
     {
     int c;
     double val;
     setbuf(stdout,NULL);  /* turn stdout buffering off */
     while (((c=scanf("%lf",&val)) != EOF) && c > 0) { 
          fprintf(stdout,"%g\n",val+1);  /* add one to input */
          fflush(stdout);  /* force output back to main pgm */
     }
     exit(0);
     }
    )
   )
   (views
    (icon
     (extent 112 0)
     (iconImage "notepad.icon")
    )
    (detail
     (origin 14 116)
     (extent 593 249)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 1 "SLIDER"
   (name "Number")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Real")
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Number")
     (values range 0 100)
     (datum 76.023)
    )
    (component autoTrigger on)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (name "Real")
     (datum 0)
    )
    (component detents 0.001)
   )
   (views
    (icon
     (extent 80 0)
    )
    (detail
     (origin 23 415)
     (extent 134 230)
    )
    (active detail)
   )
  )
  (component 2 "SHELLESCAPE"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "a")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Exit code")
     (lock name constraints)
    )
    (output 2
     (type data)
     (name "b")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (attr iopath pipe read "pipe"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (attr iopath pipe write "pipe"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (procedure
      WRITE TEXT a REAL STD EOL
      READ TEXT b REAL
    )
    (component shell "none")
    (component command "/usr/lib/veetest/examples/escapes/manual33.exe")
    (component deathWait "Yes")
   )
   (views
    (icon
     (origin 353 256)
     (extent 115 68)
     (iconImage "c.icon")
    )
    (detail
     (origin 220 463)
     (extent 420 134)
    )
    (terminals on)
    (active detail)
   )
  )
  (component 3 "TEXTDISPLAY"
   (name "Result")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 80 0)
    )
    (detail
     (origin 789 549)
     (extent 162 42)
    )
    (active detail)
   )
  )
  (component 4 "NOTE"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 4 5
     This example is provided as an
     illustration "as is", and Hewlett-Packard
     Company makes no warranty of any kind
     with regard to this example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 620 115)
     (extent 401 110)
     (editing disabled)
    )
    (active detail)
   )
  )
  (configuration
   (connect D1:1 D2:1)
   (connect D2:2 D3:1)
  )
 )
 (views
  (detail
   (origin 0 62)
   (extent 980 643)
   (configuration
    (connect D1:1 D2:1
     (Point 159 530)
     (Point 177 530)
    )
    (connect D2:2 D3:1
     (Point 742 570)
     (Point 786 570)
    )
   )
   (stackingOrder 1 2 3 4 0)
  )
  (active detail)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
