#! /usr/lib/veetest/veetest -r
(revision "B.00.00")
(date "Fri 20/Nov/1992")
(component 0 "ROOTCONTEXT"
 (name "Manufacturing Test Example")
 (description 4 2
  This example is to demonstrate user interaction,
  sequencing of multiple tests, and how to 
  generate and display a report.
  
 )
 (interface
 )
 (implementation
  (UserFunctions
   (nextID 8)
   (context 0
    (name "test2")
    (description 10 5
     Test 2 will check a noisy waveform against a 
     set of pre-determined coordinates.  Here we 
     use a coordinate constant.  Instead, we could
     have read the coordinate points from a file.
     
     The most powerful object in this test is the
     comparator.  Note that it was used to compare
     coordinate points to a waveform, and included 
     the ability to interpolate between points.
     
    )
    (interface
     (sequence in)
     (sequence out)
    )
    (implementation
     (locked no)
     (trigMode deg)
     (nextID 23)
     (component 0 "YPLOT"
      (name "MASK TEST")
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "Noisy Wave")
        (lock constraints)
       )
       (input 2
        (type data)
        (name "UpperLimit")
        (lock constraints)
        (optional yes)
       )
       (input 3
        (type data)
        (name "UpperFail")
        (lock constraints)
        (optional yes)
       )
      )
      (implementation
       (component clearAtPrerun 1)
       (component clearAtActivate 0)
       (component tracePin 1)
       (component tracePin 2)
       (component tracePin 3)
       (component graphMode time)
      )
      (views
       (icon
        (extent 110 0)
        (iconImage "display.icon")
       )
       (detail
        (origin 717 -3)
        (extent 346 266)
        (displayMode annotGraph)
        (graphType cartesian)
        (gridType grid)
        (scale 0
         (name "Mag")
         (domainName "Time")
         (pen 9)
         (show 1)
         (range -2 2 4 linear)
        )
        (domain 0 0.02 4 linear)
        (trace 0 onScale 0
         (name "Noisy Wave")
         (pen 4)
         (lineType 1)
         (pointType 0)
        )
        (trace 1 onScale 0
         (name "UpperLimit")
         (pen 7)
         (lineType 1)
         (pointType 0)
        )
        (trace 2 onScale 0
         (name "UpperFail")
         (pen 2)
         (lineType 2)
         (pointType 1)
        )
       )
       (active detail)
      )
     )
     (component 1 "FORMULA"
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "A")
        (optional yes)
       )
       (output 1
        (type data)
        (name "Result")
        (lock name constraints)
       )
      )
      (implementation
       (component isLocked no)
       (component expr 1 "a+1")
      )
      (views
       (icon
        (origin 491 -72)
        (extent 78 64)
        (iconImage "formula.icon")
       )
       (detail
        (origin 626 100)
        (extent 79 60)
       )
       (terminals on)
       (active icon)
      )
     )
     (component 2 "METER"
      (name "Test Number")
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "Data")
        (requires
         (datatype Real)
         (shape "Scalar")
        )
        (lock name constraints)
       )
      )
      (implementation
       (component clearAtPrerun 1)
       (component clearAtActivate 1)
       (component range 0 30)
      )
      (views
       (icon
        (origin 595 -52)
        (extent 110 25)
       )
       (detail
        (origin 579 128)
        (extent 183 124)
       )
       (active icon)
      )
     )
     (component 3 "COUNTER"
      (name "# of Failures")
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "Data")
       )
       (output 1
        (type data)
        (name "Count")
        (tag "Count")
        (lock name constraints)
       )
      )
      (implementation
       (component clearAtPrerun 0)
       (component clearAtActivate 1)
      )
      (views
       (icon
        (origin 717 298)
        (extent 127 25)
       )
       (detail
        (origin 551 539)
        (extent 129 63)
       )
       (terminals on)
       (active icon)
      )
     )
     (component 4 "FORMULA"
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "A")
        (optional yes)
       )
       (input 2
        (type data)
        (name "B")
        (optional yes)
       )
       (output 1
        (type data)
        (name "Result")
        (lock name constraints)
       )
      )
      (implementation
       (component isLocked no)
       (component expr 1 "((a/b)*100)")
      )
      (views
       (icon
        (origin 731 398)
        (extent 78 64)
        (iconImage "formula.icon")
       )
       (detail
        (origin 679 308)
        (extent 133 104)
       )
       (terminals on)
       (active icon)
      )
     )
     (component 5 "CONSTANT"
      (name "Upper Limit")
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (lock name constraints)
       )
      )
      (implementation
       (component value Coord
        (name "Upper Limit")
        (numDims 1)
        (size 6)
        (numCoordDims 2)
        (data
         [ (0,0.5) (0.0022,1.2) (0.007200000000000001,1.2) (0.0132,-0.5) (0.0162,-0.5) (0.02,0.5) ]
        )
       )
       (component autoTrigger off)
       (component initializeAtPrerun off)
       (component initializeAtActivate off)
       (component initValue Coord
        (name "Coord")
        (numCoordDims 2)
        (datum (0,0))
       )
      )
      (views
       (icon
        (origin 115 498)
        (extent 110 25)
       )
       (detail
        (origin 106 137)
        (extent 249 126)
       )
       (active detail)
      )
     )
     (component 6 "FORRANGE"
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "From")
        (tag "From")
        (requires
         (datatype Real)
         (shape "Scalar")
        )
        (lock constraints)
        (optional yes)
        (buffer YES)
       )
       (output 1
        (type data)
        (name "Data")
        (lock name constraints)
       )
      )
      (implementation
       (component from 5)
       (component thru 1)
       (component step -1)
      )
      (views
       (icon
        (origin 145 358)
        (extent 110 64)
        (iconImage "loop.icon")
       )
       (detail
        (origin 135 537)
        (extent 170 86)
       )
       (active icon)
      )
     )
     (component 7 "EXITCONTEXT"
      (interface
       (sequence in)
      )
      (implementation
      )
      (views
       (icon
        (origin 128 448)
        (extent 145 25)
       )
       (detail
       )
       (terminals on)
       (active icon)
      )
     )
     (component 8 "FORMULA"
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "A")
        (optional yes)
       )
       (output 1
        (type data)
        (name "Result")
        (lock name constraints)
       )
      )
      (implementation
       (component isLocked no)
       (component expr 1 "\"WAITING...\"+a")
      )
      (views
       (icon
        (origin 291 358)
        (extent 78 64)
        (iconImage "formula.icon")
       )
       (detail
        (origin 245 378)
        (extent 160 104)
       )
       (terminals on)
       (active icon)
      )
     )
     (component 9 "TEXTDISPLAY"
      (name "AlphaNumeric")
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "Data")
       )
      )
      (implementation
       (component clearAtPrerun 1)
       (component clearAtActivate 1)
      )
      (views
       (icon
       )
       (detail
        (origin 414 402)
        (extent 192 37)
       )
       (active detail)
      )
     )
     (component 10 "DELAY"
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "Done")
        (tag "Done")
        (lock constraints)
       )
      )
      (implementation
       (component delay 0.8)
      )
      (views
       (icon
        (origin 471 458)
        (extent 78 25)
       )
       (detail
        (origin 555 633)
        (extent 130 34)
       )
       (active icon)
      )
     )
     (component 11 "FORCOUNT"
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "Count")
        (lock name constraints)
       )
      )
      (implementation
       (component count 30)
      )
      (views
       (icon
        (iconImage "loop.icon")
       )
       (detail
        (origin 95 33)
        (extent 170 34)
       )
       (active detail)
      )
     )
     (component 12 "START"
      (interface
       (sequence out)
      )
      (implementation
      )
      (views
       (icon
        (origin 147 -58)
        (extent 67 37)
       )
       (detail
       )
       (terminals on)
       (active icon)
      )
     )
     (component 13 "RANDOMNUMBER"
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "Rand Val")
        (lock name constraints)
       )
      )
      (implementation
       (component lowerLimit 0.2)
       (component upperLimit 0.23)
      )
      (views
       (icon
        (origin 317 -22)
        (extent 127 25)
       )
       (detail
        (origin 169 250)
        (extent 222 60)
       )
       (terminals on)
       (active icon)
      )
     )
     (component 14 "VNOISEGENERATOR"
      (name "Noise Generator")
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "Amplitude")
        (tag "Amplitude")
        (requires
         (datatype Real)
         (shape "Scalar")
        )
        (lock constraints)
        (optional yes)
        (buffer YES)
       )
       (output 1
        (type data)
        (name "noise WF")
        (tag "noiseWF")
        (lock name constraints)
       )
      )
      (implementation
       (component amplitude 0.2217456929340452)
       (component numPoints 256)
       (component interval 0.02)
      )
      (views
       (icon
        (origin 425 15)
        (extent 151 31)
       )
       (detail
        (origin 375 225)
        (extent 221 90)
       )
       (terminals on)
       (active icon)
      )
     )
     (component 15 "COMPARATOR"
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "Ref Value")
        (tag "RefValue")
       )
       (input 2
        (type data)
        (name "Test Value")
        (tag "TestValue")
       )
       (output 1
        (type data)
        (name "Passed")
        (tag "Passed")
        (lock name constraints)
        (optional yes)
       )
       (output 2
        (type data)
        (name "Failed")
        (tag "Failed")
        (lock name constraints)
        (optional yes)
       )
       (output 3
        (type data)
        (name "Failures")
        (tag "Failures")
        (lock name constraints)
        (optional yes)
       )
      )
      (implementation
       (attr relation "<")
      )
      (views
       (icon
        (origin 415 193)
        (extent 110 34)
       )
       (detail
        (origin 815 125)
        (extent 251 110)
       )
       (terminals on)
       (active icon)
      )
     )
     (component 16 "COLLECTOR"
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "Data")
        (tag "Data")
       )
       (input 2
        (type trigger)
        (name "XEQ")
        (lock name constraints)
       )
       (output 1
        (type data)
        (name "Array")
        (tag "Array")
        (lock constraints)
       )
      )
      (implementation
       (component clearAtPrerun 1)
       (component clearAtActivate 1)
       (component output1D YES)
      )
      (views
       (icon
        (origin 425 268)
        (extent 110 25)
       )
       (detail
        (origin 485 335)
        (extent 60 110)
       )
       (terminals on)
       (active icon)
      )
     )
     (component 17 "TOFILE"
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "B")
        (optional yes)
       )
      )
      (implementation
       (attr iopath file append "/tmp/mfgdata"
        (readTerm "\n")
        (fs "\n")
        (eol "\n")
        (multiField fullSyntax)
        (arrayFormat block)
       )
       (procedure
         WRITE TEXT "    " QSTR EOL
         WRITE TEXT "    " QSTR EOL
         WRITE TEXT "    " QSTR EOL
         WRITE TEXT now() DATE:WDMY TIME:HMS:H12 EOL
         WRITE TEXT "    " QSTR EOL
         WRITE TEXT "FAILING COORDINATES from TEST 2" EOL
         WRITE TEXT "--------------------------------------------------------" EOL
         WRITE TEXT b COORD STD:4 EOL
       )
      )
      (views
       (icon
        (origin 561 263)
        (extent 78 34)
       )
       (detail
        (origin 485 447)
        (extent 320 167)
       )
       (terminals on)
       (active icon)
      )
     )
     (component 18 "FORMULA"
      (name " + ")
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "X")
        (lock name constraints)
       )
       (input 2
        (type data)
        (name "Y")
        (lock name constraints)
       )
       (output 1
        (type data)
        (name "Result")
        (lock name constraints)
       )
      )
      (implementation
       (component isLocked yes)
       (component expr 1 "X+Y")
      )
      (views
       (icon
        (origin 617 28)
        (extent 46 25)
       )
       (detail
       )
       (terminals on)
       (active icon)
      )
     )
     (component 19 "VFUNCTIONGENERATOR"
      (name "Function Generator")
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (lock name constraints)
       )
      )
      (implementation
       (component function Sine)
       (component frequency 50)
       (component amplitude 1)
       (component dcOffset 0)
       (component phaseShift 0)
       (component numPoints 256)
       (component interval 0.02)
       (component degRad Deg)
       (component errorOnAlias 1)
      )
      (views
       (icon
        (origin 413 61)
        (extent 174 78)
        (iconImage "virtual.icon")
       )
       (detail
        (origin 239 111)
        (extent 239 198)
       )
       (terminals on)
       (active icon)
      )
     )
     (component 20 "SAMPLEHOLD"
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "InData")
        (tag "InData")
        (lock constraints)
       )
       (input 2
        (type trigger)
        (name "XEQ")
        (lock name constraints)
       )
       (output 1
        (type data)
        (name "OutData")
        (tag "OutData")
        (lock constraints)
       )
      )
      (implementation
      )
      (views
       (icon
        (origin 877 308)
        (extent 127 25)
       )
       (detail
       )
       (terminals on)
       (active icon)
      )
     )
     (component 21 "TEXTDISPLAY"
      (name "% Failures")
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "Data")
       )
      )
      (implementation
       (component clearAtPrerun 1)
       (component clearAtActivate 1)
      )
      (views
       (icon
        (extent 110 0)
       )
       (detail
        (origin 835 412)
        (extent 190 37)
       )
       (active detail)
      )
     )
     (component 22 "FROMGLOBAL"
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "Data")
        (tag "Data")
        (lock name constraints)
       )
      )
      (implementation
       (component globalName waittime)
      )
      (views
       (icon
        (origin 75 328)
        (extent 110 25)
       )
       (detail
        (origin 102 320)
        (extent 97 61)
       )
       (terminals on)
       (active icon)
      )
     )
     (configuration
      (connect D18:1 D0:1)
      (connect D5:1 D0:2)
      (connect D15:3 D0:3)
      (connect D11:1 D1:1)
      (connect D1:1 D2:1)
      (connect D15:2 D3:1)
      (connect D20:1 D4:1)
      (connect D1:1 D4:2)
      (connect D17:0 D6:0)
      (connect D22:1 D6:1)
      (connect D6:0 D7:0)
      (connect D6:1 D8:1)
      (connect D8:1 D9:1)
      (connect D9:0 D10:0)
      (connect D12:0 D11:0)
      (connect D11:1 D13:0)
      (connect D13:1 D14:1)
      (connect D5:1 D15:1)
      (connect D18:1 D15:2)
      (connect D15:3 D16:1)
      (connect D11:0 D16:2)
      (connect D16:1 D17:1)
      (connect D14:1 D18:1)
      (connect D19:1 D18:2)
      (connect D3:1 D20:1)
      (connect D11:1 D20:2)
      (connect D4:1 D21:1)
     )
     (ShowOnExecPanel
      (origin 168 131)
      (extent 594 581)
      (panel
       (origin 485 264)
       (extent 590 553)
       (widget 0 detail
        (title off)
        (origin 502 274)
        (extent 554 305)
        (displayMode annotGraph)
        (graphType cartesian)
        (gridType off)
        (scale 0
         (name "Mag")
         (domainName "Time")
         (pen 9)
         (show 1)
         (range -2 2 4 linear)
        )
        (domain 0 0.02 4 linear)
        (trace 0 onScale 0
         (name "Noisy Wave")
         (pen 4)
         (lineType 1)
         (pointType 0)
        )
        (trace 1 onScale 0
         (name "UpperLimit")
         (pen 7)
         (lineType 1)
         (pointType 0)
        )
        (trace 2 onScale 0
         (name "UpperFail")
         (pen 2)
         (lineType 2)
         (pointType 1)
        )
       )
       (widget 2 detail
        (title on)
        (origin 503 622)
        (extent 290 140)
       )
       (widget 3 detail
        (title on)
        (origin 837 622)
        (extent 216 36)
       )
       (widget 21 detail
        (title on)
        (origin 839 714)
        (extent 216 45)
       )
       (widget 9 detail
        (title off)
        (origin 683 770)
        (extent 217 40)
       )
      )
     )
    )
    (views
     (detail
      (origin 45 89)
      (extent 834 515)
      (configuration
       (connect D18:1 D0:1
        (Point 665 40)
        (Point 714 40)
       )
       (connect D5:1 D0:2
        (Point 357 200)
        (Point 390 200)
        (Point 390 170)
        (Point 690 170)
        (Point 690 130)
        (Point 714 130)
       )
       (connect D15:3 D0:3
        (Point 527 220)
        (Point 714 220)
       )
       (connect D11:1 D1:1
        (Point 267 50)
        (Point 290 50)
        (Point 290 -40)
        (Point 488 -40)
       )
       (connect D1:1 D2:1
        (Point 571 -40)
        (Point 592 -40)
       )
       (connect D15:2 D3:1
        (Point 527 210)
        (Point 660 210)
        (Point 660 310)
        (Point 714 310)
       )
       (connect D20:1 D4:1
        (Point 1006 320)
        (Point 1020 320)
        (Point 1020 350)
        (Point 710 350)
        (Point 710 410)
        (Point 728 410)
       )
       (connect D1:1 D4:2
        (Point 571 -40)
        (Point 580 -40)
        (Point 580 -10)
        (Point 690 -10)
        (Point 690 120)
        (Point 700 120)
        (Point 700 180)
        (Point 690 180)
        (Point 690 450)
        (Point 728 450)
       )
       (connect D17:0 D6:0
        (Point 600 299)
        (Point 600 320)
        (Point 200 320)
        (Point 200 355)
       )
       (connect D22:1 D6:1
        (Point 187 340)
        (Point 210 340)
        (Point 210 310)
        (Point 60 310)
        (Point 60 390)
        (Point 142 390)
       )
       (connect D6:0 D7:0
        (Point 200 424)
        (Point 200 445)
       )
       (connect D6:1 D8:1
        (Point 257 390)
        (Point 288 390)
       )
       (connect D8:1 D9:1
        (Point 371 390)
        (Point 390 390)
        (Point 390 420)
        (Point 411 420)
       )
       (connect D9:0 D10:0
        (Point 510 441)
        (Point 510 455)
       )
       (connect D12:0 D11:0
        (Point 180 -19)
        (Point 180 2)
       )
       (connect D11:1 D13:0
        (Point 267 50)
        (Point 290 50)
        (Point 290 -40)
        (Point 380 -40)
        (Point 380 -25)
       )
       (connect D13:1 D14:1
        (Point 446 -10)
        (Point 460 -10)
        (Point 460 10)
        (Point 410 10)
        (Point 410 30)
        (Point 422 30)
       )
       (connect D5:1 D15:1
        (Point 357 200)
        (Point 412 200)
       )
       (connect D18:1 D15:2
        (Point 665 40)
        (Point 680 40)
        (Point 680 160)
        (Point 400 160)
        (Point 400 220)
        (Point 412 220)
       )
       (connect D15:3 D16:1
        (Point 527 220)
        (Point 540 220)
        (Point 540 250)
        (Point 410 250)
        (Point 410 270)
        (Point 422 270)
       )
       (connect D11:0 D16:2
        (Point 180 69)
        (Point 180 80)
        (Point 380 80)
        (Point 380 290)
        (Point 422 290)
       )
       (connect D16:1 D17:1
        (Point 537 280)
        (Point 558 280)
       )
       (connect D14:1 D18:1
        (Point 578 30)
        (Point 614 30)
       )
       (connect D19:1 D18:2
        (Point 589 100)
        (Point 600 100)
        (Point 600 50)
        (Point 614 50)
       )
       (connect D3:1 D20:1
        (Point 846 310)
        (Point 874 310)
       )
       (connect D11:1 D20:2
        (Point 267 50)
        (Point 390 50)
        (Point 390 160)
        (Point 370 160)
        (Point 370 340)
        (Point 860 340)
        (Point 860 330)
        (Point 874 330)
       )
       (connect D4:1 D21:1
        (Point 811 430)
        (Point 832 430)
       )
      )
      (stackingOrder 0 1 2 3 4 5 6 7 8 9
        10 11 12 13 14 15 16 18 19 20
        21 17 22)
     )
     (terminals on)
     (active detail)
    )
   )
   (context 1
    (name "Test1")
    (description 4 5
     Test one is to show how to view data as it is
     received and then to have the option of viewing
     additional choices.
     
    )
    (interface
     (sequence in)
     (sequence out)
    )
    (implementation
     (locked no)
     (trigMode deg)
     (nextID 9)
     (component 0 "FORCOUNT"
      (name "For Count 50")
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (lock name constraints)
       )
      )
      (implementation
       (component count 50)
      )
      (views
       (icon
        (origin -249 238)
        (extent 118 64)
        (iconImage "loop.icon")
       )
       (detail
        (origin 54 213)
        (extent 192 34)
       )
       (active icon)
      )
     )
     (component 1 "RANDOMNUMBER"
      (name "Random Number")
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "Rand Val")
        (lock name constraints)
       )
      )
      (implementation
       (component lowerLimit -1)
       (component upperLimit 1)
      )
      (views
       (icon
        (origin -73 288)
        (extent 127 25)
       )
       (detail
        (origin 237 180)
        (extent 222 60)
       )
       (terminals on)
       (active icon)
      )
     )
     (component 2 "YPLOT"
      (name "Data Being Collected...")
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "Trace1")
        (lock constraints)
       )
      )
      (implementation
       (component clearAtPrerun 1)
       (component clearAtActivate 1)
       (component tracePin 1)
       (component graphMode strip)
      )
      (views
       (icon
        (extent 217 0)
        (iconImage "display.icon")
       )
       (detail
        (origin 125 226)
        (extent 291 149)
        (displayMode graphOnly)
        (graphType cartesian)
        (gridType axis)
        (scale 0
         (name "Y name")
         (domainName "X name")
         (pen 9)
         (show 1)
         (range -1 1 3 linear)
        )
        (domain 0 49.00000000000053 4 linear)
        (trace 0 onScale 0
         (name "Trace1")
         (pen 4)
         (lineType 1)
         (pointType 0)
        )
        (stepSize 1)
        (trackingEnabled 1)
       )
       (active detail)
      )
     )
     (component 3 "START"
      (interface
       (sequence out)
      )
      (implementation
      )
      (views
       (icon
        (origin -223 172)
        (extent 67 37)
       )
       (detail
       )
       (terminals on)
       (active icon)
      )
     )
     (component 4 "COLLECTOR"
      (name "Collector")
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "Data")
        (tag "Data")
       )
       (input 2
        (type trigger)
        (name "XEQ")
        (lock name constraints)
       )
       (output 1
        (type data)
        (name "Array")
        (tag "Array")
        (lock constraints)
       )
      )
      (implementation
       (component clearAtPrerun 1)
       (component clearAtActivate 1)
       (component output1D YES)
      )
      (views
       (icon
        (origin -65 358)
        (extent 110 25)
       )
       (detail
        (origin 175 448)
        (extent 33 104)
       )
       (terminals on)
       (active icon)
      )
     )
     (component 5 "FORMULA"
      (name "movingAvg(x,numPts)")
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "X")
        (lock name constraints)
       )
       (input 2
        (type data)
        (name "numPts")
        (requires
         (datatype Int32)
         (shape "Scalar")
        )
        (lock name constraints)
       )
       (output 1
        (type data)
        (name "Result")
        (lock name constraints)
       )
      )
      (implementation
       (component isLocked yes)
       (component expr 1 "movingAvg(x,numPts)")
      )
      (views
       (icon
        (origin -80 428)
        (extent 181 25)
       )
       (detail
        (origin 688 315)
        (extent 205 110)
       )
       (terminals on)
       (active icon)
      )
     )
     (component 6 "CONTEXT"
      (name "More Info ?")
      (description 3 7
       This is just to prompt for showing more 
       information.
       
      )
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "X")
        (optional yes)
       )
       (input 2
        (type data)
        (name "Average")
        (optional yes)
       )
      )
      (implementation
       (locked no)
       (trigMode deg)
       (nextID 10)
       (component 3 "NOTE"
        (name "More Information ?")
        (interface
        )
        (implementation
         (component text 1 10
          Do yh
         )
        )
        (views
         (icon
          (origin 764 218)
          (extent 172 64)
          (iconImage "notepad.icon")
         )
         (detail
          (origin 492 225)
          (extent 417 90)
          (editing enabled)
         )
         (active icon)
        )
       )
       (component 4 "CONTEXT"
        (name "Final Data")
        (description 6 9
         After choosing more info...Note that this
         object actually finds the Min Point and 
         Max Point, and then must build the line.
         
         Note also that the Standard Deviation could
         have been plotted as well.
        )
        (interface
         (sequence in)
         (sequence out)
         (input 1
          (type data)
          (name "X")
          (optional yes)
         )
         (input 2
          (type data)
          (name "Average")
          (optional yes)
         )
         (output 1
          (type exception)
          (name "Error")
          (lock name constraints)
          (optional yes)
         )
        )
        (implementation
         (locked no)
         (trigMode deg)
         (nextID 15)
         (component 0 "YPLOT"
          (name "Final Data")
          (interface
           (sequence in)
           (sequence out)
           (input 1
            (type data)
            (name "Data")
            (lock constraints)
           )
           (input 2
            (type data)
            (name "Average")
            (lock constraints)
            (optional yes)
           )
           (input 3
            (type data)
            (name "Min Pt.")
            (lock constraints)
            (optional yes)
           )
           (input 4
            (type data)
            (name "Max Pt.")
            (lock constraints)
            (optional yes)
           )
          )
          (implementation
           (component clearAtPrerun 1)
           (component clearAtActivate 0)
           (component tracePin 1)
           (component tracePin 2)
           (component tracePin 3)
           (component tracePin 4)
           (component graphMode strip)
          )
          (views
           (icon
            (origin 515 478)
            (extent 110 64)
            (iconImage "display.icon")
           )
           (detail
            (origin 612 358)
            (extent 336 304)
            (displayMode annotGraph)
            (graphType cartesian)
            (gridType frame)
            (scale 0
             (name "Y name")
             (domainName "X name")
             (pen 9)
             (show 1)
             (range -1.2 1.2 3 linear)
            )
            (domain 0 49 4 linear)
            (trace 0 onScale 0
             (name "Data")
             (pen 4)
             (lineType 1)
             (pointType 0)
            )
            (trace 1 onScale 0
             (name "Average")
             (pen 7)
             (lineType 1)
             (pointType 0)
            )
            (trace 2 onScale 0
             (name "Min Pt.")
             (pen 6)
             (lineType 1)
             (pointType 0)
            )
            (trace 3 onScale 0
             (name "Max Pt.")
             (pen 2)
             (lineType 1)
             (pointType 0)
            )
            (stepSize 1)
            (trackingEnabled 1)
           )
           (active icon)
          )
         )
         (component 1 "FORMULA"
          (name "sdev(x)")
          (interface
           (sequence in)
           (sequence out)
           (input 1
            (type data)
            (name "X")
            (lock name constraints)
           )
           (output 1
            (type data)
            (name "Result")
            (lock name constraints)
           )
          )
          (implementation
           (component isLocked yes)
           (component expr 1 "sdev(x)")
          )
          (views
           (icon
            (origin 391 688)
            (extent 78 25)
           )
           (detail
           )
           (terminals on)
           (active icon)
          )
         )
         (component 2 "ALLOCATEARRAY"
          (name "Build Max")
          (interface
           (sequence in)
           (sequence out)
           (input 1
            (type data)
            (name "Init Value")
            (tag "Init Value")
            (requires
             (datatype Real)
             (shape "Scalar")
            )
            (lock constraints)
            (optional yes)
            (buffer YES)
           )
           (output 1
            (type data)
            (name "Array")
            (tag "Array")
            (lock constraints)
           )
          )
          (implementation
           (component numDims 1)
           (component dimSizes "50")
           (component type "Real")
           (component initEnum "Init Value")
           (component initialValue
            (name "Init Value")
            (datum 0.919271124762119)
           )
           (component from 0)
           (component thru 0)
          )
          (views
           (icon
            (origin 302 595)
            (extent 96 31)
           )
           (detail
            (origin 404 543)
            (extent 220 134)
           )
           (terminals on)
           (active icon)
          )
         )
         (component 3 "ALLOCATEARRAY"
          (name "Build Min")
          (interface
           (sequence in)
           (sequence out)
           (input 1
            (type data)
            (name "Init Value")
            (tag "Init Value")
            (requires
             (datatype Real)
             (shape "Scalar")
            )
            (lock constraints)
            (optional yes)
            (buffer YES)
           )
           (output 1
            (type data)
            (name "Array")
            (tag "Array")
            (lock constraints)
           )
          )
          (implementation
           (component numDims 1)
           (component dimSizes "50")
           (component type "Real")
           (component initEnum "Init Value")
           (component initialValue
            (name "Init Value")
            (datum -0.9851434765618663)
           )
           (component from 0)
           (component thru 0)
          )
          (views
           (icon
            (origin 294 523)
            (extent 92 35)
           )
           (detail
            (origin 395 443)
            (extent 220 134)
           )
           (terminals on)
           (active icon)
          )
         )
         (component 4 "FORMULA"
          (name "min(x)")
          (interface
           (sequence in)
           (sequence out)
           (input 1
            (type data)
            (name "X")
            (lock name constraints)
           )
           (output 1
            (type data)
            (name "Result")
            (lock name constraints)
           )
          )
          (implementation
           (component isLocked yes)
           (component expr 1 "min(x)")
          )
          (views
           (icon
            (origin 181 528)
            (extent 78 25)
           )
           (detail
            (origin 301 483)
            (extent 88 54)
           )
           (terminals on)
           (active icon)
          )
         )
         (component 5 "FORMULA"
          (name "max(x)")
          (interface
           (sequence in)
           (sequence out)
           (input 1
            (type data)
            (name "X")
            (lock name constraints)
           )
           (output 1
            (type data)
            (name "Result")
            (lock name constraints)
           )
          )
          (implementation
           (component isLocked yes)
           (component expr 1 "max(x)")
          )
          (views
           (icon
            (origin 201 598)
            (extent 78 25)
           )
           (detail
           )
           (terminals on)
           (active icon)
          )
         )
         (component 6 "TEXTDISPLAY"
          (name "Std Deviation")
          (interface
           (sequence in)
           (sequence out)
           (input 1
            (type data)
            (name "Data")
           )
          )
          (implementation
           (component clearAtPrerun 1)
           (component clearAtActivate 1)
          )
          (views
           (icon
            (origin 997 668)
            (extent 127 25)
           )
           (detail
            (origin 595 683)
            (extent 201 34)
           )
           (active detail)
          )
         )
         (component 8 "ESCAPE"
          (interface
           (sequence in)
          )
          (implementation
           (component code 0)
           (component message "")
          )
          (views
           (icon
            (origin 211 438)
            (extent 78 25)
           )
           (detail
            (origin 486 289)
            (extent 149 63)
           )
           (active icon)
          )
         )
         (component 10 "TEXTDISPLAY"
          (name "AlphaNumeric")
          (interface
           (sequence in)
           (sequence out)
           (input 1
            (type data)
            (name "Data")
           )
          )
          (implementation
           (component clearAtPrerun 1)
           (component clearAtActivate 1)
          )
          (views
           (icon
           )
           (detail
            (origin 410 301)
            (extent 180 39)
           )
           (active detail)
          )
         )
         (component 11 "DELAY"
          (interface
           (sequence in)
           (sequence out)
           (output 1
            (type data)
            (name "Done")
            (tag "Done")
            (lock constraints)
           )
          )
          (implementation
           (component delay 1)
          )
          (views
           (icon
            (origin 461 368)
            (extent 78 25)
           )
           (detail
            (origin 410 384)
            (extent 120 32)
           )
           (active icon)
          )
         )
         (component 12 "FORRANGE"
          (interface
           (sequence in)
           (sequence out)
           (input 1
            (type data)
            (name "From")
            (tag "From")
            (requires
             (datatype Real)
             (shape "Scalar")
            )
            (lock constraints)
            (optional yes)
            (buffer YES)
           )
           (output 1
            (type data)
            (name "Data")
            (lock name constraints)
           )
          )
          (implementation
           (component from 5)
           (component thru 1)
           (component step -1)
          )
          (views
           (icon
            (origin 175 268)
            (extent 110 64)
            (iconImage "loop.icon")
           )
           (detail
            (origin 315 227)
            (extent 150 86)
           )
           (active icon)
          )
         )
         (component 13 "FORMULA"
          (interface
           (sequence in)
           (sequence out)
           (input 1
            (type data)
            (name "A")
            (optional yes)
           )
           (output 1
            (type data)
            (name "Result")
            (lock name constraints)
           )
          )
          (implementation
           (component isLocked no)
           (component expr 1 "\"Waiting...\"+a")
          )
          (views
           (icon
            (origin 301 268)
            (extent 78 64)
            (iconImage "formula.icon")
           )
           (detail
            (origin 555 299)
            (extent 160 62)
           )
           (terminals on)
           (active icon)
          )
         )
         (component 14 "FROMGLOBAL"
          (interface
           (sequence in)
           (sequence out)
           (output 1
            (type data)
            (name "Data")
            (tag "Data")
            (lock name constraints)
           )
          )
          (implementation
           (component globalName waittime)
          )
          (views
           (icon
            (origin 65 228)
            (extent 110 25)
           )
           (detail
            (origin 262 240)
            (extent 97 61)
           )
           (terminals on)
           (active icon)
          )
         )
         (configuration
          (connect I1:1 D0:1)
          (connect I2:1 D0:2)
          (connect D3:1 D0:3)
          (connect D2:1 D0:4)
          (connect I1:1 D1:1)
          (connect D5:1 D2:1)
          (connect D4:1 D3:1)
          (connect I1:1 D4:1)
          (connect I1:1 D5:1)
          (connect D1:1 D6:1)
          (connect D10:0 D7:0)
          (connect D11:1 D8:1)
          (connect D8:0 D9:0)
          (connect D6:0 D10:0)
          (connect D12:1 D10:1)
          (connect D10:1 D11:1)
         )
         (ShowOnExecPanel
          (origin 261 90)
          (extent 401 501)
          (panel
           (origin 362 184)
           (extent 397 473)
           (widget 0 detail
            (title on)
            (origin 395 234)
            (extent 336 304)
            (displayMode annotGraph)
            (graphType cartesian)
            (gridType frame)
            (scale 0
             (name "Y name")
             (domainName "X name")
             (pen 9)
             (show 1)
             (range -1.2 1.2 3 linear)
            )
            (domain 0 49 4 linear)
            (trace 0 onScale 0
             (name "Data")
             (pen 4)
             (lineType 1)
             (pointType 0)
            )
            (trace 1 onScale 0
             (name "Average")
             (pen 7)
             (lineType 1)
             (pointType 0)
            )
            (trace 2 onScale 0
             (name "Min Pt.")
             (pen 6)
             (lineType 1)
             (pointType 0)
            )
            (trace 3 onScale 0
             (name "Max Pt.")
             (pen 2)
             (lineType 1)
             (pointType 0)
            )
            (stepSize 1)
            (trackingEnabled 1)
           )
           (widget 6 detail
            (title on)
            (origin 439 566)
            (extent 201 34)
           )
           (widget 8 detail
            (title off)
            (origin 381 611)
            (extent 356 37)
           )
          )
         )
        )
        (views
         (icon
          (origin 225 398)
          (extent 110 25)
         )
         (detail
          (origin -4 171)
          (extent 668 459)
          (configuration
           (connect I1:1 D0:1
            (Point -2 290)
            (Point 320 370)
            (Point 320 490)
            (Point 512 490)
           )
           (connect I2:1 D0:2
            (Point -2 530)
            (Point 180 610)
            (Point 180 580)
            (Point 190 580)
            (Point 190 500)
            (Point 512 500)
           )
           (connect D3:1 D0:3
            (Point 388 540)
            (Point 393 540)
            (Point 393 510)
            (Point 512 510)
           )
           (connect D2:1 D0:4
            (Point 400 610)
            (Point 410 610)
            (Point 410 600)
            (Point 390 600)
            (Point 390 520)
            (Point 512 520)
           )
           (connect I1:1 D1:1
            (Point -2 290)
            (Point 165 410)
            (Point 165 610)
            (Point 185 610)
            (Point 185 700)
            (Point 388 700)
           )
           (connect D5:1 D2:1
            (Point 281 610)
            (Point 299 610)
           )
           (connect D4:1 D3:1
            (Point 261 540)
            (Point 291 540)
           )
           (connect I1:1 D4:1
            (Point -2 290)
            (Point 165 410)
            (Point 165 540)
            (Point 178 540)
           )
           (connect I1:1 D5:1
            (Point -2 290)
            (Point 165 410)
            (Point 165 610)
            (Point 198 610)
           )
           (connect D1:1 D6:1
            (Point 471 700)
            (Point 592 700)
           )
           (connect D10:0 D7:0
            (Point 230 334)
            (Point 230 350)
            (Point 250 350)
            (Point 250 435)
           )
           (connect D11:1 D8:1
            (Point 381 300)
            (Point 390 300)
            (Point 390 320)
            (Point 407 320)
           )
           (connect D8:0 D9:0
            (Point 500 342)
            (Point 500 365)
           )
           (connect D6:0 D10:0
            (Point 695 719)
            (Point 695 730)
            (Point 580 730)
            (Point 580 580)
            (Point 630 580)
            (Point 630 250)
            (Point 230 250)
            (Point 230 265)
           )
           (connect D12:1 D10:1
            (Point 177 240)
            (Point 190 240)
            (Point 190 260)
            (Point 160 260)
            (Point 160 300)
            (Point 172 300)
           )
           (connect D10:1 D11:1
            (Point 287 300)
            (Point 298 300)
           )
          )
          (stackingOrder 1 2 3 4 5 6 7 11 8 0
            9 10 12)
         )
         (terminals on)
         (active icon)
        )
       )
       (component 5 "LITERALCONSTANT"
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Text")
          (lock name constraints)
         )
        )
        (implementation
         (component value Text
          (name "Text")
          (datum "Selecting YES, More Info")
         )
         (component autoTrigger off)
         (component initializeAtPrerun off)
         (component initializeAtActivate off)
         (component initValue Text
          (name "CString")
          (datum "")
         )
        )
        (views
         (icon
         )
         (detail
          (origin 684 514)
          (extent 192 32)
         )
         (active detail)
        )
       )
       (component 6 "TEXTDISPLAY"
        (interface
         (sequence in)
         (sequence out)
         (input 1
          (type data)
          (name "Data")
         )
        )
        (implementation
         (component clearAtPrerun 1)
         (component clearAtActivate 1)
        )
        (views
         (icon
         )
         (detail
          (origin 960 511)
          (extent 180 39)
         )
         (active detail)
        )
       )
       (component 7 "DELAY"
        (interface
         (sequence in)
         (sequence out)
         (input 1
          (type data)
          (name "Delay")
          (tag "Delay")
          (requires
           (datatype Real)
           (shape "Scalar")
          )
          (lock constraints)
          (optional yes)
          (buffer YES)
         )
         (output 1
          (type data)
          (name "Done")
          (tag "Done")
          (lock constraints)
         )
        )
        (implementation
         (component delay 1.666666666666667)
        )
        (views
         (icon
          (origin 781 568)
          (extent 78 25)
         )
         (detail
          (origin 300 454)
          (extent 120 32)
         )
         (active icon)
        )
       )
       (component 8 "START"
        (interface
         (sequence out)
        )
        (implementation
        )
        (views
         (icon
          (origin 637 392)
          (extent 67 37)
         )
         (detail
         )
         (terminals on)
         (active icon)
        )
       )
       (component 9 "FORMULA"
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Result")
          (lock name constraints)
         )
        )
        (implementation
         (component isLocked no)
         (component expr 1 "waittime/3")
        )
        (views
         (icon
          (origin 661 568)
          (extent 78 64)
          (iconImage "formula.icon")
         )
         (detail
          (origin 618 569)
          (extent 124 62)
         )
         (terminals on)
         (active icon)
        )
       )
       (configuration
        (connect D4:0 D1:0)
        (connect I1:1 D1:1)
        (connect I2:1 D1:2)
        (connect D5:0 D2:0)
        (connect D2:1 D3:1)
        (connect D2:0 D4:0)
        (connect D6:1 D4:1)
       )
       (ShowOnExecPanel
        (origin 38 284)
        (extent 328 180)
        (panel
         (origin 213 464)
         (extent 324 152)
         (widget 0 icon
          (title off)
          (origin 263 475)
          (extent 172 64)
          (iconImage "notepad.icon")
         )
         (widget 3 detail
          (title off)
          (origin 215 555)
          (extent 321 39)
         )
        )
       )
      )
      (views
       (icon
        (origin 405 448)
        (extent 110 25)
       )
       (detail
        (origin 132 136)
        (extent 687 629)
        (configuration
         (connect D4:0 D1:0
          (Point 820 595)
          (Point 280 395)
         )
         (connect I1:1 D1:1
          (Point 134 300)
          (Point 90 300)
          (Point 90 310)
          (Point -150 310)
          (Point -150 400)
          (Point 222 400)
         )
         (connect I2:1 D1:2
          (Point 134 620)
          (Point 90 620)
          (Point 90 660)
          (Point -150 660)
          (Point -150 420)
          (Point 222 420)
         )
         (connect D5:0 D2:0
          (Point 670 431)
          (Point 670 450)
          (Point 780 450)
          (Point 780 483)
         )
         (connect D2:1 D3:1
          (Point 878 530)
          (Point 957 530)
         )
         (connect D2:0 D4:0
          (Point 780 548)
          (Point 780 560)
          (Point 820 560)
          (Point 820 565)
         )
         (connect D6:1 D4:1
          (Point 741 600)
          (Point 750 600)
          (Point 750 580)
          (Point 778 580)
         )
        )
        (stackingOrder 0 2 5 3 4 1 6)
       )
       (terminals on)
       (active detail)
      )
     )
     (component 7 "TOFILE"
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "dta")
        (optional yes)
       )
      )
      (implementation
       (attr iopath file append "/tmp/mfgdata"
        (readTerm "\n")
        (fs "\n")
        (eol "\n")
        (multiField fullSyntax)
        (arrayFormat block)
       )
       (procedure
         WRITE TEXT "    " QSTR EOL
         WRITE TEXT "    " QSTR EOL
         WRITE TEXT "    " QSTR EOL
         WRITE TEXT now() DATE:WDMY TIME:HMS:H12 EOL
         WRITE TEXT "    " QSTR EOL
         WRITE TEXT "DATA FROM TEST 1" EOL
         WRITE TEXT "--------------------------------------------------------" EOL
         WRITE TEXT dta REAL STD:4 EOL
       )
      )
      (views
       (icon
        (origin 201 393)
        (extent 78 34)
       )
       (detail
        (origin 387 441)
        (extent 457 178)
       )
       (terminals on)
       (active icon)
      )
     )
     (configuration
      (connect D3:0 D0:0)
      (connect D0:1 D1:0)
      (connect D1:1 D2:1)
      (connect D1:1 D4:1)
      (connect D0:0 D4:2)
      (connect D4:1 D5:1)
      (connect D0:1 D5:2)
      (connect D4:1 D6:1)
      (connect D5:1 D6:2)
      (connect D4:1 D7:1)
     )
     (ShowOnExecPanel
      (origin 28 202)
      (extent 880 309)
      (panel
       (origin 342 330)
       (extent 876 281)
       (widget 2 detail
        (title on)
        (origin 737 402)
        (extent 387 147)
        (displayMode graphOnly)
        (graphType cartesian)
        (gridType axis)
        (scale 0
         (name "Y name")
         (domainName "X name")
         (pen 9)
         (show 1)
         (range -1 1 3 linear)
        )
        (domain 0 49.00000000000053 4 linear)
        (trace 0 onScale 0
         (name "Trace1")
         (pen 4)
         (lineType 1)
         (pointType 0)
        )
        (stepSize 1)
        (trackingEnabled 1)
       )
      )
     )
    )
    (views
     (detail
      (origin 45 89)
      (extent 829 515)
      (configuration
       (connect D3:0 D0:0
        (Point -190 211)
        (Point -190 235)
       )
       (connect D0:1 D1:0
        (Point -129 270)
        (Point -10 270)
        (Point -10 285)
       )
       (connect D1:1 D2:1
        (Point 56 300)
        (Point 122 300)
       )
       (connect D1:1 D4:1
        (Point 56 300)
        (Point 70 300)
        (Point 70 330)
        (Point -80 330)
        (Point -80 360)
        (Point -68 360)
       )
       (connect D0:0 D4:2
        (Point -190 304)
        (Point -190 380)
        (Point -68 380)
       )
       (connect D4:1 D5:1
        (Point 47 370)
        (Point 60 370)
        (Point 60 400)
        (Point -90 400)
        (Point -90 430)
        (Point -83 430)
       )
       (connect D0:1 D5:2
        (Point -129 270)
        (Point -110 270)
        (Point -110 450)
        (Point -83 450)
       )
       (connect D4:1 D6:1
        (Point 47 370)
        (Point 40 370)
        (Point 40 300)
        (Point 49 300)
       )
       (connect D5:1 D6:2
        (Point 103 440)
        (Point 110 440)
        (Point 110 450)
        (Point 40 450)
        (Point 40 620)
        (Point 49 620)
       )
       (connect D4:1 D7:1
        (Point 47 370)
        (Point 60 370)
        (Point 60 400)
        (Point 180 400)
        (Point 180 410)
        (Point 198 410)
       )
      )
      (stackingOrder 0 1 2 3 4 5 7 6)
     )
     (terminals on)
     (active detail)
    )
   )
   (context 2
    (name "Test3")
    (description 8 5
     This object just loads and runs a complete other
     test.  In this case, the other test is another
     VEE model.  It could just as easily have been 
     a C Function that is directly tied to this
     VEE process.  For more information on tying
     in C functions, see the Help information on
     Compiled Functions.
     
    )
    (interface
     (sequence in)
     (sequence out)
    )
    (implementation
     (locked no)
     (trigMode deg)
     (nextID 16)
     (component 4 "TEXTDISPLAY"
      (name "The Date")
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "Data")
       )
      )
      (implementation
       (component clearAtPrerun 1)
       (component clearAtActivate 1)
      )
      (views
       (icon
        (extent 110 0)
       )
       (detail
        (origin 512 104)
        (extent 156 192)
       )
       (active detail)
      )
     )
     (component 5 "TOFILE"
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "dta")
        (optional yes)
       )
      )
      (implementation
       (attr iopath file append "/tmp/mfgdata"
        (readTerm "\n")
        (fs "\n")
        (eol "\n")
        (multiField fullSyntax)
        (arrayFormat block)
       )
       (procedure
         WRITE TEXT "    " QSTR EOL
         WRITE TEXT "    " QSTR EOL
         WRITE TEXT "    " QSTR EOL
         WRITE TEXT now() DATE:WDMY TIME:HMS:H12 EOL
         WRITE TEXT "    " QSTR EOL
         WRITE TEXT "DATA FROM TEST 3" EOL
         WRITE TEXT "--------------------------------------------------------" EOL
         WRITE TEXT dta REAL STD:4 EOL
       )
      )
      (views
       (icon
        (origin 581 393)
        (extent 78 34)
       )
       (detail
        (origin 397 421)
        (extent 457 178)
       )
       (terminals on)
       (active icon)
      )
     )
     (component 7 "CALL"
      (name "Call Function")
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "X")
        (lock name constraints)
        (optional yes)
       )
      )
      (implementation
       (component callFunc "pfchart")
      )
      (views
       (icon
       )
       (detail
        (origin 90 282)
        (extent 260 36)
       )
       (terminals on)
       (active detail)
      )
     )
     (component 8 "START"
      (interface
       (sequence out)
      )
      (implementation
      )
      (views
       (icon
        (origin 147 82)
        (extent 67 37)
       )
       (detail
       )
       (terminals on)
       (active icon)
      )
     )
     (component 13 "CONTEXT"
      (name "Load from Disk")
      (description 12 7
       This user object loads the barchart function
       from disk.   You could have also escaped to
       HP-UX, started another VEE process, and loaded
       this program to run.   
       
       By being able to dynamically load and delete
       objects, users can load only the parts of 
       memory that are required, and make maximum
       use of memory space.
       NOTE:  To see the detail view of this object,
       you must press the RIGHT mouse button, and
       select SHOW TITLE.  Then select DETAIL.
      )
      (interface
       (sequence in)
       (sequence out)
      )
      (implementation
       (locked no)
       (trigMode deg)
       (nextID 9)
       (component 1 "LITERALCONSTANT"
        (name "loading")
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Text")
          (lock name constraints)
         )
        )
        (implementation
         (component value Text
          (name "loading")
          (datum "Loading from Disk")
         )
         (component autoTrigger off)
         (component initializeAtPrerun off)
         (component initializeAtActivate off)
         (component initValue Text
          (name "CString")
          (datum "")
         )
        )
        (views
         (icon
          (extent 78 0)
         )
         (detail
          (origin 371 358)
          (extent 219 25)
         )
         (active detail)
        )
       )
       (component 3 "TEXTDISPLAY"
        (name "Loading from Disk")
        (interface
         (sequence in)
         (sequence out)
         (input 1
          (type data)
          (name "Data")
         )
        )
        (implementation
         (component clearAtPrerun 1)
         (component clearAtActivate 1)
        )
        (views
         (icon
          (extent 163 0)
         )
         (detail
          (origin 533 432)
          (extent 255 37)
         )
         (active detail)
        )
       )
       (component 7 "IMPORT"
        (name "Import Library")
        (interface
         (sequence in)
         (sequence out)
         (input 1
          (type control)
          (name "File Name")
          (tag "File Name")
          (requires
           (datatype Text)
           (shape "Scalar")
          )
          (lock name constraints)
          (optional yes)
         )
        )
        (implementation
         (component libType "userFunction")
         (component libName "myLibrary")
         (component fileName "/usr/lib/veetest/examples/mfgtest/mfgauto1.ex")
        )
        (views
         (icon
          (origin 622 508)
          (extent 136 25)
         )
         (detail
          (origin 508 372)
          (extent 305 96)
         )
         (active icon)
        )
       )
       (component 8 "LITERALCONSTANT"
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Text")
          (lock name constraints)
         )
        )
        (implementation
         (component value Text
          (name "Text")
          (datum "/usr/lib/veetest/examples/mfgtest/mfgauto1.ex")
         )
         (component autoTrigger off)
         (component initializeAtPrerun off)
         (component initializeAtActivate off)
         (component initValue Text
          (name "CString")
          (datum "")
         )
        )
        (views
         (icon
          (origin 427 508)
          (extent 46 25)
         )
         (detail
          (origin 354 504)
          (extent 192 32)
         )
         (active icon)
        )
       )
       (configuration
        (connect D0:1 D1:1)
        (connect D1:0 D2:0)
        (connect D3:1 D2:1)
       )
       (ShowOnExecPanel
        (origin 292 287)
        (extent 376 99)
        (panel
         (origin 414 415)
         (extent 372 71)
         (widget 1 detail
          (title off)
          (origin 422 437)
          (extent 358 32)
         )
        )
       )
      )
      (views
       (icon
        (origin 122 168)
        (extent 136 25)
       )
       (detail
        (origin 348 321)
        (extent 485 239)
        (configuration
         (connect D0:1 D1:1
          (Point 592 370)
          (Point 810 370)
          (Point 810 490)
          (Point 510 490)
          (Point 510 450)
          (Point 530 450)
         )
         (connect D1:0 D2:0
          (Point 660 471)
          (Point 660 480)
          (Point 690 480)
          (Point 690 505)
         )
         (connect D3:1 D2:1
          (Point 475 520)
          (Point 619 520)
         )
        )
        (stackingOrder 0 1 2 3)
       )
       (terminals on)
       (active icon)
      )
     )
     (component 14 "DELETE"
      (name "Delete Library")
      (description 2 7
       The library name is the same as the name given
       in the Loading UserObject.  
      )
      (interface
       (sequence in)
       (sequence out)
      )
      (implementation
       (component libName "myLibrary")
      )
      (views
       (icon
       )
       (detail
        (origin 109 432)
        (extent 242 36)
       )
       (active detail)
      )
     )
     (configuration
      (connect D2:1 D0:1)
      (connect D2:1 D1:1)
      (connect D4:0 D2:0)
      (connect D3:0 D4:0)
      (connect D2:0 D5:0)
     )
    )
    (views
     (panel
      (origin 584 519)
      (extent 392 262)
     )
     (detail
      (origin 215 139)
      (extent 498 384)
      (configuration
       (connect D2:1 D0:1
        (Point 382 300)
        (Point 430 300)
        (Point 430 200)
        (Point 509 200)
       )
       (connect D2:1 D1:1
        (Point 382 300)
        (Point 440 300)
        (Point 440 410)
        (Point 578 410)
       )
       (connect D4:0 D2:0
        (Point 190 195)
        (Point 190 230)
        (Point 220 230)
        (Point 220 251)
       )
       (connect D3:0 D4:0
        (Point 180 121)
        (Point 180 130)
        (Point 190 130)
        (Point 190 165)
       )
       (connect D2:0 D5:0
        (Point 220 320)
        (Point 220 340)
        (Point 230 340)
        (Point 230 401)
       )
      )
      (stackingOrder 3 0 2 5 4 1)
     )
     (terminals on)
     (active detail)
    )
   )
   (context 3
    (name "Report")
    (description 7 5
     This object just reads in the information that
     was stored to the mfgdata file in the other
     tests.
     
     Notice that we are reading the data as a block
     of information in one array of text strings.
     
    )
    (interface
     (sequence in)
     (sequence out)
    )
    (implementation
     (locked no)
     (trigMode deg)
     (nextID 15)
     (component 3 "SCROLLINGTEXTDISPLAY"
      (name "Data from Tests")
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "Data")
       )
      )
      (implementation
       (component clearAtPrerun 1)
       (component clearAtActivate 1)
      )
      (views
       (icon
        (origin 875 368)
        (extent 145 25)
       )
       (detail
        (origin 534 231)
        (extent 442 225)
        (bufferSize 256)
       )
       (active detail)
      )
     )
     (component 4 "FROMFILE"
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "X")
        (lock constraints)
        (optional yes)
       )
       (output 2
        (type data)
        (name "EOF")
        (tag "EOF")
        (lock name constraints)
        (optional yes)
       )
      )
      (implementation
       (attr iopath file read "/tmp/mfgdata"
        (readTerm "\n")
        (fs " ")
        (eol "\n")
        (multiField fullSyntax)
        (arrayFormat block)
       )
       (procedure
         READ TEXT x STR ARRAY:*
         EXECUTE REWIND
       )
      )
      (views
       (icon
        (origin 313 282)
        (extent 110 25)
       )
       (detail
        (origin 422 391)
        (extent 324 153)
       )
       (terminals on)
       (active icon)
      )
     )
     (component 6 "START"
      (interface
       (sequence out)
      )
      (implementation
      )
      (views
       (icon
        (origin 245 206)
        (extent 67 37)
       )
       (detail
       )
       (terminals on)
       (active icon)
      )
     )
     (component 9 "TEXTDISPLAY"
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "Data")
       )
      )
      (implementation
       (component clearAtPrerun 1)
       (component clearAtActivate 1)
      )
      (views
       (icon
        (origin 380 405)
        (extent 118 25)
       )
       (detail
        (origin 369 508)
        (extent 180 39)
       )
       (active icon)
      )
     )
     (component 10 "DELAY"
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "Done")
        (tag "Done")
        (lock constraints)
       )
      )
      (implementation
       (component delay 1)
      )
      (views
       (icon
        (origin 410 465)
        (extent 78 25)
       )
       (detail
        (origin 389 461)
        (extent 120 32)
       )
       (active icon)
      )
     )
     (component 12 "FORRANGE"
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "From")
        (tag "From")
        (requires
         (datatype Real)
         (shape "Scalar")
        )
        (lock constraints)
        (optional yes)
        (buffer YES)
       )
       (output 1
        (type data)
        (name "Data")
        (lock name constraints)
       )
      )
      (implementation
       (component from 5)
       (component thru 1)
       (component step -1)
      )
      (views
       (icon
        (origin 185 308)
        (extent 110 64)
        (iconImage "loop.icon")
       )
       (detail
        (origin 125 307)
        (extent 150 86)
       )
       (active icon)
      )
     )
     (component 13 "FORMULA"
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "A")
        (optional yes)
       )
       (output 1
        (type data)
        (name "Result")
        (lock name constraints)
       )
      )
      (implementation
       (component isLocked no)
       (component expr 1 "\"Waiting...\"+a")
      )
      (views
       (icon
        (origin 280 385)
        (extent 78 64)
        (iconImage "formula.icon")
       )
       (detail
        (origin 224 386)
        (extent 160 62)
       )
       (terminals on)
       (active icon)
      )
     )
     (component 14 "FROMGLOBAL"
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "Data")
        (tag "Data")
        (lock name constraints)
       )
      )
      (implementation
       (component globalName waittime)
      )
      (views
       (icon
        (origin 125 258)
        (extent 110 25)
       )
       (detail
        (origin 172 270)
        (extent 97 61)
       )
       (terminals on)
       (active icon)
      )
     )
     (configuration
      (connect D1:1 D0:1)
      (connect D7:0 D1:0)
      (connect D6:1 D3:1)
      (connect D3:0 D4:0)
      (connect D1:0 D5:0)
      (connect D7:1 D5:1)
      (connect D5:1 D6:1)
      (connect D2:0 D7:0)
     )
     (ShowOnExecPanel
      (origin 264 96)
      (extent 440 562)
      (panel
       (origin 255 89)
       (extent 436 534)
       (widget 0 detail
        (title off)
        (origin 264 95)
        (extent 415 423)
        (bufferSize 256)
       )
       (widget 3 detail
        (title off)
        (origin 292 551)
        (extent 342 40)
       )
      )
     )
    )
    (views
     (detail
      (origin 114 176)
      (extent 697 339)
      (configuration
       (connect D1:1 D0:1
        (Point 425 284)
        (Point 498 284)
        (Point 498 343)
        (Point 531 343)
       )
       (connect D7:0 D1:0
        (Point 180 285)
        (Point 180 310)
        (Point 160 310)
        (Point 160 300)
        (Point 120 300)
        (Point 120 250)
        (Point 130 250)
        (Point 130 190)
        (Point 368 190)
        (Point 368 279)
       )
       (connect D6:1 D3:1
        (Point 360 417)
        (Point 377 417)
       )
       (connect D3:0 D4:0
        (Point 439 432)
        (Point 439 447)
        (Point 449 447)
        (Point 449 462)
       )
       (connect D1:0 D5:0
        (Point 368 309)
        (Point 368 330)
        (Point 300 330)
        (Point 300 290)
        (Point 240 290)
        (Point 240 305)
       )
       (connect D7:1 D5:1
        (Point 237 270)
        (Point 250 270)
        (Point 250 280)
        (Point 230 280)
        (Point 230 300)
        (Point 170 300)
        (Point 170 340)
        (Point 182 340)
       )
       (connect D5:1 D6:1
        (Point 297 340)
        (Point 310 340)
        (Point 310 380)
        (Point 260 380)
        (Point 260 417)
        (Point 277 417)
       )
       (connect D2:0 D7:0
        (Point 278 245)
        (Point 278 260)
        (Point 240 260)
        (Point 240 240)
        (Point 180 240)
        (Point 180 255)
       )
      )
      (stackingOrder 0 2 3 1 5 7 6 4)
     )
     (terminals on)
     (active detail)
    )
   )
   (context 4
    (name "UserName")
    (description 3 5
     This object will prompt the user for who they 
     are.  If they select none, it will prompt them
     to get added to the list....
    )
    (interface
     (sequence in)
     (sequence out)
     (output 1
      (type data)
      (name "X")
      (lock constraints)
      (optional yes)
     )
    )
    (implementation
     (locked no)
     (trigMode deg)
     (nextID 13)
     (component 0 "ENUMCONSTANT"
      (name "Select your Name")
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type control)
        (name "Default Value")
        (requires
         (datatype Text)
         (shape "Scalar")
        )
        (lock name constraints)
        (optional yes)
       )
       (output 1
        (type data)
        (name "Enum")
        (lock name constraints)
       )
      )
      (implementation
       (component value Enum
        (name "Select your Name")
        (values
         ( "Joe" 0)
         ( "Fred" 1)
         ( "Sally" 2)
         ( "None" 3)
        )
        (datum "Fred")
       )
       (component autoTrigger on)
       (component initializeAtPrerun off)
       (component initializeAtActivate off)
       (component initValue Enum
        (name "Enum")
        (shared yes)
        (datum "Fred")
       )
      )
      (views
       (icon
        (origin 463 198)
        (extent 154 25)
       )
       (detail
        (origin 638 328)
        (extent 125 104)
        (format list)
       )
       (terminals on)
       (active icon)
      )
     )
     (component 1 "IFTHENELSE"
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "A")
        (optional yes)
       )
       (output 1
        (type data)
        (name "Then")
        (lock name constraints)
       )
       (output 2
        (type data)
        (name "Else")
        (lock name constraints)
       )
      )
      (implementation
       (component isLocked no)
       (component expr "a==\"None\"")
      )
      (views
       (icon
        (origin 532 340)
        (extent 78 25)
       )
       (detail
        (origin 142 307)
        (extent 149 70)
       )
       (terminals on)
       (active icon)
      )
     )
     (component 3 "GATE"
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "A")
        (tag "InData")
       )
       (output 1
        (type data)
        (name "X")
        (tag "OutData")
        (lock name constraints)
       )
      )
      (implementation
      )
      (views
       (icon
        (origin 597 398)
        (extent 46 25)
       )
       (detail
       )
       (terminals on)
       (active icon)
      )
     )
     (component 4 "DO"
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "Do")
        (lock name constraints)
       )
      )
      (implementation
      )
      (views
       (icon
        (origin 697 398)
        (extent 46 25)
       )
       (detail
       )
       (terminals on)
       (active icon)
      )
     )
     (component 5 "EXITPROCESS"
      (interface
       (sequence in)
      )
      (implementation
       (comp code 0)
      )
      (views
       (icon
        (origin 681 458)
        (extent 78 64)
        (iconImage "stop.icon")
       )
       (detail
        (origin 531 555)
        (extent 120 34)
       )
       (active icon)
      )
     )
     (component 6 "CONTEXT"
      (name "Sorry")
      (description 4 7
       This is just a message box to inform them that
       they were rejected and must be added to the list
       of allowable users.
       
      )
      (interface
       (sequence in)
       (sequence out)
      )
      (implementation
       (locked no)
       (trigMode deg)
       (nextID 2)
       (component 0 "NOTE"
        (interface
        )
        (implementation
         (component text 3 10
          ASK YOUR TEST DEVELOPER TO
          ADD YOUR NAME TO THE LIST.
          
         )
        )
        (views
         (icon
          (iconImage "notepad.icon")
         )
         (detail
          (origin 428 272)
          (extent 285 56)
          (editing enabled)
         )
         (active detail)
        )
       )
       (component 1 "CONFIRM"
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Go")
          (lock name constraints)
         )
        )
        (implementation
        )
        (views
         (icon
          (origin 526 380)
          (extent 128 80)
         )
         (detail
         )
         (terminals on)
         (active icon)
        )
       )
       (configuration
       )
       (ShowOnExecPanel
        (origin 442 311)
        (extent 378 228)
        (panel
         (origin 143 260)
         (extent 374 200)
         (widget 0 detail
          (title off)
          (origin 190 276)
          (extent 285 56)
          (editing enabled)
         )
         (widget 1 icon
          (title off)
          (origin 269 360)
          (extent 128 80)
         )
        )
       )
      )
      (views
       (icon
        (origin 681 358)
        (extent 78 25)
       )
       (detail
        (origin 415 230)
        (extent 350 300)
        (configuration
        )
        (stackingOrder 0 1)
       )
       (terminals on)
       (active icon)
      )
     )
     (component 7 "TOGLOBAL"
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "Data")
        (tag "Data")
       )
      )
      (implementation
       (component globalName operator)
      )
      (views
       (icon
        (origin 685 258)
        (extent 110 25)
       )
       (detail
        (origin 552 239)
        (extent 97 62)
       )
       (terminals on)
       (active icon)
      )
     )
     (component 8 "START"
      (interface
       (sequence out)
      )
      (implementation
      )
      (views
       (icon
        (origin 467 122)
        (extent 67 37)
       )
       (detail
       )
       (terminals on)
       (active icon)
      )
     )
     (component 9 "DELAY"
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "Delay")
        (tag "Delay")
        (requires
         (datatype Real)
         (shape "Scalar")
        )
        (lock constraints)
        (optional yes)
        (buffer YES)
       )
       (output 1
        (type data)
        (name "Done")
        (tag "Done")
        (lock constraints)
       )
      )
      (implementation
       (component delay 1.666666666666667)
      )
      (views
       (icon
        (origin 411 448)
        (extent 78 25)
       )
       (detail
        (origin 270 284)
        (extent 120 32)
       )
       (active icon)
      )
     )
     (component 10 "TEXTDISPLAY"
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "Data")
       )
      )
      (implementation
       (component clearAtPrerun 1)
       (component clearAtActivate 1)
      )
      (views
       (icon
       )
       (detail
        (origin 490 481)
        (extent 180 39)
       )
       (active detail)
      )
     )
     (component 11 "LITERALCONSTANT"
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "Text")
        (lock name constraints)
       )
      )
      (implementation
       (component value Text
        (name "Text")
        (datum "Auto-Selecting \'Fred\'")
       )
       (component autoTrigger off)
       (component initializeAtPrerun off)
       (component initializeAtActivate off)
       (component initValue Text
        (name "CString")
        (datum "")
       )
      )
      (views
       (icon
       )
       (detail
        (origin 364 394)
        (extent 192 32)
       )
       (active detail)
      )
     )
     (component 12 "FORMULA"
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "Result")
        (lock name constraints)
       )
      )
      (implementation
       (component isLocked no)
       (component expr 1 "waittime/3")
      )
      (views
       (icon
        (origin 331 428)
        (extent 78 64)
        (iconImage "formula.icon")
       )
       (detail
        (origin 288 429)
        (extent 124 62)
       )
       (terminals on)
       (active icon)
      )
     )
     (configuration
      (connect D7:0 D0:1)
      (connect D0:1 D1:1)
      (connect D1:2 D2:0)
      (connect D0:1 D2:1)
      (connect D5:0 D3:0)
      (connect D3:0 D4:0)
      (connect D1:1 D5:0)
      (connect D2:1 D6:1)
      (connect D10:0 D8:0)
      (connect D11:1 D8:1)
      (connect D10:1 D9:1)
      (connect D0:0 D10:0)
      (connect D2:1 O1:1)
     )
     (ShowOnExecPanel
      (origin 333 239)
      (extent 319 302)
      (panel
       (origin 581 343)
       (extent 315 274)
       (widget 0 detail
        (title on)
        (origin 636 391)
        (extent 230 104)
        (format buttons)
       )
       (widget 9 detail
        (title off)
        (origin 589 539)
        (extent 294 36)
       )
      )
     )
    )
    (views
     (detail
      (origin 235 109)
      (extent 456 438)
      (configuration
       (connect D7:0 D0:1
        (Point 500 161)
        (Point 500 170)
        (Point 440 170)
        (Point 440 210)
        (Point 460 210)
       )
       (connect D0:1 D1:1
        (Point 619 210)
        (Point 640 210)
        (Point 640 240)
        (Point 510 240)
        (Point 510 352)
        (Point 529 352)
       )
       (connect D1:2 D2:0
        (Point 612 362)
        (Point 620 362)
        (Point 620 395)
       )
       (connect D0:1 D2:1
        (Point 619 210)
        (Point 640 210)
        (Point 640 240)
        (Point 510 240)
        (Point 510 410)
        (Point 594 410)
       )
       (connect D5:0 D3:0
        (Point 720 385)
        (Point 720 395)
       )
       (connect D3:0 D4:0
        (Point 720 425)
        (Point 720 455)
       )
       (connect D1:1 D5:0
        (Point 612 342)
        (Point 720 342)
        (Point 720 355)
       )
       (connect D2:1 D6:1
        (Point 645 410)
        (Point 660 410)
        (Point 660 270)
        (Point 682 270)
       )
       (connect D10:0 D8:0
        (Point 460 428)
        (Point 460 440)
        (Point 450 440)
        (Point 450 445)
       )
       (connect D11:1 D8:1
        (Point 411 460)
        (Point 500 460)
        (Point 500 510)
        (Point 400 510)
        (Point 400 460)
        (Point 408 460)
       )
       (connect D10:1 D9:1
        (Point 558 410)
        (Point 570 410)
        (Point 570 440)
        (Point 470 440)
        (Point 470 500)
        (Point 487 500)
       )
       (connect D0:0 D10:0
        (Point 540 225)
        (Point 540 250)
        (Point 520 250)
        (Point 520 340)
        (Point 460 340)
        (Point 460 363)
       )
       (connect D2:1 O1:1
        (Point 645 410)
        (Point 660 410)
        (Point 660 330)
        (Point 730 330)
        (Point 730 338)
        (Point 688 338)
       )
      )
      (stackingOrder 1 2 3 4 5 0 7 10 9 6
        8 11)
     )
     (terminals on)
     (active detail)
    )
   )
   (context 5
    (name "PasswordAccepted")
    (description 4 5
     Bogus box to tell the operator that they 
     entered the correct password.  This object
     does not perform any other function.
     
    )
    (interface
     (sequence in)
     (sequence out)
    )
    (implementation
     (locked no)
     (trigMode deg)
     (nextID 6)
     (component 0 "EXITCONTEXT"
      (interface
       (sequence in)
      )
      (implementation
      )
      (views
       (icon
        (origin 528 428)
        (extent 145 25)
       )
       (detail
       )
       (terminals on)
       (active icon)
      )
     )
     (component 1 "TEXTDISPLAY"
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "Data")
       )
      )
      (implementation
       (component clearAtPrerun 1)
       (component clearAtActivate 1)
      )
      (views
       (icon
       )
       (detail
        (origin 449 286)
        (extent 242 68)
       )
       (active detail)
      )
     )
     (component 2 "DELAY"
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "Delay")
        (tag "Delay")
        (requires
         (datatype Real)
         (shape "Scalar")
        )
        (lock constraints)
        (optional yes)
        (buffer YES)
       )
      )
      (implementation
       (component delay 1.666666666666667)
      )
      (views
       (icon
        (origin 501 388)
        (extent 78 25)
       )
       (detail
        (origin 395 383)
        (extent 130 34)
       )
       (active icon)
      )
     )
     (component 3 "LITERALCONSTANT"
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "Text")
        (lock name constraints)
       )
      )
      (implementation
       (component value Text
        (name "Text")
        (datum "Password Accepted")
       )
       (component autoTrigger off)
       (component initializeAtPrerun off)
       (component initializeAtActivate off)
       (component initValue Text
        (name "CString")
        (datum "")
       )
      )
      (views
       (icon
        (origin 427 198)
        (extent 46 25)
       )
       (detail
        (origin 340 306)
        (extent 201 28)
       )
       (active icon)
      )
     )
     (component 5 "FORMULA"
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "Result")
        (lock name constraints)
       )
      )
      (implementation
       (component isLocked no)
       (component expr 1 "waittime/3")
      )
      (views
       (icon
        (origin 411 358)
        (extent 78 64)
        (iconImage "formula.icon")
       )
       (detail
        (origin 368 359)
        (extent 124 62)
       )
       (terminals on)
       (active icon)
      )
     )
     (configuration
      (connect D2:0 D0:0)
      (connect D3:1 D1:1)
      (connect D1:0 D2:0)
      (connect D4:1 D2:1)
     )
     (ShowOnExecPanel
      (origin 293 205)
      (extent 371 194)
      (panel
       (origin 317 227)
       (extent 367 166)
       (widget 1 detail
        (title off)
        (origin 376 276)
        (extent 251 61)
       )
      )
     )
    )
    (views
     (detail
      (origin 315 179)
      (extent 301 299)
      (configuration
       (connect D2:0 D0:0
        (Point 540 415)
        (Point 540 430)
        (Point 550 430)
        (Point 550 420)
        (Point 600 420)
        (Point 600 425)
       )
       (connect D3:1 D1:1
        (Point 475 210)
        (Point 490 210)
        (Point 490 240)
        (Point 430 240)
        (Point 430 320)
        (Point 446 320)
       )
       (connect D1:0 D2:0
        (Point 570 356)
        (Point 570 370)
        (Point 540 370)
        (Point 540 385)
       )
       (connect D4:1 D2:1
        (Point 491 390)
        (Point 490 390)
        (Point 490 400)
        (Point 498 400)
       )
      )
      (stackingOrder 0 1 3 2 4)
     )
     (terminals on)
     (active detail)
    )
   )
   (context 6
    (name "CheckPassword")
    (description 11 5
     This an object which will pop-up a dialog box for
     interaction with a user. The input required is the
     prompt and, if needed, a default reply. The con-
     struction is that of a user object inside a user
     function. The internal user object is the actual
     dialog box that will pop-up. This is an unsecured
     model; feel free to make any necessary mod-
     ifications.
     
     (one possible change could be to store the 
     passwords into an encrypted file.)
    )
    (interface
     (sequence in)
     (sequence out)
     (output 1
      (type data)
      (name "ReplyOut")
      (lock constraints)
      (optional yes)
     )
    )
    (implementation
     (locked no)
     (trigMode deg)
     (nextID 20)
     (component 0 "JUNCTION"
      (name "JCT")
      (interface
       (input 1
        (type data)
        (name "A")
        (lock name constraints)
       )
       (input 2
        (type data)
        (name "B")
        (lock name constraints)
       )
       (input 3
        (type data)
        (name "C")
        (optional yes)
       )
       (input 4
        (type data)
        (name "D")
        (optional yes)
       )
       (output 1
        (type data)
        (name "Data")
        (lock name constraints)
       )
      )
      (implementation
      )
      (views
       (icon
        (origin 1037 448)
        (extent 46 45)
       )
       (detail
        (origin 670 398)
        (extent 10 204)
       )
       (terminals on)
       (active icon)
      )
     )
     (component 1 "IFTHENELSE"
      (name "Passwords")
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "A")
        (optional yes)
       )
       (output 1
        (type data)
        (name "Then")
        (lock name constraints)
       )
       (output 2
        (type data)
        (name "Else If")
        (lock name constraints)
       )
       (output 3
        (type data)
        (name "Else If")
        (lock name constraints)
       )
       (output 4
        (type data)
        (name "Else")
        (lock name constraints)
       )
      )
      (implementation
       (component isLocked no)
       (component expr "(operator==\"Joe\" AND a==\"1234\")*1")
       (component expr "(operator==\"Fred\" AND a==\"2345\")*1")
       (component expr "(operator==\"Sally\" AND a==\"3456\")*1")
      )
      (views
       (icon
        (origin 725 473)
        (extent 110 54)
       )
       (detail
        (origin 379 453)
        (extent 343 154)
       )
       (terminals on)
       (active icon)
      )
     )
     (component 2 "FORMULA"
      (name " + ")
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "X")
        (lock name constraints)
       )
       (input 2
        (type data)
        (name "Y")
        (lock name constraints)
       )
       (output 1
        (type data)
        (name "Result")
        (lock name constraints)
       )
      )
      (implementation
       (component isLocked yes)
       (component expr 1 "X+Y")
      )
      (views
       (icon
        (origin 787 298)
        (extent 46 25)
       )
       (detail
       )
       (terminals on)
       (active icon)
      )
     )
     (component 3 "TEXTDISPLAY"
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "Data")
       )
      )
      (implementation
       (component clearAtPrerun 1)
       (component clearAtActivate 1)
      )
      (views
       (icon
        (origin 901 298)
        (extent 118 25)
       )
       (detail
        (origin 477 611)
        (extent 286 38)
       )
       (active icon)
      )
     )
     (component 4 "LITERALCONSTANT"
      (name "Prompt")
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "Text")
        (lock name constraints)
       )
      )
      (implementation
       (component value Text
        (name "Prompt")
        (datum ", Enter your ID number")
       )
       (component autoTrigger off)
       (component initializeAtPrerun off)
       (component initializeAtActivate off)
       (component initValue Text
        (name "CString")
        (datum "")
       )
      )
      (views
       (icon
        (extent 78 0)
       )
       (detail
        (origin 624 388)
        (extent 252 25)
       )
       (active detail)
      )
     )
     (component 5 "CONTEXT"
      (name "Keybd")
      (description 2 7
       Keypad Modified to display asterisks instead 
       of the entered number string.
      )
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "X")
        (lock constraints)
        (optional yes)
       )
       (output 2
        (type exception)
        (name "Error")
        (lock name constraints)
        (optional yes)
       )
      )
      (implementation
       (locked no)
       (trigMode deg)
       (nextID 39)
       (component 0 "JUNCTION"
        (name "JCT")
        (interface
         (input 1
          (type data)
          (name "A")
          (lock name constraints)
         )
         (input 2
          (type data)
          (name "B")
          (lock name constraints)
         )
         (input 3
          (type data)
          (name "C")
          (optional yes)
         )
         (input 4
          (type data)
          (name "D")
          (optional yes)
         )
         (input 5
          (type data)
          (name "E")
          (optional yes)
         )
         (input 6
          (type data)
          (name "F")
          (optional yes)
         )
         (input 7
          (type data)
          (name "G")
          (optional yes)
         )
         (input 8
          (type data)
          (name "H")
          (optional yes)
         )
         (input 9
          (type data)
          (name "I")
          (optional yes)
         )
         (input 10
          (type data)
          (name "J")
          (optional yes)
         )
         (input 11
          (type data)
          (name "K")
          (optional yes)
         )
         (output 1
          (type data)
          (name "Data")
          (lock name constraints)
         )
        )
        (implementation
        )
        (views
         (icon
          (origin 87 233)
          (extent 46 114)
         )
         (detail
         )
         (terminals on)
         (active icon)
        )
       )
       (component 1 "LITERALCONSTANT"
        (name "\"8\"")
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Text")
          (lock name constraints)
         )
        )
        (implementation
         (component value Text
          (name "\"8\"")
          (datum "8")
         )
         (component autoTrigger off)
         (component initializeAtPrerun off)
         (component initializeAtActivate off)
         (component initValue Text
          (name "CString")
          (datum "")
         )
        )
        (views
         (icon
          (origin -143 418)
          (extent 46 25)
         )
         (detail
          (origin 290 399)
          (extent 120 23)
         )
         (active icon)
        )
       )
       (component 2 "CONFIRM"
        (name "Cancel")
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Go")
          (lock name constraints)
         )
        )
        (implementation
        )
        (views
         (icon
          (origin 122 432)
          (extent 76 37)
         )
         (detail
          (origin 491 410)
          (extent 68 40)
         )
         (terminals on)
         (active icon)
        )
       )
       (component 3 "LITERALCONSTANT"
        (name "\"1\"")
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Text")
          (lock name constraints)
         )
        )
        (implementation
         (component value Text
          (name "\"1\"")
          (datum "1")
         )
         (component autoTrigger off)
         (component initializeAtPrerun off)
         (component initializeAtActivate off)
         (component initValue Text
          (name "CString")
          (datum "")
         )
        )
        (views
         (icon
          (origin -223 188)
          (extent 46 25)
         )
         (detail
          (origin 170 269)
          (extent 120 23)
         )
         (active icon)
        )
       )
       (component 4 "CONFIRM"
        (name " 2 ")
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Go")
          (lock name constraints)
         )
        )
        (implementation
        )
        (views
         (icon
          (origin -184 142)
          (extent 49 37)
         )
         (detail
          (origin 360 180)
          (extent 50 40)
         )
         (terminals on)
         (active icon)
        )
       )
       (component 5 "LITERALCONSTANT"
        (name "\"2\"")
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Text")
          (lock name constraints)
         )
        )
        (implementation
         (component value Text
          (name "\"2\"")
          (datum "2")
         )
         (component autoTrigger off)
         (component initializeAtPrerun off)
         (component initializeAtActivate off)
         (component initValue Text
          (name "CString")
          (datum "")
         )
        )
        (views
         (icon
          (origin -143 188)
          (extent 46 25)
         )
         (detail
          (origin 230 389)
          (extent 120 23)
         )
         (active icon)
        )
       )
       (component 6 "CONFIRM"
        (name " 3 ")
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Go")
          (lock name constraints)
         )
        )
        (implementation
        )
        (views
         (icon
          (origin -84 142)
          (extent 49 37)
         )
         (detail
          (origin 390 180)
          (extent 50 40)
         )
         (terminals on)
         (active icon)
        )
       )
       (component 7 "LITERALCONSTANT"
        (name "\"3\"")
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Text")
          (lock name constraints)
         )
        )
        (implementation
         (component value Text
          (name "\"3\"")
          (datum "3")
         )
         (component autoTrigger off)
         (component initializeAtPrerun off)
         (component initializeAtActivate off)
         (component initValue Text
          (name "CString")
          (datum "")
         )
        )
        (views
         (icon
          (origin -43 188)
          (extent 46 25)
         )
         (detail
          (origin 200 379)
          (extent 120 23)
         )
         (active icon)
        )
       )
       (component 8 "CONFIRM"
        (name " 4 ")
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Go")
          (lock name constraints)
         )
        )
        (implementation
        )
        (views
         (icon
          (origin -274 262)
          (extent 49 37)
         )
         (detail
          (origin 510 340)
          (extent 50 40)
         )
         (terminals on)
         (active icon)
        )
       )
       (component 9 "CONFIRM"
        (name " 5 ")
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Go")
          (lock name constraints)
         )
        )
        (implementation
        )
        (views
         (icon
          (origin -184 262)
          (extent 49 37)
         )
         (detail
          (origin 350 320)
          (extent 50 40)
         )
         (terminals on)
         (active icon)
        )
       )
       (component 10 "CONFIRM"
        (name " 6 ")
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Go")
          (lock name constraints)
         )
        )
        (implementation
        )
        (views
         (icon
          (origin -84 262)
          (extent 49 37)
         )
         (detail
          (origin 490 320)
          (extent 50 40)
         )
         (terminals on)
         (active icon)
        )
       )
       (component 11 "LITERALCONSTANT"
        (name "\"4\"")
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Text")
          (lock name constraints)
         )
        )
        (implementation
         (component value Text
          (name "\"4\"")
          (datum "4")
         )
         (component autoTrigger off)
         (component initializeAtPrerun off)
         (component initializeAtActivate off)
         (component initValue Text
          (name "CString")
          (datum "")
         )
        )
        (views
         (icon
          (origin -233 308)
          (extent 46 25)
         )
         (detail
          (origin 190 309)
          (extent 120 23)
         )
         (active icon)
        )
       )
       (component 12 "LITERALCONSTANT"
        (name "\"5\"")
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Text")
          (lock name constraints)
         )
        )
        (implementation
         (component value Text
          (name "\"5\"")
          (datum "5")
         )
         (component autoTrigger off)
         (component initializeAtPrerun off)
         (component initializeAtActivate off)
         (component initValue Text
          (name "CString")
          (datum "")
         )
        )
        (views
         (icon
          (origin -143 308)
          (extent 46 25)
         )
         (detail
          (origin 290 309)
          (extent 120 23)
         )
         (active icon)
        )
       )
       (component 13 "LITERALCONSTANT"
        (name "\"6\"")
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Text")
          (lock name constraints)
         )
        )
        (implementation
         (component value Text
          (name "\"6\"")
          (datum "6")
         )
         (component autoTrigger off)
         (component initializeAtPrerun off)
         (component initializeAtActivate off)
         (component initValue Text
          (name "CString")
          (datum "")
         )
        )
        (views
         (icon
          (origin -53 308)
          (extent 46 25)
         )
         (detail
          (origin 390 309)
          (extent 120 23)
         )
         (active icon)
        )
       )
       (component 14 "CONFIRM"
        (name " 7 ")
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Go")
          (lock name constraints)
         )
        )
        (implementation
        )
        (views
         (icon
          (origin -284 372)
          (extent 49 37)
         )
         (detail
          (origin 200 410)
          (extent 50 40)
         )
         (terminals on)
         (active icon)
        )
       )
       (component 15 "LITERALCONSTANT"
        (name "\"7\"")
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Text")
          (lock name constraints)
         )
        )
        (implementation
         (component value Text
          (name "\"7\"")
          (datum "7")
         )
         (component autoTrigger off)
         (component initializeAtPrerun off)
         (component initializeAtActivate off)
         (component initValue Text
          (name "CString")
          (datum "")
         )
        )
        (views
         (icon
          (origin -243 418)
          (extent 46 25)
         )
         (detail
          (origin 190 399)
          (extent 120 23)
         )
         (active icon)
        )
       )
       (component 16 "CONFIRM"
        (name " 8 ")
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Go")
          (lock name constraints)
         )
        )
        (implementation
        )
        (views
         (icon
          (origin -184 372)
          (extent 49 37)
         )
         (detail
          (origin 340 420)
          (extent 50 40)
         )
         (terminals on)
         (active icon)
        )
       )
       (component 17 "CONFIRM"
        (name " 9 ")
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Go")
          (lock name constraints)
         )
        )
        (implementation
        )
        (views
         (icon
          (origin -84 372)
          (extent 49 37)
         )
         (detail
          (origin 480 420)
          (extent 50 40)
         )
         (terminals on)
         (active icon)
        )
       )
       (component 18 "LITERALCONSTANT"
        (name "\"9\"")
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Text")
          (lock name constraints)
         )
        )
        (implementation
         (component value Text
          (name "\"9\"")
          (datum "9")
         )
         (component autoTrigger off)
         (component initializeAtPrerun off)
         (component initializeAtActivate off)
         (component initValue Text
          (name "CString")
          (datum "")
         )
        )
        (views
         (icon
          (origin -43 418)
          (extent 46 25)
         )
         (detail
          (origin 390 399)
          (extent 120 23)
         )
         (active icon)
        )
       )
       (component 19 "REPEATUNTILBREAK"
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Continuous")
          (lock name constraints)
         )
        )
        (implementation
        )
        (views
         (icon
          (origin -425 288)
          (extent 110 64)
          (iconImage "loop.icon")
         )
         (detail
         )
         (terminals on)
         (active icon)
        )
       )
       (component 20 "CONFIRM"
        (name " 0 ")
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Go")
          (lock name constraints)
         )
        )
        (implementation
        )
        (views
         (icon
          (origin -294 472)
          (extent 49 37)
         )
         (detail
          (origin 190 520)
          (extent 50 40)
         )
         (terminals on)
         (active icon)
        )
       )
       (component 21 "CONFIRM"
        (name " . ")
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Go")
          (lock name constraints)
         )
        )
        (implementation
        )
        (views
         (icon
          (origin -184 472)
          (extent 49 37)
         )
         (detail
          (origin 330 530)
          (extent 50 40)
         )
         (terminals on)
         (active icon)
        )
       )
       (component 22 "LITERALCONSTANT"
        (name "\".\"")
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Text")
          (lock name constraints)
         )
        )
        (implementation
         (component value Text
          (name "\".\"")
          (datum ".")
         )
         (component autoTrigger off)
         (component initializeAtPrerun off)
         (component initializeAtActivate off)
         (component initValue Text
          (name "CString")
          (datum "")
         )
        )
        (views
         (icon
          (origin -143 518)
          (extent 46 25)
         )
         (detail
          (origin 260 539)
          (extent 120 23)
         )
         (active icon)
        )
       )
       (component 23 "LITERALCONSTANT"
        (name "\"0\"")
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Text")
          (lock name constraints)
         )
        )
        (implementation
         (component value Text
          (name "\"0\"")
          (datum "0")
         )
         (component autoTrigger off)
         (component initializeAtPrerun off)
         (component initializeAtActivate off)
         (component initValue Text
          (name "CString")
          (datum "")
         )
        )
        (views
         (icon
          (origin -253 518)
          (extent 46 25)
         )
         (detail
          (origin 190 539)
          (extent 120 23)
         )
         (active icon)
        )
       )
       (component 24 "CONFIRM"
        (name "CE")
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Go")
          (lock name constraints)
         )
        )
        (implementation
        )
        (views
         (icon
          (origin -40 472)
          (extent 40 37)
         )
         (detail
          (origin 470 530)
          (extent 50 40)
         )
         (terminals on)
         (active icon)
        )
       )
       (component 25 "CONFIRM"
        (name " 1 ")
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Go")
          (lock name constraints)
         )
        )
        (implementation
        )
        (views
         (icon
          (origin -264 142)
          (extent 49 37)
         )
         (detail
          (origin 200 180)
          (extent 50 40)
         )
         (terminals on)
         (active icon)
        )
       )
       (component 26 "ESCAPE"
        (interface
         (sequence in)
        )
        (implementation
         (component code 0)
         (component message "Done")
        )
        (views
         (icon
         )
         (detail
          (origin 200 499)
          (extent 140 63)
         )
         (active detail)
        )
       )
       (component 27 "CONFIRM"
        (name "Accept")
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Go")
          (lock name constraints)
         )
        )
        (implementation
        )
        (views
         (icon
          (origin 182 112)
          (extent 76 37)
         )
         (detail
          (origin 631 180)
          (extent 68 40)
         )
         (terminals on)
         (active icon)
        )
       )
       (component 28 "EXITCONTEXT"
        (interface
         (sequence in)
        )
        (implementation
        )
        (views
         (icon
          (origin 228 158)
          (extent 145 25)
         )
         (detail
         )
         (terminals on)
         (active icon)
        )
       )
       (component 29 "ACCUMULATOR"
        (interface
         (sequence in)
         (sequence out)
         (input 1
          (type data)
          (name "Data")
          (tag "InData")
          (requires
           (shape "Scalar")
          )
          (lock name constraints)
         )
         (input 2
          (type control)
          (name "Clear")
          (lock name constraints)
          (optional yes)
         )
         (output 1
          (type data)
          (name "Data")
          (tag "accumData")
          (lock name constraints)
         )
        )
        (implementation
         (component clearAtPrerun 1)
         (component clearAtActivate 1)
        )
        (views
         (icon
         )
         (detail
          (origin 180 243)
          (extent 180 34)
         )
         (active detail)
        )
       )
       (component 30 "JUNCTION"
        (name "JCT")
        (interface
         (input 1
          (type data)
          (name "A")
          (lock name constraints)
         )
         (input 2
          (type data)
          (name "B")
          (lock name constraints)
         )
         (output 1
          (type data)
          (name "Data")
          (lock name constraints)
         )
        )
        (implementation
        )
        (views
         (icon
          (origin 387 258)
          (extent 46 25)
         )
         (detail
         )
         (terminals on)
         (active icon)
        )
       )
       (component 32 "NEXT"
        (interface
         (sequence in)
        )
        (implementation
        )
        (views
         (icon
          (origin 217 378)
          (extent 46 25)
         )
         (detail
         )
         (terminals on)
         (active icon)
        )
       )
       (component 33 "LITERALCONSTANT"
        (name "\"*\"")
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Text")
          (lock name constraints)
         )
        )
        (implementation
         (component value Text
          (name "\"*\"")
          (datum "*")
         )
         (component autoTrigger off)
         (component initializeAtPrerun off)
         (component initializeAtActivate off)
         (component initValue Text
          (name "CString")
          (datum "")
         )
        )
        (views
         (icon
          (origin 87 368)
          (extent 46 25)
         )
         (detail
          (origin 500 219)
          (extent 120 23)
         )
         (active icon)
        )
       )
       (component 34 "LITERALCONSTANT"
        (name "Password")
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Text")
          (lock name constraints)
         )
        )
        (implementation
         (component value Text
          (name "Password")
          (datum "****")
         )
         (component autoTrigger off)
         (component initializeAtPrerun off)
         (component initializeAtActivate off)
         (component initValue Text
          (name "CString")
          (datum "")
         )
        )
        (views
         (icon
          (origin 515 348)
          (extent 110 25)
         )
         (detail
          (origin 284 344)
          (extent 192 32)
         )
         (active detail)
        )
       )
       (configuration
        (connect D3:1 D0:1)
        (connect D5:1 D0:2)
        (connect D7:1 D0:3)
        (connect D11:1 D0:4)
        (connect D12:1 D0:5)
        (connect D13:1 D0:6)
        (connect D15:1 D0:7)
        (connect D1:1 D0:8)
        (connect D18:1 D0:9)
        (connect D23:1 D0:10)
        (connect D22:1 D0:11)
        (connect D16:1 D1:0)
        (connect D25:1 D3:0)
        (connect D19:1 D4:0)
        (connect D4:1 D5:0)
        (connect D19:1 D6:0)
        (connect D6:1 D7:0)
        (connect D19:1 D8:0)
        (connect D19:1 D9:0)
        (connect D19:1 D10:0)
        (connect D8:1 D11:0)
        (connect D9:1 D12:0)
        (connect D10:1 D13:0)
        (connect D19:1 D14:0)
        (connect D14:1 D15:0)
        (connect D19:1 D16:0)
        (connect D19:1 D17:0)
        (connect D17:1 D18:0)
        (connect D19:1 D20:0)
        (connect D19:1 D21:0)
        (connect D21:1 D22:0)
        (connect D20:1 D23:0)
        (connect D19:1 D24:0)
        (connect D19:1 D25:0)
        (connect D2:1 D26:0)
        (connect D27:1 D28:0)
        (connect D0:1 D29:1)
        (connect D24:1 D29:2)
        (connect D29:1 D30:1)
        (connect D24:1 D30:2)
        (connect D0:1 D32:0)
        (connect D30:1 O1:1)
       )
      )
      (views
       (icon
        (origin 491 378)
        (extent 78 25)
       )
       (panel
        (origin 1074 493)
        (extent 232 355)
        (widget 25 icon
         (title off)
         (origin 1092 570)
         (extent 49 37)
        )
        (widget 6 icon
         (title off)
         (origin 1232 570)
         (extent 49 37)
        )
        (widget 4 icon
         (title off)
         (origin 1160 570)
         (extent 49 37)
        )
        (widget 8 icon
         (title off)
         (origin 1091 624)
         (extent 49 37)
        )
        (widget 10 icon
         (title off)
         (origin 1231 623)
         (extent 49 37)
        )
        (widget 14 icon
         (title off)
         (origin 1092 677)
         (extent 49 37)
        )
        (widget 17 icon
         (title off)
         (origin 1231 677)
         (extent 49 37)
        )
        (widget 9 icon
         (title off)
         (origin 1160 623)
         (extent 49 37)
        )
        (widget 16 icon
         (title off)
         (origin 1161 675)
         (extent 49 37)
        )
        (widget 21 icon
         (title off)
         (origin 1231 725)
         (extent 49 37)
        )
        (widget 20 icon
         (title off)
         (origin 1161 725)
         (extent 49 37)
        )
        (widget 24 icon
         (title off)
         (origin 1093 727)
         (extent 49 35)
        )
        (widget 33 detail
         (title off)
         (origin 1091 511)
         (extent 192 32)
        )
       )
       (detail
        (origin -142 137)
        (extent 924 487)
        (configuration
         (connect D3:1 D0:1
          (Point -175 200)
          (Point -160 200)
          (Point -160 230)
          (Point -110 230)
          (Point -110 120)
          (Point 30 120)
          (Point 30 240)
          (Point 84 240)
         )
         (connect D5:1 D0:2
          (Point -95 200)
          (Point -80 200)
          (Point -80 230)
          (Point 0 230)
          (Point 0 250)
          (Point 84 250)
         )
         (connect D7:1 D0:3
          (Point 5 200)
          (Point 20 200)
          (Point 20 260)
          (Point 84 260)
         )
         (connect D11:1 D0:4
          (Point -185 320)
          (Point -170 320)
          (Point -170 330)
          (Point -110 330)
          (Point -110 340)
          (Point -70 340)
          (Point -70 320)
          (Point -20 320)
          (Point -20 300)
          (Point -10 300)
          (Point -10 290)
          (Point 0 290)
          (Point 0 270)
          (Point 84 270)
         )
         (connect D12:1 D0:5
          (Point -95 320)
          (Point -80 320)
          (Point -80 310)
          (Point -90 310)
          (Point -90 300)
          (Point -100 300)
          (Point -100 240)
          (Point -10 240)
          (Point -10 280)
          (Point 84 280)
         )
         (connect D13:1 D0:6
          (Point -5 320)
          (Point 10 320)
          (Point 10 290)
          (Point 84 290)
         )
         (connect D15:1 D0:7
          (Point -195 430)
          (Point -180 430)
          (Point -180 450)
          (Point -150 450)
          (Point -150 460)
          (Point -10 460)
          (Point -10 310)
          (Point 20 310)
          (Point 20 300)
          (Point 84 300)
         )
         (connect D1:1 D0:8
          (Point -95 430)
          (Point -80 430)
          (Point -80 420)
          (Point -90 420)
          (Point -90 410)
          (Point -100 410)
          (Point -100 350)
          (Point 30 350)
          (Point 30 310)
          (Point 84 310)
         )
         (connect D18:1 D0:9
          (Point 5 430)
          (Point 20 430)
          (Point 20 320)
          (Point 84 320)
         )
         (connect D23:1 D0:10
          (Point -205 530)
          (Point -190 530)
          (Point -190 560)
          (Point 50 560)
          (Point 50 330)
          (Point 84 330)
         )
         (connect D22:1 D0:11
          (Point -95 530)
          (Point 40 530)
          (Point 40 340)
          (Point 84 340)
         )
         (connect D16:1 D1:0
          (Point -133 390)
          (Point -120 390)
          (Point -120 415)
         )
         (connect D25:1 D3:0
          (Point -213 160)
          (Point -200 160)
          (Point -200 185)
         )
         (connect D19:1 D4:0
          (Point -313 320)
          (Point -290 320)
          (Point -290 120)
          (Point -160 120)
          (Point -160 139)
         )
         (connect D4:1 D5:0
          (Point -133 160)
          (Point -120 160)
          (Point -120 185)
         )
         (connect D19:1 D6:0
          (Point -313 320)
          (Point -290 320)
          (Point -290 120)
          (Point -160 120)
          (Point -160 110)
          (Point -60 110)
          (Point -60 139)
         )
         (connect D6:1 D7:0
          (Point -33 160)
          (Point -20 160)
          (Point -20 185)
         )
         (connect D19:1 D8:0
          (Point -313 320)
          (Point -290 320)
          (Point -290 240)
          (Point -250 240)
          (Point -250 259)
         )
         (connect D19:1 D9:0
          (Point -313 320)
          (Point -290 320)
          (Point -290 240)
          (Point -160 240)
          (Point -160 259)
         )
         (connect D19:1 D10:0
          (Point -313 320)
          (Point -290 320)
          (Point -290 240)
          (Point -120 240)
          (Point -120 250)
          (Point -60 250)
          (Point -60 259)
         )
         (connect D8:1 D11:0
          (Point -223 280)
          (Point -188 280)
          (Point -210 305)
         )
         (connect D9:1 D12:0
          (Point -133 280)
          (Point -120 280)
          (Point -120 305)
         )
         (connect D10:1 D13:0
          (Point -33 280)
          (Point -20 280)
          (Point -20 290)
          (Point -30 290)
          (Point -30 305)
         )
         (connect D19:1 D14:0
          (Point -313 320)
          (Point -260 320)
          (Point -260 369)
         )
         (connect D14:1 D15:0
          (Point -233 390)
          (Point -220 390)
          (Point -220 415)
         )
         (connect D19:1 D16:0
          (Point -313 320)
          (Point -260 320)
          (Point -260 350)
          (Point -160 350)
          (Point -160 369)
         )
         (connect D19:1 D17:0
          (Point -313 320)
          (Point -260 320)
          (Point -260 350)
          (Point -120 350)
          (Point -120 360)
          (Point -60 360)
          (Point -60 369)
         )
         (connect D17:1 D18:0
          (Point -33 390)
          (Point -20 390)
          (Point -20 415)
         )
         (connect D19:1 D20:0
          (Point -313 320)
          (Point -300 320)
          (Point -300 430)
          (Point -270 430)
          (Point -270 469)
         )
         (connect D19:1 D21:0
          (Point -313 320)
          (Point -300 320)
          (Point -300 430)
          (Point -260 430)
          (Point -260 460)
          (Point -160 460)
          (Point -160 469)
         )
         (connect D21:1 D22:0
          (Point -133 490)
          (Point -120 490)
          (Point -120 515)
         )
         (connect D20:1 D23:0
          (Point -243 490)
          (Point -230 490)
          (Point -230 515)
         )
         (connect D19:1 D24:0
          (Point -313 320)
          (Point -260 320)
          (Point -260 350)
          (Point -120 350)
          (Point -120 360)
          (Point -110 360)
          (Point -110 450)
          (Point -30 450)
          (Point -30 460)
          (Point -20 460)
          (Point -20 469)
         )
         (connect D19:1 D25:0
          (Point -313 320)
          (Point -290 320)
          (Point -290 120)
          (Point -240 120)
          (Point -240 139)
         )
         (connect D2:1 D26:0
          (Point 200 450)
          (Point 270 450)
          (Point 270 468)
         )
         (connect D27:1 D28:0
          (Point 260 130)
          (Point 300 130)
          (Point 300 155)
         )
         (connect D0:1 D29:1
          (Point 135 290)
          (Point 150 290)
          (Point 150 250)
          (Point 177 250)
         )
         (connect D24:1 D29:2
          (Point 2 490)
          (Point 30 490)
          (Point 30 410)
          (Point 170 410)
          (Point 170 270)
          (Point 177 270)
         )
         (connect D29:1 D30:1
          (Point 362 260)
          (Point 384 260)
         )
         (connect D24:1 D30:2
          (Point 2 490)
          (Point 30 490)
          (Point 30 410)
          (Point 210 410)
          (Point 210 420)
          (Point 370 420)
          (Point 370 280)
          (Point 384 280)
         )
         (connect D0:1 D32:0
          (Point 135 290)
          (Point 150 290)
          (Point 150 330)
          (Point 140 330)
          (Point 140 360)
          (Point 110 360)
          (Point 110 365)
         )
         (connect D30:1 O1:1
          (Point 435 270)
          (Point 752 270)
          (Point 752 260)
          (Point 779 260)
         )
        )
        (stackingOrder 0 1 2 3 4 5 6 7 9 10
          11 12 13 14 15 16 17 18 19 20
          21 22 23 24 25 26 27 28 29 30
          32 31 8 33)
       )
       (active icon)
      )
     )
     (component 9 "FROMGLOBAL"
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "Data")
        (tag "Data")
        (lock name constraints)
       )
      )
      (implementation
       (component globalName operator)
      )
      (views
       (icon
        (origin 655 288)
        (extent 110 25)
       )
       (detail
        (origin 182 240)
        (extent 97 61)
       )
       (terminals on)
       (active icon)
      )
     )
     (component 11 "CONSTANT"
      (name "Real")
      (subType "Real")
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "Real")
        (lock name constraints)
       )
      )
      (implementation
       (component value Real
        (name "Real")
        (datum 0)
       )
       (component autoTrigger off)
       (component initializeAtPrerun off)
       (component initializeAtActivate off)
       (component initValue Real
        (name "Real")
        (datum 0)
       )
      )
      (views
       (icon
        (origin 887 488)
        (extent 46 25)
       )
       (detail
        (origin 625 563)
        (extent 110 34)
        (showFormat real)
       )
       (active icon)
      )
     )
     (component 13 "LITERALCONSTANT"
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "Text")
        (lock name constraints)
       )
      )
      (implementation
       (component value Text
        (name "Text")
        (datum "2345")
       )
       (component autoTrigger off)
       (component initializeAtPrerun off)
       (component initializeAtActivate off)
       (component initValue Text
        (name "CString")
        (datum "")
       )
      )
      (views
       (icon
        (origin 567 438)
        (extent 46 25)
       )
       (detail
        (origin 84 294)
        (extent 192 32)
       )
       (active icon)
      )
     )
     (component 14 "DELAY"
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "Delay")
        (tag "Delay")
        (requires
         (datatype Real)
         (shape "Scalar")
        )
        (lock constraints)
        (optional yes)
        (buffer YES)
       )
       (output 1
        (type data)
        (name "Done")
        (tag "Done")
        (lock constraints)
       )
      )
      (implementation
       (component delay 5)
      )
      (views
       (icon
        (origin 591 678)
        (extent 78 25)
       )
       (detail
        (origin 197 504)
        (extent 57 32)
       )
       (terminals on)
       (active icon)
      )
     )
     (component 15 "LITERALCONSTANT"
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "Text")
        (lock name constraints)
       )
      )
      (implementation
       (component value Text
        (name "Text")
        (datum "Selecting Fred\'s Password")
       )
       (component autoTrigger off)
       (component initializeAtPrerun off)
       (component initializeAtActivate off)
       (component initValue Text
        (name "CString")
        (datum "")
       )
      )
      (views
       (icon
        (origin 557 538)
        (extent 46 25)
       )
       (detail
        (origin 74 364)
        (extent 192 32)
       )
       (active icon)
      )
     )
     (component 17 "TEXTDISPLAY"
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "Data")
       )
      )
      (implementation
       (component clearAtPrerun 1)
       (component clearAtActivate 1)
      )
      (views
       (icon
        (origin 611 588)
        (extent 118 25)
       )
       (detail
        (origin 667 581)
        (extent 286 38)
       )
       (active detail)
      )
     )
     (component 18 "EXITCONTEXT"
      (interface
       (sequence in)
      )
      (implementation
      )
      (views
       (icon
        (origin 728 668)
        (extent 145 25)
       )
       (detail
       )
       (terminals on)
       (active icon)
      )
     )
     (component 19 "FROMGLOBAL"
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "Data")
        (tag "Data")
        (lock name constraints)
       )
      )
      (implementation
       (component globalName waittime)
      )
      (views
       (icon
        (origin 465 638)
        (extent 110 25)
       )
       (detail
        (origin 532 480)
        (extent 97 61)
       )
       (terminals on)
       (active icon)
      )
     )
     (configuration
      (connect D1:1 D0:1)
      (connect D1:2 D0:2)
      (connect D1:3 D0:3)
      (connect D7:1 D0:4)
      (connect D8:1 D1:1)
      (connect D6:1 D2:1)
      (connect D4:1 D2:2)
      (connect D2:1 D3:1)
      (connect D1:4 D7:0)
      (connect D3:0 D8:0)
      (connect D13:1 D9:1)
      (connect D8:0 D10:0)
      (connect D10:1 D11:1)
      (connect D9:0 D12:0)
      (connect D10:0 D13:0)
      (connect D0:1 O1:1)
     )
     (ShowOnExecPanel
      (origin 314 202)
      (extent 353 499)
      (panel
       (origin 422 232)
       (extent 349 471)
       (widget 3 detail
        (title off)
        (origin 429 254)
        (extent 335 46)
       )
       (widget 5 panel
        (title off)
        (origin 479 331)
        (extent 232 355)
        (widget 25 icon
         (title off)
         (origin 497 408)
         (extent 49 37)
        )
        (widget 6 icon
         (title off)
         (origin 637 408)
         (extent 49 37)
        )
        (widget 4 icon
         (title off)
         (origin 565 408)
         (extent 49 37)
        )
        (widget 8 icon
         (title off)
         (origin 496 462)
         (extent 49 37)
        )
        (widget 10 icon
         (title off)
         (origin 636 461)
         (extent 49 37)
        )
        (widget 14 icon
         (title off)
         (origin 497 515)
         (extent 49 37)
        )
        (widget 17 icon
         (title off)
         (origin 636 515)
         (extent 49 37)
        )
        (widget 9 icon
         (title off)
         (origin 565 461)
         (extent 49 37)
        )
        (widget 16 icon
         (title off)
         (origin 566 513)
         (extent 49 37)
        )
        (widget 21 icon
         (title off)
         (origin 636 563)
         (extent 49 37)
        )
        (widget 20 icon
         (title off)
         (origin 566 563)
         (extent 49 37)
        )
        (widget 24 icon
         (title off)
         (origin 498 565)
         (extent 49 35)
        )
        (widget 33 detail
         (title off)
         (origin 496 349)
         (extent 192 32)
        )
       )
       (widget 11 detail
        (title off)
        (origin 427 647)
        (extent 339 35)
       )
      )
     )
    )
    (views
     (detail
      (origin 45 89)
      (extent 774 515)
      (configuration
       (connect D1:1 D0:1
        (Point 837 480)
        (Point 870 480)
        (Point 870 450)
        (Point 1034 450)
       )
       (connect D1:2 D0:2
        (Point 837 490)
        (Point 860 490)
        (Point 860 460)
        (Point 1034 460)
       )
       (connect D1:3 D0:3
        (Point 837 500)
        (Point 860 500)
        (Point 860 530)
        (Point 960 530)
        (Point 960 470)
        (Point 1034 470)
       )
       (connect D7:1 D0:4
        (Point 935 500)
        (Point 950 500)
        (Point 950 480)
        (Point 1034 480)
       )
       (connect D8:1 D1:1
        (Point 615 450)
        (Point 670 450)
        (Point 670 500)
        (Point 722 500)
       )
       (connect D6:1 D2:1
        (Point 767 300)
        (Point 784 300)
       )
       (connect D4:1 D2:2
        (Point 878 400)
        (Point 900 400)
        (Point 900 340)
        (Point 770 340)
        (Point 770 320)
        (Point 784 320)
       )
       (connect D2:1 D3:1
        (Point 835 310)
        (Point 898 310)
       )
       (connect D1:4 D7:0
        (Point 837 510)
        (Point 850 510)
        (Point 850 470)
        (Point 910 470)
        (Point 910 485)
       )
       (connect D3:0 D8:0
        (Point 960 325)
        (Point 960 440)
        (Point 630 440)
        (Point 630 430)
        (Point 590 430)
        (Point 590 435)
       )
       (connect D13:1 D9:1
        (Point 577 650)
        (Point 590 650)
        (Point 590 660)
        (Point 580 660)
        (Point 580 690)
        (Point 588 690)
       )
       (connect D8:0 D10:0
        (Point 590 465)
        (Point 590 480)
        (Point 580 480)
        (Point 580 535)
       )
       (connect D10:1 D11:1
        (Point 605 550)
        (Point 620 550)
        (Point 620 600)
        (Point 664 600)
       )
       (connect D9:0 D12:0
        (Point 630 705)
        (Point 630 720)
        (Point 690 720)
        (Point 690 650)
        (Point 800 650)
        (Point 800 665)
       )
       (connect D10:0 D13:0
        (Point 580 565)
        (Point 580 580)
        (Point 520 580)
        (Point 520 635)
       )
       (connect D0:1 O1:1
        (Point 1085 470)
        (Point 1100 470)
        (Point 1100 356)
        (Point 816 356)
       )
      )
      (stackingOrder 4 3 2 6 1 7 11 12 0 8
        10 13 9 5)
     )
     (terminals on)
     (active detail)
    )
   )
   (context 7
    (name "PermissionDenied")
    (description 6 5
     This is the message box to inform them that
     the password was incorrect.  
     
     NOTE !!!  The HINT box would be removed before
     using this object in an actual situation.
     
    )
    (interface
     (sequence in)
     (sequence out)
    )
    (implementation
     (locked no)
     (trigMode deg)
     (nextID 3)
     (component 0 "NOTE"
      (interface
      )
      (implementation
       (component text 4 8
         
           Sorry, please enter
          another ID number, or 
              press CANCEL.
       )
      )
      (views
       (icon
        (iconImage "notepad.icon")
       )
       (detail
        (origin 410 95)
        (extent 180 90)
        (editing enabled)
       )
       (active detail)
      )
     )
     (component 1 "CONFIRM"
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "Go")
        (lock name constraints)
       )
      )
      (implementation
      )
      (views
       (icon
        (origin 551 262)
        (extent 58 37)
       )
       (detail
       )
       (terminals on)
       (active icon)
      )
     )
     (component 2 "NOTE"
      (name "Login Hint")
      (interface
      )
      (implementation
       (component text 4 8
         
            Joe....1234
            Fred...2345
           Sally...3456
       )
      )
      (views
       (icon
        (origin 625 228)
        (extent 110 64)
        (iconImage "notepad.icon")
       )
       (detail
        (origin 537 146)
        (extent 187 89)
        (editing enabled)
       )
       (active detail)
      )
     )
     (configuration
     )
     (ShowOnExecPanel
      (origin 284 201)
      (extent 407 508)
      (panel
       (origin 409 310)
       (extent 403 480)
       (widget 1 icon
        (title off)
        (origin 563 489)
        (extent 97 59)
       )
       (widget 2 detail
        (title on)
        (origin 522 638)
        (extent 187 89)
        (editing disabled)
       )
       (widget 0 detail
        (title off)
        (origin 489 354)
        (extent 241 101)
        (editing disabled)
       )
      )
     )
    )
    (views
     (detail
      (origin 295 189)
      (extent 334 275)
      (configuration
      )
      (stackingOrder 0 1 2)
     )
     (terminals on)
     (active detail)
    )
   )
  )
  (locked no)
  (trigMode deg)
  (nextID 79)
  (component 3 "TOFILE"
   (description 2 4
    This will clear the existing file and log
    the username via global variables.
   )
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (attr iopath file append "/tmp/mfgdata"
     (readTerm "\n")
     (fs "\n")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (procedure
      EXECUTE CLEAR
      WRITE TEXT "OPERATOR IS: ",operator EOL
      WRITE TEXT "            " STR EOL
    )
   )
   (views
    (icon
     (origin 171 373)
     (extent 78 34)
    )
    (detail
     (origin 112 261)
     (extent 457 178)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 7 "START"
   (interface
    (sequence out)
   )
   (implementation
   )
   (views
    (icon
     (origin 117 112)
     (extent 67 37)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 9 "CONTEXT"
   (name "Select a Choice")
   (description 12 4
    This object allows users to select multiple 
    choices.  We could have used an "Enum" choice
    box, but then the user could have only selected
    one at a time. 
    
    The "ALL TESTS" choice simply sends a 1 as the
    new default value to all other toggles.  
    
    The IF/THEN/ELSE objects will test the status
    of the TOGGLEs and either send the name of
    the test or a null string.  The COLLECTOR 
    just builds the test names into an array.
   )
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "TestVector")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (locked yes)
    (trigMode deg)
    (nextID 35)
    (component 1 "TOGGLE"
     (name "Generate Report")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Default Value")
       (requires
        (datatype Int32)
        (shape "Scalar")
       )
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (name "Toggle")
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Generate Report")
       (datum 1)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate on)
      (component initValue Int32
       (name "LongInt")
       (datum 0)
      )
     )
     (views
      (icon
       (origin 375 284)
       (extent 192 27)
       (format check box)
      )
      (detail
       (origin 390 570)
       (extent 40 60)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "TOGGLE"
     (name "Test #2        ")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Default Value")
       (requires
        (datatype Int32)
        (shape "Scalar")
       )
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (name "Toggle")
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Test #2        ")
       (datum 1)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate on)
      (component initValue Int32
       (name "LongInt")
       (datum 0)
      )
     )
     (views
      (icon
       (origin 375 184)
       (extent 192 27)
       (format check box)
      )
      (detail
       (origin 250 440)
       (extent 44 60)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 3 "TOGGLE"
     (name "Test #1        ")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Default Value")
       (requires
        (datatype Int32)
        (shape "Scalar")
       )
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (name "Toggle")
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Test #1        ")
       (datum 1)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate on)
      (component initValue Int32
       (name "LongInt")
       (datum 0)
      )
     )
     (views
      (icon
       (origin 375 134)
       (extent 192 27)
       (format check box)
      )
      (detail
       (origin 250 390)
       (extent 40 60)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 5 "CONSTANT"
     (name "1")
     (subType "Integer")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Int32")
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "1")
       (datum 1)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (name "LongInt")
       (datum 0)
      )
     )
     (views
      (icon
       (origin 288 285)
       (extent 46 25)
      )
      (detail
       (origin 75 464)
       (extent 150 32)
       (showFormat int)
      )
      (active icon)
     )
    )
    (component 6 "TOGGLE"
     (name "Test #3        ")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Default Value")
       (requires
        (datatype Int32)
        (shape "Scalar")
       )
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (name "Toggle")
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Test #3        ")
       (datum 1)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate on)
      (component initValue Int32
       (name "LongInt")
       (datum 0)
      )
     )
     (views
      (icon
       (origin 375 234)
       (extent 192 27)
       (format check box)
      )
      (detail
       (origin 280 510)
       (extent 47 60)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 18 "COLLECTOR"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
       (tag "Data")
      )
      (input 2
       (type trigger)
       (name "XEQ")
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "Array")
       (tag "Array")
       (lock constraints)
      )
     )
     (implementation
      (component clearAtPrerun 1)
      (component clearAtActivate 1)
      (component output1D NO)
     )
     (views
      (icon
       (origin 876 155)
       (extent 110 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 19 "IFTHENELSE"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "(a==1)*\"Test1\"")
     )
     (views
      (icon
       (origin 612 125)
       (extent 118 25)
      )
      (detail
       (origin 638 254)
       (extent 154 72)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 20 "JUNCTION"
     (name "JCT")
     (interface
      (input 1
       (type data)
       (name "A")
       (lock name constraints)
      )
      (input 2
       (type data)
       (name "B")
       (lock name constraints)
      )
      (input 3
       (type data)
       (name "C")
       (optional yes)
      )
      (input 4
       (type data)
       (name "D")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Data")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 768 155)
       (extent 46 45)
      )
      (detail
       (origin 670 308)
       (extent 10 204)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 21 "IFTHENELSE"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "(a==1)*\"Test2\"")
     )
     (views
      (icon
       (origin 612 175)
       (extent 118 25)
      )
      (detail
       (origin 478 384)
       (extent 154 72)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 22 "IFTHENELSE"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "(a==1)*\"Test3\"")
     )
     (views
      (icon
       (origin 612 225)
       (extent 118 25)
      )
      (detail
       (origin 478 434)
       (extent 154 72)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 23 "IFTHENELSE"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "(a==1)*\"Report\"")
     )
     (views
      (icon
       (origin 622 285)
       (extent 118 25)
      )
      (detail
       (origin 184 544)
       (extent 163 72)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 24 "IFTHENELSE"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "strposchar(a,\"T\")==-1 AND strposchar(a,\"R\")==-1")
     )
     (views
      (icon
       (origin 922 235)
       (extent 118 25)
      )
      (detail
       (origin 310 384)
       (extent 451 72)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 26 "ESCAPE"
     (interface
      (sequence in)
     )
     (implementation
      (component code 0)
      (component message "")
     )
     (views
      (icon
       (origin 992 275)
       (extent 118 24)
      )
      (detail
       (origin 166 639)
       (extent 149 63)
      )
      (active icon)
     )
    )
    (component 27 "START"
     (interface
      (sequence out)
     )
     (implementation
     )
     (views
      (icon
       (origin 231 170)
       (extent 67 37)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 28 "LITERALCONSTANT"
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Text")
       (lock name constraints)
      )
     )
     (implementation
      (component value Text
       (name "Text")
       (datum "Selecting All Tests")
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Text
       (name "CString")
       (datum "")
      )
     )
     (views
      (icon
      )
      (detail
       (origin 298 392)
       (extent 192 32)
      )
      (active detail)
     )
    )
    (component 30 "DELAY"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Delay")
       (tag "Delay")
       (requires
        (datatype Real)
        (shape "Scalar")
       )
       (lock constraints)
       (optional yes)
       (buffer YES)
      )
      (output 1
       (type data)
       (name "Done")
       (tag "Done")
       (lock constraints)
      )
     )
     (implementation
      (component delay 1.666666666666667)
     )
     (views
      (icon
       (origin 391 508)
       (extent 78 25)
      )
      (detail
       (origin 360 514)
       (extent 120 32)
      )
      (active icon)
     )
    )
    (component 32 "TEXTDISPLAY"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
      )
     )
     (implementation
      (component clearAtPrerun 1)
      (component clearAtActivate 1)
     )
     (views
      (icon
      )
      (detail
       (origin 521 387)
       (extent 373 45)
      )
      (title off)
      (active detail)
     )
    )
    (component 33 "EXITCONTEXT"
     (interface
      (sequence in)
     )
     (implementation
     )
     (views
      (icon
       (origin 905 347)
       (extent 145 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 34 "FORMULA"
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "waittime/3")
     )
     (views
      (icon
       (origin 271 488)
       (extent 78 64)
       (iconImage "formula.icon")
      )
      (detail
       (origin 298 499)
       (extent 124 62)
      )
      (terminals on)
      (active icon)
     )
    )
    (configuration
     (connect D4:0 D0:0)
     (connect D3:1 D0:1)
     (connect D2:0 D1:0)
     (connect D3:1 D1:1)
     (connect D3:0 D2:0)
     (connect D3:1 D2:1)
     (connect D13:0 D3:0)
     (connect D1:0 D4:0)
     (connect D3:1 D4:1)
     (connect D7:1 D5:1)
     (connect D15:0 D5:2)
     (connect D2:1 D6:1)
     (connect D6:1 D7:1)
     (connect D8:1 D7:2)
     (connect D9:1 D7:3)
     (connect D10:1 D7:4)
     (connect D1:1 D8:1)
     (connect D4:1 D9:1)
     (connect D0:1 D10:1)
     (connect D5:1 D11:1)
     (connect D11:1 D12:0)
     (connect D0:0 D14:0)
     (connect D14:0 D15:0)
     (connect D18:1 D15:1)
     (connect D14:1 D16:1)
     (connect D5:0 D17:0)
     (connect D5:1 O1:1)
    )
    (ShowOnExecPanel
     (origin 315 259)
     (extent 356 261)
     (panel
      (origin 284 364)
      (extent 352 233)
      (widget 4 icon
       (title off)
       (origin 302 450)
       (extent 192 27)
       (format check box)
      )
      (widget 0 icon
       (title off)
       (origin 301 487)
       (extent 192 27)
       (format check box)
      )
      (widget 2 icon
       (title off)
       (origin 302 377)
       (extent 192 27)
       (format check box)
      )
      (widget 1 icon
       (title off)
       (origin 302 414)
       (extent 192 27)
       (format check box)
      )
      (widget 16 detail
       (title off)
       (origin 286 550)
       (extent 373 45)
      )
     )
    )
   )
   (views
    (icon
     (origin 158 438)
     (extent 145 45)
    )
    (detail
     (origin 231 319)
     (extent 438 303)
     (configuration
      (connect D4:0 D0:0
       (Point 471 263)
       (Point 471 281)
      )
      (connect D3:1 D0:1
       (Point 336 297)
       (Point 372 297)
      )
      (connect D2:0 D1:0
       (Point 471 163)
       (Point 471 181)
      )
      (connect D3:1 D1:1
       (Point 336 297)
       (Point 351 297)
       (Point 351 197)
       (Point 372 197)
      )
      (connect D3:0 D2:0
       (Point 311 312)
       (Point 311 328)
       (Point 214 328)
       (Point 214 118)
       (Point 471 118)
       (Point 471 131)
      )
      (connect D3:1 D2:1
       (Point 336 297)
       (Point 351 297)
       (Point 351 147)
       (Point 372 147)
      )
      (connect D13:0 D3:0
       (Point 264 209)
       (Point 264 228)
       (Point 311 228)
       (Point 311 282)
      )
      (connect D1:0 D4:0
       (Point 471 213)
       (Point 471 231)
      )
      (connect D3:1 D4:1
       (Point 336 297)
       (Point 351 297)
       (Point 351 247)
       (Point 372 247)
      )
      (connect D7:1 D5:1
       (Point 816 177)
       (Point 831 177)
       (Point 831 157)
       (Point 873 157)
      )
      (connect D15:0 D5:2
       (Point 430 535)
       (Point 434 558)
       (Point 844 558)
       (Point 844 177)
       (Point 873 177)
      )
      (connect D2:1 D6:1
       (Point 569 147)
       (Point 591 147)
       (Point 591 137)
       (Point 609 137)
      )
      (connect D6:1 D7:1
       (Point 732 127)
       (Point 751 127)
       (Point 751 157)
       (Point 765 157)
      )
      (connect D8:1 D7:2
       (Point 732 177)
       (Point 751 177)
       (Point 751 167)
       (Point 765 167)
      )
      (connect D9:1 D7:3
       (Point 732 227)
       (Point 751 227)
       (Point 751 177)
       (Point 765 177)
      )
      (connect D10:1 D7:4
       (Point 742 287)
       (Point 761 287)
       (Point 761 217)
       (Point 741 217)
       (Point 741 187)
       (Point 765 187)
      )
      (connect D1:1 D8:1
       (Point 569 197)
       (Point 591 197)
       (Point 591 187)
       (Point 609 187)
      )
      (connect D4:1 D9:1
       (Point 569 247)
       (Point 591 247)
       (Point 591 237)
       (Point 609 237)
      )
      (connect D0:1 D10:1
       (Point 569 297)
       (Point 619 297)
      )
      (connect D5:1 D11:1
       (Point 988 167)
       (Point 1001 167)
       (Point 1001 197)
       (Point 901 197)
       (Point 901 247)
       (Point 919 247)
      )
      (connect D11:1 D12:0
       (Point 1042 237)
       (Point 1051 237)
       (Point 1051 272)
      )
      (connect D0:0 D14:0
       (Point 471 313)
       (Point 471 328)
       (Point 394 328)
       (Point 394 361)
      )
      (connect D14:0 D15:0
       (Point 394 426)
       (Point 394 448)
       (Point 430 448)
       (Point 430 505)
      )
      (connect D18:1 D15:1
       (Point 351 520)
       (Point 388 520)
      )
      (connect D14:1 D16:1
       (Point 492 408)
       (Point 505 408)
       (Point 505 409)
       (Point 518 409)
      )
      (connect D5:0 D17:0
       (Point 931 182)
       (Point 931 189)
       (Point 887 189)
       (Point 887 279)
       (Point 977 279)
       (Point 977 344)
      )
      (connect D5:1 O1:1
       (Point 988 167)
       (Point 1005 167)
       (Point 1005 205)
       (Point 1125 205)
       (Point 1125 480)
       (Point 666 480)
      )
     )
     (stackingOrder 0 1 2 3 4 7 5 6 8 9
       10 11 12 13 14 16 17 15 18)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 16 "CONTEXT"
   (name "Press For")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (locked no)
    (trigMode deg)
    (nextID 4)
    (component 0 "IFTHENELSE"
     (name "!= 0")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a!=0")
     )
     (views
      (icon
       (origin 365 340)
       (extent 46 25)
      )
      (detail
       (origin 209 308)
       (extent 73 64)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "TOGGLE"
     (name "Info About")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Reset")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Info About")
       (values range 0 1)
       (datum 0)
      )
      (component autoTrigger on)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (name "LongInt")
       (datum 0)
      )
     )
     (views
      (icon
       (origin 201 333)
       (extent 114 39)
       (format button)
      )
      (detail
       (origin 320 203)
       (extent 42 54)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "REPEATUNTILBREAK"
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Continuous")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 115 248)
       (extent 110 64)
       (iconImage "loop.icon")
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 3 "CONTEXT"
     (name "Info About This Example")
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (locked no)
      (trigMode deg)
      (nextID 2)
      (component 0 "CONFIRM"
       (name "DONE")
       (description 7 8
        This tiny "thread" begins running when the 
        enclosing UserObject is executed.  When the user
        acknowledges the OK/DONE button, there is nothing
        left to execute, so the thread ends.  Since there
        are not other threads running, the User Object
        is completed and will exit, removing the Show on
        Execute pop-up display.
       )
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 421 482)
         (extent 58 37)
        )
        (detail
         (origin 156 253)
         (extent 79 34)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "NOTE"
       (name "NotePad")
       (description 2 8
        This notepad is displayed as a Show on Execute
        panel to present the information to the reader.
       )
       (interface
       )
       (implementation
        (component text 25 9
         PURPOSE:  To illustrate how a manufacturing test system might be designed using VEE 2.0.
         
         USER INPUT REQUIRED: Press Start (or Run). HP VEE will answer the prompts.
         
         	      To have the program run continuously, simply leave the box checked at the
         		  end of the demo.  To stop the example, click on the check box.
         
         
         EXPLANATION:  The following simulated tests are available in this example:
         
                       TEST #1:  Takes 50 random points and plots the results as they are taken.
         
                       TEST #2:  Tests 30 waveforms with random noise against an upper limit,
                                 recording the coordinates that failed and percent of failures.
         
                       TEST #3   Determines the distribution of 100 random numbers and plots a
                                 barchart of the results.  A threshold, manually set, determines
                                 the color of each bar for Pass/Fail indication.  This test
                                 is actually kept on disk and is loaded when test3 is called.
         
         
                       REPORT:   At any time, a report of the previously run tests can be shown,
                                 including the OPERATOR, timestamp when test was run, and the
                                 logged output from each test.  The Report is cleared each time
                                 after it is displayed.
        )
       )
       (views
        (icon
         (origin 410 415)
         (extent 78 25)
        )
        (detail
         (origin 25 209)
         (extent 848 437)
         (editing disabled)
        )
        (active icon)
       )
      )
      (configuration
      )
      (ShowOnExecPanel
       (origin 61 130)
       (extent 849 561)
       (panel
        (origin 38 154)
        (extent 845 533)
        (widget 0 icon
         (title off)
         (origin 437 639)
         (extent 58 37)
        )
        (widget 1 detail
         (title off)
         (origin 45 165)
         (extent 832 463)
         (editing disabled)
        )
       )
      )
     )
     (views
      (icon
       (origin 352 408)
       (extent 217 25)
      )
      (detail
       (origin 17 160)
       (extent 866 520)
       (configuration
       )
       (stackingOrder 0 1)
      )
      (active panel)
      (active panel)
     )
    )
    (configuration
     (connect D1:1 D0:1)
     (connect D2:1 D1:0)
     (connect D3:0 D1:1)
     (connect D0:1 D3:0)
    )
   )
   (views
    (icon
     (origin 275 188)
     (extent 110 25)
    )
    (panel
     (origin 392 178)
     (extent 276 85)
     (widget 1 icon
      (title off)
      (origin 473 199)
      (extent 114 39)
      (format button)
     )
    )
    (detail
     (origin 4 105)
     (extent 912 591)
     (configuration
      (connect D1:1 D0:1
       (Point 317 352)
       (Point 362 352)
      )
      (connect D2:1 D1:0
       (Point 227 280)
       (Point 258 280)
       (Point 258 330)
      )
      (connect D3:0 D1:1
       (Point 460 689)
       (Point 460 450)
       (Point 180 450)
       (Point 180 352)
       (Point 198 352)
      )
      (connect D0:1 D3:0
       (Point 413 342)
       (Point 460 342)
       (Point 460 123)
      )
     )
     (stackingOrder 0 1 2 3)
    )
    (active icon)
   )
  )
  (component 26 "NOTE"
   (interface
   )
   (implementation
   )
   (views
    (icon
     (origin 271 86)
     (extent 338 48)
     (label off)
     (iconImage "/usr/lib/veetest/bitmaps/disclaim.icon")
    )
    (detail
     (origin 830 250)
     (extent 200 100)
     (editing enabled)
    )
    (active icon)
   )
  )
  (component 39 "SEQUENCER"
   (description 7 4
    This sequencer takes advantage of the EXEC TRANS
    control pin.  This allows users to step through
    the prescribed tests, without testing the
    returned values.  To see the sequencer test
    returned values, look at the Login Control object
    on this example.
    
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type control)
     (name "Exec Trans")
     (requires
      (datatype Text)
     )
     (lock name constraints)
     (optional yes)
    )
    (output 1
     (type data)
     (name "Return")
     (tag "Return")
     (lock name constraints)
     (optional yes)
    )
    (output 2
     (type data)
     (name "Log")
     (tag "Log")
     (lock name constraints)
     (optional yes)
    )
   )
   (implementation
    (component logfields "name" "pass" "result")
    (procedure
      test1 EXECEX:test1() 	//Show Points/Analyze
      test2 EXECEX:test2() 	//Waveform Test
      test3 EXECEX:test3() 	//Bar Display from Disk
      report EXECEX:report() 	//Show Data from Tests
    )
   )
   (views
    (icon
     (origin 375 448)
     (extent 110 25)
    )
    (detail
     (origin 346 427)
     (extent 308 107)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 52 "SEQUENCER"
   (name "Login Control")
   (description 9 4
    This is a sequencer whose purpose is to step 
    through the user login dialog.  This sequence
    will first call the function UserName to 
    prompt for a name, and then carry the name
    via global variables to a password routine
    to confirm access.
    
    Notice the second transaction and the differences
    between a PASS flag and a FAIL flag.  
   )
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Return")
     (tag "Return")
     (lock name constraints)
     (optional yes)
    )
    (output 2
     (type data)
     (name "Log")
     (tag "Log")
     (lock name constraints)
     (optional yes)
    )
   )
   (implementation
    (component logfields "name" "pass" "result")
    (procedure
      getname EXECEX:username() 	//User Login Prompt
      validate LOGEN TESTEX:checkpassword() 	LIMITEX: 1 EQ 1 	PASSOP CALLEX:passwordaccepted() 	FAILOP CALLEX:permissiondenied() TGOTO:validate //Password Verification
    )
   )
   (views
    (icon
     (origin 157 318)
     (extent 127 25)
    )
    (detail
     (origin 31 247)
     (extent 498 126)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 73 "REPEATUNTILBREAK"
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Continuous")
     (lock name constraints)
    )
   )
   (implementation
   )
   (views
    (icon
     (origin 95 228)
     (extent 110 64)
     (iconImage "loop.icon")
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 74 "CONTEXT"
   (name "Program Control")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (locked no)
    (trigMode deg)
    (nextID 18)
    (component 1 "TOGGLE"
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Toggle")
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Toggle")
       (values range 0 1)
       (datum 1)
      )
      (component autoTrigger on)
      (component initializeAtPrerun on)
      (component initializeAtActivate on)
      (component initValue Int32
       (name "LongInt")
       (datum 1)
      )
     )
     (views
      (icon
       (origin 42 423)
       (extent 116 115)
       (format check box)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "LITERALCONSTANT"
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Text")
       (lock name constraints)
      )
     )
     (implementation
      (component value Text
       (name "Text")
       (datum "Click Here to Quit")
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Text
       (name "CString")
       (datum "")
      )
     )
     (views
      (icon
       (origin 177 288)
       (extent 46 25)
      )
      (detail
       (origin 274 354)
       (extent 192 32)
      )
      (active icon)
     )
    )
    (component 3 "TEXTDISPLAY"
     (name "AlphaNumeric")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
      )
     )
     (implementation
      (component clearAtPrerun 1)
      (component clearAtActivate 1)
     )
     (views
      (icon
       (origin 261 278)
       (extent 118 25)
      )
      (detail
       (origin 320 291)
       (extent 180 39)
      )
      (active icon)
     )
    )
    (component 4 "IFTHENELSE"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a==1")
     )
     (views
      (icon
       (origin 191 598)
       (extent 118 25)
      )
      (detail
       (origin 753 624)
       (extent 64 72)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 5 "DELAY"
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Done")
       (tag "Done")
       (lock constraints)
      )
     )
     (implementation
      (component delay 4)
     )
     (views
      (icon
       (origin 161 328)
       (extent 78 25)
      )
      (detail
       (origin 270 434)
       (extent 120 32)
      )
      (active icon)
     )
    )
    (component 6 "START"
     (interface
      (sequence out)
     )
     (implementation
     )
     (views
      (icon
       (origin 157 232)
       (extent 67 37)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 7 "NEXT"
     (interface
      (sequence in)
     )
     (implementation
     )
     (views
      (icon
       (origin 357 598)
       (extent 46 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 8 "EXITPROCESS"
     (interface
      (sequence in)
     )
     (implementation
      (comp code 0)
     )
     (views
      (icon
       (origin 531 598)
       (extent 78 64)
       (iconImage "stop.icon")
      )
      (detail
       (origin 885 654)
       (extent 110 32)
      )
      (active icon)
     )
    )
    (component 10 "NOTE"
     (name "Please Note")
     (interface
     )
     (implementation
      (component text 4 7
       This example is available 
       for standard use in
       examples/mfgtest/mfgtest.ex
       
      )
     )
     (views
      (icon
       (extent 110 0)
       (iconImage "notepad.icon")
      )
      (detail
       (origin 325 381)
       (extent 270 98)
       (editing enabled)
      )
      (active detail)
     )
    )
    (component 13 "TOGLOBAL"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
       (tag "Data")
      )
     )
     (implementation
      (component globalName waittime)
     )
     (views
      (icon
       (origin 565 538)
       (extent 110 25)
      )
      (detail
       (origin 322 279)
       (extent 97 62)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 14 "ENUMCONSTANT"
     (name "Speed")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Enum")
       (lock name constraints)
      )
     )
     (implementation
      (component value Enum
       (name "Speed")
       (values
        ( "Fast" 0)
        ( "Normal" 1)
        ( "Slow" 2)
       )
       (datum "Normal")
      )
      (component autoTrigger off)
      (component initializeAtPrerun on)
      (component initializeAtActivate off)
      (component initValue Enum
       (name "Enum")
       (shared yes)
       (datum "Normal")
      )
     )
     (views
      (icon
       (origin 361 488)
       (extent 78 25)
      )
      (detail
       (origin 182 458)
       (extent 117 84)
       (format buttons)
      )
      (active detail)
     )
    )
    (component 16 "IFTHENELSE"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else If")
       (lock name constraints)
      )
      (output 3
       (type data)
       (name "Else If")
       (lock name constraints)
      )
      (output 4
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "(ord(a)==0)*0.000010")
      (component expr "(ord(a)==1)*5")
      (component expr "(ord(a)==2)*10")
     )
     (views
      (icon
       (origin 331 488)
       (extent 118 45)
      )
      (detail
       (origin 436 458)
       (extent 208 124)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 17 "JUNCTION"
     (name "JCT")
     (interface
      (input 1
       (type data)
       (name "A")
       (lock name constraints)
      )
      (input 2
       (type data)
       (name "B")
       (lock name constraints)
      )
      (input 3
       (type data)
       (name "C")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Data")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 507 503)
       (extent 46 34)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (configuration
     (connect D4:0 D0:0)
     (connect D5:0 D1:0)
     (connect D1:1 D2:1)
     (connect D10:0 D3:0)
     (connect D0:1 D3:1)
     (connect D1:0 D4:0)
     (connect D3:1 D6:0)
     (connect D3:2 D7:0)
     (connect D12:1 D9:1)
     (connect D0:1 D10:0)
     (connect D10:1 D11:1)
     (connect D11:1 D12:1)
     (connect D11:2 D12:2)
     (connect D11:3 D12:3)
    )
    (ShowOnExecPanel
     (origin 302 242)
     (extent 386 229)
     (panel
      (origin 39 430)
      (extent 382 201)
      (widget 2 detail
       (title off)
       (origin 52 434)
       (extent 217 57)
      )
      (widget 0 icon
       (title off)
       (origin 101 499)
       (extent 116 111)
       (format check box)
      )
      (widget 10 detail
       (title on)
       (origin 279 465)
       (extent 117 136)
       (format buttons)
      )
     )
    )
   )
   (views
    (icon
     (origin 158 518)
     (extent 145 25)
    )
    (detail
     (origin 7 223)
     (extent 667 434)
     (configuration
      (connect D4:0 D0:0
       (Point 200 355)
       (Point 200 370)
       (Point 100 370)
       (Point 100 420)
      )
      (connect D5:0 D1:0
       (Point 190 271)
       (Point 190 280)
       (Point 200 280)
       (Point 200 285)
      )
      (connect D1:1 D2:1
       (Point 225 300)
       (Point 240 300)
       (Point 240 290)
       (Point 258 290)
      )
      (connect D10:0 D3:0
       (Point 240 544)
       (Point 240 560)
       (Point 250 560)
       (Point 250 595)
      )
      (connect D0:1 D3:1
       (Point 160 480)
       (Point 170 480)
       (Point 170 610)
       (Point 188 610)
      )
      (connect D1:0 D4:0
       (Point 200 315)
       (Point 200 325)
      )
      (connect D3:1 D6:0
       (Point 311 600)
       (Point 330 600)
       (Point 330 580)
       (Point 380 580)
       (Point 380 595)
      )
      (connect D3:2 D7:0
       (Point 311 620)
       (Point 330 620)
       (Point 330 640)
       (Point 420 640)
       (Point 420 580)
       (Point 570 580)
       (Point 570 595)
      )
      (connect D12:1 D9:1
       (Point 555 520)
       (Point 570 520)
       (Point 570 530)
       (Point 560 530)
       (Point 560 540)
       (Point 550 540)
       (Point 550 550)
       (Point 562 550)
      )
      (connect D0:1 D10:0
       (Point 160 480)
       (Point 170 480)
       (Point 170 410)
       (Point 240 410)
       (Point 240 427)
      )
      (connect D10:1 D11:1
       (Point 301 500)
       (Point 310 500)
       (Point 310 510)
       (Point 328 510)
      )
      (connect D11:1 D12:1
       (Point 451 490)
       (Point 490 490)
       (Point 490 510)
       (Point 504 510)
      )
      (connect D11:2 D12:2
       (Point 451 500)
       (Point 480 500)
       (Point 480 520)
       (Point 504 520)
      )
      (connect D11:3 D12:3
       (Point 451 510)
       (Point 470 510)
       (Point 470 530)
       (Point 504 530)
      )
     )
     (stackingOrder 0 8 5 1 7 6 9 10 2 4
       12 11 3)
    )
    (active icon)
   )
  )
  (component 76 "TOGLOBAL"
   (name "Set Wait Global")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
     (tag "Data")
    )
   )
   (implementation
    (component globalName waittime)
   )
   (views
    (icon
     (origin 78 188)
     (extent 145 25)
    )
    (detail
     (origin 107 179)
     (extent 127 62)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 77 "CONSTANT"
   (name "5")
   (subType "Real")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Real")
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "5")
     (datum 5)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (name "Real")
     (datum 0)
    )
   )
   (views
    (icon
     (origin 7 188)
     (extent 46 25)
    )
    (detail
     (origin 165 173)
     (extent 110 34)
     (showFormat real)
    )
    (active icon)
   )
  )
  (component 78 "CONFIRM"
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Go")
     (lock name constraints)
    )
   )
   (implementation
   )
   (views
    (icon
     (origin 351 392)
     (extent 58 37)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (configuration
   (connect D6:0 D0:0)
   (connect D0:0 D2:0)
   (connect D1:0 D3:0)
   (connect D11:1 D5:0)
   (connect D2:1 D5:1)
   (connect D7:1 D6:0)
   (connect D9:0 D7:0)
   (connect D2:0 D8:0)
   (connect D1:0 D9:0)
   (connect D10:1 D9:1)
  )
 )
 (views
  (panel
   (origin 0 62)
   (extent 1000 660)
   (widget 1 icon
    (title off)
    (origin 378 72)
    (extent 178 101)
   )
   (widget 4 icon
    (title off)
    (origin 653 87)
    (extent 338 48)
    (label off)
    (iconImage "/usr/lib/veetest/bitmaps/disclaim.icon")
   )
  )
  (detail
   (origin 0 62)
   (extent 943 634)
   (configuration
    (connect D6:0 D0:0
     (Point 220 345)
     (Point 220 360)
     (Point 210 360)
     (Point 210 370)
    )
    (connect D0:0 D2:0
     (Point 210 409)
     (Point 210 420)
     (Point 230 420)
     (Point 230 435)
    )
    (connect D1:0 D3:0
     (Point 150 151)
     (Point 150 170)
     (Point 330 170)
     (Point 330 185)
    )
    (connect D11:1 D5:0
     (Point 411 410)
     (Point 430 410)
     (Point 430 445)
    )
    (connect D2:1 D5:1
     (Point 305 460)
     (Point 372 460)
    )
    (connect D7:1 D6:0
     (Point 207 260)
     (Point 220 260)
     (Point 220 315)
    )
    (connect D9:0 D7:0
     (Point 150 215)
     (Point 150 225)
    )
    (connect D2:0 D8:0
     (Point 230 485)
     (Point 230 515)
    )
    (connect D1:0 D9:0
     (Point 150 151)
     (Point 150 185)
    )
    (connect D10:1 D9:1
     (Point 55 200)
     (Point 75 200)
    )
   )
   (stackingOrder 5 4 7 9 1 3 10 6 0 2
     11 8)
  )
  (active panel)
  (active panel)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
