#! /usr/lib/veetest/veetest -r
(revision "A.00.01")
(date "Wed 01/Jan/1992")
(component 0 "Context"
 (name "Stacked Bar Chart Example")
 (interface
 )
 (implementation
  (trigMode deg)
  (locked no)
  (component 0 "TextDisplay"
   (name "Upper")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 78 0)
    )
    (detail
     (origin 866 150)
     (extent 129 240)
    )
    (active detail)
   )
  )
  (component 1 "TextDisplay"
   (name "Lower")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 78 0)
    )
    (detail
     (origin 866 480)
     (extent 129 240)
    )
    (active detail)
   )
  )
  (component 2 "Note"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 4 5
     This example is provided as an
     illustration "as is", and Hewlett-Packard
     Company makes no warranty of any kind
     with regard to this example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 392 119)
     (extent 397 82)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 3 "Context"
   (name "Generate Data")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Result")
     (lock constraints)
     (optional yes)
    )
    (output 2
     (type data)
     (name "X")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "Context"
     (name "100 random #s")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Array")
       (lock constraints)
       (optional yes)
      )
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Collector"
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "Data")
         (tag "Data")
        )
        (input 2
         (type trigger)
         (name "XEQ")
         (lock name constraints)
        )
        (output 1
         (type data)
         (name "Array")
         (tag "Array")
         (lock constraints)
        )
       )
       (implementation
        (component clearAtPrerun 1)
        (component clearAtActivate 1)
       )
       (views
        (icon
         (origin 280 248)
         (extent 110 25)
        )
        (detail
         (origin 265 455)
         (extent 60 110)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "RandomNumber"
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Rand Val")
         (lock name constraints)
        )
       )
       (implementation
        (component lowerLimit 0)
        (component upperLimit 1)
       )
       (views
        (icon
         (origin 107 258)
         (extent 127 25)
        )
        (detail
         (origin 109 410)
         (extent 222 60)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 2 "ForCount"
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Count")
         (lock name constraints)
        )
       )
       (implementation
        (component count 100)
       )
       (views
        (icon
         (origin 90 168)
         (extent 110 64)
         (iconImage "loop.icon")
        )
        (detail
         (origin 60 183)
         (extent 170 34)
        )
        (active detail)
       )
      )
      (configuration
       (connect D1:1 D0:1)
       (connect D2:0 D0:2)
       (connect D2:1 D1:0)
       (connect D0:1 O1:1)
      )
     )
     (views
      (icon
       (origin 27 278)
       (extent 127 25)
      )
      (detail
       (origin 31 130)
       (extent 388 200)
       (configuration
        (connect D1:1 D0:1
         (Point 236 270)
         (Point 250 270)
         (Point 250 250)
         (Point 277 250)
        )
        (connect D2:0 D0:2
         (Point 145 219)
         (Point 145 240)
         (Point 85 240)
         (Point 85 300)
         (Point 255 300)
         (Point 255 270)
         (Point 277 270)
        )
        (connect D2:1 D1:0
         (Point 232 200)
         (Point 250 200)
         (Point 250 240)
         (Point 170 240)
         (Point 170 255)
        )
        (connect D0:1 O1:1
         (Point 392 260)
         (Point 416 240)
        )
       )
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "Context"
     (name "100 random #s")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Array")
       (lock constraints)
       (optional yes)
      )
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Collector"
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "Data")
         (tag "Data")
        )
        (input 2
         (type trigger)
         (name "XEQ")
         (lock name constraints)
        )
        (output 1
         (type data)
         (name "Array")
         (tag "Array")
         (lock constraints)
        )
       )
       (implementation
        (component clearAtPrerun 1)
        (component clearAtActivate 1)
       )
       (views
        (icon
         (origin 280 248)
         (extent 110 25)
        )
        (detail
         (origin 265 455)
         (extent 60 110)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "RandomNumber"
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Rand Val")
         (lock name constraints)
        )
       )
       (implementation
        (component lowerLimit 0)
        (component upperLimit 1)
       )
       (views
        (icon
         (origin 107 258)
         (extent 127 25)
        )
        (detail
         (origin 109 410)
         (extent 222 60)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 2 "ForCount"
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Count")
         (lock name constraints)
        )
       )
       (implementation
        (component count 100)
       )
       (views
        (icon
         (origin 90 168)
         (extent 110 64)
         (iconImage "loop.icon")
        )
        (detail
         (origin 60 183)
         (extent 170 34)
        )
        (active detail)
       )
      )
      (configuration
       (connect D1:1 D0:1)
       (connect D2:0 D0:2)
       (connect D2:1 D1:0)
       (connect D0:1 O1:1)
      )
     )
     (views
      (icon
       (origin 7 388)
       (extent 127 25)
      )
      (detail
       (origin 31 130)
       (extent 388 200)
       (configuration
        (connect D1:1 D0:1
         (Point 236 270)
         (Point 250 270)
         (Point 250 250)
         (Point 277 250)
        )
        (connect D2:0 D0:2
         (Point 145 219)
         (Point 145 240)
         (Point 85 240)
         (Point 85 300)
         (Point 255 300)
         (Point 255 270)
         (Point 277 270)
        )
        (connect D2:1 D1:0
         (Point 232 200)
         (Point 250 200)
         (Point 250 240)
         (Point 170 240)
         (Point 170 255)
        )
        (connect D0:1 O1:1
         (Point 392 260)
         (Point 416 240)
        )
       )
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "Formula"
     (name "magDist()")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "X")
       (lock name constraints)
      )
      (input 2
       (type data)
       (name "From")
       (lock name constraints)
      )
      (input 3
       (type data)
       (name "Thru")
       (lock name constraints)
      )
      (input 4
       (type data)
       (name "Step")
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked yes)
      (component expr 1 "magDist(x,from,thru,step)")
     )
     (views
      (icon
       (origin 205 348)
       (extent 110 45)
      )
      (detail
       (origin 421 305)
       (extent 259 210)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 3 "Formula"
     (name "magDist()")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "X")
       (lock name constraints)
      )
      (input 2
       (type data)
       (name "From")
       (lock name constraints)
      )
      (input 3
       (type data)
       (name "Thru")
       (lock name constraints)
      )
      (input 4
       (type data)
       (name "Step")
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked yes)
      (component expr 1 "magDist(x,from,thru,step)")
     )
     (views
      (icon
       (origin 205 448)
       (extent 110 45)
      )
      (detail
       (origin 421 305)
       (extent 259 210)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 4 "Constant"
     (name "Low Lim")
     (subType "Real")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Real")
       (lock name constraints)
      )
     )
     (implementation
      (component value Real
       (name "Low Lim")
       (datum 0)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Real
       (datum 0)
      )
     )
     (views
      (icon
       (extent 78 0)
      )
      (detail
       (origin 5 347)
       (extent 130 27)
       (showFormat real)
      )
      (active detail)
     )
    )
    (component 5 "Constant"
     (name "High Lim")
     (subType "Real")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Real")
       (lock name constraints)
      )
     )
     (implementation
      (component value Real
       (name "High Lim")
       (datum 1)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Real
       (datum 0)
      )
     )
     (views
      (icon
       (extent 110 0)
      )
      (detail
       (origin 2 456)
       (extent 137 28)
       (showFormat real)
      )
      (active detail)
     )
    )
    (component 6 "Constant"
     (name "step")
     (subType "Real")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Real")
       (lock name constraints)
      )
     )
     (implementation
      (component value Real
       (name "step")
       (datum 0.1)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Real
       (datum 0)
      )
     )
     (views
      (icon
       (origin 487 708)
       (extent 46 25)
      )
      (detail
       (origin 9 526)
       (extent 122 28)
       (showFormat real)
      )
      (active detail)
     )
    )
    (configuration
     (connect D0:1 D2:1)
     (connect D4:1 D2:2)
     (connect D5:1 D2:3)
     (connect D6:1 D2:4)
     (connect D1:1 D3:1)
     (connect D4:1 D3:2)
     (connect D5:1 D3:3)
     (connect D6:1 D3:4)
     (connect D2:1 O1:1)
     (connect D3:1 O2:1)
    )
   )
   (views
    (icon
     (origin 127 348)
     (extent 127 25)
    )
    (detail
     (origin 14 263)
     (extent 332 294)
     (configuration
      (connect D0:1 D2:1
       (Point 156 290)
       (Point 170 290)
       (Point 170 350)
       (Point 202 350)
      )
      (connect D4:1 D2:2
       (Point 137 360)
       (Point 202 360)
      )
      (connect D5:1 D2:3
       (Point 141 470)
       (Point 170 470)
       (Point 170 370)
       (Point 202 370)
      )
      (connect D6:1 D2:4
       (Point 133 540)
       (Point 160 540)
       (Point 160 490)
       (Point 210 490)
       (Point 210 430)
       (Point 190 430)
       (Point 190 380)
       (Point 202 380)
      )
      (connect D1:1 D3:1
       (Point 136 400)
       (Point 160 400)
       (Point 160 450)
       (Point 202 450)
      )
      (connect D4:1 D3:2
       (Point 137 360)
       (Point 180 360)
       (Point 180 460)
       (Point 202 460)
      )
      (connect D5:1 D3:3
       (Point 141 470)
       (Point 202 470)
      )
      (connect D6:1 D3:4
       (Point 133 540)
       (Point 160 540)
       (Point 160 480)
       (Point 202 480)
      )
      (connect D2:1 O1:1
       (Point 317 370)
       (Point 329 370)
       (Point 329 340)
       (Point 343 340)
      )
      (connect D3:1 O2:1
       (Point 317 470)
       (Point 329 470)
       (Point 329 500)
       (Point 343 500)
      )
     )
    )
    (active detail)
   )
  )
  (component 4 "Context"
   (name "Stacked Bars")
   (description 25 4
    Generates and displays a Stacked-Bar chart from
    the two 1-D arrays of input data.  The number
    of bars is equal to the number of array elements
    (arrays must be same size), and the "length" of
    each bar is set by the corresponding element data,
    which should be positive real or int32 numbers. 
    
    The display is autoscaled after plotting the bars
    using the maximum and minumum array data values
    and the number of bars.
    
    The display and data labels, bar color, grid type,
    etc. can be set by clicking the Right Button over
    the display area and selecting the "Traces and
    Scales" entry from the resulting menu.  The gap
    between bars can be set using the "Spacing" box
    in the Bar Chart Detail view.
    
    It may prove useful to Secure the BarChart User
    Object after customizing, since this eliminates
    the Panel/Detail buttons and some menu selections
    that are no longer needed.  Be sure to save the
    unsecured object so you can make changes at a
    later date, however. 
    
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Ary")
     (optional yes)
    )
    (input 2
     (type data)
     (name "LowData")
     (optional yes)
    )
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "YPlot"
     (name "XY Trace")
     (subType "XY_Trace")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Trace1")
       (lock constraints)
      )
      (input 2
       (type data)
       (name "Trace2")
       (lock constraints)
       (optional yes)
      )
      (input 3
       (type control)
       (name "Auto Scale")
       (lock name constraints)
       (optional yes)
      )
      (input 4
       (type control)
       (name "Next Curve")
       (lock name constraints)
       (optional yes)
      )
     )
     (implementation
      (component clearAtPrerun 1)
      (component clearAtActivate 0)
      (component tracePin 1)
      (component tracePin 2)
      (component graphMode rectangular)
     )
     (views
      (icon
       (iconImage "display.icon")
      )
      (detail
       (origin 512 351)
       (extent 317 278)
       (displayMode scrollGraph)
       (graphType cartesian)
       (gridType frame)
       (scale 0
        (name "Y name")
        (domainName "X name")
        (pen 9)
        (show 1)
        (range 0 30 4 linear)
       )
       (domain 0 10 4 linear)
       (trace 0 onScale 0
        (name "Trace1")
        (pen 7)
        (lineType 1)
        (pointType 6)
       )
       (trace 1 onScale 0
        (name "Trace2")
        (pen 4)
        (lineType 1)
        (pointType 6)
       )
      )
      (active detail)
     )
    )
    (component 1 "Formula"
     (name "Calculate Top Bar coords")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (input 2
       (type data)
       (name "B")
       (optional yes)
      )
      (input 3
       (type data)
       (name "I")
       (optional yes)
      )
      (input 4
       (type data)
       (name "z")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "[coord(I+z/2,A[i]+B[i]) coord(I+1-z/2,A[i]+B[i])]")
     )
     (views
      (icon
       (origin 237 318)
       (extent 226 45)
      )
      (detail
       (origin 158 398)
       (extent 475 204)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "Formula"
     (name "Calculate Low Bar coords")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (input 2
       (type data)
       (name "I")
       (optional yes)
      )
      (input 3
       (type data)
       (name "z")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "[coord(I+z/2,A[i]) coord(I+1-z/2,A[i])]")
     )
     (views
      (icon
       (origin 237 383)
       (extent 226 34)
      )
      (detail
       (origin 153 393)
       (extent 385 154)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 3 "Constant"
     (name "Spacing")
     (subType "Real")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Real")
       (lock name constraints)
      )
     )
     (implementation
      (component value Real
       (name "Spacing")
       (datum 0.2)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Real
       (datum 0)
      )
     )
     (views
      (icon
       (extent 78 0)
      )
      (detail
       (origin 277 466)
       (extent 147 28)
       (showFormat real)
      )
      (active detail)
     )
    )
    (component 4 "FromArray"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Ary")
       (tag "Ary")
      )
      (output 1
       (type data)
       (name "SubAry")
       (tag "Result")
       (lock constraints)
      )
      (output 2
       (type data)
       (name "Type")
       (tag "Type")
       (lock constraints)
      )
      (output 3
       (type data)
       (name "NumDims")
       (tag "NumDims")
       (lock constraints)
      )
      (output 4
       (type data)
       (name "DimSizes")
       (tag "DimSizes")
       (lock constraints)
      )
      (output 5
       (type data)
       (name "TotSize")
       (tag "TotSize")
       (lock constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "Ary")
     )
     (views
      (icon
       (origin 215 548)
       (extent 110 64)
       (iconImage "unbuild.icon")
      )
      (detail
       (origin 252 110)
       (extent 147 160)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 5 "ForCount"
     (name "For Count")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Count")
       (tag "Count")
       (requires
        (datatype Int32)
        (shape "Scalar")
       )
       (lock constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (name "Count")
       (lock name constraints)
      )
      (buffers in
       (buffer "Count")
      )
     )
     (implementation
      (component count 10)
     )
     (views
      (icon
       (origin 345 568)
       (extent 110 64)
       (iconImage "loop.icon")
      )
      (detail
       (origin 615 253)
       (extent 170 34)
      )
      (active icon)
     )
    )
    (configuration
     (connect D1:1 D0:1)
     (connect D2:1 D0:2)
     (connect D5:0 D0:3)
     (connect D0:0 D0:4)
     (connect I1:1 D1:1)
     (connect I2:1 D1:2)
     (connect D5:1 D1:3)
     (connect D3:1 D1:4)
     (connect I2:1 D2:1)
     (connect D5:1 D2:2)
     (connect D3:1 D2:3)
     (connect I2:1 D4:1)
     (connect D4:5 D5:1)
    )
   )
   (views
    (icon
     (origin 491 608)
     (extent 118 25)
    )
    (panel
     (origin 419 285)
     (extent 423 291)
     (widget 0 detail
      (title off)
      (origin 423 291)
      (extent 415 281)
      (displayMode annotGraph)
      (graphType cartesian)
      (gridType frame)
      (scale 0
       (name "Y name")
       (domainName "X name")
       (pen 1)
       (show 1)
       (range 0 30 4 linear)
      )
      (domain 0 10 4 linear)
      (trace 0 onScale 0
       (name "Trace1")
       (pen 7)
       (lineType 1)
       (pointType 6)
      )
      (trace 1 onScale 0
       (name "Trace2")
       (pen 4)
       (lineType 1)
       (pointType 6)
      )
     )
    )
    (detail
     (origin 156 303)
     (extent 689 355)
     (configuration
      (connect D1:1 D0:1
       (Point 465 340)
       (Point 480 340)
       (Point 480 380)
       (Point 509 380)
      )
      (connect D2:1 D0:2
       (Point 465 400)
       (Point 480 400)
       (Point 480 450)
       (Point 509 450)
      )
      (connect D5:0 D0:3
       (Point 400 634)
       (Point 400 650)
       (Point 470 650)
       (Point 470 520)
       (Point 509 520)
      )
      (connect D0:0 D0:4
       (Point 670 631)
       (Point 670 650)
       (Point 490 650)
       (Point 490 590)
       (Point 509 590)
      )
      (connect I1:1 D1:1
       (Point 158 390)
       (Point 170 390)
       (Point 170 320)
       (Point 234 320)
      )
      (connect I2:1 D1:2
       (Point 158 590)
       (Point 170 590)
       (Point 170 580)
       (Point 200 580)
       (Point 200 330)
       (Point 234 330)
      )
      (connect D5:1 D1:3
       (Point 457 600)
       (Point 480 600)
       (Point 480 530)
       (Point 210 530)
       (Point 210 340)
       (Point 234 340)
      )
      (connect D3:1 D1:4
       (Point 426 480)
       (Point 450 480)
       (Point 450 520)
       (Point 220 520)
       (Point 220 350)
       (Point 234 350)
      )
      (connect I2:1 D2:1
       (Point 158 590)
       (Point 170 590)
       (Point 170 580)
       (Point 200 580)
       (Point 200 390)
       (Point 234 390)
      )
      (connect D5:1 D2:2
       (Point 457 600)
       (Point 480 600)
       (Point 480 530)
       (Point 210 530)
       (Point 210 400)
       (Point 234 400)
      )
      (connect D3:1 D2:3
       (Point 426 480)
       (Point 450 480)
       (Point 450 520)
       (Point 220 520)
       (Point 220 410)
       (Point 234 410)
      )
      (connect I2:1 D4:1
       (Point 158 590)
       (Point 170 590)
       (Point 170 580)
       (Point 212 580)
      )
      (connect D4:5 D5:1
       (Point 327 600)
       (Point 342 600)
      )
     )
    )
    (active panel)
    (active panel)
   )
  )
  (component 5 "Context"
   (name "Press For")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "IfThenElse"
     (name "!= 0")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a!=0")
     )
     (views
      (icon
       (origin 365 350)
       (extent 46 25)
      )
      (detail
       (origin 209 308)
       (extent 73 64)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "Toggle"
     (name "Info About")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Reset")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Info About")
       (values range 0 1)
       (datum 0)
      )
      (component autoTrigger on)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (datum 0)
      )
     )
     (views
      (icon
       (origin 201 343)
       (extent 114 39)
       (format button)
      )
      (detail
       (origin 320 203)
       (extent 42 54)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "Context"
     (name "Info About This Example")
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Confirm"
       (name "DONE")
       (description 7 8
        This tiny "thread" begins running when the 
        enclosing UserObject is executed.  When the user
        acknowledges the OK/DONE button, there is nothing
        left to execute, so the thread ends.  Since there
        are not other threads running, the User Object
        is completed and will exit, removing the Show on
        Execute pop-up display.
       )
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 421 482)
         (extent 58 37)
        )
        (detail
         (origin 156 253)
         (extent 79 34)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "Note"
       (name "NotePad")
       (description 2 8
        This notepad is displayed as a Show on Execute
        panel to present the information to the reader.
       )
       (interface
       )
       (implementation
        (component text 21 9
         PURPOSE:     Illustrates use of the Stacked Bar Chart library object to display two arrays
                      of data simultaneously.
         
         USER INPUT REQUIRED: Press Run to display the Bar Chart.
         
         EXPLANATION: To generate some interesting data to display, two array of 100 random numbers
                      between 0 and 1.0 are analyzed to get the magnitude Distribution in 10 "bins"
                      between 0 and 1.  The resulting arrays each have 10 elements representing the
                      number of numbers in each of the 10 bins.  The arrays are given to the 
                      StakBarChart library object to generate the display.
         
         IMPLEMENTATION: The StakBarChart library object provides additional usage information from
                      the Show Description choice in the object menu.  Setting colors, etc. is
                      described here, along with a description of the input requirements.  When
                      using the BarChart object in your models, you may want to place and size it,
                      then secure the User Object to prevent inadvertent changes.
         
                      Since StakBarChart is a User Object, you may want to examine it to see how
                      the barchart is generated.  Some advanced techniques are used to generate
                      the bar fill using the YPlot "Traces & Scales" menu to set the "Point" style
                      to fill-mode.
        )
       )
       (views
        (icon
         (origin 410 415)
         (extent 78 25)
        )
        (detail
         (origin 25 209)
         (extent 848 437)
         (editing disabled)
        )
        (active icon)
       )
      )
      (configuration
      )
      (ShowOnExecPanel
       (origin 0 43)
       (extent 849 571)
       (panel
        (origin 38 164)
        (extent 845 533)
        (widget 0 icon
         (title off)
         (origin 437 649)
         (extent 58 37)
        )
        (widget 1 detail
         (title off)
         (origin 46 175)
         (extent 832 463)
         (editing disabled)
        )
       )
      )
     )
     (views
      (icon
       (origin 352 418)
       (extent 217 25)
      )
      (detail
       (origin 17 160)
       (extent 866 520)
       (configuration
       )
      )
      (active icon)
     )
    )
    (configuration
     (connect D1:1 D0:1)
     (connect D2:0 D1:1)
     (connect D0:1 D2:0)
    )
   )
   (views
    (icon
     (origin 415 408)
     (extent 110 25)
    )
    (panel
     (origin 21 122)
     (extent 319 77)
     (widget 1 icon
      (title off)
      (origin 123 135)
      (extent 114 39)
      (format button)
     )
    )
    (detail
     (origin 4 115)
     (extent 912 591)
     (configuration
      (connect D1:1 D0:1
       (Point 317 362)
       (Point 362 362)
      )
      (connect D2:0 D1:1
       (Point 460 445)
       (Point 460 460)
       (Point 180 460)
       (Point 180 362)
       (Point 198 362)
      )
      (connect D0:1 D2:0
       (Point 413 352)
       (Point 460 352)
       (Point 460 415)
      )
     )
    )
    (active panel)
    (active panel)
   )
  )
  (configuration
   (connect D3:1 D0:1)
   (connect D3:2 D1:1)
   (connect D3:1 D4:1)
   (connect D3:2 D4:2)
  )
 )
 (views
  (panel
   (origin 0 67)
   (extent 850 558)
   (widget 2 detail
    (title on)
    (origin 416 118)
    (extent 397 82)
    (editing disabled)
   )
   (widget 5 panel
    (title on)
    (origin 29 118)
    (extent 319 77)
    (widget 1 icon
     (title off)
     (origin 131 131)
     (extent 114 39)
     (format button)
    )
   )
   (widget 0 detail
    (title on)
    (origin 30 268)
    (extent 137 315)
   )
   (widget 1 detail
    (title on)
    (origin 186 268)
    (extent 142 315)
   )
   (widget 4 panel
    (title on)
    (origin 349 268)
    (extent 466 315)
    (widget 0 detail
     (title off)
     (origin 353 273)
     (extent 458 305)
     (displayMode annotGraph)
     (graphType cartesian)
     (gridType frame)
     (scale 0
      (name "Y name")
      (domainName "X name")
      (pen 1)
      (show 1)
      (range 0 30 4 linear)
     )
     (domain 0 10 4 linear)
     (trace 0 onScale 0
      (name "Trace1")
      (pen 7)
      (lineType 1)
      (pointType 6)
     )
     (trace 1 onScale 0
      (name "Trace2")
      (pen 4)
      (lineType 1)
      (pointType 6)
     )
    )
   )
  )
  (detail
   (origin 0 67)
   (extent 935 615)
   (configuration
    (connect D3:1 D0:1
     (Point 368 340)
     (Point 400 340)
     (Point 400 220)
     (Point 850 220)
     (Point 850 270)
     (Point 863 270)
    )
    (connect D3:2 D1:1
     (Point 368 500)
     (Point 400 500)
     (Point 400 600)
     (Point 863 600)
    )
    (connect D3:1 D4:1
     (Point 368 340)
     (Point 390 340)
     (Point 390 360)
     (Point 416 360)
    )
    (connect D3:2 D4:2
     (Point 368 500)
     (Point 416 500)
    )
   )
  )
  (active panel)
  (active panel)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
