#! /usr/lib/veetest/veetest -r
(revision "B.00.00")
(date "Mon 09/Nov/1992")
(component 0 "ROOTCONTEXT"
 (name "Read/Write File Example")
 (interface
 )
 (implementation
  (locked no)
  (trigMode deg)
  (nextID 15)
  (component 0 "TEXTDISPLAY"
   (name "DATA FROM FILE")
   (interface
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 0)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (origin 377 308)
     (extent 136 25)
    )
    (detail
     (origin 575 390)
     (extent 210 40)
    )
    (active detail)
   )
  )
  (component 1 "SHELLESCAPE"
   (name "sh -c \"rm Data File\"")
   (description 15 4
    This Execute Program is used to run a unix ksh
    shell with the "rm" command on the default
    file.  
    
    For the advanced student, remember that a unix
    rm performs an "unlink" operation that removes
    the directory entry with the filename but does
    not actually delete the file until after all
    processes have closed the file.  In this example,
    the "rm" does the unlink, but the file is not
    removed until "Post Run" that occurs when STOP
    is executed.  You may want to place a From File
    device _after_ this device to verify that data
    can still be accessed even when the file has been
    removed from the directory. 
   )
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Exit code")
     (lock name constraints)
    )
   )
   (implementation
    (attr iopath pipe read "pipe"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (attr iopath pipe write "pipe"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (component shell "sh")
    (component command "rm /tmp/example.data")
    (component deathWait "Yes")
   )
   (views
    (icon
     (origin 465 628)
     (extent 190 25)
    )
    (detail
     (origin 331 572)
     (extent 388 116)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 2 "EXITPROCESS"
   (name "Stop")
   (interface
    (sequence in)
   )
   (implementation
    (comp code 0)
   )
   (views
    (icon
     (origin 537 668)
     (extent 46 25)
    )
    (detail
     (origin 506 513)
     (extent 129 34)
    )
    (active icon)
   )
  )
  (component 3 "DELAY"
   (name "0.5 Sec")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (component delay 0.5)
   )
   (views
    (icon
     (origin 711 618)
     (extent 78 25)
    )
    (detail
     (origin 757 443)
     (extent 147 34)
    )
    (active icon)
   )
  )
  (component 4 "TOFILE"
   (name "Write new Data to File")
   (description 10 4
    This To File device first rewinds the file (sets
    the output file pointer back to beginning of file),
    then writes the new value to the file.
    
    The Write Mode, as set via the Clear File At 
    PreRun & Open box, must Overwrite (box checked), 
    since rewinding is not allowed in Append mode.  
    Remember that all To File devices that write to 
    the same file name will SHARE a common Write Mode 
    selection; changing it for one changes it for all.
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
   )
   (implementation
    (attr iopath file write "/tmp/example.data"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (procedure
      EXECUTE REWIND
      WRITE TEXT a EOL
    )
   )
   (views
    (icon
     (origin 626 598)
     (extent 208 25)
    )
    (detail
     (origin 620 498)
     (extent 271 105)
    )
    (terminals on)
    (active detail)
   )
  )
  (component 5 "TOFILE"
   (name "No, create defaultfile")
   (description 13 4
    If the file errors during rewind, we will assume
    that it doesn't exist.  (To be extremely robust,
    the error number should indicate "file not found",
    since a few other errors could cause the rewind to
    fail.)
    
    This ToFile writes an initial value to the file.
    Although it doesn't matter whether the Write Mode
    is Append or Overwrite when the file is first
    created, remember that ALL ToFile devices with
    the same file name will SHARE a common Write Mode!
    (The file is in Overwrite mode when the Clear File
    At PreRun & Open box is checked.)
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
   )
   (implementation
    (attr iopath file write "/tmp/example.data"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (procedure
      WRITE TEXT "200" EOL
    )
   )
   (views
    (icon
     (origin 486 288)
     (extent 208 25)
    )
    (detail
     (origin 589 229)
     (extent 273 103)
    )
    (terminals on)
    (active detail)
   )
  )
  (component 6 "FORMULA"
   (name " - ")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "X")
     (lock name)
    )
    (input 2
     (type data)
     (name "Y")
     (lock name)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked yes)
    (component expr 1 "X-Y")
   )
   (views
    (icon
     (origin 367 588)
     (extent 46 25)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 7 "IFTHENELSE"
   (name "A >= 0")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Then")
     (lock name constraints)
    )
    (output 2
     (type data)
     (name "Else")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr "a>=0")
   )
   (views
    (icon
     (origin 451 588)
     (extent 78 25)
    )
    (detail
     (origin 449 578)
     (extent 73 104)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 8 "FROMFILE"
   (name "Does File Exist?")
   (description 18 4
    The recommended way to determine if a file exists
    is to REWIND it in a From File device.  If the
    file does not exist, an error is generated. 
    
    For our application, we also want to insure that
    the data in the file can be read.  The second
    transaction reads one Real number into the "null"
    variable.  (Null accepts and then discards all
    data sent to it.)
    
    Why would a REWIND in a TO File not be a good way
    to test for file existence?  Remember that a file
    opened for Write can be in Append or Overwrite
    mode, and Rewind is illegal in append.  (The file
    is in Overwrite mode when the Clear File At PreRun
    & Open box is checked.)  Also, opening a To File 
    will create an empty file if one does not exist.
    
   )
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type exception)
     (name "Error")
     (lock name constraints)
     (optional yes)
    )
   )
   (implementation
    (attr iopath file read "/tmp/example.data"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (procedure
      EXECUTE REWIND
      READ TEXT null REAL
    )
   )
   (views
    (icon
     (origin 93 348)
     (extent 154 25)
    )
    (detail
     (origin 42 235)
     (extent 287 90)
    )
    (terminals on)
    (active detail)
   )
  )
  (component 9 "REPEATUNTILBREAK"
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Continuous")
     (lock name constraints)
    )
   )
   (implementation
   )
   (views
    (icon
     (origin 145 348)
     (extent 110 64)
     (iconImage "loop.icon")
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 10 "FROMFILE"
   (name "Read the data from file")
   (description 16 4
    Each time through the loop, we read the data that
    was last written to the file.  We must always
    REWIND the file before reading to insure the
    READ transaction will not hit an EOF.
    
    IMPORTANT:  Rewinding the "read" file pointer will
    rewind all From File devices with the same data
    file name, since all share a common File pointer.
    
    However, this has no effect on a ToFile device
    write file pointer for the same file name.  The
    existence of two file pointers, one for reading
    and one for writing, may seem strange, but it does
    allow one thread to write ahead of another thread
    that is reading and processing the data.
    
   )
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "X")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (attr iopath file read "/tmp/example.data"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (procedure
      EXECUTE REWIND
      READ TEXT x REAL
    )
   )
   (views
    (icon
     (origin 327 498)
     (extent 217 25)
    )
    (detail
     (origin 107 453)
     (extent 326 94)
    )
    (terminals on)
    (active detail)
   )
  )
  (component 11 "CONSTANT"
   (name "Amt to Deduct")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Amt to Deduct")
     (datum 25)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (name "Real")
     (datum 0)
    )
   )
   (views
    (icon
     (origin 97 428)
     (extent 127 25)
    )
    (detail
     (origin 80 596)
     (extent 201 28)
    )
    (active detail)
   )
  )
  (component 12 "NOTE"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 4 5
     This example is provided as an
     illustration "as is", and Hewlett-Packard
     Company makes no warranty of any kind
     with regard to this example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 570 98)
     (extent 401 84)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 13 "NOTE"
   (interface
   )
   (implementation
    (component text 4 5
     Press RUN to operate
     this example.  Most
     devices have a Show
     Description info box.
    )
   )
   (views
    (icon
    )
    (detail
     (origin 347 100)
     (extent 206 81)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 14 "CONTEXT"
   (name "Press For")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (locked no)
    (trigMode deg)
    (nextID 4)
    (component 0 "IFTHENELSE"
     (name "If != 0")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a!=0")
     )
     (views
      (icon
       (origin 301 332)
       (extent 78 25)
      )
      (detail
       (origin 299 278)
       (extent 73 64)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "TOGGLE"
     (name "Info About")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Reset")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Info About")
       (values range 0 1)
       (datum 0)
      )
      (component autoTrigger on)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (name "LongInt")
       (datum 0)
      )
     )
     (views
      (icon
       (origin 153 325)
       (extent 114 39)
       (format button)
      )
      (detail
       (origin 320 203)
       (extent 42 54)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "REPEATUNTILBREAK"
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Continuous")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 75 248)
       (extent 110 64)
       (iconImage "loop.icon")
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 3 "CONTEXT"
     (name "Info About This Example")
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (locked no)
      (trigMode deg)
      (nextID 2)
      (component 0 "CONFIRM"
       (name "DONE")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 637 629)
         (extent 58 37)
        )
        (detail
         (origin 466 633)
         (extent 79 34)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "NOTE"
       (name "NotePad")
       (interface
       )
       (implementation
        (component text 24 9
         PURPOSE:  Illustrate how to save data between successive executions of a program by
                   writing the latest data to a file after reading and modifying data previously
                   written to the same file.
         
         USER INPUT REQUIRED:  Press RUN several times, watching the program deduct a constant
                   value from the data value in the file.  You may want to use the Edit menu to
                   enable "Show Execution Flow" before running so you can see the operation of
                   the program.
         
         EXPLANATION:  Most devices have a "Show Description" dialog box that can be viewed by
                   selecting this from the device's Object Menu.  Detailed explanation for each
                   device is found there.
         
                   Several techniques are illustrated in this example, such as: a) How to
                   determine if a file exists, and if not how to create it; b) How to read and
                   write data to and from the same file (possible because there are two file
                   pointers -- one to retain the current position for writing data and another
                   to retain the position for reading data);  c) How to continually "overwrite"
                   data in a file instead of appending each new data to the end of existing 
                   data; 
         
                   These techniques are useful in cases where calibration data must be read and
                   updated from a file or where "global" data must be saved between subsequent
                   executions of a Vee program.
        )
       )
       (views
        (icon
         (origin 628 568)
         (extent 78 25)
        )
        (detail
         (origin 16 146)
         (extent 848 437)
         (editing enabled)
        )
        (active icon)
       )
      )
      (configuration
      )
      (ShowOnExecPanel
       (origin 55 78)
       (extent 849 561)
       (panel
        (origin 18 168)
        (extent 845 533)
        (widget 1 detail
         (title off)
         (origin 31 180)
         (extent 816 465)
         (editing disabled)
        )
        (widget 0 icon
         (title off)
         (origin 417 653)
         (extent 58 37)
        )
       )
      )
     )
     (views
      (icon
       (origin 332 422)
       (extent 217 25)
      )
      (detail
       (origin 228 309)
       (extent 405 230)
       (configuration
       )
       (stackingOrder 0 1)
      )
      (active icon)
     )
    )
    (configuration
     (connect D1:1 D0:1)
     (connect D2:1 D1:0)
     (connect D3:0 D1:1)
     (connect D0:1 D3:0)
    )
   )
   (views
    (icon
     (origin 475 648)
     (extent 110 25)
    )
    (panel
     (origin 11 102)
     (extent 319 77)
     (widget 1 icon
      (title off)
      (origin 113 115)
      (extent 114 39)
      (format button)
     )
    )
    (detail
     (origin 4 115)
     (extent 912 591)
     (configuration
      (connect D1:1 D0:1
       (Point 269 344)
       (Point 298 344)
      )
      (connect D2:1 D1:0
       (Point 187 280)
       (Point 210 280)
       (Point 210 322)
      )
      (connect D3:0 D1:1
       (Point 440 449)
       (Point 440 470)
       (Point 130 470)
       (Point 130 344)
       (Point 150 344)
      )
      (connect D0:1 D3:0
       (Point 381 334)
       (Point 440 334)
       (Point 440 419)
      )
     )
     (stackingOrder 0 1 2 3)
    )
    (active panel)
    (active panel)
   )
  )
  (configuration
   (connect D10:1 D0:1)
   (connect D7:2 D1:0)
   (connect D1:0 D2:0)
   (connect D4:0 D3:0)
   (connect D7:1 D4:0)
   (connect D6:1 D4:1)
   (connect D8:1 D5:1)
   (connect D10:1 D6:1)
   (connect D11:1 D6:2)
   (connect D6:1 D7:1)
   (connect D8:0 D9:0)
   (connect D9:1 D10:0)
  )
 )
 (views
  (detail
   (origin 0 62)
   (extent 980 643)
   (configuration
    (connect D10:1 D0:1
     (Point 465 500)
     (Point 490 500)
     (Point 490 410)
     (Point 572 410)
    )
    (connect D7:2 D1:0
     (Point 531 610)
     (Point 560 610)
     (Point 560 625)
    )
    (connect D1:0 D2:0
     (Point 560 655)
     (Point 560 665)
    )
    (connect D4:0 D3:0
     (Point 750 605)
     (Point 750 615)
    )
    (connect D7:1 D4:0
     (Point 531 590)
     (Point 550 590)
     (Point 550 450)
     (Point 750 450)
     (Point 750 467)
    )
    (connect D6:1 D4:1
     (Point 415 600)
     (Point 430 600)
     (Point 430 580)
     (Point 490 580)
     (Point 490 550)
     (Point 577 550)
    )
    (connect D8:1 D5:1
     (Point 391 280)
     (Point 546 280)
    )
    (connect D10:1 D6:1
     (Point 465 500)
     (Point 490 500)
     (Point 490 540)
     (Point 480 540)
     (Point 480 570)
     (Point 364 570)
     (Point 364 590)
    )
    (connect D11:1 D6:2
     (Point 283 610)
     (Point 364 610)
    )
    (connect D6:1 D7:1
     (Point 415 600)
     (Point 448 600)
    )
    (connect D8:0 D9:0
     (Point 200 327)
     (Point 200 345)
    )
    (connect D9:1 D10:0
     (Point 257 380)
     (Point 270 380)
     (Point 270 422)
    )
   )
   (stackingOrder 0 2 4 5 6 7 8 10 11 12
     13 9 1 14 3)
  )
  (active detail)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
