#! /usr/lib/veetest/veetest -r
(revision "A.00.00")
(date "Tue 02/Apr/1991")
(component 0 "Context"
 (name "Conformal Mapping Example")
 (interface
 )
 (implementation
  (trigMode deg)
  (locked no)
  (component 0 "Constant"
   (name "Radius")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Radius")
     (datum 1.5)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
   )
   (views
    (icon
     (origin 101 358)
     (extent 78 25)
    )
    (detail
     (origin 41 546)
     (extent 138 28)
    )
    (active detail)
   )
  )
  (component 1 "ToPComplex"
   (name "Build PComplex")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Mag")
     (requires
      (datatype Real)
     )
     (lock name constraints)
    )
    (input 2
     (type data)
     (name "Phase")
     (requires
      (datatype Real)
     )
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "PComplex")
     (lock name constraints)
    )
   )
   (implementation
   )
   (views
    (icon
     (origin 212 568)
     (extent 136 64)
     (iconImage build.icon)
    )
    (detail
     (origin 292 298)
     (extent 69 104)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 2 "AllocateArray"
   (name "angle(0..359)")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Array")
     (tag "Array")
     (lock constraints)
    )
   )
   (implementation
    (component numDims 1)
    (component dimSizes "360")
    (component type "Real")
    (component initEnum "Lin Ramp")
    (component initialValue
     (name "Init Value")
     (datum 1.5)
    )
    (component from 0)
    (component thru 359)
   )
   (views
    (icon
     (origin 47 608)
     (extent 127 25)
    )
    (detail
     (origin 35 580)
     (extent 221 120)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 3 "Note"
   (name "Note Pad")
   (interface
   )
   (implementation
    (component text 8 5
     Conformal Mapping in the Complex Plane
                w = 1/2*(z+1/z)
     
                  TO OPERATE:
     Use the Sliders below to adjust the
     center point of the circle data along
     the Real and Imaginary axis and examine
     the resulting curves on the display.
    )
   )
   (views
    (icon
     (origin 395 598)
     (extent 110 25)
    )
    (detail
     (origin 542 249)
     (extent 376 62)
     (editing enabled)
    )
    (active icon)
   )
  )
  (component 4 "YPlot"
   (name "Complex Plane")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "C. map")
     (lock constraints)
    )
    (input 2
     (type data)
     (name "circle")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
    (component tracePin 1)
    (component tracePin 2)
    (component graphMode complex)
   )
   (views
    (icon
     (iconImage display.icon)
    )
    (detail
     (origin 617 370)
     (extent 326 280)
     (displayMode annotGraph)
     (graphType cartesian)
     (gridType axis)
     (scale 0
      (name "Imag")
      (domainName "Real")
      (color 0x909090)
      (show 1)
      (range -2.5 2.5 4 linear)
     )
     (domain -2.5 2.5 4 linear)
     (trace 0 onScale 0
      (name "C. map")
      (color 0xffdd00)
      (lineType 1)
      (pointType 0)
     )
     (trace 1 onScale 0
      (name "circle")
      (color 0xccff)
      (lineType 1)
      (pointType 0)
     )
     (markerInterpolate 1)
    )
    (active detail)
   )
  )
  (component 5 "Formula"
   (name "Formula")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "z")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "1/2*(z+1/z)")
   )
   (views
    (icon
     (origin 361 228)
     (extent 78 64)
     (iconImage formula.icon)
    )
    (detail
     (origin 389 413)
     (extent 133 54)
    )
    (terminals on)
    (active detail)
   )
  )
  (component 6 "Formula"
   (name " + ")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "X")
     (lock name constraints)
    )
    (input 2
     (type data)
     (name "Y")
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked yes)
    (component expr 1 "X+Y")
   )
   (views
    (icon
     (origin 267 428)
     (extent 46 25)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 7 "ToComplex"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Real")
     (requires
      (datatype Real)
     )
     (lock name constraints)
    )
    (input 2
     (type data)
     (name "Imag")
     (requires
      (datatype Real)
     )
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Complex")
     (lock name constraints)
    )
   )
   (implementation
   )
   (views
    (icon
     (origin 47 398)
     (extent 127 64)
     (iconImage build.icon)
    )
    (detail
     (origin 460 565)
     (extent 70 110)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 8 "Note"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 4 5
     This example is provided as an
     illustration "as is", and Hewlett-Packard
     Company makes no warranty of any kind
     with regard to this example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 522 239)
     (extent 397 82)
     (editing enabled)
    )
    (active detail)
   )
  )
  (component 9 "Context"
   (name "Press For")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "IfThenElse"
     (name "!= 0")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a!=0")
     )
     (views
      (icon
       (origin 365 340)
       (extent 46 25)
      )
      (detail
       (origin 209 308)
       (extent 73 64)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "Toggle"
     (name "Info About")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Reset")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Info About")
       (values range 0 1)
       (datum 0)
      )
      (component autoTrigger on)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (datum 0)
      )
     )
     (views
      (icon
       (origin 201 333)
       (extent 114 39)
       (format button)
      )
      (detail
       (origin 320 203)
       (extent 42 54)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "Context"
     (name "Info About This Example")
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Note"
       (name "NotePad")
       (interface
       )
       (implementation
        (component text 34 9
         PURPOSE:     To illustrate generating, adding, processing, and displaying Complex and
                      Polar Complex numbers
                  
         USER INPUT REQUIRED:  Adjust Center of Circle on the Real and Imag axis.
                  
         EXPLANATION: The problem is to do a conformal mapping in the complex plane, with the
                      complex mapping equation of w=1/2*(z+1/z)  [which is a very popular
                      equation for such things].  The input data that makes this interesting is
                      a circle of some radius offset from the origin by some amount.  We don't
                      want to have to figure out the equation of a circle [since we don't have
                      a high school geometry student near by], and to keep it fast, we don't 
                      want to use a loop.
         
                      The first task is to generate the circle by feeding a "Build PComplex"
                      object a fixed radius and a set of angles from 0 to 360 degrees.  
         
                      The second task is generating the set of angles with an "Allocate Real
                      Array" object using ramp initialization.  That device is a good loop
                      substitute when using parallel math to apply an operation to an entire
                      array simultaneously.
         
                      Task number 3 is offsetting the circle.  Rather than having nightmares of 
                      cosines and x^2's, all that is needed is to create a RECTANGULAR 
                      "Complex" constant, and add it to the PComplex array just built.  HP-VEE 
                      takes care of all the conversions automatically.
         
                      The final step is easy... just run the Complex array (or is it PComplex, 
                      we don't care!!) through a formula box with the above equation, which 
                      will be evaluated using complex math.  A "Complex Plane" display shows 
                      the resulting output nicely.
         
                      It's interesting to play with the Radius and Center input parameters to
                      see how they change things.  Note that they are quite sensitive.
         
        )
       )
       (views
        (description 2 9
         This notepad is displayed as a Show on Execute
         panel to present the information to the reader.
        )
        (icon
         (origin 160 185)
         (extent 78 25)
        )
        (detail
         (origin 36 162)
         (extent 848 437)
         (editing enabled)
        )
        (active icon)
       )
      )
      (component 1 "Confirm"
       (name "DONE")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (description 7 9
         This tiny "thread" begins running when the 
         enclosing UserObject is executed.  When the user
         acknowledges the OK/DONE button, there is nothing
         left to execute, so the thread ends.  Since there
         are not other threads running, the User Object
         is completed and will exit, removing the Show on
         Execute pop-up display.
        )
        (icon
         (origin 171 252)
         (extent 58 37)
        )
        (detail
         (origin 156 253)
         (extent 79 34)
        )
        (terminals on)
        (active icon)
       )
      )
      (configuration
      )
      (ShowOnExecPanel
       (origin 55 78)
       (extent 849 571)
       (panel
        (origin 58 144)
        (extent 845 533)
        (widget 0 detail
         (title off)
         (origin 71 156)
         (extent 816 465)
         (editing enabled)
        )
        (widget 1 icon
         (title off)
         (origin 457 629)
         (extent 58 37)
        )
       )
      )
     )
     (views
      (icon
       (origin 352 408)
       (extent 217 25)
      )
      (detail
       (origin 17 140)
       (extent 866 520)
       (configuration
       )
      )
      (active icon)
     )
    )
    (configuration
     (connect D1:1 D0:1)
     (connect D2:0 D1:1)
     (connect D0:1 D2:0)
    )
   )
   (views
    (icon
     (origin 445 408)
     (extent 110 25)
    )
    (panel
     (origin 521 112)
     (extent 319 77)
     (widget 1 icon
      (title off)
      (origin 623 125)
      (extent 114 39)
      (format button)
     )
    )
    (detail
     (origin 4 115)
     (extent 912 591)
     (configuration
      (connect D1:1 D0:1
       (Point 317 352)
       (Point 362 352)
      )
      (connect D2:0 D1:1
       (Point 460 435)
       (Point 460 450)
       (Point 180 450)
       (Point 180 352)
       (Point 198 352)
      )
      (connect D0:1 D2:0
       (Point 413 342)
       (Point 460 342)
       (Point 460 405)
      )
     )
    )
    (active panel)
    (active panel)
   )
  )
  (component 10 "Slider"
   (name "Center Real")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type control)
     (name "MaxValue")
     (tag "MaxValue")
     (requires
      (datatype Real)
      (shape "Scalar")
     )
     (lock constraints)
     (optional yes)
    )
    (input 2
     (type control)
     (name "MinValue")
     (tag "MinValue")
     (requires
      (datatype Real)
      (shape "Scalar")
     )
     (lock constraints)
     (optional yes)
    )
    (output 1
     (type data)
     (name "Real")
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Center Real")
     (values range -2 2)
     (datum -0.252)
    )
    (component autoTrigger on)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
    (component detents 0.001)
   )
   (views
    (icon
     (extent 110 0)
    )
    (detail
     (origin 260 201)
     (extent 181 138)
    )
    (active detail)
   )
  )
  (component 11 "Junction"
   (name "JCT")
   (interface
    (input 1
     (type data)
     (name "A")
     (lock name constraints)
    )
    (input 2
     (type data)
     (name "B")
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Data")
     (lock name constraints)
    )
   )
   (implementation
   )
   (views
    (icon
     (origin 257 128)
     (extent 46 25)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 12 "Start"
   (interface
    (sequence out)
   )
   (implementation
   )
   (views
    (icon
     (origin 147 82)
     (extent 67 37)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 13 "Slider"
   (name "Center Imag")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type control)
     (name "MaxValue")
     (tag "MaxValue")
     (requires
      (datatype Real)
      (shape "Scalar")
     )
     (lock constraints)
     (optional yes)
    )
    (input 2
     (type control)
     (name "MinValue")
     (tag "MinValue")
     (requires
      (datatype Real)
      (shape "Scalar")
     )
     (lock constraints)
     (optional yes)
    )
    (output 1
     (type data)
     (name "Real")
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Center Imag")
     (values range -2 2)
     (datum 0.487)
    )
    (component autoTrigger on)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
    (component detents 0.001)
   )
   (views
    (icon
     (extent 110 0)
    )
    (detail
     (origin 30 201)
     (extent 161 138)
    )
    (active detail)
   )
  )
  (configuration
   (connect D7:0 D0:0)
   (connect D0:1 D1:1)
   (connect D2:1 D1:2)
   (connect D0:0 D2:0)
   (connect D5:1 D4:1)
   (connect D6:1 D4:2)
   (connect D6:1 D5:1)
   (connect D7:1 D6:1)
   (connect D1:1 D6:2)
   (connect D10:1 D7:1)
   (connect D13:1 D7:2)
   (connect D11:1 D10:0)
   (connect D12:0 D11:1)
   (connect D13:0 D11:2)
   (connect D10:0 D13:0)
  )
 )
 (views
  (panel
   (origin 0 67)
   (extent 1000 673)
   (widget 4 detail
    (title on)
    (origin 424 271)
    (extent 528 403)
    (displayMode annotGraph)
    (graphType cartesian)
    (gridType axis)
    (scale 0
     (name "Imag")
     (domainName "Real")
     (color 0x909090)
     (show 1)
     (range -2.5 2.5 4 linear)
    )
    (domain -2.5 2.5 4 linear)
    (trace 0 onScale 0
     (name "C. map")
     (color 0xffdd00)
     (lineType 1)
     (pointType 0)
    )
    (trace 1 onScale 0
     (name "circle")
     (color 0xccff)
     (lineType 1)
     (pointType 0)
    )
    (markerInterpolate 1)
   )
   (widget 3 detail
    (title on)
    (origin 22 272)
    (extent 373 154)
    (editing disabled)
   )
   (widget 13 detail
    (title on)
    (origin 239 491)
    (extent 156 178)
   )
   (widget 10 detail
    (title on)
    (origin 25 492)
    (extent 156 178)
   )
   (widget 8 detail
    (title on)
    (origin 501 119)
    (extent 397 82)
    (editing disabled)
   )
   (widget 9 panel
    (title on)
    (origin 43 122)
    (extent 319 77)
    (widget 1 icon
     (title off)
     (origin 145 135)
     (extent 114 39)
     (format button)
    )
   )
  )
  (detail
   (origin 0 67)
   (extent 935 615)
   (configuration
    (connect D7:0 D0:0
     (Point 110 464)
     (Point 110 513)
    )
    (connect D0:1 D1:1
     (Point 181 560)
     (Point 190 560)
     (Point 190 580)
     (Point 209 580)
    )
    (connect D2:1 D1:2
     (Point 176 620)
     (Point 209 620)
    )
    (connect D0:0 D2:0
     (Point 110 576)
     (Point 110 605)
    )
    (connect D5:1 D4:1
     (Point 594 440)
     (Point 614 440)
    )
    (connect D6:1 D4:2
     (Point 315 440)
     (Point 330 440)
     (Point 330 490)
     (Point 380 490)
     (Point 380 580)
     (Point 614 580)
    )
    (connect D6:1 D5:1
     (Point 315 440)
     (Point 346 440)
    )
    (connect D7:1 D6:1
     (Point 176 430)
     (Point 264 430)
    )
    (connect D1:1 D6:2
     (Point 350 600)
     (Point 370 600)
     (Point 370 550)
     (Point 250 550)
     (Point 250 450)
     (Point 264 450)
    )
    (connect D10:1 D7:1
     (Point 443 270)
     (Point 460 270)
     (Point 460 360)
     (Point 360 360)
     (Point 360 370)
     (Point 20 370)
     (Point 20 410)
     (Point 44 410)
    )
    (connect D13:1 D7:2
     (Point 193 270)
     (Point 210 270)
     (Point 210 360)
     (Point 10 360)
     (Point 10 450)
     (Point 44 450)
    )
    (connect D11:1 D10:0
     (Point 305 140)
     (Point 350 140)
     (Point 350 168)
    )
    (connect D12:0 D11:1
     (Point 180 121)
     (Point 180 140)
     (Point 230 140)
     (Point 230 130)
     (Point 254 130)
    )
    (connect D13:0 D11:2
     (Point 110 341)
     (Point 110 350)
     (Point 10 350)
     (Point 10 150)
     (Point 254 150)
    )
    (connect D10:0 D13:0
     (Point 350 341)
     (Point 350 360)
     (Point 240 360)
     (Point 240 160)
     (Point 110 160)
     (Point 110 168)
    )
   )
  )
  (active panel)
  (active panel)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
