#! /usr/lib/veetest/veetest -r
(revision "B.00.00")
(date "Fri 23/Oct/1992")
(component 0 "ROOTCONTEXT"
 (name "Future Value Example")
 (interface
 )
 (implementation
  (locked no)
  (trigMode rad)
  (nextID 14)
  (component 0 "CONSTANT"
   (name "Goal, Time")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Int32
     (name "Goal, Time")
     (datum 25)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Int32
     (name "LongInt")
     (datum 0)
    )
   )
   (views
    (icon
     (extent 110 0)
    )
    (detail
     (origin 13 311)
     (extent 174 28)
     (showFormat int)
    )
    (active detail)
   )
  )
  (component 1 "CONSTANT"
   (name "Goal, FV")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Goal, FV")
     (datum 500000)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (name "Real")
     (datum 0)
    )
   )
   (views
    (icon
     (extent 110 0)
    )
    (detail
     (origin 12 241)
     (extent 156 28)
     (showFormat real)
    )
    (active detail)
   )
  )
  (component 2 "CONSTANT"
   (name "Max # Periods")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Int32
     (name "Max # Periods")
     (datum 40)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Int32
     (name "LongInt")
     (datum 0)
    )
   )
   (views
    (icon
     (origin 37 358)
     (extent 127 25)
    )
    (detail
     (origin 12 382)
     (extent 176 27)
     (showFormat int)
    )
    (active detail)
   )
  )
  (component 3 "CONSTANT"
   (name "Principal")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Principal")
     (datum 10000)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (name "Real")
     (datum 0)
    )
   )
   (views
    (icon
     (extent 110 0)
    )
    (detail
     (origin 18 451)
     (extent 165 28)
     (showFormat real)
    )
    (active detail)
   )
  )
  (component 4 "NOTE"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 4 5
     This example is provided as an
     illustration "as is", and Hewlett-Packard
     Company makes no warranty of any kind
     with regard to this example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 14 105)
     (extent 393 81)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 5 "FORMULA"
   (name "Interest")
   (description 4 4
    This "Math -> Formula" object calculates the
    Interest rate, in percent, that will satisfy
    the intersection of the Time and Future Value
    goals.
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "FV")
     (optional yes)
    )
    (input 2
     (type data)
     (name "N")
     (optional yes)
    )
    (input 3
     (type data)
     (name "PV")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "round(((FV/PV)^(1/N)-1)*10K)/100+\" %\"")
   )
   (views
    (icon
     (origin 289 387)
     (extent 102 36)
    )
    (detail
     (origin 253 586)
     (extent 385 129)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 6 "CONTEXT"
   (name "Secured Int")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Step %")
     (lock constraints)
     (optional yes)
    )
    (output 2
     (type data)
     (name "Thru %")
     (lock constraints)
     (optional yes)
    )
    (output 3
     (type data)
     (name "From %")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (locked yes)
    (trigMode rad)
    (nextID 4)
    (component 0 "CONSTANT"
     (name "Thru %")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Real
       (name "Thru %")
       (datum 20)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Real
       (name "Real")
       (datum 0)
      )
     )
    )
    (component 1 "CONSTANT"
     (name "Step %")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Real
       (name "Step %")
       (datum 2)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Real
       (name "Real")
       (datum 0)
      )
     )
    )
    (component 2 "CONSTANT"
     (name "From %")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Real
       (name "From %")
       (datum 4)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Real
       (name "Real")
       (datum 0)
      )
     )
    )
    (component 3 "NOTE"
     (name "Interest Values:")
     (interface
     )
     (implementation
      (component text 5 7
       From %:
       
       Thru %:
       
       Step %:
      )
     )
    )
    (configuration
     (connect D1:1 O1:1)
     (connect D0:1 O2:1)
     (connect D2:1 O3:1)
    )
   )
   (views
    (icon
     (extent 110 0)
    )
    (panel
     (origin 11 520)
     (extent 198 150)
     (widget 3 detail
      (title on)
      (origin 16 559)
      (extent 187 105)
      (editing disabled)
     )
     (widget 2 detail
      (title off)
      (origin 91 563)
      (extent 110 30)
      (showFormat real)
     )
     (widget 0 detail
      (title off)
      (origin 91 598)
      (extent 109 29)
      (showFormat real)
     )
     (widget 1 detail
      (title off)
      (origin 91 631)
      (extent 108 28)
      (showFormat real)
     )
    )
    (active panel)
    (active panel)
   )
  )
  (component 7 "CONTEXT"
   (name "Secured Plot Display")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "MaxT")
     (optional yes)
    )
    (input 2
     (type data)
     (name "PrinVal")
     (optional yes)
    )
    (input 3
     (type data)
     (name "GoalMoney")
     (optional yes)
    )
    (input 4
     (type data)
     (name "GoalTime")
     (optional yes)
    )
    (input 5
     (type data)
     (name "FromI")
     (optional yes)
    )
    (input 6
     (type data)
     (name "ThruI")
     (optional yes)
    )
    (input 7
     (type data)
     (name "StepI")
     (optional yes)
    )
   )
   (implementation
    (locked yes)
    (trigMode rad)
    (nextID 11)
    (component 0 "TEXTDISPLAY"
     (name "#Plots")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
      )
     )
     (implementation
      (component clearAtPrerun 1)
      (component clearAtActivate 1)
     )
    )
    (component 1 "FORMULA"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "(A+1)+\" Plots by %\"")
     )
    )
    (component 2 "FORMULA"
     (name "maxIndex(x)")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "X")
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked yes)
      (component expr 1 "maxIndex(x)")
     )
    )
    (component 3 "TEXTDISPLAY"
     (name "Min %")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
      )
     )
     (implementation
      (component clearAtPrerun 1)
      (component clearAtActivate 1)
     )
    )
    (component 4 "TEXTDISPLAY"
     (name "Max %")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
      )
     )
     (implementation
      (component clearAtPrerun 1)
      (component clearAtActivate 1)
     )
    )
    (component 5 "FORMULA"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "min(A)+\" %\"")
     )
    )
    (component 6 "COLLECTOR"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
       (tag "Data")
      )
      (input 2
       (type trigger)
       (name "XEQ")
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "Array")
       (tag "Array")
       (lock constraints)
      )
     )
     (implementation
      (component clearAtPrerun 1)
      (component clearAtActivate 1)
      (component output1D YES)
     )
    )
    (component 7 "YPLOT"
     (name "Future Value vs. Time by % Rate")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Future Value")
       (lock constraints)
      )
      (input 2
       (type data)
       (name "Goal, Time")
       (lock constraints)
       (optional yes)
      )
      (input 3
       (type data)
       (name "Goal, Money")
       (lock constraints)
       (optional yes)
      )
      (input 4
       (type control)
       (name "Next Curve")
       (lock name constraints)
       (optional yes)
      )
     )
     (implementation
      (component clearAtPrerun 1)
      (component clearAtActivate 0)
      (component tracePin 1)
      (component tracePin 2)
      (component tracePin 3)
      (component graphMode rectangular)
     )
    )
    (component 8 "CONTEXT"
     (name "FutureVal")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "N")
       (optional yes)
      )
      (input 2
       (type data)
       (name "PV")
       (optional yes)
      )
      (input 3
       (type data)
       (name "I")
       (optional yes)
      )
      (output 1
       (type data)
       (name "FV")
       (lock constraints)
       (optional yes)
      )
     )
     (implementation
      (locked no)
      (trigMode rad)
      (nextID 3)
      (component 0 "FORMULA"
       (name "Formula")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "A")
         (optional yes)
        )
        (output 1
         (type data)
         (name "Result")
         (lock name constraints)
        )
       )
       (implementation
        (component isLocked no)
        (component expr 1 "ramp(A,1,A)")
       )
      )
      (component 1 "FORMULA"
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "n")
         (optional yes)
        )
        (input 2
         (type data)
         (name "pv")
         (optional yes)
        )
        (input 3
         (type data)
         (name "i")
         (optional yes)
        )
        (output 1
         (type data)
         (name "Result")
         (lock name constraints)
        )
       )
       (implementation
        (component isLocked no)
        (component expr 1 "pv*(1+i/100)^n")
       )
      )
      (component 2 "TOCOORDINATE"
       (name "Build Coord FV")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "X Data")
         (tag "X")
         (requires
          (datatype Real)
         )
         (lock constraints)
        )
        (input 2
         (type data)
         (name "Y Data")
         (tag "Y")
         (requires
          (datatype Real)
         )
         (lock constraints)
        )
        (output 1
         (type data)
         (name "Coord")
         (tag "Coord")
         (lock constraints)
        )
       )
       (implementation
       )
      )
      (configuration
       (connect I1:1 D0:1)
       (connect D0:1 D1:1)
       (connect I2:1 D1:2)
       (connect I3:1 D1:3)
       (connect D0:1 D2:1)
       (connect D1:1 D2:2)
       (connect D2:1 O1:1)
      )
     )
    )
    (component 9 "FORMULA"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "max(A)+\" %\"")
     )
    )
    (component 10 "FORRANGE"
     (name "Interest%")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "From")
       (tag "From")
       (requires
        (datatype Real)
        (shape "Scalar")
       )
       (lock constraints)
       (optional yes)
       (buffer YES)
      )
      (input 2
       (type data)
       (name "Thru")
       (tag "Thru")
       (requires
        (datatype Real)
        (shape "Scalar")
       )
       (lock constraints)
       (optional yes)
       (buffer YES)
      )
      (input 3
       (type data)
       (name "Step")
       (tag "Step")
       (requires
        (datatype Real)
        (shape "Scalar")
       )
       (lock constraints)
       (optional yes)
       (buffer YES)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component from 4)
      (component thru 20)
      (component step 2)
     )
    )
    (configuration
     (connect D1:1 D0:1)
     (connect D2:1 D1:1)
     (connect D6:1 D2:1)
     (connect D5:1 D3:1)
     (connect D9:1 D4:1)
     (connect D6:1 D5:1)
     (connect D10:1 D6:1)
     (connect D10:0 D6:2)
     (connect D8:1 D7:1)
     (connect I3:1 D7:2)
     (connect I4:1 D7:3)
     (connect D10:1 D7:4)
     (connect I1:1 D8:1)
     (connect I2:1 D8:2)
     (connect D10:1 D8:3)
     (connect D6:1 D9:1)
     (connect I5:1 D10:1)
     (connect I6:1 D10:2)
     (connect I7:1 D10:3)
    )
   )
   (views
    (icon
     (origin 635 383)
     (extent 190 74)
    )
    (panel
     (origin 494 114)
     (extent 492 523)
     (widget 7 detail
      (title on)
      (origin 499 153)
      (extent 481 472)
      (displayMode annotGraph)
      (graphType cartesian)
      (gridType grid)
      (scale 0
       (name "Money Units")
       (domainName "Time Periods")
       (pen 9)
       (show 1)
       (range 0 2000000 4 linear)
      )
      (domain 0 40 4 linear)
      (trace 0 onScale 0
       (name "Future Value")
       (pen 4)
       (lineType 1)
       (pointType 0)
      )
      (trace 1 onScale 0
       (name "Goal, Time")
       (pen 7)
       (lineType 1)
       (pointType 0)
      )
      (trace 2 onScale 0
       (name "Goal, Money")
       (pen 6)
       (lineType 1)
       (pointType 0)
      )
      (marker 0 onTrace 0)
      (marker 1 onTrace 1)
     )
     (widget 0 detail
      (title off)
      (origin 503 302)
      (extent 145 31)
      (formatter
       (realFormat standard)
       (realSigDigits 2)
       (realRadixSpec 2)
       (integerBase decimal)
      )
     )
     (widget 4 detail
      (title off)
      (origin 657 173)
      (extent 67 28)
      (formatter
       (realFormat standard)
       (realSigDigits 2)
       (realRadixSpec 2)
       (integerBase decimal)
      )
     )
     (widget 3 detail
      (title off)
      (origin 880 517)
      (extent 65 27)
      (formatter
       (realFormat standard)
       (realSigDigits 2)
       (realRadixSpec 2)
       (integerBase decimal)
      )
     )
    )
    (active panel)
    (active panel)
   )
  )
  (component 8 "TEXTDISPLAY"
   (name "Interest <- Goal")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 154 0)
    )
    (detail
     (origin 236 700)
     (extent 228 31)
     (formatter
      (realFormat fixed)
      (realSigDigits 4)
      (realRadixSpec 2)
      (integerBase decimal)
     )
    )
    (active detail)
   )
  )
  (component 9 "CONTEXT"
   (name "FV/Time Goals")
   (description 2 4
    This "Device -> UserObject" is used to calculate
    the FV and Time goal lines.
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (input 2
     (type data)
     (name "T")
     (optional yes)
    )
    (input 3
     (type data)
     (name "Tmax")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Time")
     (lock constraints)
     (optional yes)
    )
    (output 2
     (type data)
     (name "FV")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (locked no)
    (trigMode rad)
    (nextID 6)
    (component 0 "TOCOORDINATE"
     (name "Build Coord V")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "X Data")
       (tag "X")
       (requires
        (datatype Real)
       )
       (lock constraints)
      )
      (input 2
       (type data)
       (name "Y Data")
       (tag "Y")
       (requires
        (datatype Real)
       )
       (lock constraints)
      )
      (output 1
       (type data)
       (name "Coord")
       (tag "Coord")
       (lock constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 367 178)
       (extent 127 64)
       (iconImage "build.icon")
      )
      (detail
       (origin 450 585)
       (extent 71 110)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "TOCOORDINATE"
     (name "Build Coord H")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "X Data")
       (tag "X")
       (requires
        (datatype Real)
       )
       (lock constraints)
      )
      (input 2
       (type data)
       (name "Y Data")
       (tag "Y")
       (requires
        (datatype Real)
       )
       (lock constraints)
      )
      (output 1
       (type data)
       (name "Coord")
       (tag "Coord")
       (lock constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 367 358)
       (extent 127 64)
       (iconImage "build.icon")
      )
      (detail
       (origin 420 585)
       (extent 71 110)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "FORMULA"
     (name "Formula Hy")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "[A A]")
     )
     (views
      (icon
       (origin 205 398)
       (extent 110 25)
      )
      (detail
       (origin 196 369)
       (extent 79 63)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 3 "FORMULA"
     (name "Formula Hx")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "T")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "[1 T]")
     )
     (views
      (icon
       (origin 205 358)
       (extent 110 25)
      )
      (detail
       (origin 196 316)
       (extent 79 88)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 4 "FORMULA"
     (name "Formula Vy")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "ramp(11,1,10*A)")
     )
     (views
      (icon
       (origin 235 218)
       (extent 110 25)
      )
      (detail
       (origin 191 190)
       (extent 169 60)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 5 "FORMULA"
     (name "Formula Vx")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "T")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "ramp(11,T,T)")
     )
     (views
      (icon
       (origin 235 178)
       (extent 110 25)
      )
      (detail
       (origin 204 160)
       (extent 142 61)
      )
      (terminals on)
      (active icon)
     )
    )
    (configuration
     (connect D5:1 D0:1)
     (connect D4:1 D0:2)
     (connect D3:1 D1:1)
     (connect D2:1 D1:2)
     (connect I1:1 D2:1)
     (connect I3:1 D3:1)
     (connect I1:1 D4:1)
     (connect I2:1 D5:1)
     (connect D0:1 O1:1)
     (connect D1:1 O2:1)
    )
   )
   (views
    (icon
     (origin 257 248)
     (extent 127 54)
    )
    (detail
     (origin 149 110)
     (extent 322 340)
     (configuration
      (connect D5:1 D0:1
       (Point 347 190)
       (Point 364 190)
      )
      (connect D4:1 D0:2
       (Point 347 230)
       (Point 364 230)
      )
      (connect D3:1 D1:1
       (Point 317 370)
       (Point 364 370)
      )
      (connect D2:1 D1:2
       (Point 317 410)
       (Point 364 410)
      )
      (connect I1:1 D2:1
       (Point 151 170)
       (Point 160 170)
       (Point 160 230)
       (Point 180 230)
       (Point 180 410)
       (Point 202 410)
      )
      (connect I3:1 D3:1
       (Point 151 410)
       (Point 160 410)
       (Point 160 370)
       (Point 202 370)
      )
      (connect I1:1 D4:1
       (Point 151 170)
       (Point 160 170)
       (Point 160 230)
       (Point 232 230)
      )
      (connect I2:1 D5:1
       (Point 151 290)
       (Point 170 290)
       (Point 170 190)
       (Point 232 190)
      )
      (connect D0:1 O1:1
       (Point 496 210)
       (Point 510 210)
       (Point 510 170)
       (Point 460 170)
       (Point 460 200)
       (Point 468 200)
      )
      (connect D1:1 O2:1
       (Point 496 390)
       (Point 510 390)
       (Point 510 350)
       (Point 460 350)
       (Point 460 380)
       (Point 468 380)
      )
     )
     (stackingOrder 0 1 2 3 4 5)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 10 "CONTEXT"
   (name "Unsecured Plot")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "MaxT")
     (optional yes)
    )
    (input 2
     (type data)
     (name "PrinVal")
     (optional yes)
    )
    (input 3
     (type data)
     (name "GoalMoney")
     (optional yes)
    )
    (input 4
     (type data)
     (name "GoalTime")
     (optional yes)
    )
    (input 5
     (type data)
     (name "FromI")
     (optional yes)
    )
    (input 6
     (type data)
     (name "ThruI")
     (optional yes)
    )
    (input 7
     (type data)
     (name "StepI")
     (optional yes)
    )
   )
   (implementation
    (locked no)
    (trigMode rad)
    (nextID 11)
    (component 0 "TEXTDISPLAY"
     (name "#Plots")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
      )
     )
     (implementation
      (component clearAtPrerun 1)
      (component clearAtActivate 1)
     )
     (views
      (icon
       (extent 78 0)
      )
      (detail
       (origin 753 635)
       (extent 145 30)
       (formatter
        (realFormat standard)
        (realSigDigits 2)
        (realRadixSpec 2)
        (integerBase decimal)
       )
      )
      (active detail)
     )
    )
    (component 1 "FORMULA"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "(A+1)+\" Plots by %\"")
     )
     (views
      (icon
       (origin 656 638)
       (extent 78 25)
      )
      (detail
       (origin 643 554)
       (extent 205 53)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "FORMULA"
     (name "maxIndex(x)")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "X")
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked yes)
      (component expr 1 "maxIndex(x)")
     )
     (views
      (icon
       (origin 530 638)
       (extent 110 25)
      )
      (detail
       (origin 749 610)
       (extent 133 60)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 3 "TEXTDISPLAY"
     (name "Min %")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
      )
     )
     (implementation
      (component clearAtPrerun 1)
      (component clearAtActivate 1)
     )
     (views
      (icon
       (extent 78 0)
      )
      (detail
       (origin 795 575)
       (extent 100 30)
       (formatter
        (realFormat standard)
        (realSigDigits 2)
        (realRadixSpec 2)
        (integerBase decimal)
       )
      )
      (active detail)
     )
    )
    (component 4 "TEXTDISPLAY"
     (name "Max %")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
      )
     )
     (implementation
      (component clearAtPrerun 1)
      (component clearAtActivate 1)
     )
     (views
      (icon
       (extent 78 0)
      )
      (detail
       (origin 533 574)
       (extent 105 32)
       (formatter
        (realFormat standard)
        (realSigDigits 2)
        (realRadixSpec 2)
        (integerBase decimal)
       )
      )
      (active detail)
     )
    )
    (component 5 "FORMULA"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "min(A)+\" %\"")
     )
     (views
      (icon
       (origin 676 578)
       (extent 78 25)
      )
      (detail
       (origin 576 634)
       (extent 118 53)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 6 "COLLECTOR"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
       (tag "Data")
      )
      (input 2
       (type trigger)
       (name "XEQ")
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "Array")
       (tag "Array")
       (lock constraints)
      )
     )
     (implementation
      (component clearAtPrerun 1)
      (component clearAtActivate 1)
      (component output1D YES)
     )
     (views
      (icon
       (origin 393 637)
       (extent 104 27)
      )
      (detail
       (origin 445 745)
       (extent 60 110)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 7 "YPLOT"
     (name "Future Value vs. Time by % Rate")
     (description 1 6
      This is a "Display -> XY Trace" object.
     )
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Future Value")
       (lock constraints)
      )
      (input 2
       (type data)
       (name "Goal, Time")
       (lock constraints)
       (optional yes)
      )
      (input 3
       (type data)
       (name "Goal, Money")
       (lock constraints)
       (optional yes)
      )
      (input 4
       (type control)
       (name "Next Curve")
       (lock name constraints)
       (optional yes)
      )
     )
     (implementation
      (component clearAtPrerun 1)
      (component clearAtActivate 0)
      (component tracePin 1)
      (component tracePin 2)
      (component tracePin 3)
      (component graphMode rectangular)
     )
     (views
      (icon
       (extent 289 0)
       (iconImage "display.icon")
      )
      (detail
       (origin 486 164)
       (extent 418 372)
       (displayMode scrollGraph)
       (graphType cartesian)
       (gridType grid)
       (scale 0
        (name "Money Units")
        (domainName "Time Periods")
        (pen 9)
        (show 1)
        (range 0 2000000 4 linear)
       )
       (domain 0 40 4 linear)
       (trace 0 onScale 0
        (name "Future Value")
        (pen 4)
        (lineType 1)
        (pointType 0)
       )
       (trace 1 onScale 0
        (name "Goal, Time")
        (pen 7)
        (lineType 1)
        (pointType 0)
       )
       (trace 2 onScale 0
        (name "Goal, Money")
        (pen 6)
        (lineType 1)
        (pointType 0)
       )
       (marker 0 onTrace 0)
       (marker 1 onTrace 1)
      )
      (active detail)
     )
    )
    (component 8 "CONTEXT"
     (name "FutureVal")
     (description 2 6
      This "Device -> UserObject" is used to generate
      the Future Value plots.
     )
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "N")
       (optional yes)
      )
      (input 2
       (type data)
       (name "PV")
       (optional yes)
      )
      (input 3
       (type data)
       (name "I")
       (optional yes)
      )
      (output 1
       (type data)
       (name "FV")
       (lock constraints)
       (optional yes)
      )
     )
     (implementation
      (locked no)
      (trigMode rad)
      (nextID 3)
      (component 0 "FORMULA"
       (name "Formula")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "A")
         (optional yes)
        )
        (output 1
         (type data)
         (name "Result")
         (lock name constraints)
        )
       )
       (implementation
        (component isLocked no)
        (component expr 1 "ramp(A,1,A)")
       )
       (views
        (icon
         (origin 311 398)
         (extent 78 25)
        )
        (detail
         (origin 305 483)
         (extent 151 34)
        )
        (active icon)
       )
      )
      (component 1 "FORMULA"
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "n")
         (optional yes)
        )
        (input 2
         (type data)
         (name "pv")
         (optional yes)
        )
        (input 3
         (type data)
         (name "i")
         (optional yes)
        )
        (output 1
         (type data)
         (name "Result")
         (lock name constraints)
        )
       )
       (implementation
        (component isLocked no)
        (component expr 1 "pv*(1+i/100)^n")
       )
       (views
        (icon
         (origin 361 493)
         (extent 78 34)
        )
        (detail
         (origin 375 456)
         (extent 160 129)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 2 "TOCOORDINATE"
       (name "Build Coord FV")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "X Data")
         (tag "X")
         (requires
          (datatype Real)
         )
         (lock constraints)
        )
        (input 2
         (type data)
         (name "Y Data")
         (tag "Y")
         (requires
          (datatype Real)
         )
         (lock constraints)
        )
        (output 1
         (type data)
         (name "Coord")
         (tag "Coord")
         (lock constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 462 458)
         (extent 136 64)
         (iconImage "build.icon")
        )
        (detail
         (origin 425 235)
         (extent 80 110)
        )
        (terminals on)
        (active icon)
       )
      )
      (configuration
       (connect I1:1 D0:1)
       (connect D0:1 D1:1)
       (connect I2:1 D1:2)
       (connect I3:1 D1:3)
       (connect D0:1 D2:1)
       (connect D1:1 D2:2)
       (connect D2:1 O1:1)
      )
     )
     (views
      (icon
       (origin 377 192)
       (extent 97 36)
      )
      (detail
       (origin 298 363)
       (extent 324 234)
       (configuration
        (connect I1:1 D0:1
         (Point 300 410)
         (Point 308 410)
        )
        (connect D0:1 D1:1
         (Point 391 410)
         (Point 410 410)
         (Point 410 470)
         (Point 340 470)
         (Point 340 500)
         (Point 358 500)
        )
        (connect I2:1 D1:2
         (Point 300 490)
         (Point 310 490)
         (Point 310 510)
         (Point 358 510)
        )
        (connect I3:1 D1:3
         (Point 300 570)
         (Point 310 570)
         (Point 310 520)
         (Point 358 520)
        )
        (connect D0:1 D2:1
         (Point 391 410)
         (Point 410 410)
         (Point 410 470)
         (Point 459 470)
        )
        (connect D1:1 D2:2
         (Point 441 510)
         (Point 459 510)
        )
        (connect D2:1 O1:1
         (Point 600 490)
         (Point 619 490)
        )
       )
       (stackingOrder 0 1 2)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 9 "FORMULA"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "max(A)+\" %\"")
     )
     (views
      (icon
       (origin 436 578)
       (extent 78 25)
      )
      (detail
       (origin 445 554)
       (extent 160 53)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 10 "FORRANGE"
     (name "Interest%")
     (description 4 6
      This "Flow -> Repeat -> For Range" object is
      used to generate a range of interest rates for
      the Future Value plots.  It also acts as the
      "Next Curve" control input to the plot object.
     )
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "From")
       (tag "From")
       (requires
        (datatype Real)
        (shape "Scalar")
       )
       (lock constraints)
       (optional yes)
       (buffer YES)
      )
      (input 2
       (type data)
       (name "Thru")
       (tag "Thru")
       (requires
        (datatype Real)
        (shape "Scalar")
       )
       (lock constraints)
       (optional yes)
       (buffer YES)
      )
      (input 3
       (type data)
       (name "Step")
       (tag "Step")
       (requires
        (datatype Real)
        (shape "Scalar")
       )
       (lock constraints)
       (optional yes)
       (buffer YES)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component from 4)
      (component thru 20)
      (component step 2)
     )
     (views
      (icon
       (origin 366 533)
       (extent 99 34)
      )
      (detail
       (origin 473 219)
       (extent 174 82)
      )
      (active icon)
     )
    )
    (configuration
     (connect D1:1 D0:1)
     (connect D2:1 D1:1)
     (connect D6:1 D2:1)
     (connect D5:1 D3:1)
     (connect D9:1 D4:1)
     (connect D6:1 D5:1)
     (connect D10:1 D6:1)
     (connect D10:0 D6:2)
     (connect D8:1 D7:1)
     (connect I3:1 D7:2)
     (connect I4:1 D7:3)
     (connect D10:1 D7:4)
     (connect I1:1 D8:1)
     (connect I2:1 D8:2)
     (connect D10:1 D8:3)
     (connect D6:1 D9:1)
     (connect I5:1 D10:1)
     (connect I6:1 D10:2)
     (connect I7:1 D10:3)
    )
   )
   (views
    (icon
     (origin 572 808)
     (extent 136 74)
    )
    (panel
     (origin 478 819)
     (extent 494 522)
     (widget 7 detail
      (title on)
      (origin 483 858)
      (extent 481 472)
      (displayMode annotGraph)
      (graphType cartesian)
      (gridType grid)
      (scale 0
       (name "Money Units")
       (domainName "Time Periods")
       (pen 9)
       (show 1)
       (range 0 2000000 4 linear)
      )
      (domain 0 40 4 linear)
      (trace 0 onScale 0
       (name "Future Value")
       (pen 4)
       (lineType 1)
       (pointType 0)
      )
      (trace 1 onScale 0
       (name "Goal, Time")
       (pen 7)
       (lineType 1)
       (pointType 0)
      )
      (trace 2 onScale 0
       (name "Goal, Money")
       (pen 6)
       (lineType 1)
       (pointType 0)
      )
      (marker 0 onTrace 0)
      (marker 1 onTrace 1)
     )
     (widget 0 detail
      (title off)
      (origin 487 1006)
      (extent 145 31)
      (formatter
       (realFormat standard)
       (realSigDigits 2)
       (realRadixSpec 2)
       (integerBase decimal)
      )
     )
     (widget 4 detail
      (title off)
      (origin 635 879)
      (extent 67 28)
      (formatter
       (realFormat standard)
       (realSigDigits 2)
       (realRadixSpec 2)
       (integerBase decimal)
      )
     )
     (widget 3 detail
      (title off)
      (origin 861 1222)
      (extent 65 27)
      (formatter
       (realFormat standard)
       (realSigDigits 2)
       (realRadixSpec 2)
       (integerBase decimal)
      )
     )
    )
    (detail
     (origin 340 150)
     (extent 570 520)
     (configuration
      (connect D1:1 D0:1
       (Point 736 650)
       (Point 750 650)
      )
      (connect D2:1 D1:1
       (Point 642 650)
       (Point 653 650)
      )
      (connect D6:1 D2:1
       (Point 499 650)
       (Point 527 650)
      )
      (connect D5:1 D3:1
       (Point 756 590)
       (Point 792 590)
      )
      (connect D9:1 D4:1
       (Point 516 590)
       (Point 530 590)
      )
      (connect D6:1 D5:1
       (Point 499 650)
       (Point 515 650)
       (Point 515 620)
       (Point 665 620)
       (Point 665 590)
       (Point 673 590)
      )
      (connect D10:1 D6:1
       (Point 467 550)
       (Point 475 550)
       (Point 475 520)
       (Point 465 520)
       (Point 465 510)
       (Point 385 510)
       (Point 385 640)
       (Point 390 640)
      )
      (connect D10:0 D6:2
       (Point 415 569)
       (Point 415 580)
       (Point 405 580)
       (Point 405 590)
       (Point 375 590)
       (Point 375 660)
       (Point 390 660)
      )
      (connect D8:1 D7:1
       (Point 476 210)
       (Point 483 210)
      )
      (connect I3:1 D7:2
       (Point 342 350)
       (Point 355 350)
       (Point 355 300)
       (Point 483 300)
      )
      (connect I4:1 D7:3
       (Point 342 420)
       (Point 355 420)
       (Point 355 390)
       (Point 483 390)
      )
      (connect D10:1 D7:4
       (Point 467 550)
       (Point 475 550)
       (Point 475 520)
       (Point 465 520)
       (Point 465 480)
       (Point 483 480)
      )
      (connect I1:1 D8:1
       (Point 342 210)
       (Point 358 210)
       (Point 358 200)
       (Point 374 200)
      )
      (connect I2:1 D8:2
       (Point 342 280)
       (Point 355 280)
       (Point 355 210)
       (Point 374 210)
      )
      (connect D10:1 D8:3
       (Point 467 550)
       (Point 475 550)
       (Point 475 520)
       (Point 465 520)
       (Point 465 510)
       (Point 385 510)
       (Point 385 500)
       (Point 365 500)
       (Point 365 220)
       (Point 374 220)
      )
      (connect D6:1 D9:1
       (Point 499 650)
       (Point 515 650)
       (Point 515 620)
       (Point 415 620)
       (Point 415 590)
       (Point 433 590)
      )
      (connect I5:1 D10:1
       (Point 342 490)
       (Point 355 490)
       (Point 355 540)
       (Point 363 540)
      )
      (connect I6:1 D10:2
       (Point 342 560)
       (Point 352 560)
       (Point 352 550)
       (Point 363 550)
      )
      (connect I7:1 D10:3
       (Point 342 630)
       (Point 355 630)
       (Point 355 560)
       (Point 363 560)
      )
     )
     (stackingOrder 0 1 2 3 4 5 6 7 8 9
       10)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 11 "CONTEXT"
   (name "Unsecured I")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "FromI")
     (lock constraints)
     (optional yes)
    )
    (output 2
     (type data)
     (name "ThruI")
     (lock constraints)
     (optional yes)
    )
    (output 3
     (type data)
     (name "StepI")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (locked no)
    (trigMode rad)
    (nextID 4)
    (component 0 "NOTE"
     (name "Interest Values:")
     (interface
     )
     (implementation
      (component text 5 7
       From %:
       
       Thru %:
       
       Step %:
      )
     )
     (views
      (icon
       (origin 63 438)
       (extent 154 25)
      )
      (detail
       (origin 12 438)
       (extent 197 105)
       (editing disabled)
      )
      (active detail)
     )
    )
    (component 1 "CONSTANT"
     (name "From %")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Real
       (name "From %")
       (datum 4)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Real
       (name "Real")
       (datum 0)
      )
     )
     (views
      (icon
       (extent 78 0)
      )
      (detail
       (origin 78 476)
       (extent 165 28)
       (showFormat real)
      )
      (active detail)
     )
    )
    (component 2 "CONSTANT"
     (name "Thru %")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Real
       (name "Thru %")
       (datum 20)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Real
       (name "Real")
       (datum 0)
      )
     )
     (views
      (icon
       (extent 78 0)
      )
      (detail
       (origin 78 546)
       (extent 165 28)
       (showFormat real)
      )
      (active detail)
     )
    )
    (component 3 "CONSTANT"
     (name "Step %")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Real
       (name "Step %")
       (datum 2)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Real
       (name "Real")
       (datum 0)
      )
     )
     (views
      (icon
       (extent 78 0)
      )
      (detail
       (origin 78 616)
       (extent 165 28)
       (showFormat real)
      )
      (active detail)
     )
    )
    (configuration
     (connect D1:1 O1:1)
     (connect D2:1 O2:1)
     (connect D3:1 O3:1)
    )
   )
   (views
    (icon
     (origin 255 848)
     (extent 110 34)
    )
    (panel
     (origin 81 955)
     (extent 198 150)
     (widget 0 detail
      (title on)
      (origin 86 994)
      (extent 187 105)
      (editing disabled)
     )
     (widget 1 detail
      (title off)
      (origin 161 998)
      (extent 110 30)
      (showFormat real)
     )
     (widget 2 detail
      (title off)
      (origin 161 1033)
      (extent 109 29)
      (showFormat real)
     )
     (widget 3 detail
      (title off)
      (origin 161 1066)
      (extent 108 28)
      (showFormat real)
     )
    )
    (detail
     (origin 2 406)
     (extent 316 248)
     (configuration
      (connect D1:1 O1:1
       (Point 245 490)
       (Point 265 490)
       (Point 265 450)
       (Point 315 450)
      )
      (connect D2:1 O2:1
       (Point 245 560)
       (Point 265 560)
       (Point 265 540)
       (Point 315 540)
      )
      (connect D3:1 O3:1
       (Point 245 630)
       (Point 315 630)
      )
     )
     (stackingOrder 0 1 2 3)
    )
    (active icon)
   )
  )
  (component 12 "NOTE"
   (name "To Operate")
   (interface
   )
   (implementation
    (component text 3 5
          Click "Run" to see the results
         of this example, or "Info About"
         for an overview and more details.
    )
   )
   (views
    (icon
     (origin 45 703)
     (extent 110 64)
     (iconImage "notepad.icon")
    )
    (detail
     (origin 5 658)
     (extent 390 65)
     (editing disabled)
    )
    (active icon)
   )
  )
  (component 13 "CONTEXT"
   (name "Press For")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (locked no)
    (trigMode deg)
    (nextID 3)
    (component 0 "IFTHENELSE"
     (name "!= 0")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a!=0")
     )
     (views
      (icon
       (origin 647 578)
       (extent 46 25)
      )
      (detail
       (origin 209 308)
       (extent 73 64)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "TOGGLE"
     (name "Info About")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Reset")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Info About")
       (values range 0 1)
       (datum 0)
      )
      (component autoTrigger on)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (name "LongInt")
       (datum 0)
      )
     )
     (views
      (icon
       (origin 493 571)
       (extent 114 39)
       (format button)
      )
      (detail
       (origin 483 593)
       (extent 64 54)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "CONTEXT"
     (name "Info About this Example")
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (locked no)
      (trigMode deg)
      (nextID 2)
      (component 0 "NOTE"
       (name "NotePad")
       (description 2 8
        This notepad is displayed as a Show on Execute
        panel to present the information to the reader.
       )
       (interface
       )
       (implementation
        (component text 52 9
         PURPOSE:      Demonstrate financial capabilities of HP VEE; show the "future value growth" of
                       a principal amount, through graphical curve plotting.
         
         USER INPUT REQUIRED: None, for example results.  You may change any of the input data and
                       re-run the example.
         
         EXPLANATION: This model calculates the future value of a principal amount, for a range of
                      interest rates, up to a specified period, and displays the growth graphically as
                      an X,Y plot for each interest rate.  "FV return" and "Time Period" goal inputs
                      are indicated on the graph as salmon and cyan colored straight lines.  The
                      interest rate to achieve these goals, at their intersection, is calculated and
                      displayed.  All interest rates used in the example are based on a time period
                      equal to one year.  However, the time period is effectively defined by the
                      interest rate that is entered.  In other words, if, in the Interest Rate entry
                      fields you enter annual interest rates divided by 12, then the time periods will
                      be months.
         
                      The details of model construction may be observed by clicking on "Detail",
                      located left above the menu bar, using the left mouse button.  In the detail
                      mode, objects are often iconized to save space.  To "open" an icon, simply double
                      click on the icon.
         
                      Some of the HP VEE features to notice in this model include the method of
                      displaying both the exponential growth curves of future value, and the straight
                      lines as goal indicators.  The "Display -> XY Plot" object tolerates various size
                      and shape data on its inputs.  However, multiple and dissimilar data are often
                      best handled by using coordinate pairs, along with the "Next Curve" control input
                      feature of the graph.  Each "Next Curve" data set may be different, so long as
                      the data within each set is similar.  Also note that the plot display and the 
                      "Interest Values:" entry objects are secured UserObjects.  See below for more
                      information.
         
                      The main reason for securing the above mentioned UserObjects is to prevent the
                      accessing of the larger panel object, in such a way as might move or activate it.
                      This will cause it to overlay and hide the smaller panel objects.  This is
                      prevented when a UserObject panel is secured.  Unsecured versions of these User
                      Objects may be explored by pressing the "Next" key while in the "Detail" mode.
         
                      The "annotation" of the graphic display is accomplished with "Display -> Alpha
                      Numeric" objects which help to clarify the fact that each curve represents a
                      different interest rate.  Note the triangular markers, which are used to indicate
                      specific values on a curve by clicking near the spot of interest with the left
                      mouse button.  This feature continues to function even in a secured panel, but
                      other display options will not be available.
         
                      The "Interest Value:" input object approximates a "Flow -> Repeat -> For Range"
                      object, and consists of "Data -> Constant -> Real" objects overlaid on a "Display
                      -> Note Pad" object, and configured as panels.  It was constructed merely as a
                      means of sending the individual values into a "For Range" object (which, in order
                      to function properly, must be located within the secured "Plot Display"
                      UserObject.) 
         
        )
       )
       (views
        (icon
         (origin 681 608)
         (extent 78 25)
        )
        (detail
         (origin 56 212)
         (extent 848 437)
         (editing disabled)
        )
        (active icon)
       )
      )
      (component 1 "CONFIRM"
       (name "DONE")
       (description 7 8
        This tiny "thread" begins running when the 
        enclosing UserObject is executed.  When the user
        acknowledges the OK/DONE button, there is nothing
        left to execute, so the thread ends.  Since there
        are not other threads running, the User Object
        is completed and will exit, removing the Show on
        Execute pop-up display.
       )
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 701 672)
         (extent 58 37)
        )
        (detail
         (origin 686 673)
         (extent 79 34)
        )
        (terminals on)
        (active icon)
       )
      )
      (configuration
      )
      (ShowOnExecPanel
       (origin 9 94)
       (extent 901 575)
       (panel
        (origin 282 357)
        (extent 897 547)
        (widget 0 detail
         (title off)
         (origin 287 363)
         (extent 888 493)
         (editing disabled)
        )
        (widget 1 icon
         (title off)
         (origin 701 862)
         (extent 58 37)
        )
       )
      )
     )
     (views
      (icon
       (origin 622 618)
       (extent 217 25)
      )
      (detail
       (origin 287 350)
       (extent 866 520)
       (configuration
       )
       (stackingOrder 0 1)
      )
      (active icon)
     )
    )
    (configuration
     (connect D1:1 D0:1)
     (connect D2:0 D1:1)
     (connect D0:1 D2:0)
    )
   )
   (views
    (icon
     (origin 307 248)
     (extent 110 25)
    )
    (panel
     (origin 533 697)
     (extent 295 56)
     (widget 1 icon
      (title off)
      (origin 623 707)
      (extent 114 39)
      (format button)
     )
    )
    (detail
     (origin 274 305)
     (extent 912 591)
     (configuration
      (connect D1:1 D0:1
       (Point 609 590)
       (Point 644 590)
      )
      (connect D2:0 D1:1
       (Point 730 645)
       (Point 730 660)
       (Point 470 660)
       (Point 470 590)
       (Point 490 590)
      )
      (connect D0:1 D2:0
       (Point 695 580)
       (Point 730 580)
       (Point 730 615)
      )
     )
     (stackingOrder 0 1 2)
    )
    (active panel)
    (active panel)
   )
  )
  (configuration
   (connect D1:1 D5:1)
   (connect D0:1 D5:2)
   (connect D3:1 D5:3)
   (connect D2:1 D7:1)
   (connect D3:1 D7:2)
   (connect D9:1 D7:3)
   (connect D9:2 D7:4)
   (connect D6:3 D7:5)
   (connect D6:2 D7:6)
   (connect D6:1 D7:7)
   (connect D5:1 D8:1)
   (connect D1:1 D9:1)
   (connect D0:1 D9:2)
   (connect D2:1 D9:3)
   (connect D2:1 D10:1)
   (connect D3:1 D10:2)
   (connect D9:1 D10:3)
   (connect D9:2 D10:4)
   (connect D11:1 D10:5)
   (connect D11:2 D10:6)
   (connect D11:3 D10:7)
  )
 )
 (views
  (panel
   (origin 0 62)
   (extent 917 651)
   (widget 4 detail
    (title on)
    (origin 6 620)
    (extent 386 82)
    (editing disabled)
   )
   (widget 7 panel
    (title off)
    (origin 401 67)
    (extent 506 636)
    (widget 7 detail
     (title on)
     (origin 406 106)
     (extent 497 592)
     (displayMode annotGraph)
     (graphType cartesian)
     (gridType grid)
     (scale 0
      (name "Money Units")
      (domainName "Time Periods")
      (pen 9)
      (show 1)
      (range 0 2000000 4 linear)
     )
     (domain 0 40 4 linear)
     (trace 0 onScale 0
      (name "Future Value")
      (pen 4)
      (lineType 1)
      (pointType 0)
     )
     (trace 1 onScale 0
      (name "Goal, Time")
      (pen 7)
      (lineType 1)
      (pointType 0)
     )
     (trace 2 onScale 0
      (name "Goal, Money")
      (pen 6)
      (lineType 1)
      (pointType 0)
     )
     (marker 0 onTrace 0)
     (marker 1 onTrace 1)
    )
    (widget 4 detail
     (title off)
     (origin 559 125)
     (extent 80 31)
     (formatter
      (realFormat standard)
      (realSigDigits 2)
      (realRadixSpec 2)
      (integerBase decimal)
     )
    )
    (widget 3 detail
     (title off)
     (origin 793 588)
     (extent 72 29)
     (formatter
      (realFormat standard)
      (realSigDigits 2)
      (realRadixSpec 2)
      (integerBase decimal)
     )
    )
    (widget 0 detail
     (title off)
     (origin 410 285)
     (extent 150 30)
     (formatter
      (realFormat standard)
      (realSigDigits 2)
      (realRadixSpec 2)
      (integerBase decimal)
     )
    )
   )
   (widget 13 panel
    (title on)
    (origin 9 206)
    (extent 379 65)
    (widget 1 icon
     (title off)
     (origin 126 215)
     (extent 148 42)
     (format button)
    )
   )
   (widget 3 detail
    (title on)
    (origin 9 314)
    (extent 175 34)
    (showFormat real)
   )
   (widget 2 detail
    (title on)
    (origin 9 389)
    (extent 174 31)
    (showFormat int)
   )
   (widget 6 panel
    (title off)
    (origin 194 278)
    (extent 192 141)
    (widget 3 detail
     (title on)
     (origin 197 312)
     (extent 187 105)
     (editing disabled)
    )
    (widget 2 detail
     (title off)
     (origin 272 321)
     (extent 110 30)
     (showFormat real)
    )
    (widget 0 detail
     (title off)
     (origin 273 356)
     (extent 109 29)
     (showFormat real)
    )
    (widget 1 detail
     (title off)
     (origin 274 387)
     (extent 108 28)
     (showFormat real)
    )
   )
   (widget 0 detail
    (title on)
    (origin 9 462)
    (extent 173 32)
    (showFormat int)
   )
   (widget 8 detail
    (title on)
    (origin 93 542)
    (extent 204 32)
    (formatter
     (realFormat fixed)
     (realSigDigits 4)
     (realRadixSpec 2)
     (integerBase decimal)
    )
   )
   (widget 12 detail
    (title on)
    (origin 10 105)
    (extent 377 61)
    (editing disabled)
   )
   (widget 1 detail
    (title on)
    (origin 194 461)
    (extent 188 32)
    (showFormat real)
   )
  )
  (detail
   (origin 0 62)
   (extent 985 679)
   (configuration
    (connect D1:1 D5:1
     (Point 170 255)
     (Point 240 255)
     (Point 240 265)
     (Point 260 265)
     (Point 260 395)
     (Point 286 395)
    )
    (connect D0:1 D5:2
     (Point 189 325)
     (Point 210 325)
     (Point 210 405)
     (Point 286 405)
    )
    (connect D3:1 D5:3
     (Point 185 465)
     (Point 210 465)
     (Point 210 415)
     (Point 286 415)
    )
    (connect D2:1 D7:1
     (Point 190 395)
     (Point 220 395)
     (Point 220 325)
     (Point 430 325)
     (Point 430 165)
     (Point 491 165)
    )
    (connect D3:1 D7:2
     (Point 185 465)
     (Point 210 465)
     (Point 210 435)
     (Point 440 435)
     (Point 440 235)
     (Point 491 235)
    )
    (connect D9:1 D7:3
     (Point 386 255)
     (Point 400 255)
     (Point 400 305)
     (Point 491 305)
    )
    (connect D9:2 D7:4
     (Point 386 295)
     (Point 410 295)
     (Point 410 375)
     (Point 491 375)
    )
    (connect D6:3 D7:5
     (Point 211 645)
     (Point 250 645)
     (Point 250 445)
     (Point 491 445)
    )
    (connect D6:2 D7:6
     (Point 211 595)
     (Point 240 595)
     (Point 240 515)
     (Point 491 515)
    )
    (connect D6:1 D7:7
     (Point 211 545)
     (Point 230 545)
     (Point 230 585)
     (Point 491 585)
    )
    (connect D5:1 D8:1
     (Point 393 405)
     (Point 410 405)
     (Point 410 455)
     (Point 260 455)
     (Point 260 655)
     (Point 220 655)
     (Point 220 715)
     (Point 233 715)
    )
    (connect D1:1 D9:1
     (Point 170 255)
     (Point 254 255)
    )
    (connect D0:1 D9:2
     (Point 189 325)
     (Point 210 325)
     (Point 210 275)
     (Point 254 275)
    )
    (connect D2:1 D9:3
     (Point 190 395)
     (Point 220 395)
     (Point 220 295)
     (Point 254 295)
    )
    (connect D2:1 D10:1
     (Point 190 395)
     (Point 220 395)
     (Point 220 325)
     (Point 400 325)
     (Point 400 385)
     (Point 450 385)
     (Point 450 635)
     (Point 500 635)
     (Point 500 815)
     (Point 569 815)
    )
    (connect D3:1 D10:2
     (Point 185 465)
     (Point 210 465)
     (Point 210 435)
     (Point 440 435)
     (Point 440 645)
     (Point 490 645)
     (Point 490 825)
     (Point 569 825)
    )
    (connect D9:1 D10:3
     (Point 386 255)
     (Point 400 255)
     (Point 400 305)
     (Point 460 305)
     (Point 460 625)
     (Point 510 625)
     (Point 510 835)
     (Point 569 835)
    )
    (connect D9:2 D10:4
     (Point 386 295)
     (Point 410 295)
     (Point 410 375)
     (Point 470 375)
     (Point 470 655)
     (Point 480 655)
     (Point 480 845)
     (Point 569 845)
    )
    (connect D11:1 D10:5
     (Point 367 855)
     (Point 569 855)
    )
    (connect D11:2 D10:6
     (Point 367 865)
     (Point 569 865)
    )
    (connect D11:3 D10:7
     (Point 367 875)
     (Point 569 875)
    )
   )
   (stackingOrder 0 1 2 3 4 5 6 7 8 9
     10 11 12 13)
  )
  (active panel)
  (active panel)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
