#! /usr/lib/veetest/veetest -r
(revision "B.00.00")
(date "Mon 14/Sep/1992")
(component 0 "ROOTCONTEXT"
 (name " Spring Natural Frequency Example")
 (interface
 )
 (implementation
  (locked no)
  (trigMode deg)
  (component 0 "CONSTANT"
   (name "Min Freq")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (datum 15)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
   )
   (views
    (icon
     (origin 383 511)
     (extent 110 39)
    )
    (detail
     (origin 301 496)
     (extent 139 29)
    )
    (active detail)
   )
  )
  (component 1 "FORMULA"
   (name "Formula")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Mass")
     (optional yes)
    )
    (input 2
     (type data)
     (name "dcoil")
     (optional yes)
    )
    (input 3
     (type data)
     (name "Grigid")
     (optional yes)
    )
    (input 4
     (type data)
     (name "dwire")
     (optional yes)
    )
    (input 5
     (type data)
     (name "turns")
     (optional yes)
    )
    (input 6
     (type data)
     (name "Length")
     (optional yes)
    )
    (output 1
     (type data)
     (name " ")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "((Grigid*dwire^4)/(8*turns*dcoil^3)*(Mass+Length/3))")
   )
   (views
    (icon
     (origin 282 378)
     (extent 77 65)
    )
    (detail
     (origin 109 467)
     (extent 482 248)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 2 "NOTE"
   (name "Note Pad")
   (interface
   )
   (implementation
    (component text 9 5
      A "Note Pad" object may be effectively
      used as a reminder of some of the
      model details and reasons for such
      things as why a minimum frequency is
      necessary.  For example:
      
      "See which diameter spring is the
      lowest cost between 12 and 15 ( >15
      gives too low a natural frequency)."
    )
   )
   (views
    (icon
     (origin 307 591)
     (extent 106 39)
    )
    (detail
     (origin 200 479)
     (extent 381 182)
     (editing disabled)
    )
    (active icon)
   )
  )
  (component 3 "NOTE"
   (name "To Operate")
   (interface
   )
   (implementation
    (component text 3 5
     Click "Run" to see example
     calculation results, or
     "Info About" for details.
    )
   )
   (views
    (icon
     (origin 45 88)
     (extent 110 64)
     (iconImage "notepad.icon")
    )
    (detail
     (origin 226 240)
     (extent 249 61)
     (editing disabled)
    )
    (active icon)
   )
  )
  (component 4 "FORRANGE"
   (name "dcoil")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component from 12)
    (component thru 18)
    (component step 1)
   )
   (views
    (icon
     (extent 59 0)
    )
    (detail
     (origin 6 347)
     (extent 168 86)
    )
    (active detail)
   )
  )
  (component 5 "FORRANGE"
   (name "Mass")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component from 2)
    (component thru 10)
    (component step 2)
   )
   (views
    (icon
     (extent 50 0)
    )
    (detail
     (origin 6 197)
     (extent 168 86)
    )
    (active detail)
   )
  )
  (component 6 "CONSTANT"
   (name "Rigidity")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (datum 12000000)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
   )
   (views
    (icon
     (extent 86 0)
    )
    (detail
     (origin 26 486)
     (extent 129 28)
    )
    (active detail)
   )
  )
  (component 7 "CONSTANT"
   (name "dwire")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (datum 0.5)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
   )
   (views
    (icon
     (extent 59 0)
    )
    (detail
     (origin 26 566)
     (extent 129 28)
    )
    (active detail)
   )
  )
  (component 8 "CONSTANT"
   (name "turns")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (datum 10)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
   )
   (views
    (icon
     (extent 59 0)
    )
    (detail
     (origin 26 646)
     (extent 129 28)
    )
    (active detail)
   )
  )
  (component 9 "CONSTANT"
   (name "length")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (datum 12)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
   )
   (views
    (icon
     (extent 68 0)
    )
    (detail
     (origin 26 726)
     (extent 128 29)
    )
    (active detail)
   )
  )
  (component 10 "XYPLOT"
   (name "Natural Frequency")
   (description 2 4
    This is a "Display, X vs Y Plot" object
    
   )
   (interface
    (sequence out)
    (input 1
     (type data)
     (name "XData")
     (lock name)
    )
    (input 2
     (type data)
     (name "YData1")
     (lock name)
    )
    (input 3
     (type data)
     (name "MinFreq")
     (lock constraints)
     (optional yes)
    )
    (input 4
     (type control)
     (name "Next Curve")
     (lock name constraints)
     (optional yes)
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
    (component tracePin 2)
    (component tracePin 3)
    (component graphMode rectangular)
   )
   (views
    (icon
     (origin 679 428)
     (extent 163 45)
    )
    (detail
     (origin 514 251)
     (extent 472 418)
     (displayMode annotGraph)
     (graphType cartesian)
     (gridType grid)
     (scale 0
      (name "Freq")
      (domainName "Coil Diam")
      (pen 9)
      (show 1)
      (range 0 80 3 linear)
     )
     (domain 12 18 3 linear)
     (trace 0 onScale 0
      (name "YData1")
      (pen 4)
      (lineType 1)
      (pointType 0)
     )
     (trace 1 onScale 0
      (name "MinFreq")
      (pen 7)
      (lineType 5)
      (pointType 0)
     )
    )
    (active detail)
   )
  )
  (component 11 "NOTE"
   (name "Mass 2")
   (interface
   )
   (implementation
    (component text 2 5
     Variation between
     graphs lines is mass
    )
   )
   (views
    (icon
     (origin 481 648)
     (extent 78 25)
    )
    (detail
     (origin 572 377)
     (extent 197 46)
     (editing disabled)
    )
    (active icon)
   )
  )
  (component 12 "NOTE"
   (name "Mass 10")
   (interface
   )
   (implementation
    (component text 2 5
     Variation between
     graphs lines is mass
    )
   )
   (views
    (icon
     (origin 861 208)
     (extent 78 25)
    )
    (detail
     (origin 742 257)
     (extent 197 46)
     (editing disabled)
    )
    (active icon)
   )
  )
  (component 13 "CONTEXT"
   (name "Press For")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (locked no)
    (trigMode deg)
    (component 0 "IFTHENELSE"
     (name "!= 0")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a!=0")
     )
     (views
      (icon
       (origin 365 370)
       (extent 46 25)
      )
      (detail
       (origin 209 308)
       (extent 73 64)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "TOGGLE"
     (name "Info About")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Reset")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Info About")
       (values range 0 1)
       (datum 0)
      )
      (component autoTrigger on)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (datum 0)
      )
     )
     (views
      (icon
       (origin 201 363)
       (extent 114 39)
       (format button)
      )
      (detail
       (origin 320 203)
       (extent 42 54)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "CONTEXT"
     (name "Info about this Example")
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (locked no)
      (trigMode deg)
      (component 0 "NOTE"
       (name "NotePad")
       (interface
       )
       (implementation
        (component text 37 9
         PURPOSE:     Demonstrate the calculation of natural frequency for a coil spring using a
                      model constructed in HP VEE, wherein a number of variable parameters are used.
         
         USER INPUT REQUIRED:  None.  Click "Run" to run the model.   You may change any values
                      displayed on the panel before running the example.
         
         EXPLANATION: The natural frequency is displayed as a graph versus the spring diameter for
                      each step in the range of mass associated with the spring system.  Each
                      parameter may be individually changed, and the effect of the change may then
                      be plotted.  However, the plots for some (extreme) values may not be very
                      useful, unless both scales on the display are changed to logarithmic mode,
                      in order to minimize the compression of plots which must cover extreme ranges.
                      This may be done by clicking the plot display's object menu button (upper
                      left corner of object) using the left mouse button, or anywhere on the plot
                      display using the right mouse button, and selecting "Traces & Scales...".
                      On the resulting pop-up panel click on each "Mapping:" button to change the
                      mode from "Linear" to "Log".  You may also select the number of log cycles
                      to display.  Another useful change to the display format may be accomplished
                      using the object menu by selecting "Panel Menu -> Scales & Sliders".  This
                      makes it easy to use "Auto Scale", or to specify the scale limits.
         
                      The model was built using HP VEE's panel approach because of the better
                      organized and simplified appearance this makes possible.  To review the
                      specific objects used to build the model, click on the "Detail" button
                      located on the left of the title bar.  Some of the objects accessible in
                      this mode have been iconized.  Double clicking on an icon will activate its
                      open view.  Selecting "Help" or "Show Description" from an object menu may
                      also provide additional useful information.
         
                      The program uses several features of HP VEE, including data input objects,
                      "Show On Execute" panel, "X vs Y Plot" display and a "Formula" object.  To
                      simplify the model, formula points were generated by nested iteration loops;
                      if calculation speed is important, see the examples/concepts/manual25.ex
                      for hints on using ramps and parallel math to replace the iterations.
         
                      To exit this information panel, click "DONE" below.
         
        )
       )
       (views
        (icon
         (origin 401 458)
         (extent 78 25)
        )
        (detail
         (origin 25 206)
         (extent 851 489)
         (editing disabled)
        )
        (active icon)
       )
      )
      (component 1 "CONFIRM"
       (name "DONE")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 411 512)
         (extent 58 37)
        )
        (detail
         (origin 396 503)
         (extent 79 34)
        )
        (terminals on)
        (active icon)
       )
      )
      (configuration
      )
      (ShowOnExecPanel
       (origin 12 80)
       (extent 881 594)
       (panel
        (origin 12 162)
        (extent 877 556)
        (widget 1 icon
         (title off)
         (origin 409 675)
         (extent 58 37)
        )
        (widget 0 detail
         (title off)
         (origin 23 174)
         (extent 855 491)
         (editing disabled)
        )
       )
      )
     )
     (views
      (icon
       (origin 342 428)
       (extent 217 25)
      )
      (detail
       (origin 13 162)
       (extent 875 517)
       (configuration
       )
       (stackingOrder 1 0)
      )
      (active icon)
     )
    )
    (configuration
     (connect D1:1 D0:1)
     (connect D2:0 D1:1)
     (connect D0:1 D2:0)
    )
   )
   (views
    (icon
     (origin 415 408)
     (extent 110 25)
    )
    (panel
     (origin 201 122)
     (extent 319 77)
     (widget 1 icon
      (title off)
      (origin 303 135)
      (extent 114 39)
      (format button)
     )
    )
    (detail
     (origin 4 115)
     (extent 912 591)
     (configuration
      (connect D1:1 D0:1
       (Point 317 382)
       (Point 362 382)
      )
      (connect D2:0 D1:1
       (Point 450 455)
       (Point 450 470)
       (Point 180 470)
       (Point 180 382)
       (Point 198 382)
      )
      (connect D0:1 D2:0
       (Point 413 372)
       (Point 450 372)
       (Point 450 425)
      )
     )
     (stackingOrder 0 1 2)
    )
    (active panel)
    (active panel)
   )
  )
  (component 14 "NOTE"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 4 5
      This example is provided as an
      illustration "as is", and Hewlett-Packard
      Company makes no warranty of any kind
      with regard to this example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 543 120)
     (extent 395 80)
     (editing disabled)
    )
    (active detail)
   )
  )
  (configuration
   (connect D5:1 D1:1)
   (connect D4:1 D1:2)
   (connect D6:1 D1:3)
   (connect D7:1 D1:4)
   (connect D8:1 D1:5)
   (connect D9:1 D1:6)
   (connect D5:1 D4:0)
   (connect D4:1 D10:1)
   (connect D1:1 D10:2)
   (connect D0:1 D10:3)
   (connect D5:1 D10:4)
  )
 )
 (views
  (panel
   (origin 0 67)
   (extent 912 645)
   (widget 5 detail
    (title on)
    (origin 20 277)
    (extent 168 86)
   )
   (widget 6 detail
    (title on)
    (origin 202 278)
    (extent 129 28)
   )
   (widget 7 detail
    (title on)
    (origin 204 364)
    (extent 129 28)
   )
   (widget 8 detail
    (title on)
    (origin 204 452)
    (extent 129 28)
   )
   (widget 9 detail
    (title on)
    (origin 204 534)
    (extent 130 28)
   )
   (widget 4 detail
    (title on)
    (origin 19 477)
    (extent 168 86)
   )
   (widget 14 detail
    (title on)
    (origin 503 106)
    (extent 395 77)
    (editing disabled)
   )
   (widget 3 detail
    (title on)
    (origin 234 106)
    (extent 257 77)
    (editing disabled)
   )
   (widget 10 detail
    (title on)
    (origin 366 229)
    (extent 530 451)
    (displayMode annotGraph)
    (graphType cartesian)
    (gridType grid)
    (scale 0
     (name "Freq")
     (domainName "Coil Diam")
     (pen 9)
     (show 1)
     (range 0 80 3 linear)
    )
    (domain 12 18 3 linear)
    (trace 0 onScale 0
     (name "YData1")
     (pen 4)
     (lineType 1)
     (pointType 0)
    )
    (trace 1 onScale 0
     (name "MinFreq")
     (pen 7)
     (lineType 5)
     (pointType 0)
    )
   )
   (widget 11 icon
    (title off)
    (origin 489 524)
    (extent 71 25)
   )
   (widget 12 icon
    (title off)
    (origin 670 390)
    (extent 78 25)
   )
   (widget 13 panel
    (title on)
    (origin 12 106)
    (extent 210 78)
    (widget 1 icon
     (title off)
     (origin 62 123)
     (extent 114 39)
     (format button)
    )
   )
  )
  (detail
   (origin 0 67)
   (extent 973 646)
   (configuration
    (connect D5:1 D1:1
     (Point 176 240)
     (Point 200 240)
     (Point 200 300)
     (Point 210 300)
     (Point 210 380)
     (Point 279 380)
    )
    (connect D4:1 D1:2
     (Point 176 390)
     (Point 279 390)
    )
    (connect D6:1 D1:3
     (Point 157 500)
     (Point 200 500)
     (Point 200 400)
     (Point 279 400)
    )
    (connect D7:1 D1:4
     (Point 157 580)
     (Point 210 580)
     (Point 210 410)
     (Point 279 410)
    )
    (connect D8:1 D1:5
     (Point 157 660)
     (Point 220 660)
     (Point 220 420)
     (Point 279 420)
    )
    (connect D9:1 D1:6
     (Point 156 740)
     (Point 170 740)
     (Point 170 710)
     (Point 230 710)
     (Point 230 430)
     (Point 279 430)
    )
    (connect D5:1 D4:0
     (Point 176 240)
     (Point 200 240)
     (Point 200 300)
     (Point 90 300)
     (Point 90 314)
    )
    (connect D4:1 D10:1
     (Point 176 390)
     (Point 260 390)
     (Point 260 310)
     (Point 511 310)
    )
    (connect D1:1 D10:2
     (Point 361 410)
     (Point 436 410)
     (Point 511 410)
    )
    (connect D0:1 D10:3
     (Point 442 510)
     (Point 476 510)
     (Point 511 510)
    )
    (connect D5:1 D10:4
     (Point 176 240)
     (Point 200 240)
     (Point 200 300)
     (Point 210 300)
     (Point 210 380)
     (Point 270 380)
     (Point 270 360)
     (Point 460 360)
     (Point 460 610)
     (Point 511 610)
    )
   )
   (stackingOrder 0 1 2 3 4 5 6 7 8 9
     10 11 12 14 13)
  )
  (active panel)
  (active panel)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
  (delGlob yes)
 )
)
