#! /usr/lib/veetest/veetest -r
(revision "B.00.00")
(date "Mon 26/Oct/1992")
(component 0 "ROOTCONTEXT"
 (name "File Editor Example")
 (interface
 )
 (implementation
  (locked no)
  (trigMode deg)
  (nextID 6)
  (component 0 "NOTE"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 4 5
     This example is provided as an
     illustration "as is", and Hewlett-Packard
     Company makes no warranty of any kind
     with regard to this example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 452 109)
     (extent 397 82)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 1 "LITERALCONSTANT"
   (name "File Name")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Text")
     (lock name constraints)
    )
   )
   (implementation
    (component value Text
     (name "File Name")
     (datum "/tmp/abc")
    )
    (component autoTrigger on)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Text
     (name "CString")
     (datum "")
    )
   )
   (views
    (icon
     (extent 110 0)
    )
    (detail
     (origin 50 246)
     (extent 201 28)
    )
    (active detail)
   )
  )
  (component 2 "CONTEXT"
   (name "File Editor")
   (description 36 4
    The FILE EDITOR device implements a simple text
    editor that operates on the supplied file name
    text string.  The named file is opened, if it
    exists, and read into the "edit buffer".  The user
    can modify the buffer as desired, then choose the
    Write or Cancel buttons.  Although limited, this
    device allows you to edit a file using Vee objects
    rather than using Execute Program to spawn an unix
    file editor.
    
    DESCRIPTION:
    The Detail view of the File Editor will let you
    examine the Show Description selections for most
    of the devices.
      
    CAVEATS:  
    Because the Text Constant device was not designed
    for use as a Text Edit window, several edit
    operations are somewhat different.  For example,
    the TAB key is used to move to the next "line",
    and cannot be inserted into the text file.  When
    positioned at the last line, a TAB will create ONE
    new line for input.  If several "blank" lines are
    needed at the end, temporarily create a dummy line
    with some text and use the Insert Line key to
    create the black lines about it, then delete or
    edit the dummy line.
        
    Because X-windows/ Motif style guides mandate that
    the "Return" key be used to terminate editing on a
    field, you must learn not to use the Return KEY;
    the TAB key performs the required line termination.
        
    You can move around the edit window with the key-
    board Arrows, Prev and Next keys, etc.  You can
    also use Emacs key mappings if you know them.
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "File Name")
     (requires
      (datatype Text)
      (shape "Scalar")
     )
     (optional yes)
    )
   )
   (implementation
    (locked no)
    (trigMode deg)
    (nextID 20)
    (component 0 "REPEATUNTILBREAK"
     (description 5 6
      Since we don't know how many lines are in the file,
      the read operation must be repeated until EOF is
      found.  The EOF triggers the collector to send
      all accumulated lines of text, then activates the
      "Break" object that terminates this iterator.  
     )
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Continuous")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 45 518)
       (extent 110 64)
       (iconImage "loop.icon")
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "FORMULA"
     (name "Editing:")
     (description 2 6
      This object constructs the "Editing: <filename>"
      text string displayed while editing is allowed.
     )
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "\"Editing: \"+A")
     )
     (views
      (icon
       (origin 45 638)
       (extent 110 25)
      )
      (detail
       (origin 120 380)
       (extent 151 60)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "JUNCTION"
     (name "JCT")
     (description 2 6
      This device passes thru either the Loading or the
      Editing string to the display device.
     )
     (interface
      (input 1
       (type data)
       (name "A")
       (lock name constraints)
      )
      (input 2
       (type data)
       (name "B")
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "Data")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 197 628)
       (extent 46 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 3 "TOFILE"
     (description 22 6
      Using the file name supplied on the Control input
      pin, the ToFile device overwrites the existing
      contents of the file with the array of data sent
      from the "Editable Text Constant" device. 
      
      The transaction uses STR format to write each 
      array element as a Text STRing.  The Config
      options are set to add a "\n" (newline) after
      each array element is written.  Since the last
      element receives no "\n" separator character, the
      Array separator char is set to "\n" to provide
      the final newline.
      
      Note that the ToFile device is set to Clear File
      at Prerun, causing any data written to start at
      the beginning of the file, rather than to be
      appended to the file.  (The file isn't actually
      cleared at pre-run; it is opened for overwriting
      at prerun, but not truncated until the first
      write operation takes place.  Thus, CANCELing
      the edit session does not truncate the file.)
      
     )
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "StrArray")
       (tag "A")
       (optional yes)
      )
      (input 2
       (type control)
       (name "File Name")
       (tag "File Name")
       (requires
        (datatype Text)
        (shape "Scalar")
       )
       (lock name constraints)
       (optional yes)
      )
     )
     (implementation
      (attr iopath file write "/tmp/abc"
       (readTerm "\n")
       (fs "\n")
       (eol "\n")
       (multiField fullSyntax)
       (arrayFormat block)
      )
      (procedure
        WRITE TEXT StrArray STR EOL
      )
     )
     (views
      (icon
       (origin 381 308)
       (extent 78 25)
      )
      (detail
       (origin 512 801)
       (extent 327 98)
      )
      (terminals on)
      (active detail)
     )
    )
    (component 4 "TEXTDISPLAY"
     (name "File Name")
     (description 3 6
      This device has been added to the File Editor
      Panel view to allow the user to see what file is
      being loaded and edited.
     )
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
      )
     )
     (implementation
      (component clearAtPrerun 1)
      (component clearAtActivate 1)
     )
     (views
      (icon
       (origin 265 628)
       (extent 110 25)
      )
      (detail
       (origin 165 463)
       (extent 190 35)
      )
      (active icon)
     )
    )
    (component 5 "CONFIRM"
     (name "WRITE")
     (description 12 6
      This "Confirm(OK)" object is added to the Panel
      view to allow the user to initiate a write of 
      the data in the Text Constant to the named file.
      
      If the user clicks on this button, the "Editable
      Text Constant" will operate, sending it's current
      data to the ToFile divide.  
      
      Note that the Cancel button is activated in 
      parallel with the Write; whichever one is pressed
      first by the user will allow control to continue
      from that device.
     )
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Go")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 47 702)
       (extent 67 37)
      )
      (detail
       (origin 36 120)
       (extent 59 40)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 6 "JUNCTION"
     (name "JCT")
     (description 3 6
      To feed either the collected text array or an 
      empty text array to the Editable Text Constant,
      the "JCT" object is used.
     )
     (interface
      (input 1
       (type data)
       (name "A")
       (lock name constraints)
      )
      (input 2
       (type data)
       (name "B")
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "Data")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 337 698)
       (extent 46 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 7 "EXITCONTEXT"
     (description 6 6
      Executing this object terminates the File Edit
      operation without writing the modified text to
      the file.  The Editable Text Constant device is
      first cleared by sending an empty array to it.
      
      
     )
     (interface
      (sequence in)
     )
     (implementation
     )
     (views
      (icon
       (origin 188 848)
       (extent 145 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 8 "EXITCONTEXT"
     (description 4 6
      Operating this object terminates the File Edit
      session after dumping the edited text to the 
      ToFile device for writing.
      
     )
     (interface
      (sequence in)
     )
     (implementation
     )
     (views
      (icon
       (origin 38 848)
       (extent 145 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 9 "CONFIRM"
     (name "CANCEL")
     (description 12 6
      This Confirm/OK object allows the user to cancel
      an edit session without writing the possibly 
      modified data to the file.  It does this by first
      clearing the "Editable Text Constant" by sending
      an empty array to it, then using the ExitUserObj
      device to terminate all operations in the File
      Editor User Object.
      
      Note that this device operates in parallel with
      the Write button; whichever is pressed first by
      the user will allow propagation to proceed from 
      that device.
     )
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Go")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 142 702)
       (extent 76 37)
      )
      (detail
       (origin 561 170)
       (extent 68 40)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 10 "DO"
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Do")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 157 758)
       (extent 46 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 11 "JUNCTION"
     (name "JCT")
     (interface
      (input 1
       (type data)
       (name "A")
       (lock name constraints)
      )
      (input 2
       (type data)
       (name "B")
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "Data")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 227 768)
       (extent 46 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 12 "LITERALCONSTANT"
     (name "Empty")
     (description 11 6
      Although the "Editable Text Constant" can have a
      "RESET" control input added, that input only 
      clears each element of the existing array and does
      not re-size the configured array.
      
      Thus, we use this small Text Constant to load an
      empty array into the edit constant after a Cancel
      request or after the file has been written.  If
      we did not clear the Editable Text Constant, it's
      current contents would be saved along with the
      user's program needlessly.
     )
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Text")
       (lock name constraints)
      )
     )
     (implementation
      (component value Text
       (name "Empty")
       (numDims 1)
       (size 1)
       (data
        [ "" ]
       )
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Text
       (name "CString")
       (datum "")
      )
     )
     (views
      (icon
       (origin 271 798)
       (extent 78 25)
      )
      (detail
       (origin 220 538)
       (extent 201 64)
      )
      (active icon)
     )
    )
    (component 13 "FROMFILE"
     (description 25 6
      The From File device is specially configured to
      read complete lines of text from the specified
      file, including blank lines consisting of just
      a newline.
      
      The method used is to read each line as one large
      TOKEN composed of all characters except the "\n"
      marking the end of a line.   Reading the file as
      an TEXT STRING instead of a TOKEN would cause all
      empty lines to be skipped, since STRING format
      collapses multiple white space into one separator.
      
      After reading the text (possibly nil) up to the
      newline ("\n"), we must read and discard the \n
      itself.  The CHAR read into "null" consumes the
      newline and puts it in the special variable "null"
      that discards all input.
      
      The EOF pin is added to allow detection of End of
      File which occurs on the read following the last
      successful TEXT read, if any.  The EOF pin is 
      used to cause the Collector to output the array
      of text strings it has been building as each line
      is read from the file.
      
     )
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "File Name")
       (tag "File Name")
       (requires
        (datatype Text)
        (shape "Scalar")
       )
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (name "X")
       (lock constraints)
       (optional yes)
      )
      (output 2
       (type data)
       (name "EOF")
       (tag "EOF")
       (lock name constraints)
       (optional yes)
      )
     )
     (implementation
      (attr iopath file read "/tmp/abc"
       (readTerm "\n")
       (fs " ")
       (eol "\n")
       (multiField fullSyntax)
       (arrayFormat block)
      )
      (procedure
        READ TEXT x TOKEN EXCLUDE:"\n"
        READ TEXT null CHAR:1
      )
     )
     (views
      (icon
       (origin 525 138)
       (extent 110 25)
      )
      (detail
       (origin 294 527)
       (extent 393 86)
      )
      (terminals on)
      (active detail)
     )
    )
    (component 14 "FROMFILE"
     (name "Rewind File")
     (description 7 6
      Each time the editor is invoked, we need to rewind
      the file.  Since all instances of a From File with
      the same file share a single file pointer, and
      since that pointer is only cleared when the file
      is closed at post-run, attempts to re-edit a file
      would fail if the pointer were not reset to the
      start of the file.
     )
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "File Name")
       (requires
        (datatype Text)
        (shape "Scalar")
       )
       (lock name constraints)
       (optional yes)
      )
     )
     (implementation
      (attr iopath file read "/tmp/abc"
       (readTerm "\n")
       (fs " ")
       (eol "\n")
       (multiField fullSyntax)
       (arrayFormat block)
      )
      (procedure
        EXECUTE REWIND
      )
     )
     (views
      (icon
       (origin 285 178)
       (extent 110 25)
      )
      (detail
       (origin 146 388)
       (extent 239 65)
      )
      (terminals on)
      (active detail)
     )
    )
    (component 15 "FORMULA"
     (name "Loading:")
     (description 3 6
      This device constructs the "loading: <filename>"
      string displayed while reading the file into the
      edit buffer.
     )
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "\"Loading: \"+A")
     )
     (views
      (icon
       (origin 45 478)
       (extent 110 25)
      )
      (detail
       (origin 120 220)
       (extent 151 60)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 16 "COLLECTOR"
     (description 7 6
      Each line of text is taken from the From File as
      a text string and added as the next element of a
      1-D array of text strings.  After the final line
      line has been read, the EOF pin operates to have
      the Collector send the entire collected array of
      text strings to the Editable Text Constant.
      
     )
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
       (tag "Data")
      )
      (input 2
       (type trigger)
       (name "XEQ")
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "Array")
       (tag "Array")
       (lock constraints)
      )
     )
     (implementation
      (component clearAtPrerun 1)
      (component clearAtActivate 1)
      (component output1D YES)
     )
     (views
      (icon
       (origin 755 548)
       (extent 110 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 17 "BREAK"
     (description 7 6
      This device terminates the endless "Until Break"
      used to read each line from the file.  After the
      Collector has passed the collected array of text
      to the next device, it's Sequence Out pin will
      let the "Break" object operate to terminate the 
      loop.  Control will proceed with the device 
      connected to the Until Break's Sequence Out pin.
     )
     (interface
      (sequence in)
     )
     (implementation
     )
     (views
      (icon
       (origin 771 598)
       (extent 78 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 18 "NOTE"
     (name "HINTS:")
     (interface
     )
     (implementation
      (component text 3 7
       See the Show Description on most
       of the devices for more detailed
       descriptions.
      )
     )
     (views
      (icon
       (extent 78 0)
       (iconImage "notepad.icon")
      )
      (detail
       (origin 506 389)
       (extent 308 63)
       (editing disabled)
      )
      (active detail)
     )
    )
    (component 19 "LITERALCONSTANT"
     (name "Editable Text Constant")
     (description 24 6
      This object, used somewhat differently, is the
      basis for the editing function.  A resized view
      of this device has been added to the File Editor
      Panel that pops up when the User Object executes.
      
      How does the editing work? In general, each of the
      Data Constant devices can be configured as scalar
      or 1D arrays.  When configed as an array, the
      size of the array changes as the user edits the
      data from the keyboard.  By configing a Text Constant
      as an array, we allow the user to modify each line
      of the array independently.
      
      To load an entire new set of values into a Data
      Constant, the Default Value control input is used.
      A "control" pin operates asynchronously, meaning
      that data arriving on the pin is "used" immediately
      by the device without waiting for other DATA or
      Sequence In pins to be activated.  This allows us
      to load the text array read from the file over any
      existing data in the Text Constant, where the user
      can modify it.
      
      
     )
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Default Value")
       (requires
        (datatype Text)
        (shape "Array 1D")
       )
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (name "Text")
       (lock name constraints)
      )
     )
     (implementation
      (component value Text
       (name "Editable Text Constant")
       (numDims 1)
       (size 1)
       (data
        [ "" ]
       )
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Text
       (name "CString")
       (datum "")
      )
     )
     (views
      (icon
       (extent 208 0)
      )
      (detail
       (origin 542 678)
       (extent 276 64)
      )
      (terminals on)
      (active detail)
     )
    )
    (configuration
     (connect D15:0 D0:0)
     (connect D0:0 D1:0)
     (connect I1:1 D1:1)
     (connect D15:1 D2:1)
     (connect D1:1 D2:2)
     (connect D19:0 D3:0)
     (connect D19:1 D3:1)
     (connect I1:1 D3:2)
     (connect D2:1 D4:1)
     (connect D1:0 D5:0)
     (connect D16:1 D6:1)
     (connect D12:1 D6:2)
     (connect D10:0 D7:0)
     (connect D5:0 D8:0)
     (connect D1:0 D9:0)
     (connect D9:1 D10:0)
     (connect D10:1 D11:1)
     (connect D3:0 D11:2)
     (connect D11:1 D12:0)
     (connect D0:1 D13:0)
     (connect I1:1 D13:1)
     (connect I1:1 D14:1)
     (connect D14:0 D15:0)
     (connect I1:1 D15:1)
     (connect D13:1 D16:1)
     (connect D13:2 D16:2)
     (connect D16:0 D17:0)
     (connect D5:1 D19:0)
     (connect D6:1 D19:1)
    )
    (ShowOnExecPanel
     (origin 15 76)
     (extent 846 599)
     (panel
      (origin 79 335)
      (extent 842 571)
      (widget 4 detail
       (title off)
       (origin 99 862)
       (extent 370 36)
      )
      (widget 9 icon
       (title off)
       (origin 684 862)
       (extent 76 37)
      )
      (widget 5 icon
       (title off)
       (origin 598 862)
       (extent 67 37)
      )
      (widget 19 detail
       (title off)
       (origin 92 347)
       (extent 815 503)
      )
     )
    )
   )
   (views
    (icon
     (origin 295 418)
     (extent 110 25)
    )
    (detail
     (origin 29 334)
     (extent 882 593)
     (configuration
      (connect D15:0 D0:0
       (Point 100 505)
       (Point 100 515)
      )
      (connect D0:0 D1:0
       (Point 100 584)
       (Point 100 635)
      )
      (connect I1:1 D1:1
       (Point 31 640)
       (Point 31 650)
       (Point 42 650)
      )
      (connect D15:1 D2:1
       (Point 157 490)
       (Point 170 490)
       (Point 170 630)
       (Point 194 630)
      )
      (connect D1:1 D2:2
       (Point 157 650)
       (Point 194 650)
      )
      (connect D19:0 D3:0
       (Point 640 744)
       (Point 640 770)
      )
      (connect D19:1 D3:1
       (Point 870 710)
       (Point 890 710)
       (Point 890 750)
       (Point 390 750)
       (Point 390 820)
       (Point 409 820)
      )
      (connect I1:1 D3:2
       (Point 31 640)
       (Point 30 640)
       (Point 30 890)
       (Point 350 890)
       (Point 350 880)
       (Point 409 880)
      )
      (connect D2:1 D4:1
       (Point 245 640)
       (Point 262 640)
      )
      (connect D1:0 D5:0
       (Point 100 665)
       (Point 100 680)
       (Point 80 680)
       (Point 80 699)
      )
      (connect D16:1 D6:1
       (Point 867 560)
       (Point 880 560)
       (Point 880 590)
       (Point 870 590)
       (Point 870 640)
       (Point 800 640)
       (Point 800 630)
       (Point 400 630)
       (Point 400 680)
       (Point 320 680)
       (Point 320 700)
       (Point 334 700)
      )
      (connect D12:1 D6:2
       (Point 351 810)
       (Point 370 810)
       (Point 370 780)
       (Point 320 780)
       (Point 320 720)
       (Point 334 720)
      )
      (connect D10:0 D7:0
       (Point 180 785)
       (Point 180 830)
       (Point 260 830)
       (Point 260 845)
      )
      (connect D5:0 D8:0
       (Point 80 741)
       (Point 80 760)
       (Point 110 760)
       (Point 110 845)
      )
      (connect D1:0 D9:0
       (Point 100 665)
       (Point 100 680)
       (Point 180 680)
       (Point 180 699)
      )
      (connect D9:1 D10:0
       (Point 220 720)
       (Point 240 720)
       (Point 240 750)
       (Point 180 750)
       (Point 180 755)
      )
      (connect D10:1 D11:1
       (Point 205 770)
       (Point 224 770)
      )
      (connect D3:0 D11:2
       (Point 640 901)
       (Point 640 920)
       (Point 390 920)
       (Point 390 840)
       (Point 270 840)
       (Point 270 820)
       (Point 210 820)
       (Point 210 790)
       (Point 224 790)
      )
      (connect D11:1 D12:0
       (Point 275 780)
       (Point 310 780)
       (Point 310 795)
      )
      (connect D0:1 D13:0
       (Point 157 550)
       (Point 180 550)
       (Point 180 480)
       (Point 460 480)
       (Point 460 496)
      )
      (connect I1:1 D13:1
       (Point 31 640)
       (Point 30 640)
       (Point 30 600)
       (Point 160 600)
       (Point 160 570)
       (Point 191 570)
      )
      (connect I1:1 D14:1
       (Point 31 640)
       (Point 30 640)
       (Point 30 420)
       (Point 43 420)
      )
      (connect D14:0 D15:0
       (Point 230 455)
       (Point 230 470)
       (Point 100 470)
       (Point 100 475)
      )
      (connect I1:1 D15:1
       (Point 31 640)
       (Point 30 640)
       (Point 30 490)
       (Point 42 490)
      )
      (connect D13:1 D16:1
       (Point 729 550)
       (Point 752 550)
      )
      (connect D13:2 D16:2
       (Point 729 590)
       (Point 740 590)
       (Point 740 570)
       (Point 752 570)
      )
      (connect D16:0 D17:0
       (Point 810 575)
       (Point 810 595)
      )
      (connect D5:1 D19:0
       (Point 116 720)
       (Point 130 720)
       (Point 130 670)
       (Point 390 670)
       (Point 390 640)
       (Point 640 640)
       (Point 640 647)
      )
      (connect D6:1 D19:1
       (Point 385 710)
       (Point 409 710)
      )
     )
     (stackingOrder 0 1 2 3 4 5 6 7 8 9
       10 11 12 13 14 15 16 17 18 19)
    )
    (active detail)
   )
  )
  (component 3 "NOTE"
   (name "To Operate:")
   (interface
   )
   (implementation
    (component text 2 5
     <-- Enter a Filename that has some text you want to edit,
         then press RETURN.
    )
   )
   (views
    (icon
     (extent 110 0)
    )
    (detail
     (origin 312 240)
     (extent 577 40)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 4 "EXITPROCESS"
   (interface
    (sequence in)
   )
   (implementation
    (comp code 0)
   )
   (views
    (icon
     (iconImage "stop.icon")
    )
    (detail
     (origin 420 1003)
     (extent 120 34)
    )
    (active detail)
   )
  )
  (component 5 "CONTEXT"
   (name "Press For")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (locked no)
    (trigMode deg)
    (nextID 4)
    (component 0 "IFTHENELSE"
     (name "!= 0")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a!=0")
     )
     (views
      (icon
       (origin 365 350)
       (extent 46 25)
      )
      (detail
       (origin 209 308)
       (extent 73 64)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "TOGGLE"
     (name "Info About")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Reset")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Info About")
       (values range 0 1)
       (datum 0)
      )
      (component autoTrigger on)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (name "LongInt")
       (datum 0)
      )
     )
     (views
      (icon
       (origin 201 343)
       (extent 114 39)
       (format button)
      )
      (detail
       (origin 320 203)
       (extent 42 54)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "REPEATUNTILBREAK"
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Continuous")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 115 268)
       (extent 110 64)
       (iconImage "loop.icon")
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 3 "CONTEXT"
     (name "Info About This Example")
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (locked no)
      (trigMode deg)
      (nextID 2)
      (component 0 "NOTE"
       (name "NotePad")
       (description 2 8
        This notepad is displayed as a Show on Execute
        panel to present the information to the reader.
       )
       (interface
       )
       (implementation
        (component text 25 9
         PURPOSE:      Uses the Text Constant device to implement a (limited) text editor.
         
         USER INPUT REQUIRED:  Enter a filename, press Return, and the editor will appear.
         
         EXPLANATION:  Although somewhat limited, this example shows a method of editing
                       text using Vee, as opposed to running an editor from the Execute Program 
                       object.  
         
                       Because the "Text Constant" object was not designed for use as a Text
                       Edit window, several edit operations are somewhat different.  For
                       example, the TAB key is used to move to the next "line", and cannot
                       be inserted into the text file.  When positioned at the last line,
                       a TAB will create ONE new line for input.  If several "blank" lines
                       are needed at the end, temporarily create a dummy line with some text
                       and use the Insert Line key to create the black lines about it, then
                       delete or edit the dummy line.
         
                       Because X-windows/ Motif style guides mandate that the "Return" key be
                       used to terminate editing on a field, you will have to learn not to use
                       the Return to try to advance to the next line; instead, the TAB key is
                       preferred.
         
                       You can move around the edit window with the keyboard Arrows, Prev and
                       Next keys, etc.  You can also use Emacs key mappings if you know them.
         
        )
       )
       (views
        (icon
         (origin 411 408)
         (extent 78 25)
        )
        (detail
         (origin 26 202)
         (extent 848 437)
         (editing disabled)
        )
        (active detail)
       )
      )
      (component 1 "CONFIRM"
       (name "DONE")
       (description 7 8
        This tiny "thread" begins running when the 
        enclosing UserObject is executed.  When the user
        acknowledges the OK/DONE button, there is nothing
        left to execute, so the thread ends.  Since there
        are not other threads running, the User Object
        is completed and will exit, removing the Show on
        Execute pop-up display.
       )
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 421 472)
         (extent 58 37)
        )
        (detail
         (origin 156 253)
         (extent 79 34)
        )
        (terminals on)
        (active icon)
       )
      )
      (configuration
      )
      (ShowOnExecPanel
       (origin 55 78)
       (extent 849 561)
       (panel
        (origin 38 164)
        (extent 845 533)
        (widget 0 detail
         (title off)
         (origin 51 176)
         (extent 816 465)
         (editing disabled)
        )
        (widget 1 icon
         (title off)
         (origin 437 649)
         (extent 58 37)
        )
       )
      )
     )
     (views
      (icon
       (origin 352 418)
       (extent 217 25)
      )
      (detail
       (origin 17 160)
       (extent 866 520)
       (configuration
       )
       (stackingOrder 1 0)
      )
      (active icon)
     )
    )
    (configuration
     (connect D1:1 D0:1)
     (connect D2:1 D1:0)
     (connect D3:0 D1:1)
     (connect D0:1 D3:0)
    )
   )
   (views
    (icon
     (origin 475 628)
     (extent 110 25)
    )
    (panel
     (origin 21 112)
     (extent 319 77)
     (widget 1 icon
      (title off)
      (origin 123 125)
      (extent 114 39)
      (format button)
     )
    )
    (detail
     (origin 4 115)
     (extent 912 591)
     (configuration
      (connect D1:1 D0:1
       (Point 317 362)
       (Point 362 362)
      )
      (connect D2:1 D1:0
       (Point 227 300)
       (Point 258 300)
       (Point 258 340)
      )
      (connect D3:0 D1:1
       (Point 460 445)
       (Point 460 460)
       (Point 180 460)
       (Point 180 362)
       (Point 198 362)
      )
      (connect D0:1 D3:0
       (Point 413 352)
       (Point 460 352)
       (Point 460 415)
      )
     )
     (stackingOrder 0 1 2 3)
    )
    (active panel)
    (active panel)
   )
  )
  (configuration
   (connect D1:1 D2:1)
   (connect D2:0 D4:0)
  )
 )
 (views
  (detail
   (origin 0 62)
   (extent 931 609)
   (configuration
    (connect D1:1 D2:1
     (Point 253 260)
     (Point 260 260)
     (Point 260 290)
     (Point 10 290)
     (Point 10 640)
     (Point 26 640)
    )
    (connect D2:0 D4:0
     (Point 480 949)
     (Point 480 972)
    )
   )
   (stackingOrder 0 1 2 3 4 5)
  )
  (active detail)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
