#! /usr/lib/veetest/veetest -r
(revision "B.00.00")
(date "Mon 26/Oct/1992")
(component 0 "ROOTCONTEXT"
 (name "String Function Example")
 (interface
 )
 (implementation
  (locked no)
  (trigMode deg)
  (nextID 8)
  (component 0 "LITERALCONSTANT"
   (name "String")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Text")
     (lock name constraints)
    )
   )
   (implementation
    (component value Text
     (name "String")
     (datum "supercalifragalistic")
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Text
     (name "CString")
     (datum "")
    )
   )
   (views
    (icon
     (extent 78 0)
    )
    (detail
     (origin 10 256)
     (extent 201 28)
    )
    (active detail)
   )
  )
  (component 1 "NOTE"
   (name "To Operate:")
   (interface
   )
   (implementation
    (component text 3 5
     Enter some String data
     and other parameters,
     then press RUN.
    )
   )
   (views
    (icon
     (extent 110 0)
     (iconImage "notepad.icon")
    )
    (detail
     (origin 350 111)
     (extent 221 79)
     (editing enabled)
    )
    (active detail)
   )
  )
  (component 2 "NOTE"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 4 5
     This example is provided as an
     illustration "as is", and Hewlett-Packard
     Company makes no warranty of any kind
     with regard to this example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 592 108)
     (extent 396 84)
     (editing enabled)
    )
    (active detail)
   )
  )
  (component 3 "LITERALCONSTANT"
   (name "Reg. Expr.")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Text")
     (lock name constraints)
    )
   )
   (implementation
    (component value Text
     (name "Reg. Expr.")
     (datum ".*\\(li.*li\\)")
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Text
     (name "CString")
     (datum "")
    )
   )
   (views
    (icon
     (extent 110 0)
    )
    (detail
     (origin 10 386)
     (extent 201 28)
    )
    (active detail)
   )
  )
  (component 4 "SHELLESCAPE"
   (name "match(string,regexp)")
   (description 18 4
    Examines "string" for the first match with the
    Basic Regular Expression (see regexp(5)).  Since
    all patterns are anchored to the beginning of the
    string, ^ is not a r.e. metachar.   Because of 
    this anchoring, regular expression must include
    all characters beginning with the first; matching
    only chars in the middle of the string is not
    directly supported.
    
    Normally, match() returns the number of characters
    that are matched by the regular expression.  An
    alternative is to return the (sub)set of chars
    from the match by using the \( and \) metachars.
    If such a regular expression matches the string,
    the characters within the \(..\) will be returned
    instead of the match count.  If no match occurs,
    0 will still be returned.
    
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "string")
     (requires
      (datatype Text)
      (shape "Scalar")
     )
     (optional yes)
    )
    (input 2
     (type data)
     (name "regexp")
     (requires
      (datatype Text)
      (shape "Scalar")
     )
     (optional yes)
    )
    (output 1
     (type data)
     (name "Exit code")
     (lock name constraints)
    )
    (output 2
     (type data)
     (name "X")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (attr iopath pipe read "pipe"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (attr iopath pipe write "pipe"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (procedure
      WRITE TEXT "expr \'",string,"\' : \'",regexp,"\'" EOL
      READ TEXT x TOKEN EXCLUDE:"\n"
    )
    (component shell "none")
    (component command "/bin/sh -s")
    (component deathWait "Yes")
   )
   (views
    (icon
     (origin 265 323)
     (extent 190 34)
    )
    (detail
     (origin 327 264)
     (extent 496 132)
    )
    (terminals on)
    (active detail)
   )
  )
  (component 5 "TEXTDISPLAY"
   (name "Error Code")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 110 0)
    )
    (detail
     (origin 762 515)
     (extent 176 31)
    )
    (active detail)
   )
  )
  (component 6 "TEXTDISPLAY"
   (name "Match data")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 110 0)
    )
    (detail
     (origin 455 513)
     (extent 251 34)
    )
    (active detail)
   )
  )
  (component 7 "CONTEXT"
   (name "Press For")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (locked no)
    (trigMode deg)
    (nextID 3)
    (component 0 "IFTHENELSE"
     (name "!= 0")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a!=0")
     )
     (views
      (icon
       (origin 365 350)
       (extent 46 25)
      )
      (detail
       (origin 209 308)
       (extent 73 64)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "TOGGLE"
     (name "Info About")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Reset")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Info About")
       (values range 0 1)
       (datum 0)
      )
      (component autoTrigger on)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (name "LongInt")
       (datum 0)
      )
     )
     (views
      (icon
       (origin 201 343)
       (extent 114 39)
       (format button)
      )
      (detail
       (origin 320 203)
       (extent 42 54)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "CONTEXT"
     (name "Info About This Example")
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (locked no)
      (trigMode deg)
      (nextID 2)
      (component 0 "NOTE"
       (name "NotePad")
       (description 2 8
        This notepad is displayed as a Show on Execute
        panel to present the information to the reader.
       )
       (interface
       )
       (implementation
        (component text 19 9
         PURPOSE:     Provides a string extraction object using "expr" command.
         
         USER INPUT REQUIRED:  Adjust the "string", if desired, then press RUN.
         
         EXPLANATION: Using the Execute Program object to run the "expr" command provides a way to
                   implement an unusual string function needed to parse text data using a
                   regular expression.  Because expr is rather good about always sending 
                   something to stdout, the extra tests to examine the expr exit code is
                   not usually needed before the READ TOKEN input transaction.  
         
                   Each object has a Show Description that explains the usage and limitations of
                   the implementation.  The man pages for "expr" may be of additional use to
                   determine the behavior of these objects for special cases.  
         
                   NOTE:  The READ TOKEN EXCLUDE: "\n" operation is used to allow a nil string
                   to be returned if expr outputs only a "\n" to stdout.  The STRING format would
                   have skipped over the newline and hung waiting for non-whitespace output!
         
         
        )
       )
       (views
        (icon
         (origin 410 415)
         (extent 78 25)
        )
        (detail
         (origin 25 209)
         (extent 848 437)
         (editing disabled)
        )
        (active detail)
       )
      )
      (component 1 "CONFIRM"
       (name "DONE")
       (description 7 8
        This tiny "thread" begins running when the 
        enclosing UserObject is executed.  When the user
        acknowledges the OK/DONE button, there is nothing
        left to execute, so the thread ends.  Since there
        are not other threads running, the User Object
        is completed and will exit, removing the Show on
        Execute pop-up display.
       )
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 421 482)
         (extent 58 37)
        )
        (detail
         (origin 156 253)
         (extent 79 34)
        )
        (terminals on)
        (active icon)
       )
      )
      (configuration
      )
      (ShowOnExecPanel
       (origin 0 29)
       (extent 849 561)
       (panel
        (origin 38 164)
        (extent 845 533)
        (widget 1 icon
         (title off)
         (origin 437 649)
         (extent 58 37)
        )
        (widget 0 detail
         (title off)
         (origin 49 174)
         (extent 827 463)
         (editing disabled)
        )
       )
      )
     )
     (views
      (icon
       (origin 352 418)
       (extent 217 25)
      )
      (detail
       (origin 17 160)
       (extent 866 520)
       (configuration
       )
       (stackingOrder 1 0)
      )
      (active icon)
     )
    )
    (configuration
     (connect D1:1 D0:1)
     (connect D2:0 D1:1)
     (connect D0:1 D2:0)
    )
   )
   (views
    (icon
     (origin 475 628)
     (extent 110 25)
    )
    (panel
     (origin 11 112)
     (extent 319 77)
     (widget 1 icon
      (title off)
      (origin 113 125)
      (extent 114 39)
      (format button)
     )
    )
    (detail
     (origin 4 115)
     (extent 912 591)
     (configuration
      (connect D1:1 D0:1
       (Point 317 362)
       (Point 362 362)
      )
      (connect D2:0 D1:1
       (Point 460 445)
       (Point 460 460)
       (Point 180 460)
       (Point 180 362)
       (Point 198 362)
      )
      (connect D0:1 D2:0
       (Point 413 352)
       (Point 460 352)
       (Point 460 415)
      )
     )
     (stackingOrder 0 1 2)
    )
    (active panel)
    (active panel)
   )
  )
  (configuration
   (connect D0:1 D4:1)
   (connect D3:1 D4:2)
   (connect D4:1 D5:1)
   (connect D4:2 D6:1)
  )
 )
 (views
  (detail
   (origin 0 62)
   (extent 980 643)
   (configuration
    (connect D0:1 D4:1
     (Point 213 270)
     (Point 230 270)
     (Point 230 300)
     (Point 254 300)
    )
    (connect D3:1 D4:2
     (Point 213 400)
     (Point 230 400)
     (Point 230 360)
     (Point 254 360)
    )
    (connect D4:1 D5:1
     (Point 925 300)
     (Point 950 300)
     (Point 950 430)
     (Point 740 430)
     (Point 740 530)
     (Point 759 530)
    )
    (connect D4:2 D6:1
     (Point 925 360)
     (Point 940 360)
     (Point 940 420)
     (Point 430 420)
     (Point 430 530)
     (Point 452 530)
    )
   )
   (stackingOrder 0 1 2 3 4 5 6 7)
  )
  (active detail)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
