#! /usr/lib/veetest/veetest -r
(revision "A.00.01")
(date "Sun 22/Sep/1991")
(component 0 "Context"
 (name "Fluidflow Example")
 (interface
 )
 (implementation
  (trigMode deg)
  (locked no)
  (component 0 "Constant"
   (name "Coefficient")
   (description 10 4
    This "Data -> Constant -> Real" object is used
    to enter the Orifice Coefficient, which is
    dependent on the orifice structure.  For example,
    two coefficients for a cylindrical orifice:
    
      Thick plate, with a small orifice
      diameter:                    (4d>t>=2d) -> .82
    
      Beveled orifice, or thin plate with
      a large orifice diameter:    (t<d/4)    -> .61
   )
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Coefficient")
     (datum 0.82)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
   )
   (views
    (icon
     (extent 110 0)
    )
    (detail
     (origin 35 634)
     (extent 191 31)
    )
    (active detail)
   )
  )
  (component 1 "ForRange"
   (name "Orifice Dia. in.")
   (description 8 4
    This "Data -> Repeat -> For Count" object
    provides input to define the range of orifice
    diameters to be used in calculations, and 
    controls the number of graphs plotted.
    
    The "sequence in" connection from the "Build
    Array" object ensures that this object will not
    activate until the array is built.
   )
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component from 0.2)
    (component thru 1)
    (component step 0.2)
   )
   (views
    (icon
     (extent 154 0)
     (iconImage "loop.icon")
    )
    (detail
     (origin 28 473)
     (extent 205 93)
    )
    (active detail)
   )
  )
  (component 2 "Context"
   (name "Press For")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "IfThenElse"
     (name "!= 0")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a!=0")
     )
     (views
      (icon
       (origin 365 350)
       (extent 46 25)
      )
      (detail
       (origin 209 308)
       (extent 73 64)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "Toggle"
     (name "Info About")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Reset")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Info About")
       (values range 0 1)
       (datum 0)
      )
      (component autoTrigger on)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (datum 0)
      )
     )
     (views
      (icon
       (origin 201 343)
       (extent 114 39)
       (format button)
      )
      (detail
       (origin 320 203)
       (extent 42 54)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "Context"
     (name "Info About this Example")
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Note"
       (name "Note Pad")
       (interface
       )
       (implementation
        (component text 45 9
         PURPOSE:     Show a simple Mechanical Engineering problem setup and solution.  It also
                      shows methods of data entry and display, the use of arrays and calculation
                      formula, and simple sequence control.
         
         USER DATA REQUIRED: None.  Click on "Start" to run the model. You may change any value
                      by clicking on the entry field of an object and entering a new value:
         
                      Maximum Fluid Head (feet) - Data points based on 1/10th of Maximum.
                      Orfice DIameter (inches)  - set using "From, Thru, Step Range" values.
                      Orfice Coefficient
         
         EXPLANATION: The model uses a simple formula to calculate the water flow volume (gpm)
                      from an orifice in a tank wall, based on the height of water ("head", in
                      feet) above the orifice (with diameter in inches).  The .82 orifice
                      coefficient corresponds to a cylindrical hole in a tank wall of thickness
                      two or three times the orifice diameter.  (Another coefficient example
                      would be .61 for a beveled orifice, or for a relatively large orifice in
                      a thin wall.)
         
                      This example also demonstrates some basic HP VEE capabilities, such as
                      graphically displaying ranges of flow depending on various head and orifice
                      values.  The model was built using the panel approach for simplified entry
                      and viewing of the data.  More specifics of the model can be seen by
                      clicking on the "Detail" button, located on the left side of the title bar.
                      The detail view shows the objects, some in an iconized state, and the data
                      and sequence interconnections.  To see the open view of an icon, double-
                      click on it with the left mouse button.
         
                      The multiple generation of curves provides an example of the need for
                      sequence control, which is done by using a "For Count" object (generates a
                      range of values for orifice diameter) that has its sequence controlled by
                      the "Generate Head Values" object,  which uses a "Ramp Formula" to generate
                      evenly spaced values in an array.  This is necessary to ensure that the
                      array (which contains "head" values) has been completed before the "For
                      Count" object activates.  A specific diameter value is used along with the
                      orifice coefficient and the "head" array as inputs to the "Formula" object,
                      which then calculates an array output as an individual line on the plot
                      display.  Each new diameter value also triggers a "Next Curve" input to the
                      display, as well as the calculation of a new output array.
         
                      Select  "Show Description" from the object menu on each object to gain more
                      information about the function of the object.  From this menu you may also
                      directly access the "Help" information for the object.
         
                      Click on "DONE" to exit this information panel.
        )
       )
       (views
        (icon
         (origin 385 408)
         (extent 110 25)
        )
        (detail
         (origin 26 230)
         (extent 828 381)
         (editing disabled)
        )
        (active icon)
       )
      )
      (component 1 "Confirm"
       (name "DONE")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 411 462)
         (extent 58 37)
        )
        (detail
         (origin 590 510)
         (extent 50 40)
        )
        (terminals on)
        (active icon)
       )
      )
      (configuration
      )
      (ShowOnExecPanel
       (origin 24 77)
       (extent 851 534)
       (panel
        (origin 27 172)
        (extent 847 496)
        (widget 0 detail
         (title off)
         (origin 40 186)
         (extent 825 417)
         (editing disabled)
        )
        (widget 1 icon
         (title off)
         (origin 419 618)
         (extent 58 37)
        )
       )
      )
     )
     (views
      (icon
       (origin 342 408)
       (extent 217 25)
      )
      (detail
       (origin 11 176)
       (extent 858 469)
       (configuration
       )
      )
      (active icon)
     )
    )
    (configuration
     (connect D1:1 D0:1)
     (connect D2:0 D1:1)
     (connect D0:1 D2:0)
    )
   )
   (views
    (icon
     (origin 415 408)
     (extent 110 25)
    )
    (panel
     (origin 11 122)
     (extent 319 77)
     (widget 1 icon
      (title off)
      (origin 113 135)
      (extent 114 39)
      (format button)
     )
    )
    (detail
     (origin 4 115)
     (extent 912 591)
     (configuration
      (connect D1:1 D0:1
       (Point 317 362)
       (Point 362 362)
      )
      (connect D2:0 D1:1
       (Point 450 435)
       (Point 450 450)
       (Point 180 450)
       (Point 180 362)
       (Point 198 362)
      )
      (connect D0:1 D2:0
       (Point 413 352)
       (Point 450 352)
       (Point 450 405)
      )
     )
    )
    (active panel)
    (active panel)
   )
  )
  (component 3 "XYPlot"
   (name "Water Flow vs. Head vs. Orifice Dia.")
   (description 12 4
    This "Display -> X vs Y Plot" object is used to
    provide a plot of calculated results for each
    orifice diameter in the specified range, based on
    the input "head" array and orifice coefficient.
    The triangular marker in the display may be set
    to show the values of any point of interest by
    clicking on that point.  By using the display's
    object menu, you may observe various optional
    settings.  The appearance of the display can be
    significantly altered by changing some of these
    settings.
     
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "XData")
     (lock constraints)
    )
    (input 2
     (type data)
     (name "Water Flow")
     (lock constraints)
    )
    (input 3
     (type control)
     (name "Next Curve")
     (lock name constraints)
     (optional yes)
    )
    (input 4
     (type control)
     (name "Auto Scale")
     (lock name constraints)
     (optional yes)
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
    (component tracePin 2)
    (component graphMode rectangular)
   )
   (views
    (icon
     (origin 603 468)
     (extent 334 64)
     (iconImage "display.icon")
    )
    (detail
     (origin 489 253)
     (extent 463 475)
     (displayMode scrollGraph)
     (graphType cartesian)
     (gridType grid)
     (scale 0
      (name "Gal./Min.")
      (domainName "Water \"Head\" in Tank (feet)")
      (pen 9)
      (show 1)
      (range 0 250 3 linear)
     )
     (domain 0 200 3 linear)
     (trace 0 onScale 0
      (name "Water Flow")
      (pen 4)
      (lineType 1)
      (pointType 1)
     )
     (marker 0 onTrace 0)
    )
    (active detail)
   )
  )
  (component 4 "Formula"
   (name "Formula")
   (description 17 4
    This "Math -> Formula" object contains the basic
    formula for the model: (19.64*C)*(D^2)*(H^.5)
    where C is the orifice coefficient;
          D is the orifice diameter, inches;
      and H is the water height in the tank, feet.
    
    The constant 19.64 is derived from combining the
    gravity constant and various conversion constants
    to yield gallons per minute flow values:
     (((2*32.174)^.5)*(pi/576)*((12^3)/231)*60)
    
    Based on equation of flow: Q = C*Area*Velocity,
    which in terms of head and orifice diameter
    becomes, before simplification:
    
    (1728*60/231)*C*((PI/4)*(D/12)^2)*(2*32.174*H)^.5
    
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "H")
     (optional yes)
    )
    (input 2
     (type data)
     (name "D")
     (optional yes)
    )
    (input 3
     (type data)
     (name "C")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "19.64*C*(D^2)*(H^.5)")
   )
   (views
    (icon
     (origin 375 394)
     (extent 91 72)
     (iconImage "formula.icon")
    )
    (detail
     (origin 158 335)
     (extent 214 150)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 5 "Formula"
   (name "Generate Head Data")
   (description 13 4
    This formula box will generate the "Head" data
    used in the water flow calculation and on the 
    X-axis of the plot.
    
    The formula box demonstrates a way to generate
    data that is equidistantly spaced.  That is, the
    ramp function with correct choices of start and
    stop values will generate an array of data. 
    
    Math operations are many time faster when 
    operating on arrays of data than on a single value
    at a time.  Try to use them in your models to 
    speed up execution time.
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "numPts")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "ramp(numPts,10,numPts*10)")
   )
   (views
    (icon
     (origin 44 398)
     (extent 172 25)
    )
    (detail
     (origin 191 220)
     (extent 259 60)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 6 "Formula"
   (name " / ")
   (description 5 4
    This is a "Math -> +-*/ -> /" object used to
    divide the "Max. Head, ft." value by a simple
    scaling divisor, to determine the size of the
    divisions between one value of "head" and
    another.
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "X")
     (lock name constraints)
    )
    (input 2
     (type data)
     (name "Y")
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked yes)
    (component expr 1 "X/Y")
   )
   (views
    (icon
     (origin 267 318)
     (extent 46 25)
    )
    (detail
     (origin 277 838)
     (extent 79 104)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 7 "Constant"
   (name "Max. Head, ft.")
   (description 4 4
    This "Data -> Constant -> Real" object contains
    the value input for the maximum height ("head")
    of water in a tank to be considered, and defines
    the upper limit for calculations and plots.
   )
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Int32
     (name "Max. Head, ft.")
     (datum 200)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Int32
     (datum 0)
    )
   )
   (views
    (icon
     (origin 62 568)
     (extent 136 25)
    )
    (detail
     (origin 15 284)
     (extent 210 33)
    )
    (active detail)
   )
  )
  (component 8 "Constant"
   (name "SclDiv")
   (description 5 4
    This "Data -> Constant -> Integer" object is
    being used to hold a constant that defines the
    size of the array and the "Max.Head, ft." value
    will be subdivided for use in calculation and
    plotting.
   )
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Int32
     (name "SclDiv")
     (datum 10)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Int32
     (datum 0)
    )
   )
   (views
    (icon
     (origin 141 338)
     (extent 78 25)
    )
    (detail
     (origin 127 646)
     (extent 147 28)
    )
    (active icon)
   )
  )
  (component 9 "Note"
   (name "Note Pad")
   (description 5 4
    This "Display -> Note Pad" object is used on the
    panel in an open view, as an enunciator, in order
    to clarify the meaning of the multiple lines on
    the plot display.
     
   )
   (interface
   )
   (implementation
    (component text 3 5
     Each plot presents values 
     based on a specific orifice 
     diameter.
    )
   )
   (views
    (icon
     (origin 365 228)
     (extent 110 25)
    )
    (detail
     (origin 293 146)
     (extent 274 68)
     (editing disabled)
    )
    (active icon)
   )
  )
  (component 10 "Note"
   (name "1\"")
   (description 4 4
    This "Display -> Note Pad" object has had its
    title changed, and is being used as an icon to 
    provide a simple label to identify one of the
    plots.
   )
   (interface
   )
   (implementation
   )
   (views
    (icon
     (origin 957 218)
     (extent 46 25)
    )
    (detail
     (origin 780 134)
     (extent 180 90)
     (editing disabled)
    )
    (active icon)
   )
  )
  (component 11 "Note"
   (name ".6\"")
   (description 4 4
    This "Display -> Note Pad" object has had its
    title changed, and is being used as an icon to
    provide a simple label to identify one of the
    plots.
   )
   (interface
   )
   (implementation
   )
   (views
    (icon
     (origin 957 428)
     (extent 46 25)
    )
    (detail
     (origin 780 404)
     (extent 180 90)
     (editing enabled)
    )
    (active icon)
   )
  )
  (component 12 "Note"
   (name ".2\"")
   (description 4 4
    This "Display -> Note Pad" object has had its
    title changed, and is being used as an icon to
    provide a simple label to identify one of the
    plots.
   )
   (interface
   )
   (implementation
   )
   (views
    (icon
     (origin 957 608)
     (extent 46 25)
    )
    (detail
     (origin 780 545)
     (extent 180 90)
     (editing disabled)
    )
    (active icon)
   )
  )
  (component 13 "Note"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 5 5
     This example is provided as an
     illustration "as is", and Hewlett-
     Packard Company makes no warranty
     of any kind with regard to this
     example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 22 730)
     (extent 316 101)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 14 "Note"
   (name "To Operate")
   (description 5 4
    This is a "Display -> Note Pad" object, displayed
    on the panel in an open view, which is used to
    convey the basic information necessary to use
    this "Water Flow thru and Orifice" model.
    
   )
   (interface
   )
   (implementation
    (component text 3 5
     Click "Run" to see calculation
     results, or "Info About" for
     details.
    )
   )
   (views
    (icon
     (origin 365 155)
     (extent 110 30)
    )
    (detail
     (origin 545 120)
     (extent 311 61)
     (editing enabled)
    )
    (active detail)
   )
  )
  (configuration
   (connect D5:0 D1:0)
   (connect D5:1 D3:1)
   (connect D4:1 D3:2)
   (connect D1:1 D3:3)
   (connect D1:0 D3:4)
   (connect D5:1 D4:1)
   (connect D1:1 D4:2)
   (connect D0:1 D4:3)
   (connect D6:1 D5:1)
   (connect D7:1 D6:1)
   (connect D8:1 D6:2)
  )
 )
 (views
  (panel
   (origin 0 67)
   (extent 972 580)
   (widget 3 detail
    (title on)
    (origin 430 108)
    (extent 518 534)
    (displayMode scrollGraph)
    (graphType cartesian)
    (gridType grid)
    (scale 0
     (name "Flow, gpm")
     (domainName "Head (X)")
     (pen 9)
     (show 1)
     (range 0 250 3 linear)
    )
    (domain 0 200 3 linear)
    (trace 0 onScale 0
     (name "Water Flow")
     (pen 4)
     (lineType 1)
     (pointType 1)
    )
    (marker 0 onTrace 0)
   )
   (widget 10 icon
    (title off)
    (origin 878 134)
    (extent 35 20)
   )
   (widget 11 icon
    (title off)
    (origin 871 373)
    (extent 38 21)
   )
   (widget 12 icon
    (title off)
    (origin 879 493)
    (extent 37 19)
   )
   (widget 9 detail
    (title off)
    (origin 586 124)
    (extent 261 70)
    (editing disabled)
   )
   (widget 1 detail
    (title on)
    (origin 219 523)
    (extent 179 118)
   )
   (widget 7 detail
    (title on)
    (origin 24 523)
    (extent 180 32)
   )
   (widget 0 detail
    (title on)
    (origin 23 608)
    (extent 179 32)
   )
   (widget 14 detail
    (title on)
    (origin 54 106)
    (extent 320 60)
    (editing disabled)
   )
   (widget 2 panel
    (title on)
    (origin 53 217)
    (extent 320 76)
    (widget 1 icon
     (title off)
     (origin 155 230)
     (extent 114 39)
     (format button)
    )
   )
   (widget 13 detail
    (title on)
    (origin 52 349)
    (extent 320 102)
    (editing disabled)
   )
  )
  (detail
   (origin 0 67)
   (extent 1238 895)
   (configuration
    (connect D5:0 D1:0
     (Point 130 425)
     (Point 130 440)
    )
    (connect D5:1 D3:1
     (Point 218 410)
     (Point 360 410)
     (Point 360 310)
     (Point 486 310)
    )
    (connect D4:1 D3:2
     (Point 468 430)
     (Point 486 430)
    )
    (connect D1:1 D3:3
     (Point 235 519)
     (Point 260 519)
     (Point 260 550)
     (Point 486 550)
    )
    (connect D1:0 D3:4
     (Point 130 568)
     (Point 130 580)
     (Point 250 580)
     (Point 250 670)
     (Point 486 670)
    )
    (connect D5:1 D4:1
     (Point 218 410)
     (Point 372 410)
    )
    (connect D1:1 D4:2
     (Point 235 519)
     (Point 260 519)
     (Point 260 430)
     (Point 372 430)
    )
    (connect D0:1 D4:3
     (Point 228 649)
     (Point 270 649)
     (Point 270 450)
     (Point 372 450)
    )
    (connect D6:1 D5:1
     (Point 315 330)
     (Point 330 330)
     (Point 330 380)
     (Point 20 380)
     (Point 20 410)
     (Point 41 410)
    )
    (connect D7:1 D6:1
     (Point 227 300)
     (Point 250 300)
     (Point 250 320)
     (Point 264 320)
    )
    (connect D8:1 D6:2
     (Point 221 350)
     (Point 240 350)
     (Point 240 340)
     (Point 264 340)
    )
   )
  )
  (active panel)
  (active panel)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
