#! /usr/lib/veetest/veetest -r
(revision "A.00.01")
(date "Tue 10/Mar/1992")
(component 0 "Context"
 (name "Analog Filter Example")
 (interface
 )
 (implementation
  (trigMode deg)
  (locked no)
  (component 0 "XYPlot"
   (name "Magnitude vs. Frequency")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "XData")
     (lock constraints)
    )
    (input 2
     (type data)
     (name "low pass")
     (lock constraints)
    )
    (input 3
     (type data)
     (name "band pass")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
    (component tracePin 2)
    (component tracePin 3)
    (component graphMode rectangular)
   )
   (views
    (icon
     (extent 217 0)
     (iconImage "display.icon")
    )
    (detail
     (origin 590 122)
     (extent 360 296)
     (displayMode annotGraph)
     (graphType cartesian)
     (gridType grid)
     (scale 0
      (name "Magnitude")
      (domainName "Frequency")
      (pen 9)
      (show 1)
      (range 0.0001 1 4 log)
     )
     (domain 2 20000 4 log)
     (trace 0 onScale 0
      (name "low pass")
      (pen 4)
      (lineType 1)
      (pointType 0)
     )
     (trace 1 onScale 0
      (name "band pass")
      (pen 7)
      (lineType 1)
      (pointType 0)
     )
    )
    (active detail)
   )
  )
  (component 1 "XYPlot"
   (name "Phase vs. Frequency")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "XData")
     (lock constraints)
    )
    (input 2
     (type data)
     (name "low pass")
     (lock constraints)
    )
    (input 3
     (type data)
     (name "band pass")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
    (component tracePin 2)
    (component tracePin 3)
    (component graphMode rectangular)
   )
   (views
    (icon
     (extent 181 0)
     (iconImage "display.icon")
    )
    (detail
     (origin 590 462)
     (extent 360 296)
     (displayMode annotGraph)
     (graphType cartesian)
     (gridType grid)
     (scale 0
      (name "Phase")
      (domainName "Frequency")
      (pen 9)
      (show 1)
      (range -100 100 4 linear)
     )
     (domain 2 20000 4 log)
     (trace 0 onScale 0
      (name "low pass")
      (pen 4)
      (lineType 1)
      (pointType 0)
     )
     (trace 1 onScale 0
      (name "band pass")
      (pen 7)
      (lineType 1)
      (pointType 0)
     )
    )
    (active detail)
   )
  )
  (component 2 "Formula"
   (name "phase(x)")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "X")
     (lock name)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked yes)
    (component expr 1 "phase(x)")
   )
   (views
    (icon
     (origin 477 696)
     (extent 86 29)
    )
    (detail
     (origin 492 600)
     (extent 116 60)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 3 "Formula"
   (name "mag(x)")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "X")
     (lock name)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked yes)
    (component expr 1 "mag(x)")
   )
   (views
    (icon
     (origin 496 256)
     (extent 68 29)
    )
    (detail
     (origin 512 160)
     (extent 96 60)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 4 "Formula"
   (name "mag(x)")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "X")
     (lock name)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked yes)
    (component expr 1 "mag(x)")
   )
   (views
    (icon
     (origin 496 356)
     (extent 68 29)
    )
    (detail
     (origin 512 260)
     (extent 96 60)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 5 "Formula"
   (name "ramp")
   (description 13 4
    The "ramp(numElem,from,thru)" function generates
    a 1D array whose size is "numElem" long.  The 
    values in the array are evenly spaced starting 
    at the "from" value and ending with the "thru"
    value.
    
    A "For Range" object could have been used to 
    generate the same numbers one at a time.  In HP 
    VEE, however, arrays are processed almost as fast
    as scalars by "Formula" objects and displays.  
    Thus, more efficient models use array builders 
    rather than iterators wherever possible.
    
   )
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name " ")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "ramp(1000,0,20000)")
   )
   (views
    (icon
     (origin 217 476)
     (extent 46 29)
    )
    (detail
     (origin 169 568)
     (extent 223 45)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 6 "Formula"
   (name "phase(x)")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "X")
     (lock name)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked yes)
    (component expr 1 "phase(x)")
   )
   (views
    (icon
     (origin 467 536)
     (extent 86 29)
    )
    (detail
     (origin 492 500)
     (extent 116 60)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 7 "Constant"
   (name "fo")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "fo")
     (datum 500)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
   )
   (views
    (icon
     (extent 32 0)
    )
    (detail
     (origin 46 703)
     (extent 89 35)
    )
    (active detail)
   )
  )
  (component 8 "Constant"
   (name "Q")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Q")
     (datum 5)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
   )
   (views
    (icon
     (origin 207 598)
     (extent 46 25)
    )
    (detail
     (origin 48 623)
     (extent 85 34)
    )
    (active detail)
   )
  )
  (component 9 "Constant"
   (name "pole")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "pole")
     (datum 500)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
   )
   (views
    (icon
     (extent 50 0)
    )
    (detail
     (origin 41 545)
     (extent 98 30)
    )
    (active detail)
   )
  )
  (component 10 "Formula"
   (name "low pass")
   (description 13 4
    This is the formula for the transfer function of
    a one pole low pass filter.  The LaPlace transform
    would be:
               a
      H(s)= --------
             a + s
    
    where "a" is the location of the pole.  To 
    generate a spectrum, we substituted " jf" for 
    "s".
    
    
      
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "f")
     (optional yes)
    )
    (input 2
     (type data)
     (name "a")
     (optional yes)
    )
    (output 1
     (type data)
     (name " ")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "a/(a+j(f))")
   )
   (views
    (icon
     (origin 317 536)
     (extent 86 29)
    )
    (detail
     (origin 360 487)
     (extent 151 86)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 11 "Start"
   (name "Start")
   (interface
    (sequence out)
   )
   (implementation
   )
   (views
    (icon
     (origin 206 411)
     (extent 69 39)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 12 "Note"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 5 5
     This example is provided as an
     illustration "as is", and 
     Hewlett-Packard Company makes 
     no warranty of any kind
     with regard to this example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 35 271)
     (extent 291 99)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 13 "Context"
   (name "Press For")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "IfThenElse"
     (name "!= 0")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a!=0")
     )
     (views
      (icon
       (origin 325 310)
       (extent 46 25)
      )
      (detail
       (origin 209 308)
       (extent 73 64)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "Toggle"
     (name "Info About")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Reset")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Info About")
       (values range 0 1)
       (datum 0)
      )
      (component autoTrigger on)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (datum 0)
      )
     )
     (views
      (icon
       (origin 161 303)
       (extent 114 39)
       (format button)
      )
      (detail
       (origin 320 203)
       (extent 42 54)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "Context"
     (name "Info About...")
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Confirm"
       (name "DONE")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 370 519)
         (extent 58 37)
        )
        (detail
         (origin 466 633)
         (extent 79 34)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "Note"
       (name "Overview of Analog Filter Example")
       (interface
       )
       (implementation
        (component text 34 9
         PURPOSE:     This example shows how to display the transfer function of a filter,
                      and how to use array math rather than iterators.
         
         USER INPUT REQUIRED:  None. Simply click on "Start".
         
         EXPLANATION: The magnitude and phase response of two filters, a one pole low pass
                      and a two pole band pass, are calculated  and displayed.
         
                      The "Formula" object titled "ramp" generates a 1D array containing 1000
                      numbers equally spaced from 0 to 20,000.  The range and number of points
                      can be edited to any frequency range of interest.  Look at its "Show 
                      Description" for more information.
         
                      The "Formula" objects titled "low pass" and "band pass" apply a function
                      to each element in the input array.  The result is an array of complex
                      numbers, one for each  frequency.  Their "Show Descriptions"  explain
                      their operation in more detail.
         
                      The "mag(x)" object calculates the magnitude of each complex number in
                      the array.  The result is also an array.  The phase(x) object calculates
                      the phase of each complex number in the array.  The units of the phase
                      result is determined by the "Trig Mode" setting under "Preferences" in
                      the "File" menu.
         
                      The magnitude and phase are displayed in "XY Trace" displays.  The X
                      input in each case is the array of frequencies.  The Y inputs come from
                      the respective "mag(x) " and  "phase(x)" objects.
         
                      This example allows you to change characteristics of the filter by
                      entering numbers in a "Constant" object.  These could also be sliders.
         
                      You can analyze other transfer characteristics by changing the "Formula"
                      objects. 
         
        )
       )
       (views
        (icon
         (origin 537 558)
         (extent 307 25)
        )
        (detail
         (origin 208 334)
         (extent 384 252)
         (editing disabled)
        )
        (active detail)
       )
      )
      (configuration
      )
      (ShowOnExecPanel
       (origin 64 117)
       (extent 835 522)
       (panel
        (origin 35 158)
        (extent 831 484)
        (widget 0 icon
         (title off)
         (origin 417 589)
         (extent 58 37)
        )
        (widget 1 detail
         (title off)
         (origin 50 168)
         (extent 804 397)
         (editing disabled)
        )
       )
      )
     )
     (views
      (icon
       (origin 387 388)
       (extent 127 25)
      )
      (detail
       (origin 205 290)
       (extent 351 200)
       (configuration
       )
      )
      (active icon)
     )
    )
    (configuration
     (connect D1:1 D0:1)
     (connect D0:0 D1:1)
     (connect D0:1 D2:0)
    )
   )
   (views
    (icon
     (origin 435 388)
     (extent 110 25)
    )
    (panel
     (origin 11 122)
     (extent 319 77)
     (widget 1 icon
      (title off)
      (origin 113 135)
      (extent 114 39)
      (format button)
     )
    )
    (detail
     (origin 1 115)
     (extent 879 551)
     (configuration
      (connect D1:1 D0:1
       (Point 277 322)
       (Point 322 322)
      )
      (connect D0:0 D1:1
       (Point 348 337)
       (Point 348 360)
       (Point 140 360)
       (Point 140 322)
       (Point 158 322)
      )
      (connect D0:1 D2:0
       (Point 373 312)
       (Point 450 312)
       (Point 450 385)
      )
     )
    )
    (active panel)
    (active panel)
   )
  )
  (component 14 "Formula"
   (name "band pass")
   (description 14 4
    The LaPlace transform for a two pole bandpass
    filter is:
                    2
                   s  fo/Q
      H(s) = ------------------------
                2              2
               s  - s fo/Q - fo
    
    where "fo" is the frequency of maximum response 
    and "Q" is the selectivity of the filter.
    
    To display the spectrum, we substituted "jf" for
    "s".
    
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "f")
     (optional yes)
    )
    (input 2
     (type data)
     (name "Q")
     (optional yes)
    )
    (input 3
     (type data)
     (name "fo")
     (optional yes)
    )
    (output 1
     (type data)
     (name " ")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "j(f*(fo/Q))/((fo^2-f^2)+j(f*fo/Q))")
   )
   (views
    (icon
     (origin 313 693)
     (extent 95 34)
    )
    (detail
     (origin 115 427)
     (extent 340 126)
    )
    (terminals on)
    (active icon)
   )
  )
  (configuration
   (connect D5:1 D0:1)
   (connect D3:1 D0:2)
   (connect D4:1 D0:3)
   (connect D5:1 D1:1)
   (connect D6:1 D1:2)
   (connect D2:1 D1:3)
   (connect D14:1 D2:1)
   (connect D10:1 D3:1)
   (connect D14:1 D4:1)
   (connect D11:0 D5:0)
   (connect D10:1 D6:1)
   (connect D5:1 D10:1)
   (connect D9:1 D10:2)
   (connect D5:1 D14:1)
   (connect D8:1 D14:2)
   (connect D7:1 D14:3)
  )
 )
 (views
  (detail
   (origin 0 67)
   (extent 1004 664)
   (configuration
    (connect D5:1 D0:1
     (Point 265 490)
     (Point 280 490)
     (Point 280 510)
     (Point 430 510)
     (Point 430 170)
     (Point 587 170)
    )
    (connect D3:1 D0:2
     (Point 566 270)
     (Point 587 270)
    )
    (connect D4:1 D0:3
     (Point 566 370)
     (Point 587 370)
    )
    (connect D5:1 D1:1
     (Point 265 490)
     (Point 280 490)
     (Point 280 510)
     (Point 587 510)
    )
    (connect D6:1 D1:2
     (Point 555 550)
     (Point 570 550)
     (Point 570 610)
     (Point 587 610)
    )
    (connect D2:1 D1:3
     (Point 565 710)
     (Point 587 710)
    )
    (connect D14:1 D2:1
     (Point 410 710)
     (Point 442 710)
     (Point 442 710)
     (Point 474 710)
    )
    (connect D10:1 D3:1
     (Point 405 550)
     (Point 440 550)
     (Point 440 270)
     (Point 493 270)
    )
    (connect D14:1 D4:1
     (Point 410 710)
     (Point 450 710)
     (Point 450 370)
     (Point 493 370)
    )
    (connect D11:0 D5:0
     (Point 240 452)
     (Point 240 473)
    )
    (connect D10:1 D6:1
     (Point 405 550)
     (Point 464 550)
    )
    (connect D5:1 D10:1
     (Point 265 490)
     (Point 280 490)
     (Point 280 540)
     (Point 314 540)
    )
    (connect D9:1 D10:2
     (Point 141 560)
     (Point 314 560)
    )
    (connect D5:1 D14:1
     (Point 265 490)
     (Point 280 490)
     (Point 280 700)
     (Point 310 700)
    )
    (connect D8:1 D14:2
     (Point 135 640)
     (Point 160 640)
     (Point 160 710)
     (Point 310 710)
    )
    (connect D7:1 D14:3
     (Point 137 720)
     (Point 223 720)
     (Point 223 720)
     (Point 310 720)
    )
   )
  )
  (active detail)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
