#! /usr/lib/veetest/veetest -r
(revision "B.00.00")
(date "Fri 23/Oct/1992")
(component 0 "ROOTCONTEXT"
 (name "HP VEE-Test: 3852A DAC Example")
 (interface
  (sequence in)
  (sequence out)
 )
 (implementation
  (locked no)
  (trigMode deg)
  (nextID 18)
  (component 0 "LITERALCONSTANT"
   (name "Buffer Size")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Text
     (name "Buffer Size")
     (datum "3072")
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Text
     (name "CString")
     (datum "")
    )
   )
   (views
    (icon
     (origin 185 267)
     (extent 71 47)
    )
    (detail
     (origin 11 113)
     (extent 199 34)
    )
    (active detail)
   )
  )
  (component 1 "CONSTANT"
   (name "NRDGS")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Int32
     (name "NRDGS")
     (datum 1024)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Int32
     (name "LongInt")
     (datum 0)
    )
   )
   (views
    (icon
     (origin 139 405)
     (extent 35 47)
    )
    (detail
     (origin 46 293)
     (extent 129 34)
    )
    (active detail)
   )
  )
  (component 2 "LITERALCONSTANT"
   (name "SPER")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Text
     (name "SPER")
     (datum "5e-5")
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Text
     (name "CString")
     (datum "")
    )
   )
   (views
    (icon
     (origin 120 367)
     (extent 46 47)
    )
    (detail
     (origin 11 203)
     (extent 198 35)
    )
    (active detail)
   )
  )
  (component 3 "CONSTANT"
   (name "Transfer block size.")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Int32
     (name "Transfer block size.")
     (datum 512)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Int32
     (name "LongInt")
     (datum 0)
    )
   )
   (views
    (icon
     (origin 80 595)
     (extent 152 47)
    )
    (detail
     (origin 48 386)
     (extent 264 48)
    )
    (active detail)
   )
  )
  (component 4 "IFTHENELSE"
   (name "A MOD 20 == 0")
   (description 7 4
    This If/Then/Else object's argument is true when 
    ever the current count output by the For Count 
    object is evenly divisible by 20. When this 
    happens the "then" data output pin is fired 
    allowing the Gate object to pass the current block 
    of readings to the Execute Program object for 
    unpacking and finally to the Display object.
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Then")
     (lock name constraints)
    )
    (output 2
     (type data)
     (name "Else")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr "A MOD 20==0")
   )
   (views
    (icon
     (origin 487 268)
     (extent 127 25)
    )
    (detail
     (origin 521 235)
     (extent 149 70)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 5 "GATE"
   (description 4 4
    The gate object will allow the current block of
    readings to pass to the Execute Program object 
    whenever the top sequence in pin is pinged by the
    If/Then/Else object titled "A MOD 20 == 0".
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (tag "InData")
    )
    (output 1
     (type data)
     (name "X")
     (tag "OutData")
     (lock name constraints)
    )
   )
   (implementation
   )
   (views
    (icon
     (origin 627 308)
     (extent 46 25)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 6 "COUNTER"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
    (input 2
     (type control)
     (name "Clear")
     (lock name constraints)
     (optional yes)
    )
    (output 1
     (type data)
     (name "Count")
     (tag "Count")
     (lock name constraints)
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (origin 720 296)
     (extent 80 29)
    )
    (detail
     (origin 970 121)
     (extent 160 39)
    )
    (active icon)
   )
  )
  (component 7 "NOTE"
   (name " Disclaimer")
   (interface
   )
   (implementation
    (component text 9 5
     This example is
     provided as an 
     illustration "as 
     is", and Hewlett-
     Packard Company 
     makes no warranty 
     of any kind with 
     regard to this 
     example.
    )
   )
   (views
    (icon
     (origin 475 588)
     (extent 110 25)
    )
    (detail
     (origin 801 105)
     (extent 179 170)
     (editing enabled)
    )
    (active detail)
   )
  )
  (component 8 "IFTHENELSE"
   (name "A == 5")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Then")
     (lock name constraints)
    )
    (output 2
     (type data)
     (name "Else")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr "A==5")
   )
   (views
    (icon
     (origin 871 297)
     (extent 78 26)
    )
    (detail
     (origin 803 230)
     (extent 64 80)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 9 "IODEVICE"
   (name "Trigger 3852A")
   (description 3 4
    This Direct I/O object contains the command line
    to trigger the 3852A's voltmeter to start taking 
    readings
   )
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (comp iopath "HP 3852A")
    (procedure
      WRITE TEXT "SCTRIG SGL" EOL
    )
   )
   (views
    (icon
     (origin 307 168)
     (extent 127 64)
     (iconImage "inst.icon")
    )
    (detail
     (origin 146 287)
     (extent 289 47)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 10 "FORCOUNT"
   (name "For Count")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component count 750)
   )
   (views
    (icon
     (origin 315 248)
     (extent 110 64)
     (iconImage "loop.icon")
    )
    (detail
     (origin 328 372)
     (extent 164 37)
    )
    (active icon)
   )
  )
  (component 11 "CONTEXT"
   (name "Press For")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (locked no)
    (trigMode deg)
    (nextID 3)
    (component 0 "IFTHENELSE"
     (name "!= 0")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a!=0")
     )
     (views
      (icon
       (origin 345 330)
       (extent 46 25)
      )
      (detail
       (origin 209 308)
       (extent 73 64)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "TOGGLE"
     (name "Info About")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Reset")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Info About")
       (values range 0 1)
       (datum 0)
      )
      (component autoTrigger on)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (name "LongInt")
       (datum 0)
      )
     )
     (views
      (icon
       (origin 181 323)
       (extent 114 39)
       (format button)
      )
      (detail
       (origin 320 203)
       (extent 42 54)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "CONTEXT"
     (name "Info About This Example")
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (locked no)
      (trigMode deg)
      (nextID 2)
      (component 0 "CONFIRM"
       (name "DONE")
       (description 7 8
        This tiny "thread" begins running when the 
        enclosing UserObject is executed.  When the user
        acknowledges the OK/DONE button, there is nothing
        left to execute, so the thread ends.  Since there
        are not other threads running, the User Object
        is completed and will exit, removing the Show on
        Execute pop-up display.
       )
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 61 182)
         (extent 58 37)
        )
        (detail
         (origin 156 253)
         (extent 79 34)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "NOTE"
       (name "Explanation")
       (interface
       )
       (implementation
        (component text 32 9
         This model shows continuous high speed data acquistion using the HP 3852A Data Acquistion/
         Control Unit and it's high speed voltmeter, the 44702A/B. This example is like the example
         "gpio2.ex" in that a complete data acquisition solution is shown. The only difference is that
         the data is transferred via the HP-IB interface instead of using GPIO.
         
         The Direct I/O objects titled "3852A Setup", "Trigger 3852A", and "HP-IB Data Transfer"
         all have explanations in the Show Description choice under their object menus. The If/Then/Else
         object titled "A MOD 20 == 0", the Gate,  and the Execute Program object also have explanations 
         under the Show Description choice.
         
         As in the examples "gpio1.ex" and "gpio2.ex", the efficiency of the model determines it's 
         ability to maintain throughput with an instrument with a high sample rate. Hence the Int32
         datatype is used to read the data from the HP-IB interface. Even though the 3852A supports
         64 bit readings over HP-IB, it is still more efficient to use the packed format to decrease
         the amount of bandwidth used on the bus (two bytes/reading vs. eight bytes/reading). By using
         the Int32 datatype in the transaction within the the Direct I/O object titled "HP-IB Data
         Transfer" instead of the Int16 datatype, the overhead of the promotion of Int16 to Int32 is 
         avoided. Remember that the Int16 datatype is supported for I/O only and is promoted to Int32
         every place else.
         
         Another method of increasing this model's efficiency is by allowing only every 20th block of
         1024 readings to be displayed. This is very much like the example "gpio2.ex" except that 
         each block of readings is displayed without overwriting the previous displayed blocks. 
         In this way each block is displayed as a separate curve on the plot. This is done by using 
         the "Next Curve" control pin on the Display object. After five curves have been displayed the
         plot is cleared for the next five blocks of readings to be displayed. The clearing of the
         display is controlled by the Counter and the If/Then/Else object titled "A == 5". For more 
         information on data acquisition and HP VEE-Test please see the application note 1206-01 titled
         "Complete data Acquisition Solutions with HP VEE-Test".
         
           
         
        )
       )
       (views
        (icon
         (origin 395 468)
         (extent 110 25)
        )
        (detail
         (origin 21 230)
         (extent 898 361)
         (editing disabled)
        )
        (active detail)
       )
      )
      (configuration
      )
      (ShowOnExecPanel
       (origin 36 95)
       (extent 926 523)
       (panel
        (origin 19 188)
        (extent 922 485)
        (widget 0 icon
         (title off)
         (origin 453 603)
         (extent 58 37)
        )
        (widget 1 detail
         (title on)
         (origin 50 238)
         (extent 867 353)
         (editing enabled)
        )
       )
      )
     )
     (views
      (icon
       (origin 372 418)
       (extent 217 25)
      )
      (detail
       (origin 12 159)
       (extent 916 522)
       (configuration
       )
       (stackingOrder 0 1)
      )
      (active icon)
     )
    )
    (configuration
     (connect D1:1 D0:1)
     (connect D0:0 D1:1)
     (connect D0:1 D2:0)
    )
   )
   (views
    (icon
     (origin 305 648)
     (extent 110 25)
    )
    (panel
     (origin 475 137)
     (extent 290 67)
     (widget 1 icon
      (title off)
      (origin 577 150)
      (extent 114 39)
      (format button)
     )
    )
    (detail
     (origin 2 110)
     (extent 956 601)
     (configuration
      (connect D1:1 D0:1
       (Point 297 342)
       (Point 342 342)
      )
      (connect D0:0 D1:1
       (Point 368 357)
       (Point 368 380)
       (Point 160 380)
       (Point 160 342)
       (Point 178 342)
      )
      (connect D0:1 D2:0
       (Point 393 332)
       (Point 400 332)
       (Point 400 140)
       (Point 480 140)
       (Point 480 415)
      )
     )
     (stackingOrder 0 1 2)
    )
    (active panel)
    (active panel)
   )
  )
  (component 12 "YPLOT"
   (name "XY Trace")
   (subType "XY_Trace")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Trace1")
     (lock constraints)
    )
    (input 2
     (type control)
     (name "Next Curve")
     (lock name constraints)
     (optional yes)
    )
    (input 3
     (type control)
     (name "Clear")
     (lock name constraints)
     (optional yes)
    )
    (input 4
     (type control)
     (name "Auto Scale")
     (lock name constraints)
     (optional yes)
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
    (component tracePin 1)
    (component graphMode rectangular)
   )
   (views
    (icon
     (iconImage "display.icon")
    )
    (detail
     (origin 225 540)
     (extent 710 180)
     (displayMode graphOnly)
     (graphType cartesian)
     (gridType grid)
     (scale 0
      (name "Y name")
      (domainName "X name")
      (pen 9)
      (show 1)
      (range 2.68 2.72 4 linear)
     )
     (domain 0 1200 4 linear)
     (trace 0 onScale 0
      (name "Trace1")
      (pen 4)
      (lineType 1)
      (pointType 0)
     )
    )
    (terminals on)
    (active detail)
   )
  )
  (component 13 "IODEVICE"
   (name "HP-IB Data Transfer")
   (description 17 4
    This direct I/O object contains the transaction
    which reads data off the HP-IB interface. The
    readings are placed on the bus by the 3852A in an
    internal packed format where each reading is 16
    bits. The transaction in this object is configured
    for Int32. This means that if the transfer block
    size is specified as 512, then with two readings 
    per Int32, 1024 readings are transferred. The use
    of the Int32 datatype is to avoid the unnecessary
    promotion of the Int16 datatype to Int32. The 
    Int16 datatype is only supported by I/O transac-
    tions, once the Int16 is output from an I/O 
    object's data output pin it is promoted to Int32.
    By using the Int32 datatype to start with (two
    readings per data unit) the promotion is avoided
    and the model is made more efficient.
    
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "cnt")
     (optional yes)
    )
    (output 1
     (type data)
     (name "rawOut")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (comp iopath "HP 3852A")
    (procedure
      READ BINARY rawOut INT32 COUNT:cnt
    )
   )
   (views
    (icon
     (origin 370 338)
     (extent 181 64)
     (iconImage "io.icon")
    )
    (detail
     (origin 311 598)
     (extent 268 105)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 14 "TOFILE"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
   )
   (implementation
    (attr iopath file write "/tmp/rawdata"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (procedure
      WRITE BINARY a INT32
    )
   )
   (views
    (icon
     (origin 601 358)
     (extent 78 25)
    )
    (detail
     (origin 483 294)
     (extent 324 173)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 15 "TOSTRING"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (output 1
     (type data)
     (name "result")
     (lock name constraints)
    )
   )
   (implementation
    (attr iopath string write "string"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (procedure
      WRITE TEXT "/usr/lib/veetest/examples/3852A/unpack.exe ",2*a EOL
    )
   )
   (views
    (icon
     (origin 575 398)
     (extent 110 25)
    )
    (detail
     (origin 461 368)
     (extent 308 105)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 16 "SHELLESCAPE"
   (description 27 4
    The Execute Program object manages the executable 
    "unpack.exe", the source for which is in the file 
    "unpack.c". This program unpacks a number of 
    packed 16 bit 44702A/B readings and returns them 
    as 64 bit reals. The number of readings to be 
    unpacked is input to the program as a command line 
    argument. The Execute Program object writes the 
    packed data to the process via the process's 
    stdin pipe and reads the unpacked data from it's 
    stdout pipe.  Since the program is written to run 
    continuously, reading and writing data from and 
    to the Execute Program object, the Wait for child 
    exit choice on the object is set to "No".
    
    An important point is that UNIX pipes have a 
    default size of 8192 bytes. If more than this 
    amount is written to a pipe using the write 
    statment, the pipe will block causing HP VEE 
    to hang. This is why the constant box titled 
    block size has 2048 entred into it (remember 
    that for efficiency the transactions are all 
    Int32 so that 2048 Int32 x 2 readings/Int32 x 
    2 bytes/reading = 8192 ). It is possible to 
    change the size of the pipes by reconfiguring 
    the HP-UX kernel.
    
    
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "rawIn")
     (optional yes)
    )
    (input 2
     (type data)
     (name "Command")
     (tag "Command")
     (requires
      (datatype Text)
      (shape "Scalar")
     )
     (lock constraints)
     (optional yes)
     (buffer YES)
    )
    (input 3
     (type data)
     (name "cnt")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Exit code")
     (lock name constraints)
    )
    (output 2
     (type data)
     (name "dataOut")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (attr iopath pipe read "pipe"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (attr iopath pipe write "pipe"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (procedure
      WRITE BINARY rawIn INT32
      READ BINARY dataOut REAL64 COUNT:cnt*2
    )
    (component shell "none")
    (component command "/usr/lib/veetest/examples/3852A/unpack.exe 1024")
    (component deathWait "No")
   )
   (views
    (icon
     (origin 744 346)
     (extent 152 68)
     (iconImage "c.icon")
    )
    (detail
     (origin 266 305)
     (extent 609 170)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 17 "IODEVICE"
   (name "3852A Setup")
   (description 18 4
    This Direct I/O object contains two downloadable
    subroutines for the 3852A. Unlike examples 
    "gpio1.ex" and "gpio2.ex" which dealt only with
    the 44702A/B voltmeter card, this example deals
    with the 3052A system. The subroutine "SETUP"
    configures the 3852A for continuous readings via
    the HP-IB interface. The subroutine "INTROUT"
    is called to transfer the readings from internal
    memory to the interface bus upon an interrupt
    generated after the number of readings set by
    NRDGS has been taken. Notice that once again 
    readings will be transferred in a packed format
    
    Notice that a number of the commands for the 3852A
    have been made into variables by using the data 
    input terminals and the Constant objects. This is
    the basis for building user interactive drivers
    for any instrument.
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "BUFSIZ")
     (tag "BUFSIZ")
     (optional yes)
    )
    (input 2
     (type data)
     (name "RATE")
     (tag "RATE")
     (optional yes)
    )
    (input 3
     (type data)
     (name "NRDGS")
     (tag "NRDGS")
     (optional yes)
    )
    (input 4
     (type data)
     (name "SIZ")
     (tag "SIZ")
     (optional yes)
    )
    (input 5
     (type data)
     (name "NUMRDGS")
     (tag "NUMRDGS")
     (optional yes)
    )
   )
   (implementation
    (comp iopath "HP 3852A")
    (procedure
      WRITE TEXT "OUTBUF ",BUFSIZ EOL
      WRITE TEXT "RST" EOL
      WRITE TEXT "OUTBUF ON;INBUF ON;DISABLE LABELS;DISP OFF" EOL
      WRITE TEXT "PACKED RD(",SIZ*2-1,")" EOL
      WRITE TEXT "SUB SETUP" EOL
      WRITE TEXT "  USE 100" EOL
      WRITE TEXT "  CONF DCV" EOL
      WRITE TEXT "  SCANMODE ON" EOL
      WRITE TEXT "  SCTRIG HOLD" EOL
      WRITE TEXT "  TERM RIBBON" EOL
      WRITE TEXT "  RANGE 9" EOL
      WRITE TEXT "  RDGSMODE BURST" EOL
      WRITE TEXT "  NRDGS ",NRDGS EOL
      WRITE TEXT "  SPER ",RATE EOL
      WRITE TEXT "  SCDELAY 0" EOL
      WRITE TEXT "  ASCAN ON" EOL
      WRITE TEXT "  CLWRITE 000" EOL
      WRITE TEXT "  STTRIG HOLD" EOL
      WRITE TEXT "SUBEND" EOL
      WRITE TEXT "CALL SETUP" EOL
      WRITE TEXT "SUB INTROUT" EOL
      WRITE TEXT "  XRDGS 100,",NUMRDGS," INTO RD" EOL
      WRITE TEXT "  VREAD RD,PACK" EOL
      WRITE TEXT "  ENABLE INTR USE 100" EOL
      WRITE TEXT "SUBEND" EOL
      WRITE TEXT "ON INTR USE 100 CALL INTROUT" EOL
      WRITE TEXT "RQS FPS;RQS ON" EOL
      WRITE TEXT "ENABLE INTR USE 100" EOL
      WRITE TEXT "ENABLE INTR SYS" EOL
    )
   )
   (views
    (icon
     (origin 315 78)
     (extent 110 64)
     (iconImage "inst.icon")
    )
    (detail
     (origin 127 111)
     (extent 536 559)
    )
    (terminals on)
    (active icon)
   )
  )
  (configuration
   (connect D10:1 D4:1)
   (connect D4:1 D5:0)
   (connect D13:1 D5:1)
   (connect D4:1 D6:1)
   (connect D8:1 D6:2)
   (connect D6:1 D8:1)
   (connect D17:0 D9:0)
   (connect D9:0 D10:0)
   (connect D16:2 D12:1)
   (connect D5:1 D12:2)
   (connect D8:1 D12:3)
   (connect D16:0 D12:4)
   (connect D10:1 D13:0)
   (connect D3:1 D13:1)
   (connect D13:1 D14:1)
   (connect D3:1 D15:1)
   (connect D5:1 D16:1)
   (connect D15:1 D16:2)
   (connect D3:1 D16:3)
   (connect D0:1 D17:1)
   (connect D2:1 D17:2)
   (connect D1:1 D17:3)
   (connect D1:1 D17:4)
   (connect D1:1 D17:5)
  )
 )
 (views
  (detail
   (origin 0 62)
   (extent 979 668)
   (configuration
    (connect D10:1 D4:1
     (Point 427 280)
     (Point 484 280)
    )
    (connect D4:1 D5:0
     (Point 616 270)
     (Point 650 270)
     (Point 650 305)
    )
    (connect D13:1 D5:1
     (Point 553 370)
     (Point 580 370)
     (Point 580 320)
     (Point 624 320)
    )
    (connect D4:1 D6:1
     (Point 616 270)
     (Point 650 270)
     (Point 650 290)
     (Point 690 290)
     (Point 690 300)
     (Point 717 300)
    )
    (connect D8:1 D6:2
     (Point 951 300)
     (Point 970 300)
     (Point 970 340)
     (Point 900 340)
     (Point 900 330)
     (Point 810 330)
     (Point 810 340)
     (Point 710 340)
     (Point 710 320)
     (Point 717 320)
    )
    (connect D6:1 D8:1
     (Point 802 310)
     (Point 868 310)
    )
    (connect D17:0 D9:0
     (Point 370 144)
     (Point 370 165)
    )
    (connect D9:0 D10:0
     (Point 370 234)
     (Point 370 245)
    )
    (connect D16:2 D12:1
     (Point 898 400)
     (Point 920 400)
     (Point 920 480)
     (Point 100 480)
     (Point 100 570)
     (Point 112 570)
    )
    (connect D5:1 D12:2
     (Point 675 320)
     (Point 700 320)
     (Point 700 360)
     (Point 720 360)
     (Point 720 460)
     (Point 90 460)
     (Point 90 610)
     (Point 112 610)
    )
    (connect D8:1 D12:3
     (Point 951 300)
     (Point 970 300)
     (Point 970 340)
     (Point 930 340)
     (Point 930 490)
     (Point 70 490)
     (Point 70 650)
     (Point 112 650)
    )
    (connect D16:0 D12:4
     (Point 820 416)
     (Point 820 470)
     (Point 80 470)
     (Point 80 690)
     (Point 112 690)
    )
    (connect D10:1 D13:0
     (Point 427 280)
     (Point 460 280)
     (Point 460 335)
    )
    (connect D3:1 D13:1
     (Point 314 410)
     (Point 330 410)
     (Point 330 370)
     (Point 367 370)
    )
    (connect D13:1 D14:1
     (Point 553 370)
     (Point 598 370)
    )
    (connect D3:1 D15:1
     (Point 314 410)
     (Point 330 410)
     (Point 330 420)
     (Point 560 420)
     (Point 560 410)
     (Point 572 410)
    )
    (connect D5:1 D16:1
     (Point 675 320)
     (Point 700 320)
     (Point 700 360)
     (Point 741 360)
    )
    (connect D15:1 D16:2
     (Point 687 410)
     (Point 700 410)
     (Point 700 380)
     (Point 741 380)
    )
    (connect D3:1 D16:3
     (Point 314 410)
     (Point 330 410)
     (Point 330 420)
     (Point 560 420)
     (Point 560 440)
     (Point 710 440)
     (Point 710 400)
     (Point 741 400)
    )
    (connect D0:1 D17:1
     (Point 212 130)
     (Point 230 130)
     (Point 230 90)
     (Point 312 90)
    )
    (connect D2:1 D17:2
     (Point 211 220)
     (Point 240 220)
     (Point 240 100)
     (Point 312 100)
    )
    (connect D1:1 D17:3
     (Point 177 310)
     (Point 250 310)
     (Point 250 110)
     (Point 312 110)
    )
    (connect D1:1 D17:4
     (Point 177 310)
     (Point 250 310)
     (Point 250 120)
     (Point 312 120)
    )
    (connect D1:1 D17:5
     (Point 177 310)
     (Point 250 310)
     (Point 250 130)
     (Point 312 130)
    )
   )
   (stackingOrder 0 1 2 3 4 5 6 7 9 10
     13 14 15 17 11 16 8 12)
  )
  (active detail)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
