#! /usr/lib/veetest/veetest -r
(revision "A.00.01")
(date "Sun 08/Sep/1991")
(component 0 "Context"
 (name "Slots Example")
 (interface
 )
 (implementation
  (trigMode deg)
  (locked no)
  (component 0 "Note"
   (interface
   )
   (implementation
    (component text 4 5
     Most devices have
     a "Show Description"
     box with details
     on their operation.
    )
   )
   (views
    (icon
    )
    (detail
     (origin 377 120)
     (extent 206 80)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 1 "Note"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 4 5
     This example is provided as an
     illustration "as is", and Hewlett-Packard
     Company makes no warranty of any kind
     with regard to this example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 604 118)
     (extent 392 84)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 2 "ForCount"
   (name "Gimme 5")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component count 5)
   )
   (views
    (icon
     (origin 862 406)
     (extent 77 29)
    )
    (detail
     (origin 578 303)
     (extent 165 34)
    )
    (active icon)
   )
  )
  (component 3 "Context"
   (name "Press For")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "Toggle"
     (name "Info About")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Reset")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Info About")
       (values range 0 1)
       (datum 0)
      )
      (component autoTrigger on)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (datum 0)
      )
     )
     (views
      (icon
       (origin 93 231)
       (extent 114 39)
       (format button)
      )
      (detail
       (origin 115 223)
       (extent 51 54)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "Context"
     (name "Info About")
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Note"
       (name "NotePad")
       (interface
       )
       (implementation
        (component text 20 9
         Purpose:  To illustrate an interactive model build from many types of devices.
         
         User Input Required:  Press RUN to start the program.  Press PULL to spin the wheel.
         
         Explanation:  This example provides two "faces" -- the Panel view and the Detail view.
                    You can use the Panel and Detail buttons in the title bar to switch between
                    the views.  Generally, the panel view provides the user interface to a model,
                    while the Detail view provides the implementation details.  The program can
                    be operated from either view, but with some loss of user friendliness.
         
                    Most of the building blocks are provided by User Objects that encapsulate
                    the detailed steps necessary to perform a function such as "SpinDaWheel",
                    which spins the three wheels a random number of times each time the User
                    Object operates.  
         
                    Many of the devices have a "Show Description" entry that details why and how
                    the device operates; you can access this by right-clicking on each device and
                    then selecting ShowDescription from the resulting Object menu.
         
         
        )
       )
       (views
        (icon
         (origin 400 351)
         (extent 78 25)
        )
        (detail
         (origin 36 162)
         (extent 848 437)
         (editing disabled)
        )
        (active icon)
       )
      )
      (component 1 "Confirm"
       (name "DONE")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 410 415)
         (extent 58 37)
        )
        (detail
         (origin 466 633)
         (extent 79 34)
        )
        (terminals on)
        (active icon)
       )
      )
      (configuration
      )
      (ShowOnExecPanel
       (origin 55 78)
       (extent 849 571)
       (panel
        (origin 18 150)
        (extent 845 533)
        (widget 0 detail
         (title off)
         (origin 31 162)
         (extent 816 465)
         (editing disabled)
        )
        (widget 1 icon
         (title off)
         (origin 417 635)
         (extent 58 37)
        )
       )
      )
     )
     (views
      (icon
       (origin 385 408)
       (extent 110 25)
      )
      (detail
       (origin 255 310)
       (extent 351 200)
       (configuration
       )
      )
      (active icon)
     )
    )
    (component 2 "IfThenElse"
     (name "!= 0")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a!=0")
     )
     (views
      (icon
       (origin 257 238)
       (extent 46 25)
      )
      (detail
       (origin 209 308)
       (extent 73 64)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 3 "RepeatUntilBreak"
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Continuous")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 25 148)
       (extent 110 64)
       (iconImage "loop.icon")
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (configuration
     (connect D3:1 D0:0)
     (connect D1:0 D0:1)
     (connect D2:1 D1:0)
     (connect D0:1 D2:1)
    )
   )
   (views
    (icon
     (origin 175 368)
     (extent 110 25)
    )
    (panel
     (origin 31 118)
     (extent 319 77)
     (widget 0 icon
      (title off)
      (origin 133 131)
      (extent 114 39)
      (format button)
     )
    )
    (detail
     (origin 4 111)
     (extent 912 591)
     (configuration
      (connect D3:1 D0:0
       (Point 137 180)
       (Point 150 180)
       (Point 150 228)
      )
      (connect D1:0 D0:1
       (Point 440 435)
       (Point 440 450)
       (Point 70 450)
       (Point 70 250)
       (Point 90 250)
      )
      (connect D2:1 D1:0
       (Point 305 240)
       (Point 440 240)
       (Point 440 405)
      )
      (connect D0:1 D2:1
       (Point 209 250)
       (Point 254 250)
      )
     )
    )
    (active panel)
    (active panel)
   )
  )
  (component 4 "Context"
   (name "YOU HAVE WON:")
   (description 3 4
    This user object uses the Show Panel on Execute
    to pop up it's Panel over the main panel whenever
    a payoff is done.  
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
   )
   (implementation
    (trigMode rad)
    (locked no)
    (component 0 "Delay"
     (name "Delay")
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (component delay 1.25)
     )
     (views
      (icon
       (origin 821 576)
       (extent 59 29)
      )
      (detail
       (origin 563 462)
       (extent 129 34)
      )
      (active icon)
     )
    )
    (component 1 "TextDisplay"
     (name "AlphaNumeric")
     (interface
      (sequence out)
      (input 1
       (type data)
       (name "Data")
      )
     )
     (implementation
      (component clearAtPrerun 1)
      (component clearAtActivate 1)
     )
     (views
      (icon
      )
      (detail
       (origin 754 523)
       (extent 192 35)
      )
      (active detail)
     )
    )
    (component 2 "ToString"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (tag "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "result")
       (lock name constraints)
      )
     )
     (implementation
      (attr iopath string write "string"
       (readTerm "\n")
       (fs " ")
       (eol "\n")
       (multiField fullSyntax)
       (arrayFormat block)
      )
      (procedure
        WRITE TEXT "$",a EOL
      )
     )
     (views
      (icon
       (origin 615 528)
       (extent 110 25)
      )
      (detail
       (origin 278 380)
       (extent 238 120)
      )
      (terminals on)
      (active icon)
     )
    )
    (configuration
     (connect D1:0 D0:0)
     (connect D2:1 D1:1)
     (connect I1:1 D2:1)
    )
    (ShowOnExecPanel
     (origin 384 266)
     (extent 222 112)
     (panel
      (origin 761 503)
      (extent 218 74)
      (widget 1 detail
       (title off)
       (origin 777 520)
       (extent 192 35)
      )
     )
    )
   )
   (views
    (icon
     (origin 853 527)
     (extent 134 26)
    )
    (detail
     (origin 600 440)
     (extent 360 181)
     (configuration
      (connect D1:0 D0:0
       (Point 850 560)
       (Point 850 573)
      )
      (connect D2:1 D1:1
       (Point 727 540)
       (Point 751 540)
      )
      (connect I1:1 D2:1
       (Point 602 540)
       (Point 602 540)
       (Point 602 540)
       (Point 612 540)
      )
     )
    )
    (active icon)
   )
  )
  (component 5 "TextDisplay"
   (name "Your Bankroll")
   (interface
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (origin 705 696)
     (extent 131 29)
    )
    (detail
     (origin 600 613)
     (extent 201 35)
    )
    (active detail)
   )
  )
  (component 6 "Constant"
   (name "Subtract $5")
   (subType "Integer")
   (description 2 4
    Each time the handle is "pulled", we need to
    subtract from the user's bankroll.
   )
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Int32")
     (lock name constraints)
    )
   )
   (implementation
    (component value Int32
     (name "Subtract $5")
     (datum -5)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Int32
     (datum 0)
    )
   )
   (views
    (icon
     (origin 255 508)
     (extent 110 25)
    )
    (detail
     (origin 229 626)
     (extent 183 28)
     (showFormat int)
    )
    (active icon)
   )
  )
  (component 7 "IfThenElse"
   (name "A > 0")
   (description 6 4
    Test to see if there is any money left in the
    bankroll.  If not, we exit.  Otherwise, it's
    OK to let the user Pull and spin the wheel again.
    
    If no money is left, the Break will stop the
    Until Break iterator and the model will stop.
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Then")
     (lock name constraints)
    )
    (output 2
     (type data)
     (name "Else")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr "a>0")
   )
   (views
    (icon
     (origin 681 507)
     (extent 78 26)
    )
    (detail
     (origin 533 505)
     (extent 64 90)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 8 "Break"
   (interface
    (sequence in)
   )
   (implementation
   )
   (views
    (icon
     (origin 731 548)
     (extent 78 25)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 9 "ForCount"
   (name "For Count")
   (description 9 4
    The Random number feeding this iterator determines
    how many times the "Spin Da Wheel" user object is
    to be run.  Each time it runs, it produces a new
    set of random values on the output.  
    
    After the For Count has iterated "Spin Da Wheel"
    the desired number of times, it's Sequence Out
    pin is activated to allow the Sequence In on the
    Payoff calculation User Object to run.
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Count")
     (tag "Count")
     (requires
      (datatype Int32)
      (shape "Scalar")
     )
     (lock constraints)
     (optional yes)
    )
    (output 1
     (type data)
     (lock name constraints)
    )
    (buffers in
     (buffer "Count")
    )
   )
   (implementation
    (component count 14)
   )
   (views
    (icon
     (origin 453 316)
     (extent 95 29)
    )
    (detail
     (origin 346 605)
     (extent 165 34)
    )
    (active icon)
   )
  )
  (component 10 "ToString"
   (name "To String")
   (description 10 4
    Because the player would expect his bankroll to
    be in dollars, we can use the To String device to
    format a displayable string that is prefaced with
    a $.
    
    Another way to accomplish this would be to "add"
    the string "$" to the payroll amount.  Because
    adding unlike types converts the lower type (a
    real number) to the higher type (a string), the
    result would be a string formated as we desire.
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (tag "A")
     (optional yes)
    )
    (output 1
     (type data)
     (name "result")
     (lock name constraints)
    )
   )
   (implementation
    (attr iopath string write "string"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (procedure
      WRITE TEXT "$",a," Left" EOL
    )
   )
   (views
    (icon
     (origin 465 618)
     (extent 110 25)
    )
    (detail
     (origin 183 438)
     (extent 308 105)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 11 "Accumulator"
   (name "Accumulator")
   (description 4 4
    The accumulator keeps a running account of the
    bankroll by adding whatever data is presented on
    the input (positive numbers add, negative will
    subtract). 
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
     (tag "InData")
     (requires
      (shape "Scalar")
     )
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Data")
     (tag "accumData")
     (lock name constraints)
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (origin 535 508)
     (extent 110 25)
    )
    (detail
     (origin 459 493)
     (extent 183 34)
    )
    (active icon)
   )
  )
  (component 12 "Junction"
   (name "JCT")
   (description 6 4
    The Bankroll calculation "adds" whatever value
    is passed thru this device.  At start (PreRun),
    it is passed the 100 to start the bankroll. Each
    time the user "pulls", $5 is subtracted from the
    bankroll; after each payoff, the winnings are
    added to the bankroll.
   )
   (interface
    (input 1
     (type data)
     (name "A")
     (lock name constraints)
     (optional yes)
    )
    (input 2
     (type data)
     (name "B")
     (lock name constraints)
     (optional yes)
    )
    (input 3
     (type data)
     (name "C")
     (lock name constraints)
     (optional yes)
    )
    (output 1
     (type data)
     (name "Data")
     (lock name constraints)
    )
   )
   (implementation
   )
   (views
    (icon
     (origin 449 503)
     (extent 62 34)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 13 "Context"
   (name "DING - DING")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (trigMode rad)
    (locked no)
    (component 0 "LiteralConstant"
     (name "A WINNER!")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Text")
       (lock name constraints)
      )
     )
     (implementation
      (component value Text
       (name "A WINNER!")
       (datum "  $100 JACKPOT IS YOURS")
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Text
       (datum "")
      )
     )
     (views
      (icon
       (extent 110 0)
      )
      (detail
       (origin 771 423)
       (extent 259 54)
      )
      (active detail)
     )
    )
    (component 1 "Delay"
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (component delay 1)
     )
     (views
      (icon
       (origin 851 518)
       (extent 78 25)
      )
      (detail
       (origin 825 513)
       (extent 130 34)
      )
      (active detail)
     )
    )
    (configuration
     (connect D0:0 D1:0)
    )
    (ShowOnExecPanel
     (origin 332 253)
     (extent 330 158)
     (panel
      (origin 727 420)
      (extent 326 120)
      (widget 0 detail
       (title on)
       (origin 764 470)
       (extent 259 54)
      )
     )
    )
   )
   (views
    (icon
     (origin 855 477)
     (extent 110 26)
    )
    (detail
     (origin 700 380)
     (extent 360 181)
     (configuration
      (connect D0:0 D1:0
       (Point 900 479)
       (Point 900 500)
       (Point 890 500)
       (Point 890 480)
      )
     )
    )
    (active icon)
   )
  )
  (component 14 "TextDisplay"
   (name "Text")
   (interface
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (origin 658 220)
     (extent 124 40)
    )
    (detail
     (origin 620 282)
     (extent 120 37)
    )
    (active detail)
   )
  )
  (component 15 "TextDisplay"
   (name "Text")
   (interface
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (origin 658 270)
     (extent 124 40)
    )
    (detail
     (origin 750 282)
     (extent 120 37)
    )
    (active detail)
   )
  )
  (component 16 "TextDisplay"
   (name "Text")
   (interface
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (origin 658 320)
     (extent 124 40)
    )
    (detail
     (origin 882 283)
     (extent 116 34)
    )
    (active detail)
   )
  )
  (component 17 "RandomNumberSeed"
   (description 7 4
    Without the Random Seed object, each time this
    model is loaded and run, the same repeating 
    sequence of random numbers would be generated.
    
    By using the time and date to generate a new
    seed each time the program is run, an entirely
    new sequence of numbers is generated.
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Seed")
     (requires
      (datatype Int32)
      (shape "Scalar")
     )
     (lock name constraints)
    )
   )
   (implementation
   )
   (views
    (icon
     (origin 85 328)
     (extent 110 25)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 18 "Constant"
   (name "Start $$$")
   (description 6 4
    This CONSTANT sets the initial value of your
    Bankroll every time the Slot Machine is started.
    
    The Default is $100.  An exercise would be to
    read this value from a text file that is updated
    after each spin with the remaining bankroll.
   )
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Int32
     (name "Start $$$")
     (datum 100)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Int32
     (datum 0)
    )
   )
   (views
    (icon
     (origin 93 376)
     (extent 95 29)
    )
    (detail
     (origin 78 286)
     (extent 165 28)
    )
    (active icon)
   )
  )
  (component 19 "ExitProcess"
   (name "Exit Program")
   (interface
    (sequence in)
   )
   (implementation
    (comp code 0)
   )
   (views
    (icon
     (origin 79 506)
     (extent 122 29)
    )
    (detail
     (origin 666 539)
     (extent 192 34)
    )
    (active icon)
   )
  )
  (component 20 "RepeatUntilBreak"
   (name "Until Break")
   (description 6 4
    This device continues to rerun the "PULL" thread
    until a "break" device operates.  The thread that
    is activated by this device constitutes the entire
    slot machine for one cycle of spinning, evaluating
    the results, displaying the winnings, and recalcing
    the bankroll.
   )
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Continuous")
     (lock name constraints)
    )
   )
   (implementation
   )
   (views
    (icon
     (origin 82 427)
     (extent 116 26)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 21 "Start"
   (name "Start")
   (interface
    (sequence out)
   )
   (implementation
   )
   (views
    (icon
     (origin 106 211)
     (extent 69 39)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 22 "Confirm"
   (name "PULL")
   (description 8 4
    This Confirm/OK device pauses execution of the
    thread until the button is activated by the user,
    at which point the remainder of the thread is
    processed.
    
    Since there is nothing tied to the sequence out
    pin, execution of the thread will stop after all
    the "hosted" thread has completed.
   )
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Go")
     (lock name constraints)
    )
   )
   (implementation
   )
   (views
    (icon
     (origin 220 461)
     (extent 60 39)
    )
    (detail
     (origin 243 327)
     (extent 65 47)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 23 "Note"
   (name "The Odds")
   (interface
   )
   (implementation
    (component text 6 5
       THE PAYOFF FOR THIS MACHINE
       -------    ----------------
       $ 100      3 BARs
       $  20      Any other 3 
       $  10      Any 2 BELLs
       $   5      Any 2 Sevens
    )
   )
   (views
    (icon
     (origin 136 597)
     (extent 89 26)
    )
    (detail
     (origin 42 547)
     (extent 277 126)
     (editing enabled)
    )
    (active icon)
   )
  )
  (component 24 "Context"
   (name "Calc Payoff")
   (description 18 4
    This user object "examines" the state of each
    wheel after the spin to see if any of the payoff
    combinations are present.  Although not elegant,
    the method is to use a large If/Then with suitable
    expressions to test the three inputs.
    
    If none of the payoffs are found, the sequence
    out pin is fired to allow the test for A > 0
    to run.  If the acculator has some money, the 
    model will continue with the next iteration of
    the Until Break.  
    
    If a payoff is found, the "pay" output will have
    the dollar value to add to the bankroll.  If the
    jackpot payoff is found, the upper output pin will
    also be activated to allow the Gimme 5 to flash
    a win box on the panel 5 times.
     
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (input 2
     (type data)
     (name "B")
     (optional yes)
    )
    (input 3
     (type data)
     (name "C")
     (optional yes)
    )
    (output 1
     (type data)
     (name "DING")
     (lock constraints)
     (optional yes)
    )
    (output 2
     (type data)
     (name "Pay")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (trigMode rad)
    (locked no)
    (component 0 "Junction"
     (name "JCT")
     (interface
      (input 1
       (type data)
       (name "A")
       (lock name constraints)
       (optional yes)
      )
      (input 2
       (type data)
       (name "B")
       (lock name constraints)
       (optional yes)
      )
      (input 3
       (type data)
       (name "C")
       (lock name constraints)
       (optional yes)
      )
      (input 4
       (type data)
       (name "D")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (name "Data")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 828 458)
       (extent 64 45)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "Constant"
     (name "$100")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "$100")
       (datum 100)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (datum 0)
      )
     )
     (views
      (icon
       (origin 745 346)
       (extent 50 29)
      )
      (detail
       (origin 341 243)
       (extent 147 28)
      )
      (active icon)
     )
    )
    (component 2 "IfThenElse"
     (name "Find Matches")
     (description 11 6
      This If/Then device has three expressions that
      examine the input text strings, looking for
      matches with the displayed payoff.  If you
      open this device to the detailed view, it is
      very large.  Maximizing the "Calc Payoff" by
      clicking on the Max botton in the title bar is
      recommended.
      
      Note: the odds are hard-coded in the expressions.
      An astute student could consider other ways of
      making the payoff decision without using If/then.
     )
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (input 2
       (type data)
       (name "B")
       (optional yes)
      )
      (input 3
       (type data)
       (name "C")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else If")
       (lock name constraints)
      )
      (output 3
       (type data)
       (name "Else If")
       (lock name constraints)
      )
      (output 4
       (type data)
       (name "Else If")
       (lock name constraints)
      )
      (output 5
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "A==B AND B==C AND A==\"BAR\"")
      (component expr "A==B AND B==C")
      (component expr "(A==B AND A==\"BELL\") OR (B==C AND B==\"BELL\") OR (C==A AND C==\"BELL\")")
      (component expr "(A==B AND A==\"7\") OR (B==C AND B==\"7\") OR (C==A AND C==\"7\")")
     )
     (views
      (icon
       (origin 576 413)
       (extent 129 54)
      )
      (detail
       (origin 80 149)
       (extent 640 243)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 3 "Constant"
     (name "$20")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "$20")
       (datum 20)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (datum 0)
      )
     )
     (views
      (icon
       (origin 750 406)
       (extent 41 29)
      )
      (detail
       (origin 304 252)
       (extent 147 28)
      )
      (active icon)
     )
    )
    (component 4 "Constant"
     (name "$5")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "$5")
       (datum 5)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (datum 0)
      )
     )
     (views
      (icon
       (origin 753 526)
       (extent 34 29)
      )
      (detail
       (origin 309 367)
       (extent 147 28)
      )
      (active icon)
     )
    )
    (component 5 "Constant"
     (name "$10")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "$10")
       (datum 10)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (datum 0)
      )
     )
     (views
      (icon
       (origin 750 466)
       (extent 41 29)
      )
      (detail
       (origin 306 308)
       (extent 147 28)
      )
      (active icon)
     )
    )
    (configuration
     (connect D1:1 D0:1)
     (connect D3:1 D0:2)
     (connect D5:1 D0:3)
     (connect D4:1 D0:4)
     (connect D2:1 D1:0)
     (connect I1:1 D2:1)
     (connect I2:1 D2:2)
     (connect I3:1 D2:3)
     (connect D2:2 D3:0)
     (connect D2:4 D4:0)
     (connect D2:3 D5:0)
     (connect D2:1 O1:1)
     (connect D0:1 O2:1)
    )
   )
   (views
    (icon
     (origin 682 423)
     (extent 116 34)
    )
    (detail
     (origin 523 277)
     (extent 405 307)
     (configuration
      (connect D1:1 D0:1
       (Point 797 360)
       (Point 820 360)
       (Point 820 460)
       (Point 825 460)
      )
      (connect D3:1 D0:2
       (Point 793 420)
       (Point 810 420)
       (Point 810 470)
       (Point 825 470)
      )
      (connect D5:1 D0:3
       (Point 793 480)
       (Point 825 480)
      )
      (connect D4:1 D0:4
       (Point 789 540)
       (Point 810 540)
       (Point 810 490)
       (Point 825 490)
      )
      (connect D2:1 D1:0
       (Point 707 420)
       (Point 730 420)
       (Point 730 330)
       (Point 770 330)
       (Point 770 343)
      )
      (connect I1:1 D2:1
       (Point 525 330)
       (Point 540 330)
       (Point 540 420)
       (Point 573 420)
      )
      (connect I2:1 D2:2
       (Point 525 440)
       (Point 573 440)
      )
      (connect I3:1 D2:3
       (Point 525 550)
       (Point 540 550)
       (Point 540 460)
       (Point 573 460)
      )
      (connect D2:2 D3:0
       (Point 707 430)
       (Point 740 430)
       (Point 740 390)
       (Point 770 390)
       (Point 770 403)
      )
      (connect D2:4 D4:0
       (Point 707 450)
       (Point 720 450)
       (Point 720 510)
       (Point 770 510)
       (Point 770 523)
      )
      (connect D2:3 D5:0
       (Point 707 440)
       (Point 730 440)
       (Point 730 450)
       (Point 770 450)
       (Point 770 463)
      )
      (connect D2:1 O1:1
       (Point 707 420)
       (Point 730 420)
       (Point 730 330)
       (Point 830 330)
       (Point 830 360)
       (Point 925 360)
      )
      (connect D0:1 O2:1
       (Point 894 480)
       (Point 910 480)
       (Point 910 520)
       (Point 925 520)
      )
     )
    )
    (terminals on)
    (active icon)
   )
  )
  (component 25 "Formula"
   (name "Get Time")
   (description 8 4
    Because the Random Seed needs a number that
    can be represented by an integer, we use a
    Formula box to get the current time using the
    now() function.  Since now() returns a large
    real number, the MOD function is used to generate
    a suitable large number that is within the range
    of 2^32.
    
   )
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "now() MOD (2^31)")
   )
   (views
    (icon
     (origin 85 268)
     (extent 110 25)
    )
    (detail
     (origin 31 250)
     (extent 178 60)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 26 "RandomNumber"
   (name "Random Number")
   (description 9 4
    This object sets a range for the random number
    between 8 and 15, rather than the 0 to 1 commonly
    found.  The resulting number determines how many
    times the Wheel will spin by loading the For
    Count iterator.  
    
    This lets the wheel spin at least 8 times, but
    never more than 15 times per pull, and introduces
    additional randomness to the machine.
   )
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Rand Val")
     (lock name constraints)
    )
   )
   (implementation
    (component lowerLimit 8)
    (component upperLimit 15)
   )
   (views
    (icon
     (origin 433 247)
     (extent 134 26)
    )
    (detail
     (origin 361 232)
     (extent 219 57)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 27 "Context"
   (name "Spin Da Wheel")
   (description 7 4
    This user object encapsulates the devices needed
    to repeatedly spin each of the three "wheels" a
    random number of times.
    
    It provides three outputs, one for each wheel,
    every time they are spun.  The For count device
    determines how many times to spin them.
   )
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "SubAry")
     (lock constraints)
     (optional yes)
    )
    (output 2
     (type data)
     (name "SubAry")
     (lock constraints)
     (optional yes)
    )
    (output 3
     (type data)
     (name "SubAry")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "Formula"
     (name "UnBuild Array")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Ary")
       (optional yes)
      )
      (input 2
       (type data)
       (name "I")
       (optional yes)
      )
      (output 1
       (type data)
       (name "SubAry")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "Ary[I]")
     )
     (views
      (icon
       (origin 563 527)
       (extent 134 26)
      )
      (detail
       (origin 326 348)
       (extent 83 47)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "Formula"
     (name "UnBuild Array")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Ary")
       (optional yes)
      )
      (input 2
       (type data)
       (name "I")
       (optional yes)
      )
      (output 1
       (type data)
       (name "SubAry")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "Ary[I]")
     )
     (views
      (icon
       (origin 553 477)
       (extent 134 26)
      )
      (detail
       (origin 326 348)
       (extent 83 47)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "Formula"
     (name "UnBuild Array")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Ary")
       (optional yes)
      )
      (input 2
       (type data)
       (name "I")
       (optional yes)
      )
      (output 1
       (type data)
       (name "SubAry")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "Ary[I]")
     )
     (views
      (icon
       (origin 553 427)
       (extent 134 26)
      )
      (detail
       (origin 326 348)
       (extent 83 47)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 3 "LiteralConstant"
     (name "Text")
     (description 17 6
      This Text Constant generates a 1-dimension array
      of text strings.  For this example, each "picture"
      on the wheel is entered once in the list.  
      
      Spinning the wheel is done by randomly selecting
      one of the array elements.  For example, the
      third element is "Cherry" and is accessed as
      text[3].
      
      To make the "wheel" more realistic, you could add
      many array elements to the text device, varying
      the odds of selecting a particular element by how
      many times it is represented in the list.  If you
      do change the array size from 6 elements, you must
      change the Random Number generators to produce
      new indices from 0 to the max number of elements.
      
     )
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Text
       (name "Text")
       (numDims 1)
       (size 8)
       (data
        [ "BAR" "BELL" "BELL" "APPLE" "CHERRY" "PLUM" "7" "7" ]
       )
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Text
       (datum "")
      )
     )
     (views
      (icon
      )
      (detail
       (origin 366 274)
       (extent 149 152)
      )
      (active detail)
     )
    )
    (component 4 "RandomNumber"
     (name "Random Number")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Rand Val")
       (lock name constraints)
      )
     )
     (implementation
      (component lowerLimit -0.4999)
      (component upperLimit 7.4999)
     )
     (views
      (icon
       (origin 373 437)
       (extent 134 26)
      )
      (detail
       (origin 301 452)
       (extent 219 57)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 5 "RandomNumber"
     (name "Random Number")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Rand Val")
       (lock name constraints)
      )
     )
     (implementation
      (component lowerLimit -0.4999)
      (component upperLimit 7.4999)
     )
     (views
      (icon
       (origin 373 487)
       (extent 134 26)
      )
      (detail
       (origin 301 502)
       (extent 219 57)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 6 "RandomNumber"
     (name "Random Number")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Rand Val")
       (lock name constraints)
      )
     )
     (implementation
      (component lowerLimit -0.4999)
      (component upperLimit 7.4999)
     )
     (views
      (icon
       (origin 373 537)
       (extent 134 26)
      )
      (detail
       (origin 301 522)
       (extent 219 57)
      )
      (terminals on)
      (active icon)
     )
    )
    (configuration
     (connect D3:1 D0:1)
     (connect D6:1 D0:2)
     (connect D3:1 D1:1)
     (connect D5:1 D1:2)
     (connect D3:1 D2:1)
     (connect D4:1 D2:2)
     (connect D2:1 O1:1)
     (connect D1:1 O2:1)
     (connect D0:1 O3:1)
    )
   )
   (views
    (icon
     (origin 445 423)
     (extent 131 34)
    )
    (detail
     (origin 267 260)
     (extent 426 340)
     (configuration
      (connect D3:1 D0:1
       (Point 517 350)
       (Point 540 350)
       (Point 540 530)
       (Point 560 530)
      )
      (connect D6:1 D0:2
       (Point 509 550)
       (Point 534 550)
       (Point 534 550)
       (Point 560 550)
      )
      (connect D3:1 D1:1
       (Point 517 350)
       (Point 540 350)
       (Point 540 480)
       (Point 550 480)
      )
      (connect D5:1 D1:2
       (Point 509 500)
       (Point 529 500)
       (Point 529 500)
       (Point 550 500)
      )
      (connect D3:1 D2:1
       (Point 517 350)
       (Point 540 350)
       (Point 540 430)
       (Point 550 430)
      )
      (connect D4:1 D2:2
       (Point 509 450)
       (Point 529 450)
       (Point 529 450)
       (Point 550 450)
      )
      (connect D2:1 O1:1
       (Point 689 440)
       (Point 700 440)
       (Point 700 320)
       (Point 690 320)
      )
      (connect D1:1 O2:1
       (Point 689 490)
       (Point 710 490)
       (Point 710 440)
       (Point 690 440)
      )
      (connect D0:1 O3:1
       (Point 699 540)
       (Point 729 540)
       (Point 729 560)
       (Point 690 560)
      )
     )
    )
    (terminals on)
    (active icon)
   )
  )
  (configuration
   (connect D24:1 D2:0)
   (connect D24:2 D4:1)
   (connect D10:1 D5:1)
   (connect D22:1 D6:0)
   (connect D24:0 D7:0)
   (connect D11:1 D7:1)
   (connect D7:2 D8:0)
   (connect D26:1 D9:1)
   (connect D11:1 D10:1)
   (connect D12:1 D11:1)
   (connect D18:1 D12:1)
   (connect D6:1 D12:2)
   (connect D24:2 D12:3)
   (connect D2:1 D13:0)
   (connect D27:1 D14:1)
   (connect D27:2 D15:1)
   (connect D27:3 D16:1)
   (connect D25:1 D17:1)
   (connect D17:0 D18:0)
   (connect D20:0 D19:0)
   (connect D18:0 D20:0)
   (connect D20:1 D22:0)
   (connect D9:0 D24:0)
   (connect D27:1 D24:1)
   (connect D27:2 D24:2)
   (connect D27:3 D24:3)
   (connect D21:0 D25:0)
   (connect D6:0 D26:0)
   (connect D9:1 D27:0)
  )
 )
 (views
  (panel
   (origin 0 67)
   (extent 995 648)
   (widget 15 detail
    (title off)
    (origin 422 97)
    (extent 124 40)
   )
   (widget 16 detail
    (title off)
    (origin 553 97)
    (extent 124 40)
   )
   (widget 14 detail
    (title off)
    (origin 291 98)
    (extent 124 40)
   )
   (widget 5 detail
    (title on)
    (origin 392 198)
    (extent 201 35)
   )
   (widget 1 detail
    (title on)
    (origin 324 622)
    (extent 392 84)
    (editing disabled)
   )
   (widget 23 detail
    (title on)
    (origin 543 449)
    (extent 290 122)
    (editing disabled)
   )
   (widget 3 panel
    (title on)
    (origin 184 448)
    (extent 299 125)
    (widget 0 icon
     (title off)
     (origin 271 475)
     (extent 114 39)
     (format button)
    )
   )
   (widget 22 icon
    (title off)
    (origin 467 286)
    (extent 60 39)
   )
  )
  (detail
   (origin 0 67)
   (extent 1004 664)
   (configuration
    (connect D24:1 D2:0
     (Point 800 430)
     (Point 820 430)
     (Point 820 390)
     (Point 900 390)
     (Point 900 403)
    )
    (connect D24:2 D4:1
     (Point 800 450)
     (Point 820 450)
     (Point 820 540)
     (Point 850 540)
    )
    (connect D10:1 D5:1
     (Point 577 630)
     (Point 597 630)
    )
    (connect D22:1 D6:0
     (Point 282 480)
     (Point 310 480)
     (Point 310 505)
    )
    (connect D24:0 D7:0
     (Point 740 459)
     (Point 740 480)
     (Point 720 480)
     (Point 720 504)
    )
    (connect D11:1 D7:1
     (Point 647 520)
     (Point 678 520)
    )
    (connect D7:2 D8:0
     (Point 761 530)
     (Point 770 530)
     (Point 770 545)
    )
    (connect D26:1 D9:1
     (Point 569 260)
     (Point 590 260)
     (Point 590 290)
     (Point 430 290)
     (Point 430 330)
     (Point 450 330)
    )
    (connect D11:1 D10:1
     (Point 647 520)
     (Point 660 520)
     (Point 660 560)
     (Point 450 560)
     (Point 450 630)
     (Point 462 630)
    )
    (connect D12:1 D11:1
     (Point 513 520)
     (Point 532 520)
    )
    (connect D18:1 D12:1
     (Point 190 390)
     (Point 380 390)
     (Point 380 510)
     (Point 446 510)
    )
    (connect D6:1 D12:2
     (Point 367 520)
     (Point 446 520)
    )
    (connect D24:2 D12:3
     (Point 800 450)
     (Point 820 450)
     (Point 820 540)
     (Point 830 540)
     (Point 830 670)
     (Point 430 670)
     (Point 430 530)
     (Point 446 530)
    )
    (connect D2:1 D13:0
     (Point 941 420)
     (Point 960 420)
     (Point 960 450)
     (Point 910 450)
     (Point 910 474)
    )
    (connect D27:1 D14:1
     (Point 578 430)
     (Point 600 430)
     (Point 600 300)
     (Point 617 300)
    )
    (connect D27:2 D15:1
     (Point 578 440)
     (Point 650 440)
     (Point 650 340)
     (Point 740 340)
     (Point 740 300)
     (Point 747 300)
    )
    (connect D27:3 D16:1
     (Point 578 450)
     (Point 660 450)
     (Point 660 380)
     (Point 870 380)
     (Point 870 300)
     (Point 879 300)
    )
    (connect D25:1 D17:1
     (Point 197 280)
     (Point 210 280)
     (Point 210 310)
     (Point 70 310)
     (Point 70 340)
     (Point 82 340)
    )
    (connect D17:0 D18:0
     (Point 140 355)
     (Point 140 373)
    )
    (connect D20:0 D19:0
     (Point 140 455)
     (Point 140 503)
    )
    (connect D18:0 D20:0
     (Point 140 407)
     (Point 140 424)
    )
    (connect D20:1 D22:0
     (Point 200 440)
     (Point 250 440)
     (Point 250 458)
    )
    (connect D9:0 D24:0
     (Point 500 347)
     (Point 500 360)
     (Point 430 360)
     (Point 430 480)
     (Point 690 480)
     (Point 690 400)
     (Point 740 400)
     (Point 740 420)
    )
    (connect D27:1 D24:1
     (Point 578 430)
     (Point 628 430)
     (Point 628 430)
     (Point 679 430)
    )
    (connect D27:2 D24:2
     (Point 578 440)
     (Point 628 440)
     (Point 628 440)
     (Point 679 440)
    )
    (connect D27:3 D24:3
     (Point 578 450)
     (Point 628 450)
     (Point 628 450)
     (Point 679 450)
    )
    (connect D21:0 D25:0
     (Point 140 252)
     (Point 140 258)
     (Point 140 258)
     (Point 140 265)
    )
    (connect D6:0 D26:0
     (Point 310 535)
     (Point 310 550)
     (Point 390 550)
     (Point 390 230)
     (Point 500 230)
     (Point 500 244)
    )
    (connect D9:1 D27:0
     (Point 550 330)
     (Point 570 330)
     (Point 570 360)
     (Point 510 360)
     (Point 510 420)
    )
   )
  )
  (active panel)
  (active panel)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
