#! /usr/lib/veetest/veetest -r
(revision "B.00.00")
(date "Tue 17/Nov/1992")
(component 0 "ROOTCONTEXT"
 (name "Using Parallel Math")
 (interface
 )
 (implementation
  (locked no)
  (trigMode deg)
  (nextID 21)
  (component 0 "FORCOUNT"
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Count")
     (lock name constraints)
    )
   )
   (implementation
    (component count 15)
   )
   (views
    (icon
     (iconImage "loop.icon")
    )
    (detail
     (origin 205 123)
     (extent 170 34)
    )
    (active detail)
   )
  )
  (component 1 "FORMULA"
   (name "log(x)")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "X")
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked yes)
    (component expr 1 "log(x)")
   )
   (views
    (icon
     (origin 501 288)
     (extent 78 25)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 2 "FORMULA"
   (name "Formula")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (input 2
     (type data)
     (name "B")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "A+B")
   )
   (views
    (icon
     (iconImage "formula.icon")
    )
    (detail
     (origin 650 277)
     (extent 50 87)
    )
    (terminals on)
    (active detail)
   )
  )
  (component 3 "TEXTDISPLAY"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
    )
    (detail
     (origin 815 302)
     (extent 190 37)
    )
    (active detail)
   )
  )
  (component 4 "FORMULA"
   (name " / ")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "X")
     (lock name constraints)
    )
    (input 2
     (type data)
     (name "Y")
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked yes)
    (component expr 1 "X/Y")
   )
   (views
    (icon
     (origin 357 458)
     (extent 46 25)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 5 "FORMULA"
   (name "log(x)")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "X")
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked yes)
    (component expr 1 "log(x)")
   )
   (views
    (icon
     (origin 481 458)
     (extent 78 25)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 6 "FORMULA"
   (name "sum(x)")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "X")
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked yes)
    (component expr 1 "sum(x)")
   )
   (views
    (icon
     (origin 591 458)
     (extent 78 25)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 7 "TEXTDISPLAY"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
    )
    (detail
     (origin 695 452)
     (extent 190 37)
    )
    (active detail)
   )
  )
  (component 8 "CONSTANT"
   (name "Array A")
   (subType "Real")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Real")
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Array A")
     (numDims 1)
     (size 15)
     (data
      [ 4 5 6 7 8 10 12 14 16 18 20 22 24 26 28 ]
     )
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (name "Real")
     (datum 0)
    )
   )
   (views
    (icon
     (extent 78 0)
    )
    (detail
     (origin 15 117)
     (extent 150 287)
     (showFormat real)
    )
    (active detail)
   )
  )
  (component 9 "CONSTANT"
   (name "Array B")
   (subType "Real")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Real")
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Array B")
     (numDims 1)
     (size 15)
     (data
      [ 4 3 2 4 3 2 4 3 2 4 3 2 4 3 2 ]
     )
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (name "Real")
     (datum 0)
    )
   )
   (views
    (icon
     (extent 78 0)
    )
    (detail
     (origin 15 457)
     (extent 150 287)
     (showFormat real)
    )
    (active detail)
   )
  )
  (component 10 "START"
   (interface
    (sequence out)
   )
   (implementation
   )
   (views
    (icon
     (origin 257 42)
     (extent 67 37)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 11 "FORMULA"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (input 2
     (type data)
     (name "B")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "sum(log(A/B))")
   )
   (views
    (icon
     (iconImage "formula.icon")
    )
    (detail
     (origin 324 574)
     (extent 142 92)
    )
    (terminals on)
    (active detail)
   )
  )
  (component 12 "TEXTDISPLAY"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
    )
    (detail
     (origin 705 602)
     (extent 190 37)
    )
    (active detail)
   )
  )
  (component 13 "FORMULA"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "i")
     (optional yes)
    )
    (input 2
     (type data)
     (name "A")
     (optional yes)
    )
    (input 3
     (type data)
     (name "B")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "A[i]/B[i]")
   )
   (views
    (icon
     (origin 331 268)
     (extent 78 64)
     (iconImage "formula.icon")
    )
    (detail
     (origin 304 234)
     (extent 103 132)
    )
    (terminals on)
    (active detail)
   )
  )
  (component 16 "CONTEXT"
   (name "Press For")
   (description 10 4
    This User Object is the outermost "context"
    for the InfoAbout help device.  Within this
    device is the pop-up panel containing the info
    Notepad.  If all you can see is a device with
    "Press For", you should double-click the left
    mouse button on the Press For to restore the
    Panel View of the device.  To see how this device
    operates, click on the Info About button first,
    then press the Detail button in the "Press For"
    title bar.
   )
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (locked no)
    (trigMode deg)
    (nextID 4)
    (component 0 "TOGGLE"
     (name "Info About")
     (description 24 6
      This is a toggle device with the name changed to
      reflect it's function.  The output of the device
      is "0" when the button is up, and "1" when the
      button is down.  
      
      A Reset Control Input terminal has been added to
      to always pop the button back out after showing
      the pop-up help (Info About This Example) User
      Object.
      
      The Toggle has set the "AutoExecute" option to let
      it operate even when the RUN button in the title
      bar has not been pressed.  Note, however, that
      AutoExecute only works when no other threads are
      operating, either from their Start buttons or from
      the RUN button.
      
      To allow the Toggle to operate when other threads
      are running, an Until Break device repeatedly lets
      the Toggle device output it's current value (based
      on the button state) to the If/Then.  Thus, when
      RUN is pressed, the InfoAbout toggle output is
      still monitored for "1".
      
     )
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Reset")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Info About")
       (values range 0 1)
       (datum 0)
      )
      (component autoTrigger on)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (name "LongInt")
       (datum 0)
      )
     )
     (views
      (icon
       (origin 253 331)
       (extent 114 39)
       (format button)
      )
      (detail
       (origin 320 203)
       (extent 42 54)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "CONTEXT"
     (name "Info About This Example")
     (description 10 6
      This is a User Object that has both a detail view
      and a Panel view.  If this device is visible as
      an icon, you must double-click the left mouse
      button to "open up" the non-iconic view.
      
      Since the User Object has both a Panel and Detail
      view, when you double-click on the icon, you will
      first see the Panel view.  To see the components
      of the User Object, press the Detail button in
      the "Info About This Example" title bar.
     )
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (locked no)
      (trigMode deg)
      (nextID 2)
      (component 0 "NOTE"
       (name "NotePad")
       (description 11 8
        This notepad is displayed as a Show on Execute
        panel to present the information to the reader.
        
        It has been "Added to Panel" of the "Info About
        This Example" user object, thus it is not 
        necessary to keep it as an open device inside the
        Detail view; you can edit the notepad from the
        Panel view of this User Object.  You can also
        set/clear the "Enable Edit" flag in this Notepad's
        Object Menu to keep the pop-up notepad from being
        altered by the user.
       )
       (interface
       )
       (implementation
        (component text 38 9
         PURPOSE: Use PARALLEL MATH to operate on arrays of data.
         
         OPERATOR INPUT REQUIRED:  Press RUN and observe the answers.  You may want to enable
                  data flow monitoring by pulling down the Edit menu and selecting Show Data
                  Flow.
         
         EXPLANATION:  Often, VEE will be used to analyze data that is stored in arrays.  In
                  this example, two arrays of data (A and B) will be used.  As an exercise,
                  calculate the sum of the logs of array A divided by array B. The resulting
                  solution with a conventional language might be:
         
                       SUM = 0.0
                       FOR (i = 1 to 15)
                           SUM = SUM + log( A[i] / B[i] )
                       NEXT i
         
                  Directly translating this into VEE is shown in the top of the workspace. If,
                  however, we make use of VEE's ability to operate on all elements of an array
                  in PARALLEL, a much simpler and quicker solution is possible.  The DIVIDE
                  math object produces an output array containing the element-by-element results
                  of the division.   The LOG math object also produces an element-by-element
                  output array containing the log of each of the input array elements.  Finally,
                  the SUM function is used to calculate the sum of all elements of the input
                  array, producing a scalar output that is displayed.
            
                  You can use the "Line Probe" operation to inspect the data output from any of
                  the math objects after the program has been run.  
         
                  One final optimization is possible by combining all the math operations into
                  one FORMULA box, as shown at the bottom of the workspace.  Note that PARALLEL
                  math operations, such as A/B in the formula, give the same element-by-element
                  results as the discrete implementation.  Because VEE doesn't have to execute
                  multiple objects, the operation is slightly faster.  The trade-off is less 
                  clarity in discerning the algorithm used.
         
                     
         
         
        )
       )
       (views
        (icon
         (origin 440 416)
         (extent 78 25)
        )
        (detail
         (origin 76 202)
         (extent 848 437)
         (editing enabled)
        )
        (active detail)
       )
      )
      (component 1 "CONFIRM"
       (name "DONE")
       (description 7 8
        This tiny "thread" begins running when the 
        enclosing UserObject is executed.  When the user
        acknowledges the OK/DONE button, there is nothing
        left to execute, so the thread ends.  Since there
        are not other threads running, the User Object
        is completed and will exit, removing the Show on
        Execute pop-up display.
       )
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 471 472)
         (extent 58 37)
        )
        (detail
         (origin 156 253)
         (extent 79 34)
        )
        (terminals on)
        (active icon)
       )
      )
      (configuration
      )
      (ShowOnExecPanel
       (origin 16 16)
       (extent 849 561)
       (panel
        (origin 88 154)
        (extent 845 533)
        (widget 1 icon
         (title off)
         (origin 487 639)
         (extent 58 37)
        )
        (widget 0 detail
         (title off)
         (origin 104 165)
         (extent 816 465)
         (editing disabled)
        )
       )
      )
     )
     (views
      (icon
       (origin 402 408)
       (extent 217 25)
      )
      (detail
       (origin 67 150)
       (extent 866 520)
       (configuration
       )
       (stackingOrder 1 0)
      )
      (active icon)
     )
    )
    (component 3 "IFTHENELSE"
     (name "!= 0")
     (description 10 6
      This device tests the value of the data input
      and either executes the "Info About This Device"
      User object when the input is "1", or terminates
      the current iteration of the Until Break device.
      
      If no threads are running, the Toggle can generate
      it's output data whenever the button is changed
      (using the Toggle's AutoExecute mode).  In this
      case, either the User Object is executed or the
      Autoexecute sequence terminates.
     )
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a!=0")
     )
     (views
      (icon
       (origin 427 338)
       (extent 46 25)
      )
      (detail
       (origin 349 328)
       (extent 73 64)
      )
      (terminals on)
      (active icon)
     )
    )
    (configuration
     (connect D1:0 D0:1)
     (connect D2:1 D1:0)
     (connect D0:1 D2:1)
    )
   )
   (views
    (icon
     (origin -595 2608)
     (extent 110 25)
    )
    (panel
     (origin 654 110)
     (extent 332 60)
     (widget 0 icon
      (title off)
      (origin 759 118)
      (extent 114 39)
      (format button)
     )
    )
    (detail
     (origin 54 105)
     (extent 912 591)
     (configuration
      (connect D1:0 D0:1
       (Point 510 435)
       (Point 510 450)
       (Point 230 450)
       (Point 230 350)
       (Point 250 350)
      )
      (connect D2:1 D1:0
       (Point 475 340)
       (Point 510 340)
       (Point 510 405)
      )
      (connect D0:1 D2:1
       (Point 369 350)
       (Point 424 350)
      )
     )
     (stackingOrder 0 2 1)
    )
    (active panel)
    (active panel)
   )
  )
  (component 17 "NOTE"
   (interface
   )
   (implementation
   )
   (views
    (icon
     (origin 651 186)
     (extent 338 48)
     (label off)
     (iconImage "/usr/lib/veetest/bitmaps/disclaim.icon")
    )
    (detail
     (origin 830 250)
     (extent 200 100)
     (editing enabled)
    )
    (active icon)
   )
  )
  (component 20 "NOTE"
   (interface
   )
   (implementation
    (component text 3 5
     To Operate, click RUN.
     Click Info About for
     detailed description.
    )
   )
   (views
    (icon
     (iconImage "notepad.icon")
    )
    (detail
     (origin 422 110)
     (extent 217 60)
     (editing enabled)
    )
    (active detail)
   )
  )
  (configuration
   (connect D10:0 D0:0)
   (connect D13:1 D1:1)
   (connect D1:1 D2:1)
   (connect D2:1 D2:2)
   (connect D2:1 D3:1)
   (connect D8:1 D4:1)
   (connect D9:1 D4:2)
   (connect D4:1 D5:1)
   (connect D5:1 D6:1)
   (connect D6:1 D7:1)
   (connect D8:1 D11:1)
   (connect D9:1 D11:2)
   (connect D11:1 D12:1)
   (connect D0:1 D13:1)
   (connect D8:1 D13:2)
   (connect D9:1 D13:3)
  )
 )
 (views
  (detail
   (origin 0 62)
   (extent 1004 669)
   (configuration
    (connect D10:0 D0:0
     (Point 290 81)
     (Point 290 92)
    )
    (connect D13:1 D1:1
     (Point 479 300)
     (Point 498 300)
    )
    (connect D1:1 D2:1
     (Point 581 300)
     (Point 607 300)
    )
    (connect D2:1 D2:2
     (Point 772 320)
     (Point 790 320)
     (Point 790 390)
     (Point 590 390)
     (Point 590 340)
     (Point 607 340)
    )
    (connect D2:1 D3:1
     (Point 772 320)
     (Point 812 320)
    )
    (connect D8:1 D4:1
     (Point 167 260)
     (Point 190 260)
     (Point 190 300)
     (Point 250 300)
     (Point 250 460)
     (Point 354 460)
    )
    (connect D9:1 D4:2
     (Point 167 600)
     (Point 200 600)
     (Point 200 540)
     (Point 240 540)
     (Point 240 480)
     (Point 354 480)
    )
    (connect D4:1 D5:1
     (Point 405 470)
     (Point 478 470)
    )
    (connect D5:1 D6:1
     (Point 561 470)
     (Point 588 470)
    )
    (connect D6:1 D7:1
     (Point 671 470)
     (Point 692 470)
    )
    (connect D8:1 D11:1
     (Point 167 260)
     (Point 190 260)
     (Point 190 300)
     (Point 250 300)
     (Point 250 600)
     (Point 281 600)
    )
    (connect D9:1 D11:2
     (Point 167 600)
     (Point 210 600)
     (Point 210 640)
     (Point 281 640)
    )
    (connect D11:1 D12:1
     (Point 538 620)
     (Point 702 620)
    )
    (connect D0:1 D13:1
     (Point 377 140)
     (Point 400 140)
     (Point 400 180)
     (Point 240 180)
     (Point 240 260)
     (Point 261 260)
    )
    (connect D8:1 D13:2
     (Point 167 260)
     (Point 190 260)
     (Point 190 300)
     (Point 261 300)
    )
    (connect D9:1 D13:3
     (Point 167 600)
     (Point 200 600)
     (Point 200 540)
     (Point 240 540)
     (Point 240 340)
     (Point 261 340)
    )
   )
   (stackingOrder 8 9 0 10 15 16 4 5 6 7
     12 11 14 13 1 2 3)
  )
  (active detail)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
