#! /usr/lib/veetest/veetest -r
(revision "B.00.00")
(date "Mon 16/Nov/1992")
(component 0 "ROOTCONTEXT"
 (name "Importing An Array From a Text File")
 (interface
 )
 (implementation
  (locked no)
  (trigMode deg)
  (nextID 11)
  (component 0 "NOTE"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 4 5
     This example is provided as an
     illustration "as is", and Hewlett-Packard
     Company makes no warranty of any kind
     with regard to this example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 562 109)
     (extent 397 82)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 1 "NOTE"
   (name "Info About")
   (interface
   )
   (implementation
    (component text 29 5
     Overview:
     This model illustrates one way to import an array of
     numeric data from a text file.  In this case, the
     array is always one- or two-dimensional, but the size
     of each dimension is not known.
     
     Details:
     To run this model, your operating system must include 
     the awk shell command.
     
     To run this model, simply press "Start" or "Run".
     
     This is how the model works:
     
     The "Array File" name is concatenated with an awk
     command.  Awk is useful for processing text files.
     In this case, the awk command passed to "Execute 
     Program" reports the number of fields (whitespace 
     separated columns) and records (rows separated by 
     newlines) in the text file.  This row and column 
     information is passed to "From File" which reads the 
     specified number of elements, building the array as 
     it goes.
     
     This approach relies on two important assumptions:
     
        * The array is one- or two-dimensional.
     
        * There are no missing elements.
    )
   )
   (views
    (icon
     (origin 215 208)
     (extent 110 25)
    )
    (detail
     (origin 12 102)
     (extent 517 216)
     (editing enabled)
    )
    (active detail)
   )
  )
  (component 2 "LITERALCONSTANT"
   (name "awk command")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Text")
     (lock name constraints)
    )
   )
   (implementation
    (component value Text
     (name "awk command")
     (datum "awk \'{if(NR==1) print NF}END{print NR}\' ")
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Text
     (name "CString")
     (datum "")
    )
   )
   (views
    (icon
     (origin 65 358)
     (extent 110 25)
    )
    (detail
     (origin 74 400)
     (extent 452 60)
    )
    (active icon)
   )
  )
  (component 3 "FORMULA"
   (name " + ")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "X")
     (lock name constraints)
    )
    (input 2
     (type data)
     (name "Y")
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked yes)
    (component expr 1 "X+Y")
   )
   (views
    (icon
     (origin 217 378)
     (extent 46 25)
    )
    (detail
     (origin 270 115)
     (extent 70 110)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 4 "LITERALCONSTANT"
   (name "Array File")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Text")
     (lock name constraints)
    )
   )
   (implementation
    (component value Text
     (name "Array File")
     (datum "/usr/lib/veetest/examples/concepts/manual28.dat")
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Text
     (name "CString")
     (datum "")
    )
   )
   (views
    (icon
     (origin 65 398)
     (extent 110 25)
    )
    (detail
     (origin 4 396)
     (extent 273 28)
    )
    (active icon)
   )
  )
  (component 5 "START"
   (interface
    (sequence out)
   )
   (implementation
   )
   (views
    (icon
     (origin 367 332)
     (extent 67 37)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 6 "SHELLESCAPE"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Command")
     (tag "Command")
     (requires
      (datatype Text)
      (shape "Scalar")
     )
     (lock constraints)
     (optional yes)
     (buffer YES)
    )
    (output 1
     (type data)
     (name "Exit code")
     (lock name constraints)
    )
    (output 2
     (type data)
     (name "rows")
     (lock constraints)
     (optional yes)
    )
    (output 3
     (type data)
     (name "cols")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (attr iopath pipe read "pipe"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (attr iopath pipe write "pipe"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (procedure
      READ TEXT cols,rows REAL
    )
    (component shell "none")
    (component command "awk \'{if(NR==1) print NF}END{print NR}\' /usr/lib/veetest/examples/concepts/manual28.dat")
    (component deathWait "Yes")
   )
   (views
    (icon
     (origin 303 402)
     (extent 155 76)
     (iconImage "c.icon")
    )
    (detail
     (origin -119 345)
     (extent 978 171)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 7 "TEXTDISPLAY"
   (name "Rows")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 46 0)
    )
    (detail
     (origin 555 363)
     (extent 190 35)
    )
    (active detail)
   )
  )
  (component 8 "TEXTDISPLAY"
   (name "Columns")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (origin 161 478)
     (extent 78 25)
    )
    (detail
     (origin 555 443)
     (extent 190 35)
    )
    (active detail)
   )
  )
  (component 9 "FROMFILE"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "rows")
     (tag "rows")
     (optional yes)
    )
    (input 2
     (type data)
     (name "cols")
     (tag "cols")
     (optional yes)
    )
    (input 3
     (type control)
     (name "File Name")
     (tag "File Name")
     (requires
      (datatype Text)
      (shape "Scalar")
     )
     (lock name constraints)
     (optional yes)
    )
    (output 1
     (type data)
     (name "X")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (attr iopath file read "/usr/lib/veetest/examples/concepts/manual28.dat"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (procedure
      READ TEXT x REAL ARRAY:rows,cols
    )
   )
   (views
    (icon
     (origin 275 178)
     (extent 110 25)
    )
    (detail
     (origin 213 533)
     (extent 325 154)
    )
    (terminals on)
    (active detail)
   )
  )
  (component 10 "TEXTDISPLAY"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (origin 721 478)
     (extent 118 25)
    )
    (detail
     (origin 768 343)
     (extent 325 295)
    )
    (active detail)
   )
  )
  (configuration
   (connect D2:1 D3:1)
   (connect D4:1 D3:2)
   (connect D5:0 D6:0)
   (connect D3:1 D6:1)
   (connect D6:2 D7:1)
   (connect D6:3 D8:1)
   (connect D6:2 D9:1)
   (connect D6:3 D9:2)
   (connect D4:1 D9:3)
   (connect D9:1 D10:1)
  )
 )
 (views
  (detail
   (origin 0 62)
   (extent 980 643)
   (configuration
    (connect D2:1 D3:1
     (Point 177 370)
     (Point 190 370)
     (Point 190 380)
     (Point 214 380)
    )
    (connect D4:1 D3:2
     (Point 177 410)
     (Point 190 410)
     (Point 190 400)
     (Point 214 400)
    )
    (connect D5:0 D6:0
     (Point 400 371)
     (Point 400 380)
     (Point 380 380)
     (Point 380 399)
    )
    (connect D3:1 D6:1
     (Point 265 390)
     (Point 280 390)
     (Point 280 440)
     (Point 300 440)
    )
    (connect D6:2 D7:1
     (Point 460 440)
     (Point 480 440)
     (Point 480 380)
     (Point 552 380)
    )
    (connect D6:3 D8:1
     (Point 460 460)
     (Point 552 460)
    )
    (connect D6:2 D9:1
     (Point 460 440)
     (Point 480 440)
     (Point 480 490)
     (Point 290 490)
     (Point 290 480)
     (Point 100 480)
     (Point 100 560)
     (Point 110 560)
    )
    (connect D6:3 D9:2
     (Point 460 460)
     (Point 490 460)
     (Point 490 390)
     (Point 350 390)
     (Point 350 340)
     (Point 50 340)
     (Point 50 610)
     (Point 110 610)
    )
    (connect D4:1 D9:3
     (Point 177 410)
     (Point 190 410)
     (Point 190 440)
     (Point 90 440)
     (Point 90 660)
     (Point 110 660)
    )
    (connect D9:1 D10:1
     (Point 570 610)
     (Point 750 610)
     (Point 750 490)
     (Point 765 490)
    )
   )
   (stackingOrder 3 7 8 10 2 1 0 5 9 4
     6)
  )
  (active detail)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
