#! /usr/lib/veetest/veetest -r
(revision "B.00.00")
(date "Fri 20/Nov/1992")
(component 0 "ROOTCONTEXT"
 (name "Bin Sort Example")
 (interface
 )
 (implementation
  (UserFunctions
   (nextID 2)
   (context 0
    (name "measResist")
    (interface
     (sequence in)
     (sequence out)
     (output 1
      (type data)
      (name "Res")
      (lock constraints)
      (optional yes)
     )
    )
    (implementation
     (locked no)
     (trigMode deg)
     (nextID 2)
     (component 0 "HPIDSTATE"
      (name "dvm (3478A)")
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "READING")
        (tag "READING")
        (lock constraints)
        (optional yes)
       )
       (output 2
        (type exception)
        (name "Error")
        (lock name constraints)
        (optional yes)
       )
      )
      (implementation
       (component filename "hp3478a.cid")
       (component driver "dvm")
       (component state
        (idComp
         (name "FUNCTION")
         (typeStr "Enum")
         (state "Valid")
         (value "OHM2")
        )
        (idComp
         (name "ARANGE")
         (typeStr "Enum")
         (state "Valid")
         (value "ON")
        )
        (idComp
         (name "RANGE")
         (typeStr "Real")
         (state "Dontcare")
         (value 0)
        )
        (idComp
         (name "NDIG")
         (typeStr "Real")
         (state "Valid")
         (value 3.5)
        )
        (idComp
         (name "TRIGGER")
         (typeStr "Enum")
         (state "Valid")
         (value "SINGLE")
        )
        (idComp
         (name "AZERO")
         (typeStr "Enum")
         (state "Valid")
         (value "ON")
        )
        (idComp
         (name "DISPLAY_STRING")
         (typeStr "Enum")
         (state "Valid")
         (value "NORMAL")
        )
        (idComp
         (name "DISPLAYED_STRING")
         (typeStr "Text")
         (state "Valid")
         (value "            ")
        )
        (idComp
         (name "MASK")
         (typeStr "Int16")
         (state "Valid")
         (value 0)
        )
        (idComp
         (name "ERROR")
         (typeStr "Int16")
         (state "Invalid")
         (value 0)
        )
       )
      )
      (views
       (icon
        (extent 110 0)
        (iconImage "inst.icon")
       )
       (detail
        (origin 280 239)
        (extent 214 215)
        (visiblePanels 3 "DISPL" "HP3478A" "MENUA")
       )
       (terminals on)
       (active detail)
      )
     )
     (component 1 "FORMULA"
      (name "round(x)")
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "X")
        (lock name constraints)
       )
       (output 1
        (type data)
        (name "Result")
        (lock name constraints)
       )
      )
      (implementation
       (component isLocked yes)
       (component expr 1 "round(x)")
      )
      (views
       (icon
        (origin 595 278)
        (extent 110 25)
       )
       (detail
       )
       (terminals on)
       (active icon)
      )
     )
     (configuration
      (connect D0:1 D1:1)
      (connect D1:1 O1:1)
     )
    )
    (views
     (detail
      (origin 245 199)
      (extent 474 280)
      (configuration
       (connect D0:1 D1:1
        (Point 576 286)
        (Point 584 286)
        (Point 584 290)
        (Point 592 290)
       )
       (connect D1:1 O1:1
        (Point 707 290)
        (Point 720 290)
        (Point 720 300)
        (Point 710 300)
        (Point 710 349)
        (Point 716 349)
       )
      )
      (stackingOrder 0 1)
     )
     (terminals on)
     (active detail)
    )
   )
   (context 1
    (name "simResist")
    (interface
     (sequence in)
     (sequence out)
     (output 1
      (type data)
      (name "Res")
      (lock constraints)
      (optional yes)
     )
    )
    (implementation
     (locked no)
     (trigMode deg)
     (nextID 2)
     (component 0 "RANDOMNUMBER"
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "Rand Val")
        (lock name constraints)
       )
      )
      (implementation
       (component lowerLimit 100)
       (component upperLimit 400)
      )
      (views
       (icon
        (origin 427 188)
        (extent 127 25)
       )
       (detail
        (origin 342 290)
        (extent 157 60)
       )
       (terminals on)
       (active detail)
      )
     )
     (component 1 "FORMULA"
      (name "round(x)")
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "X")
        (lock name constraints)
       )
       (output 1
        (type data)
        (name "Result")
        (lock name constraints)
       )
      )
      (implementation
       (component isLocked yes)
       (component expr 1 "round(x)")
      )
      (views
       (icon
        (origin 545 378)
        (extent 110 25)
       )
       (detail
        (origin 552 299)
        (extent 106 62)
       )
       (terminals on)
       (active icon)
      )
     )
     (configuration
      (connect D0:1 D1:1)
      (connect D1:1 O1:1)
     )
    )
    (views
     (detail
      (origin 295 249)
      (extent 374 180)
      (configuration
       (connect D0:1 D1:1
        (Point 591 320)
        (Point 610 320)
        (Point 610 360)
        (Point 530 360)
        (Point 530 390)
        (Point 542 390)
       )
       (connect D1:1 O1:1
        (Point 657 390)
        (Point 670 390)
        (Point 670 380)
        (Point 660 380)
        (Point 660 349)
        (Point 666 349)
       )
      )
      (stackingOrder 0 1)
     )
     (terminals on)
     (active detail)
    )
   )
  )
  (locked no)
  (trigMode rad)
  (nextID 18)
  (component 0 "SEQUENCER"
   (name "Test Value & Tolerance")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "nom")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Return")
     (tag "Return")
     (lock name constraints)
     (optional yes)
    )
    (output 2
     (type exception)
     (name "Error")
     (lock name constraints)
     (optional yes)
    )
   )
   (implementation
    (component logfields "name" "pass" "result")
    (procedure
      test1 LOGEN TESTEX:globalOhms 	PTOLEX: 2 LT nom GT 2 	PASSOP TRTN:[nom 2] 	
      test2 LOGEN TESTEX:globalOhms 	PTOLEX: 5 LT nom GT 5 	PASSOP TRTN:[nom 5] 	
      test3 LOGEN TESTEX:globalOhms 	PTOLEX: 10 LT nom GT 10 	PASSOP TRTN:[nom 10] 	FAILOP TERR:10 
    )
   )
   (views
    (icon
     (extent 208 0)
    )
    (detail
     (origin 91 578)
     (extent 308 105)
    )
    (terminals on)
    (active detail)
   )
  )
  (component 1 "TEXTDISPLAY"
   (name "Bin Sort")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 110 0)
    )
    (detail
     (origin 560 621)
     (extent 180 39)
    )
    (active detail)
   )
  )
  (component 2 "BREAK"
   (interface
    (sequence in)
   )
   (implementation
   )
   (views
    (icon
     (origin 611 678)
     (extent 78 25)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 3 "CONSTANT"
   (name "Real")
   (subType "Real")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Real")
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Real")
     (numDims 1)
     (size 5)
     (data
      [ 330 270 220 180 150 ]
     )
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (name "Real")
     (datum 0)
    )
   )
   (views
    (icon
    )
    (detail
     (origin 17 107)
     (extent 167 127)
     (showFormat real)
    )
    (active detail)
   )
  )
  (component 4 "FORCOUNT"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Count")
     (tag "Count")
     (requires
      (datatype Int32)
      (shape "Scalar")
     )
     (lock constraints)
     (optional yes)
     (buffer YES)
    )
    (output 1
     (type data)
     (name "Count")
     (lock name constraints)
    )
   )
   (implementation
    (component count 5)
   )
   (views
    (icon
     (iconImage "loop.icon")
    )
    (detail
     (origin 165 312)
     (extent 150 36)
    )
    (active detail)
   )
  )
  (component 5 "FORMULA"
   (name "Formula")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "i")
     (optional yes)
    )
    (input 2
     (type data)
     (name "R")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "R[i]")
   )
   (views
    (icon
     (origin 91 398)
     (extent 78 64)
     (iconImage "formula.icon")
    )
    (detail
     (origin 224 425)
     (extent 63 91)
    )
    (terminals on)
    (active detail)
   )
  )
  (component 6 "TOGLOBAL"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
     (tag "Data")
    )
   )
   (implementation
    (component globalName globalOhms)
   )
   (views
    (icon
     (origin 495 128)
     (extent 110 25)
    )
    (detail
     (origin 588 421)
     (extent 124 59)
    )
    (terminals on)
    (active detail)
   )
  )
  (component 7 "TEXTDISPLAY"
   (name "Measured R")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 110 0)
    )
    (detail
     (origin 560 331)
     (extent 180 39)
    )
    (active detail)
   )
  )
  (component 8 "FORMULA"
   (name "totSize(x)")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "X")
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked yes)
    (component expr 1 "totSize(x)")
   )
   (views
    (icon
     (origin 25 318)
     (extent 110 25)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 9 "SEQUENCER"
   (name "Test Bounds")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Return")
     (tag "Return")
     (lock name constraints)
     (optional yes)
    )
    (output 2
     (type exception)
     (name "Error")
     (lock name constraints)
     (optional yes)
    )
   )
   (implementation
    (component logfields "name" "pass" "result")
    (procedure
      test1 LOGEN TESTEX:simResist() 	LIMITEX: 0 GE min(a)*.9 	FAILOP TERR:0 
      test2 LOGEN TESTEX:test1.result 	LIMITEX: 0 LE max(a)*1.1 	PASSOP TRTN:thistest.result 	FAILOP TERR:1 
    )
   )
   (views
    (icon
     (origin 235 173)
     (extent 110 34)
    )
    (detail
     (origin 271 117)
     (extent 308 107)
    )
    (terminals on)
    (active detail)
   )
  )
  (component 10 "TOSTRING"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (output 1
     (type data)
     (name "result")
     (lock name constraints)
    )
   )
   (implementation
    (attr iopath string write "string"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (procedure
      WRITE TEXT a[0]," Ohm,  ",a[1],"%" EOL
    )
   )
   (views
    (icon
     (origin 495 538)
     (extent 110 25)
    )
    (detail
     (origin 401 497)
     (extent 308 107)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 11 "CONTEXT"
   (name "Error Condition")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
   )
   (implementation
    (locked no)
    (trigMode rad)
    (nextID 5)
    (component 0 "LITERALCONSTANT"
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Text")
       (lock name constraints)
      )
     )
     (implementation
      (component value Text
       (name "Text")
       (datum "Out of Range: LOW")
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Text
       (name "CString")
       (datum "")
      )
     )
     (views
      (icon
       (origin 77 258)
       (extent 46 25)
      )
      (detail
       (origin 567 264)
       (extent 167 33)
      )
      (active icon)
     )
    )
    (component 1 "LITERALCONSTANT"
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Text")
       (lock name constraints)
      )
     )
     (implementation
      (component value Text
       (name "Text")
       (datum "Out of Range: HIGH")
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Text
       (name "CString")
       (datum "")
      )
     )
     (views
      (icon
       (origin 77 308)
       (extent 46 25)
      )
      (detail
       (origin 503 316)
       (extent 174 28)
      )
      (active icon)
     )
    )
    (component 2 "TEXTDISPLAY"
     (name "Out of Range")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
      )
     )
     (implementation
      (component clearAtPrerun 1)
      (component clearAtActivate 1)
     )
     (views
      (icon
       (extent 118 0)
      )
      (detail
       (origin 208 399)
       (extent 225 42)
      )
      (active detail)
     )
    )
    (component 3 "CONFIRM"
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Go")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 71 122)
       (extent 58 37)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 4 "FORMULA"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (input 2
       (type data)
       (name "B")
       (optional yes)
      )
      (input 3
       (type data)
       (name "C")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "(A==0 ? B : C)")
     )
     (views
      (icon
       (iconImage "formula.icon")
      )
      (detail
       (origin 205 163)
       (extent 160 154)
      )
      (terminals on)
      (active detail)
     )
    )
    (configuration
     (connect D4:1 D2:1)
     (connect I1:1 D4:1)
     (connect D0:1 D4:2)
     (connect D1:1 D4:3)
    )
    (ShowOnExecPanel
     (origin 371 293)
     (extent 280 163)
     (panel
      (origin 297 233)
      (extent 276 135)
      (widget 2 detail
       (title off)
       (origin 324 302)
       (extent 225 42)
      )
      (widget 3 icon
       (title off)
       (origin 403 249)
       (extent 58 37)
      )
     )
    )
   )
   (views
    (icon
     (origin 368 288)
     (extent 145 25)
    )
    (detail
     (origin 44 103)
     (extent 423 354)
     (configuration
      (connect D4:1 D2:1
       (Point 437 240)
       (Point 460 240)
       (Point 460 340)
       (Point 190 340)
       (Point 190 420)
       (Point 205 420)
      )
      (connect I1:1 D4:1
       (Point 46 290)
       (Point 60 290)
       (Point 60 190)
       (Point 162 190)
      )
      (connect D0:1 D4:2
       (Point 125 270)
       (Point 140 270)
       (Point 140 240)
       (Point 162 240)
      )
      (connect D1:1 D4:3
       (Point 125 320)
       (Point 140 320)
       (Point 140 290)
       (Point 162 290)
      )
     )
     (stackingOrder 4 0 1 2 3)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 12 "BREAK"
   (interface
    (sequence in)
   )
   (implementation
   )
   (views
    (icon
     (origin 401 338)
     (extent 78 25)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 15 "CONTEXT"
   (name "Press For")
   (description 10 4
    This User Object is the outermost "context"
    for the InfoAbout help device.  Within this
    device is the pop-up panel containing the info
    Notepad.  If all you can see is a device with
    "Press For", you should double-click the left
    mouse button on the Press For to restore the
    Panel View of the device.  To see how this device
    operates, click on the Info About button first,
    then press the Detail button in the "Press For"
    title bar.
   )
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (locked no)
    (trigMode deg)
    (nextID 4)
    (component 0 "TOGGLE"
     (name "Info About")
     (description 17 6
      This is a toggle device with the name changed to
      reflect it's function.  The output of the device
      is "0" when the button is up, and "1" when the
      button is down.  
      
      A Reset Control Input terminal has been added to
      to always pop the button back out after showing
      the pop-up help (Info About This Example) User
      Object.
      
      The Toggle has set the "AutoExecute" option to let
      it operate even when the RUN button in the title
      bar has not been pressed.  Note, however, that
      AutoExecute only works when no other threads are
      operating, either from their Start buttons or from
      the RUN button.
      
     )
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Reset")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Info About")
       (values range 0 1)
       (datum 0)
      )
      (component autoTrigger on)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (name "LongInt")
       (datum 0)
      )
     )
     (views
      (icon
       (origin 233 331)
       (extent 114 39)
       (format button)
      )
      (detail
       (origin 320 203)
       (extent 42 54)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "CONTEXT"
     (name "Info About This Example")
     (description 10 6
      This is a User Object that has both a detail view
      and a Panel view.  If this device is visible as
      an icon, you must double-click the left mouse
      button to "open up" the non-iconic view.
      
      Since the User Object has both a Panel and Detail
      view, when you double-click on the icon, you will
      first see the Panel view.  To see the components
      of the User Object, press the Detail button in
      the "Info About This Example" title bar.
     )
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (locked no)
      (trigMode deg)
      (nextID 2)
      (component 0 "NOTE"
       (name "NotePad")
       (description 11 8
        This notepad is displayed as a Show on Execute
        panel to present the information to the reader.
        
        It has been "Added to Panel" of the "Info About
        This Example" user object, thus it is not 
        necessary to keep it as an open device inside the
        Detail view; you can edit the notepad from the
        Panel view of this User Object.  You can also
        set/clear the "Enable Edit" flag in this Notepad's
        Object Menu to keep the pop-up notepad from being
        altered by the user.
       )
       (interface
       )
       (implementation
        (component text 43 9
         PURPOSE:  Shows how to use the Sequencer object to solve a simple bin sort problem.
         
         USER INPUT REQUIRED:  Press "Run".
         
         EXPLANATION:
         	In the old days, carbon resistors were manufactured by a rathar imprecise process,
         	and then tested, sorted and marked.  The trick was that the standard resistance
         	values (for example, 220, 270 and 330 ohms) were chosen to overlap at the 10 
         	percent tolerance.  Thus, you didn't have to throw any resistors away.  This model 
         	sorts the resistors into the proper bins based on the value and the tolerance.
         
         	This example uses two Sequencer objects.  The first one (labeled Test Bounds)
         	checks for the extreme limits and rejects any resistors which do not fit in any
         	bin.  The first test calls a User Function, simResist, to get the value of the
         	resistor.  The second test uses the result from the first test rather than calling
         	simResist again.  Calling simResist a second time would get a different resistor
         	value which is not what we want.  The result of the test, the resistance, is put on 
         	the Return output terminal and is stored in a global variable for later use.
         	The Real array in the upper left corner of the model contains five elements,
         	each representing a standard resistance value.  The list of values is extensible
         	due to the use of totSize().  
         
         	The second Sequencer is inside a loop which indexes down the list of nominal 
         	resistor values.  The three transactions in the Sequencer labeled Test Value & 
         	Tolerance each call the global variable, globalOhms, to get the resistance value.  
         	They test the resistance against the nominal value which is input from the array 
         	and a tolerance.  If the test passes, the real array of the nominal value and the 
         	tolerance (e.g. [220 2]) is output.  The To String formats it for display.
         
         	Note that we are not using the Log output terminal in either Sequencer, so we've
         	deleted it to speed up execution.
         
         	If you want to see the flow of this model, try running it a few times with Show 
         	Exec Flow and Show Data Flow turned on.
         
         	There is also a User Function, measResist(), which can measure the resistance, 
         	instead of simulating it.  If you have a HP 3478A Digital Voltmeter, just connect 
         	it to your HP-IB, change the FORMULA field in test1 to the expression measResist(), 
         	turn Live Mode On, and run the model.
         
         
         
         
        )
       )
       (views
        (icon
         (origin 440 416)
         (extent 78 25)
        )
        (detail
         (origin 56 202)
         (extent 848 437)
         (editing enabled)
        )
        (active detail)
       )
      )
      (component 1 "CONFIRM"
       (name "DONE")
       (description 7 8
        This tiny "thread" begins running when the 
        enclosing UserObject is executed.  When the user
        acknowledges the OK/DONE button, there is nothing
        left to execute, so the thread ends.  Since there
        are not other threads running, the User Object
        is completed and will exit, removing the Show on
        Execute pop-up display.
       )
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 451 472)
         (extent 58 37)
        )
        (detail
         (origin 156 253)
         (extent 79 34)
        )
        (terminals on)
        (active icon)
       )
      )
      (configuration
      )
      (ShowOnExecPanel
       (origin 16 16)
       (extent 849 563)
       (panel
        (origin 68 154)
        (extent 845 533)
        (widget 1 icon
         (title off)
         (origin 467 639)
         (extent 58 37)
        )
        (widget 0 detail
         (title off)
         (origin 85 164)
         (extent 820 465)
         (editing disabled)
        )
       )
      )
     )
     (views
      (icon
       (origin 382 408)
       (extent 217 25)
      )
      (detail
       (origin 47 150)
       (extent 866 520)
       (configuration
       )
       (stackingOrder 1 0)
      )
      (active icon)
     )
    )
    (component 3 "IFTHENELSE"
     (name "!= 0")
     (description 5 6
      If no threads are running, the Toggle can generate
      it's output data whenever the button is changed
      (using the Toggle's AutoExecute mode).  In this
      case, either the User Object is executed or the
      Autoexecute sequence terminates.
     )
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a!=0")
     )
     (views
      (icon
       (origin 407 338)
       (extent 46 25)
      )
      (detail
       (origin 349 328)
       (extent 73 64)
      )
      (terminals on)
      (active icon)
     )
    )
    (configuration
     (connect D1:0 D0:1)
     (connect D2:1 D1:0)
     (connect D0:1 D2:1)
    )
   )
   (views
    (icon
     (origin 445 398)
     (extent 110 25)
    )
    (panel
     (origin 684 104)
     (extent 293 73)
     (widget 0 icon
      (title off)
      (origin 787 122)
      (extent 114 39)
      (format button)
     )
    )
    (detail
     (origin 34 105)
     (extent 912 591)
     (configuration
      (connect D1:0 D0:1
       (Point 490 435)
       (Point 490 450)
       (Point 210 450)
       (Point 210 350)
       (Point 230 350)
      )
      (connect D2:1 D1:0
       (Point 455 340)
       (Point 490 340)
       (Point 490 405)
      )
      (connect D0:1 D2:1
       (Point 349 350)
       (Point 404 350)
      )
     )
     (stackingOrder 0 2 1)
    )
    (active panel)
    (active panel)
   )
  )
  (component 16 "NOTE"
   (interface
   )
   (implementation
   )
   (views
    (icon
     (origin 631 516)
     (extent 338 48)
     (label off)
     (iconImage "disclaim.icon")
    )
    (detail
     (origin 830 250)
     (extent 200 100)
     (editing enabled)
    )
    (active icon)
   )
  )
  (configuration
   (connect D5:1 D0:1)
   (connect D10:1 D1:1)
   (connect D1:0 D2:0)
   (connect D9:0 D4:0)
   (connect D8:1 D4:1)
   (connect D4:1 D5:1)
   (connect D3:1 D5:2)
   (connect D9:1 D6:1)
   (connect D9:1 D7:1)
   (connect D3:1 D8:1)
   (connect D3:1 D9:1)
   (connect D0:1 D10:1)
   (connect D9:2 D11:1)
   (connect D11:0 D12:0)
  )
 )
 (views
  (detail
   (origin 0 62)
   (extent 980 658)
   (configuration
    (connect D5:1 D0:1
     (Point 359 470)
     (Point 380 470)
     (Point 380 530)
     (Point 30 530)
     (Point 30 630)
     (Point 48 630)
    )
    (connect D10:1 D1:1
     (Point 607 550)
     (Point 620 550)
     (Point 620 580)
     (Point 540 580)
     (Point 540 640)
     (Point 557 640)
    )
    (connect D1:0 D2:0
     (Point 650 662)
     (Point 650 675)
    )
    (connect D9:0 D4:0
     (Point 440 226)
     (Point 440 250)
     (Point 240 250)
     (Point 240 281)
    )
    (connect D8:1 D4:1
     (Point 137 330)
     (Point 162 330)
    )
    (connect D4:1 D5:1
     (Point 317 330)
     (Point 340 330)
     (Point 340 370)
     (Point 160 370)
     (Point 160 450)
     (Point 181 450)
    )
    (connect D3:1 D5:2
     (Point 186 170)
     (Point 210 170)
     (Point 210 260)
     (Point 10 260)
     (Point 10 490)
     (Point 181 490)
    )
    (connect D9:1 D6:1
     (Point 651 140)
     (Point 670 140)
     (Point 670 250)
     (Point 540 250)
     (Point 540 350)
     (Point 520 350)
     (Point 520 450)
     (Point 535 450)
    )
    (connect D9:1 D7:1
     (Point 651 140)
     (Point 670 140)
     (Point 670 250)
     (Point 540 250)
     (Point 540 350)
     (Point 557 350)
    )
    (connect D3:1 D8:1
     (Point 186 170)
     (Point 210 170)
     (Point 210 260)
     (Point 10 260)
     (Point 10 330)
     (Point 22 330)
    )
    (connect D3:1 D9:1
     (Point 186 170)
     (Point 228 170)
    )
    (connect D0:1 D10:1
     (Point 471 600)
     (Point 480 600)
     (Point 480 550)
     (Point 492 550)
    )
    (connect D9:2 D11:1
     (Point 651 200)
     (Point 660 200)
     (Point 660 240)
     (Point 530 240)
     (Point 530 260)
     (Point 350 260)
     (Point 350 300)
     (Point 365 300)
    )
    (connect D11:0 D12:0
     (Point 440 315)
     (Point 440 335)
    )
   )
   (stackingOrder 4 8 2 1 7 6 0 12 3 9
     5 14 11 10 13)
  )
  (active detail)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
