#! /usr/lib/veetest/veetest -r
(revision "A.00.01")
(date "Thu 26/Mar/1992")
(component 0 "Context"
 (name "Pie Chart Example")
 (interface
 )
 (implementation
  (locked no)
  (trigMode deg)
  (component 0 "Context"
   (name "Pie Chart")
   (description 57 4
    This User Object converts an input array into
    a pie chart with up to 8 slices.  Each array
    element is converted to a slice proportional
    to the ratio of the element to the sum of all
    elements.  Only the first eight elements are
    represented by uniquely colored slices; any
    additional elements are represented by a empty
    slice.
    
    Since the "Pie Chart" object is built from 
    objects encapsulated within a User Object, you
    will probably want to customize the Trace 
    names and colors by clicking over the piechart
    with the left mouse button, then selecting the
    Traces & Scales sub-menu.  Unused Trace input
    terminals can be deleted, but you must also
    modify the "RangeCalc" formula to reflect the max
    number of input elements to process.  Also, each
    unused Arc[] formula should be deleted to avoid
    accessing nonexistent array elements.  Finally,
    you will probably want to Secure the User Object
    to prevent the end-user from modifying these
    settings.
    
    HOW IT WORKS:
    
    First, the input data must be "stretched" into an
    array that is at least 8 elements long using a
    concat() function to add some Zero data.
    
    Next, the RangeCalc formula normalizes the input
    array so that each element represents the number
    of degrees out of 360 total.
    
    Third, an array of angles 2 degrees apart is
    generated in the Arc[] formulas.  A test must
    be made to insure that at least 2 points are
    produced.  Each Arc[] produces the array starting
    at the sum of the angles of preceeding slices,
    and ending at the sum of angles including the
    slice.  Thus, each Arc[] formula specifies the
    summing ranges needed to generate the arc data.
    
    Fourth, each array of angles is converted into
    an array of Polar Complex numbers with a radius
    of 1.  This represents an arc 1 unit from the
    origin.  If this were plotted on a Polar display,
    it would draw an arc proportional to the slice
    size.  
    
    In order to "fill" the slice with a solid color,
    the display "Traces & Scales" menu is used to
    set the Line Type to "Solid Fill".  This mode on
    an XY (cartesian) display causes a solid bar to
    be generated from each line segment to the X axis.
    On a polar display, it generates a solid pattern
    from the arc to the origin point at (0,0).
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
   )
   (implementation
    (locked no)
    (trigMode deg)
    (component 0 "Constant"
     (name "1")
     (subType "Real")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Real")
       (lock name constraints)
      )
     )
     (implementation
      (component value Real
       (name "1")
       (datum 1)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Real
       (datum 0)
      )
     )
     (views
      (icon
       (origin 447 158)
       (extent 46 25)
      )
      (detail
       (origin 390 184)
       (extent 120 32)
       (showFormat real)
      )
      (active icon)
     )
    )
    (component 1 "ToPComplex"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Mag")
       (requires
        (datatype Real)
       )
       (lock name constraints)
      )
      (input 2
       (type data)
       (name "Phase")
       (requires
        (datatype Real)
       )
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "PComplex")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 572 228)
       (extent 136 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "ToSpectrum"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Array")
       (tag "Array")
       (requires
        (datatype PComplex)
       )
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "Spectrum")
       (tag "Spectrum")
       (lock name constraints)
      )
     )
     (implementation
      (component freqMode "Start/Stop Freq")
      (component start 0)
      (component stop 1000)
      (component xMapping Linear)
     )
     (views
      (icon
       (origin 732 188)
       (extent 136 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 3 "ToSpectrum"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Array")
       (tag "Array")
       (requires
        (datatype PComplex)
       )
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "Spectrum")
       (tag "Spectrum")
       (lock name constraints)
      )
     )
     (implementation
      (component freqMode "Start/Stop Freq")
      (component start 0)
      (component stop 1000)
      (component xMapping Linear)
     )
     (views
      (icon
       (origin 732 228)
       (extent 136 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 4 "ToPComplex"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Mag")
       (requires
        (datatype Real)
       )
       (lock name constraints)
      )
      (input 2
       (type data)
       (name "Phase")
       (requires
        (datatype Real)
       )
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "PComplex")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 572 268)
       (extent 136 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 5 "ToSpectrum"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Array")
       (tag "Array")
       (requires
        (datatype PComplex)
       )
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "Spectrum")
       (tag "Spectrum")
       (lock name constraints)
      )
     )
     (implementation
      (component freqMode "Start/Stop Freq")
      (component start 0)
      (component stop 1000)
      (component xMapping Linear)
     )
     (views
      (icon
       (origin 732 268)
       (extent 136 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 6 "ToSpectrum"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Array")
       (tag "Array")
       (requires
        (datatype PComplex)
       )
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "Spectrum")
       (tag "Spectrum")
       (lock name constraints)
      )
     )
     (implementation
      (component freqMode "Start/Stop Freq")
      (component start 0)
      (component stop 1000)
      (component xMapping Linear)
     )
     (views
      (icon
       (origin 732 308)
       (extent 136 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 7 "ToPComplex"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Mag")
       (requires
        (datatype Real)
       )
       (lock name constraints)
      )
      (input 2
       (type data)
       (name "Phase")
       (requires
        (datatype Real)
       )
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "PComplex")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 572 308)
       (extent 136 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 8 "ToSpectrum"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Array")
       (tag "Array")
       (requires
        (datatype PComplex)
       )
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "Spectrum")
       (tag "Spectrum")
       (lock name constraints)
      )
     )
     (implementation
      (component freqMode "Start/Stop Freq")
      (component start 0)
      (component stop 1000)
      (component xMapping Linear)
     )
     (views
      (icon
       (origin 732 348)
       (extent 136 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 9 "ToPComplex"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Mag")
       (requires
        (datatype Real)
       )
       (lock name constraints)
      )
      (input 2
       (type data)
       (name "Phase")
       (requires
        (datatype Real)
       )
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "PComplex")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 572 348)
       (extent 136 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 10 "ToPComplex"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Mag")
       (requires
        (datatype Real)
       )
       (lock name constraints)
      )
      (input 2
       (type data)
       (name "Phase")
       (requires
        (datatype Real)
       )
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "PComplex")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 572 388)
       (extent 136 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 11 "ToSpectrum"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Array")
       (tag "Array")
       (requires
        (datatype PComplex)
       )
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "Spectrum")
       (tag "Spectrum")
       (lock name constraints)
      )
     )
     (implementation
      (component freqMode "Start/Stop Freq")
      (component start 0)
      (component stop 1000)
      (component xMapping Linear)
     )
     (views
      (icon
       (origin 732 388)
       (extent 136 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 12 "ToSpectrum"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Array")
       (tag "Array")
       (requires
        (datatype PComplex)
       )
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "Spectrum")
       (tag "Spectrum")
       (lock name constraints)
      )
     )
     (implementation
      (component freqMode "Start/Stop Freq")
      (component start 0)
      (component stop 1000)
      (component xMapping Linear)
     )
     (views
      (icon
       (origin 732 428)
       (extent 136 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 13 "ToPComplex"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Mag")
       (requires
        (datatype Real)
       )
       (lock name constraints)
      )
      (input 2
       (type data)
       (name "Phase")
       (requires
        (datatype Real)
       )
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "PComplex")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 572 428)
       (extent 136 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 14 "ToSpectrum"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Array")
       (tag "Array")
       (requires
        (datatype PComplex)
       )
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "Spectrum")
       (tag "Spectrum")
       (lock name constraints)
      )
     )
     (implementation
      (component freqMode "Start/Stop Freq")
      (component start 0)
      (component stop 1000)
      (component xMapping Linear)
     )
     (views
      (icon
       (origin 732 468)
       (extent 136 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 15 "ToPComplex"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Mag")
       (requires
        (datatype Real)
       )
       (lock name constraints)
      )
      (input 2
       (type data)
       (name "Phase")
       (requires
        (datatype Real)
       )
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "PComplex")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 572 468)
       (extent 136 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 16 "Formula"
     (name "Arc[0]")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "ramp(max([a[0]/2 2]),0,a[0])")
     )
     (views
      (icon
       (origin 431 198)
       (extent 78 25)
      )
      (detail
       (origin 222 190)
       (extent 286 41)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 17 "Formula"
     (name "Arc[2]")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "ramp(max([a[2]/2 2]),sum(a[0:1]),sum(a[0:2]))")
     )
     (views
      (icon
       (origin 431 278)
       (extent 78 25)
      )
      (detail
       (origin 216 271)
       (extent 439 38)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 18 "Formula"
     (name "Arc[3]")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "ramp(max([a[3]/2 2]),sum(a[0:2]),sum(a[0:3]))")
     )
     (views
      (icon
       (origin 431 318)
       (extent 78 25)
      )
      (detail
       (origin 216 313)
       (extent 439 34)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 19 "Formula"
     (name "Arc[4]")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "ramp(max([a[4]/2 2]),sum(a[0:3]),sum(a[0:4]))")
     )
     (views
      (icon
       (origin 431 358)
       (extent 78 25)
      )
      (detail
       (origin 216 351)
       (extent 439 39)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 20 "Formula"
     (name "Arc[5]")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "ramp(max([a[5]/2 2]),sum(a[0:4]),sum(a[0:5]))")
     )
     (views
      (icon
       (origin 431 398)
       (extent 78 25)
      )
      (detail
       (origin 216 392)
       (extent 439 37)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 21 "Formula"
     (name "Arc[6]")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "ramp(max([a[6]/2 2]),sum(a[0:5]),sum(a[0:6]))")
     )
     (views
      (icon
       (origin 431 438)
       (extent 78 25)
      )
      (detail
       (origin 216 431)
       (extent 439 38)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 22 "Formula"
     (name "Arc[7]")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "ramp(max([a[7]/2 2]),sum(a[0:6]),sum(a[0:7]))")
     )
     (views
      (icon
       (origin 431 478)
       (extent 78 25)
      )
      (detail
       (origin 216 471)
       (extent 439 38)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 23 "Formula"
     (name "Stretch")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "concat(a,[0 0 0 0 0 0 0])")
     )
     (views
      (icon
       (origin 301 328)
       (extent 78 25)
      )
      (detail
       (origin 191 333)
       (extent 259 35)
      )
      (active icon)
     )
    )
    (component 24 "Formula"
     (name "Arc[1]")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "ramp(max([a[1]/2 2]),a[0],a[0]+a[1])")
     )
     (views
      (icon
       (origin 431 238)
       (extent 78 25)
      )
      (detail
       (origin 206 231)
       (extent 358 38)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 25 "YPlot"
     (name "Magnitude vs Phase")
     (subType "Mag_vs_Phase")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "0000:")
       (lock constraints)
      )
      (input 2
       (type data)
       (name "0001:")
       (lock constraints)
       (optional yes)
      )
      (input 3
       (type data)
       (name "0002:")
       (lock constraints)
       (optional yes)
      )
      (input 4
       (type data)
       (name "0003:")
       (lock constraints)
       (optional yes)
      )
      (input 5
       (type data)
       (name "0004:")
       (lock constraints)
       (optional yes)
      )
      (input 6
       (type data)
       (name "0005:")
       (lock constraints)
       (optional yes)
      )
      (input 7
       (type data)
       (name "0006:")
       (lock constraints)
       (optional yes)
      )
      (input 8
       (type data)
       (name "0007:")
       (lock constraints)
       (optional yes)
      )
     )
     (implementation
      (component clearAtPrerun 1)
      (component clearAtActivate 1)
      (component tracePin 1)
      (component tracePin 2)
      (component tracePin 3)
      (component tracePin 4)
      (component tracePin 5)
      (component tracePin 6)
      (component tracePin 7)
      (component tracePin 8)
      (component graphMode phasemag)
     )
     (views
      (icon
       (iconImage "display.icon")
      )
      (detail
       (origin 901 164)
       (extent 339 352)
       (displayMode graphOnly)
       (graphType polar)
       (gridType off)
       (scale 0
        (name "Mag")
        (pen 9)
        (show 1)
        (vspan 2.078078078078078)
       )
       (trace 0 onScale 0
        (name "0000:")
        (pen 4)
        (lineType 1)
        (pointType 6)
       )
       (trace 1 onScale 0
        (name "0001:")
        (pen 7)
        (lineType 1)
        (pointType 6)
       )
       (trace 2 onScale 0
        (name "0002:")
        (pen 6)
        (lineType 1)
        (pointType 6)
       )
       (trace 3 onScale 0
        (name "0003:")
        (pen 3)
        (lineType 1)
        (pointType 6)
       )
       (trace 4 onScale 0
        (name "0004:")
        (pen 2)
        (lineType 1)
        (pointType 6)
       )
       (trace 5 onScale 0
        (name "0005:")
        (pen 5)
        (lineType 1)
        (pointType 6)
       )
       (trace 6 onScale 0
        (name "0006:")
        (pen 8)
        (lineType 1)
        (pointType 6)
       )
       (trace 7 onScale 0
        (name "0007:")
        (pen 1)
        (lineType 1)
        (pointType 6)
       )
      )
      (active detail)
     )
    )
    (component 26 "Formula"
     (name "RangeCalc")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "a[0:7]/sum(a)*360")
     )
     (views
      (icon
       (origin 285 198)
       (extent 110 25)
      )
      (detail
       (origin 274 193)
       (extent 232 35)
      )
      (active icon)
     )
    )
    (component 27 "ToPComplex"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Mag")
       (requires
        (datatype Real)
       )
       (lock name constraints)
      )
      (input 2
       (type data)
       (name "Phase")
       (requires
        (datatype Real)
       )
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "PComplex")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 572 188)
       (extent 136 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (configuration
     (connect D0:1 D1:1)
     (connect D24:1 D1:2)
     (connect D27:1 D2:1)
     (connect D1:1 D3:1)
     (connect D0:1 D4:1)
     (connect D17:1 D4:2)
     (connect D4:1 D5:1)
     (connect D7:1 D6:1)
     (connect D0:1 D7:1)
     (connect D18:1 D7:2)
     (connect D9:1 D8:1)
     (connect D0:1 D9:1)
     (connect D19:1 D9:2)
     (connect D0:1 D10:1)
     (connect D20:1 D10:2)
     (connect D10:1 D11:1)
     (connect D13:1 D12:1)
     (connect D0:1 D13:1)
     (connect D21:1 D13:2)
     (connect D15:1 D14:1)
     (connect D0:1 D15:1)
     (connect D22:1 D15:2)
     (connect D26:1 D16:1)
     (connect D26:1 D17:1)
     (connect D26:1 D18:1)
     (connect D26:1 D19:1)
     (connect D26:1 D20:1)
     (connect D26:1 D21:1)
     (connect D26:1 D22:1)
     (connect I1:1 D23:1)
     (connect D26:1 D24:1)
     (connect D2:1 D25:1)
     (connect D3:1 D25:2)
     (connect D5:1 D25:3)
     (connect D6:1 D25:4)
     (connect D8:1 D25:5)
     (connect D11:1 D25:6)
     (connect D12:1 D25:7)
     (connect D14:1 D25:8)
     (connect D23:1 D26:1)
     (connect D0:1 D27:1)
     (connect D16:1 D27:2)
    )
   )
   (views
    (icon
     (extent 110 0)
    )
    (panel
     (origin 394 115)
     (extent 372 350)
     (widget 25 detail
      (title off)
      (origin 399 121)
      (extent 363 340)
      (displayMode annotGraph)
      (graphType polar)
      (gridType off)
      (scale 0
       (name "Mag")
       (pen 9)
       (show 1)
       (vspan 2.185483870967742)
      )
      (trace 0 onScale 0
       (name "0000:")
       (pen 2)
       (lineType 1)
       (pointType 6)
      )
      (trace 1 onScale 0
       (name "0001:")
       (pen 7)
       (lineType 1)
       (pointType 6)
      )
      (trace 2 onScale 0
       (name "0002:")
       (pen 4)
       (lineType 1)
       (pointType 6)
      )
      (trace 3 onScale 0
       (name "0003:")
       (pen 3)
       (lineType 1)
       (pointType 6)
      )
      (trace 4 onScale 0
       (name "0004:")
       (pen 6)
       (lineType 1)
       (pointType 6)
      )
      (trace 5 onScale 0
       (name "0005:")
       (pen 5)
       (lineType 1)
       (pointType 6)
      )
      (trace 6 onScale 0
       (name "0006:")
       (pen 8)
       (lineType 1)
       (pointType 6)
      )
      (trace 7 onScale 0
       (name "0007:")
       (pen 1)
       (lineType 1)
       (pointType 6)
      )
     )
    )
    (detail
     (origin 268 119)
     (extent 705 423)
     (configuration
      (connect D0:1 D1:1
       (Point 495 170)
       (Point 530 170)
       (Point 530 190)
       (Point 540 190)
       (Point 540 230)
       (Point 569 230)
      )
      (connect D24:1 D1:2
       (Point 511 250)
       (Point 569 250)
      )
      (connect D27:1 D2:1
       (Point 710 200)
       (Point 729 200)
      )
      (connect D1:1 D3:1
       (Point 710 240)
       (Point 729 240)
      )
      (connect D0:1 D4:1
       (Point 495 170)
       (Point 530 170)
       (Point 530 190)
       (Point 540 190)
       (Point 540 270)
       (Point 569 270)
      )
      (connect D17:1 D4:2
       (Point 511 290)
       (Point 569 290)
      )
      (connect D4:1 D5:1
       (Point 710 280)
       (Point 729 280)
      )
      (connect D7:1 D6:1
       (Point 710 320)
       (Point 729 320)
      )
      (connect D0:1 D7:1
       (Point 495 170)
       (Point 530 170)
       (Point 530 190)
       (Point 540 190)
       (Point 540 310)
       (Point 569 310)
      )
      (connect D18:1 D7:2
       (Point 511 330)
       (Point 569 330)
      )
      (connect D9:1 D8:1
       (Point 710 360)
       (Point 729 360)
      )
      (connect D0:1 D9:1
       (Point 495 170)
       (Point 530 170)
       (Point 530 190)
       (Point 540 190)
       (Point 540 350)
       (Point 569 350)
      )
      (connect D19:1 D9:2
       (Point 511 370)
       (Point 569 370)
      )
      (connect D0:1 D10:1
       (Point 495 170)
       (Point 530 170)
       (Point 530 190)
       (Point 540 190)
       (Point 540 390)
       (Point 569 390)
      )
      (connect D20:1 D10:2
       (Point 511 410)
       (Point 569 410)
      )
      (connect D10:1 D11:1
       (Point 710 400)
       (Point 729 400)
      )
      (connect D13:1 D12:1
       (Point 710 440)
       (Point 729 440)
      )
      (connect D0:1 D13:1
       (Point 495 170)
       (Point 530 170)
       (Point 530 190)
       (Point 540 190)
       (Point 540 430)
       (Point 569 430)
      )
      (connect D21:1 D13:2
       (Point 511 450)
       (Point 569 450)
      )
      (connect D15:1 D14:1
       (Point 710 480)
       (Point 729 480)
      )
      (connect D0:1 D15:1
       (Point 495 170)
       (Point 530 170)
       (Point 530 190)
       (Point 540 190)
       (Point 540 470)
       (Point 569 470)
      )
      (connect D22:1 D15:2
       (Point 511 490)
       (Point 569 490)
      )
      (connect D26:1 D16:1
       (Point 397 210)
       (Point 412 210)
       (Point 412 210)
       (Point 428 210)
      )
      (connect D26:1 D17:1
       (Point 397 210)
       (Point 410 210)
       (Point 410 290)
       (Point 428 290)
      )
      (connect D26:1 D18:1
       (Point 397 210)
       (Point 410 210)
       (Point 410 330)
       (Point 428 330)
      )
      (connect D26:1 D19:1
       (Point 397 210)
       (Point 410 210)
       (Point 410 370)
       (Point 428 370)
      )
      (connect D26:1 D20:1
       (Point 397 210)
       (Point 410 210)
       (Point 410 410)
       (Point 428 410)
      )
      (connect D26:1 D21:1
       (Point 397 210)
       (Point 410 210)
       (Point 410 450)
       (Point 428 450)
      )
      (connect D26:1 D22:1
       (Point 397 210)
       (Point 410 210)
       (Point 410 490)
       (Point 428 490)
      )
      (connect I1:1 D23:1
       (Point 270 340)
       (Point 287 340)
       (Point 287 340)
       (Point 298 340)
      )
      (connect D26:1 D24:1
       (Point 397 210)
       (Point 410 210)
       (Point 410 250)
       (Point 428 250)
      )
      (connect D2:1 D25:1
       (Point 870 200)
       (Point 898 200)
      )
      (connect D3:1 D25:2
       (Point 870 240)
       (Point 898 240)
      )
      (connect D5:1 D25:3
       (Point 870 280)
       (Point 898 280)
      )
      (connect D6:1 D25:4
       (Point 870 320)
       (Point 898 320)
      )
      (connect D8:1 D25:5
       (Point 870 360)
       (Point 898 360)
      )
      (connect D11:1 D25:6
       (Point 870 400)
       (Point 898 400)
      )
      (connect D12:1 D25:7
       (Point 870 440)
       (Point 898 440)
      )
      (connect D14:1 D25:8
       (Point 870 480)
       (Point 898 480)
      )
      (connect D23:1 D26:1
       (Point 381 340)
       (Point 400 340)
       (Point 400 310)
       (Point 270 310)
       (Point 270 210)
       (Point 282 210)
      )
      (connect D0:1 D27:1
       (Point 495 170)
       (Point 530 170)
       (Point 530 190)
       (Point 569 190)
      )
      (connect D16:1 D27:2
       (Point 511 210)
       (Point 569 210)
      )
     )
    )
    (active panel)
    (active panel)
   )
  )
  (component 1 "TextDisplay"
   (name "Data")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 46 0)
    )
    (detail
     (origin 22 378)
     (extent 156 204)
    )
    (active detail)
   )
  )
  (component 2 "TextDisplay"
   (name "Percent")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 78 0)
    )
    (detail
     (origin 212 378)
     (extent 156 204)
    )
    (active detail)
   )
  )
  (component 3 "Formula"
   (name "Random Distribution")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "randomize(ramp(random(1,10),0,0),1,50)")
   )
   (views
    (icon
     (origin 70 228)
     (extent 181 25)
    )
    (detail
     (origin 102 290)
     (extent 376 60)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 4 "Formula"
   (name "Percent")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "a/sum(a)*100")
   )
   (views
    (icon
     (origin 111 308)
     (extent 78 25)
    )
    (detail
     (origin 254 370)
     (extent 142 60)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 5 "Note"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 5 5
     This example is provided as an
     illustration "as is", and Hewlett-
     Packard Company makes no warranty
     of any kind with regard to this
     example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 425 503)
     (extent 330 95)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 6 "Context"
   (name "Press For")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (locked no)
    (trigMode deg)
    (component 0 "IfThenElse"
     (name "!= 0")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a!=0")
     )
     (views
      (icon
       (origin 365 350)
       (extent 46 25)
      )
      (detail
       (origin 209 308)
       (extent 73 64)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "Toggle"
     (name "Info About")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Reset")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Info About")
       (values range 0 1)
       (datum 0)
      )
      (component autoTrigger on)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (datum 0)
      )
     )
     (views
      (icon
       (origin 201 343)
       (extent 114 39)
       (format button)
      )
      (detail
       (origin 320 203)
       (extent 42 54)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "Context"
     (name "Info About This Example")
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (locked no)
      (trigMode deg)
      (component 0 "Confirm"
       (name "DONE")
       (description 7 8
        This tiny "thread" begins running when the 
        enclosing UserObject is executed.  When the user
        acknowledges the OK/DONE button, there is nothing
        left to execute, so the thread ends.  Since there
        are not other threads running, the User Object
        is completed and will exit, removing the Show on
        Execute pop-up display.
       )
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 421 482)
         (extent 58 37)
        )
        (detail
         (origin 156 253)
         (extent 79 34)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "Note"
       (name "NotePad")
       (description 2 8
        This notepad is displayed as a Show on Execute
        panel to present the information to the reader.
       )
       (interface
       )
       (implementation
        (component text 18 9
         PURPOSE:     Illustrates use of the PieChart library object to display an array of data.
         
         USER INPUT REQUIRED: Press Run to display a Pie Chart with a random number of slices.
         
         EXPLANATION: To generate some interesting data to display, an array with 1 to 10 random
                      numbers is produced in the Formula object "Random Distribution".  The array
                      data is displayed as both raw data and as a percent of total data, and is
                      also displayed by the PieChart library object.
         
         IMPLEMENTATION:  The PieChart library object provides additional usage information from
                      the Show Description choice in the object menu.  Setting colors, etc. is
                      described here, along with a description of the input requirements.  When
                      using the PieChart object in your models, you may want to place and size it,
                      then secure the User Object to prevent inadvertent changes.
         
                      Since the PieChart is a User Object, you may want to examine it to see how
                      the slice data is generated.  In particular, note the use of the Polar
                      display with line type set to "solid fill to origon" mode.
        )
       )
       (views
        (icon
         (origin 410 415)
         (extent 78 25)
        )
        (detail
         (origin 25 209)
         (extent 848 437)
         (editing disabled)
        )
        (active icon)
       )
      )
      (configuration
      )
      (ShowOnExecPanel
       (origin 0 41)
       (extent 849 571)
       (panel
        (origin 38 164)
        (extent 845 533)
        (widget 0 icon
         (title off)
         (origin 437 649)
         (extent 58 37)
        )
        (widget 1 detail
         (title off)
         (origin 45 175)
         (extent 832 463)
         (editing disabled)
        )
       )
      )
     )
     (views
      (icon
       (origin 352 418)
       (extent 217 25)
      )
      (detail
       (origin 17 160)
       (extent 866 520)
       (configuration
       )
      )
      (active icon)
     )
    )
    (configuration
     (connect D1:1 D0:1)
     (connect D2:0 D1:1)
     (connect D0:1 D2:0)
    )
   )
   (views
    (icon
     (origin 415 408)
     (extent 110 25)
    )
    (panel
     (origin 11 122)
     (extent 319 77)
     (widget 1 icon
      (title off)
      (origin 113 135)
      (extent 114 39)
      (format button)
     )
    )
    (detail
     (origin 4 115)
     (extent 912 591)
     (configuration
      (connect D1:1 D0:1
       (Point 317 362)
       (Point 362 362)
      )
      (connect D2:0 D1:1
       (Point 460 445)
       (Point 460 460)
       (Point 180 460)
       (Point 180 362)
       (Point 198 362)
      )
      (connect D0:1 D2:0
       (Point 413 352)
       (Point 460 352)
       (Point 460 415)
      )
     )
    )
    (active panel)
    (active panel)
   )
  )
  (configuration
   (connect D3:1 D0:1)
   (connect D3:1 D1:1)
   (connect D4:1 D2:1)
   (connect D3:1 D4:1)
  )
 )
 (views
  (panel
   (origin 0 67)
   (extent 958 558)
   (widget 0 panel
    (title on)
    (origin 406 112)
    (extent 538 496)
    (widget 25 detail
     (title off)
     (origin 410 116)
     (extent 530 488)
     (displayMode annotGraph)
     (graphType polar)
     (gridType off)
     (scale 0
      (name "LABELS")
      (pen 9)
      (show 1)
      (vspan 2.185483870967742)
     )
     (trace 0 onScale 0
      (name "0000:")
      (pen 2)
      (lineType 1)
      (pointType 6)
     )
     (trace 1 onScale 0
      (name "0001:")
      (pen 7)
      (lineType 1)
      (pointType 6)
     )
     (trace 2 onScale 0
      (name "0002:")
      (pen 4)
      (lineType 1)
      (pointType 6)
     )
     (trace 3 onScale 0
      (name "0003:")
      (pen 3)
      (lineType 1)
      (pointType 6)
     )
     (trace 4 onScale 0
      (name "0004:")
      (pen 6)
      (lineType 1)
      (pointType 6)
     )
     (trace 5 onScale 0
      (name "0005:")
      (pen 5)
      (lineType 1)
      (pointType 6)
     )
     (trace 6 onScale 0
      (name "0006:")
      (pen 8)
      (lineType 1)
      (pointType 6)
     )
     (trace 7 onScale 0
      (name "0007:")
      (pen 1)
      (lineType 1)
      (pointType 6)
     )
    )
   )
   (widget 5 detail
    (title on)
    (origin 24 506)
    (extent 339 97)
    (editing disabled)
   )
   (widget 6 panel
    (title on)
    (origin 28 112)
    (extent 333 76)
    (widget 1 icon
     (title off)
     (origin 140 128)
     (extent 114 39)
     (format button)
    )
   )
   (widget 2 detail
    (title on)
    (origin 200 238)
    (extent 159 221)
   )
   (widget 1 detail
    (title on)
    (origin 25 237)
    (extent 157 223)
   )
  )
  (detail
   (origin 0 67)
   (extent 885 540)
   (configuration
    (connect D3:1 D0:1
     (Point 253 240)
     (Point 270 240)
     (Point 270 290)
     (Point 391 290)
    )
    (connect D3:1 D1:1
     (Point 253 240)
     (Point 270 240)
     (Point 270 290)
     (Point 90 290)
     (Point 90 320)
     (Point 10 320)
     (Point 10 480)
     (Point 19 480)
    )
    (connect D4:1 D2:1
     (Point 191 320)
     (Point 200 320)
     (Point 200 480)
     (Point 209 480)
    )
    (connect D3:1 D4:1
     (Point 253 240)
     (Point 270 240)
     (Point 270 290)
     (Point 90 290)
     (Point 90 320)
     (Point 108 320)
    )
   )
  )
  (active panel)
  (active panel)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
