#! /usr/lib/veetest/veetest -r
(revision "A.00.01")
(date "Tue 17/Sep/1991")
(component 0 "Context"
 (name "Discounted Payback Period  Example")
 (interface
 )
 (implementation
  (trigMode deg)
  (locked no)
  (component 0 "Note"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 5 5
     This example is provided as an
     illustration "as is", and
     Hewlett-Packard Company makes no
     warranty of any kind with regard
     to this example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 339 118)
     (extent 302 105)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 1 "Context"
   (name "Adjust Arrays")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data2")
     (optional yes)
    )
    (input 2
     (type data)
     (name "R")
     (optional yes)
    )
    (input 3
     (type data)
     (name "A")
     (optional yes)
    )
    (input 4
     (type data)
     (name "M")
     (optional yes)
    )
    (input 5
     (type data)
     (name "B")
     (optional yes)
    )
    (input 6
     (type data)
     (name "I")
     (optional yes)
    )
    (input 7
     (type data)
     (name "C")
     (optional yes)
    )
    (output 1
     (type data)
     (name "X")
     (lock constraints)
     (optional yes)
    )
    (output 2
     (type data)
     (name "Y")
     (lock constraints)
     (optional yes)
    )
    (output 3
     (type data)
     (name "Z")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "VectorConcatenator"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data1")
       (optional yes)
      )
      (input 2
       (type data)
       (name "Data2")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Array")
       (tag "Array")
       (lock constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 616 738)
       (extent 118 25)
      )
      (detail
       (origin 814 826)
       (extent 62 108)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "VectorConcatenator"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data1")
       (optional yes)
      )
      (input 2
       (type data)
       (name "Data2")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Array")
       (tag "Array")
       (lock constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 616 588)
       (extent 118 25)
      )
      (detail
       (origin 814 826)
       (extent 62 108)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "VectorConcatenator"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data1")
       (optional yes)
      )
      (input 2
       (type data)
       (name "Data2")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Array")
       (tag "Array")
       (lock constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 606 458)
       (extent 118 25)
      )
      (detail
       (origin 814 826)
       (extent 62 108)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 3 "AllocateArray"
     (name "Alloc Real")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Dim Size 1")
       (tag "Dim Size 1")
       (requires
        (datatype Int32)
        (shape "Scalar")
       )
       (lock constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (name "Array")
       (tag "Array")
       (lock constraints)
      )
      (buffers in
       (buffer "Dim Size 1")
      )
     )
     (implementation
      (component numDims 1)
      (component dimSizes "24")
      (component type "Real")
      (component initEnum "Init Value")
      (component initialValue
       (name "Init Value")
       (datum 0)
      )
      (component from 1)
      (component thru 10)
     )
     (views
      (icon
       (origin 480 468)
       (extent 110 25)
      )
      (detail
       (origin 501 828)
       (extent 359 124)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 4 "AllocateArray"
     (name "Alloc Real")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Dim Size 1")
       (tag "Dim Size 1")
       (requires
        (datatype Int32)
        (shape "Scalar")
       )
       (lock constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (name "Array")
       (tag "Array")
       (lock constraints)
      )
      (buffers in
       (buffer "Dim Size 1")
      )
     )
     (implementation
      (component numDims 1)
      (component dimSizes "14")
      (component type "Real")
      (component initEnum "Init Value")
      (component initialValue
       (name "Init Value")
       (datum 0)
      )
      (component from 1)
      (component thru 10)
     )
     (views
      (icon
       (origin 490 598)
       (extent 110 25)
      )
      (detail
       (origin 501 828)
       (extent 359 124)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 5 "AllocateArray"
     (name "Alloc Real")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Dim Size 1")
       (tag "Dim Size 1")
       (requires
        (datatype Int32)
        (shape "Scalar")
       )
       (lock constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (name "Array")
       (tag "Array")
       (lock constraints)
      )
      (buffers in
       (buffer "Dim Size 1")
      )
     )
     (implementation
      (component numDims 1)
      (component dimSizes "0")
      (component type "Real")
      (component initEnum "Init Value")
      (component initialValue
       (name "Init Value")
       (datum 0)
      )
      (component from 1)
      (component thru 10)
     )
     (views
      (icon
       (origin 490 748)
       (extent 110 25)
      )
      (detail
       (origin 501 828)
       (extent 359 124)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 6 "Formula"
     (name " - ")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "X")
       (lock name constraints)
      )
      (input 2
       (type data)
       (name "Y")
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked yes)
      (component expr 1 "X-Y")
     )
     (views
      (icon
       (origin 352 748)
       (extent 46 25)
      )
      (detail
       (origin 403 626)
       (extent 65 108)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 7 "Formula"
     (name " - ")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "X")
       (lock name constraints)
      )
      (input 2
       (type data)
       (name "Y")
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked yes)
      (component expr 1 "X-Y")
     )
     (views
      (icon
       (origin 352 597)
       (extent 47 27)
      )
      (detail
       (origin 403 626)
       (extent 65 108)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 8 "Formula"
     (name " - ")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "X")
       (lock name constraints)
      )
      (input 2
       (type data)
       (name "Y")
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked yes)
      (component expr 1 "X-Y")
     )
     (views
      (icon
       (origin 352 468)
       (extent 46 25)
      )
      (detail
       (origin 403 626)
       (extent 65 108)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 9 "Junction"
     (name "JCT")
     (interface
      (input 1
       (type data)
       (name "A")
       (lock name constraints)
       (optional yes)
      )
      (input 2
       (type data)
       (name "B")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (name "Data")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 702 408)
       (extent 46 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 10 "Junction"
     (name "JCT")
     (interface
      (input 1
       (type data)
       (name "A")
       (lock name constraints)
       (optional yes)
      )
      (input 2
       (type data)
       (name "B")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (name "Data")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 682 528)
       (extent 46 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 11 "Junction"
     (name "JCT")
     (interface
      (input 1
       (type data)
       (name "A")
       (lock name constraints)
       (optional yes)
      )
      (input 2
       (type data)
       (name "B")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (name "Data")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 692 678)
       (extent 46 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 12 "IfThenElse"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "A==0")
     )
     (views
      (icon
       (origin 416 388)
       (extent 78 25)
      )
      (detail
       (origin 413 426)
       (extent 64 68)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 13 "Gate"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (tag "InData")
      )
      (output 1
       (type data)
       (name "X")
       (tag "OutData")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 422 468)
       (extent 46 25)
      )
      (detail
       (origin 650 131)
       (extent 60 58)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 14 "Gate"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (tag "InData")
      )
      (output 1
       (type data)
       (name "X")
       (tag "OutData")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 432 598)
       (extent 46 25)
      )
      (detail
       (origin 650 131)
       (extent 60 58)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 15 "Gate"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (tag "InData")
      )
      (output 1
       (type data)
       (name "X")
       (tag "OutData")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 432 748)
       (extent 46 25)
      )
      (detail
       (origin 650 131)
       (extent 60 58)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 16 "Gate"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (tag "InData")
      )
      (output 1
       (type data)
       (name "X")
       (tag "OutData")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 602 398)
       (extent 46 25)
      )
      (detail
       (origin 650 131)
       (extent 60 58)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 17 "IfThenElse"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "A==0")
     )
     (views
      (icon
       (origin 406 678)
       (extent 78 25)
      )
      (detail
       (origin 413 426)
       (extent 64 68)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 18 "Gate"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (tag "InData")
      )
      (output 1
       (type data)
       (name "X")
       (tag "OutData")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 592 668)
       (extent 46 25)
      )
      (detail
       (origin 650 131)
       (extent 60 58)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 19 "IfThenElse"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "A==0")
     )
     (views
      (icon
       (origin 421 528)
       (extent 78 25)
      )
      (detail
       (origin 423 506)
       (extent 64 68)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 20 "Gate"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (tag "InData")
      )
      (output 1
       (type data)
       (name "X")
       (tag "OutData")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 547 538)
       (extent 46 25)
      )
      (detail
       (origin 545 521)
       (extent 60 58)
      )
      (terminals on)
      (active icon)
     )
    )
    (configuration
     (connect I6:1 D0:1)
     (connect D5:1 D0:2)
     (connect I4:1 D1:1)
     (connect D4:1 D1:2)
     (connect I2:1 D2:1)
     (connect D3:1 D2:2)
     (connect D13:1 D3:1)
     (connect D14:1 D4:1)
     (connect D15:1 D5:1)
     (connect I1:1 D6:1)
     (connect I7:1 D6:2)
     (connect I1:1 D7:1)
     (connect I5:1 D7:2)
     (connect I1:1 D8:1)
     (connect I3:1 D8:2)
     (connect D16:1 D9:1)
     (connect D2:1 D9:2)
     (connect D20:1 D10:1)
     (connect D1:1 D10:2)
     (connect D18:1 D11:1)
     (connect D0:1 D11:2)
     (connect D8:1 D12:1)
     (connect D12:2 D13:0)
     (connect D8:1 D13:1)
     (connect D19:2 D14:0)
     (connect D7:1 D14:1)
     (connect D17:2 D15:0)
     (connect D6:1 D15:1)
     (connect D12:1 D16:0)
     (connect I2:1 D16:1)
     (connect D6:1 D17:1)
     (connect D17:1 D18:0)
     (connect I6:1 D18:1)
     (connect D7:1 D19:1)
     (connect D19:1 D20:0)
     (connect I4:1 D20:1)
     (connect D9:1 O1:1)
     (connect D10:1 O2:1)
     (connect D11:1 O3:1)
    )
   )
   (views
    (icon
     (origin 457 543)
     (extent 127 74)
    )
    (detail
     (origin 285 339)
     (extent 480 462)
     (configuration
      (connect I6:1 D0:1
       (Point 287 700)
       (Point 295 700)
       (Point 295 660)
       (Point 515 660)
       (Point 515 710)
       (Point 613 710)
       (Point 613 740)
      )
      (connect D5:1 D0:2
       (Point 602 760)
       (Point 613 760)
      )
      (connect I4:1 D1:1
       (Point 287 580)
       (Point 305 580)
       (Point 305 510)
       (Point 525 510)
       (Point 525 580)
       (Point 595 580)
       (Point 595 590)
       (Point 613 590)
      )
      (connect D4:1 D1:2
       (Point 602 610)
       (Point 613 610)
      )
      (connect I2:1 D2:1
       (Point 287 460)
       (Point 305 460)
       (Point 305 370)
       (Point 525 370)
       (Point 525 410)
       (Point 585 410)
       (Point 585 460)
       (Point 603 460)
      )
      (connect D3:1 D2:2
       (Point 592 480)
       (Point 603 480)
      )
      (connect D13:1 D3:1
       (Point 470 480)
       (Point 477 480)
      )
      (connect D14:1 D4:1
       (Point 480 610)
       (Point 487 610)
      )
      (connect D15:1 D5:1
       (Point 480 760)
       (Point 487 760)
      )
      (connect I1:1 D6:1
       (Point 287 400)
       (Point 295 400)
       (Point 295 470)
       (Point 335 470)
       (Point 335 750)
       (Point 349 750)
      )
      (connect I7:1 D6:2
       (Point 287 760)
       (Point 295 760)
       (Point 295 770)
       (Point 349 770)
      )
      (connect I1:1 D7:1
       (Point 287 400)
       (Point 295 400)
       (Point 295 470)
       (Point 335 470)
       (Point 335 600)
       (Point 349 600)
      )
      (connect I5:1 D7:2
       (Point 287 640)
       (Point 295 640)
       (Point 295 620)
       (Point 349 620)
      )
      (connect I1:1 D8:1
       (Point 287 400)
       (Point 295 400)
       (Point 295 470)
       (Point 349 470)
      )
      (connect I3:1 D8:2
       (Point 287 520)
       (Point 295 520)
       (Point 295 490)
       (Point 349 490)
      )
      (connect D16:1 D9:1
       (Point 650 410)
       (Point 699 410)
      )
      (connect D2:1 D9:2
       (Point 726 470)
       (Point 745 470)
       (Point 745 450)
       (Point 699 450)
       (Point 699 430)
      )
      (connect D20:1 D10:1
       (Point 595 550)
       (Point 605 550)
       (Point 605 530)
       (Point 679 530)
      )
      (connect D1:1 D10:2
       (Point 736 600)
       (Point 745 600)
       (Point 745 570)
       (Point 665 570)
       (Point 665 550)
       (Point 679 550)
      )
      (connect D18:1 D11:1
       (Point 640 680)
       (Point 689 680)
      )
      (connect D0:1 D11:2
       (Point 736 750)
       (Point 745 750)
       (Point 745 720)
       (Point 675 720)
       (Point 675 700)
       (Point 689 700)
      )
      (connect D8:1 D12:1
       (Point 400 480)
       (Point 400 450)
       (Point 395 450)
       (Point 395 400)
       (Point 413 400)
      )
      (connect D12:2 D13:0
       (Point 496 410)
       (Point 515 410)
       (Point 515 430)
       (Point 445 430)
       (Point 445 465)
      )
      (connect D8:1 D13:1
       (Point 400 480)
       (Point 419 480)
      )
      (connect D19:2 D14:0
       (Point 501 550)
       (Point 515 550)
       (Point 515 570)
       (Point 455 570)
       (Point 455 595)
      )
      (connect D7:1 D14:1
       (Point 401 610)
       (Point 429 610)
      )
      (connect D17:2 D15:0
       (Point 486 700)
       (Point 505 700)
       (Point 505 720)
       (Point 455 720)
       (Point 455 745)
      )
      (connect D6:1 D15:1
       (Point 400 760)
       (Point 429 760)
      )
      (connect D12:1 D16:0
       (Point 496 390)
       (Point 515 390)
       (Point 515 380)
       (Point 625 380)
       (Point 625 395)
      )
      (connect I2:1 D16:1
       (Point 287 460)
       (Point 305 460)
       (Point 305 370)
       (Point 525 370)
       (Point 525 410)
       (Point 599 410)
      )
      (connect D6:1 D17:1
       (Point 400 760)
       (Point 415 760)
       (Point 415 730)
       (Point 385 730)
       (Point 385 690)
       (Point 403 690)
      )
      (connect D17:1 D18:0
       (Point 486 680)
       (Point 505 680)
       (Point 505 650)
       (Point 615 650)
       (Point 615 665)
      )
      (connect I6:1 D18:1
       (Point 287 700)
       (Point 295 700)
       (Point 295 660)
       (Point 515 660)
       (Point 515 680)
       (Point 589 680)
      )
      (connect D7:1 D19:1
       (Point 401 610)
       (Point 415 610)
       (Point 415 580)
       (Point 395 580)
       (Point 395 540)
       (Point 418 540)
      )
      (connect D19:1 D20:0
       (Point 501 530)
       (Point 515 530)
       (Point 515 520)
       (Point 570 520)
       (Point 570 535)
      )
      (connect I4:1 D20:1
       (Point 287 580)
       (Point 305 580)
       (Point 305 510)
       (Point 525 510)
       (Point 525 550)
       (Point 544 550)
      )
      (connect D9:1 O1:1
       (Point 750 420)
       (Point 762 420)
      )
      (connect D10:1 O2:1
       (Point 730 540)
       (Point 755 540)
       (Point 755 580)
       (Point 762 580)
      )
      (connect D11:1 O3:1
       (Point 740 690)
       (Point 755 690)
       (Point 755 740)
       (Point 762 740)
      )
     )
    )
    (terminals on)
    (active icon)
   )
  )
  (component 2 "Constant"
   (name "R & D")
   (description 6 4
    This is a "Data, Constant, Real" object, with the
    "Config... Array Elements" set to 12.  Increasing
    this value would allow entry of a larger number
    of cash flows.  This object is for input of 
    Net Quarterly R&D Expenses
    .
   )
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "R & D")
     (numDims 1)
     (size 12)
     (data
      [ 0 2000 3500 7000 10000 14000 19000 20000 20000 15000 8000 4000 ]
     )
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
   )
   (views
    (icon
     (extent 78 0)
    )
    (detail
     (origin 22 256)
     (extent 197 168)
    )
    (active detail)
   )
  )
  (component 3 "Constant"
   (name "Periods/Year")
   (description 3 4
    This is a "Data, Constant, Real" object, used
    for data input, in this case for the desired
    "Discount Rate".
   )
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Periods/Year")
     (datum 4)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0.1)
    )
   )
   (views
    (icon
     (origin 281 548)
     (extent 118 25)
    )
    (detail
     (origin 244 419)
     (extent 192 23)
    )
    (active detail)
   )
  )
  (component 4 "Constant"
   (name "Discount Rate, %")
   (description 3 4
    This is a "Data, Constant, Real" object, used
    for data input, in this case for the desired
    "Discount Rate".
   )
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Discount Rate, %")
     (datum 18)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0.1)
    )
   )
   (views
    (icon
     (origin 281 548)
     (extent 154 25)
    )
    (detail
     (origin 22 476)
     (extent 196 28)
    )
    (active detail)
   )
  )
  (component 5 "Constant"
   (name "Mktg & Mfg")
   (description 5 4
    This is a "Data, Constant, Real" object, with the
    "Config... Array Elements" set to 12.  Increasing
    this value would allow entry of a larger number
    of cash flows.  This object is for input of Net
    Quarterly Marketing & Manufacturing Expenses.
   )
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Mktg & Mfg")
     (numDims 1)
     (size 22)
     (data
      [ 0 0 0 0 1000 2000 3000 5000 8000 10000 12000 12000 12000 10000 9000 8000 5000 3000 3000 3000 2000 2000 ]
     )
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
   )
   (views
    (icon
     (extent 110 0)
    )
    (detail
     (origin 24 586)
     (extent 192 168)
    )
    (active detail)
   )
  )
  (component 6 "Constant"
   (name "Units Shipped")
   (description 6 4
    This is a "Data, Constant, Real" object, with the
    "Config... Array Elements" set to 12.  Increasing
    this value would allow entry of a larger number
    of cash flows.  This object is for input of 
    Net Income per Quarter Year.
    
   )
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Units Shipped")
     (numDims 1)
     (size 36)
     (data
      [ 0 0 0 0 0 0 0 0 0 0 15 25 50 80 130 180 230 280 320 360 400 400 375 350 325 300 275 225 160 120 90 70 50 40 30 20 ]
     )
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
   )
   (views
    (icon
     (origin 61 488)
     (extent 127 25)
    )
    (detail
     (origin 10 802)
     (extent 201 176)
    )
    (active detail)
   )
  )
  (component 7 "Formula"
   (name "M&M Cost-Tax")
   (description 9 4
    This is a "Math, Formula" object.
    
    A number of input elements acting as "named 
    variables" may be used by the mathematical 
    formula entered into this object to produce the
    output result.
    
    This object gives 1-TaxRate for Marketing and 
    Manufacturing Cash Flows
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "MMcost")
     (optional yes)
    )
    (input 2
     (type data)
     (name "MTR")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "(1-MTR/100)*MMcost")
   )
   (views
    (icon
     (origin 271 603)
     (extent 118 34)
    )
    (detail
     (origin 71 286)
     (extent 178 129)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 8 "Formula"
   (name "sum(x)")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "X")
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked yes)
    (component expr 1 "sum(x)")
   )
   (views
    (icon
     (origin 291 658)
     (extent 78 25)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 9 "Constant"
   (name " Tax Rate, %")
   (description 3 4
    This is a "Data, Constant, Real" object, used
    for data input, in this case for the desired
    "Discount Rate".
   )
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name " Tax Rate, %")
     (datum 35)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0.1)
    )
   )
   (views
    (icon
     (origin 348 848)
     (extent 118 25)
    )
    (detail
     (origin 244 746)
     (extent 192 29)
    )
    (active detail)
   )
  )
  (component 10 "Formula"
   (name "Income-Tax")
   (description 9 4
    This is a "Math, Formula" object.
    
    A number of input elements acting as "named 
    variables" may be used by the mathematical 
    formula entered into this object to produce the
    output result.
    
    This object gives 1-TaxRate for Marketing and 
    Manufacturing Cash Flows
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "MTR")
     (optional yes)
    )
    (input 2
     (type data)
     (name "Nsold")
     (optional yes)
    )
    (input 3
     (type data)
     (name "Inc")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "((1-MTR/100)*Inc)*Nsold")
   )
   (views
    (icon
     (origin 335 813)
     (extent 110 34)
    )
    (detail
     (origin 65 473)
     (extent 241 154)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 11 "Constant"
   (name "Income/Unit")
   (description 3 4
    This is a "Data, Constant, Real" object, used
    for data input, in this case for the desired
    "Discount Rate".
   )
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Income/Unit")
     (datum 153)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0.1)
    )
   )
   (views
    (icon
     (origin 348 848)
     (extent 110 25)
    )
    (detail
     (origin 246 918)
     (extent 209 24)
    )
    (active detail)
   )
  )
  (component 12 "Formula"
   (name "sum(x)")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "X")
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked yes)
    (component expr 1 "sum(x)")
   )
   (views
    (icon
     (origin 381 948)
     (extent 78 25)
    )
    (detail
     (origin 224 171)
     (extent 83 58)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 13 "TextDisplay"
   (name "Shipments Sum")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 127 0)
    )
    (detail
     (origin 540 925)
     (extent 201 31)
    )
    (active detail)
   )
  )
  (component 14 "LiteralConstant"
   (name "Text")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Text")
     (lock name constraints)
    )
   )
   (implementation
    (component value Text
     (name "Text")
     (datum "None !")
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Text
     (datum "")
    )
   )
   (views
    (icon
     (origin 567 838)
     (extent 46 25)
    )
    (detail
     (origin 222 576)
     (extent 136 29)
    )
    (active icon)
   )
  )
  (component 15 "TextDisplay"
   (name " M&M Exp. Sum")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 127 0)
    )
    (detail
     (origin 490 707)
     (extent 201 26)
    )
    (active detail)
   )
  )
  (component 16 "Formula"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "NPV")
     (optional yes)
    )
    (input 2
     (type data)
     (name "I")
     (optional yes)
    )
    (input 3
     (type data)
     (name "Cmax")
     (optional yes)
    )
    (input 4
     (type data)
     (name "Txt")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "(I>=Cmax AND NPV<0 ? Txt : I)")
   )
   (views
    (icon
     (origin 660 818)
     (extent 81 45)
    )
    (detail
     (origin 303 478)
     (extent 295 204)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 17 "TextDisplay"
   (name "Dis.Pb.Period")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 127 0)
    )
    (detail
     (origin 770 823)
     (extent 201 35)
    )
    (active detail)
   )
  )
  (component 18 "Formula"
   (name "now()")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked yes)
    (component expr 1 "now()")
   )
   (views
    (icon
     (origin 831 918)
     (extent 78 25)
    )
    (detail
     (origin 678 583)
     (extent 75 54)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 19 "TextDisplay"
   (name "Now")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 46 0)
    )
    (detail
     (origin 914 913)
     (extent 292 35)
     (formatter
      (realFormat timeStamp)
      (realSigDigits 4)
      (realRadixSpec 4)
      (timeStamp timeDate)
      (timeFormat HMS H12)
      (dateFormat DMY)
      (integerBase decimal)
     )
    )
    (active detail)
   )
  )
  (component 20 "Formula"
   (name "sum(x)")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "X")
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked yes)
    (component expr 1 "sum(x)")
   )
   (views
    (icon
     (origin 896 757)
     (extent 69 27)
    )
    (detail
     (origin 501 423)
     (extent 88 54)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 21 "TextDisplay"
   (name "Net Present Value")
   (description 1 4
    This is a "Display, AlphaNumeric" object.
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (origin 809 388)
     (extent 163 25)
    )
    (detail
     (origin 994 752)
     (extent 212 36)
     (formatter
      (realFormat fixed)
      (realSigDigits 16)
      (realRadixSpec 2)
      (integerBase decimal)
     )
    )
    (active detail)
   )
  )
  (component 22 "TextDisplay"
   (name "Individual PV")
   (description 5 4
    This is a "Display, AlphaNumeric" object.
    
    Note that this display device may be use to show
    either a single element, or the multiple elements
    of an array.
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (origin 727 558)
     (extent 127 25)
    )
    (detail
     (origin 991 507)
     (extent 219 206)
     (formatter
      (realFormat fixed)
      (realSigDigits 16)
      (realRadixSpec 2)
      (integerBase decimal)
     )
    )
    (active detail)
   )
  )
  (component 23 "Break"
   (interface
    (sequence in)
   )
   (implementation
   )
   (views
    (icon
     (origin 868 657)
     (extent 64 26)
    )
    (detail
     (origin 786 288)
     (extent 89 24)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 24 "Formula"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Pd")
     (optional yes)
    )
    (input 2
     (type data)
     (name "R")
     (optional yes)
    )
    (input 3
     (type data)
     (name "M")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "(R/Pd+M/Pd)")
   )
   (views
    (icon
     (origin 661 528)
     (extent 78 64)
     (iconImage "formula.icon")
    )
    (detail
     (origin 609 343)
     (extent 133 154)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 25 "Formula"
   (name " - ")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "X")
     (lock name constraints)
    )
    (input 2
     (type data)
     (name "Y")
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked yes)
    (component expr 1 "X-Y")
   )
   (views
    (icon
     (origin 857 538)
     (extent 46 25)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 26 "Formula"
   (name " / ")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "X")
     (lock name constraints)
    )
    (input 2
     (type data)
     (name "Y")
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked yes)
    (component expr 1 "X/Y")
   )
   (views
    (icon
     (origin 657 468)
     (extent 46 25)
    )
    (detail
     (origin 623 436)
     (extent 65 108)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 27 "Context"
   (name "Sumd Expens")
   (description 4 4
    This is a "Devices, UserObject" object.
    It contains the objects necessary to create a
    cumulative sum of array values.
    
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (input 2
     (type data)
     (name "Count")
     (requires
      (datatype Int32)
      (shape "Scalar")
     )
     (optional yes)
    )
    (output 1
     (type data)
     (name "X")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "Collector"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
       (tag "Data")
      )
      (input 2
       (type trigger)
       (name "XEQ")
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "Array")
       (tag "Array")
       (lock constraints)
      )
     )
     (implementation
      (component clearAtPrerun 1)
      (component clearAtActivate 1)
     )
     (views
      (icon
       (origin 760 378)
       (extent 110 25)
      )
      (detail
       (origin 408 266)
       (extent 25 108)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "ForCount"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Count")
       (tag "Count")
       (requires
        (datatype Int32)
        (shape "Scalar")
       )
       (lock constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
      (buffers in
       (buffer "Count")
      )
     )
     (implementation
      (component count 36)
     )
     (views
      (icon
       (origin 502 407)
       (extent 87 27)
      )
      (detail
       (origin 508 201)
       (extent 165 38)
      )
      (active icon)
     )
    )
    (component 2 "FromArray"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Ary")
       (tag "Ary")
      )
      (input 2
       (type data)
       (name "I")
       (optional yes)
      )
      (output 1
       (type data)
       (name "SubAry")
       (tag "Result")
       (lock constraints)
      )
      (output 2
       (type data)
       (name "Type")
       (tag "Type")
       (lock constraints)
      )
      (output 3
       (type data)
       (name "NumDims")
       (tag "NumDims")
       (lock constraints)
      )
      (output 4
       (type data)
       (name "DimSizes")
       (tag "DimSizes")
       (lock constraints)
      )
      (output 5
       (type data)
       (name "TotSize")
       (tag "TotSize")
       (lock constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "Ary[0:I]")
     )
     (views
      (icon
       (origin 582 288)
       (extent 127 64)
       (iconImage "unbuild.icon")
      )
      (detail
       (origin 148 131)
       (extent 145 158)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 3 "Formula"
     (name "sum(x)")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "X")
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked yes)
      (component expr 1 "sum(x)")
     )
     (views
      (icon
       (origin 736 288)
       (extent 78 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (configuration
     (connect D3:1 D0:1)
     (connect D1:0 D0:2)
     (connect I2:1 D1:1)
     (connect I1:1 D2:1)
     (connect D1:1 D2:2)
     (connect D2:1 D3:1)
     (connect D0:1 O1:1)
    )
   )
   (views
    (icon
     (origin 665 353)
     (extent 110 34)
    )
    (detail
     (origin 481 275)
     (extent 429 190)
     (configuration
      (connect D3:1 D0:1
       (Point 816 300)
       (Point 835 300)
       (Point 835 330)
       (Point 745 330)
       (Point 745 380)
       (Point 757 380)
      )
      (connect D1:0 D0:2
       (Point 545 436)
       (Point 545 450)
       (Point 615 450)
       (Point 615 400)
       (Point 757 400)
      )
      (connect I2:1 D1:1
       (Point 483 430)
       (Point 483 420)
       (Point 499 420)
      )
      (connect I1:1 D2:1
       (Point 483 330)
       (Point 495 330)
       (Point 495 300)
       (Point 579 300)
      )
      (connect D1:1 D2:2
       (Point 591 420)
       (Point 605 420)
       (Point 605 390)
       (Point 565 390)
       (Point 565 340)
       (Point 579 340)
      )
      (connect D2:1 D3:1
       (Point 711 300)
       (Point 733 300)
      )
      (connect D0:1 O1:1
       (Point 872 390)
       (Point 885 390)
       (Point 885 380)
       (Point 907 380)
      )
     )
    )
    (terminals on)
    (active icon)
   )
  )
  (component 28 "Context"
   (name "MaxArraySize")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Ary")
     (optional yes)
    )
    (input 2
     (type data)
     (name "Ary")
     (optional yes)
    )
    (input 3
     (type data)
     (name "Ary")
     (optional yes)
    )
    (output 1
     (type data)
     (name "MaxSiz")
     (lock constraints)
     (optional yes)
    )
    (output 2
     (type data)
     (name "RDsiz")
     (lock constraints)
     (optional yes)
    )
    (output 3
     (type data)
     (name "MMsiz")
     (lock constraints)
     (optional yes)
    )
    (output 4
     (type data)
     (name "IncSiz")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "FromArray"
     (name "Get Values")
     (description 6 6
      This is a "Data -> Access Array -> Get Values" 
      object.
      
      It is used in this example merely to obtain the
      number of values entered into the "CashFlows" 
      array.
     )
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Ary")
       (tag "Ary")
      )
      (output 1
       (type data)
       (name "SubAry")
       (tag "Result")
       (lock constraints)
      )
      (output 2
       (type data)
       (name "Type")
       (tag "Type")
       (lock constraints)
      )
      (output 3
       (type data)
       (name "NumDims")
       (tag "NumDims")
       (lock constraints)
      )
      (output 4
       (type data)
       (name "DimSizes")
       (tag "DimSizes")
       (lock constraints)
      )
      (output 5
       (type data)
       (name "TotSize")
       (tag "TotSize")
       (lock constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "Ary[0:*]")
     )
     (views
      (icon
       (origin 190 573)
       (extent 101 54)
       (iconImage "unbuild.icon")
      )
      (detail
       (origin 87 223)
       (extent 106 134)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "FromArray"
     (name "Get Values")
     (description 6 6
      This is a "Data -> Access Array -> Get Values" 
      object.
      
      It is used in this example merely to obtain the
      number of values entered into the "CashFlows" 
      array.
     )
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Ary")
       (tag "Ary")
      )
      (output 1
       (type data)
       (name "SubAry")
       (tag "Result")
       (lock constraints)
      )
      (output 2
       (type data)
       (name "Type")
       (tag "Type")
       (lock constraints)
      )
      (output 3
       (type data)
       (name "NumDims")
       (tag "NumDims")
       (lock constraints)
      )
      (output 4
       (type data)
       (name "DimSizes")
       (tag "DimSizes")
       (lock constraints)
      )
      (output 5
       (type data)
       (name "TotSize")
       (tag "TotSize")
       (lock constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "Ary[0:*]")
     )
     (views
      (icon
       (origin 190 503)
       (extent 101 54)
       (iconImage "unbuild.icon")
      )
      (detail
       (origin 287 413)
       (extent 106 134)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "FromArray"
     (name "Get Values")
     (description 6 6
      This is a "Data -> Access Array -> Get Values" 
      object.
      
      It is used in this example merely to obtain the
      number of values entered into the "CashFlows" 
      array.
     )
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Ary")
       (tag "Ary")
      )
      (output 1
       (type data)
       (name "SubAry")
       (tag "Result")
       (lock constraints)
      )
      (output 2
       (type data)
       (name "Type")
       (tag "Type")
       (lock constraints)
      )
      (output 3
       (type data)
       (name "NumDims")
       (tag "NumDims")
       (lock constraints)
      )
      (output 4
       (type data)
       (name "DimSizes")
       (tag "DimSizes")
       (lock constraints)
      )
      (output 5
       (type data)
       (name "TotSize")
       (tag "TotSize")
       (lock constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "Ary[0:*]")
     )
     (views
      (icon
       (origin 190 433)
       (extent 101 54)
       (iconImage "unbuild.icon")
      )
      (detail
       (origin 287 413)
       (extent 106 134)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 3 "Formula"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (input 2
       (type data)
       (name "B")
       (optional yes)
      )
      (input 3
       (type data)
       (name "C")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "((A>=B AND A>=C) ? A : ((B>A AND B>=C) ? B : C))")
     )
     (views
      (icon
       (origin 341 468)
       (extent 78 64)
       (iconImage "formula.icon")
      )
      (detail
       (origin 342 193)
       (extent 466 154)
      )
      (terminals on)
      (active icon)
     )
    )
    (configuration
     (connect I3:1 D0:1)
     (connect I2:1 D1:1)
     (connect I1:1 D2:1)
     (connect D2:5 D3:1)
     (connect D1:5 D3:2)
     (connect D0:5 D3:3)
     (connect D3:1 O1:1)
     (connect D2:5 O2:1)
     (connect D1:5 O3:1)
     (connect D0:5 O4:1)
    )
   )
   (views
    (icon
     (origin 271 548)
     (extent 118 45)
    )
    (detail
     (origin 143 414)
     (extent 324 253)
     (configuration
      (connect I3:1 D0:1
       (Point 145 640)
       (Point 187 600)
      )
      (connect I2:1 D1:1
       (Point 145 550)
       (Point 160 550)
       (Point 160 530)
       (Point 187 530)
      )
      (connect I1:1 D2:1
       (Point 145 460)
       (Point 187 460)
      )
      (connect D2:5 D3:1
       (Point 293 480)
       (Point 338 480)
      )
      (connect D1:5 D3:2
       (Point 293 550)
       (Point 310 550)
       (Point 310 500)
       (Point 338 500)
      )
      (connect D0:5 D3:3
       (Point 293 620)
       (Point 320 620)
       (Point 320 520)
       (Point 338 520)
      )
      (connect D3:1 O1:1
       (Point 421 500)
       (Point 440 500)
       (Point 440 460)
       (Point 464 460)
      )
      (connect D2:5 O2:1
       (Point 293 480)
       (Point 310 480)
       (Point 310 450)
       (Point 450 450)
       (Point 450 520)
       (Point 464 520)
      )
      (connect D1:5 O3:1
       (Point 293 550)
       (Point 310 550)
       (Point 310 580)
       (Point 464 580)
      )
      (connect D0:5 O4:1
       (Point 293 620)
       (Point 330 620)
       (Point 330 640)
       (Point 464 640)
      )
     )
    )
    (terminals on)
    (active icon)
   )
  )
  (component 29 "Context"
   (name "Period Discnt Fctr")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "TotPrd")
     (optional yes)
    )
    (input 2
     (type data)
     (name "DscntRt")
     (optional yes)
    )
    (input 3
     (type data)
     (name "PerInYr")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Lin Ary")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "Collector"
     (name "Collector")
     (description 4 6
      This is a "Data, Collector" object.
      
      The "Collector" builds a one dimensional array
      from individual data elements.
     )
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
       (tag "Data")
      )
      (input 2
       (type trigger)
       (name "XEQ")
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "Array")
       (tag "Array")
       (lock constraints)
      )
     )
     (implementation
      (component clearAtPrerun 1)
      (component clearAtActivate 1)
     )
     (views
      (icon
       (origin 425 528)
       (extent 110 25)
      )
      (detail
       (origin 494 388)
       (extent 33 104)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "ForCount"
     (name "For Cnt.")
     (description 6 6
      This is a "Flow, Repeat, For Count" object.
      
      This object is used for looping a defined number 
      of cycles.  However, as indicated in this case,
      the number of cycles may be obtained from the
      result of preceding calculations.
     )
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Count")
       (tag "Count")
       (requires
        (datatype Int32)
        (shape "Scalar")
       )
       (lock constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
      (buffers in
       (buffer "Count")
      )
     )
     (implementation
      (component count 36)
     )
     (views
      (icon
       (origin 316 425)
       (extent 88 31)
      )
      (detail
       (origin 386 347)
       (extent 89 47)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "Formula"
     (name "Disc. Factor")
     (description 6 6
      This is a "Math, Formula" object.
      
      A number of input elements acting as "named 
      variables" may be used by the mathematical 
      formula entered into this object to produce the
      output result.
     )
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "N")
       (optional yes)
      )
      (input 2
       (type data)
       (name "R")
       (optional yes)
      )
      (input 3
       (type data)
       (name "P")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "(1+R/P/100)^N")
     )
     (views
      (icon
       (origin 431 408)
       (extent 118 64)
       (iconImage "formula.icon")
      )
      (detail
       (origin 390 283)
       (extent 151 154)
      )
      (terminals on)
      (active icon)
     )
    )
    (configuration
     (connect D2:1 D0:1)
     (connect D1:0 D0:2)
     (connect I1:1 D1:1)
     (connect D1:1 D2:1)
     (connect I2:1 D2:2)
     (connect I3:1 D2:3)
     (connect D0:1 O1:1)
    )
   )
   (views
    (icon
     (origin 405 473)
     (extent 170 34)
    )
    (detail
     (origin 321 330)
     (extent 319 260)
     (configuration
      (connect D2:1 D0:1
       (Point 551 440)
       (Point 580 440)
       (Point 580 500)
       (Point 410 500)
       (Point 410 530)
       (Point 422 530)
      )
      (connect D1:0 D0:2
       (Point 360 458)
       (Point 360 550)
       (Point 422 550)
      )
      (connect I1:1 D1:1
       (Point 323 380)
       (Point 300 380)
       (Point 300 440)
       (Point 313 440)
      )
      (connect D1:1 D2:1
       (Point 406 440)
       (Point 420 440)
       (Point 420 420)
       (Point 428 420)
      )
      (connect I2:1 D2:2
       (Point 323 470)
       (Point 330 470)
       (Point 330 420)
       (Point 450 420)
       (Point 450 390)
       (Point 428 440)
      )
      (connect I3:1 D2:3
       (Point 323 560)
       (Point 340 560)
       (Point 340 440)
       (Point 440 440)
       (Point 440 410)
       (Point 428 460)
      )
      (connect D0:1 O1:1
       (Point 537 540)
       (Point 550 540)
       (Point 550 470)
       (Point 637 470)
      )
     )
    )
    (terminals on)
    (active icon)
   )
  )
  (component 30 "Note"
   (name "CF Header")
   (interface
   )
   (implementation
    (component text 2 5
     Cash Flows per Period:              Quantity/Period:
      Expenses for:     Expenses for:      for:
    )
   )
   (views
    (icon
     (origin 665 128)
     (extent 110 25)
    )
    (detail
     (origin 316 117)
     (extent 509 46)
     (editing disabled)
    )
    (active icon)
   )
  )
  (component 31 "Note"
   (name "DPP")
   (interface
   )
   (implementation
    (component text 2 5
      Discounted Payback
       Period:
    )
   )
   (views
    (icon
     (origin 977 818)
     (extent 46 25)
    )
    (detail
     (origin 699 628)
     (extent 183 45)
     (editing disabled)
    )
    (active icon)
   )
  )
  (component 32 "YPlot"
   (name "Cumulative Cash Flows")
   (description 1 4
    This is a "Display, XY Trace" object
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Expenses")
     (lock constraints)
    )
    (input 2
     (type data)
     (name "Income")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
    (component tracePin 1)
    (component tracePin 2)
    (component graphMode rectangular)
   )
   (views
    (icon
     (extent 199 0)
     (iconImage "display.icon")
    )
    (detail
     (origin 807 126)
     (extent 426 329)
     (displayMode scrollGraph)
     (graphType cartesian)
     (gridType grid)
     (scale 0
      (name "Dollars, $")
      (domainName "Cash Flow Periods")
      (pen 9)
      (show 1)
      (range 0 350000 3 linear)
     )
     (domain 0 35 3 linear)
     (trace 0 onScale 0
      (name "Expenses")
      (pen 4)
      (lineType 1)
      (pointType 0)
     )
     (trace 1 onScale 0
      (name "Income")
      (pen 7)
      (lineType 1)
      (pointType 0)
     )
    )
    (active detail)
   )
  )
  (component 33 "Context"
   (name "Sumd Expens")
   (description 4 4
    This is a "Device, UserObject" object.
    It contains the objects necessary to create a
    cumulative sum of array values.
    
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (input 2
     (type data)
     (name "Count")
     (requires
      (datatype Int32)
      (shape "Scalar")
     )
     (optional yes)
    )
    (output 1
     (type data)
     (name "X")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "Formula"
     (name "sum(x)")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "X")
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked yes)
      (component expr 1 "sum(x)")
     )
     (views
      (icon
       (origin 636 138)
       (extent 78 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "FromArray"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Ary")
       (tag "Ary")
      )
      (input 2
       (type data)
       (name "I")
       (optional yes)
      )
      (output 1
       (type data)
       (name "SubAry")
       (tag "Result")
       (lock constraints)
      )
      (output 2
       (type data)
       (name "Type")
       (tag "Type")
       (lock constraints)
      )
      (output 3
       (type data)
       (name "NumDims")
       (tag "NumDims")
       (lock constraints)
      )
      (output 4
       (type data)
       (name "DimSizes")
       (tag "DimSizes")
       (lock constraints)
      )
      (output 5
       (type data)
       (name "TotSize")
       (tag "TotSize")
       (lock constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "Ary[0:I]")
     )
     (views
      (icon
       (origin 482 138)
       (extent 127 64)
       (iconImage "unbuild.icon")
      )
      (detail
       (origin 217 161)
       (extent 106 158)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "ForCount"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Count")
       (tag "Count")
       (requires
        (datatype Int32)
        (shape "Scalar")
       )
       (lock constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
      (buffers in
       (buffer "Count")
      )
     )
     (implementation
      (component count 36)
     )
     (views
      (icon
       (origin 402 257)
       (extent 87 27)
      )
      (detail
       (origin 508 201)
       (extent 165 38)
      )
      (active icon)
     )
    )
    (component 3 "Collector"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
       (tag "Data")
      )
      (input 2
       (type trigger)
       (name "XEQ")
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "Array")
       (tag "Array")
       (lock constraints)
      )
     )
     (implementation
      (component clearAtPrerun 1)
      (component clearAtActivate 1)
     )
     (views
      (icon
       (origin 660 208)
       (extent 110 25)
      )
      (detail
       (origin 408 266)
       (extent 25 108)
      )
      (terminals on)
      (active icon)
     )
    )
    (configuration
     (connect D1:1 D0:1)
     (connect I1:1 D1:1)
     (connect D2:1 D1:2)
     (connect I2:1 D2:1)
     (connect D0:1 D3:1)
     (connect D2:0 D3:2)
     (connect D3:1 O1:1)
    )
   )
   (views
    (icon
     (origin 665 193)
     (extent 110 34)
    )
    (detail
     (origin 361 115)
     (extent 429 190)
     (configuration
      (connect D1:1 D0:1
       (Point 611 150)
       (Point 622 150)
       (Point 622 150)
       (Point 633 150)
      )
      (connect I1:1 D1:1
       (Point 363 170)
       (Point 395 170)
       (Point 395 150)
       (Point 479 150)
      )
      (connect D2:1 D1:2
       (Point 491 270)
       (Point 505 270)
       (Point 505 240)
       (Point 465 240)
       (Point 465 190)
       (Point 479 190)
      )
      (connect I2:1 D2:1
       (Point 363 270)
       (Point 363 270)
       (Point 399 270)
      )
      (connect D0:1 D3:1
       (Point 716 150)
       (Point 735 150)
       (Point 735 180)
       (Point 645 180)
       (Point 645 210)
       (Point 657 210)
      )
      (connect D2:0 D3:2
       (Point 445 286)
       (Point 445 300)
       (Point 515 300)
       (Point 515 230)
       (Point 657 230)
      )
      (connect D3:1 O1:1
       (Point 772 220)
       (Point 785 220)
       (Point 787 220)
       (Point 787 220)
      )
     )
    )
    (terminals on)
    (active icon)
   )
  )
  (component 34 "ForCount"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Count")
     (tag "Count")
     (requires
      (datatype Int32)
      (shape "Scalar")
     )
     (lock constraints)
     (optional yes)
    )
    (output 1
     (type data)
     (lock name constraints)
    )
    (buffers in
     (buffer "Count")
    )
   )
   (implementation
    (component count 36)
   )
   (views
    (icon
     (origin 625 618)
     (extent 110 25)
    )
    (detail
     (origin 368 371)
     (extent 165 38)
    )
    (active icon)
   )
  )
  (component 35 "IfThenElse"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (input 2
     (type data)
     (name "B")
     (optional yes)
    )
    (input 3
     (type data)
     (name "I")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Then")
     (lock name constraints)
    )
    (output 2
     (type data)
     (name "Else")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr "B[I]-A[I]>=0 AND I>0")
   )
   (views
    (icon
     (origin 771 613)
     (extent 78 34)
    )
    (detail
     (origin 688 653)
     (extent 215 135)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 36 "Note"
   (name "To Operate")
   (description 7 4
    This is a "Display, Note Pad" object.
    
    It is used here as a part of the main panel as a
    means of providing introductory information.
    Note that it may be shown only as an icon on the
    Detail workarea, while appearing in the Main Panel
    in an expanded state.
   )
   (interface
   )
   (implementation
    (component text 2 5
     Click "Run" or "Start" to find 
     results;  "Info" for details.
    )
   )
   (views
    (icon
     (origin 15 106)
     (extent 110 28)
    )
    (detail
     (origin 6 110)
     (extent 328 81)
     (editing disabled)
    )
    (active icon)
   )
  )
  (component 37 "Toggle"
   (name "Info")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type control)
     (name "Reset")
     (lock name constraints)
     (optional yes)
    )
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Int32
     (name "Info")
     (values range 0 1)
     (datum 0)
    )
    (component autoTrigger on)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Int32
     (datum 0)
    )
   )
   (views
    (icon
     (origin 160 101)
     (extent 60 39)
     (format button)
    )
    (detail
     (origin 65 127)
     (extent 30 46)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 38 "IfThenElse"
   (name "!= 0")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Then")
     (lock name constraints)
    )
    (output 2
     (type data)
     (name "Else")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr "A!=0")
   )
   (views
    (icon
     (origin 237 108)
     (extent 46 25)
    )
    (detail
     (origin 239 208)
     (extent 73 64)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 39 "Context"
   (name "Overview of DPP Example")
   (description 6 4
    This is a "Device, UserObject" object, which is
    effectively a subprogram device, and in this 
    situation is on its own substring, and is being
    used in a "Panel" mode.  It contains only
    "Display, Note Pad" and "Flow, Confirm (OK)"
    objects.
   )
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "Confirm"
     (name "DONE")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Go")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 351 422)
       (extent 58 37)
      )
      (detail
       (origin 466 633)
       (extent 79 34)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "Note"
     (name "Note Pad")
     (description 1 6
      This is a "Display, Note Pad" object
     )
     (interface
     )
     (implementation
      (component text 46 7
       PURPOSE: Demonstrate financial capabilities of HP VEE, using a simple
       		 Net Present Value "Discounted Payback Period" model with some
       		 provision for effect of taxes.
       
       REQUIRED USER DATA: None, to run example
       
       EXPLANATION: You may change the values for "Periods/Year", "Discount Rate"
        (annual interest rate), "R&D Tax Rate", "General Tax Rate" and "Income/Unit",
        as well as entries for any individual period of "R & D", "Mktg & Mfg" or
        "Units Shipped", including the total number of periods (array elements) in any
        of these objects.  Click on any input field, such as "Discount Rate" and enter
        desired value.  Or, click on any "array" field, position cursor on period (or
        element) to change, and type in the value.  Then use the "Tab" key to enter the
        value and cycle down to the next line.  To add a line, simply press "Tab" key
        from the last line, or "Insert line" key from any location. To delete a line,
        position cursor on line and press "Delete line" key.  When all desired data has
        been entered, click "Start".
       
       NOTE: All cash flow inputs MUST start from same period (ie from array element
        0000: ).  Use a value of zero where no cash flow occurs.  Cash flows are
        assumed to occur at the BEGINNING of each period.  However, if there are no
        initial investment values (ie, values entered in 0000: lines), then the effect
        is the same as assuming END of period cash flows.  "Discounted Payback Period:"
        determines the point at which the sum of cumulative income is greater than the
        sum of cumulative expenses.  A positive NPV is needed for a DPP period to
        occur, and also shows achievement of the discount rate goal.
       
       To exit "Info", press "DONE" below.
       
       ADDITIONAL INFORMATION: Use slider bar at right to view remaining text.
       
       
        Please click "Detail" (left above menu bar) to view the model from another
        perspective.  One might thus observe the inherent advantages of using the
        "Panel" feature of HP VEE on display layout and organization of data. 
        "UserObjects" were used to simplify a fairly complex structure, by grouping
        associated objects into one object.  Also note that calculations are easily
        achieved using array math.
       
        The "Object Menu" for a expanded object may be accessed by clicking with the
        left mouse button on the bar in the upper left corner of object.  Or, with
        an iconized object, click on it with the right mouse button.  By bringing up
        the "Object Menu" for a device and selecting "Show Description", additional
        information will be shown for some objects.  You may also in this manner
        directly access the "Help" information for the object.
       
      )
     )
     (views
      (icon
       (origin 325 378)
       (extent 110 25)
      )
      (detail
       (origin 180 397)
       (extent 580 466)
       (editing disabled)
      )
      (active icon)
     )
    )
    (configuration
    )
    (ShowOnExecPanel
     (origin 124 53)
     (extent 784 657)
     (panel
      (origin 10 111)
      (extent 780 619)
      (widget 0 icon
       (title off)
       (origin 371 684)
       (extent 58 37)
      )
      (widget 1 detail
       (title off)
       (origin 23 125)
       (extent 756 548)
       (editing disabled)
      )
     )
    )
   )
   (views
    (icon
     (origin 280 158)
     (extent 40 24)
     (label off)
    )
    (detail
     (origin 178 345)
     (extent 424 170)
     (configuration
     )
    )
    (active icon)
   )
  )
  (component 40 "Start"
   (name "Start")
   (interface
    (sequence out)
   )
   (implementation
   )
   (views
    (icon
     (origin 86 171)
     (extent 69 39)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 41 "Constant"
   (name "R&D Tax Rate, %")
   (description 3 4
    This is a "Data, Constant, Real" object, used
    for data input, in this case for the desired
    "Discount Rate".
   )
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "R&D Tax Rate, %")
     (datum 30)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0.1)
    )
   )
   (views
    (icon
     (origin 348 928)
     (extent 145 25)
    )
    (detail
     (origin 247 336)
     (extent 206 29)
    )
    (active detail)
   )
  )
  (component 42 "Formula"
   (name "sum(x)")
   (description 4 4
    This is an "AdvMath, Array, sum(x)" object.
    
    It provides the sum of all elements of a one
    dimensional array.
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "X")
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked yes)
    (component expr 1 "sum(x)")
   )
   (views
    (icon
     (origin 286 267)
     (extent 68 26)
    )
    (detail
     (origin 311 203)
     (extent 88 54)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 43 "TextDisplay"
   (name "R&D Exp. Sum")
   (description 1 4
    This is a "Display, AlphaNumeric" object.
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 118 0)
    )
    (detail
     (origin 374 266)
     (extent 212 28)
    )
    (active detail)
   )
  )
  (component 44 "Formula"
   (name "R&D Cost-Tax")
   (description 9 4
    This is a "Math, Formula" object.
    
    A number of input elements acting as "named 
    variables" may be used by the mathematical 
    formula entered into this object to produce the
    output result.
    
    This object gives 1-TaxRate for Research and
    Development Cash Flows
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "RTR")
     (optional yes)
    )
    (input 2
     (type data)
     (name "RDcost")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "(1-(RTR/100))*RDcost")
   )
   (views
    (icon
     (origin 471 348)
     (extent 118 25)
    )
    (detail
     (origin 291 116)
     (extent 198 89)
    )
    (terminals on)
    (active icon)
   )
  )
  (configuration
   (connect D28:1 D1:1)
   (connect D44:1 D1:2)
   (connect D28:2 D1:3)
   (connect D7:1 D1:4)
   (connect D28:3 D1:5)
   (connect D10:1 D1:6)
   (connect D28:4 D1:7)
   (connect D40:0 D2:0)
   (connect D5:1 D7:1)
   (connect D9:1 D7:2)
   (connect D5:1 D8:1)
   (connect D9:1 D10:1)
   (connect D6:1 D10:2)
   (connect D11:1 D10:3)
   (connect D6:1 D12:1)
   (connect D12:1 D13:1)
   (connect D8:1 D15:1)
   (connect D34:0 D16:0)
   (connect D20:1 D16:1)
   (connect D34:1 D16:2)
   (connect D28:1 D16:3)
   (connect D14:1 D16:4)
   (connect D16:1 D17:1)
   (connect D11:1 D18:0)
   (connect D18:1 D19:1)
   (connect D25:1 D20:1)
   (connect D20:1 D21:1)
   (connect D25:1 D22:1)
   (connect D35:1 D23:0)
   (connect D29:1 D24:1)
   (connect D1:1 D24:2)
   (connect D1:2 D24:3)
   (connect D26:1 D25:1)
   (connect D24:1 D25:2)
   (connect D1:3 D26:1)
   (connect D29:1 D26:2)
   (connect D26:1 D27:1)
   (connect D28:1 D27:2)
   (connect D2:1 D28:1)
   (connect D5:1 D28:2)
   (connect D6:1 D28:3)
   (connect D28:1 D29:1)
   (connect D4:1 D29:2)
   (connect D3:1 D29:3)
   (connect D33:1 D32:1)
   (connect D27:1 D32:2)
   (connect D24:1 D33:1)
   (connect D28:1 D33:2)
   (connect D32:0 D34:0)
   (connect D28:1 D34:1)
   (connect D33:1 D35:1)
   (connect D27:1 D35:2)
   (connect D34:1 D35:3)
   (connect D38:0 D37:1)
   (connect D37:1 D38:1)
   (connect D38:1 D39:0)
   (connect D2:1 D42:1)
   (connect D42:1 D43:1)
   (connect D41:1 D44:1)
   (connect D2:1 D44:2)
  )
 )
 (views
  (panel
   (origin 0 67)
   (extent 933 648)
   (widget 40 icon
    (title off)
    (origin 104 92)
    (extent 69 39)
   )
   (widget 37 icon
    (title off)
    (origin 19 91)
    (extent 69 39)
    (format button)
   )
   (widget 2 detail
    (title on)
    (origin 6 431)
    (extent 158 206)
   )
   (widget 43 detail
    (title on)
    (origin 5 675)
    (extent 157 32)
   )
   (widget 15 detail
    (title on)
    (origin 169 677)
    (extent 163 30)
   )
   (widget 5 detail
    (title on)
    (origin 171 432)
    (extent 162 207)
   )
   (widget 41 detail
    (title on)
    (origin 5 324)
    (extent 177 25)
   )
   (widget 9 detail
    (title on)
    (origin 187 324)
    (extent 150 28)
   )
   (widget 11 detail
    (title on)
    (origin 341 324)
    (extent 156 26)
   )
   (widget 19 detail
    (title off)
    (origin 501 469)
    (extent 208 33)
    (formatter
     (realFormat timeStamp)
     (realSigDigits 4)
     (realRadixSpec 4)
     (timeStamp timeDate)
     (timeFormat HM H24)
     (dateFormat DMY)
     (integerBase decimal)
    )
   )
   (widget 30 detail
    (title off)
    (origin 6 356)
    (extent 490 36)
    (editing disabled)
   )
   (widget 31 detail
    (title on)
    (origin 501 542)
    (extent 205 44)
    (editing disabled)
   )
   (widget 17 detail
    (title off)
    (origin 502 592)
    (extent 204 40)
   )
   (widget 3 detail
    (title on)
    (origin 5 190)
    (extent 181 24)
   )
   (widget 4 detail
    (title on)
    (origin 5 257)
    (extent 179 23)
   )
   (widget 6 detail
    (title on)
    (origin 338 431)
    (extent 158 209)
   )
   (widget 13 detail
    (title on)
    (origin 338 678)
    (extent 158 29)
   )
   (widget 21 detail
    (title on)
    (origin 502 671)
    (extent 204 36)
    (formatter
     (realFormat fixed)
     (realSigDigits 16)
     (realRadixSpec 2)
     (integerBase decimal)
    )
   )
   (widget 0 detail
    (title on)
    (origin 189 188)
    (extent 307 99)
    (editing disabled)
   )
   (widget 36 detail
    (title on)
    (origin 190 106)
    (extent 305 46)
    (editing enabled)
   )
   (widget 22 detail
    (title on)
    (origin 712 504)
    (extent 217 203)
    (formatter
     (realFormat fixed)
     (realSigDigits 16)
     (realRadixSpec 2)
     (integerBase decimal)
    )
   )
   (widget 32 detail
    (title on)
    (origin 502 106)
    (extent 427 357)
    (displayMode annotGraph)
    (graphType cartesian)
    (gridType grid)
    (scale 0
     (name "Dollar$")
     (domainName "Cash Flow Periods")
     (pen 9)
     (show 1)
     (range 0 200000 3 linear)
    )
    (domain 0 35 3 linear)
    (trace 0 onScale 0
     (name "Expenses")
     (pen 4)
     (lineType 1)
     (pointType 0)
    )
    (trace 1 onScale 0
     (name "Income")
     (pen 7)
     (lineType 1)
     (pointType 0)
    )
    (marker 0 onTrace 1)
    (marker 1 onTrace 0)
   )
  )
  (detail
   (origin 0 67)
   (extent 976 638)
   (configuration
    (connect D28:1 D1:1
     (Point 391 550)
     (Point 454 550)
    )
    (connect D44:1 D1:2
     (Point 591 360)
     (Point 600 360)
     (Point 600 390)
     (Point 460 390)
     (Point 460 520)
     (Point 440 520)
     (Point 440 560)
     (Point 454 560)
    )
    (connect D28:2 D1:3
     (Point 391 560)
     (Point 410 560)
     (Point 410 570)
     (Point 454 570)
    )
    (connect D7:1 D1:4
     (Point 391 620)
     (Point 420 620)
     (Point 420 580)
     (Point 454 580)
    )
    (connect D28:3 D1:5
     (Point 391 570)
     (Point 400 570)
     (Point 400 580)
     (Point 410 580)
     (Point 410 590)
     (Point 454 590)
    )
    (connect D10:1 D1:6
     (Point 447 830)
     (Point 460 830)
     (Point 460 680)
     (Point 440 680)
     (Point 440 600)
     (Point 454 600)
    )
    (connect D28:4 D1:7
     (Point 391 580)
     (Point 400 580)
     (Point 400 600)
     (Point 410 600)
     (Point 410 610)
     (Point 454 610)
    )
    (connect D40:0 D2:0
     (Point 120 212)
     (Point 120 223)
    )
    (connect D5:1 D7:1
     (Point 218 670)
     (Point 240 670)
     (Point 240 610)
     (Point 268 610)
    )
    (connect D9:1 D7:2
     (Point 438 760)
     (Point 450 760)
     (Point 450 690)
     (Point 390 690)
     (Point 390 650)
     (Point 260 650)
     (Point 260 630)
     (Point 268 630)
    )
    (connect D5:1 D8:1
     (Point 218 670)
     (Point 288 670)
    )
    (connect D9:1 D10:1
     (Point 438 760)
     (Point 450 760)
     (Point 450 790)
     (Point 320 790)
     (Point 320 820)
     (Point 332 820)
    )
    (connect D6:1 D10:2
     (Point 213 890)
     (Point 220 890)
     (Point 220 830)
     (Point 332 830)
    )
    (connect D11:1 D10:3
     (Point 457 930)
     (Point 470 930)
     (Point 470 880)
     (Point 320 880)
     (Point 320 840)
     (Point 332 840)
    )
    (connect D6:1 D12:1
     (Point 213 890)
     (Point 230 890)
     (Point 230 960)
     (Point 378 960)
    )
    (connect D12:1 D13:1
     (Point 461 960)
     (Point 470 960)
     (Point 470 940)
     (Point 537 940)
    )
    (connect D8:1 D15:1
     (Point 371 670)
     (Point 470 670)
     (Point 470 720)
     (Point 487 720)
    )
    (connect D34:0 D16:0
     (Point 680 645)
     (Point 680 660)
     (Point 700 660)
     (Point 700 815)
    )
    (connect D20:1 D16:1
     (Point 967 770)
     (Point 657 820)
    )
    (connect D34:1 D16:2
     (Point 737 630)
     (Point 657 830)
    )
    (connect D28:1 D16:3
     (Point 391 550)
     (Point 410 550)
     (Point 410 540)
     (Point 460 540)
     (Point 460 650)
     (Point 480 650)
     (Point 480 750)
     (Point 620 750)
     (Point 620 840)
     (Point 657 840)
    )
    (connect D14:1 D16:4
     (Point 615 850)
     (Point 657 850)
    )
    (connect D16:1 D17:1
     (Point 743 840)
     (Point 767 840)
    )
    (connect D11:1 D18:0
     (Point 457 930)
     (Point 470 930)
     (Point 470 880)
     (Point 870 880)
     (Point 870 915)
    )
    (connect D18:1 D19:1
     (Point 911 930)
     (Point 920 930)
     (Point 920 920)
     (Point 900 920)
     (Point 900 930)
     (Point 911 930)
    )
    (connect D25:1 D20:1
     (Point 905 550)
     (Point 920 550)
     (Point 920 610)
     (Point 950 610)
     (Point 950 700)
     (Point 880 700)
     (Point 880 770)
     (Point 893 770)
    )
    (connect D20:1 D21:1
     (Point 967 770)
     (Point 991 770)
    )
    (connect D25:1 D22:1
     (Point 905 550)
     (Point 920 550)
     (Point 920 610)
     (Point 988 610)
    )
    (connect D35:1 D23:0
     (Point 851 620)
     (Point 900 620)
     (Point 900 654)
    )
    (connect D29:1 D24:1
     (Point 577 490)
     (Point 630 490)
     (Point 630 540)
     (Point 658 540)
    )
    (connect D1:1 D24:2
     (Point 586 560)
     (Point 658 560)
    )
    (connect D1:2 D24:3
     (Point 586 580)
     (Point 658 580)
    )
    (connect D26:1 D25:1
     (Point 705 480)
     (Point 760 480)
     (Point 760 540)
     (Point 854 540)
    )
    (connect D24:1 D25:2
     (Point 741 560)
     (Point 854 560)
    )
    (connect D1:3 D26:1
     (Point 586 600)
     (Point 600 600)
     (Point 600 470)
     (Point 654 470)
    )
    (connect D29:1 D26:2
     (Point 577 490)
     (Point 654 490)
    )
    (connect D26:1 D27:1
     (Point 705 480)
     (Point 720 480)
     (Point 720 450)
     (Point 650 450)
     (Point 650 360)
     (Point 662 360)
    )
    (connect D28:1 D27:2
     (Point 391 550)
     (Point 410 550)
     (Point 410 540)
     (Point 460 540)
     (Point 460 530)
     (Point 470 530)
     (Point 470 450)
     (Point 610 450)
     (Point 610 380)
     (Point 662 380)
    )
    (connect D2:1 D28:1
     (Point 221 340)
     (Point 230 340)
     (Point 230 450)
     (Point 240 450)
     (Point 240 560)
     (Point 268 560)
    )
    (connect D5:1 D28:2
     (Point 218 670)
     (Point 240 670)
     (Point 240 570)
     (Point 268 570)
    )
    (connect D6:1 D28:3
     (Point 213 890)
     (Point 220 890)
     (Point 220 830)
     (Point 230 830)
     (Point 230 690)
     (Point 250 690)
     (Point 250 580)
     (Point 268 580)
    )
    (connect D28:1 D29:1
     (Point 391 550)
     (Point 410 550)
     (Point 410 530)
     (Point 390 530)
     (Point 390 480)
     (Point 402 480)
    )
    (connect D4:1 D29:2
     (Point 220 490)
     (Point 402 490)
    )
    (connect D3:1 D29:3
     (Point 438 430)
     (Point 450 430)
     (Point 450 460)
     (Point 380 460)
     (Point 380 500)
     (Point 402 500)
    )
    (connect D33:1 D32:1
     (Point 777 210)
     (Point 804 210)
    )
    (connect D27:1 D32:2
     (Point 777 370)
     (Point 804 370)
    )
    (connect D24:1 D33:1
     (Point 741 560)
     (Point 750 560)
     (Point 750 510)
     (Point 660 510)
     (Point 660 460)
     (Point 640 460)
     (Point 640 350)
     (Point 650 350)
     (Point 650 200)
     (Point 662 200)
    )
    (connect D28:1 D33:2
     (Point 391 550)
     (Point 410 550)
     (Point 410 540)
     (Point 460 540)
     (Point 460 530)
     (Point 470 530)
     (Point 470 450)
     (Point 610 450)
     (Point 610 380)
     (Point 630 380)
     (Point 630 340)
     (Point 640 340)
     (Point 640 220)
     (Point 662 220)
    )
    (connect D32:0 D34:0
     (Point 1020 457)
     (Point 1020 470)
     (Point 960 470)
     (Point 960 600)
     (Point 680 600)
     (Point 680 615)
    )
    (connect D28:1 D34:1
     (Point 391 550)
     (Point 410 550)
     (Point 410 540)
     (Point 460 540)
     (Point 460 640)
     (Point 600 640)
     (Point 600 630)
     (Point 622 630)
    )
    (connect D33:1 D35:1
     (Point 777 210)
     (Point 790 210)
     (Point 790 220)
     (Point 780 220)
     (Point 780 360)
     (Point 770 360)
     (Point 770 570)
     (Point 750 570)
     (Point 750 620)
     (Point 768 620)
    )
    (connect D27:1 D35:2
     (Point 777 370)
     (Point 790 370)
     (Point 790 380)
     (Point 780 380)
     (Point 780 480)
     (Point 860 480)
     (Point 860 580)
     (Point 760 580)
     (Point 760 630)
     (Point 768 630)
    )
    (connect D34:1 D35:3
     (Point 737 630)
     (Point 750 630)
     (Point 750 640)
     (Point 768 640)
    )
    (connect D38:0 D37:1
     (Point 260 135)
     (Point 260 160)
     (Point 140 160)
     (Point 140 120)
     (Point 157 120)
    )
    (connect D37:1 D38:1
     (Point 222 120)
     (Point 234 120)
    )
    (connect D38:1 D39:0
     (Point 285 110)
     (Point 300 110)
     (Point 300 155)
    )
    (connect D2:1 D42:1
     (Point 221 340)
     (Point 230 340)
     (Point 230 280)
     (Point 283 280)
    )
    (connect D42:1 D43:1
     (Point 356 280)
     (Point 371 280)
    )
    (connect D41:1 D44:1
     (Point 455 350)
     (Point 468 350)
    )
    (connect D2:1 D44:2
     (Point 221 340)
     (Point 230 340)
     (Point 230 380)
     (Point 460 380)
     (Point 460 370)
     (Point 468 370)
    )
   )
  )
  (active panel)
  (active panel)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
