#! /usr/lib/veetest/veetest -r
(revision "A.00.01")
(date "Tue 17/Sep/1991")
(component 0 "Context"
 (name "HP VEE-Test: 3852A DAC Example")
 (interface
  (sequence in)
  (sequence out)
 )
 (implementation
  (trigMode rad)
  (locked no)
  (component 0 "LiteralConstant"
   (name "SPER")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Text")
     (lock name constraints)
    )
   )
   (implementation
    (component value Text
     (name "SPER")
     (datum "10e-6")
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Text
     (datum "")
    )
   )
   (views
    (icon
     (extent 46 0)
    )
    (detail
     (origin 48 164)
     (extent 224 33)
    )
    (active detail)
   )
  )
  (component 1 "Constant"
   (name "NRDGS")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Int32
     (name "NRDGS")
     (datum 2048)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Int32
     (datum 0)
    )
   )
   (views
    (icon
     (extent 78 0)
    )
    (detail
     (origin 51 242)
     (extent 219 37)
    )
    (active detail)
   )
  )
  (component 2 "IODevice"
   (name "Trigger 3852A")
   (description 1 4
    The 44702A/B is triggered here.
   )
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (comp iopath "HP 3852A")
    (procedure
      WRITE TEXT "SCTRIG SGL" EOL
    )
   )
   (views
    (icon
     (origin 317 408)
     (extent 127 64)
     (iconImage "inst.icon")
    )
    (detail
     (origin 229 352)
     (extent 303 57)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 3 "IODevice"
   (name "3852A Setup")
   (description 7 4
    The series of commands here configure the 44702A/B
    to take DC Voltage readings from the 3852A's 
    external terminal. The readings are transferred
    via GPIO to the controller. Two of the parameters
    are entered as variables, SPER and NRDGS. The SPER
    value of 10e-6 will cause readings to be taken at
    100kHz.
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Intrvl")
     (tag "Intrvl")
     (optional yes)
    )
    (input 2
     (type data)
     (name "Numrdgs")
     (tag "Numrdgs")
     (optional yes)
    )
   )
   (implementation
    (comp iopath "HP 3852A")
    (procedure
      WRITE TEXT "RESET" EOL
      WRITE TEXT "OUTBUF ON; INBUF ON; DISABLE LABELS;DISP OFF" EOL
      WRITE TEXT "USE 100" EOL
      WRITE TEXT "SCANMODE ON" EOL
      WRITE TEXT "SCTRIG HOLD" EOL
      WRITE TEXT "CONF DCV" EOL
      WRITE TEXT "TERM EXT" EOL
      WRITE TEXT "RANGE 9" EOL
      WRITE TEXT "RDGS GPIO" EOL
      WRITE TEXT "NRDGS ",Numrdgs EOL
      WRITE TEXT "SPER ",Intrvl EOL
      WRITE TEXT "SCDELAY 0" EOL
      WRITE TEXT "ASCAN ON" EOL
      WRITE TEXT "STTRIG HOLD" EOL
    )
   )
   (views
    (icon
     (origin 325 208)
     (extent 110 64)
     (iconImage "inst.icon")
    )
    (detail
     (origin 468 101)
     (extent 494 258)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 4 "IODevice"
   (name "GPIO Data Transfer Setup")
   (description 10 4
    The IOCONTROL transactions are equivalent to the
    CONTROL commands in HP BASIC. With the voltmeter
    in the 3852A, the 44702A/B, the GPIO control line,
    CTL0, is used with the Data Buffer register. The
    first transaction sets CTL1 high and CTL0 low 
    prepatory to accessing the 44702's Data Buffer. 
    Sending the 4 (binary 100) addresses the Data 
    Buffer register.The last transactions sets the 
    CTL lines back to their normal state.
    
   )
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (comp iopath "GPIO Transfer")
    (procedure
      WRITE IOCONTROL CTL 1
      WRITE BINARY 4 INT16
      WRITE IOCONTROL CTL 0
    )
   )
   (views
    (icon
     (origin 267 318)
     (extent 226 64)
     (iconImage "inst.icon")
    )
    (detail
     (origin 204 267)
     (extent 353 86)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 5 "Note"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 4 5
     This example is provided as an
     illustration "as is", and Hewlett-Packard
     Company makes no warranty of any kind
     with regard to this example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 552 179)
     (extent 397 82)
     (editing enabled)
    )
    (active detail)
   )
  )
  (component 6 "RepeatUntilBreak"
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Continuous")
     (lock name constraints)
    )
   )
   (implementation
   )
   (views
    (icon
     (origin 325 538)
     (extent 110 64)
     (iconImage "loop.icon")
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 7 "Context"
   (name "Press For")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "IfThenElse"
     (name "!= 0")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a!=0")
     )
     (views
      (icon
       (origin 345 330)
       (extent 46 25)
      )
      (detail
       (origin 209 308)
       (extent 73 64)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "Toggle"
     (name "Info About")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Reset")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Info About")
       (values range 0 1)
       (datum 0)
      )
      (component autoTrigger on)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (datum 0)
      )
     )
     (views
      (icon
       (origin 181 323)
       (extent 114 39)
       (format button)
      )
      (detail
       (origin 320 203)
       (extent 42 54)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "Context"
     (name "Info About This Example")
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Confirm"
       (name "DONE")
       (description 7 8
        This tiny "thread" begins running when the 
        enclosing UserObject is executed.  When the user
        acknowledges the OK/DONE button, there is nothing
        left to execute, so the thread ends.  Since there
        are not other threads running, the User Object
        is completed and will exit, removing the Show on
        Execute pop-up display.
       )
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 61 182)
         (extent 58 37)
        )
        (detail
         (origin 156 253)
         (extent 79 34)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "Note"
       (name "Explanation")
       (interface
       )
       (implementation
        (component text 35 9
         This model shows continuous high speed data acquistion using the HP 3852A Data Acquistion/
         Control Unit and it's high speed voltmeter, the 44702A/B. This example logs the data to
         disc only. The model configures the voltmeter to take readings at 100kHz, it's maximum.
         The ability of this model to remove data from the GPIO interface at a high enough rate so 
         the voltmeter's internal memory does not fill up and cause readings to stop being taken 
         is dependent on a variety of parameters.
         
         The speed of the machine this model is running on is one important factor, as are it's 
         current process load, LAN traffic, and available space on the disc. In general, any 380 to 
         400 class HP 9000 computer will have no problem logging data to disc at 100kHz. Any machine
         not in this class may be unable to maintain that sample rate for an extended period. 
         
         This example contains 4 Direct I/O objects, two configured for HP-IB, and two configured
         for GPIO. The Direct I/O object titled "3852A Setup" downloads the command strings to the
         44702A/B within the 3852A. The Direct I/O object titled "GPIO Data Transfer Setup" sets
         the GPIO CTL lines so that the voltmeter's internal Data Buffer register can be addressed
         prepatory to reading data off the bus. This object shows the use of the IOCONTROL transac-
         tions. The other HPIB object, titled "Trigger 3852A", triggers the voltmeter to start taking 
         readings. The last Direct I/O object, configured for the GPIO interface, reads the data
         off the bus. Notice that the transaction in this object is set to read 32-bit integers
         (Int32). The voltmeter's readings are placed on the bus in an internal, packed format 
         where each reading is 16 bits. Therefore, the object titled "GPIO Data Transfer", is 
         transfering twice the number of readings stated in the COUNT variable. Since the 
         transaction is configured to read 10,000 32 bit integers, 20,000 readings are actually
         read for each operation of the object.
         
         This is an important point for performance reasons. Even though HP VEE supports a 16 bit 
         data type (Int16) for I/O, that data type is immediately promoted to Int32 upon exiting the
         data output pin of the I/O object. This promotion has some time costs. By keeping the data 
         read from the GPIO interface in a 32 bit format (2 readings per Int32), the promotion and
         subsequent time costs are then avoided. Notice that the To File object's transaction is 
         also configured for Int32. For further information on HP VEE-Test and the 3852A please see
         HP Application Note 1206-01 "Complete data Acquisition Solutions with HP VEE-Test". Please
         read the "Show Description" notes on each of the Direct I/O objects for more information.
         
        )
       )
       (views
        (icon
         (origin 395 468)
         (extent 110 25)
        )
        (detail
         (origin 21 230)
         (extent 898 361)
         (editing enabled)
        )
        (active detail)
       )
      )
      (configuration
      )
      (ShowOnExecPanel
       (origin 36 95)
       (extent 926 523)
       (panel
        (origin 19 188)
        (extent 922 485)
        (widget 0 icon
         (title off)
         (origin 453 603)
         (extent 58 37)
        )
        (widget 1 detail
         (title on)
         (origin 50 238)
         (extent 867 353)
         (editing enabled)
        )
       )
      )
     )
     (views
      (icon
       (origin 372 418)
       (extent 217 25)
      )
      (detail
       (origin 12 159)
       (extent 916 522)
       (configuration
       )
      )
      (active icon)
     )
    )
    (configuration
     (connect D1:1 D0:1)
     (connect D0:0 D1:1)
     (connect D0:1 D2:0)
    )
   )
   (views
    (icon
     (origin 435 408)
     (extent 110 25)
    )
    (panel
     (origin 561 332)
     (extent 319 77)
     (widget 1 icon
      (title off)
      (origin 663 345)
      (extent 114 39)
      (format button)
     )
    )
    (detail
     (origin 2 110)
     (extent 956 601)
     (configuration
      (connect D1:1 D0:1
       (Point 297 342)
       (Point 342 342)
      )
      (connect D0:0 D1:1
       (Point 368 357)
       (Point 368 380)
       (Point 160 380)
       (Point 160 342)
       (Point 178 342)
      )
      (connect D0:1 D2:0
       (Point 393 332)
       (Point 400 332)
       (Point 400 140)
       (Point 480 140)
       (Point 480 415)
      )
     )
    )
    (active panel)
    (active panel)
   )
  )
  (component 8 "Counter"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
    (output 1
     (type data)
     (name "Count")
     (tag "Count")
     (lock name constraints)
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
    )
    (detail
     (origin 645 503)
     (extent 150 34)
    )
    (active detail)
   )
  )
  (component 9 "IODevice"
   (name "GPIO Data Transfer (GPIO@12)")
   (description 18 4
    Readings are read from the GPIO interface here.
    Readings are placed on the interface in a packed 
    format, 2 bytes per reading. The transaction is
    this Direct I/O object is reading in Int32, or
    two readings at a time. Notice that the number of
    Int32s to read is entered via the variable, cnt.
    In this case this value is 10,000. This means that
    20,000 readings are being brought into VEE TEST
    every time this object operates. The purpose in 
    reading such large blocks of data is to stay ahead 
    of the 44702A/B's sample rate. If the internal
    memory of the voltmeter is allowed to fill up the
    voltmeter will stop. Depending on the power of the
    controller, it's process load, LAN traffic, and
    disc volume, the size of the blocks can be 
    modified to keep up with the 44702A/B's sample
    rate.
    
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "cnt")
     (tag "cnt")
     (optional yes)
    )
    (output 1
     (type data)
     (name "raw")
     (requires
      (datatype Int16)
     )
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (comp iopath "GPIO Transfer")
    (procedure
      READ BINARY raw INT32 COUNT:cnt
    )
   )
   (views
    (icon
     (origin 359 648)
     (extent 262 64)
     (iconImage "inst.icon")
    )
    (detail
     (origin 318 603)
     (extent 365 75)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 10 "Constant"
   (name "Block size to read")
   (subType "Integer")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Int32")
     (lock name constraints)
    )
   )
   (implementation
    (component value Int32
     (name "Block size to read")
     (datum 10000)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Int32
     (datum 0)
    )
   )
   (views
    (icon
     (extent 172 0)
    )
    (detail
     (origin 47 666)
     (extent 246 28)
     (showFormat int)
    )
    (active detail)
   )
  )
  (component 11 "Note"
   (name "100khz data acquisition logging readings to disc")
   (interface
   )
   (implementation
   )
   (views
    (icon
     (origin 249 78)
     (extent 442 25)
    )
    (detail
     (origin 308 125)
     (extent 525 90)
     (editing enabled)
    )
    (active icon)
   )
  )
  (component 12 "ToFile"
   (name "To File")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (tag "A")
     (optional yes)
    )
   )
   (implementation
    (attr iopath file write "/tmp/rawdata"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (procedure
      WRITE BINARY a INT32
    )
   )
   (views
    (icon
     (origin 680 666)
     (extent 80 29)
    )
    (detail
     (origin 567 543)
     (extent 356 175)
    )
    (terminals on)
    (active icon)
   )
  )
  (configuration
   (connect D4:0 D2:0)
   (connect D0:1 D3:1)
   (connect D1:1 D3:2)
   (connect D3:0 D4:0)
   (connect D2:0 D6:0)
   (connect D6:1 D8:1)
   (connect D6:1 D9:0)
   (connect D10:1 D9:1)
   (connect D9:1 D12:1)
  )
 )
 (views
  (detail
   (origin 0 67)
   (extent 995 668)
   (configuration
    (connect D4:0 D2:0
     (Point 380 384)
     (Point 380 394)
     (Point 380 394)
     (Point 380 405)
    )
    (connect D0:1 D3:1
     (Point 274 180)
     (Point 290 180)
     (Point 290 220)
     (Point 322 220)
    )
    (connect D1:1 D3:2
     (Point 272 260)
     (Point 322 260)
    )
    (connect D3:0 D4:0
     (Point 380 274)
     (Point 380 294)
     (Point 380 294)
     (Point 380 315)
    )
    (connect D2:0 D6:0
     (Point 380 474)
     (Point 380 535)
    )
    (connect D6:1 D8:1
     (Point 437 570)
     (Point 490 570)
     (Point 490 520)
     (Point 642 520)
    )
    (connect D6:1 D9:0
     (Point 437 570)
     (Point 490 570)
     (Point 490 645)
    )
    (connect D10:1 D9:1
     (Point 295 680)
     (Point 356 680)
    )
    (connect D9:1 D12:1
     (Point 623 680)
     (Point 650 680)
     (Point 650 680)
     (Point 677 680)
    )
   )
  )
  (active detail)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
