#! /usr/lib/veetest/veetest -r
(revision "B.00.00")
(date "Fri 20/Nov/1992")
(component 0 "ROOTCONTEXT"
 (name "Manufacturing Test Example")
 (description 4 2
  This example is to demonstrate user interaction,
  sequencing of multiple tests, and how to 
  generate and display a report.
  
 )
 (interface
 )
 (implementation
  (UserFunctions
   (nextID 8)
   (context 0
    (name "test2")
    (description 10 5
     Test 2 will check a noisy waveform against a 
     set of pre-determined coordinates.  Here we 
     use a coordinate constant.  Instead, we could
     have read the coordinate points from a file.
     
     The most powerful object in this test is the
     comparator.  Note that it was used to compare
     coordinate points to a waveform, and included 
     the ability to interpolate between points.
     
    )
    (interface
     (sequence in)
     (sequence out)
    )
    (implementation
     (locked no)
     (trigMode deg)
     (nextID 22)
     (component 0 "YPLOT"
      (name "MASK TEST")
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "Noisy Wave")
        (lock constraints)
       )
       (input 2
        (type data)
        (name "UpperLimit")
        (lock constraints)
        (optional yes)
       )
       (input 3
        (type data)
        (name "UpperFail")
        (lock constraints)
        (optional yes)
       )
      )
      (implementation
       (component clearAtPrerun 1)
       (component clearAtActivate 0)
       (component tracePin 1)
       (component tracePin 2)
       (component tracePin 3)
       (component graphMode time)
      )
      (views
       (icon
        (extent 110 0)
        (iconImage "display.icon")
       )
       (detail
        (origin 757 247)
        (extent 346 266)
        (displayMode annotGraph)
        (graphType cartesian)
        (gridType grid)
        (scale 0
         (name "Mag")
         (domainName "Time")
         (pen 9)
         (show 1)
         (range -2 2 4 linear)
        )
        (domain 0 0.02 4 linear)
        (trace 0 onScale 0
         (name "Noisy Wave")
         (pen 4)
         (lineType 1)
         (pointType 0)
        )
        (trace 1 onScale 0
         (name "UpperLimit")
         (pen 7)
         (lineType 1)
         (pointType 0)
        )
        (trace 2 onScale 0
         (name "UpperFail")
         (pen 2)
         (lineType 2)
         (pointType 1)
        )
       )
       (active detail)
      )
     )
     (component 1 "FORMULA"
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "A")
        (optional yes)
       )
       (output 1
        (type data)
        (name "Result")
        (lock name constraints)
       )
      )
      (implementation
       (component isLocked no)
       (component expr 1 "a+1")
      )
      (views
       (icon
        (origin 531 178)
        (extent 78 64)
        (iconImage "formula.icon")
       )
       (detail
        (origin 626 100)
        (extent 79 60)
       )
       (terminals on)
       (active icon)
      )
     )
     (component 2 "METER"
      (name "Test Number")
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "Data")
        (requires
         (datatype Real)
         (shape "Scalar")
        )
        (lock name constraints)
       )
      )
      (implementation
       (component clearAtPrerun 1)
       (component clearAtActivate 1)
       (component range 0 30)
      )
      (views
       (icon
        (origin 635 198)
        (extent 110 25)
       )
       (detail
        (origin 579 128)
        (extent 183 124)
       )
       (active icon)
      )
     )
     (component 3 "COUNTER"
      (name "# of Failures")
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "Data")
       )
       (output 1
        (type data)
        (name "Count")
        (tag "Count")
        (lock name constraints)
       )
      )
      (implementation
       (component clearAtPrerun 0)
       (component clearAtActivate 1)
      )
      (views
       (icon
        (origin 757 548)
        (extent 127 25)
       )
       (detail
        (origin 551 539)
        (extent 129 63)
       )
       (terminals on)
       (active icon)
      )
     )
     (component 4 "FORMULA"
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "A")
        (optional yes)
       )
       (input 2
        (type data)
        (name "B")
        (optional yes)
       )
       (output 1
        (type data)
        (name "Result")
        (lock name constraints)
       )
      )
      (implementation
       (component isLocked no)
       (component expr 1 "((a/b)*100)")
      )
      (views
       (icon
        (origin 771 648)
        (extent 78 64)
        (iconImage "formula.icon")
       )
       (detail
        (origin 679 308)
        (extent 133 104)
       )
       (terminals on)
       (active icon)
      )
     )
     (component 5 "CONSTANT"
      (name "Upper Limit")
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (lock name constraints)
       )
      )
      (implementation
       (component value Coord
        (name "Upper Limit")
        (numDims 1)
        (size 6)
        (numCoordDims 2)
        (data
         [ (0,0.5) (0.0022,1.2) (0.007200000000000001,1.2) (0.0132,-0.5) (0.0162,-0.5) (0.02,0.5) ]
        )
       )
       (component autoTrigger off)
       (component initializeAtPrerun off)
       (component initializeAtActivate off)
       (component initValue Coord
        (name "Coord")
        (numCoordDims 2)
        (datum (0,0))
       )
      )
      (views
       (icon
        (origin 115 498)
        (extent 110 25)
       )
       (detail
        (origin 146 387)
        (extent 249 126)
       )
       (active detail)
      )
     )
     (component 6 "FORRANGE"
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "Data")
        (lock name constraints)
       )
      )
      (implementation
       (component from 5)
       (component thru 1)
       (component step -1)
      )
      (views
       (icon
        (origin 185 608)
        (extent 110 64)
        (iconImage "loop.icon")
       )
       (detail
        (origin 135 537)
        (extent 170 86)
       )
       (active icon)
      )
     )
     (component 7 "EXITCONTEXT"
      (interface
       (sequence in)
      )
      (implementation
      )
      (views
       (icon
        (origin 168 698)
        (extent 145 25)
       )
       (detail
       )
       (terminals on)
       (active icon)
      )
     )
     (component 8 "FORMULA"
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "A")
        (optional yes)
       )
       (output 1
        (type data)
        (name "Result")
        (lock name constraints)
       )
      )
      (implementation
       (component isLocked no)
       (component expr 1 "\"WAITING...\"+a")
      )
      (views
       (icon
        (origin 331 608)
        (extent 78 64)
        (iconImage "formula.icon")
       )
       (detail
        (origin 245 378)
        (extent 160 104)
       )
       (terminals on)
       (active icon)
      )
     )
     (component 9 "TEXTDISPLAY"
      (name "AlphaNumeric")
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "Data")
       )
      )
      (implementation
       (component clearAtPrerun 1)
       (component clearAtActivate 1)
      )
      (views
       (icon
       )
       (detail
        (origin 454 652)
        (extent 192 37)
       )
       (active detail)
      )
     )
     (component 10 "DELAY"
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "Done")
        (tag "Done")
        (lock constraints)
       )
      )
      (implementation
       (component delay 0.8)
      )
      (views
       (icon
        (origin 511 708)
        (extent 78 25)
       )
       (detail
        (origin 555 633)
        (extent 130 34)
       )
       (active icon)
      )
     )
     (component 11 "FORCOUNT"
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "Count")
        (lock name constraints)
       )
      )
      (implementation
       (component count 30)
      )
      (views
       (icon
        (iconImage "loop.icon")
       )
       (detail
        (origin 135 283)
        (extent 170 34)
       )
       (active detail)
      )
     )
     (component 12 "START"
      (interface
       (sequence out)
      )
      (implementation
      )
      (views
       (icon
        (origin 187 192)
        (extent 67 37)
       )
       (detail
       )
       (terminals on)
       (active icon)
      )
     )
     (component 13 "RANDOMNUMBER"
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "Rand Val")
        (lock name constraints)
       )
      )
      (implementation
       (component lowerLimit 0.2)
       (component upperLimit 0.23)
      )
      (views
       (icon
        (origin 357 228)
        (extent 127 25)
       )
       (detail
        (origin 169 250)
        (extent 222 60)
       )
       (terminals on)
       (active icon)
      )
     )
     (component 14 "VNOISEGENERATOR"
      (name "Noise Generator")
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "Amplitude")
        (tag "Amplitude")
        (requires
         (datatype Real)
         (shape "Scalar")
        )
        (lock constraints)
        (optional yes)
        (buffer YES)
       )
       (output 1
        (type data)
        (name "noise WF")
        (tag "noiseWF")
        (lock name constraints)
       )
      )
      (implementation
       (component amplitude 0.2176264983971132)
       (component numPoints 256)
       (component interval 0.02)
      )
      (views
       (icon
        (origin 465 265)
        (extent 151 31)
       )
       (detail
        (origin 375 225)
        (extent 221 90)
       )
       (terminals on)
       (active icon)
      )
     )
     (component 15 "COMPARATOR"
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "Ref Value")
        (tag "RefValue")
       )
       (input 2
        (type data)
        (name "Test Value")
        (tag "TestValue")
       )
       (output 1
        (type data)
        (name "Passed")
        (tag "Passed")
        (lock name constraints)
        (optional yes)
       )
       (output 2
        (type data)
        (name "Failed")
        (tag "Failed")
        (lock name constraints)
        (optional yes)
       )
       (output 3
        (type data)
        (name "Failures")
        (tag "Failures")
        (lock name constraints)
        (optional yes)
       )
      )
      (implementation
       (attr relation "<")
      )
      (views
       (icon
        (origin 455 443)
        (extent 110 34)
       )
       (detail
        (origin 815 125)
        (extent 251 110)
       )
       (terminals on)
       (active icon)
      )
     )
     (component 16 "COLLECTOR"
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "Data")
        (tag "Data")
       )
       (input 2
        (type trigger)
        (name "XEQ")
        (lock name constraints)
       )
       (output 1
        (type data)
        (name "Array")
        (tag "Array")
        (lock constraints)
       )
      )
      (implementation
       (component clearAtPrerun 1)
       (component clearAtActivate 1)
       (component output1D YES)
      )
      (views
       (icon
        (origin 465 518)
        (extent 110 25)
       )
       (detail
        (origin 485 335)
        (extent 60 110)
       )
       (terminals on)
       (active icon)
      )
     )
     (component 17 "TOFILE"
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "B")
        (optional yes)
       )
      )
      (implementation
       (attr iopath file append "/tmp/mfgdata"
        (readTerm "\n")
        (fs "\n")
        (eol "\n")
        (multiField fullSyntax)
        (arrayFormat block)
       )
       (procedure
         WRITE TEXT "    " QSTR EOL
         WRITE TEXT "    " QSTR EOL
         WRITE TEXT "    " QSTR EOL
         WRITE TEXT now() DATE:WDMY TIME:HMS:H12 EOL
         WRITE TEXT "    " QSTR EOL
         WRITE TEXT "FAILING COORDINATES from TEST 2" EOL
         WRITE TEXT "--------------------------------------------------------" EOL
         WRITE TEXT b COORD STD:4 EOL
       )
      )
      (views
       (icon
        (origin 601 513)
        (extent 78 34)
       )
       (detail
        (origin 485 447)
        (extent 320 167)
       )
       (terminals on)
       (active icon)
      )
     )
     (component 18 "FORMULA"
      (name " + ")
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "X")
        (lock name constraints)
       )
       (input 2
        (type data)
        (name "Y")
        (lock name constraints)
       )
       (output 1
        (type data)
        (name "Result")
        (lock name constraints)
       )
      )
      (implementation
       (component isLocked yes)
       (component expr 1 "X+Y")
      )
      (views
       (icon
        (origin 657 278)
        (extent 46 25)
       )
       (detail
       )
       (terminals on)
       (active icon)
      )
     )
     (component 19 "VFUNCTIONGENERATOR"
      (name "Function Generator")
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (lock name constraints)
       )
      )
      (implementation
       (component function Sine)
       (component frequency 50)
       (component amplitude 1)
       (component dcOffset 0)
       (component phaseShift 0)
       (component numPoints 256)
       (component interval 0.02)
       (component degRad Deg)
       (component errorOnAlias 1)
      )
      (views
       (icon
        (origin 453 311)
        (extent 174 78)
        (iconImage "virtual.icon")
       )
       (detail
        (origin 239 111)
        (extent 239 198)
       )
       (terminals on)
       (active icon)
      )
     )
     (component 20 "SAMPLEHOLD"
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "InData")
        (tag "InData")
        (lock constraints)
       )
       (input 2
        (type trigger)
        (name "XEQ")
        (lock name constraints)
       )
       (output 1
        (type data)
        (name "OutData")
        (tag "OutData")
        (lock constraints)
       )
      )
      (implementation
      )
      (views
       (icon
        (origin 917 558)
        (extent 127 25)
       )
       (detail
       )
       (terminals on)
       (active icon)
      )
     )
     (component 21 "TEXTDISPLAY"
      (name "% Failures")
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "Data")
       )
      )
      (implementation
       (component clearAtPrerun 1)
       (component clearAtActivate 1)
      )
      (views
       (icon
        (extent 110 0)
       )
       (detail
        (origin 875 662)
        (extent 190 37)
       )
       (active detail)
      )
     )
     (configuration
      (connect D18:1 D0:1)
      (connect D5:1 D0:2)
      (connect D15:3 D0:3)
      (connect D11:1 D1:1)
      (connect D1:1 D2:1)
      (connect D15:2 D3:1)
      (connect D20:1 D4:1)
      (connect D1:1 D4:2)
      (connect D17:0 D6:0)
      (connect D6:0 D7:0)
      (connect D6:1 D8:1)
      (connect D8:1 D9:1)
      (connect D9:0 D10:0)
      (connect D12:0 D11:0)
      (connect D11:1 D13:0)
      (connect D13:1 D14:1)
      (connect D5:1 D15:1)
      (connect D18:1 D15:2)
      (connect D15:3 D16:1)
      (connect D11:0 D16:2)
      (connect D16:1 D17:1)
      (connect D14:1 D18:1)
      (connect D19:1 D18:2)
      (connect D3:1 D20:1)
      (connect D11:1 D20:2)
      (connect D4:1 D21:1)
     )
     (ShowOnExecPanel
      (origin 169 123)
      (extent 594 581)
      (panel
       (origin 485 264)
       (extent 590 553)
       (widget 0 detail
        (title off)
        (origin 502 274)
        (extent 554 305)
        (displayMode annotGraph)
        (graphType cartesian)
        (gridType off)
        (scale 0
         (name "Mag")
         (domainName "Time")
         (pen 9)
         (show 1)
         (range -2 2 4 linear)
        )
        (domain 0 0.02 4 linear)
        (trace 0 onScale 0
         (name "Noisy Wave")
         (pen 4)
         (lineType 1)
         (pointType 0)
        )
        (trace 1 onScale 0
         (name "UpperLimit")
         (pen 7)
         (lineType 1)
         (pointType 0)
        )
        (trace 2 onScale 0
         (name "UpperFail")
         (pen 2)
         (lineType 2)
         (pointType 1)
        )
       )
       (widget 2 detail
        (title on)
        (origin 503 622)
        (extent 290 140)
       )
       (widget 3 detail
        (title on)
        (origin 837 622)
        (extent 216 36)
       )
       (widget 21 detail
        (title on)
        (origin 839 714)
        (extent 216 45)
       )
       (widget 9 detail
        (title off)
        (origin 683 770)
        (extent 217 40)
       )
      )
     )
    )
    (views
     (detail
      (origin 125 159)
      (extent 983 599)
      (configuration
       (connect D18:1 D0:1
        (Point 705 290)
        (Point 754 290)
       )
       (connect D5:1 D0:2
        (Point 397 450)
        (Point 430 450)
        (Point 430 420)
        (Point 730 420)
        (Point 730 380)
        (Point 754 380)
       )
       (connect D15:3 D0:3
        (Point 567 470)
        (Point 754 470)
       )
       (connect D11:1 D1:1
        (Point 307 300)
        (Point 330 300)
        (Point 330 210)
        (Point 528 210)
       )
       (connect D1:1 D2:1
        (Point 611 210)
        (Point 632 210)
       )
       (connect D15:2 D3:1
        (Point 567 460)
        (Point 700 460)
        (Point 700 560)
        (Point 754 560)
       )
       (connect D20:1 D4:1
        (Point 1046 570)
        (Point 1060 570)
        (Point 1060 600)
        (Point 750 600)
        (Point 750 660)
        (Point 768 660)
       )
       (connect D1:1 D4:2
        (Point 611 210)
        (Point 620 210)
        (Point 620 240)
        (Point 730 240)
        (Point 730 370)
        (Point 740 370)
        (Point 740 430)
        (Point 730 430)
        (Point 730 700)
        (Point 768 700)
       )
       (connect D17:0 D6:0
        (Point 640 549)
        (Point 640 570)
        (Point 240 570)
        (Point 240 605)
       )
       (connect D6:0 D7:0
        (Point 240 674)
        (Point 240 695)
       )
       (connect D6:1 D8:1
        (Point 297 640)
        (Point 328 640)
       )
       (connect D8:1 D9:1
        (Point 411 640)
        (Point 430 640)
        (Point 430 670)
        (Point 451 670)
       )
       (connect D9:0 D10:0
        (Point 550 691)
        (Point 550 705)
       )
       (connect D12:0 D11:0
        (Point 220 231)
        (Point 220 252)
       )
       (connect D11:1 D13:0
        (Point 307 300)
        (Point 330 300)
        (Point 330 210)
        (Point 420 210)
        (Point 420 225)
       )
       (connect D13:1 D14:1
        (Point 486 240)
        (Point 500 240)
        (Point 500 260)
        (Point 450 260)
        (Point 450 280)
        (Point 462 280)
       )
       (connect D5:1 D15:1
        (Point 397 450)
        (Point 452 450)
       )
       (connect D18:1 D15:2
        (Point 705 290)
        (Point 720 290)
        (Point 720 410)
        (Point 440 410)
        (Point 440 470)
        (Point 452 470)
       )
       (connect D15:3 D16:1
        (Point 567 470)
        (Point 580 470)
        (Point 580 500)
        (Point 450 500)
        (Point 450 520)
        (Point 462 520)
       )
       (connect D11:0 D16:2
        (Point 220 319)
        (Point 220 330)
        (Point 420 330)
        (Point 420 540)
        (Point 462 540)
       )
       (connect D16:1 D17:1
        (Point 577 530)
        (Point 598 530)
       )
       (connect D14:1 D18:1
        (Point 618 280)
        (Point 654 280)
       )
       (connect D19:1 D18:2
        (Point 629 350)
        (Point 640 350)
        (Point 640 300)
        (Point 654 300)
       )
       (connect D3:1 D20:1
        (Point 886 560)
        (Point 914 560)
       )
       (connect D11:1 D20:2
        (Point 307 300)
        (Point 430 300)
        (Point 430 410)
        (Point 410 410)
        (Point 410 590)
        (Point 900 590)
        (Point 900 580)
        (Point 914 580)
       )
       (connect D4:1 D21:1
        (Point 851 680)
        (Point 872 680)
       )
      )
      (stackingOrder 0 1 2 3 4 5 6 7 8 9
        10 11 12 13 14 15 16 18 19 20
        21 17)
     )
     (terminals on)
     (active detail)
    )
   )
   (context 1
    (name "Test1")
    (description 4 5
     Test one is to show how to view data as it is
     received and then to have the option of viewing
     additional choices.
     
    )
    (interface
     (sequence in)
     (sequence out)
    )
    (implementation
     (locked no)
     (trigMode deg)
     (nextID 8)
     (component 0 "FORCOUNT"
      (name "For Count 50")
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (lock name constraints)
       )
      )
      (implementation
       (component count 50)
      )
      (views
       (icon
        (origin 81 208)
        (extent 118 64)
        (iconImage "loop.icon")
       )
       (detail
        (origin 54 213)
        (extent 192 34)
       )
       (active icon)
      )
     )
     (component 1 "RANDOMNUMBER"
      (name "Random Number")
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "Rand Val")
        (lock name constraints)
       )
      )
      (implementation
       (component lowerLimit -1)
       (component upperLimit 1)
      )
      (views
       (icon
        (origin 257 258)
        (extent 127 25)
       )
       (detail
        (origin 237 180)
        (extent 222 60)
       )
       (terminals on)
       (active icon)
      )
     )
     (component 2 "YPLOT"
      (name "Data Being Collected...")
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "Trace1")
        (lock constraints)
       )
      )
      (implementation
       (component clearAtPrerun 1)
       (component clearAtActivate 1)
       (component tracePin 1)
       (component graphMode strip)
      )
      (views
       (icon
        (extent 217 0)
        (iconImage "display.icon")
       )
       (detail
        (origin 455 196)
        (extent 291 149)
        (displayMode graphOnly)
        (graphType cartesian)
        (gridType axis)
        (scale 0
         (name "Y name")
         (domainName "X name")
         (pen 9)
         (show 1)
         (range -1 1 3 linear)
        )
        (domain 0 49.00000000000053 4 linear)
        (trace 0 onScale 0
         (name "Trace1")
         (pen 4)
         (lineType 1)
         (pointType 0)
        )
        (stepSize 1)
        (trackingEnabled 1)
       )
       (active detail)
      )
     )
     (component 3 "START"
      (interface
       (sequence out)
      )
      (implementation
      )
      (views
       (icon
        (origin 107 142)
        (extent 67 37)
       )
       (detail
       )
       (terminals on)
       (active icon)
      )
     )
     (component 4 "COLLECTOR"
      (name "Collector")
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "Data")
        (tag "Data")
       )
       (input 2
        (type trigger)
        (name "XEQ")
        (lock name constraints)
       )
       (output 1
        (type data)
        (name "Array")
        (tag "Array")
        (lock constraints)
       )
      )
      (implementation
       (component clearAtPrerun 1)
       (component clearAtActivate 1)
       (component output1D YES)
      )
      (views
       (icon
        (origin 265 328)
        (extent 110 25)
       )
       (detail
        (origin 175 448)
        (extent 33 104)
       )
       (terminals on)
       (active icon)
      )
     )
     (component 5 "FORMULA"
      (name "movingAvg(x,numPts)")
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "X")
        (lock name constraints)
       )
       (input 2
        (type data)
        (name "numPts")
        (requires
         (datatype Int32)
         (shape "Scalar")
        )
        (lock name constraints)
       )
       (output 1
        (type data)
        (name "Result")
        (lock name constraints)
       )
      )
      (implementation
       (component isLocked yes)
       (component expr 1 "movingAvg(x,numPts)")
      )
      (views
       (icon
        (origin 250 398)
        (extent 181 25)
       )
       (detail
        (origin 688 315)
        (extent 205 110)
       )
       (terminals on)
       (active icon)
      )
     )
     (component 6 "CONTEXT"
      (name "More Info ?")
      (description 3 7
       This is just to prompt for showing more 
       information.
       
      )
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "X")
        (optional yes)
       )
       (input 2
        (type data)
        (name "Average")
        (optional yes)
       )
      )
      (implementation
       (locked no)
       (trigMode deg)
       (nextID 5)
       (component 0 "EXITCONTEXT"
        (interface
         (sequence in)
        )
        (implementation
        )
        (views
         (icon
          (origin 328 408)
          (extent 145 25)
         )
         (detail
         )
         (terminals on)
         (active icon)
        )
       )
       (component 1 "CONFIRM"
        (name "No, Exit")
        (interface
         (sequence in)
         (sequence out)
         (input 1
          (type trigger)
          (name "XEQ")
          (lock name constraints)
          (optional yes)
         )
         (output 1
          (type data)
          (name "Go")
          (lock name constraints)
         )
        )
        (implementation
        )
        (views
         (icon
          (origin 343 332)
          (extent 94 37)
         )
         (detail
          (origin 872 420)
          (extent 76 40)
         )
         (terminals on)
         (active icon)
        )
       )
       (component 2 "CONFIRM"
        (name "YES, More Info")
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Go")
          (lock name constraints)
         )
        )
        (implementation
        )
        (views
         (icon
          (origin 86 342)
          (extent 148 37)
         )
         (detail
          (origin 535 360)
          (extent 140 40)
         )
         (terminals on)
         (active icon)
        )
       )
       (component 3 "NOTE"
        (name "More Information ?")
        (interface
        )
        (implementation
        )
        (views
         (icon
          (origin 164 218)
          (extent 172 64)
          (iconImage "notepad.icon")
         )
         (detail
          (origin 282 235)
          (extent 417 90)
          (editing enabled)
         )
         (active icon)
        )
       )
       (component 4 "CONTEXT"
        (name "Final Data")
        (description 6 9
         After choosing more info...Note that this
         object actually finds the Min Point and 
         Max Point, and then must build the line.
         
         Note also that the Standard Deviation could
         have been plotted as well.
        )
        (interface
         (sequence in)
         (sequence out)
         (input 1
          (type data)
          (name "X")
          (optional yes)
         )
         (input 2
          (type data)
          (name "Average")
          (optional yes)
         )
         (output 1
          (type exception)
          (name "Error")
          (lock name constraints)
          (optional yes)
         )
        )
        (implementation
         (locked no)
         (trigMode deg)
         (nextID 9)
         (component 0 "YPLOT"
          (name "Final Data")
          (interface
           (sequence in)
           (sequence out)
           (input 1
            (type data)
            (name "Data")
            (lock constraints)
           )
           (input 2
            (type data)
            (name "Average")
            (lock constraints)
            (optional yes)
           )
           (input 3
            (type data)
            (name "Min Pt.")
            (lock constraints)
            (optional yes)
           )
           (input 4
            (type data)
            (name "Max Pt.")
            (lock constraints)
            (optional yes)
           )
          )
          (implementation
           (component clearAtPrerun 1)
           (component clearAtActivate 0)
           (component tracePin 1)
           (component tracePin 2)
           (component tracePin 3)
           (component tracePin 4)
           (component graphMode strip)
          )
          (views
           (icon
            (origin 915 458)
            (extent 110 64)
            (iconImage "display.icon")
           )
           (detail
            (origin 342 278)
            (extent 336 304)
            (displayMode annotGraph)
            (graphType cartesian)
            (gridType frame)
            (scale 0
             (name "Y name")
             (domainName "X name")
             (pen 9)
             (show 1)
             (range -1.2 1.2 3 linear)
            )
            (domain 0 49 4 linear)
            (trace 0 onScale 0
             (name "Data")
             (pen 4)
             (lineType 1)
             (pointType 0)
            )
            (trace 1 onScale 0
             (name "Average")
             (pen 7)
             (lineType 1)
             (pointType 0)
            )
            (trace 2 onScale 0
             (name "Min Pt.")
             (pen 6)
             (lineType 1)
             (pointType 0)
            )
            (trace 3 onScale 0
             (name "Max Pt.")
             (pen 2)
             (lineType 1)
             (pointType 0)
            )
            (stepSize 1)
            (trackingEnabled 1)
           )
           (active detail)
          )
         )
         (component 1 "FORMULA"
          (name "sdev(x)")
          (interface
           (sequence in)
           (sequence out)
           (input 1
            (type data)
            (name "X")
            (lock name constraints)
           )
           (output 1
            (type data)
            (name "Result")
            (lock name constraints)
           )
          )
          (implementation
           (component isLocked yes)
           (component expr 1 "sdev(x)")
          )
          (views
           (icon
            (origin 301 608)
            (extent 78 25)
           )
           (detail
           )
           (terminals on)
           (active icon)
          )
         )
         (component 2 "ALLOCATEARRAY"
          (name "Build Max")
          (interface
           (sequence in)
           (sequence out)
           (input 1
            (type data)
            (name "Init Value")
            (tag "Init Value")
            (requires
             (datatype Real)
             (shape "Scalar")
            )
            (lock constraints)
            (optional yes)
            (buffer YES)
           )
           (output 1
            (type data)
            (name "Array")
            (tag "Array")
            (lock constraints)
           )
          )
          (implementation
           (component numDims 1)
           (component dimSizes "50")
           (component type "Real")
           (component initEnum "Init Value")
           (component initialValue
            (name "Init Value")
            (datum 0.9655045262020607)
           )
           (component from 0)
           (component thru 0)
          )
          (views
           (icon
            (origin 212 515)
            (extent 96 31)
           )
           (detail
            (origin 404 543)
            (extent 220 134)
           )
           (terminals on)
           (active icon)
          )
         )
         (component 3 "ALLOCATEARRAY"
          (name "Build Min")
          (interface
           (sequence in)
           (sequence out)
           (input 1
            (type data)
            (name "Init Value")
            (tag "Init Value")
            (requires
             (datatype Real)
             (shape "Scalar")
            )
            (lock constraints)
            (optional yes)
            (buffer YES)
           )
           (output 1
            (type data)
            (name "Array")
            (tag "Array")
            (lock constraints)
           )
          )
          (implementation
           (component numDims 1)
           (component dimSizes "50")
           (component type "Real")
           (component initEnum "Init Value")
           (component initialValue
            (name "Init Value")
            (datum -0.994489837146233)
           )
           (component from 0)
           (component thru 0)
          )
          (views
           (icon
            (origin 204 443)
            (extent 92 35)
           )
           (detail
            (origin 395 443)
            (extent 220 134)
           )
           (terminals on)
           (active icon)
          )
         )
         (component 4 "FORMULA"
          (name "min(x)")
          (interface
           (sequence in)
           (sequence out)
           (input 1
            (type data)
            (name "X")
            (lock name constraints)
           )
           (output 1
            (type data)
            (name "Result")
            (lock name constraints)
           )
          )
          (implementation
           (component isLocked yes)
           (component expr 1 "min(x)")
          )
          (views
           (icon
            (origin 91 448)
            (extent 78 25)
           )
           (detail
            (origin 301 483)
            (extent 88 54)
           )
           (terminals on)
           (active icon)
          )
         )
         (component 5 "FORMULA"
          (name "max(x)")
          (interface
           (sequence in)
           (sequence out)
           (input 1
            (type data)
            (name "X")
            (lock name constraints)
           )
           (output 1
            (type data)
            (name "Result")
            (lock name constraints)
           )
          )
          (implementation
           (component isLocked yes)
           (component expr 1 "max(x)")
          )
          (views
           (icon
            (origin 111 518)
            (extent 78 25)
           )
           (detail
           )
           (terminals on)
           (active icon)
          )
         )
         (component 6 "TEXTDISPLAY"
          (name "Std Deviation")
          (interface
           (sequence in)
           (sequence out)
           (input 1
            (type data)
            (name "Data")
           )
          )
          (implementation
           (component clearAtPrerun 1)
           (component clearAtActivate 1)
          )
          (views
           (icon
            (origin 997 668)
            (extent 127 25)
           )
           (detail
            (origin 505 603)
            (extent 201 34)
           )
           (active detail)
          )
         )
         (component 7 "CONFIRM"
          (interface
           (sequence in)
           (sequence out)
           (output 1
            (type data)
            (name "Go")
            (lock name constraints)
           )
          )
          (implementation
          )
          (views
           (icon
            (origin 106 242)
            (extent 58 37)
           )
           (detail
           )
           (terminals on)
           (active icon)
          )
         )
         (component 8 "ESCAPE"
          (interface
           (sequence in)
          )
          (implementation
           (component code 0)
           (component message "")
          )
          (views
           (icon
            (origin 196 278)
            (extent 78 25)
           )
           (detail
            (origin 486 289)
            (extent 149 63)
           )
           (active icon)
          )
         )
         (configuration
          (connect I1:1 D0:1)
          (connect I2:1 D0:2)
          (connect D3:1 D0:3)
          (connect D2:1 D0:4)
          (connect I1:1 D1:1)
          (connect D5:1 D2:1)
          (connect D4:1 D3:1)
          (connect I1:1 D4:1)
          (connect I1:1 D5:1)
          (connect D1:1 D6:1)
          (connect D7:1 D8:0)
         )
         (ShowOnExecPanel
          (origin 261 200)
          (extent 401 501)
          (panel
           (origin 302 404)
           (extent 397 473)
           (widget 0 detail
            (title on)
            (origin 335 454)
            (extent 336 304)
            (displayMode annotGraph)
            (graphType cartesian)
            (gridType frame)
            (scale 0
             (name "Y name")
             (domainName "X name")
             (pen 9)
             (show 1)
             (range -1.2 1.2 3 linear)
            )
            (domain 0 49 4 linear)
            (trace 0 onScale 0
             (name "Data")
             (pen 4)
             (lineType 1)
             (pointType 0)
            )
            (trace 1 onScale 0
             (name "Average")
             (pen 7)
             (lineType 1)
             (pointType 0)
            )
            (trace 2 onScale 0
             (name "Min Pt.")
             (pen 6)
             (lineType 1)
             (pointType 0)
            )
            (trace 3 onScale 0
             (name "Max Pt.")
             (pen 2)
             (lineType 1)
             (pointType 0)
            )
            (stepSize 1)
            (trackingEnabled 1)
           )
           (widget 7 icon
            (title off)
            (origin 600 782)
            (extent 58 37)
           )
           (widget 6 detail
            (title on)
            (origin 339 803)
            (extent 201 34)
           )
          )
         )
        )
        (views
         (icon
          (origin -195 448)
          (extent 110 25)
         )
         (detail
          (origin 66 211)
          (extent 668 459)
          (configuration
           (connect I1:1 D0:1
            (Point 68 330)
            (Point 75 330)
            (Point 75 320)
            (Point 339 320)
           )
           (connect I2:1 D0:2
            (Point 68 570)
            (Point 115 570)
            (Point 115 500)
            (Point 185 500)
            (Point 185 390)
            (Point 339 390)
           )
           (connect D3:1 D0:3
            (Point 298 460)
            (Point 339 460)
           )
           (connect D2:1 D0:4
            (Point 310 530)
            (Point 339 530)
           )
           (connect I1:1 D1:1
            (Point 68 330)
            (Point 75 330)
            (Point 75 530)
            (Point 95 530)
            (Point 95 620)
            (Point 298 620)
           )
           (connect D5:1 D2:1
            (Point 191 530)
            (Point 209 530)
           )
           (connect D4:1 D3:1
            (Point 171 460)
            (Point 201 460)
           )
           (connect I1:1 D4:1
            (Point 68 330)
            (Point 75 330)
            (Point 75 460)
            (Point 88 460)
           )
           (connect I1:1 D5:1
            (Point 68 330)
            (Point 75 330)
            (Point 75 530)
            (Point 108 530)
           )
           (connect D1:1 D6:1
            (Point 381 620)
            (Point 502 620)
           )
           (connect D7:1 D8:0
            (Point 166 260)
            (Point 235 260)
            (Point 235 275)
           )
          )
          (stackingOrder 0 1 2 3 4 5 6 7 8)
         )
         (terminals on)
         (active icon)
        )
       )
       (configuration
        (connect D1:1 D0:0)
        (connect D4:1 D1:1)
        (connect D2:1 D4:0)
        (connect I1:1 D4:1)
        (connect I2:1 D4:2)
       )
       (ShowOnExecPanel
        (origin 107 283)
        (extent 269 175)
        (panel
         (origin 433 407)
         (extent 265 147)
         (widget 2 icon
          (title off)
          (origin 441 493)
          (extent 148 37)
         )
         (widget 3 icon
          (title off)
          (origin 483 418)
          (extent 172 64)
          (iconImage "notepad.icon")
         )
         (widget 1 icon
          (title off)
          (origin 598 493)
          (extent 94 37)
         )
        )
       )
      )
      (views
       (icon
        (origin 475 428)
        (extent 110 25)
       )
       (detail
        (origin -28 156)
        (extent 687 629)
        (configuration
         (connect D1:1 D0:0
          (Point 439 350)
          (Point 480 350)
          (Point 480 390)
          (Point 400 390)
          (Point 400 405)
         )
         (connect D4:1 D1:1
          (Point -83 460)
          (Point 250 460)
          (Point 250 350)
          (Point 340 350)
         )
         (connect D2:1 D4:0
          (Point 236 360)
          (Point 260 360)
          (Point 260 310)
          (Point 440 310)
          (Point 440 170)
          (Point -140 170)
          (Point -140 445)
         )
         (connect I1:1 D4:1
          (Point -26 320)
          (Point -429 270)
          (Point -429 450)
          (Point -198 450)
         )
         (connect I2:1 D4:2
          (Point -26 640)
          (Point -429 590)
          (Point -429 470)
          (Point -198 470)
         )
        )
        (stackingOrder 0 1 2 4 3)
       )
       (terminals on)
       (active icon)
      )
     )
     (component 7 "TOFILE"
      (description 4 7
       We did not check the CLEAR box of the TO FILE
       object because we wanted other tests to be
       able to append to this file.
       
      )
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "dta")
        (optional yes)
       )
      )
      (implementation
       (attr iopath file append "/tmp/mfgdata"
        (readTerm "\n")
        (fs "\n")
        (eol "\n")
        (multiField fullSyntax)
        (arrayFormat block)
       )
       (procedure
         WRITE TEXT "    " QSTR EOL
         WRITE TEXT "    " QSTR EOL
         WRITE TEXT "    " QSTR EOL
         WRITE TEXT now() DATE:WDMY TIME:HMS:H12 EOL
         WRITE TEXT "    " QSTR EOL
         WRITE TEXT "DATA FROM TEST 1" EOL
         WRITE TEXT "--------------------------------------------------------" EOL
         WRITE TEXT dta REAL STD:4 EOL
       )
      )
      (views
       (icon
        (origin 531 363)
        (extent 78 34)
       )
       (detail
        (origin 457 451)
        (extent 457 178)
       )
       (terminals on)
       (active icon)
      )
     )
     (configuration
      (connect D3:0 D0:0)
      (connect D0:1 D1:0)
      (connect D1:1 D2:1)
      (connect D1:1 D4:1)
      (connect D0:0 D4:2)
      (connect D4:1 D5:1)
      (connect D0:1 D5:2)
      (connect D4:1 D6:1)
      (connect D5:1 D6:2)
      (connect D4:1 D7:1)
     )
     (ShowOnExecPanel
      (origin 7 210)
      (extent 880 309)
      (panel
       (origin 342 330)
       (extent 876 281)
       (widget 2 detail
        (title on)
        (origin 737 402)
        (extent 387 147)
        (displayMode graphOnly)
        (graphType cartesian)
        (gridType axis)
        (scale 0
         (name "Y name")
         (domainName "X name")
         (pen 9)
         (show 1)
         (range -1 1 3 linear)
        )
        (domain 0 49.00000000000053 4 linear)
        (trace 0 onScale 0
         (name "Trace1")
         (pen 4)
         (lineType 1)
         (pointType 0)
        )
        (stepSize 1)
        (trackingEnabled 1)
       )
      )
     )
    )
    (views
     (detail
      (origin 125 139)
      (extent 606 369)
      (configuration
       (connect D3:0 D0:0
        (Point 140 181)
        (Point 140 205)
       )
       (connect D0:1 D1:0
        (Point 201 240)
        (Point 320 240)
        (Point 320 255)
       )
       (connect D1:1 D2:1
        (Point 386 270)
        (Point 452 270)
       )
       (connect D1:1 D4:1
        (Point 386 270)
        (Point 400 270)
        (Point 400 300)
        (Point 250 300)
        (Point 250 330)
        (Point 262 330)
       )
       (connect D0:0 D4:2
        (Point 140 274)
        (Point 140 350)
        (Point 262 350)
       )
       (connect D4:1 D5:1
        (Point 377 340)
        (Point 390 340)
        (Point 390 370)
        (Point 240 370)
        (Point 240 400)
        (Point 247 400)
       )
       (connect D0:1 D5:2
        (Point 201 240)
        (Point 220 240)
        (Point 220 420)
        (Point 247 420)
       )
       (connect D4:1 D6:1
        (Point 377 340)
        (Point 390 340)
        (Point 390 370)
        (Point 460 370)
        (Point 460 430)
        (Point 472 430)
       )
       (connect D5:1 D6:2
        (Point 433 410)
        (Point 450 410)
        (Point 450 450)
        (Point 472 450)
       )
       (connect D4:1 D7:1
        (Point 377 340)
        (Point 390 340)
        (Point 390 370)
        (Point 510 370)
        (Point 510 380)
        (Point 528 380)
       )
      )
      (stackingOrder 0 1 2 3 4 5 7 6)
     )
     (terminals on)
     (active detail)
    )
   )
   (context 2
    (name "Test3")
    (description 14 5
     This object just loads and runs a complete other
     test.  In this case, the other test is another
     VEE model.  It could just as easily have been 
     a C Function that is directly tied to this
     VEE process.  For more information on tying
     in C functions, see the Help information on
     Compiled Functions.
     
     To access the Loading from Disk object, you must
     first pull down its object menu (right button)
     and turn SHOW TITLE to ON.
     
     Delete Library will remove the function from 
     memory.
    )
    (interface
     (sequence in)
     (sequence out)
    )
    (implementation
     (locked no)
     (trigMode deg)
     (nextID 16)
     (component 4 "TEXTDISPLAY"
      (name "The Date")
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "Data")
       )
      )
      (implementation
       (component clearAtPrerun 1)
       (component clearAtActivate 1)
      )
      (views
       (icon
        (extent 110 0)
       )
       (detail
        (origin 672 204)
        (extent 156 192)
       )
       (active detail)
      )
     )
     (component 5 "TOFILE"
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "dta")
        (optional yes)
       )
      )
      (implementation
       (attr iopath file append "/tmp/mfgdata"
        (readTerm "\n")
        (fs "\n")
        (eol "\n")
        (multiField fullSyntax)
        (arrayFormat block)
       )
       (procedure
         WRITE TEXT "    " QSTR EOL
         WRITE TEXT "    " QSTR EOL
         WRITE TEXT "    " QSTR EOL
         WRITE TEXT now() DATE:WDMY TIME:HMS:H12 EOL
         WRITE TEXT "    " QSTR EOL
         WRITE TEXT "DATA FROM TEST 3" EOL
         WRITE TEXT "--------------------------------------------------------" EOL
         WRITE TEXT dta REAL STD:4 EOL
       )
      )
      (views
       (icon
        (origin 741 493)
        (extent 78 34)
       )
       (detail
        (origin 514 400)
        (extent 457 178)
       )
       (terminals on)
       (active icon)
      )
     )
     (component 7 "CALL"
      (name "Call Function")
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "X")
        (lock name constraints)
        (optional yes)
       )
      )
      (implementation
       (component callFunc "pfchart")
      )
      (views
       (icon
       )
       (detail
        (origin 250 382)
        (extent 260 36)
       )
       (terminals on)
       (active detail)
      )
     )
     (component 8 "START"
      (interface
       (sequence out)
      )
      (implementation
      )
      (views
       (icon
        (origin 307 182)
        (extent 67 37)
       )
       (detail
       )
       (terminals on)
       (active icon)
      )
     )
     (component 13 "CONTEXT"
      (name "Load from Disk")
      (description 12 7
       This user object loads the barchart function
       from disk.   You could have also escaped to
       HP-UX, started another VEE process, and loaded
       this program to run.   
       
       By being able to dynamically load and delete
       objects, users can load only the parts of 
       memory that are required, and make maximum
       use of memory space.
       NOTE:  To see the detail view of this object,
       you must press the RIGHT mouse button, and
       select SHOW TITLE.  Then select DETAIL.
      )
      (interface
       (sequence in)
       (sequence out)
      )
      (implementation
       (locked no)
       (trigMode deg)
       (nextID 9)
       (component 1 "LITERALCONSTANT"
        (name "loading")
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Text")
          (lock name constraints)
         )
        )
        (implementation
         (component value Text
          (name "loading")
          (datum "Loading from Disk")
         )
         (component autoTrigger off)
         (component initializeAtPrerun off)
         (component initializeAtActivate off)
         (component initValue Text
          (name "CString")
          (datum "")
         )
        )
        (views
         (icon
          (extent 78 0)
         )
         (detail
          (origin 121 188)
          (extent 219 25)
         )
         (active detail)
        )
       )
       (component 3 "TEXTDISPLAY"
        (name "Loading from Disk")
        (interface
         (sequence in)
         (sequence out)
         (input 1
          (type data)
          (name "Data")
         )
        )
        (implementation
         (component clearAtPrerun 1)
         (component clearAtActivate 1)
        )
        (views
         (icon
          (extent 163 0)
         )
         (detail
          (origin 283 262)
          (extent 255 37)
         )
         (active detail)
        )
       )
       (component 7 "IMPORT"
        (name "Import Library")
        (interface
         (sequence in)
         (sequence out)
         (input 1
          (type control)
          (name "File Name")
          (tag "File Name")
          (requires
           (datatype Text)
           (shape "Scalar")
          )
          (lock name constraints)
          (optional yes)
         )
        )
        (implementation
         (component libType "userFunction")
         (component libName "myLibrary")
         (component fileName "/usr/lib/veetest/examples/mfgtest/mfgtest1.ex.new")
        )
        (views
         (icon
          (origin 372 338)
          (extent 136 25)
         )
         (detail
          (origin 508 372)
          (extent 305 96)
         )
         (active icon)
        )
       )
       (component 8 "LITERALCONSTANT"
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Text")
          (lock name constraints)
         )
        )
        (implementation
         (component value Text
          (name "Text")
          (datum "/usr/lib/veetest/examples/mfgtest/mfgtest1.ex")
         )
         (component autoTrigger off)
         (component initializeAtPrerun off)
         (component initializeAtActivate off)
         (component initValue Text
          (name "CString")
          (datum "")
         )
        )
        (views
         (icon
          (origin 177 338)
          (extent 46 25)
         )
         (detail
          (origin 104 334)
          (extent 192 32)
         )
         (active icon)
        )
       )
       (configuration
        (connect D0:1 D1:1)
        (connect D1:0 D2:0)
        (connect D3:1 D2:1)
       )
       (ShowOnExecPanel
        (origin 330 280)
        (extent 376 75)
        (panel
         (origin 164 245)
         (extent 372 71)
         (widget 1 detail
          (title off)
          (origin 172 267)
          (extent 358 32)
         )
        )
       )
      )
      (views
       (icon
        (origin 282 268)
        (extent 136 25)
       )
       (detail
        (origin 98 151)
        (extent 485 239)
        (configuration
         (connect D0:1 D1:1
          (Point 342 200)
          (Point 560 200)
          (Point 560 320)
          (Point 260 320)
          (Point 260 280)
          (Point 280 280)
         )
         (connect D1:0 D2:0
          (Point 410 301)
          (Point 410 310)
          (Point 440 310)
          (Point 440 335)
         )
         (connect D3:1 D2:1
          (Point 225 350)
          (Point 369 350)
         )
        )
        (stackingOrder 0 1 2 3)
       )
       (terminals on)
       (active icon)
      )
     )
     (component 14 "DELETE"
      (name "Delete Library")
      (description 2 7
       The library name is the same as the name given
       in the Loading UserObject.  
      )
      (interface
       (sequence in)
       (sequence out)
      )
      (implementation
       (component libName "myLibrary")
      )
      (views
       (icon
       )
       (detail
        (origin 269 532)
        (extent 242 36)
       )
       (active detail)
      )
     )
     (configuration
      (connect D2:1 D0:1)
      (connect D2:1 D1:1)
      (connect D4:0 D2:0)
      (connect D3:0 D4:0)
      (connect D2:0 D5:0)
     )
    )
    (views
     (panel
      (origin 584 519)
      (extent 392 262)
     )
     (detail
      (origin 65 109)
      (extent 728 444)
      (configuration
       (connect D2:1 D0:1
        (Point 542 400)
        (Point 590 400)
        (Point 590 300)
        (Point 669 300)
       )
       (connect D2:1 D1:1
        (Point 542 400)
        (Point 600 400)
        (Point 600 510)
        (Point 738 510)
       )
       (connect D4:0 D2:0
        (Point 350 295)
        (Point 350 330)
        (Point 380 330)
        (Point 380 351)
       )
       (connect D3:0 D4:0
        (Point 340 221)
        (Point 340 230)
        (Point 350 230)
        (Point 350 265)
       )
       (connect D2:0 D5:0
        (Point 380 420)
        (Point 380 440)
        (Point 390 440)
        (Point 390 501)
       )
      )
      (stackingOrder 3 0 2 5 1 4)
     )
     (terminals on)
     (active detail)
    )
   )
   (context 3
    (name "Report")
    (description 7 5
     This object just reads in the information that
     was stored to the mfgdata file in the other
     tests.
     
     Notice that we are reading the data as a block
     of information in one array of text strings.
     
    )
    (interface
     (sequence in)
     (sequence out)
    )
    (implementation
     (locked no)
     (trigMode deg)
     (nextID 8)
     (component 0 "CONFIRM"
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "Go")
        (lock name constraints)
       )
      )
      (implementation
      )
      (views
       (icon
        (origin 381 502)
        (extent 58 37)
       )
       (detail
       )
       (terminals on)
       (active icon)
      )
     )
     (component 1 "BREAK"
      (interface
       (sequence in)
      )
      (implementation
      )
      (views
       (icon
        (origin 451 578)
        (extent 78 25)
       )
       (detail
       )
       (terminals on)
       (active icon)
      )
     )
     (component 3 "SCROLLINGTEXTDISPLAY"
      (name "Data from Tests")
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "Data")
       )
      )
      (implementation
       (component clearAtPrerun 1)
       (component clearAtActivate 1)
      )
      (views
       (icon
        (origin 875 368)
        (extent 145 25)
       )
       (detail
        (origin 646 347)
        (extent 442 225)
        (bufferSize 256)
       )
       (active detail)
      )
     )
     (component 4 "FROMFILE"
      (description 5 7
       With the 2.0 revision of HP VEE, From File can
       now read to all of the information without
       knowing the length of the file.  Look at the
       transaction on this object and see the ARRAY (*)
       line.  That indicates to read all of the file.
      )
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "X")
        (lock constraints)
        (optional yes)
       )
       (output 2
        (type data)
        (name "EOF")
        (tag "EOF")
        (lock name constraints)
        (optional yes)
       )
      )
      (implementation
       (attr iopath file read "/tmp/mfgdata"
        (readTerm "\n")
        (fs " ")
        (eol "\n")
        (multiField fullSyntax)
        (arrayFormat block)
       )
       (procedure
         READ TEXT x STR ARRAY:*
       )
      )
      (views
       (icon
        (origin 425 398)
        (extent 110 25)
       )
       (detail
        (origin 313 334)
        (extent 324 153)
       )
       (terminals on)
       (active icon)
      )
     )
     (component 6 "START"
      (interface
       (sequence out)
      )
      (implementation
      )
      (views
       (icon
        (origin 357 322)
        (extent 67 37)
       )
       (detail
       )
       (terminals on)
       (active icon)
      )
     )
     (configuration
      (connect D2:0 D0:0)
      (connect D0:1 D1:0)
      (connect D3:1 D2:1)
      (connect D4:0 D3:0)
     )
     (ShowOnExecPanel
      (origin 267 164)
      (extent 448 542)
      (panel
       (origin 348 433)
       (extent 444 514)
       (widget 2 detail
        (title off)
        (origin 357 439)
        (extent 415 423)
        (bufferSize 256)
       )
       (widget 0 icon
        (title off)
        (origin 366 872)
        (extent 398 66)
       )
      )
     )
    )
    (views
     (detail
      (origin 135 289)
      (extent 958 339)
      (configuration
       (connect D2:0 D0:0
        (Point 867 574)
        (Point 867 590)
        (Point 620 590)
        (Point 620 480)
        (Point 410 480)
        (Point 410 499)
       )
       (connect D0:1 D1:0
        (Point 441 520)
        (Point 490 520)
        (Point 490 575)
       )
       (connect D3:1 D2:1
        (Point 537 400)
        (Point 610 400)
        (Point 610 459)
        (Point 643 459)
       )
       (connect D4:0 D3:0
        (Point 390 361)
        (Point 390 380)
        (Point 480 380)
        (Point 480 395)
       )
      )
      (stackingOrder 2 1 4 0 3)
     )
     (terminals on)
     (active detail)
    )
   )
   (context 4
    (name "UserName")
    (description 3 5
     This object will prompt the user for who they 
     are.  If they select none, it will prompt them
     to get added to the list....
    )
    (interface
     (sequence in)
     (sequence out)
     (output 1
      (type data)
      (name "X")
      (lock constraints)
      (optional yes)
     )
    )
    (implementation
     (locked no)
     (trigMode deg)
     (nextID 8)
     (component 0 "ENUMCONSTANT"
      (name "Select your Name")
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type control)
        (name "Reset")
        (lock name constraints)
        (optional yes)
       )
       (output 1
        (type data)
        (name "Enum")
        (lock name constraints)
       )
      )
      (implementation
       (component value Enum
        (name "Select your Name")
        (values
         ( "Joe" 0)
         ( "Fred" 1)
         ( "Sally" 2)
         ( "None" 3)
        )
        (datum "Joe")
       )
       (component autoTrigger on)
       (component initializeAtPrerun off)
       (component initializeAtActivate off)
       (component initValue Enum
        (name "Enum")
        (shared yes)
        (datum "Joe")
       )
      )
      (views
       (icon
        (origin 63 148)
        (extent 154 25)
       )
       (detail
        (origin 365 347)
        (extent 230 26)
        (format list)
       )
       (active detail)
      )
     )
     (component 1 "IFTHENELSE"
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "A")
        (optional yes)
       )
       (output 1
        (type data)
        (name "Then")
        (lock name constraints)
       )
       (output 2
        (type data)
        (name "Else")
        (lock name constraints)
       )
      )
      (implementation
       (component isLocked no)
       (component expr "a==\"None\"")
      )
      (views
       (icon
        (origin 452 500)
        (extent 78 25)
       )
       (detail
        (origin 142 307)
        (extent 149 70)
       )
       (terminals on)
       (active icon)
      )
     )
     (component 2 "CONFIRM"
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "Go")
        (lock name constraints)
       )
      )
      (implementation
      )
      (views
       (icon
        (origin 461 632)
        (extent 58 37)
       )
       (detail
       )
       (terminals on)
       (active icon)
      )
     )
     (component 3 "GATE"
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "A")
        (tag "InData")
       )
       (output 1
        (type data)
        (name "X")
        (tag "OutData")
        (lock name constraints)
       )
      )
      (implementation
      )
      (views
       (icon
        (origin 517 558)
        (extent 46 25)
       )
       (detail
       )
       (terminals on)
       (active icon)
      )
     )
     (component 4 "DO"
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "Do")
        (lock name constraints)
       )
      )
      (implementation
      )
      (views
       (icon
        (origin 617 558)
        (extent 46 25)
       )
       (detail
       )
       (terminals on)
       (active icon)
      )
     )
     (component 5 "EXITPROCESS"
      (interface
       (sequence in)
      )
      (implementation
       (comp code 0)
      )
      (views
       (icon
        (origin 601 618)
        (extent 78 64)
        (iconImage "stop.icon")
       )
       (detail
        (origin 531 555)
        (extent 120 34)
       )
       (active icon)
      )
     )
     (component 6 "CONTEXT"
      (name "Sorry")
      (description 4 7
       This is just a message box to inform them that
       they were rejected and must be added to the list
       of allowable users.
       
      )
      (interface
       (sequence in)
       (sequence out)
      )
      (implementation
       (locked no)
       (trigMode deg)
       (nextID 2)
       (component 0 "NOTE"
        (interface
        )
        (implementation
         (component text 3 10
          ASK YOUR TEST DEVELOPER TO
          ADD YOUR NAME TO THE LIST.
          
         )
        )
        (views
         (icon
          (iconImage "notepad.icon")
         )
         (detail
          (origin 428 272)
          (extent 285 56)
          (editing enabled)
         )
         (active detail)
        )
       )
       (component 1 "CONFIRM"
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Go")
          (lock name constraints)
         )
        )
        (implementation
        )
        (views
         (icon
          (origin 526 380)
          (extent 128 80)
         )
         (detail
         )
         (terminals on)
         (active icon)
        )
       )
       (configuration
       )
       (ShowOnExecPanel
        (origin 442 311)
        (extent 378 228)
        (panel
         (origin 143 260)
         (extent 374 200)
         (widget 0 detail
          (title off)
          (origin 190 276)
          (extent 285 56)
          (editing enabled)
         )
         (widget 1 icon
          (title off)
          (origin 269 360)
          (extent 128 80)
         )
        )
       )
      )
      (views
       (icon
        (origin 601 518)
        (extent 78 25)
       )
       (detail
        (origin 415 230)
        (extent 350 300)
        (configuration
        )
        (stackingOrder 0 1)
       )
       (terminals on)
       (active icon)
      )
     )
     (component 7 "TOGLOBAL"
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "Data")
        (tag "Data")
       )
      )
      (implementation
       (component globalName operator)
      )
      (views
       (icon
        (origin 605 418)
        (extent 110 25)
       )
       (detail
        (origin 622 359)
        (extent 97 62)
       )
       (terminals on)
       (active icon)
      )
     )
     (configuration
      (connect D2:0 D0:0)
      (connect D4:1 D0:1)
      (connect D0:1 D1:1)
      (connect D1:2 D3:0)
      (connect D0:1 D3:1)
      (connect D6:0 D4:0)
      (connect D4:0 D5:0)
      (connect D1:1 D6:0)
      (connect D3:1 D7:1)
      (connect D3:1 O1:1)
     )
     (ShowOnExecPanel
      (origin 333 239)
      (extent 319 302)
      (panel
       (origin 33 113)
       (extent 315 274)
       (widget 0 detail
        (title on)
        (origin 88 161)
        (extent 230 104)
        (format buttons)
       )
       (widget 2 icon
        (title off)
        (origin 97 293)
        (extent 220 49)
       )
      )
     )
    )
    (views
     (detail
      (origin 475 249)
      (extent 266 418)
      (configuration
       (connect D2:0 D0:0
        (Point 490 671)
        (Point 490 690)
        (Point 330 690)
        (Point 330 290)
        (Point 480 290)
        (Point 480 316)
       )
       (connect D4:1 D0:1
        (Point 665 570)
        (Point 820 570)
        (Point 820 480)
        (Point 340 480)
        (Point 340 360)
        (Point 362 360)
       )
       (connect D0:1 D1:1
        (Point 597 360)
        (Point 620 360)
        (Point 620 400)
        (Point 430 400)
        (Point 430 512)
        (Point 449 512)
       )
       (connect D1:2 D3:0
        (Point 532 522)
        (Point 540 522)
        (Point 540 555)
       )
       (connect D0:1 D3:1
        (Point 597 360)
        (Point 620 360)
        (Point 620 400)
        (Point 430 400)
        (Point 430 570)
        (Point 514 570)
       )
       (connect D6:0 D4:0
        (Point 640 545)
        (Point 640 555)
       )
       (connect D4:0 D5:0
        (Point 640 585)
        (Point 640 615)
       )
       (connect D1:1 D6:0
        (Point 532 502)
        (Point 640 502)
        (Point 640 515)
       )
       (connect D3:1 D7:1
        (Point 565 570)
        (Point 580 570)
        (Point 580 430)
        (Point 602 430)
       )
       (connect D3:1 O1:1
        (Point 565 570)
        (Point 580 570)
        (Point 580 490)
        (Point 700 490)
        (Point 700 468)
        (Point 738 468)
       )
      )
      (stackingOrder 0 1 2 3 4 5 6 7)
     )
     (terminals on)
     (active detail)
    )
   )
   (context 5
    (name "PasswordAccepted")
    (description 4 5
     Bogus box to tell the operator that they 
     entered the correct password.  This object
     does not perform any other function.
     
    )
    (interface
     (sequence in)
     (sequence out)
    )
    (implementation
     (locked no)
     (trigMode deg)
     (nextID 4)
     (component 0 "EXITCONTEXT"
      (interface
       (sequence in)
      )
      (implementation
      )
      (views
       (icon
        (origin 598 558)
        (extent 145 25)
       )
       (detail
       )
       (terminals on)
       (active icon)
      )
     )
     (component 1 "TEXTDISPLAY"
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "Data")
       )
      )
      (implementation
       (component clearAtPrerun 1)
       (component clearAtActivate 1)
      )
      (views
       (icon
       )
       (detail
        (origin 519 416)
        (extent 242 68)
       )
       (active detail)
      )
     )
     (component 2 "DELAY"
      (interface
       (sequence in)
       (sequence out)
      )
      (implementation
       (component delay 1.5)
      )
      (views
       (icon
        (origin 521 518)
        (extent 78 25)
       )
       (detail
        (origin 205 563)
        (extent 130 34)
       )
       (active icon)
      )
     )
     (component 3 "LITERALCONSTANT"
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "Text")
        (lock name constraints)
       )
      )
      (implementation
       (component value Text
        (name "Text")
        (datum "Password Accepted")
       )
       (component autoTrigger off)
       (component initializeAtPrerun off)
       (component initializeAtActivate off)
       (component initValue Text
        (name "CString")
        (datum "")
       )
      )
      (views
       (icon
        (origin 497 328)
        (extent 46 25)
       )
       (detail
        (origin 340 306)
        (extent 201 28)
       )
       (active icon)
      )
     )
     (configuration
      (connect D2:0 D0:0)
      (connect D3:1 D1:1)
      (connect D1:0 D2:0)
     )
     (ShowOnExecPanel
      (origin 293 205)
      (extent 371 194)
      (panel
       (origin 317 227)
       (extent 367 166)
       (widget 1 detail
        (title off)
        (origin 376 276)
        (extent 251 61)
       )
      )
     )
    )
    (views
     (detail
      (origin 465 309)
      (extent 301 299)
      (configuration
       (connect D2:0 D0:0
        (Point 560 545)
        (Point 560 560)
        (Point 580 560)
        (Point 580 550)
        (Point 610 550)
        (Point 610 540)
        (Point 670 540)
        (Point 670 555)
       )
       (connect D3:1 D1:1
        (Point 545 340)
        (Point 560 340)
        (Point 560 370)
        (Point 500 370)
        (Point 500 450)
        (Point 516 450)
       )
       (connect D1:0 D2:0
        (Point 640 486)
        (Point 640 510)
        (Point 560 510)
        (Point 560 515)
       )
      )
      (stackingOrder 0 1 2 3)
     )
     (terminals on)
     (active detail)
    )
   )
   (context 6
    (name "CheckPassword")
    (description 11 5
     This an object which will pop-up a dialog box for
     interaction with a user. The input required is the
     prompt and, if needed, a default reply. The con-
     struction is that of a user object inside a user
     function. The internal user object is the actual
     dialog box that will pop-up. This is an unsecured
     model; feel free to make any necessary mod-
     ifications.
     
     (one possible change could be to store the 
     passwords into an encrypted file.)
    )
    (interface
     (sequence in)
     (sequence out)
     (output 1
      (type data)
      (name "ReplyOut")
      (lock constraints)
      (optional yes)
     )
    )
    (implementation
     (locked no)
     (trigMode deg)
     (nextID 13)
     (component 0 "JUNCTION"
      (name "JCT")
      (interface
       (input 1
        (type data)
        (name "A")
        (lock name constraints)
       )
       (input 2
        (type data)
        (name "B")
        (lock name constraints)
       )
       (input 3
        (type data)
        (name "C")
        (optional yes)
       )
       (input 4
        (type data)
        (name "D")
        (optional yes)
       )
       (output 1
        (type data)
        (name "Data")
        (lock name constraints)
       )
      )
      (implementation
      )
      (views
       (icon
        (origin 757 468)
        (extent 46 45)
       )
       (detail
        (origin 670 398)
        (extent 10 204)
       )
       (terminals on)
       (active icon)
      )
     )
     (component 1 "IFTHENELSE"
      (name "Passwords")
      (description 4 7
       This IF/THEN/ELSE object will compare the 
       text string sent from the Keybd object against
       a set of allowable passwords.  This is then
       propogated out of the ReplyOut terminal.
      )
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "A")
        (optional yes)
       )
       (output 1
        (type data)
        (name "Then")
        (lock name constraints)
       )
       (output 2
        (type data)
        (name "Else If")
        (lock name constraints)
       )
       (output 3
        (type data)
        (name "Else If")
        (lock name constraints)
       )
       (output 4
        (type data)
        (name "Else")
        (lock name constraints)
       )
      )
      (implementation
       (component isLocked no)
       (component expr "(operator==\"Joe\" AND a==\"1234\")*1")
       (component expr "(operator==\"Fred\" AND a==\"2345\")*1")
       (component expr "(operator==\"Sally\" AND a==\"3456\")*1")
      )
      (views
       (icon
        (origin 525 493)
        (extent 110 54)
       )
       (detail
        (origin 379 453)
        (extent 343 154)
       )
       (terminals on)
       (active icon)
      )
     )
     (component 2 "FORMULA"
      (name " + ")
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "X")
        (lock name constraints)
       )
       (input 2
        (type data)
        (name "Y")
        (lock name constraints)
       )
       (output 1
        (type data)
        (name "Result")
        (lock name constraints)
       )
      )
      (implementation
       (component isLocked yes)
       (component expr 1 "X+Y")
      )
      (views
       (icon
        (origin 587 318)
        (extent 46 25)
       )
       (detail
       )
       (terminals on)
       (active icon)
      )
     )
     (component 3 "TEXTDISPLAY"
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "Data")
       )
      )
      (implementation
       (component clearAtPrerun 1)
       (component clearAtActivate 1)
      )
      (views
       (icon
        (origin 701 318)
        (extent 118 25)
       )
       (detail
        (origin 477 611)
        (extent 286 38)
       )
       (active icon)
      )
     )
     (component 4 "LITERALCONSTANT"
      (name "Prompt")
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "Text")
        (lock name constraints)
       )
      )
      (implementation
       (component value Text
        (name "Prompt")
        (datum ", Enter your ID number")
       )
       (component autoTrigger off)
       (component initializeAtPrerun off)
       (component initializeAtActivate off)
       (component initValue Text
        (name "CString")
        (datum "")
       )
      )
      (views
       (icon
        (extent 78 0)
       )
       (detail
        (origin 424 408)
        (extent 252 25)
       )
       (active detail)
      )
     )
     (component 5 "CONTEXT"
      (name "Keybd")
      (description 2 7
       Keypad Modified to display asterisks instead 
       of the entered number string.
      )
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "X")
        (lock constraints)
        (optional yes)
       )
       (output 2
        (type exception)
        (name "Error")
        (lock name constraints)
        (optional yes)
       )
      )
      (implementation
       (locked no)
       (trigMode deg)
       (nextID 34)
       (component 0 "JUNCTION"
        (name "JCT")
        (interface
         (input 1
          (type data)
          (name "A")
          (lock name constraints)
         )
         (input 2
          (type data)
          (name "B")
          (lock name constraints)
         )
         (input 3
          (type data)
          (name "C")
          (optional yes)
         )
         (input 4
          (type data)
          (name "D")
          (optional yes)
         )
         (input 5
          (type data)
          (name "E")
          (optional yes)
         )
         (input 6
          (type data)
          (name "F")
          (optional yes)
         )
         (input 7
          (type data)
          (name "G")
          (optional yes)
         )
         (input 8
          (type data)
          (name "H")
          (optional yes)
         )
         (input 9
          (type data)
          (name "I")
          (optional yes)
         )
         (input 10
          (type data)
          (name "J")
          (optional yes)
         )
         (input 11
          (type data)
          (name "K")
          (optional yes)
         )
         (output 1
          (type data)
          (name "Data")
          (lock name constraints)
         )
        )
        (implementation
        )
        (views
         (icon
          (origin 317 323)
          (extent 46 114)
         )
         (detail
         )
         (terminals on)
         (active icon)
        )
       )
       (component 1 "LITERALCONSTANT"
        (name "\"8\"")
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Text")
          (lock name constraints)
         )
        )
        (implementation
         (component value Text
          (name "\"8\"")
          (datum "8")
         )
         (component autoTrigger off)
         (component initializeAtPrerun off)
         (component initializeAtActivate off)
         (component initValue Text
          (name "CString")
          (datum "")
         )
        )
        (views
         (icon
          (origin 87 508)
          (extent 46 25)
         )
         (detail
          (origin 290 399)
          (extent 120 23)
         )
         (active icon)
        )
       )
       (component 2 "CONFIRM"
        (name "Cancel")
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Go")
          (lock name constraints)
         )
        )
        (implementation
        )
        (views
         (icon
          (origin 352 522)
          (extent 76 37)
         )
         (detail
          (origin 491 410)
          (extent 68 40)
         )
         (terminals on)
         (active icon)
        )
       )
       (component 3 "LITERALCONSTANT"
        (name "\"1\"")
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Text")
          (lock name constraints)
         )
        )
        (implementation
         (component value Text
          (name "\"1\"")
          (datum "1")
         )
         (component autoTrigger off)
         (component initializeAtPrerun off)
         (component initializeAtActivate off)
         (component initValue Text
          (name "CString")
          (datum "")
         )
        )
        (views
         (icon
          (origin 7 278)
          (extent 46 25)
         )
         (detail
          (origin 170 269)
          (extent 120 23)
         )
         (active icon)
        )
       )
       (component 4 "CONFIRM"
        (name " 2 ")
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Go")
          (lock name constraints)
         )
        )
        (implementation
        )
        (views
         (icon
          (origin 46 232)
          (extent 49 37)
         )
         (detail
          (origin 360 180)
          (extent 50 40)
         )
         (terminals on)
         (active icon)
        )
       )
       (component 5 "LITERALCONSTANT"
        (name "\"2\"")
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Text")
          (lock name constraints)
         )
        )
        (implementation
         (component value Text
          (name "\"2\"")
          (datum "2")
         )
         (component autoTrigger off)
         (component initializeAtPrerun off)
         (component initializeAtActivate off)
         (component initValue Text
          (name "CString")
          (datum "")
         )
        )
        (views
         (icon
          (origin 87 278)
          (extent 46 25)
         )
         (detail
          (origin 230 389)
          (extent 120 23)
         )
         (active icon)
        )
       )
       (component 6 "CONFIRM"
        (name " 3 ")
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Go")
          (lock name constraints)
         )
        )
        (implementation
        )
        (views
         (icon
          (origin 146 232)
          (extent 49 37)
         )
         (detail
          (origin 390 180)
          (extent 50 40)
         )
         (terminals on)
         (active icon)
        )
       )
       (component 7 "LITERALCONSTANT"
        (name "\"3\"")
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Text")
          (lock name constraints)
         )
        )
        (implementation
         (component value Text
          (name "\"3\"")
          (datum "3")
         )
         (component autoTrigger off)
         (component initializeAtPrerun off)
         (component initializeAtActivate off)
         (component initValue Text
          (name "CString")
          (datum "")
         )
        )
        (views
         (icon
          (origin 187 278)
          (extent 46 25)
         )
         (detail
          (origin 200 379)
          (extent 120 23)
         )
         (active icon)
        )
       )
       (component 8 "CONFIRM"
        (name " 4 ")
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Go")
          (lock name constraints)
         )
        )
        (implementation
        )
        (views
         (icon
          (origin -44 352)
          (extent 49 37)
         )
         (detail
          (origin 210 310)
          (extent 50 40)
         )
         (terminals on)
         (active icon)
        )
       )
       (component 9 "CONFIRM"
        (name " 5 ")
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Go")
          (lock name constraints)
         )
        )
        (implementation
        )
        (views
         (icon
          (origin 46 352)
          (extent 49 37)
         )
         (detail
          (origin 350 320)
          (extent 50 40)
         )
         (terminals on)
         (active icon)
        )
       )
       (component 10 "CONFIRM"
        (name " 6 ")
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Go")
          (lock name constraints)
         )
        )
        (implementation
        )
        (views
         (icon
          (origin 146 352)
          (extent 49 37)
         )
         (detail
          (origin 490 320)
          (extent 50 40)
         )
         (terminals on)
         (active icon)
        )
       )
       (component 11 "LITERALCONSTANT"
        (name "\"4\"")
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Text")
          (lock name constraints)
         )
        )
        (implementation
         (component value Text
          (name "\"4\"")
          (datum "4")
         )
         (component autoTrigger off)
         (component initializeAtPrerun off)
         (component initializeAtActivate off)
         (component initValue Text
          (name "CString")
          (datum "")
         )
        )
        (views
         (icon
          (origin -3 398)
          (extent 46 25)
         )
         (detail
          (origin 190 309)
          (extent 120 23)
         )
         (active icon)
        )
       )
       (component 12 "LITERALCONSTANT"
        (name "\"5\"")
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Text")
          (lock name constraints)
         )
        )
        (implementation
         (component value Text
          (name "\"5\"")
          (datum "5")
         )
         (component autoTrigger off)
         (component initializeAtPrerun off)
         (component initializeAtActivate off)
         (component initValue Text
          (name "CString")
          (datum "")
         )
        )
        (views
         (icon
          (origin 87 398)
          (extent 46 25)
         )
         (detail
          (origin 290 309)
          (extent 120 23)
         )
         (active icon)
        )
       )
       (component 13 "LITERALCONSTANT"
        (name "\"6\"")
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Text")
          (lock name constraints)
         )
        )
        (implementation
         (component value Text
          (name "\"6\"")
          (datum "6")
         )
         (component autoTrigger off)
         (component initializeAtPrerun off)
         (component initializeAtActivate off)
         (component initValue Text
          (name "CString")
          (datum "")
         )
        )
        (views
         (icon
          (origin 177 398)
          (extent 46 25)
         )
         (detail
          (origin 390 309)
          (extent 120 23)
         )
         (active icon)
        )
       )
       (component 14 "CONFIRM"
        (name " 7 ")
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Go")
          (lock name constraints)
         )
        )
        (implementation
        )
        (views
         (icon
          (origin -54 462)
          (extent 49 37)
         )
         (detail
          (origin 200 410)
          (extent 50 40)
         )
         (terminals on)
         (active icon)
        )
       )
       (component 15 "LITERALCONSTANT"
        (name "\"7\"")
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Text")
          (lock name constraints)
         )
        )
        (implementation
         (component value Text
          (name "\"7\"")
          (datum "7")
         )
         (component autoTrigger off)
         (component initializeAtPrerun off)
         (component initializeAtActivate off)
         (component initValue Text
          (name "CString")
          (datum "")
         )
        )
        (views
         (icon
          (origin -13 508)
          (extent 46 25)
         )
         (detail
          (origin 190 399)
          (extent 120 23)
         )
         (active icon)
        )
       )
       (component 16 "CONFIRM"
        (name " 8 ")
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Go")
          (lock name constraints)
         )
        )
        (implementation
        )
        (views
         (icon
          (origin 46 462)
          (extent 49 37)
         )
         (detail
          (origin 340 420)
          (extent 50 40)
         )
         (terminals on)
         (active icon)
        )
       )
       (component 17 "CONFIRM"
        (name " 9 ")
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Go")
          (lock name constraints)
         )
        )
        (implementation
        )
        (views
         (icon
          (origin 146 462)
          (extent 49 37)
         )
         (detail
          (origin 480 420)
          (extent 50 40)
         )
         (terminals on)
         (active icon)
        )
       )
       (component 18 "LITERALCONSTANT"
        (name "\"9\"")
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Text")
          (lock name constraints)
         )
        )
        (implementation
         (component value Text
          (name "\"9\"")
          (datum "9")
         )
         (component autoTrigger off)
         (component initializeAtPrerun off)
         (component initializeAtActivate off)
         (component initValue Text
          (name "CString")
          (datum "")
         )
        )
        (views
         (icon
          (origin 187 508)
          (extent 46 25)
         )
         (detail
          (origin 390 399)
          (extent 120 23)
         )
         (active icon)
        )
       )
       (component 19 "REPEATUNTILBREAK"
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Continuous")
          (lock name constraints)
         )
        )
        (implementation
        )
        (views
         (icon
          (origin -195 378)
          (extent 110 64)
          (iconImage "loop.icon")
         )
         (detail
         )
         (terminals on)
         (active icon)
        )
       )
       (component 20 "CONFIRM"
        (name " 0 ")
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Go")
          (lock name constraints)
         )
        )
        (implementation
        )
        (views
         (icon
          (origin -64 562)
          (extent 49 37)
         )
         (detail
          (origin 190 520)
          (extent 50 40)
         )
         (terminals on)
         (active icon)
        )
       )
       (component 21 "CONFIRM"
        (name " . ")
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Go")
          (lock name constraints)
         )
        )
        (implementation
        )
        (views
         (icon
          (origin 46 562)
          (extent 49 37)
         )
         (detail
          (origin 330 530)
          (extent 50 40)
         )
         (terminals on)
         (active icon)
        )
       )
       (component 22 "LITERALCONSTANT"
        (name "\".\"")
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Text")
          (lock name constraints)
         )
        )
        (implementation
         (component value Text
          (name "\".\"")
          (datum ".")
         )
         (component autoTrigger off)
         (component initializeAtPrerun off)
         (component initializeAtActivate off)
         (component initValue Text
          (name "CString")
          (datum "")
         )
        )
        (views
         (icon
          (origin 87 608)
          (extent 46 25)
         )
         (detail
          (origin 260 539)
          (extent 120 23)
         )
         (active icon)
        )
       )
       (component 23 "LITERALCONSTANT"
        (name "\"0\"")
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Text")
          (lock name constraints)
         )
        )
        (implementation
         (component value Text
          (name "\"0\"")
          (datum "0")
         )
         (component autoTrigger off)
         (component initializeAtPrerun off)
         (component initializeAtActivate off)
         (component initValue Text
          (name "CString")
          (datum "")
         )
        )
        (views
         (icon
          (origin -23 608)
          (extent 46 25)
         )
         (detail
          (origin 190 539)
          (extent 120 23)
         )
         (active icon)
        )
       )
       (component 24 "CONFIRM"
        (name "CE")
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Go")
          (lock name constraints)
         )
        )
        (implementation
        )
        (views
         (icon
          (origin 190 562)
          (extent 40 37)
         )
         (detail
          (origin 470 530)
          (extent 50 40)
         )
         (terminals on)
         (active icon)
        )
       )
       (component 25 "CONFIRM"
        (name " 1 ")
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Go")
          (lock name constraints)
         )
        )
        (implementation
        )
        (views
         (icon
          (origin -34 232)
          (extent 49 37)
         )
         (detail
          (origin 200 180)
          (extent 50 40)
         )
         (terminals on)
         (active icon)
        )
       )
       (component 26 "ESCAPE"
        (interface
         (sequence in)
        )
        (implementation
         (component code 0)
         (component message "Done")
        )
        (views
         (icon
         )
         (detail
          (origin 430 589)
          (extent 140 63)
         )
         (active detail)
        )
       )
       (component 27 "CONFIRM"
        (name "Accept")
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Go")
          (lock name constraints)
         )
        )
        (implementation
        )
        (views
         (icon
          (origin 412 202)
          (extent 76 37)
         )
         (detail
          (origin 631 180)
          (extent 68 40)
         )
         (terminals on)
         (active icon)
        )
       )
       (component 28 "EXITCONTEXT"
        (interface
         (sequence in)
        )
        (implementation
        )
        (views
         (icon
          (origin 458 248)
          (extent 145 25)
         )
         (detail
         )
         (terminals on)
         (active icon)
        )
       )
       (component 29 "ACCUMULATOR"
        (interface
         (sequence in)
         (sequence out)
         (input 1
          (type data)
          (name "Data")
          (tag "InData")
          (requires
           (shape "Scalar")
          )
          (lock name constraints)
         )
         (input 2
          (type control)
          (name "Clear")
          (lock name constraints)
          (optional yes)
         )
         (output 1
          (type data)
          (name "Data")
          (tag "accumData")
          (lock name constraints)
         )
        )
        (implementation
         (component clearAtPrerun 1)
         (component clearAtActivate 1)
        )
        (views
         (icon
         )
         (detail
          (origin 410 333)
          (extent 180 34)
         )
         (active detail)
        )
       )
       (component 30 "JUNCTION"
        (name "JCT")
        (interface
         (input 1
          (type data)
          (name "A")
          (lock name constraints)
         )
         (input 2
          (type data)
          (name "B")
          (lock name constraints)
         )
         (output 1
          (type data)
          (name "Data")
          (lock name constraints)
         )
        )
        (implementation
        )
        (views
         (icon
          (origin 617 348)
          (extent 46 25)
         )
         (detail
         )
         (terminals on)
         (active icon)
        )
       )
       (component 31 "ACCUMULATOR"
        (interface
         (sequence in)
         (sequence out)
         (input 1
          (type data)
          (name "Data")
          (tag "InData")
          (requires
           (shape "Scalar")
          )
          (lock name constraints)
         )
         (input 2
          (type control)
          (name "Clear")
          (lock name constraints)
          (optional yes)
         )
         (output 1
          (type data)
          (name "Data")
          (tag "accumData")
          (lock name constraints)
         )
        )
        (implementation
         (component clearAtPrerun 1)
         (component clearAtActivate 1)
        )
        (views
         (icon
         )
         (detail
          (origin 410 423)
          (extent 180 34)
         )
         (active detail)
        )
       )
       (component 32 "NEXT"
        (interface
         (sequence in)
        )
        (implementation
        )
        (views
         (icon
          (origin 477 468)
          (extent 46 25)
         )
         (detail
         )
         (terminals on)
         (active icon)
        )
       )
       (component 33 "LITERALCONSTANT"
        (name "\"*\"")
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Text")
          (lock name constraints)
         )
        )
        (implementation
         (component value Text
          (name "\"*\"")
          (datum "*")
         )
         (component autoTrigger off)
         (component initializeAtPrerun off)
         (component initializeAtActivate off)
         (component initValue Text
          (name "CString")
          (datum "")
         )
        )
        (views
         (icon
          (origin 317 458)
          (extent 46 25)
         )
         (detail
          (origin 500 219)
          (extent 120 23)
         )
         (active icon)
        )
       )
       (configuration
        (connect D3:1 D0:1)
        (connect D5:1 D0:2)
        (connect D7:1 D0:3)
        (connect D11:1 D0:4)
        (connect D12:1 D0:5)
        (connect D13:1 D0:6)
        (connect D15:1 D0:7)
        (connect D1:1 D0:8)
        (connect D18:1 D0:9)
        (connect D23:1 D0:10)
        (connect D22:1 D0:11)
        (connect D16:1 D1:0)
        (connect D25:1 D3:0)
        (connect D19:1 D4:0)
        (connect D4:1 D5:0)
        (connect D19:1 D6:0)
        (connect D6:1 D7:0)
        (connect D19:1 D8:0)
        (connect D19:1 D9:0)
        (connect D19:1 D10:0)
        (connect D8:1 D11:0)
        (connect D9:1 D12:0)
        (connect D10:1 D13:0)
        (connect D19:1 D14:0)
        (connect D14:1 D15:0)
        (connect D19:1 D16:0)
        (connect D19:1 D17:0)
        (connect D17:1 D18:0)
        (connect D19:1 D20:0)
        (connect D19:1 D21:0)
        (connect D21:1 D22:0)
        (connect D20:1 D23:0)
        (connect D19:1 D24:0)
        (connect D19:1 D25:0)
        (connect D2:1 D26:0)
        (connect D27:1 D28:0)
        (connect D0:1 D29:1)
        (connect D24:1 D29:2)
        (connect D29:1 D30:1)
        (connect D24:1 D30:2)
        (connect D29:0 D31:0)
        (connect D33:1 D31:1)
        (connect D24:1 D31:2)
        (connect D31:0 D32:0)
        (connect D0:1 D33:0)
        (connect D30:1 O1:1)
       )
      )
      (views
       (icon
        (origin 371 478)
        (extent 78 25)
       )
       (panel
        (origin 344 313)
        (extent 232 355)
        (widget 31 detail
         (title off)
         (origin 362 334)
         (extent 190 39)
        )
        (widget 2 icon
         (title off)
         (origin 366 609)
         (extent 76 37)
        )
        (widget 27 icon
         (title off)
         (origin 478 609)
         (extent 76 37)
        )
        (widget 25 icon
         (title off)
         (origin 362 390)
         (extent 49 37)
        )
        (widget 6 icon
         (title off)
         (origin 502 390)
         (extent 49 37)
        )
        (widget 4 icon
         (title off)
         (origin 430 390)
         (extent 49 37)
        )
        (widget 8 icon
         (title off)
         (origin 361 444)
         (extent 49 37)
        )
        (widget 10 icon
         (title off)
         (origin 501 443)
         (extent 49 37)
        )
        (widget 14 icon
         (title off)
         (origin 362 497)
         (extent 49 37)
        )
        (widget 17 icon
         (title off)
         (origin 501 497)
         (extent 49 37)
        )
        (widget 9 icon
         (title off)
         (origin 430 443)
         (extent 49 37)
        )
        (widget 16 icon
         (title off)
         (origin 431 495)
         (extent 49 37)
        )
        (widget 21 icon
         (title off)
         (origin 501 545)
         (extent 49 37)
        )
        (widget 20 icon
         (title off)
         (origin 431 545)
         (extent 49 37)
        )
        (widget 24 icon
         (title off)
         (origin 363 547)
         (extent 49 35)
        )
       )
       (detail
        (origin 378 237)
        (extent 924 487)
        (configuration
         (connect D3:1 D0:1
          (Point 55 290)
          (Point 70 290)
          (Point 70 320)
          (Point 120 320)
          (Point 120 210)
          (Point 260 210)
          (Point 260 330)
          (Point 314 330)
         )
         (connect D5:1 D0:2
          (Point 135 290)
          (Point 150 290)
          (Point 150 320)
          (Point 230 320)
          (Point 230 340)
          (Point 314 340)
         )
         (connect D7:1 D0:3
          (Point 235 290)
          (Point 250 290)
          (Point 250 350)
          (Point 314 350)
         )
         (connect D11:1 D0:4
          (Point 45 410)
          (Point 60 410)
          (Point 60 420)
          (Point 120 420)
          (Point 120 430)
          (Point 160 430)
          (Point 160 410)
          (Point 210 410)
          (Point 210 390)
          (Point 220 390)
          (Point 220 380)
          (Point 230 380)
          (Point 230 360)
          (Point 314 360)
         )
         (connect D12:1 D0:5
          (Point 135 410)
          (Point 150 410)
          (Point 150 400)
          (Point 140 400)
          (Point 140 390)
          (Point 130 390)
          (Point 130 330)
          (Point 220 330)
          (Point 220 370)
          (Point 314 370)
         )
         (connect D13:1 D0:6
          (Point 225 410)
          (Point 240 410)
          (Point 240 380)
          (Point 314 380)
         )
         (connect D15:1 D0:7
          (Point 35 520)
          (Point 50 520)
          (Point 50 540)
          (Point 80 540)
          (Point 80 550)
          (Point 220 550)
          (Point 220 400)
          (Point 250 400)
          (Point 250 390)
          (Point 314 390)
         )
         (connect D1:1 D0:8
          (Point 135 520)
          (Point 150 520)
          (Point 150 510)
          (Point 140 510)
          (Point 140 500)
          (Point 130 500)
          (Point 130 440)
          (Point 260 440)
          (Point 260 400)
          (Point 314 400)
         )
         (connect D18:1 D0:9
          (Point 235 520)
          (Point 250 520)
          (Point 250 410)
          (Point 314 410)
         )
         (connect D23:1 D0:10
          (Point 25 620)
          (Point 40 620)
          (Point 40 650)
          (Point 280 650)
          (Point 280 420)
          (Point 314 420)
         )
         (connect D22:1 D0:11
          (Point 135 620)
          (Point 270 620)
          (Point 270 430)
          (Point 314 430)
         )
         (connect D16:1 D1:0
          (Point 97 480)
          (Point 110 480)
          (Point 110 505)
         )
         (connect D25:1 D3:0
          (Point 17 250)
          (Point 30 250)
          (Point 30 275)
         )
         (connect D19:1 D4:0
          (Point -83 410)
          (Point -60 410)
          (Point -60 210)
          (Point 70 210)
          (Point 70 229)
         )
         (connect D4:1 D5:0
          (Point 97 250)
          (Point 110 250)
          (Point 110 275)
         )
         (connect D19:1 D6:0
          (Point -83 410)
          (Point -60 410)
          (Point -60 210)
          (Point 70 210)
          (Point 70 200)
          (Point 170 200)
          (Point 170 229)
         )
         (connect D6:1 D7:0
          (Point 197 250)
          (Point 210 250)
          (Point 210 275)
         )
         (connect D19:1 D8:0
          (Point -83 410)
          (Point -60 410)
          (Point -60 330)
          (Point -20 330)
          (Point -20 349)
         )
         (connect D19:1 D9:0
          (Point -83 410)
          (Point -60 410)
          (Point -60 330)
          (Point 70 330)
          (Point 70 349)
         )
         (connect D19:1 D10:0
          (Point -83 410)
          (Point -60 410)
          (Point -60 330)
          (Point 110 330)
          (Point 110 340)
          (Point 170 340)
          (Point 170 349)
         )
         (connect D8:1 D11:0
          (Point 7 370)
          (Point 20 370)
          (Point 20 395)
         )
         (connect D9:1 D12:0
          (Point 97 370)
          (Point 110 370)
          (Point 110 395)
         )
         (connect D10:1 D13:0
          (Point 197 370)
          (Point 210 370)
          (Point 210 380)
          (Point 200 380)
          (Point 200 395)
         )
         (connect D19:1 D14:0
          (Point -83 410)
          (Point -30 410)
          (Point -30 459)
         )
         (connect D14:1 D15:0
          (Point -3 480)
          (Point 10 480)
          (Point 10 505)
         )
         (connect D19:1 D16:0
          (Point -83 410)
          (Point -30 410)
          (Point -30 440)
          (Point 70 440)
          (Point 70 459)
         )
         (connect D19:1 D17:0
          (Point -83 410)
          (Point -30 410)
          (Point -30 440)
          (Point 110 440)
          (Point 110 450)
          (Point 170 450)
          (Point 170 459)
         )
         (connect D17:1 D18:0
          (Point 197 480)
          (Point 210 480)
          (Point 210 505)
         )
         (connect D19:1 D20:0
          (Point -83 410)
          (Point -70 410)
          (Point -70 520)
          (Point -40 520)
          (Point -40 559)
         )
         (connect D19:1 D21:0
          (Point -83 410)
          (Point -70 410)
          (Point -70 520)
          (Point -30 520)
          (Point -30 550)
          (Point 70 550)
          (Point 70 559)
         )
         (connect D21:1 D22:0
          (Point 97 580)
          (Point 110 580)
          (Point 110 605)
         )
         (connect D20:1 D23:0
          (Point -13 580)
          (Point 0 580)
          (Point 0 605)
         )
         (connect D19:1 D24:0
          (Point -83 410)
          (Point -30 410)
          (Point -30 440)
          (Point 110 440)
          (Point 110 450)
          (Point 120 450)
          (Point 120 540)
          (Point 200 540)
          (Point 200 550)
          (Point 210 550)
          (Point 210 559)
         )
         (connect D19:1 D25:0
          (Point -83 410)
          (Point -60 410)
          (Point -60 210)
          (Point -10 210)
          (Point -10 229)
         )
         (connect D2:1 D26:0
          (Point 430 540)
          (Point 500 540)
          (Point 500 558)
         )
         (connect D27:1 D28:0
          (Point 490 220)
          (Point 530 220)
          (Point 530 245)
         )
         (connect D0:1 D29:1
          (Point 365 380)
          (Point 380 380)
          (Point 380 340)
          (Point 407 340)
         )
         (connect D24:1 D29:2
          (Point 232 580)
          (Point 260 580)
          (Point 260 500)
          (Point 400 500)
          (Point 400 360)
          (Point 407 360)
         )
         (connect D29:1 D30:1
          (Point 592 350)
          (Point 614 350)
         )
         (connect D24:1 D30:2
          (Point 232 580)
          (Point 260 580)
          (Point 260 500)
          (Point 440 500)
          (Point 440 510)
          (Point 600 510)
          (Point 600 370)
          (Point 614 370)
         )
         (connect D29:0 D31:0
          (Point 500 369)
          (Point 500 392)
         )
         (connect D33:1 D31:1
          (Point 365 470)
          (Point 380 470)
          (Point 380 430)
          (Point 407 430)
         )
         (connect D24:1 D31:2
          (Point 232 580)
          (Point 260 580)
          (Point 260 500)
          (Point 400 500)
          (Point 400 450)
          (Point 407 450)
         )
         (connect D31:0 D32:0
          (Point 500 459)
          (Point 500 465)
         )
         (connect D0:1 D33:0
          (Point 365 380)
          (Point 380 380)
          (Point 380 420)
          (Point 370 420)
          (Point 370 450)
          (Point 340 450)
          (Point 340 455)
         )
         (connect D30:1 O1:1
          (Point 665 360)
          (Point 1299 360)
         )
        )
        (stackingOrder 0 1 2 3 4 5 6 7 8 9
          10 11 12 13 14 15 16 17 18 19
          20 21 22 23 24 25 26 27 28 29
          30 31 32 33)
       )
       (active icon)
      )
     )
     (component 6 "EXITPROCESS"
      (interface
       (sequence in)
      )
      (implementation
       (comp code 0)
      )
      (views
       (icon
        (origin 381 568)
        (extent 78 64)
        (iconImage "stop.icon")
       )
       (detail
        (origin 350 593)
        (extent 120 34)
       )
       (active icon)
      )
     )
     (component 9 "FROMGLOBAL"
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "Data")
        (tag "Data")
        (lock name constraints)
       )
      )
      (implementation
       (component globalName operator)
      )
      (views
       (icon
        (origin 455 308)
        (extent 110 25)
       )
       (detail
        (origin 182 240)
        (extent 97 61)
       )
       (terminals on)
       (active icon)
      )
     )
     (component 11 "CONSTANT"
      (name "Real")
      (subType "Real")
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "Real")
        (lock name constraints)
       )
      )
      (implementation
       (component value Real
        (name "Real")
        (datum 0)
       )
       (component autoTrigger off)
       (component initializeAtPrerun off)
       (component initializeAtActivate off)
       (component initValue Real
        (name "Real")
        (datum 0)
       )
      )
      (views
       (icon
        (origin 687 508)
        (extent 46 25)
       )
       (detail
        (origin 625 563)
        (extent 110 34)
        (showFormat real)
       )
       (active icon)
      )
     )
     (configuration
      (connect D1:1 D0:1)
      (connect D1:2 D0:2)
      (connect D1:3 D0:3)
      (connect D8:1 D0:4)
      (connect D5:1 D1:1)
      (connect D7:1 D2:1)
      (connect D4:1 D2:2)
      (connect D2:1 D3:1)
      (connect D3:0 D5:0)
      (connect D5:2 D6:0)
      (connect D1:4 D8:0)
      (connect D0:1 O1:1)
     )
     (ShowOnExecPanel
      (origin 313 200)
      (extent 353 499)
      (panel
       (origin 276 195)
       (extent 349 471)
       (widget 5 panel
        (title off)
        (origin 346 292)
        (extent 207 332)
        (widget 4 icon
         (title off)
         (origin 427 368)
         (extent 49 37)
        )
        (widget 6 icon
         (title off)
         (origin 483 368)
         (extent 49 37)
        )
        (widget 8 icon
         (title off)
         (origin 370 411)
         (extent 49 37)
        )
        (widget 9 icon
         (title off)
         (origin 427 411)
         (extent 49 37)
        )
        (widget 10 icon
         (title off)
         (origin 482 410)
         (extent 49 37)
        )
        (widget 14 icon
         (title off)
         (origin 370 453)
         (extent 49 37)
        )
        (widget 25 icon
         (title off)
         (origin 371 369)
         (extent 49 37)
        )
        (widget 16 icon
         (title off)
         (origin 427 452)
         (extent 49 37)
        )
        (widget 17 icon
         (title off)
         (origin 481 451)
         (extent 49 37)
        )
        (widget 20 icon
         (title off)
         (origin 426 494)
         (extent 49 37)
        )
        (widget 21 icon
         (title off)
         (origin 481 493)
         (extent 49 37)
        )
        (widget 24 icon
         (title off)
         (origin 370 495)
         (extent 49 35)
        )
        (widget 31 detail
         (title off)
         (origin 373 314)
         (extent 160 42)
        )
        (widget 2 icon
         (title off)
         (origin 453 554)
         (extent 76 37)
        )
        (widget 27 icon
         (title off)
         (origin 370 554)
         (extent 76 37)
        )
       )
       (widget 3 detail
        (title off)
        (origin 283 217)
        (extent 335 46)
       )
      )
     )
    )
    (views
     (detail
      (origin 345 259)
      (extent 483 398)
      (configuration
       (connect D1:1 D0:1
        (Point 637 500)
        (Point 660 500)
        (Point 660 470)
        (Point 754 470)
       )
       (connect D1:2 D0:2
        (Point 637 510)
        (Point 650 510)
        (Point 650 480)
        (Point 754 480)
       )
       (connect D1:3 D0:3
        (Point 637 520)
        (Point 670 520)
        (Point 670 490)
        (Point 754 490)
       )
       (connect D8:1 D0:4
        (Point 735 520)
        (Point 750 520)
        (Point 750 510)
        (Point 740 510)
        (Point 740 500)
        (Point 754 500)
       )
       (connect D5:1 D1:1
        (Point 451 480)
        (Point 470 480)
        (Point 470 520)
        (Point 522 520)
       )
       (connect D7:1 D2:1
        (Point 567 320)
        (Point 584 320)
       )
       (connect D4:1 D2:2
        (Point 678 420)
        (Point 700 420)
        (Point 700 360)
        (Point 570 360)
        (Point 570 340)
        (Point 584 340)
       )
       (connect D2:1 D3:1
        (Point 635 330)
        (Point 698 330)
       )
       (connect D3:0 D5:0
        (Point 760 345)
        (Point 760 360)
        (Point 740 360)
        (Point 740 460)
        (Point 410 460)
        (Point 410 475)
       )
       (connect D5:2 D6:0
        (Point 451 500)
        (Point 460 500)
        (Point 460 520)
        (Point 420 520)
        (Point 420 565)
       )
       (connect D1:4 D8:0
        (Point 637 530)
        (Point 680 530)
        (Point 680 500)
        (Point 710 500)
        (Point 710 505)
       )
       (connect D0:1 O1:1
        (Point 805 490)
        (Point 820 490)
        (Point 820 468)
        (Point 825 468)
       )
      )
      (stackingOrder 4 3 2 7 0 5 1 8 6)
     )
     (terminals on)
     (active detail)
    )
   )
   (context 7
    (name "PermissionDenied")
    (description 6 5
     This is the message box to inform them that
     the password was incorrect.  
     
     NOTE !!!  The HINT box would be removed before
     using this object in an actual situation.
     
    )
    (interface
     (sequence in)
     (sequence out)
    )
    (implementation
     (locked no)
     (trigMode deg)
     (nextID 3)
     (component 0 "NOTE"
      (interface
      )
      (implementation
       (component text 4 8
         
           Sorry, please enter
          another ID number, or 
              press CANCEL.
       )
      )
      (views
       (icon
        (iconImage "notepad.icon")
       )
       (detail
        (origin 460 375)
        (extent 180 90)
        (editing enabled)
       )
       (active detail)
      )
     )
     (component 1 "CONFIRM"
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "Go")
        (lock name constraints)
       )
      )
      (implementation
      )
      (views
       (icon
        (origin 601 542)
        (extent 58 37)
       )
       (detail
       )
       (terminals on)
       (active icon)
      )
     )
     (component 2 "NOTE"
      (name "Login Hint")
      (interface
      )
      (implementation
       (component text 4 8
         
            Joe....1234
            Fred...2345
           Sally...3456
       )
      )
      (views
       (icon
        (origin 625 228)
        (extent 110 64)
        (iconImage "notepad.icon")
       )
       (detail
        (origin 587 426)
        (extent 187 89)
        (editing enabled)
       )
       (active detail)
      )
     )
     (configuration
     )
     (ShowOnExecPanel
      (origin 284 201)
      (extent 407 508)
      (panel
       (origin 409 310)
       (extent 403 480)
       (widget 1 icon
        (title off)
        (origin 563 489)
        (extent 97 59)
       )
       (widget 2 detail
        (title on)
        (origin 522 638)
        (extent 187 89)
        (editing disabled)
       )
       (widget 0 detail
        (title off)
        (origin 489 354)
        (extent 241 101)
        (editing disabled)
       )
      )
     )
    )
    (views
     (detail
      (origin 445 329)
      (extent 334 275)
      (configuration
      )
      (stackingOrder 0 1 2)
     )
     (terminals on)
     (active detail)
    )
   )
  )
  (locked no)
  (trigMode deg)
  (nextID 75)
  (component 0 "EXITPROCESS"
   (interface
    (sequence in)
   )
   (implementation
    (comp code 0)
   )
   (views
    (icon
     (origin 321 468)
     (extent 78 64)
     (iconImage "stop.icon")
    )
    (detail
     (origin 70 563)
     (extent 120 34)
    )
    (active icon)
   )
  )
  (component 1 "REPEATUNTILBREAK"
   (name "Repeat Choices")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Continuous")
     (lock name constraints)
    )
   )
   (implementation
   )
   (views
    (icon
     (origin 22 338)
     (extent 136 64)
     (iconImage "/usr/lib/veetest/bitmaps/loop.icon")
    )
    (detail
     (origin 45 410)
     (extent 70 40)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 3 "TOFILE"
   (description 2 4
    This will clear the existing file and log
    the username via global variables.
   )
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (attr iopath file append "/tmp/mfgdata"
     (readTerm "\n")
     (fs "\n")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (procedure
      EXECUTE CLEAR
      WRITE TEXT "OPERATOR IS: ",operator EOL
      WRITE TEXT "            " STR EOL
    )
   )
   (views
    (icon
     (origin 51 273)
     (extent 78 34)
    )
    (detail
     (origin 32 261)
     (extent 457 178)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 7 "START"
   (interface
    (sequence out)
   )
   (implementation
   )
   (views
    (icon
     (origin 37 112)
     (extent 67 37)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 9 "CONTEXT"
   (name "Select a Choice")
   (description 12 4
    This object allows users to select multiple 
    choices.  We could have used an "Enum" choice
    box, but then the user could have only selected
    one at a time. 
    
    The "ALL TESTS" choice simply sends a 1 as the
    new default value to all other toggles.  
    
    The IF/THEN/ELSE objects will test the status
    of the TOGGLEs and either send the name of
    the test or a null string.  The COLLECTOR 
    just builds the test names into an array.
   )
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "TestVector")
     (lock constraints)
     (optional yes)
    )
    (output 2
     (type exception)
     (name "Error")
     (lock name constraints)
     (optional yes)
    )
   )
   (implementation
    (locked yes)
    (trigMode deg)
    (nextID 27)
    (component 0 "REPEATUNTILBREAK"
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Continuous")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 189 456)
       (extent 110 64)
       (iconImage "loop.icon")
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "TOGGLE"
     (name "Generate Report")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Default Value")
       (requires
        (datatype Int32)
        (shape "Scalar")
       )
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (name "Toggle")
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Generate Report")
       (datum 0)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate on)
      (component initValue Int32
       (name "LongInt")
       (datum 0)
      )
     )
     (views
      (icon
       (origin 358 595)
       (extent 192 27)
       (format check box)
      )
      (detail
       (origin 390 570)
       (extent 40 60)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "TOGGLE"
     (name "Test #2        ")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Default Value")
       (requires
        (datatype Int32)
        (shape "Scalar")
       )
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (name "Toggle")
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Test #2        ")
       (datum 0)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate on)
      (component initValue Int32
       (name "LongInt")
       (datum 0)
      )
     )
     (views
      (icon
       (origin 358 495)
       (extent 192 27)
       (format check box)
      )
      (detail
       (origin 250 440)
       (extent 44 60)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 3 "TOGGLE"
     (name "Test #1        ")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Default Value")
       (requires
        (datatype Int32)
        (shape "Scalar")
       )
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (name "Toggle")
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Test #1        ")
       (datum 0)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate on)
      (component initValue Int32
       (name "LongInt")
       (datum 0)
      )
     )
     (views
      (icon
       (origin 358 445)
       (extent 192 27)
       (format check box)
      )
      (detail
       (origin 250 390)
       (extent 40 60)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 4 "CONFIRM"
     (name "All Tests")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Go")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 183 550)
       (extent 103 37)
      )
      (detail
       (origin 378 550)
       (extent 95 40)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 5 "CONSTANT"
     (name "1")
     (subType "Integer")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Int32")
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "1")
       (datum 1)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (name "LongInt")
       (datum 0)
      )
     )
     (views
      (icon
       (origin 271 596)
       (extent 46 25)
      )
      (detail
       (origin 75 464)
       (extent 150 32)
       (showFormat int)
      )
      (active icon)
     )
    )
    (component 6 "TOGGLE"
     (name "Test #3        ")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Default Value")
       (requires
        (datatype Int32)
        (shape "Scalar")
       )
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (name "Toggle")
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Test #3        ")
       (datum 0)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate on)
      (component initValue Int32
       (name "LongInt")
       (datum 0)
      )
     )
     (views
      (icon
       (origin 358 545)
       (extent 192 27)
       (format check box)
      )
      (detail
       (origin 280 510)
       (extent 47 60)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 7 "EXITCONTEXT"
     (interface
      (sequence in)
     )
     (implementation
     )
     (views
      (icon
       (origin 192 406)
       (extent 145 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 8 "CONFIRM"
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Go")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 235 360)
       (extent 58 37)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 9 "CONFIRM"
     (name "Exit")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Go")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 475 360)
       (extent 58 37)
      )
      (detail
       (origin 241 550)
       (extent 68 40)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 10 "ESCAPE"
     (interface
      (sequence in)
     )
     (implementation
      (component code 0)
      (component message "")
     )
     (views
      (icon
       (origin 555 386)
       (extent 118 24)
      )
      (detail
       (origin 166 639)
       (extent 149 63)
      )
      (active icon)
     )
    )
    (component 18 "COLLECTOR"
     (description 7 6
      A collector is the easiest way to build a 1D
      array in VEE.  We must build the result into
      an array to pass the information out of the
      UserObject.  Also, the Sequencer requires an
      array of strings for its EXEC TRANS (execute
      transaction) terminal.
      
     )
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
       (tag "Data")
      )
      (input 2
       (type trigger)
       (name "XEQ")
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "Array")
       (tag "Array")
       (lock constraints)
      )
     )
     (implementation
      (component clearAtPrerun 1)
      (component clearAtActivate 1)
      (component output1D NO)
     )
     (views
      (icon
       (origin 859 466)
       (extent 110 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 19 "IFTHENELSE"
     (description 10 6
      All 4 of the IF/THEN/ELSE objects include an
      evaluation, multiplied by a result to pass.
      
      ie,  (a==1)*"TRUE"    would send a TRUE if a=1.
      
      If this required a true or false decision, we
      could have used TRIADIC operators inside of a 
      formula box to pass either a TRUE or FALSE 
      statement.
      
     )
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "(a==1)*\"Test1\"")
     )
     (views
      (icon
       (origin 595 436)
       (extent 118 25)
      )
      (detail
       (origin 638 254)
       (extent 154 72)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 20 "JUNCTION"
     (name "JCT")
     (interface
      (input 1
       (type data)
       (name "A")
       (lock name constraints)
      )
      (input 2
       (type data)
       (name "B")
       (lock name constraints)
      )
      (input 3
       (type data)
       (name "C")
       (optional yes)
      )
      (input 4
       (type data)
       (name "D")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Data")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 751 466)
       (extent 46 45)
      )
      (detail
       (origin 670 308)
       (extent 10 204)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 21 "IFTHENELSE"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "(a==1)*\"Test2\"")
     )
     (views
      (icon
       (origin 595 486)
       (extent 118 25)
      )
      (detail
       (origin 478 384)
       (extent 154 72)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 22 "IFTHENELSE"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "(a==1)*\"Test3\"")
     )
     (views
      (icon
       (origin 595 536)
       (extent 118 25)
      )
      (detail
       (origin 478 434)
       (extent 154 72)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 23 "IFTHENELSE"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "(a==1)*\"Report\"")
     )
     (views
      (icon
       (origin 605 596)
       (extent 118 25)
      )
      (detail
       (origin 184 544)
       (extent 163 72)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 24 "IFTHENELSE"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "strposchar(a,\"T\")==-1 AND strposchar(a,\"R\")==-1")
     )
     (views
      (icon
       (origin 905 546)
       (extent 118 25)
      )
      (detail
       (origin 310 384)
       (extent 451 72)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 26 "ESCAPE"
     (interface
      (sequence in)
     )
     (implementation
      (component code 0)
      (component message "")
     )
     (views
      (icon
       (origin 975 586)
       (extent 118 24)
      )
      (detail
       (origin 166 639)
       (extent 149 63)
      )
      (active icon)
     )
    )
    (configuration
     (connect D6:0 D1:0)
     (connect D5:1 D1:1)
     (connect D3:0 D2:0)
     (connect D5:1 D2:1)
     (connect D8:1 D3:0)
     (connect D5:1 D3:1)
     (connect D0:1 D4:0)
     (connect D4:1 D5:0)
     (connect D2:0 D6:0)
     (connect D5:1 D6:1)
     (connect D8:0 D7:0)
     (connect D9:1 D10:0)
     (connect D13:1 D11:1)
     (connect D1:0 D11:2)
     (connect D3:1 D12:1)
     (connect D12:1 D13:1)
     (connect D14:1 D13:2)
     (connect D15:1 D13:3)
     (connect D16:1 D13:4)
     (connect D2:1 D14:1)
     (connect D6:1 D15:1)
     (connect D1:1 D16:1)
     (connect D11:1 D17:1)
     (connect D17:1 D18:0)
     (connect D11:1 O1:1)
    )
    (ShowOnExecPanel
     (origin 315 259)
     (extent 356 261)
     (panel
      (origin 214 324)
      (extent 352 233)
      (widget 4 icon
       (title off)
       (origin 448 369)
       (extent 103 37)
      )
      (widget 6 icon
       (title off)
       (origin 232 410)
       (extent 192 27)
       (format check box)
      )
      (widget 1 icon
       (title off)
       (origin 231 447)
       (extent 192 27)
       (format check box)
      )
      (widget 8 icon
       (title off)
       (origin 308 497)
       (extent 58 37)
      )
      (widget 9 icon
       (title off)
       (origin 418 499)
       (extent 58 37)
      )
      (widget 3 icon
       (title off)
       (origin 232 337)
       (extent 192 27)
       (format check box)
      )
      (widget 2 icon
       (title off)
       (origin 232 374)
       (extent 192 27)
       (format check box)
      )
     )
    )
   )
   (views
    (icon
     (origin 138 418)
     (extent 145 45)
    )
    (detail
     (origin 161 279)
     (extent 438 303)
     (configuration
      (connect D6:0 D1:0
       (Point 454 574)
       (Point 454 592)
      )
      (connect D5:1 D1:1
       (Point 319 608)
       (Point 355 608)
      )
      (connect D3:0 D2:0
       (Point 454 474)
       (Point 454 492)
      )
      (connect D5:1 D2:1
       (Point 319 608)
       (Point 334 608)
       (Point 334 508)
       (Point 355 508)
      )
      (connect D8:1 D3:0
       (Point 295 378)
       (Point 454 378)
       (Point 454 442)
      )
      (connect D5:1 D3:1
       (Point 319 608)
       (Point 334 608)
       (Point 334 458)
       (Point 355 458)
      )
      (connect D0:1 D4:0
       (Point 301 488)
       (Point 314 488)
       (Point 314 538)
       (Point 234 538)
       (Point 234 547)
      )
      (connect D4:1 D5:0
       (Point 288 568)
       (Point 294 568)
       (Point 294 593)
      )
      (connect D2:0 D6:0
       (Point 454 524)
       (Point 454 542)
      )
      (connect D5:1 D6:1
       (Point 319 608)
       (Point 334 608)
       (Point 334 558)
       (Point 355 558)
      )
      (connect D8:0 D7:0
       (Point 264 399)
       (Point 264 403)
      )
      (connect D9:1 D10:0
       (Point 535 378)
       (Point 544 378)
       (Point 544 368)
       (Point 614 368)
       (Point 614 383)
      )
      (connect D13:1 D11:1
       (Point 799 488)
       (Point 814 488)
       (Point 814 468)
       (Point 856 468)
      )
      (connect D1:0 D11:2
       (Point 454 624)
       (Point 454 638)
       (Point 824 638)
       (Point 824 488)
       (Point 856 488)
      )
      (connect D3:1 D12:1
       (Point 552 458)
       (Point 574 458)
       (Point 574 448)
       (Point 592 448)
      )
      (connect D12:1 D13:1
       (Point 715 438)
       (Point 734 438)
       (Point 734 468)
       (Point 748 468)
      )
      (connect D14:1 D13:2
       (Point 715 488)
       (Point 734 488)
       (Point 734 478)
       (Point 748 478)
      )
      (connect D15:1 D13:3
       (Point 715 538)
       (Point 734 538)
       (Point 734 488)
       (Point 748 488)
      )
      (connect D16:1 D13:4
       (Point 725 598)
       (Point 744 598)
       (Point 744 528)
       (Point 724 528)
       (Point 724 498)
       (Point 748 498)
      )
      (connect D2:1 D14:1
       (Point 552 508)
       (Point 574 508)
       (Point 574 498)
       (Point 592 498)
      )
      (connect D6:1 D15:1
       (Point 552 558)
       (Point 574 558)
       (Point 574 548)
       (Point 592 548)
      )
      (connect D1:1 D16:1
       (Point 552 608)
       (Point 602 608)
      )
      (connect D11:1 D17:1
       (Point 971 478)
       (Point 984 478)
       (Point 984 508)
       (Point 884 508)
       (Point 884 558)
       (Point 902 558)
      )
      (connect D17:1 D18:0
       (Point 1025 548)
       (Point 1034 548)
       (Point 1034 583)
      )
      (connect D11:1 O1:1
       (Point 971 478)
       (Point 979 478)
       (Point 979 353)
       (Point 589 353)
       (Point 589 360)
       (Point 596 360)
      )
     )
     (stackingOrder 0 1 2 3 4 5 6 7 8 9
       13 11 12 14 15 10 16 17 18)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 16 "CONTEXT"
   (name "Press For")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (locked no)
    (trigMode deg)
    (nextID 4)
    (component 0 "IFTHENELSE"
     (name "!= 0")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a!=0")
     )
     (views
      (icon
       (origin 565 340)
       (extent 46 25)
      )
      (detail
       (origin 209 308)
       (extent 73 64)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "TOGGLE"
     (name "Info About")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Reset")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Info About")
       (values range 0 1)
       (datum 0)
      )
      (component autoTrigger on)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (name "LongInt")
       (datum 0)
      )
     )
     (views
      (icon
       (origin 401 333)
       (extent 114 39)
       (format button)
      )
      (detail
       (origin 320 203)
       (extent 42 54)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "REPEATUNTILBREAK"
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Continuous")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 315 248)
       (extent 110 64)
       (iconImage "loop.icon")
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 3 "CONTEXT"
     (name "Info About This Example")
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (locked no)
      (trigMode deg)
      (nextID 2)
      (component 0 "CONFIRM"
       (name "DONE")
       (description 7 8
        This tiny "thread" begins running when the 
        enclosing UserObject is executed.  When the user
        acknowledges the OK/DONE button, there is nothing
        left to execute, so the thread ends.  Since there
        are not other threads running, the User Object
        is completed and will exit, removing the Show on
        Execute pop-up display.
       )
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 621 472)
         (extent 58 37)
        )
        (detail
         (origin 156 253)
         (extent 79 34)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "NOTE"
       (name "NotePad")
       (description 2 8
        This notepad is displayed as a Show on Execute
        panel to present the information to the reader.
       )
       (interface
       )
       (implementation
        (component text 31 9
         PURPOSE:  To illustrate how a manufacturing test system might be designed using VEE 2.0.
         
         HP VEE 2.0:  This example is an updated version of a previous example that was shipped
                      with HP VEE 1.0.  To see this example implemented with User Objects and 
                      no UserFunctions or Sequencers, please access the example:  mfgtst1.ex
         
                      This update increased performance of this example by approx. 30-50%.
         
         AUTO RUN:    Another version of this example is included in that will load and run
                      continuously, without user prompts.  That example is stored under 
                      mfgauto.ex
         
         USER INPUT REQUIRED: Press Start (or Run) and answer the prompts.
         
         EXPLANATION:  The following simulated tests are available in this example:
         
                       TEST #1:  Takes 50 random points and plots the results as they are taken.
         
                       TEST #2:  Tests 30 waveforms with random noise against an upper limit,
                                 recording the coordinates that failed and percent of failures.
         
                       TEST #3   Determines the distribution of 100 random numbers and plots a
                                 barchart of the results.  A threshold, manually set, determines
                                 the color of each bar for Pass/Fail indication.  This test
                                 is actually kept on disk and is loaded when test3 is called.
         
         
                       REPORT:   At any time, a report of the previously run tests can be shown,
                                 including the OPERATOR, timestamp when test was run, and the
                                 logged output from each test.  The Report is cleared each time
                                 after it is displayed.
        )
       )
       (views
        (icon
         (origin 610 405)
         (extent 78 25)
        )
        (detail
         (origin 225 199)
         (extent 848 437)
         (editing disabled)
        )
        (active detail)
       )
      )
      (configuration
      )
      (ShowOnExecPanel
       (origin 61 130)
       (extent 849 561)
       (panel
        (origin 238 154)
        (extent 845 533)
        (widget 0 icon
         (title off)
         (origin 637 639)
         (extent 58 37)
        )
        (widget 1 detail
         (title off)
         (origin 245 165)
         (extent 832 463)
         (editing enabled)
        )
       )
      )
     )
     (views
      (icon
       (origin 552 408)
       (extent 217 25)
      )
      (detail
       (origin 217 150)
       (extent 866 520)
       (configuration
       )
       (stackingOrder 0 1)
      )
      (active icon)
     )
    )
    (configuration
     (connect D1:1 D0:1)
     (connect D2:1 D1:0)
     (connect D3:0 D1:1)
     (connect D0:1 D3:0)
    )
   )
   (views
    (icon
     (origin 615 408)
     (extent 110 25)
    )
    (panel
     (origin 202 188)
     (extent 276 85)
     (widget 1 icon
      (title off)
      (origin 283 209)
      (extent 114 39)
      (format button)
     )
    )
    (detail
     (origin 204 105)
     (extent 912 591)
     (configuration
      (connect D1:1 D0:1
       (Point 517 352)
       (Point 562 352)
      )
      (connect D2:1 D1:0
       (Point 427 280)
       (Point 458 280)
       (Point 458 330)
      )
      (connect D3:0 D1:1
       (Point 660 435)
       (Point 660 450)
       (Point 380 450)
       (Point 380 352)
       (Point 398 352)
      )
      (connect D0:1 D3:0
       (Point 613 342)
       (Point 660 342)
       (Point 660 405)
      )
     )
     (stackingOrder 0 1 2 3)
    )
    (active panel)
    (active panel)
   )
  )
  (component 26 "NOTE"
   (interface
   )
   (implementation
   )
   (views
    (icon
     (origin 161 86)
     (extent 338 48)
     (label off)
     (iconImage "/usr/lib/veetest/bitmaps/disclaim.icon")
    )
    (detail
     (origin 830 250)
     (extent 200 100)
     (editing enabled)
    )
    (active icon)
   )
  )
  (component 39 "SEQUENCER"
   (description 8 4
    This sequencer takes advantage of the EXEC TRANS
    control pin.  This allows users to step through
    the prescribed tests, without testing the
    returned values.  For an example of a sequencer
    testing returned values and then calling another
    test, look at the Login Control object on this
    example.  
    
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type control)
     (name "Exec Trans")
     (requires
      (datatype Text)
     )
     (lock name constraints)
     (optional yes)
    )
    (output 1
     (type data)
     (name "Return")
     (tag "Return")
     (lock name constraints)
     (optional yes)
    )
    (output 2
     (type data)
     (name "Log")
     (tag "Log")
     (lock name constraints)
     (optional yes)
    )
   )
   (implementation
    (component logfields "name" "pass" "result")
    (procedure
      test1 EXECEX:test1() 	//Show Points/Analyze
      test2 EXECEX:test2() 	//Waveform Test
      test3 EXECEX:test3() 	//Bar Display from Disk
      report EXECEX:report() 	//Show Data from Tests
    )
   )
   (views
    (icon
     (origin 365 408)
     (extent 110 25)
    )
    (detail
     (origin 226 427)
     (extent 308 107)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 52 "SEQUENCER"
   (name "Login Control")
   (description 9 4
    This is a sequencer whose purpose is to step 
    through the user login dialog.  This sequence
    will first call the function UserName to 
    prompt for a name, and then carry the name
    via global variables to a password routine
    to confirm access.
    
    Notice the second transaction and the differences
    between a PASS flag and a FAIL flag.  
   )
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Return")
     (tag "Return")
     (lock name constraints)
     (optional yes)
    )
    (output 2
     (type data)
     (name "Log")
     (tag "Log")
     (lock name constraints)
     (optional yes)
    )
   )
   (implementation
    (component logfields "name" "pass" "result")
    (procedure
      getname EXECEX:username() 	//User Login Prompt
      validate LOGEN TESTEX:checkpassword() 	LIMITEX: 1 EQ 1 	PASSOP CALLEX:passwordaccepted() 	FAILOP CALLEX:permissiondenied() TGOTO:validate //Password Verification
    )
   )
   (views
    (icon
     (origin 7 208)
     (extent 127 25)
    )
    (detail
     (origin 31 157)
     (extent 498 126)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 74 "CONFIRM"
   (name "Run All")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Go")
     (lock name constraints)
    )
   )
   (implementation
   )
   (views
    (icon
     (origin 288 362)
     (extent 85 37)
    )
    (detail
     (origin 263 339)
     (extent 65 42)
    )
    (terminals on)
    (active icon)
   )
  )
  (configuration
   (connect D4:2 D0:0)
   (connect D2:0 D1:0)
   (connect D8:0 D2:0)
   (connect D1:1 D4:0)
   (connect D9:1 D7:0)
   (connect D4:1 D7:1)
   (connect D3:0 D8:0)
  )
 )
 (views
  (panel
   (origin 0 62)
   (extent 1000 660)
   (widget 3 icon
    (title off)
    (origin 378 72)
    (extent 178 101)
   )
   (widget 5 panel
    (title on)
    (origin 3 90)
    (extent 276 85)
    (widget 1 icon
     (title off)
     (origin 84 111)
     (extent 114 39)
     (format button)
    )
   )
   (widget 6 icon
    (title off)
    (origin 653 87)
    (extent 338 48)
    (label off)
    (iconImage "/usr/lib/veetest/bitmaps/disclaim.icon")
   )
  )
  (detail
   (origin 0 62)
   (extent 867 631)
   (configuration
    (connect D4:2 D0:0
     (Point 285 450)
     (Point 360 450)
     (Point 360 465)
    )
    (connect D2:0 D1:0
     (Point 90 309)
     (Point 90 335)
    )
    (connect D8:0 D2:0
     (Point 70 235)
     (Point 70 250)
     (Point 90 250)
     (Point 90 270)
    )
    (connect D1:1 D4:0
     (Point 160 370)
     (Point 210 370)
     (Point 210 415)
    )
    (connect D9:1 D7:0
     (Point 375 380)
     (Point 420 380)
     (Point 420 405)
    )
    (connect D4:1 D7:1
     (Point 285 430)
     (Point 300 430)
     (Point 300 420)
     (Point 362 420)
    )
    (connect D3:0 D8:0
     (Point 70 151)
     (Point 70 205)
    )
   )
   (stackingOrder 5 6 0 4 1 2 8 3 7 9)
  )
  (active panel)
  (active panel)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
