#! /usr/lib/veetest/veetest -r
(revision "B.00.00")
(date "Tue 15/Sep/1992")
(component 0 "ROOTCONTEXT"
 (name "Using Wait For SRQ")
 (interface
 )
 (implementation
  (locked no)
  (trigMode deg)
  (component 0 "ONCYCLE"
   (name "On Cycle")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component cycle 2)
   )
   (views
    (icon
     (origin 235 318)
     (extent 110 64)
     (iconImage "loop.icon")
    )
    (detail
     (origin 230 603)
     (extent 160 34)
    )
    (active detail)
   )
  )
  (component 1 "ONCYCLE"
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component cycle 1)
   )
   (views
    (icon
     (origin 55 498)
     (extent 110 64)
     (iconImage "loop.icon")
    )
    (detail
     (origin 230 683)
     (extent 160 34)
    )
    (active detail)
   )
  )
  (component 2 "REPEATUNTILBREAK"
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Continuous")
     (lock name constraints)
    )
   )
   (implementation
   )
   (views
    (icon
     (origin 505 208)
     (extent 110 64)
     (iconImage "loop.icon")
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 3 "NOTE"
   (name "Threads #2 & #3")
   (interface
   )
   (implementation
    (component text 7 5
     These threads just 
     count at different 
     rates.  They are here
     to show that other
     threads continue to 
     execute while a Wait
     For SRQ is pending.
    )
   )
   (views
    (icon
     (extent 145 0)
    )
    (detail
     (origin 5 581)
     (extent 210 139)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 4 "COUNTER"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
    (output 1
     (type data)
     (name "Count")
     (tag "Count")
     (lock name constraints)
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (origin 411 688)
     (extent 78 25)
    )
    (detail
     (origin 155 513)
     (extent 150 34)
    )
    (active icon)
   )
  )
  (component 5 "COUNTER"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
    (output 1
     (type data)
     (name "Count")
     (tag "Count")
     (lock name constraints)
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (origin 411 608)
     (extent 78 25)
    )
    (detail
     (origin 205 533)
     (extent 150 34)
    )
    (active icon)
   )
  )
  (component 6 "TEXTDISPLAY"
   (name "Number")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 78 0)
    )
    (detail
     (origin 515 603)
     (extent 111 35)
    )
    (active detail)
   )
  )
  (component 7 "TEXTDISPLAY"
   (name "Number")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 78 0)
    )
    (detail
     (origin 515 683)
     (extent 111 35)
    )
    (active detail)
   )
  )
  (component 8 "NOTE"
   (name "Thread #4")
   (interface
   )
   (implementation
    (component text 2 5
     This thread
     services SRQs.
    )
   )
   (views
    (icon
     (origin 805 358)
     (extent 110 25)
    )
    (detail
     (origin 786 307)
     (extent 148 46)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 9 "NOTE"
   (name "Thread #1")
   (interface
   )
   (implementation
    (component text 4 5
     This thread simply
     sets up the instruments
     and enables them to
     generate SRQs.
    )
   )
   (views
    (icon
     (extent 110 0)
    )
    (detail
     (origin 11 446)
     (extent 218 88)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 10 "NOTE"
   (name "Info About")
   (interface
   )
   (implementation
    (component text 62 5
     Overview:
     This model shows how to service interrupts using
     the "Wait For SRQ" object.  
     
     Details:
     This model uses the HP 54504A oscilloscope and the
     HP 3478A voltmeter to generate interrupts.  You
     MUST have these instruments connected to your
     computer to actually run this model. However,
     the techniques illustrated here apply to any
     instruments.
     
     Note that you must properly configure your 
     instruments before running this model using
     "I/O-->Configure I/O" menu selection.
     
     This is how to operate the model:
     
     1. Click on "Run" in the HP VEE title bar. This 
        way, all threads will operate simultaneously
        to illustrate how execution time is shared among
        threads.  You may wish to set
                 "Edit-->Show Exec Flow"
        to more clearly reveal this behavior.
     
     2. Press the SRQ front panel button on the
        HP 3478A or any key on the front panel of the 
        HP 54504A.
     
     This is how the model works:
     
     When you click on "Run", HP VEE starts executing
     each thread.  Thread #1 resets the instruments
     and configures them to generate service requests
     (SRQs).  The HP 3478A will generate an SRQ when
     you press its SRQ front panel button; the HP 54504A
     will generate an SRQ when you press any of its
     front panel buttons.  Threads #2 & #3 continuously
     count at one and two second intervals respectively.
     Thread #4 waits for an SRQ and reports the 
     identity of the requesting device when an SRQ is
     received. 
     
     Note that Threads #2 & #3 continue to count while
     the "Wait For SRQ" is pending.  Once "Wait For SRQ"
     detects an SRQ, the subthread attached to it
     executes to the exclusion of all others; counting
     on Threads #2 & #3 does not resume until the
     SRQ has been serviced.
     
     Note that different steps are required to re-enable
     interrupts for different instruments as shown in
     Thread #4.  The HP 3478A requires only a serial
     poll to clear the RQS bit of the status byte and
     thus re-enable interrupts.  This is typical of 
     older, simpler instruments.  The HP 54504A requires
     the additional step of clearing the event register
     that records front panel key press events.  This
     behavior is typical of more modern, complex 
     instruments.  READ YOUR INSTRUMENT PROGRAMMING
     MANUAL CAREFULLY.
     
    )
   )
   (views
    (icon
     (extent 110 0)
    )
    (detail
     (origin 6 111)
     (extent 488 259)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 11 "NOTE"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 4 5
     This example is provided as an
     illustration "as is", and Hewlett-Packard
     Company makes no warranty of any kind
     with regard to this example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 572 119)
     (extent 397 82)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 12 "IFTHENELSE"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Then")
     (lock name constraints)
    )
    (output 2
     (type data)
     (name "Else")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr "bit(a,6)")
   )
   (views
    (icon
     (origin 831 518)
     (extent 78 25)
    )
    (detail
     (origin 551 455)
     (extent 149 70)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 13 "CONTEXT"
   (name "HP 54504 did it")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (locked no)
    (trigMode deg)
    (component 0 "LITERALCONSTANT"
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Text")
       (lock name constraints)
      )
     )
     (implementation
      (component value Text
       (datum "SRQ from HP 54504A")
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Text
       (datum "")
      )
     )
     (views
      (icon
       (origin 607 518)
       (extent 46 25)
      )
      (detail
       (origin 430 416)
       (extent 201 28)
      )
      (active icon)
     )
    )
    (component 1 "CONFIRM"
     (name "Press To Continue...")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Go")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 669 592)
       (extent 202 37)
      )
      (detail
       (origin 608 460)
       (extent 194 40)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "TEXTDISPLAY"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
      )
     )
     (implementation
      (component clearAtPrerun 1)
      (component clearAtActivate 1)
     )
     (views
      (icon
      )
      (detail
       (origin 675 513)
       (extent 190 35)
      )
      (active detail)
     )
    )
    (configuration
     (connect D2:0 D1:0)
     (connect D0:1 D2:1)
    )
    (ShowOnExecPanel
     (origin 328 225)
     (extent 346 272)
     (panel
      (origin 589 473)
      (extent 342 234)
      (widget 2 detail
       (title off)
       (origin 609 516)
       (extent 305 42)
      )
      (widget 1 icon
       (title off)
       (origin 662 583)
       (extent 202 37)
      )
     )
    )
   )
   (views
    (icon
     (origin 828 668)
     (extent 145 25)
    )
    (detail
     (origin 589 453)
     (extent 322 214)
     (configuration
      (connect D2:0 D1:0
       (Point 770 550)
       (Point 770 559)
       (Point 770 589)
      )
      (connect D0:1 D2:1
       (Point 655 530)
       (Point 672 530)
      )
     )
     (stackingOrder 0 1 2)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 14 "CONTEXT"
   (name "Unknown did it")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (locked no)
    (trigMode deg)
    (component 0 "CONFIRM"
     (name "Press To Continue...")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Go")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 579 592)
       (extent 202 37)
      )
      (detail
       (origin 608 460)
       (extent 194 40)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "TEXTDISPLAY"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
      )
     )
     (implementation
      (component clearAtPrerun 1)
      (component clearAtActivate 1)
     )
     (views
      (icon
      )
      (detail
       (origin 585 513)
       (extent 190 35)
      )
      (active detail)
     )
    )
    (component 2 "LITERALCONSTANT"
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Text")
       (lock name constraints)
      )
     )
     (implementation
      (component value Text
       (datum "SRQ from unknown device")
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Text
       (datum "")
      )
     )
     (views
      (icon
       (origin 517 518)
       (extent 46 25)
      )
      (detail
       (origin 430 486)
       (extent 201 28)
      )
      (active icon)
     )
    )
    (configuration
     (connect D1:0 D0:0)
     (connect D2:1 D1:1)
    )
    (ShowOnExecPanel
     (panel
      (origin 579 503)
      (extent 342 234)
      (widget 1 detail
       (title off)
       (origin 599 546)
       (extent 305 42)
      )
      (widget 0 icon
       (title off)
       (origin 652 613)
       (extent 202 37)
      )
     )
    )
   )
   (views
    (icon
     (origin 662 668)
     (extent 136 25)
    )
    (detail
     (origin 499 453)
     (extent 322 214)
     (configuration
      (connect D1:0 D0:0
       (Point 680 550)
       (Point 680 559)
       (Point 680 589)
      )
      (connect D2:1 D1:1
       (Point 565 530)
       (Point 582 530)
      )
     )
     (stackingOrder 0 1 2)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 15 "IODEVICE"
   (name "Clear ESR")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (comp iopath "scope")
    (procedure
      WRITE TEXT "*ESR?" EOL
    )
   )
   (views
    (icon
     (origin 865 578)
     (extent 110 64)
     (iconImage "io.icon")
    )
    (detail
     (origin 316 458)
     (extent 308 105)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 16 "CONTEXT"
   (name "HP 3478 did it")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (locked no)
    (trigMode deg)
    (component 0 "CONFIRM"
     (name "Press To Continue...")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Go")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 729 402)
       (extent 202 37)
      )
      (detail
       (origin 608 460)
       (extent 194 40)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "TEXTDISPLAY"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
      )
     )
     (implementation
      (component clearAtPrerun 1)
      (component clearAtActivate 1)
     )
     (views
      (icon
      )
      (detail
       (origin 735 323)
       (extent 190 35)
      )
      (active detail)
     )
    )
    (component 2 "LITERALCONSTANT"
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Text")
       (lock name constraints)
      )
     )
     (implementation
      (component value Text
       (datum "SRQ from HP 3478A")
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Text
       (datum "")
      )
     )
     (views
      (icon
       (origin 667 328)
       (extent 46 25)
      )
      (detail
       (origin 280 306)
       (extent 201 28)
      )
      (active icon)
     )
    )
    (configuration
     (connect D1:0 D0:0)
     (connect D2:1 D1:1)
    )
    (ShowOnExecPanel
     (origin 328 225)
     (extent 346 272)
     (panel
      (origin 279 243)
      (extent 342 234)
      (widget 1 detail
       (title off)
       (origin 299 286)
       (extent 305 42)
      )
      (widget 0 icon
       (title off)
       (origin 352 353)
       (extent 202 37)
      )
     )
    )
   )
   (views
    (icon
     (origin 832 468)
     (extent 136 25)
    )
    (detail
     (origin 589 263)
     (extent 322 214)
     (configuration
      (connect D1:0 D0:0
       (Point 830 360)
       (Point 830 369)
       (Point 830 399)
      )
      (connect D2:1 D1:1
       (Point 715 340)
       (Point 723 340)
       (Point 732 340)
      )
     )
     (stackingOrder 0 1 2)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 17 "IFTHENELSE"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Then")
     (lock name constraints)
    )
    (output 2
     (type data)
     (name "Else")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr "bit(a,6)")
   )
   (views
    (icon
     (origin 831 398)
     (extent 78 25)
    )
    (detail
     (origin 541 345)
     (extent 149 70)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 18 "SERIALPOLL"
   (name "Spoll: scope (hp54504a @ 709)")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "status")
     (lock name constraints)
    )
   )
   (implementation
    (comp iopath "scope")
    (comp event "spoll")
    (comp sense "nowait")
    (comp mask "0")
   )
   (views
    (icon
     (origin 515 498)
     (extent 271 64)
     (iconImage "io.icon")
    )
    (detail
     (origin 503 490)
     (extent 305 120)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 19 "SERIALPOLL"
   (name "Spoll: dvm (hp3478a @ 723)")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "status")
     (lock name constraints)
    )
   )
   (implementation
    (comp iopath "dvm")
    (comp event "spoll")
    (comp sense "nowait")
    (comp mask "0")
   )
   (views
    (icon
     (origin 518 378)
     (extent 244 64)
     (iconImage "io.icon")
    )
    (detail
     (origin 565 387)
     (extent 305 120)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 20 "WAITSRQ"
   (name "SRQ: hpib7")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "SRQ")
     (lock name constraints)
    )
   )
   (implementation
    (component channel 7)
    (component sense "wait")
    (component event "srq")
   )
   (views
    (icon
     (origin 585 278)
     (extent 110 64)
     (iconImage "io.icon")
    )
    (detail
     (origin 470 280)
     (extent 195 91)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 21 "IODEVICE"
   (name "dvm (hp3478a @ HP-IB 0)")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (comp iopath "dvm")
    (procedure
      EXECUTE CLEAR
      WRITE TEXT "M20" EOL
    )
   )
   (views
    (icon
     (origin 255 468)
     (extent 251 65)
     (iconImage "io.icon")
    )
    (detail
     (origin 226 438)
     (extent 308 105)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 22 "IODEVICE"
   (name "scope (hp54504a @ HP-IB 0)")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (comp iopath "scope")
    (procedure
      WRITE TEXT "*RST" EOL
      WRITE TEXT "*CLS;*ESE 64;*SRE 32" EOL
      EXECUTE LOCAL
    )
   )
   (views
    (icon
     (origin 258 388)
     (extent 244 64)
     (iconImage "io.icon")
    )
    (detail
     (origin 226 358)
     (extent 308 105)
    )
    (terminals on)
    (active icon)
   )
  )
  (configuration
   (connect D1:1 D4:1)
   (connect D0:1 D5:1)
   (connect D5:1 D6:1)
   (connect D4:1 D7:1)
   (connect D18:1 D12:1)
   (connect D15:0 D13:0)
   (connect D12:2 D14:0)
   (connect D12:1 D15:0)
   (connect D17:1 D16:0)
   (connect D19:1 D17:1)
   (connect D17:2 D18:0)
   (connect D20:1 D19:0)
   (connect D2:1 D20:0)
   (connect D22:0 D21:0)
  )
 )
 (views
  (detail
   (origin 0 67)
   (extent 980 638)
   (configuration
    (connect D1:1 D4:1
     (Point 392 700)
     (Point 408 700)
    )
    (connect D0:1 D5:1
     (Point 392 620)
     (Point 408 620)
    )
    (connect D5:1 D6:1
     (Point 491 620)
     (Point 512 620)
    )
    (connect D4:1 D7:1
     (Point 491 700)
     (Point 512 700)
    )
    (connect D18:1 D12:1
     (Point 788 530)
     (Point 828 530)
    )
    (connect D15:0 D13:0
     (Point 920 644)
     (Point 920 650)
     (Point 900 650)
     (Point 900 665)
    )
    (connect D12:2 D14:0
     (Point 911 540)
     (Point 920 540)
     (Point 920 560)
     (Point 850 560)
     (Point 850 580)
     (Point 730 580)
     (Point 730 665)
    )
    (connect D12:1 D15:0
     (Point 911 520)
     (Point 930 520)
     (Point 930 570)
     (Point 920 570)
     (Point 920 575)
    )
    (connect D17:1 D16:0
     (Point 911 400)
     (Point 930 400)
     (Point 930 440)
     (Point 900 440)
     (Point 900 465)
    )
    (connect D19:1 D17:1
     (Point 764 410)
     (Point 828 410)
    )
    (connect D17:2 D18:0
     (Point 911 420)
     (Point 920 420)
     (Point 920 430)
     (Point 890 430)
     (Point 890 440)
     (Point 810 440)
     (Point 810 460)
     (Point 650 460)
     (Point 650 495)
    )
    (connect D20:1 D19:0
     (Point 697 310)
     (Point 710 310)
     (Point 710 360)
     (Point 640 360)
     (Point 640 375)
    )
    (connect D2:1 D20:0
     (Point 617 240)
     (Point 640 240)
     (Point 640 275)
    )
    (connect D22:0 D21:0
     (Point 380 454)
     (Point 380 459)
     (Point 380 465)
    )
   )
   (stackingOrder 0 1 2 3 4 5 6 7 8 9
     10 11 16 21 22 19 17 18 12 20
     15 13 14)
  )
  (active detail)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
  (delGlob yes)
 )
)
