#! /usr/lib/veetest/veetest -r
(revision "A.00.00")
(date "Thu 11/Apr/1991")
(component 0 "Context"
 (name "Simulated Data Logger With Panel")
 (interface
 )
 (implementation
  (trigMode deg)
  (locked no)
  (component 0 "Start"
   (name "Graph Logged Data File")
   (interface
    (sequence out)
   )
   (implementation
   )
   (views
    (icon
     (origin 200 802)
     (extent 220 37)
    )
    (detail
     (origin 274 420)
     (extent 233 20)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 1 "Context"
   (name "Log Data")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "SeqName")
     (optional yes)
    )
    (input 2
     (type data)
     (name "Name")
     (optional yes)
    )
    (input 3
     (type data)
     (name "Meas")
     (optional yes)
    )
    (output 1
     (type data)
     (name "X")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "TimeStamp"
     (name "Time Stamp")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "TimeStamp")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 203 268)
       (extent 110 25)
      )
      (detail
       (origin 213 233)
       (extent 61 34)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "Formula"
     (name "Append Time Stamp")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (input 2
       (type data)
       (name "B")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "A+\":\"+B")
     )
     (views
      (icon
       (origin 599 228)
       (extent 163 64)
       (iconImage formula.icon)
      )
      (detail
       (origin 579 178)
       (extent 132 104)
      )
      (terminals on)
      (active detail)
     )
    )
    (component 2 "ToString"
     (name "To String")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (tag "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "result")
       (lock name constraints)
      )
     )
     (implementation
      (attr iopath string write "string"
       (readTerm "\n")
       (fs " ")
       (eol "\n")
       (multiField fullSyntax)
       (arrayFormat block)
      )
      (procedure
        WRITE TEXT a TIME:HMS:H24 EOL
      )
     )
     (views
      (icon
       (origin 355 268)
       (extent 110 25)
      )
      (detail
       (origin 261 258)
       (extent 308 105)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 3 "ToFile"
     (name "To File")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (tag "A")
       (optional yes)
      )
      (input 2
       (type data)
       (name "B")
       (tag "B")
       (optional yes)
      )
      (input 3
       (type data)
       (name "C")
       (tag "C")
       (optional yes)
      )
      (input 4
       (type control)
       (name "File Name")
       (tag "File Name")
       (requires
        (datatype Text)
        (shape "Scalar")
       )
       (lock name constraints)
       (optional yes)
      )
     )
     (implementation
      (attr iopath file write "/tmp/test:18:01:46"
       (readTerm "\n")
       (fs " ")
       (eol "\n")
       (multiField fullSyntax)
       (arrayFormat block)
      )
      (procedure
        WRITE TEXT "Filename: ",C STR EOL
        WRITE TEXT a DATE:WDMY TIME:HMS:H24 EOL
        WRITE CONTAINER b WF STD
      )
     )
     (views
      (icon
       (origin 741 283)
       (extent 78 34)
      )
      (detail
       (origin 506 396)
       (extent 409 248)
      )
      (terminals on)
      (active detail)
     )
    )
    (configuration
     (connect I1:1 D0:0)
     (connect I2:1 D1:1)
     (connect D2:1 D1:2)
     (connect D0:1 D2:1)
     (connect D0:0 D3:0)
     (connect D0:1 D3:1)
     (connect I3:1 D3:2)
     (connect D1:1 D3:3)
     (connect D1:1 D3:4)
     (connect D1:1 O1:1)
    )
   )
   (views
    (icon
     (origin 505 438)
     (extent 110 45)
    )
    (detail
     (origin 131 157)
     (extent 788 507)
     (configuration
      (connect I1:1 D0:0
       (Point 133 250)
       (Point 131 185)
       (Point 219 185)
       (Point 258 265)
      )
      (connect I2:1 D1:1
       (Point 133 420)
       (Point 146 420)
       (Point 146 130)
       (Point 536 200)
      )
      (connect D2:1 D1:2
       (Point 467 280)
       (Point 501 280)
       (Point 501 260)
       (Point 536 260)
      )
      (connect D0:1 D2:1
       (Point 315 280)
       (Point 332 280)
       (Point 332 280)
       (Point 352 280)
      )
      (connect D0:0 D3:0
       (Point 258 295)
       (Point 258 320)
       (Point 680 320)
       (Point 675 363)
      )
      (connect D0:1 D3:1
       (Point 315 280)
       (Point 328 280)
       (Point 328 310)
       (Point 378 310)
       (Point 378 430)
       (Point 403 430)
      )
      (connect I3:1 D3:2
       (Point 133 590)
       (Point 133 590)
       (Point 167 370)
       (Point 403 490)
      )
      (connect D1:1 D3:3
       (Point 783 230)
       (Point 816 230)
       (Point 816 330)
       (Point 406 330)
       (Point 406 550)
       (Point 403 550)
      )
      (connect D1:1 D3:4
       (Point 783 230)
       (Point 816 230)
       (Point 816 330)
       (Point 406 330)
       (Point 406 610)
       (Point 403 610)
      )
      (connect D1:1 O1:1
       (Point 783 230)
       (Point 807 225)
       (Point 807 325)
       (Point 907 325)
       (Point 907 405)
       (Point 916 420)
      )
     )
    )
    (terminals on)
    (active icon)
   )
  )
  (component 2 "Context"
   (name "Simulated Measurement")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "X")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "RandomNumber"
     (name "Random Number")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Rand Val")
       (lock name constraints)
      )
     )
     (implementation
      (component lowerLimit 0.5)
      (component upperLimit 1.5)
     )
     (views
      (icon
       (origin 7 708)
       (extent 127 25)
      )
      (detail
       (origin 27 500)
       (extent 222 60)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "Formula"
     (name "Formula")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (input 2
       (type data)
       (name "B")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "A+B")
     )
     (views
      (icon
       (origin 691 138)
       (extent 78 64)
       (iconImage formula.icon)
      )
      (detail
       (origin 737 368)
       (extent 79 104)
      )
      (terminals on)
      (active detail)
     )
    )
    (component 2 "VNoiseGenerator"
     (name "Noise Generator")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "noise WF")
       (tag "noiseWF")
       (lock name constraints)
      )
     )
     (implementation
      (component amplitude 0.1)
      (component numPoints 256)
      (component interval 0.02)
     )
     (views
      (icon
       (origin 208 178)
       (extent 145 25)
      )
      (detail
       (origin 308 295)
       (extent 221 90)
      )
      (terminals on)
      (active detail)
     )
    )
    (component 3 "VPulseGenerator"
     (name "VPulse Generator")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Pulse Delay")
       (tag "Pulse Delay")
       (requires
        (datatype Real)
        (shape "Scalar")
       )
       (lock constraints)
       (optional yes)
      )
      (input 2
       (type data)
       (name "High")
       (tag "High")
       (requires
        (datatype Real)
        (shape "Scalar")
       )
       (lock constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (name "pulse WF")
       (tag "pulseWF")
       (lock name constraints)
      )
      (buffers in
       (buffer "Pulse Delay")
       (buffer "High")
      )
     )
     (implementation
      (component thresholds 0%-100%)
      (component riseTime 0.002)
      (component pulseWidth 0.01)
      (component pulseDelay 0.002415187462601285)
      (component fallTime 0.005)
      (component frequency 1)
      (component high 0.5067458743041797)
      (component low 0)
      (component burstMode OFF)
      (component burstRate 1)
      (component burstCount 1)
      (component numPoints 256)
      (component interval 0.02)
      (component errorOnAlias 1)
     )
     (views
      (icon
       (origin 223 478)
       (extent 154 25)
      )
      (detail
       (origin 275 450)
       (extent 257 360)
      )
      (terminals on)
      (active detail)
     )
    )
    (component 4 "RandomNumber"
     (name "Random Number")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Rand Val")
       (lock name constraints)
      )
     )
     (implementation
      (component lowerLimit 0)
      (component upperLimit 0.005)
     )
     (views
      (icon
       (origin 7 528)
       (extent 127 25)
      )
      (detail
       (origin 27 300)
       (extent 222 60)
      )
      (terminals on)
      (active icon)
     )
    )
    (configuration
     (connect D2:1 D1:1)
     (connect D3:1 D1:2)
     (connect D4:1 D3:1)
     (connect D0:1 D3:2)
     (connect D1:1 O1:1)
    )
   )
   (views
    (icon
     (origin 251 518)
     (extent 199 25)
    )
    (detail
     (origin 32 125)
     (extent 936 610)
     (configuration
      (connect D2:1 D1:1
       (Point 621 340)
       (Point 640 340)
       (Point 640 390)
       (Point 694 390)
      )
      (connect D3:1 D1:2
       (Point 624 630)
       (Point 630 630)
       (Point 630 450)
       (Point 694 450)
      )
      (connect D4:1 D3:1
       (Point 136 540)
       (Point 150 540)
       (Point 150 540)
       (Point 152 540)
      )
      (connect D0:1 D3:2
       (Point 136 720)
       (Point 150 720)
       (Point 150 720)
       (Point 152 720)
      )
      (connect D1:1 O1:1
       (Point 888 420)
       (Point 855 401)
       (Point 855 146)
       (Point 965 145)
      )
     )
    )
    (terminals on)
    (active icon)
   )
  )
  (component 3 "YPlot"
   (name "Last Measurement")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Trace1")
     (lock constraints)
    )
    (input 2
     (type control)
     (name "Auto Scale")
     (lock name constraints)
     (optional yes)
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
    (component tracePin 1)
    (component graphMode rectangular)
   )
   (views
    (icon
     (extent 154 0)
     (iconImage display.icon)
    )
    (detail
     (origin 602 531)
     (extent 317 279)
     (displayMode scrollGraph)
     (graphType cartesian)
     (gridType grid)
     (scale 0
      (name "Y name")
      (domainName "X name")
      (color 0x909090)
      (show 1)
      (range -0.2 1.4 3 linear)
     )
     (domain 0 0.02 3 linear)
     (trace 0 onScale 0
      (name "Trace1")
      (color 0xffdd00)
      (lineType 1)
      (pointType 0)
     )
    )
    (active detail)
   )
  )
  (component 4 "LiteralConstant"
   (name "Test Name")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Text
     (name "Test Name")
     (datum "/tmp/test")
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Text
     (datum "")
    )
   )
   (views
    (icon
     (extent 110 0)
    )
    (detail
     (origin 11 444)
     (extent 258 33)
    )
    (active detail)
   )
  )
  (component 5 "YPlot"
   (name "XY Trace")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Trace1")
     (lock constraints)
    )
    (input 2
     (type control)
     (name "Auto Scale")
     (lock name constraints)
     (optional yes)
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
    (component tracePin 1)
    (component graphMode rectangular)
   )
   (views
    (icon
     (iconImage display.icon)
    )
    (detail
     (origin 602 861)
     (extent 317 279)
     (displayMode scrollGraph)
     (graphType cartesian)
     (gridType grid)
     (scale 0
      (name "Y name")
      (domainName "X name")
      (color 0x909090)
      (show 1)
      (range -0.1 0.7000000000000001 3 linear)
     )
     (domain 0 0.02 3 linear)
     (trace 0 onScale 0
      (name "Trace1")
      (color 0xffdd00)
      (lineType 1)
      (pointType 0)
     )
    )
    (active detail)
   )
  )
  (component 6 "PrintScreen"
   (name "Print Screen")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
   )
   (views
    (icon
     (origin 251 728)
     (extent 118 25)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 7 "Start"
   (name "Print Logged Data Graph")
   (interface
    (sequence out)
   )
   (implementation
   )
   (views
    (icon
     (origin 195 661)
     (extent 231 39)
    )
    (detail
     (origin 165 340)
     (extent 251 20)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 8 "Constant"
   (name "Measurement Interval")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Measurement Interval")
     (datum 2)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
   )
   (views
    (icon
     (extent 190 0)
    )
    (detail
     (origin 8 366)
     (extent 264 28)
    )
    (active detail)
   )
  )
  (component 9 "OnCycle"
   (name "On Cycle")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Cycle")
     (tag "Cycle")
     (requires
      (datatype Real)
      (shape "Scalar")
     )
     (lock constraints)
     (optional yes)
    )
    (output 1
     (type data)
     (lock name constraints)
    )
    (buffers in
     (buffer "Cycle")
    )
   )
   (implementation
    (component cycle 2)
   )
   (views
    (icon
     (origin 555 478)
     (extent 110 64)
     (iconImage loop.icon)
    )
    (detail
     (origin 302 363)
     (extent 156 34)
    )
    (active detail)
   )
  )
  (component 10 "FromFile"
   (name "Logged Data File Name")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "meas")
     (requires
      (datatype Waveform)
     )
     (lock constraints)
     (optional yes)
    )
    (output 2
     (type data)
     (name "X")
     (requires
      (datatype Text)
     )
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (attr iopath file read "/tmp/test:18:01:46"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (procedure
      READ TEXT x STR COUNT:1
      READ TEXT x STR COUNT:1
      READ CONTAINER meas
    )
   )
   (views
    (icon
     (origin 415 158)
     (extent 199 25)
    )
    (detail
     (origin 139 906)
     (extent 322 109)
    )
    (terminals on)
    (active detail)
   )
  )
  (component 11 "ExitProcess"
   (interface
    (sequence in)
   )
   (implementation
    (comp code 0)
   )
   (views
    (icon
     (origin 521 338)
     (extent 78 64)
     (iconImage stop.icon)
    )
    (detail
     (origin 510 533)
     (extent 120 34)
    )
    (active icon)
   )
  )
  (component 12 "Start"
   (name "Start Logging")
   (interface
    (sequence out)
   )
   (implementation
   )
   (views
    (icon
     (origin 310 261)
     (extent 141 39)
    )
    (detail
     (origin 360 230)
     (extent 161 20)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 13 "Note"
   (name "CAUTION:")
   (interface
   )
   (implementation
    (component text 4 5
     DO NOT USE "RUN" BUTTON
     TO OPERATE THIS EXAMPLE.
     PLEASE READ Info About
      FOR OPERATING DETAILS.
    )
   )
   (views
    (icon
     (extent 110 0)
     (iconImage notepad.icon)
    )
    (detail
     (origin 318 119)
     (extent 244 83)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 14 "Note"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 4 5
     This example is provided as an
     illustration "as is", and Hewlett-Packard
     Company makes no warranty of any kind
     with regard to this example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 572 119)
     (extent 397 82)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 15 "ScrollingTextDisplay"
   (name "Data Written to file:")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (origin 707 218)
     (extent 199 25)
    )
    (detail
     (origin 664 268)
     (extent 273 205)
     (bufferSize 256)
    )
    (active detail)
   )
  )
  (component 16 "Context"
   (name "Press For")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "IfThenElse"
     (name "!= 0")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a!=0")
     )
     (views
      (icon
       (origin 355 330)
       (extent 46 25)
      )
      (detail
       (origin 209 308)
       (extent 73 64)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "Toggle"
     (name "Info About")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Reset")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Info About")
       (values range 0 1)
       (datum 0)
      )
      (component autoTrigger on)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (datum 0)
      )
     )
     (views
      (icon
       (origin 191 323)
       (extent 114 39)
       (format button)
      )
      (detail
       (origin 320 203)
       (extent 42 54)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "RepeatUntilBreak"
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Continuous")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 115 248)
       (extent 110 64)
       (iconImage loop.icon)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 3 "Context"
     (name "Info About This Example")
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Confirm"
       (name "DONE")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (description 7 9
         This tiny "thread" begins running when the 
         enclosing UserObject is executed.  When the user
         acknowledges the OK/DONE button, there is nothing
         left to execute, so the thread ends.  Since there
         are not other threads running, the User Object
         is completed and will exit, removing the Show on
         Execute pop-up display.
        )
        (icon
         (origin 221 442)
         (extent 58 37)
        )
        (detail
         (origin 156 253)
         (extent 79 34)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "Note"
       (name "Info About")
       (interface
       )
       (implementation
        (component text 63 9
         Overview:
         This model is a  data logger that
         saves measurement data to a file.  
         
         This model includes a panel view for easy
         operation by an inexperienced operator.
         
         Details:
         Here is how to operate the model:
         
         You will probably want to operate the model
         using the Panel view.  If you are looking at
         the Detail view now, press "Panel" in the
         left side of the HP VEE title bar. 
         
            To Log Data:
            
            1) Fill in the "Measurement Interval" and
               "Test Name" fields.  The measurement
               interval is specified in seconds.
               The test name is the base name used
               by the model to create filenames to
               store logged data; VEE will append
               timestamps to the base filename for
               each file written.  The number of 
               characters you can use for the test
               name may be limited by your operating
               system; try a short name.
         
            2) Click on "Start Logging". DO NOT CLICK
               ON RUN.   
         
            3) Click on "Stop Logging" or on the "Stop"
               button in the title bar once to pause;
               Click on "Stop" again to quit logging 
               or click on "Cont" to continue.
         
            To review data that has been logged:
         
            1) Type the complete filename of the
               logged data file you wish to view 
               in the "Logged Data File" Name field.
         
            2) To graph the data on the screen, click
               on "Graph Logged Data".
         
            3) To print a paper copy of the graph,
               click on "Print Logged Data Graph".
               You must properly specify your graphics
               printer using "File-->Preferences-->
               Printer Config" before you click.
           
         You can use this model to log real data by:
         
         1. Substituting your own measurement
            object(s) for "Simulated Measurement".
            For example, you might substitute
            a "State Driver" for "Simulated
            Measurement".
         
         2. Adjusting the I/O transactions to
            properly format the data produced by
            by your measurement object(s).
        )
       )
       (views
        (icon
         (origin 145 288)
         (extent 110 25)
        )
        (detail
         (origin 26 278)
         (extent 449 244)
         (editing disabled)
        )
        (active detail)
       )
      )
      (configuration
      )
      (ShowOnExecPanel
       (origin 55 78)
       (extent 503 442)
       (panel
        (origin 211 188)
        (extent 499 404)
        (widget 1 detail
         (title off)
         (origin 235 205)
         (extent 453 313)
         (editing disabled)
        )
        (widget 0 icon
         (title off)
         (origin 417 532)
         (extent 58 37)
        )
       )
      )
     )
     (views
      (icon
       (origin 352 378)
       (extent 217 25)
      )
      (detail
       (origin 17 230)
       (extent 866 520)
       (configuration
       )
      )
      (active icon)
     )
    )
    (configuration
     (connect D1:1 D0:1)
     (connect D2:1 D1:0)
     (connect D3:0 D1:1)
     (connect D0:1 D3:0)
    )
   )
   (views
    (icon
     (origin 415 468)
     (extent 110 25)
    )
    (panel
     (origin 11 118)
     (extent 298 84)
     (widget 1 icon
      (title off)
      (origin 106 138)
      (extent 114 39)
      (format button)
     )
    )
    (detail
     (origin 6 113)
     (extent 848 554)
     (configuration
      (connect D1:1 D0:1
       (Point 307 342)
       (Point 352 342)
      )
      (connect D2:1 D1:0
       (Point 227 280)
       (Point 248 280)
       (Point 248 320)
      )
      (connect D3:0 D1:1
       (Point 460 405)
       (Point 460 420)
       (Point 170 420)
       (Point 170 342)
       (Point 188 342)
      )
      (connect D0:1 D3:0
       (Point 403 332)
       (Point 460 332)
       (Point 460 375)
      )
     )
    )
    (active panel)
    (active panel)
   )
  )
  (component 17 "Confirm"
   (name "Stop Logging")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Go")
     (lock name constraints)
    )
   )
   (implementation
   )
   (views
    (icon
     (origin 495 262)
     (extent 130 37)
    )
    (detail
     (origin 494 260)
     (extent 122 40)
    )
    (terminals on)
    (active detail)
   )
  )
  (configuration
   (connect D9:1 D1:1)
   (connect D4:1 D1:2)
   (connect D2:1 D1:3)
   (connect D9:1 D2:0)
   (connect D2:1 D3:1)
   (connect D10:1 D5:1)
   (connect D10:0 D5:2)
   (connect D7:0 D6:0)
   (connect D12:0 D9:0)
   (connect D8:1 D9:1)
   (connect D0:0 D10:0)
   (connect D17:1 D11:0)
   (connect D1:1 D15:1)
   (connect D12:0 D17:0)
  )
 )
 (views
  (panel
   (origin 0 67)
   (extent 1002 660)
   (widget 16 panel
    (title on)
    (origin 17 120)
    (extent 319 77)
    (widget 1 icon
     (title off)
     (origin 119 133)
     (extent 114 39)
     (format button)
    )
   )
   (widget 4 detail
    (title on)
    (origin 355 119)
    (extent 258 33)
   )
   (widget 8 detail
    (title on)
    (origin 358 195)
    (extent 257 32)
   )
   (widget 3 detail
    (title on)
    (origin 789 114)
    (extent 186 66)
    (displayMode graphOnly)
    (graphType cartesian)
    (gridType grid)
    (scale 0
     (name "Y name")
     (domainName "X name")
     (color 0x909090)
     (show 1)
     (range -0.2 1.4 3 linear)
    )
    (domain 0 0.02 3 linear)
    (trace 0 onScale 0
     (name "Trace1")
     (color 0xffdd00)
     (lineType 1)
     (pointType 0)
    )
   )
   (widget 15 detail
    (title on)
    (origin 633 226)
    (extent 346 68)
    (bufferSize 256)
   )
   (widget 17 icon
    (title off)
    (origin 633 139)
    (extent 140 38)
   )
   (widget 5 detail
    (title off)
    (origin 359 328)
    (extent 625 334)
    (displayMode scrollGraph)
    (graphType cartesian)
    (gridType grid)
    (scale 0
     (name "Y name")
     (domainName "X name")
     (color 0x909090)
     (show 1)
     (range -0.1 0.7000000000000001 3 linear)
    )
    (domain 0 0.02 3 linear)
    (trace 0 onScale 0
     (name "Trace1")
     (color 0xee44)
     (lineType 1)
     (pointType 0)
    )
    (marker 0 onTrace 0)
    (marker 1 onTrace 0)
    (marker 2)
   )
   (widget 10 detail
    (title on)
    (origin 19 363)
    (extent 322 35)
   )
   (widget 0 icon
    (title off)
    (origin 57 429)
    (extent 230 38)
   )
   (widget 7 icon
    (title off)
    (origin 57 497)
    (extent 231 39)
   )
   (widget 12 icon
    (title off)
    (origin 631 82)
    (extent 141 39)
   )
  )
  (detail
   (origin 0 67)
   (extent 980 653)
   (configuration
    (connect D9:1 D1:1
     (Point 460 380)
     (Point 480 380)
     (Point 480 450)
     (Point 502 450)
    )
    (connect D4:1 D1:2
     (Point 271 460)
     (Point 502 460)
    )
    (connect D2:1 D1:3
     (Point 452 530)
     (Point 470 530)
     (Point 470 470)
     (Point 502 470)
    )
    (connect D9:1 D2:0
     (Point 460 380)
     (Point 480 380)
     (Point 480 450)
     (Point 350 450)
     (Point 350 515)
    )
    (connect D2:1 D3:1
     (Point 452 530)
     (Point 480 530)
     (Point 480 600)
     (Point 599 600)
    )
    (connect D10:1 D5:1
     (Point 513 930)
     (Point 599 930)
    )
    (connect D10:0 D5:2
     (Point 310 1017)
     (Point 310 1070)
     (Point 599 1070)
    )
    (connect D7:0 D6:0
     (Point 310 702)
     (Point 310 725)
    )
    (connect D12:0 D9:0
     (Point 380 302)
     (Point 380 330)
    )
    (connect D8:1 D9:1
     (Point 274 380)
     (Point 299 380)
    )
    (connect D0:0 D10:0
     (Point 310 841)
     (Point 310 873)
    )
    (connect D17:1 D11:0
     (Point 658 280)
     (Point 640 280)
     (Point 640 320)
     (Point 560 320)
     (Point 560 335)
    )
    (connect D1:1 D15:1
     (Point 617 460)
     (Point 630 460)
     (Point 630 370)
     (Point 661 370)
    )
    (connect D12:0 D17:0
     (Point 380 302)
     (Point 380 310)
     (Point 470 310)
     (Point 470 240)
     (Point 560 240)
     (Point 560 227)
    )
   )
  )
  (active panel)
  (active panel)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
