#! /usr/lib/veetest/veetest -r
(revision "B.00.00")
(date "Fri 20/Nov/1992")
(component 0 "ROOTCONTEXT"
 (name "VEE Craps")
 (description 22 2
  This model randomly rolls 2 dice.  Win, lose and 
  match point follow the basic rules of the Las
  Vegas craps game.  To play simply push the run
  button, enter the amount you wish to bet, and
  strike roll.  The dice will be displayed in a
  random manner across the screen.
  
  You win if you roll a 7 or 11 on the first roll,
  (a natural).  You lose if you roll a 2, 3, or 12
  on the first roll, (craps).  You have a point to
  make if you roll a 4, 5, 6, 8, 9, or 10.  You then
  roll again as ofter as necessary and will win if
  you match your point before rolling a 7, but will
  lose if a 7 is rolled first.
  
  For betting we start you off with $100 bankroll.
  You may bet any amount between $1 and the current
  bankroll.  If you win, the amount you bet will be
  doubled and added to your bankroll.  If you lose,
  the amount you bet will be subtracted from your
  bankroll. 
  
 )
 (interface
 )
 (implementation
  (locked no)
  (trigMode deg)
  (nextID 90)
  (component 0 "REPEATUNTILBREAK"
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Continuous")
     (lock name constraints)
    )
   )
   (implementation
   )
   (views
    (icon
     (origin 25 128)
     (extent 110 64)
     (iconImage "loop.icon")
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 8 "TOSTRING"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (output 1
     (type data)
     (name "result")
     (lock name constraints)
    )
   )
   (implementation
    (attr iopath string write "string"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (procedure
      WRITE TEXT "$",a," Left" EOL
    )
   )
   (views
    (icon
     (origin 545 88)
     (extent 110 25)
    )
    (detail
     (origin 341 538)
     (extent 308 105)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 9 "ACCUMULATOR"
   (name "# natural wins")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
     (tag "InData")
     (requires
      (shape "Scalar")
     )
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Data")
     (tag "accumData")
     (lock name constraints)
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (origin 382 218)
     (extent 136 25)
    )
    (detail
     (origin 335 303)
     (extent 210 34)
    )
    (active icon)
   )
  )
  (component 10 "ACCUMULATOR"
   (name "# craps")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
     (tag "InData")
     (requires
      (shape "Scalar")
     )
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Data")
     (tag "accumData")
     (lock name constraints)
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (origin 411 268)
     (extent 78 25)
    )
    (detail
     (origin 350 343)
     (extent 180 34)
    )
    (active icon)
   )
  )
  (component 11 "ACCUMULATOR"
   (name "# loses")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
     (tag "InData")
     (requires
      (shape "Scalar")
     )
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Data")
     (tag "accumData")
     (lock name constraints)
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (origin 401 478)
     (extent 78 25)
    )
    (detail
     (origin 459 553)
     (extent 183 34)
    )
    (active icon)
   )
  )
  (component 20 "ACCUMULATOR"
   (name "# made point")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
     (tag "InData")
     (requires
      (shape "Scalar")
     )
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Data")
     (tag "accumData")
     (lock name constraints)
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (origin 411 368)
     (extent 118 25)
    )
    (detail
     (origin 344 247)
     (extent 213 27)
    )
    (active icon)
   )
  )
  (component 22 "TEXTDISPLAY"
   (name "Bank Roll")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (origin 685 88)
     (extent 110 25)
    )
    (detail
     (origin 805 482)
     (extent 190 37)
    )
    (active icon)
   )
  )
  (component 23 "TEXTDISPLAY"
   (name "Your Point")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (origin 685 168)
     (extent 110 25)
    )
    (detail
     (origin 645 162)
     (extent 190 37)
    )
    (active icon)
   )
  )
  (component 24 "CONTEXT"
   (name "Made Your Point")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (locked no)
    (trigMode deg)
    (nextID 12)
    (component 1 "DELAY"
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Done")
       (tag "Done")
       (lock constraints)
      )
     )
     (implementation
      (component delay 2)
     )
     (views
      (icon
      )
      (detail
       (origin 445 303)
       (extent 130 34)
      )
      (active detail)
     )
    )
    (component 2 "EXITCONTEXT"
     (interface
      (sequence in)
     )
     (implementation
     )
     (views
      (icon
       (origin 618 308)
       (extent 145 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 7 "CONSTANT"
     (name "Integer")
     (subType "Integer")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Int32")
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Integer")
       (datum 0)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (name "LongInt")
       (datum 0)
      )
     )
     (views
      (icon
      )
      (detail
       (origin 440 393)
       (extent 140 34)
       (showFormat int)
      )
      (active detail)
     )
    )
    (component 6 "TOGLOBAL"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
       (tag "Data")
      )
     )
     (implementation
      (component globalName count)
     )
     (views
      (icon
      )
      (detail
       (origin 652 379)
       (extent 97 62)
      )
      (terminals on)
      (active detail)
     )
    )
    (component 8 "FORMULA"
     (name "Formula")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "bankroll+2*bet")
     )
     (views
      (icon
       (iconImage "formula.icon")
      )
      (detail
       (origin 440 499)
       (extent 160 43)
      )
      (active detail)
     )
    )
    (component 9 "TOGLOBAL"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
       (tag "Data")
      )
     )
     (implementation
      (component globalName bankroll)
     )
     (views
      (icon
      )
      (detail
       (origin 672 489)
       (extent 97 62)
      )
      (terminals on)
      (active detail)
     )
    )
    (component 10 "TOGLOBAL"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
       (tag "Data")
      )
     )
     (implementation
      (component globalName point)
     )
     (views
      (icon
      )
      (detail
       (origin 662 599)
       (extent 97 62)
      )
      (terminals on)
      (active detail)
     )
    )
    (component 11 "LITERALCONSTANT"
     (name "\"\"")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Text")
       (lock name constraints)
      )
     )
     (implementation
      (component value Text
       (name "\"\"")
       (datum "")
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Text
       (name "CString")
       (datum "")
      )
     )
     (views
      (icon
       (extent 46 0)
      )
      (detail
       (origin 448 613)
       (extent 145 35)
      )
      (active detail)
     )
    )
    (configuration
     (connect D0:1 D1:0)
     (connect D2:1 D3:1)
     (connect D4:1 D5:1)
     (connect D7:1 D6:1)
    )
    (ShowOnExecPanel
     (origin 305 182)
     (extent 420 363)
     (panel
      (origin 632 363)
      (extent 416 335)
      (pixmapImage "win.gif")
     )
    )
   )
   (views
    (icon
     (origin 618 408)
     (extent 145 25)
    )
    (detail
     (origin 435 274)
     (extent 350 413)
     (configuration
      (connect D0:1 D1:0
       (Point 577 320)
       (Point 600 320)
       (Point 600 290)
       (Point 690 290)
       (Point 690 305)
      )
      (connect D2:1 D3:1
       (Point 582 410)
       (Point 599 410)
      )
      (connect D4:1 D5:1
       (Point 602 520)
       (Point 619 520)
      )
      (connect D7:1 D6:1
       (Point 595 630)
       (Point 609 630)
      )
     )
     (stackingOrder 3 2 1 0 4 5 6 7)
    )
    (terminals on)
    (active panel)
    (active panel)
   )
  )
  (component 25 "CONTEXT"
   (name "A natural")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (locked no)
    (trigMode deg)
    (nextID 12)
    (component 1 "EXITCONTEXT"
     (interface
      (sequence in)
     )
     (implementation
     )
     (views
      (icon
       (origin 648 178)
       (extent 145 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "DELAY"
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Done")
       (tag "Done")
       (lock constraints)
      )
     )
     (implementation
      (component delay 2)
     )
     (views
      (icon
      )
      (detail
       (origin 485 163)
       (extent 130 34)
      )
      (active detail)
     )
    )
    (component 7 "CONSTANT"
     (name "Integer")
     (subType "Integer")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Int32")
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Integer")
       (datum 0)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (name "LongInt")
       (datum 0)
      )
     )
     (views
      (icon
      )
      (detail
       (origin 460 252)
       (extent 141 36)
       (showFormat int)
      )
      (active detail)
     )
    )
    (component 6 "TOGLOBAL"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
       (tag "Data")
      )
     )
     (implementation
      (component globalName count)
     )
     (views
      (icon
      )
      (detail
       (origin 672 239)
       (extent 97 62)
      )
      (terminals on)
      (active detail)
     )
    )
    (component 8 "TOGLOBAL"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
       (tag "Data")
      )
     )
     (implementation
      (component globalName bankroll)
     )
     (views
      (icon
      )
      (detail
       (origin 672 349)
       (extent 97 62)
      )
      (terminals on)
      (active detail)
     )
    )
    (component 9 "FORMULA"
     (name "Formula")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "bankroll+2*bet")
     )
     (views
      (icon
       (iconImage "formula.icon")
      )
      (detail
       (origin 450 359)
       (extent 160 43)
      )
      (active detail)
     )
    )
    (component 10 "LITERALCONSTANT"
     (name "\"\"")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Text")
       (lock name constraints)
      )
     )
     (implementation
      (component value Text
       (name "\"\"")
       (datum "")
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Text
       (name "CString")
       (datum "")
      )
     )
     (views
      (icon
       (extent 46 0)
      )
      (detail
       (origin 458 473)
       (extent 145 35)
      )
      (active detail)
     )
    )
    (component 11 "TOGLOBAL"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
       (tag "Data")
      )
     )
     (implementation
      (component globalName point)
     )
     (views
      (icon
      )
      (detail
       (origin 672 459)
       (extent 97 62)
      )
      (terminals on)
      (active detail)
     )
    )
    (configuration
     (connect D1:1 D0:0)
     (connect D2:1 D3:1)
     (connect D5:1 D4:1)
     (connect D6:1 D7:1)
    )
    (ShowOnExecPanel
     (origin 305 170)
     (extent 420 363)
     (panel
      (origin 432 113)
      (extent 416 335)
      (pixmapImage "win.gif")
     )
    )
   )
   (views
    (icon
     (origin 625 248)
     (extent 110 25)
    )
    (detail
     (origin 459 133)
     (extent 382 474)
     (configuration
      (connect D1:1 D0:0
       (Point 617 180)
       (Point 630 180)
       (Point 630 160)
       (Point 720 160)
       (Point 720 175)
      )
      (connect D2:1 D3:1
       (Point 603 270)
       (Point 619 270)
      )
      (connect D5:1 D4:1
       (Point 612 380)
       (Point 619 380)
      )
      (connect D6:1 D7:1
       (Point 605 490)
       (Point 619 490)
      )
     )
     (stackingOrder 1 0 4 3 5 2 6 7)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 26 "CONTEXT"
   (name "craps!")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (locked no)
    (trigMode deg)
    (nextID 12)
    (component 1 "DELAY"
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Done")
       (tag "Done")
       (lock constraints)
      )
     )
     (implementation
      (component delay 2)
     )
     (views
      (icon
      )
      (detail
       (origin 402 185)
       (extent 130 34)
      )
      (active detail)
     )
    )
    (component 2 "EXITCONTEXT"
     (interface
      (sequence in)
     )
     (implementation
     )
     (views
      (icon
       (origin 558 188)
       (extent 145 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 7 "CONSTANT"
     (name "Integer")
     (subType "Integer")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Int32")
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Integer")
       (datum 0)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (name "LongInt")
       (datum 0)
      )
     )
     (views
      (icon
      )
      (detail
       (origin 370 293)
       (extent 140 34)
       (showFormat int)
      )
      (active detail)
     )
    )
    (component 6 "TOGLOBAL"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
       (tag "Data")
      )
     )
     (implementation
      (component globalName count)
     )
     (views
      (icon
      )
      (detail
       (origin 582 279)
       (extent 97 62)
      )
      (terminals on)
      (active detail)
     )
    )
    (component 10 "TOGLOBAL"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
       (tag "Data")
      )
     )
     (implementation
      (component globalName point)
     )
     (views
      (icon
      )
      (detail
       (origin 582 379)
       (extent 97 62)
      )
      (terminals on)
      (active detail)
     )
    )
    (component 11 "LITERALCONSTANT"
     (name "\"\"")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Text")
       (lock name constraints)
      )
     )
     (implementation
      (component value Text
       (name "\"\"")
       (datum "")
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Text
       (name "CString")
       (datum "")
      )
     )
     (views
      (icon
       (extent 46 0)
      )
      (detail
       (origin 368 393)
       (extent 145 35)
      )
      (active detail)
     )
    )
    (configuration
     (connect D0:1 D1:0)
     (connect D2:1 D3:1)
     (connect D5:1 D4:1)
    )
    (ShowOnExecPanel
     (origin 272 173)
     (extent 472 361)
     (panel
      (origin 316 144)
      (extent 468 333)
      (pixmapImage "lose.gif")
     )
    )
   )
   (views
    (icon
     (origin 531 268)
     (extent 78 25)
    )
    (detail
     (origin 362 139)
     (extent 357 322)
     (configuration
      (connect D0:1 D1:0
       (Point 534 202)
       (Point 540 202)
       (Point 540 170)
       (Point 630 170)
       (Point 630 185)
      )
      (connect D2:1 D3:1
       (Point 512 310)
       (Point 529 310)
      )
      (connect D5:1 D4:1
       (Point 515 410)
       (Point 529 410)
      )
     )
     (stackingOrder 0 3 2 1 5 4)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 28 "CONFIRM"
   (name "ROLL")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Go")
     (lock name constraints)
    )
   )
   (implementation
   )
   (views
    (icon
     (origin 51 322)
     (extent 58 37)
    )
    (detail
     (origin 350 130)
     (extent 50 40)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 30 "CONTEXT"
   (name "Press For")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (locked no)
    (trigMode deg)
    (nextID 4)
    (component 0 "IFTHENELSE"
     (name "!= 0")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a!=0")
     )
     (views
      (icon
       (origin 345 379)
       (extent 46 25)
      )
      (detail
       (origin 209 308)
       (extent 73 64)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "TOGGLE"
     (name "Info About")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Reset")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Info About")
       (values range 0 1)
       (datum 0)
      )
      (component autoTrigger on)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (name "LongInt")
       (datum 0)
      )
     )
     (views
      (icon
       (origin 181 372)
       (extent 114 39)
       (format button)
      )
      (detail
       (origin 320 203)
       (extent 42 54)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "CONTEXT"
     (name "Info About This Example")
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (locked no)
      (trigMode deg)
      (nextID 2)
      (component 0 "CONFIRM"
       (name "DONE")
       (description 7 8
        This tiny "thread" begins running when the 
        enclosing UserObject is executed.  When the user
        acknowledges the OK/DONE button, there is nothing
        left to execute, so the thread ends.  Since there
        are not other threads running, the User Object
        is completed and will exit, removing the Show on
        Execute pop-up display.
       )
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 369 693)
         (extent 58 37)
        )
        (detail
         (origin 156 253)
         (extent 79 34)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "NOTE"
       (name "Note Pad")
       (description 2 8
        This is a "Display, Note Pad" object
        
       )
       (interface
       )
       (implementation
        (component text 19 9
         PURPOSE:  Play craps using VEE to demonstrate the new features of pixmaps and globals.
         
         USER DATA REQUIRED:  Press run, enter your bet, and roll the dice! 
         
         EXPLANATION:  This game introduces pop-up pixmaps and shows how Global Variables can
                   be used to simplify a VEE program. From the "File" menu, you can select
                  "Show Description" for more details.
          
                   The model is built using the panel approach, which simplifies data entry
                   and viewing.  Click on the "Detail" button (left on the title bar) to
                   see the individual objects which make up the model.  Since several
                   objects have been iconized, double click on any of these to change to
                   the open view.
         
                   Additional information for some of the objects may be provided with the
                   object menu "Show Description" feature.  From the object menu, "Help" 
                   may also be  directly accessed for the object.
         
                   Click "DONE" to exit this information panel.
        )
       )
       (views
        (icon
         (origin 505 428)
         (extent 110 25)
        )
        (detail
         (origin 54 224)
         (extent 648 335)
         (editing disabled)
        )
        (active detail)
       )
      )
      (configuration
      )
      (ShowOnExecPanel
       (origin 95 65)
       (extent 811 470)
       (panel
        (origin 45 235)
        (extent 807 442)
        (widget 1 detail
         (title off)
         (origin 56 246)
         (extent 790 372)
         (editing disabled)
        )
        (widget 0 icon
         (title off)
         (origin 410 628)
         (extent 58 37)
        )
       )
      )
     )
     (views
      (icon
       (origin 340 444)
       (extent 217 25)
      )
      (detail
       (origin 5 181)
       (extent 866 520)
       (configuration
       )
       (stackingOrder 0 1)
      )
      (active icon)
     )
    )
    (component 3 "REPEATUNTILBREAK"
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Continuous")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 75 288)
       (extent 110 64)
       (iconImage "loop.icon")
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (configuration
     (connect D1:1 D0:1)
     (connect D3:1 D1:0)
     (connect D2:0 D1:1)
     (connect D0:1 D2:0)
    )
   )
   (views
    (icon
     (origin 135 238)
     (extent 110 25)
    )
    (panel
     (origin 21 532)
     (extent 319 77)
     (widget 1 icon
      (title off)
      (origin 123 545)
      (extent 114 39)
      (format button)
     )
    )
    (detail
     (origin 9 188)
     (extent 863 484)
     (configuration
      (connect D1:1 D0:1
       (Point 297 391)
       (Point 342 391)
      )
      (connect D3:1 D1:0
       (Point 187 320)
       (Point 238 320)
       (Point 238 369)
      )
      (connect D2:0 D1:1
       (Point 448 471)
       (Point 448 486)
       (Point 318 486)
       (Point 318 426)
       (Point 168 426)
       (Point 168 391)
       (Point 178 391)
      )
      (connect D0:1 D2:0
       (Point 393 381)
       (Point 448 381)
       (Point 448 441)
      )
     )
     (stackingOrder 0 1 3 2)
    )
    (active panel)
    (active panel)
   )
  )
  (component 31 "NOTE"
   (name "Betting")
   (interface
   )
   (implementation
    (component text 10 5
     ****BETTING SCHEME*****
     ***********************
     You begin with $100!  *
     ***********************
     The amount you bet is *
     doubled if you win.   *
     ***********************
     If you lose, you lose *
     the amount you bet.   *
     ***********************
    )
   )
   (views
    (icon
     (origin 41 418)
     (extent 78 64)
     (iconImage "notepad.icon")
    )
    (detail
     (origin 231 478)
     (extent 249 205)
     (editing enabled)
    )
    (active icon)
   )
  )
  (component 32 "IFTHENELSE"
   (name "Outcome is:")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "roll")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Then")
     (lock name constraints)
    )
    (output 2
     (type data)
     (name "Else If")
     (lock name constraints)
    )
    (output 3
     (type data)
     (name "Else If")
     (lock name constraints)
    )
    (output 4
     (type data)
     (name "Else If")
     (lock name constraints)
    )
    (output 5
     (type data)
     (name "Else If")
     (lock name constraints)
    )
    (output 6
     (type data)
     (name "Else If")
     (lock name constraints)
    )
    (output 7
     (type data)
     (name "Else")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr "count==1 AND (roll==7 OR roll==11)")
    (component expr "count==1 AND (roll==2 OR roll==3 OR roll==12)")
    (component expr "(count==1 AND (roll==4 OR roll==5 OR roll==6 OR roll==8 OR roll==9 OR roll==10))*roll")
    (component expr "(count>1 AND roll==point)")
    (component expr "count>1 AND roll!=7")
    (component expr "count>1")
   )
   (views
    (icon
     (origin 225 343)
     (extent 110 74)
    )
    (detail
     (origin 59 283)
     (extent 793 214)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 34 "CONTEXT"
   (name "roll da dice")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Result")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (locked no)
    (trigMode deg)
    (nextID 8)
    (component 2 "FORMULA"
     (name " + ")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "X")
       (lock name constraints)
      )
      (input 2
       (type data)
       (name "Y")
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked yes)
      (component expr 1 "X+Y")
     )
     (views
      (icon
       (origin 177 378)
       (extent 46 25)
      )
      (detail
       (origin 605 375)
       (extent 61 110)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 3 "CONTEXT"
     (name "dice 2")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "X")
       (lock constraints)
       (optional yes)
      )
     )
     (implementation
      (locked no)
      (trigMode deg)
      (nextID 13)
      (component 0 "DEMULTIPLEXER"
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "Data")
         (lock name constraints)
        )
        (input 2
         (type data)
         (name "Addr")
         (requires
          (datatype Int32)
          (shape "Scalar")
         )
         (lock name constraints)
        )
        (output 1
         (type data)
         (name "Addr 0")
         (lock name constraints)
         (optional yes)
        )
        (output 2
         (type data)
         (name "Addr 1")
         (lock name constraints)
         (optional yes)
        )
        (output 3
         (type data)
         (name "Addr 2")
         (lock constraints)
         (optional yes)
        )
        (output 4
         (type data)
         (name "Addr 3")
         (lock constraints)
         (optional yes)
        )
        (output 5
         (type data)
         (name "Addr 4")
         (lock constraints)
         (optional yes)
        )
        (output 6
         (type data)
         (name "Addr 5")
         (lock constraints)
         (optional yes)
        )
        (output 7
         (type data)
         (name "Addr 6")
         (lock constraints)
         (optional yes)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 517 383)
         (extent 127 74)
        )
        (detail
         (origin 440 263)
         (extent 70 214)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "FORMULA"
       (name "round(x)")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "X")
         (lock name constraints)
        )
        (output 1
         (type data)
         (name "Result")
         (lock name constraints)
        )
       )
       (implementation
        (component isLocked yes)
        (component expr 1 "round(x)")
       )
       (views
        (icon
         (origin 375 408)
         (extent 110 25)
        )
        (detail
        )
        (terminals on)
        (active icon)
       )
      )
      (component 2 "CONTEXT"
       (name "1")
       (interface
        (sequence in)
        (sequence out)
       )
       (implementation
        (locked no)
        (trigMode deg)
        (nextID 3)
        (component 0 "NOTE"
         (name "1")
         (interface
         )
         (implementation
          (component text 2 11
           
             * 
          )
         )
         (views
          (icon
           (extent 78 0)
           (iconImage "notepad.icon")
          )
          (detail
           (origin 464 165)
           (extent 50 59)
           (editing disabled)
          )
          (title off)
          (active detail)
         )
        )
        (component 1 "EXITCONTEXT"
         (interface
          (sequence in)
         )
         (implementation
         )
         (views
          (icon
           (origin 577 262)
           (extent 145 25)
          )
          (detail
          )
          (terminals on)
          (active icon)
         )
        )
        (component 2 "DELAY"
         (interface
          (sequence in)
          (sequence out)
          (output 1
           (type data)
           (name "Done")
           (tag "Done")
           (lock constraints)
          )
         )
         (implementation
          (component delay 2)
         )
         (views
          (icon
           (origin 551 198)
           (extent 78 25)
          )
          (detail
           (origin 525 193)
           (extent 130 34)
          )
          (active icon)
         )
        )
        (configuration
         (connect D2:1 D1:0)
        )
        (ShowOnExecPanel
         (origin 620 311)
         (extent 100 122)
         (panel
          (origin 672 151)
          (extent 96 118)
          (pixmapImage "die1.xwd")
         )
         (title off)
        )
       )
       (views
        (icon
         (origin 0 130)
         (extent 46 0)
        )
        (detail
         (origin 439 144)
         (extent 350 300)
         (configuration
          (connect D2:1 D1:0
           (Point 631 210)
           (Point 649 210)
           (Point 649 259)
          )
         )
         (stackingOrder 0 1 2)
        )
        (title off)
        (active panel)
        (active panel)
       )
      )
      (component 3 "CONTEXT"
       (name "2")
       (interface
        (sequence in)
        (sequence out)
       )
       (implementation
        (locked no)
        (trigMode deg)
        (nextID 3)
        (component 0 "NOTE"
         (name "1")
         (interface
         )
         (implementation
          (component text 2 11
           
            * *
          )
         )
         (views
          (icon
           (extent 78 0)
           (iconImage "notepad.icon")
          )
          (detail
           (origin 464 335)
           (extent 50 59)
           (editing disabled)
          )
          (title off)
          (active detail)
         )
        )
        (component 1 "EXITCONTEXT"
         (interface
          (sequence in)
         )
         (implementation
         )
         (views
          (icon
           (origin 577 432)
           (extent 145 25)
          )
          (detail
          )
          (terminals on)
          (active icon)
         )
        )
        (component 2 "DELAY"
         (interface
          (sequence in)
          (sequence out)
          (output 1
           (type data)
           (name "Done")
           (tag "Done")
           (lock constraints)
          )
         )
         (implementation
          (component delay 2)
         )
         (views
          (icon
           (origin 611 338)
           (extent 78 25)
          )
          (detail
           (origin 585 333)
           (extent 130 34)
          )
          (active icon)
         )
        )
        (configuration
         (connect D2:1 D1:0)
        )
        (ShowOnExecPanel
         (origin 615 273)
         (extent 110 138)
         (panel
          (origin 667 283)
          (extent 106 134)
          (pixmapImage "die2.xwd")
         )
         (title off)
        )
       )
       (views
        (icon
         (origin 447 198)
         (extent 46 25)
        )
        (detail
         (origin 439 284)
         (extent 350 300)
         (configuration
          (connect D2:1 D1:0
           (Point 691 350)
           (Point 710 350)
           (Point 710 380)
           (Point 649 380)
           (Point 649 429)
          )
         )
         (stackingOrder 0 1 2)
        )
        (title off)
        (active panel)
        (active panel)
       )
      )
      (component 4 "CONTEXT"
       (name "3")
       (interface
        (sequence in)
        (sequence out)
       )
       (implementation
        (locked no)
        (trigMode deg)
        (nextID 3)
        (component 0 "NOTE"
         (name "1")
         (interface
         )
         (implementation
          (component text 3 11
           *  
             * 
               *
          )
         )
         (views
          (icon
           (extent 78 0)
           (iconImage "notepad.icon")
          )
          (detail
           (origin 470 421)
           (extent 50 59)
           (editing disabled)
          )
          (title off)
          (active detail)
         )
        )
        (component 1 "EXITCONTEXT"
         (interface
          (sequence in)
         )
         (implementation
         )
         (views
          (icon
           (origin 583 518)
           (extent 145 25)
          )
          (detail
          )
          (terminals on)
          (active icon)
         )
        )
        (component 2 "DELAY"
         (interface
          (sequence in)
          (sequence out)
          (output 1
           (type data)
           (name "Done")
           (tag "Done")
           (lock constraints)
          )
         )
         (implementation
          (component delay 2)
         )
         (views
          (icon
           (origin 621 418)
           (extent 78 25)
          )
          (detail
           (origin 595 413)
           (extent 130 34)
          )
          (active icon)
         )
        )
        (configuration
         (connect D2:1 D1:0)
        )
        (ShowOnExecPanel
         (origin 648 272)
         (extent 108 132)
         (panel
          (origin 678 376)
          (extent 104 128)
          (pixmapImage "die3.xwd")
         )
         (title off)
        )
       )
       (views
        (icon
         (origin 0 -10)
         (extent 46 0)
        )
        (detail
         (origin 445 370)
         (extent 350 300)
         (configuration
          (connect D2:1 D1:0
           (Point 701 430)
           (Point 720 430)
           (Point 720 460)
           (Point 655 460)
           (Point 655 515)
          )
         )
         (stackingOrder 0 1 2)
        )
        (title off)
        (active panel)
        (active panel)
       )
      )
      (component 5 "CONTEXT"
       (name "4")
       (interface
        (sequence in)
        (sequence out)
       )
       (implementation
        (locked no)
        (trigMode deg)
        (nextID 3)
        (component 0 "NOTE"
         (name "1")
         (interface
         )
         (implementation
          (component text 3 11
           *   *
              
           *   *
          )
         )
         (views
          (icon
           (extent 78 0)
           (iconImage "notepad.icon")
          )
          (detail
           (origin 460 421)
           (extent 50 59)
           (editing disabled)
          )
          (title off)
          (active detail)
         )
        )
        (component 1 "EXITCONTEXT"
         (interface
          (sequence in)
         )
         (implementation
         )
         (views
          (icon
           (origin 573 518)
           (extent 145 25)
          )
          (detail
          )
          (terminals on)
          (active icon)
         )
        )
        (component 2 "DELAY"
         (interface
          (sequence in)
          (sequence out)
          (output 1
           (type data)
           (name "Done")
           (tag "Done")
           (lock constraints)
          )
         )
         (implementation
          (component delay 2)
         )
         (views
          (icon
           (origin 606 418)
           (extent 78 25)
          )
          (detail
           (origin 580 413)
           (extent 130 34)
          )
          (active icon)
         )
        )
        (configuration
         (connect D2:1 D1:0)
        )
        (ShowOnExecPanel
         (origin 625 318)
         (extent 112 134)
         (panel
          (origin 666 465)
          (extent 108 130)
          (pixmapImage "die4.xwd")
         )
         (title off)
        )
       )
       (views
        (icon
         (origin 0 -90)
         (extent 46 0)
        )
        (detail
         (origin 435 370)
         (extent 350 300)
         (configuration
          (connect D2:1 D1:0
           (Point 686 430)
           (Point 705 430)
           (Point 705 460)
           (Point 645 460)
           (Point 645 515)
          )
         )
         (stackingOrder 0 1 2)
        )
        (title off)
        (active panel)
        (active panel)
       )
      )
      (component 6 "CONTEXT"
       (name "5")
       (interface
        (sequence in)
        (sequence out)
       )
       (implementation
        (locked no)
        (trigMode deg)
        (nextID 3)
        (component 0 "NOTE"
         (name "1")
         (interface
         )
         (implementation
          (component text 3 11
           *   *
             * 
           *   *
          )
         )
         (views
          (icon
           (extent 78 0)
           (iconImage "notepad.icon")
          )
          (detail
           (origin 474 415)
           (extent 50 59)
           (editing disabled)
          )
          (title off)
          (active detail)
         )
        )
        (component 1 "EXITCONTEXT"
         (interface
          (sequence in)
         )
         (implementation
         )
         (views
          (icon
           (origin 587 512)
           (extent 145 25)
          )
          (detail
          )
          (terminals on)
          (active icon)
         )
        )
        (component 2 "DELAY"
         (interface
          (sequence in)
          (sequence out)
          (output 1
           (type data)
           (name "Done")
           (tag "Done")
           (lock constraints)
          )
         )
         (implementation
          (component delay 2)
         )
         (views
          (icon
           (origin 620 412)
           (extent 78 25)
          )
          (detail
           (origin 594 407)
           (extent 130 34)
          )
          (active icon)
         )
        )
        (configuration
         (connect D2:1 D1:0)
        )
        (ShowOnExecPanel
         (origin 633 292)
         (extent 110 134)
         (panel
          (origin 677 565)
          (extent 106 130)
          (pixmapImage "die5.xwd")
         )
         (title off)
        )
       )
       (views
        (icon
         (origin 0 -100)
         (extent 46 0)
        )
        (detail
         (origin 449 364)
         (extent 350 300)
         (configuration
          (connect D2:1 D1:0
           (Point 700 424)
           (Point 719 424)
           (Point 719 454)
           (Point 659 454)
           (Point 659 509)
          )
         )
         (stackingOrder 0 1 2)
        )
        (title off)
        (active panel)
        (active panel)
       )
      )
      (component 7 "CONTEXT"
       (name "6")
       (interface
        (sequence in)
        (sequence out)
       )
       (implementation
        (locked no)
        (trigMode deg)
        (nextID 3)
        (component 0 "NOTE"
         (name "1")
         (interface
         )
         (implementation
          (component text 3 11
           *   *
           *   *
           *   *
          )
         )
         (views
          (icon
           (extent 78 0)
           (iconImage "notepad.icon")
          )
          (detail
           (origin 490 421)
           (extent 50 59)
           (editing disabled)
          )
          (title off)
          (active detail)
         )
        )
        (component 1 "EXITCONTEXT"
         (interface
          (sequence in)
         )
         (implementation
         )
         (views
          (icon
           (origin 603 518)
           (extent 145 25)
          )
          (detail
          )
          (terminals on)
          (active icon)
         )
        )
        (component 2 "DELAY"
         (interface
          (sequence in)
          (sequence out)
          (output 1
           (type data)
           (name "Done")
           (tag "Done")
           (lock constraints)
          )
         )
         (implementation
          (component delay 2)
         )
         (views
          (icon
           (origin 636 418)
           (extent 78 25)
          )
          (detail
           (origin 610 413)
           (extent 130 34)
          )
          (active icon)
         )
        )
        (configuration
         (connect D2:1 D1:0)
        )
        (ShowOnExecPanel
         (origin 604 194)
         (extent 104 136)
         (panel
          (origin 700 644)
          (extent 100 132)
          (pixmapImage "die6.xwd")
         )
         (title off)
        )
       )
       (views
        (icon
         (origin 627 518)
         (extent 46 25)
        )
        (detail
         (origin 465 370)
         (extent 350 300)
         (configuration
          (connect D2:1 D1:0
           (Point 716 430)
           (Point 735 430)
           (Point 735 460)
           (Point 675 460)
           (Point 675 515)
          )
         )
         (stackingOrder 0 1 2)
        )
        (title off)
        (active panel)
        (active panel)
       )
      )
      (component 8 "FORMULA"
       (name "random(low,high)")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "low")
         (requires
          (shape "Scalar")
         )
         (lock name constraints)
        )
        (input 2
         (type data)
         (name "high")
         (requires
          (shape "Scalar")
         )
         (lock name constraints)
        )
        (output 1
         (type data)
         (name "Result")
         (lock name constraints)
        )
       )
       (implementation
        (component isLocked yes)
        (component expr 1 "random(low,high)")
       )
       (views
        (icon
         (origin 203 408)
         (extent 154 25)
        )
        (detail
         (origin 211 485)
         (extent 178 110)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 9 "CONSTANT"
       (name "0.5")
       (subType "Real")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Real")
         (lock name constraints)
        )
       )
       (implementation
        (component value Real
         (name "0.5")
         (datum 0.5)
        )
        (component autoTrigger off)
        (component initializeAtPrerun off)
        (component initializeAtActivate off)
        (component initValue Real
         (name "Real")
         (datum 0)
        )
       )
       (views
        (icon
         (origin 127 378)
         (extent 46 25)
        )
        (detail
         (origin 80 374)
         (extent 120 32)
         (showFormat real)
        )
        (active icon)
       )
      )
      (component 10 "CONSTANT"
       (name "6.5")
       (subType "Real")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Real")
         (lock name constraints)
        )
       )
       (implementation
        (component value Real
         (name "6.5")
         (datum 6.5)
        )
        (component autoTrigger off)
        (component initializeAtPrerun off)
        (component initializeAtActivate off)
        (component initValue Real
         (name "Real")
         (datum 0)
        )
       )
       (views
        (icon
         (origin 127 438)
         (extent 46 25)
        )
        (detail
         (origin 50 494)
         (extent 120 32)
         (showFormat real)
        )
        (active icon)
       )
      )
      (component 12 "NOTE"
       (interface
       )
       (implementation
        (component text 9 9
         The random generator below is used to generate both the
         address and number used in all calculation and tests. 
         To display the dice each output of the deMultiplexer is
         connected to the sequence input of a user object that
         is configured for show on execution. This makes the die
         invisible until it is actually rolled. The numerical
         output the DeMultiplexer is used to keep track of the
         amout rolled and to make decisions concerning win, match
         and lose transactions.
        )
       )
       (views
        (icon
         (origin 215 168)
         (extent 110 64)
         (iconImage "notepad.icon")
        )
        (detail
         (origin 103 176)
         (extent 534 169)
         (editing disabled)
        )
        (active detail)
       )
      )
      (configuration
       (connect D1:1 D0:1)
       (connect D1:1 D0:2)
       (connect D8:1 D1:1)
       (connect D0:2 D2:0)
       (connect D0:3 D3:0)
       (connect D0:4 D4:0)
       (connect D0:5 D5:0)
       (connect D0:6 D6:0)
       (connect D0:7 D7:0)
       (connect D9:1 D8:1)
       (connect D10:1 D8:2)
       (connect D1:1 O1:1)
      )
     )
     (views
      (icon
       (origin 51 398)
       (extent 78 65)
      )
      (detail
       (origin 68 139)
       (extent 758 521)
       (configuration
        (connect D1:1 D0:1
         (Point 487 420)
         (Point 500 420)
         (Point 500 400)
         (Point 514 400)
        )
        (connect D1:1 D0:2
         (Point 487 420)
         (Point 500 420)
         (Point 500 440)
         (Point 514 440)
        )
        (connect D8:1 D1:1
         (Point 359 420)
         (Point 372 420)
        )
        (connect D0:2 D2:0
         (Point 646 400)
         (Point 800 400)
         (Point 800 260)
         (Point 790 260)
         (Point 790 140)
         (Point 720 140)
         (Point 720 148)
        )
        (connect D0:3 D3:0
         (Point 646 410)
         (Point 660 410)
         (Point 660 380)
         (Point 650 380)
         (Point 650 270)
         (Point 720 270)
         (Point 720 280)
        )
        (connect D0:4 D4:0
         (Point 646 420)
         (Point 660 420)
         (Point 660 410)
         (Point 720 410)
         (Point 720 360)
         (Point 730 360)
         (Point 730 373)
        )
        (connect D0:5 D5:0
         (Point 646 430)
         (Point 660 430)
         (Point 660 440)
         (Point 720 440)
         (Point 720 462)
        )
        (connect D0:6 D6:0
         (Point 646 440)
         (Point 660 440)
         (Point 660 460)
         (Point 650 460)
         (Point 650 470)
         (Point 640 470)
         (Point 640 540)
         (Point 730 540)
         (Point 730 562)
        )
        (connect D0:7 D7:0
         (Point 646 450)
         (Point 670 450)
         (Point 670 470)
         (Point 660 470)
         (Point 660 480)
         (Point 630 480)
         (Point 630 620)
         (Point 750 620)
         (Point 750 641)
        )
        (connect D9:1 D8:1
         (Point 175 390)
         (Point 190 390)
         (Point 190 410)
         (Point 200 410)
        )
        (connect D10:1 D8:2
         (Point 175 450)
         (Point 190 450)
         (Point 190 430)
         (Point 200 430)
        )
        (connect D1:1 O1:1
         (Point 487 420)
         (Point 500 420)
         (Point 500 650)
         (Point 810 650)
         (Point 810 409)
         (Point 823 409)
        )
       )
       (stackingOrder 2 3 4 5 6 7 8 0 1 10
         11 9)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 4 "CONTEXT"
     (name "dice 1")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "X")
       (lock constraints)
       (optional yes)
      )
     )
     (implementation
      (locked no)
      (trigMode deg)
      (nextID 12)
      (component 0 "DEMULTIPLEXER"
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "Data")
         (lock name constraints)
        )
        (input 2
         (type data)
         (name "Addr")
         (requires
          (datatype Int32)
          (shape "Scalar")
         )
         (lock name constraints)
        )
        (output 1
         (type data)
         (name "Addr 0")
         (lock name constraints)
         (optional yes)
        )
        (output 2
         (type data)
         (name "Addr 1")
         (lock name constraints)
         (optional yes)
        )
        (output 3
         (type data)
         (name "Addr 2")
         (lock constraints)
         (optional yes)
        )
        (output 4
         (type data)
         (name "Addr 3")
         (lock constraints)
         (optional yes)
        )
        (output 5
         (type data)
         (name "Addr 4")
         (lock constraints)
         (optional yes)
        )
        (output 6
         (type data)
         (name "Addr 5")
         (lock constraints)
         (optional yes)
        )
        (output 7
         (type data)
         (name "Addr 6")
         (lock constraints)
         (optional yes)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 474 392)
         (extent 127 74)
        )
        (detail
         (origin 440 263)
         (extent 70 214)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "FORMULA"
       (name "round(x)")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "X")
         (lock name constraints)
        )
        (output 1
         (type data)
         (name "Result")
         (lock name constraints)
        )
       )
       (implementation
        (component isLocked yes)
        (component expr 1 "round(x)")
       )
       (views
        (icon
         (origin 322 417)
         (extent 110 25)
        )
        (detail
        )
        (terminals on)
        (active icon)
       )
      )
      (component 2 "FORMULA"
       (name "random(low,high)")
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "low")
         (requires
          (shape "Scalar")
         )
         (lock name constraints)
        )
        (input 2
         (type data)
         (name "high")
         (requires
          (shape "Scalar")
         )
         (lock name constraints)
        )
        (output 1
         (type data)
         (name "Result")
         (lock name constraints)
        )
       )
       (implementation
        (component isLocked yes)
        (component expr 1 "random(low,high)")
       )
       (views
        (icon
         (origin 150 417)
         (extent 154 25)
        )
        (detail
         (origin 211 485)
         (extent 178 110)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 3 "NOTE"
       (interface
       )
       (implementation
        (component text 9 9
         The random generator below is used to generate both the
         address and number used in all calculation and tests. 
         To display the dice each output of the deMultiplexer is
         connected to the sequence input of a user object that
         is configured for show on execution. This makes the die
         invisible until it is actually rolled. The numerical
         output the DeMultiplexer is used to keep track of the
         amout rolled and to make decisions concerning win, match
         and lose transactions.
        )
       )
       (views
        (icon
         (origin 215 168)
         (extent 110 64)
         (iconImage "notepad.icon")
        )
        (detail
         (origin 90 185)
         (extent 534 169)
         (editing disabled)
        )
        (active detail)
       )
      )
      (component 4 "CONSTANT"
       (name "0.5")
       (subType "Real")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Real")
         (lock name constraints)
        )
       )
       (implementation
        (component value Real
         (name "0.5")
         (datum 0.5)
        )
        (component autoTrigger off)
        (component initializeAtPrerun off)
        (component initializeAtActivate off)
        (component initValue Real
         (name "Real")
         (datum 0)
        )
       )
       (views
        (icon
         (origin 77 378)
         (extent 46 25)
        )
        (detail
         (origin 80 374)
         (extent 120 32)
         (showFormat real)
        )
        (active icon)
       )
      )
      (component 5 "CONSTANT"
       (name "6.5")
       (subType "Real")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Real")
         (lock name constraints)
        )
       )
       (implementation
        (component value Real
         (name "6.5")
         (datum 6.5)
        )
        (component autoTrigger off)
        (component initializeAtPrerun off)
        (component initializeAtActivate off)
        (component initValue Real
         (name "Real")
         (datum 0)
        )
       )
       (views
        (icon
         (origin 77 448)
         (extent 46 25)
        )
        (detail
         (origin 50 494)
         (extent 120 32)
         (showFormat real)
        )
        (active icon)
       )
      )
      (component 6 "CONTEXT"
       (name "1")
       (interface
        (sequence in)
        (sequence out)
       )
       (implementation
        (locked no)
        (trigMode deg)
        (nextID 3)
        (component 0 "NOTE"
         (name "1")
         (interface
         )
         (implementation
          (component text 2 11
           
             * 
          )
         )
         (views
          (icon
           (extent 78 0)
           (iconImage "notepad.icon")
          )
          (detail
           (origin 474 189)
           (extent 50 59)
           (editing disabled)
          )
          (title off)
          (active detail)
         )
        )
        (component 1 "EXITCONTEXT"
         (interface
          (sequence in)
         )
         (implementation
         )
         (views
          (icon
           (origin 587 286)
           (extent 145 25)
          )
          (detail
          )
          (terminals on)
          (active icon)
         )
        )
        (component 2 "DELAY"
         (interface
          (sequence in)
          (sequence out)
          (output 1
           (type data)
           (name "Done")
           (tag "Done")
           (lock constraints)
          )
         )
         (implementation
          (component delay 2)
         )
         (views
          (icon
           (origin 621 188)
           (extent 78 25)
          )
          (detail
           (origin 599 181)
           (extent 130 34)
          )
          (active detail)
         )
        )
        (configuration
         (connect D2:1 D1:0)
        )
        (ShowOnExecPanel
         (origin 309 375)
         (extent 100 122)
         (panel
          (origin 679 160)
          (extent 96 118)
          (pixmapImage "die1.xwd")
         )
         (title off)
        )
       )
       (views
        (icon
         (origin 0 120)
         (extent 46 0)
        )
        (detail
         (origin 449 138)
         (extent 350 300)
         (configuration
          (connect D2:1 D1:0
           (Point 731 198)
           (Point 724 198)
           (Point 724 228)
           (Point 659 228)
           (Point 659 283)
          )
         )
         (stackingOrder 0 1 2)
        )
        (title off)
        (active panel)
        (active panel)
       )
      )
      (component 7 "CONTEXT"
       (name "2")
       (interface
        (sequence in)
        (sequence out)
       )
       (implementation
        (locked no)
        (trigMode deg)
        (nextID 3)
        (component 0 "NOTE"
         (name "1")
         (interface
         )
         (implementation
          (component text 2 11
           
            * *
          )
         )
         (views
          (icon
           (extent 78 0)
           (iconImage "notepad.icon")
          )
          (detail
           (origin 490 331)
           (extent 50 59)
           (editing disabled)
          )
          (title off)
          (active detail)
         )
        )
        (component 1 "EXITCONTEXT"
         (interface
          (sequence in)
         )
         (implementation
         )
         (views
          (icon
           (origin 603 428)
           (extent 145 25)
          )
          (detail
          )
          (terminals on)
          (active icon)
         )
        )
        (component 2 "DELAY"
         (interface
          (sequence in)
          (sequence out)
          (output 1
           (type data)
           (name "Done")
           (tag "Done")
           (lock constraints)
          )
         )
         (implementation
          (component delay 2)
         )
         (views
          (icon
           (origin 619 331)
           (extent 78 25)
          )
          (detail
           (origin 610 323)
           (extent 130 34)
          )
          (active detail)
         )
        )
        (configuration
         (connect D2:1 D1:0)
        )
        (ShowOnExecPanel
         (origin 317 214)
         (extent 110 138)
         (panel
          (origin 674 292)
          (extent 106 134)
          (pixmapImage "die2.xwd")
         )
         (title off)
        )
       )
       (views
        (icon
         (origin 447 198)
         (extent 46 25)
        )
        (detail
         (origin 465 280)
         (extent 350 300)
         (configuration
          (connect D2:1 D1:0
           (Point 742 340)
           (Point 735 340)
           (Point 735 370)
           (Point 675 370)
           (Point 675 425)
          )
         )
         (stackingOrder 0 1 2)
        )
        (title off)
        (active panel)
        (active panel)
       )
      )
      (component 8 "CONTEXT"
       (name "3")
       (interface
        (sequence in)
        (sequence out)
       )
       (implementation
        (locked no)
        (trigMode deg)
        (nextID 3)
        (component 0 "NOTE"
         (name "1")
         (interface
         )
         (implementation
          (component text 3 11
           *  
             * 
               *
          )
         )
         (views
          (icon
           (extent 78 0)
           (iconImage "notepad.icon")
          )
          (detail
           (origin 490 421)
           (extent 50 59)
           (editing disabled)
          )
          (title off)
          (active detail)
         )
        )
        (component 1 "EXITCONTEXT"
         (interface
          (sequence in)
         )
         (implementation
         )
         (views
          (icon
           (origin 603 518)
           (extent 145 25)
          )
          (detail
          )
          (terminals on)
          (active icon)
         )
        )
        (component 2 "DELAY"
         (interface
          (sequence in)
          (sequence out)
          (output 1
           (type data)
           (name "Done")
           (tag "Done")
           (lock constraints)
          )
         )
         (implementation
          (component delay 2)
         )
         (views
          (icon
           (origin 641 418)
           (extent 78 25)
          )
          (detail
           (origin 615 413)
           (extent 130 34)
          )
          (active detail)
         )
        )
        (configuration
         (connect D2:1 D1:0)
        )
        (ShowOnExecPanel
         (origin 302 348)
         (extent 108 132)
         (panel
          (origin 685 425)
          (extent 104 128)
          (pixmapImage "die3.xwd")
         )
         (title off)
        )
       )
       (views
        (icon
         (origin 0 -10)
         (extent 46 0)
        )
        (detail
         (origin 465 370)
         (extent 350 300)
         (configuration
          (connect D2:1 D1:0
           (Point 747 430)
           (Point 740 430)
           (Point 740 460)
           (Point 675 460)
           (Point 675 515)
          )
         )
         (stackingOrder 0 1 2)
        )
        (title off)
        (active panel)
        (active panel)
       )
      )
      (component 9 "CONTEXT"
       (name "4")
       (interface
        (sequence in)
        (sequence out)
       )
       (implementation
        (locked no)
        (trigMode deg)
        (nextID 3)
        (component 0 "NOTE"
         (name "1")
         (interface
         )
         (implementation
          (component text 3 11
           *   *
              
           *   *
          )
         )
         (views
          (icon
           (extent 78 0)
           (iconImage "notepad.icon")
          )
          (detail
           (origin 474 419)
           (extent 50 59)
           (editing disabled)
          )
          (title off)
          (active detail)
         )
        )
        (component 1 "EXITCONTEXT"
         (interface
          (sequence in)
         )
         (implementation
         )
         (views
          (icon
           (origin 587 516)
           (extent 145 25)
          )
          (detail
          )
          (terminals on)
          (active icon)
         )
        )
        (component 2 "DELAY"
         (interface
          (sequence in)
          (sequence out)
          (output 1
           (type data)
           (name "Done")
           (tag "Done")
           (lock constraints)
          )
         )
         (implementation
          (component delay 2)
         )
         (views
          (icon
           (origin 620 416)
           (extent 78 25)
          )
          (detail
           (origin 594 411)
           (extent 130 34)
          )
          (active detail)
         )
        )
        (configuration
         (connect D2:1 D1:0)
        )
        (ShowOnExecPanel
         (origin 311 281)
         (extent 112 134)
         (panel
          (origin 663 514)
          (extent 108 130)
          (pixmapImage "die4.xwd")
         )
         (title off)
        )
       )
       (views
        (icon
         (origin 0 -90)
         (extent 46 0)
        )
        (detail
         (origin 449 368)
         (extent 350 300)
         (configuration
          (connect D2:1 D1:0
           (Point 726 428)
           (Point 719 428)
           (Point 719 458)
           (Point 659 458)
           (Point 659 513)
          )
         )
         (stackingOrder 0 1 2)
        )
        (title off)
        (active panel)
        (active panel)
       )
      )
      (component 10 "CONTEXT"
       (name "5")
       (interface
        (sequence in)
        (sequence out)
       )
       (implementation
        (locked no)
        (trigMode deg)
        (nextID 3)
        (component 0 "NOTE"
         (name "1")
         (interface
         )
         (implementation
          (component text 3 11
           *   *
             * 
           *   *
          )
         )
         (views
          (icon
           (extent 78 0)
           (iconImage "notepad.icon")
          )
          (detail
           (origin 484 429)
           (extent 50 59)
           (editing disabled)
          )
          (title off)
          (active detail)
         )
        )
        (component 1 "EXITCONTEXT"
         (interface
          (sequence in)
         )
         (implementation
         )
         (views
          (icon
           (origin 597 526)
           (extent 145 25)
          )
          (detail
          )
          (terminals on)
          (active icon)
         )
        )
        (component 2 "DELAY"
         (interface
          (sequence in)
          (sequence out)
          (output 1
           (type data)
           (name "Done")
           (tag "Done")
           (lock constraints)
          )
         )
         (implementation
          (component delay 2)
         )
         (views
          (icon
           (origin 633 423)
           (extent 78 25)
          )
          (detail
           (origin 607 418)
           (extent 130 34)
          )
          (active detail)
         )
        )
        (configuration
         (connect D2:1 D1:0)
        )
        (ShowOnExecPanel
         (origin 305 297)
         (extent 110 134)
         (panel
          (origin 674 604)
          (extent 106 130)
          (pixmapImage "die5.xwd")
         )
         (title off)
        )
       )
       (views
        (icon
         (origin 0 -90)
         (extent 46 0)
        )
        (detail
         (origin 459 368)
         (extent 350 300)
         (configuration
          (connect D2:1 D1:0
           (Point 739 435)
           (Point 732 435)
           (Point 732 465)
           (Point 669 465)
           (Point 669 523)
          )
         )
         (stackingOrder 0 1 2)
        )
        (title off)
        (active panel)
        (active panel)
       )
      )
      (component 11 "CONTEXT"
       (name "6")
       (interface
        (sequence in)
        (sequence out)
       )
       (implementation
        (locked no)
        (trigMode deg)
        (nextID 3)
        (component 0 "NOTE"
         (name "1")
         (interface
         )
         (implementation
          (component text 3 11
           *   *
           *   *
           *   *
          )
         )
         (views
          (icon
           (extent 78 0)
           (iconImage "notepad.icon")
          )
          (detail
           (origin 490 421)
           (extent 50 59)
           (editing disabled)
          )
          (title off)
          (active detail)
         )
        )
        (component 1 "EXITCONTEXT"
         (interface
          (sequence in)
         )
         (implementation
         )
         (views
          (icon
           (origin 603 518)
           (extent 145 25)
          )
          (detail
          )
          (terminals on)
          (active icon)
         )
        )
        (component 2 "DELAY"
         (interface
          (sequence in)
          (sequence out)
          (output 1
           (type data)
           (name "Done")
           (tag "Done")
           (lock constraints)
          )
         )
         (implementation
          (component delay 2)
         )
         (views
          (icon
           (origin 636 418)
           (extent 78 25)
          )
          (detail
           (origin 610 413)
           (extent 130 34)
          )
          (active icon)
         )
        )
        (configuration
         (connect D2:1 D1:0)
        )
        (ShowOnExecPanel
         (origin 349 272)
         (extent 104 136)
         (panel
          (origin 687 693)
          (extent 100 132)
          (pixmapImage "die6.xwd")
         )
         (title off)
        )
       )
       (views
        (icon
         (origin 0 -90)
         (extent 46 0)
        )
        (detail
         (origin 465 370)
         (extent 350 300)
         (configuration
          (connect D2:1 D1:0
           (Point 716 430)
           (Point 735 430)
           (Point 735 460)
           (Point 675 460)
           (Point 675 515)
          )
         )
         (stackingOrder 0 1 2)
        )
        (title off)
        (active panel)
        (active panel)
       )
      )
      (configuration
       (connect D1:1 D0:1)
       (connect D1:1 D0:2)
       (connect D2:1 D1:1)
       (connect D4:1 D2:1)
       (connect D5:1 D2:2)
       (connect D0:2 D6:0)
       (connect D0:3 D7:0)
       (connect D0:4 D8:0)
       (connect D0:5 D9:0)
       (connect D0:6 D10:0)
       (connect D0:7 D11:0)
       (connect D1:1 O1:1)
      )
     )
     (views
      (icon
       (origin 51 318)
       (extent 78 65)
      )
      (detail
       (origin 70 143)
       (extent 755 532)
       (configuration
        (connect D1:1 D0:1
         (Point 434 429)
         (Point 447 429)
         (Point 447 409)
         (Point 471 409)
        )
        (connect D1:1 D0:2
         (Point 434 429)
         (Point 447 429)
         (Point 447 449)
         (Point 471 449)
        )
        (connect D2:1 D1:1
         (Point 306 429)
         (Point 319 429)
        )
        (connect D4:1 D2:1
         (Point 125 390)
         (Point 140 390)
         (Point 140 419)
         (Point 147 419)
        )
        (connect D5:1 D2:2
         (Point 125 460)
         (Point 140 460)
         (Point 140 439)
         (Point 147 439)
        )
        (connect D0:2 D6:0
         (Point 603 409)
         (Point 617 409)
         (Point 617 399)
         (Point 637 399)
         (Point 637 269)
         (Point 657 269)
         (Point 657 149)
         (Point 727 149)
         (Point 727 157)
        )
        (connect D0:3 D7:0
         (Point 603 419)
         (Point 647 419)
         (Point 647 279)
         (Point 727 279)
         (Point 727 289)
        )
        (connect D0:4 D8:0
         (Point 603 429)
         (Point 617 429)
         (Point 617 409)
         (Point 737 409)
         (Point 737 422)
        )
        (connect D0:5 D9:0
         (Point 603 439)
         (Point 617 439)
         (Point 617 449)
         (Point 667 449)
         (Point 667 499)
         (Point 717 499)
         (Point 717 511)
        )
        (connect D0:6 D10:0
         (Point 603 449)
         (Point 617 449)
         (Point 617 579)
         (Point 727 579)
         (Point 727 601)
        )
        (connect D0:7 D11:0
         (Point 603 459)
         (Point 637 459)
         (Point 637 679)
         (Point 737 679)
         (Point 737 690)
        )
        (connect D1:1 O1:1
         (Point 434 429)
         (Point 447 429)
         (Point 447 449)
         (Point 457 449)
         (Point 457 489)
         (Point 807 489)
         (Point 807 419)
         (Point 822 419)
        )
       )
       (stackingOrder 8 9 10 11 2 1 6 7 0 3
         4 5)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 5 "FORMULA"
     (name "count++")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "count+1")
     )
     (views
      (icon
       (origin 51 248)
       (extent 78 25)
      )
      (detail
       (origin 122 449)
       (extent 97 62)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 7 "TOGLOBAL"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
       (tag "Data")
      )
     )
     (implementation
      (component globalName count)
     )
     (views
      (icon
       (origin 195 248)
       (extent 110 25)
      )
      (detail
       (origin 322 449)
       (extent 97 62)
      )
      (terminals on)
      (active icon)
     )
    )
    (configuration
     (connect D2:1 D0:1)
     (connect D1:1 D0:2)
     (connect D3:1 D4:1)
     (connect D0:1 O1:1)
    )
   )
   (views
    (icon
     (origin 91 368)
     (extent 118 25)
    )
    (detail
     (origin 35 237)
     (extent 330 287)
     (configuration
      (connect D2:1 D0:1
       (Point 131 350)
       (Point 150 350)
       (Point 150 380)
       (Point 174 380)
      )
      (connect D1:1 D0:2
       (Point 131 430)
       (Point 150 430)
       (Point 150 400)
       (Point 174 400)
      )
      (connect D3:1 D4:1
       (Point 131 260)
       (Point 192 260)
      )
      (connect D0:1 O1:1
       (Point 225 390)
       (Point 362 390)
      )
     )
     (stackingOrder 3 4 0 2 1)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 39 "NOTE"
   (interface
   )
   (implementation
   )
   (views
    (icon
     (origin 11 626)
     (extent 338 48)
     (label off)
     (iconImage "disclaim.icon")
    )
    (detail
     (origin 90 590)
     (extent 200 100)
     (editing enabled)
    )
    (active icon)
   )
  )
  (component 47 "CONTEXT"
   (name "init Globals")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (locked no)
    (trigMode deg)
    (nextID 13)
    (component 0 "CONSTANT"
     (name "Integer")
     (subType "Integer")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Int32")
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Integer")
       (datum 0)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (name "LongInt")
       (datum 0)
      )
     )
     (views
      (icon
       (origin 71 158)
       (extent 78 25)
      )
      (detail
       (origin 50 173)
       (extent 140 34)
       (showFormat int)
      )
      (active detail)
     )
    )
    (component 1 "TOGLOBAL"
     (name "Set count Global")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
       (tag "Data")
      )
     )
     (implementation
      (component globalName count)
     )
     (views
      (icon
       (origin 223 178)
       (extent 154 25)
      )
      (detail
       (origin 662 209)
       (extent 136 62)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "FORMULA"
     (name "Get the time")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "now() MOD (2^31)")
     )
     (views
      (icon
       (origin 61 498)
       (extent 118 25)
      )
      (detail
       (origin 70 139)
       (extent 180 62)
      )
      (active icon)
     )
    )
    (component 3 "RANDOMNUMBERSEED"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Seed")
       (requires
        (datatype Int32)
        (shape "Scalar")
       )
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 215 498)
       (extent 110 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 4 "TOGLOBAL"
     (name "Set BankRoll Global")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
       (tag "Data")
      )
     )
     (implementation
      (component globalName bankroll)
     )
     (views
      (icon
       (origin 230 258)
       (extent 181 25)
      )
      (detail
       (origin 239 219)
       (extent 163 62)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 5 "CONSTANT"
     (name "Integer")
     (subType "Integer")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Int32")
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Integer")
       (datum 100)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (name "LongInt")
       (datum 0)
      )
     )
     (views
      (icon
       (origin 71 238)
       (extent 78 25)
      )
      (detail
       (origin 50 253)
       (extent 140 34)
       (showFormat int)
      )
      (active detail)
     )
    )
    (component 7 "TOGLOBAL"
     (name "Set Bet Global")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
       (tag "Data")
      )
     )
     (implementation
      (component globalName bet)
     )
     (views
      (icon
       (origin 232 338)
       (extent 136 25)
      )
      (detail
       (origin 239 319)
       (extent 163 62)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 9 "TOGLOBAL"
     (name "Set Point Global")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
       (tag "Data")
      )
     )
     (implementation
      (component globalName point)
     )
     (views
      (icon
       (origin 233 428)
       (extent 154 25)
      )
      (detail
       (origin 282 399)
       (extent 136 62)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 10 "LITERALCONSTANT"
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Text")
       (lock name constraints)
      )
     )
     (implementation
      (component value Text
       (name "Text")
       (datum "")
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Text
       (name "CString")
       (datum "")
      )
     )
     (views
      (icon
      )
      (detail
       (origin 4 424)
       (extent 192 32)
      )
      (active detail)
     )
    )
    (component 12 "CONSTANT"
     (name "Integer")
     (subType "Integer")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Int32")
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Integer")
       (datum 0)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (name "LongInt")
       (datum 0)
      )
     )
     (views
      (icon
       (origin 71 158)
       (extent 78 25)
      )
      (detail
       (origin 50 333)
       (extent 140 34)
       (showFormat int)
      )
      (active detail)
     )
    )
    (configuration
     (connect D0:1 D1:1)
     (connect D2:1 D3:1)
     (connect D5:1 D4:1)
     (connect D9:1 D6:1)
     (connect D8:1 D7:1)
    )
   )
   (views
    (icon
     (origin 13 87)
     (extent 135 26)
    )
    (detail
     (origin 35 112)
     (extent 411 437)
     (configuration
      (connect D0:1 D1:1
       (Point 192 190)
       (Point 220 190)
      )
      (connect D2:1 D3:1
       (Point 181 510)
       (Point 212 510)
      )
      (connect D5:1 D4:1
       (Point 192 270)
       (Point 227 270)
      )
      (connect D9:1 D6:1
       (Point 192 350)
       (Point 229 350)
      )
      (connect D8:1 D7:1
       (Point 198 440)
       (Point 230 440)
      )
     )
     (stackingOrder 5 4 0 1 2 3 7 6 8 9)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 51 "TOGLOBAL"
   (name "Set Point Global")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
     (tag "Data")
    )
   )
   (implementation
    (component globalName point)
   )
   (views
    (icon
     (origin 403 318)
     (extent 154 25)
    )
    (detail
     (origin 532 149)
     (extent 136 62)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 59 "FROMGLOBAL"
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Data")
     (tag "Data")
     (lock name constraints)
    )
    (output 2
     (type exception)
     (name "Error")
     (lock name constraints)
     (optional yes)
    )
   )
   (implementation
    (component globalName point)
   )
   (views
    (icon
     (origin 405 168)
     (extent 110 25)
    )
    (detail
     (origin 727 118)
     (extent 97 64)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 62 "FROMGLOBAL"
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Data")
     (tag "Data")
     (lock name constraints)
    )
    (output 2
     (type exception)
     (name "Error")
     (lock name constraints)
     (optional yes)
    )
   )
   (implementation
    (component globalName bankroll)
   )
   (views
    (icon
     (origin 405 88)
     (extent 110 25)
    )
    (detail
     (origin 697 568)
     (extent 97 64)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 65 "IFTHENELSE"
   (name "Change Bet?")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Then")
     (lock name constraints)
    )
    (output 2
     (type data)
     (name "Else If")
     (lock name constraints)
    )
    (output 3
     (type data)
     (name "Else")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr "count==0 AND bankroll<=0")
    (component expr "count==0")
   )
   (views
    (icon
     (origin 25 223)
     (extent 110 34)
    )
    (detail
     (origin 33 203)
     (extent 244 94)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 71 "CONTEXT"
   (name "Place Your Bet")
   (description 3 4
    This is a dialog box. It's construction shows a
    generic method of constructing objects that will
    interact with users.
   )
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (locked no)
    (trigMode deg)
    (nextID 17)
    (component 1 "CONFIRM"
     (name "  OK  ")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Go")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 182 242)
       (extent 76 37)
      )
      (detail
       (origin 381 270)
       (extent 68 40)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 3 "EXITCONTEXT"
     (interface
      (sequence in)
     )
     (implementation
     )
     (views
      (icon
       (origin 48 538)
       (extent 145 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 5 "CONSTANT"
     (name "Integer")
     (subType "Integer")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Default Value")
       (requires
        (datatype Int32)
        (shape "Scalar")
       )
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (name "Int32")
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Integer")
       (datum 50)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (name "LongInt")
       (datum 0)
      )
     )
     (views
      (icon
      )
      (detail
       (origin 215 324)
       (extent 150 32)
       (showFormat int)
      )
      (active detail)
     )
    )
    (component 6 "NOTE"
     (interface
     )
     (implementation
      (component text 1 7
       Enter Amount to Bet
      )
     )
     (views
      (icon
       (iconImage "notepad.icon")
      )
      (detail
       (origin 135 136)
       (extent 210 29)
       (editing disabled)
      )
      (title off)
      (active detail)
     )
    )
    (component 7 "TOGLOBAL"
     (name "Set bet Global")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
       (tag "Data")
      )
     )
     (implementation
      (component globalName bet)
     )
     (views
      (icon
       (origin 282 428)
       (extent 136 25)
      )
      (detail
       (origin 311 459)
       (extent 118 62)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 11 "IFTHENELSE"
     (name "In Range?")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a>0 AND a<=bankroll")
     )
     (views
      (icon
       (origin 65 398)
       (extent 110 25)
      )
      (detail
       (origin 83 416)
       (extent 204 68)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 12 "CONTEXT"
     (name "ERROR")
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (locked no)
      (trigMode deg)
      (nextID 3)
      (component 0 "NOTE"
       (interface
       )
       (implementation
        (component text 3 9
         BET MUST BE GREATER
         THAN 0, BUT NO MORE
         THAN YOUR BANKROLL.
        )
       )
       (views
        (icon
         (iconImage "notepad.icon")
        )
        (detail
         (origin 90 364)
         (extent 180 92)
         (editing enabled)
        )
        (active detail)
       )
      )
      (component 1 "DELAY"
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Done")
         (tag "Done")
         (lock constraints)
        )
       )
       (implementation
        (component delay 2)
       )
       (views
        (icon
        )
        (detail
         (origin 50 534)
         (extent 120 32)
        )
        (active detail)
       )
      )
      (component 2 "EXITCONTEXT"
       (interface
        (sequence in)
       )
       (implementation
       )
       (views
        (icon
         (origin 138 578)
         (extent 145 25)
        )
        (detail
        )
        (terminals on)
        (active icon)
       )
      )
      (configuration
       (connect D1:1 D2:0)
      )
      (ShowOnExecPanel
       (origin 397 156)
       (extent 216 166)
       (panel
        (origin 104 411)
        (extent 212 138)
        (widget 0 detail
         (title off)
         (origin 122 422)
         (extent 180 92)
         (editing disabled)
        )
       )
      )
     )
     (views
      (icon
       (origin 171 428)
       (extent 78 25)
      )
      (detail
       (origin 25 320)
       (extent 350 300)
       (configuration
        (connect D1:1 D2:0
         (Point 172 550)
         (Point 210 550)
         (Point 210 575)
        )
       )
       (stackingOrder 0 1 2)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 13 "REPEATUNTILBREAK"
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Continuous")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 55 188)
       (extent 110 64)
       (iconImage "loop.icon")
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 14 "FORMULA"
     (name "Get bet Global")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "(bet>bankroll ? bankroll : bet)")
     )
     (views
      (icon
       (origin 42 328)
       (extent 136 25)
      )
      (detail
       (origin 65 320)
       (extent 230 61)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 15 "TOGLOBAL"
     (name "Set bankroll Global")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
       (tag "Data")
      )
     )
     (implementation
      (component globalName bankroll)
     )
     (views
      (icon
       (origin 230 488)
       (extent 181 25)
      )
      (detail
       (origin 259 519)
       (extent 163 62)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 16 "FORMULA"
     (name "Update bankroll")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "bankroll-bet")
     )
     (views
      (icon
       (origin 48 488)
       (extent 145 25)
      )
      (detail
       (origin 67 579)
       (extent 207 43)
      )
      (active icon)
     )
    )
    (configuration
     (connect D7:1 D0:0)
     (connect D10:0 D1:0)
     (connect D0:1 D2:0)
     (connect D8:1 D2:1)
     (connect D5:1 D4:0)
     (connect D2:1 D4:1)
     (connect D2:1 D5:1)
     (connect D5:2 D6:0)
     (connect D10:1 D9:1)
     (connect D4:0 D10:0)
    )
    (ShowOnExecPanel
     (origin 339 242)
     (extent 339 194)
     (panel
      (origin 233 457)
      (extent 335 166)
      (widget 3 detail
       (title off)
       (origin 293 471)
       (extent 210 29)
       (editing disabled)
      )
      (widget 2 detail
       (title off)
       (origin 333 523)
       (extent 145 30)
       (showFormat int)
      )
      (widget 0 icon
       (title off)
       (origin 367 570)
       (extent 76 37)
      )
     )
    )
   )
   (views
    (icon
     (origin 112 288)
     (extent 136 25)
    )
    (detail
     (origin 32 103)
     (extent 437 534)
     (configuration
      (connect D7:1 D0:0
       (Point 167 220)
       (Point 220 220)
       (Point 220 239)
      )
      (connect D10:0 D1:0
       (Point 120 515)
       (Point 120 535)
      )
      (connect D0:1 D2:0
       (Point 260 260)
       (Point 290 260)
       (Point 290 293)
      )
      (connect D8:1 D2:1
       (Point 180 340)
       (Point 212 340)
      )
      (connect D5:1 D4:0
       (Point 177 400)
       (Point 350 400)
       (Point 350 425)
      )
      (connect D2:1 D4:1
       (Point 367 340)
       (Point 390 340)
       (Point 390 380)
       (Point 270 380)
       (Point 270 440)
       (Point 279 440)
      )
      (connect D2:1 D5:1
       (Point 367 340)
       (Point 390 340)
       (Point 390 380)
       (Point 50 380)
       (Point 50 410)
       (Point 62 410)
      )
      (connect D5:2 D6:0
       (Point 177 420)
       (Point 210 420)
       (Point 210 425)
      )
      (connect D10:1 D9:1
       (Point 195 500)
       (Point 227 500)
      )
      (connect D4:0 D10:0
       (Point 350 455)
       (Point 350 470)
       (Point 120 470)
       (Point 120 485)
      )
     )
     (stackingOrder 2 8 5 6 4 10 9 1 0 7
       3)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 75 "ONCYCLE"
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Alarm")
     (lock name constraints)
    )
   )
   (implementation
    (component cycle 1)
   )
   (views
    (icon
     (iconImage "loop.icon")
    )
    (detail
     (origin 220 114)
     (extent 140 32)
    )
    (active detail)
   )
  )
  (component 76 "ACCUMULATOR"
   (name "# tries for point")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
     (tag "InData")
     (requires
      (shape "Scalar")
     )
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Data")
     (tag "accumData")
     (lock name constraints)
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (origin 399 428)
     (extent 163 25)
    )
    (detail
     (origin 418 447)
     (extent 225 27)
    )
    (active icon)
   )
  )
  (component 81 "CONTEXT"
   (name "oops!")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (locked no)
    (trigMode deg)
    (nextID 12)
    (component 1 "DELAY"
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Done")
       (tag "Done")
       (lock constraints)
      )
     )
     (implementation
      (component delay 2)
     )
     (views
      (icon
      )
      (detail
       (origin 402 65)
       (extent 130 34)
      )
      (active detail)
     )
    )
    (component 2 "EXITCONTEXT"
     (interface
      (sequence in)
     )
     (implementation
     )
     (views
      (icon
       (origin 558 68)
       (extent 145 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 7 "CONSTANT"
     (name "Integer")
     (subType "Integer")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Int32")
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Integer")
       (datum 0)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (name "LongInt")
       (datum 0)
      )
     )
     (views
      (icon
      )
      (detail
       (origin 370 173)
       (extent 140 34)
       (showFormat int)
      )
      (active detail)
     )
    )
    (component 6 "TOGLOBAL"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
       (tag "Data")
      )
     )
     (implementation
      (component globalName count)
     )
     (views
      (icon
      )
      (detail
       (origin 582 159)
       (extent 97 62)
      )
      (terminals on)
      (active detail)
     )
    )
    (component 10 "TOGLOBAL"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
       (tag "Data")
      )
     )
     (implementation
      (component globalName point)
     )
     (views
      (icon
      )
      (detail
       (origin 582 259)
       (extent 97 62)
      )
      (terminals on)
      (active detail)
     )
    )
    (component 11 "LITERALCONSTANT"
     (name "\"\"")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Text")
       (lock name constraints)
      )
     )
     (implementation
      (component value Text
       (name "\"\"")
       (datum "")
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Text
       (name "CString")
       (datum "")
      )
     )
     (views
      (icon
       (extent 46 0)
      )
      (detail
       (origin 368 273)
       (extent 145 35)
      )
      (active detail)
     )
    )
    (configuration
     (connect D0:1 D1:0)
     (connect D2:1 D3:1)
     (connect D5:1 D4:1)
    )
    (ShowOnExecPanel
     (origin 272 173)
     (extent 472 361)
     (panel
      (origin 346 354)
      (extent 468 333)
      (pixmapImage "lose.gif")
     )
    )
   )
   (views
    (icon
     (origin 481 508)
     (extent 78 25)
    )
    (detail
     (origin 368 22)
     (extent 365 317)
     (configuration
      (connect D0:1 D1:0
       (Point 534 82)
       (Point 540 82)
       (Point 540 50)
       (Point 630 50)
       (Point 630 65)
      )
      (connect D2:1 D3:1
       (Point 512 190)
       (Point 529 190)
      )
      (connect D5:1 D4:1
       (Point 515 290)
       (Point 529 290)
      )
     )
     (stackingOrder 0 3 2 1 5 4)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 82 "FROMGLOBAL"
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Data")
     (tag "Data")
     (lock name constraints)
    )
    (output 2
     (type exception)
     (name "Error")
     (lock name constraints)
     (optional yes)
    )
   )
   (implementation
    (component globalName bet)
   )
   (views
    (icon
     (origin 405 128)
     (extent 110 25)
    )
    (detail
     (origin 397 158)
     (extent 97 64)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 83 "TEXTDISPLAY"
   (name "Your Bet")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (origin 685 128)
     (extent 110 25)
    )
    (detail
     (origin 645 122)
     (extent 190 37)
    )
    (active icon)
   )
  )
  (component 87 "CONTEXT"
   (name "Bankrupt")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (locked no)
    (trigMode deg)
    (nextID 8)
    (component 2 "TOGLOBAL"
     (name "Set bet Global")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
       (tag "Data")
      )
     )
     (implementation
      (component globalName bet)
     )
     (views
      (icon
       (origin 232 178)
       (extent 136 25)
      )
      (detail
       (origin 471 299)
       (extent 118 62)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 3 "CONSTANT"
     (name "Integer")
     (subType "Integer")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Int32")
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Integer")
       (datum 0)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (name "LongInt")
       (datum 0)
      )
     )
     (views
      (icon
       (origin 131 178)
       (extent 78 25)
      )
      (detail
       (origin 340 173)
       (extent 140 34)
       (showFormat int)
      )
      (active icon)
     )
    )
    (component 4 "DELAY"
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Done")
       (tag "Done")
       (lock constraints)
      )
     )
     (implementation
      (component delay 2)
     )
     (views
      (icon
      )
      (detail
       (origin 120 264)
       (extent 120 32)
      )
      (active detail)
     )
    )
    (component 5 "EXITPROCESS"
     (interface
      (sequence in)
     )
     (implementation
      (comp code 0)
     )
     (views
      (icon
       (iconImage "stop.icon")
      )
      (detail
       (origin 255 344)
       (extent 110 32)
      )
      (active detail)
     )
    )
    (component 6 "DO"
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Do")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 197 128)
       (extent 46 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 7 "NOTE"
     (interface
     )
     (implementation
      (component text 12 7
       
       
       
       
                    G A M E
       
       
                    O V E R  
       
       
       
                  
      )
     )
     (views
      (icon
       (iconImage "notepad.icon")
      )
      (detail
       (origin 86 146)
       (extent 328 249)
       (editing enabled)
      )
      (active detail)
     )
    )
    (configuration
     (connect D1:1 D0:1)
     (connect D2:1 D3:0)
    )
    (ShowOnExecPanel
     (origin 330 221)
     (extent 342 289)
     (panel
      (origin 211 160)
      (extent 338 261)
      (widget 5 detail
       (title off)
       (origin 217 167)
       (extent 328 249)
       (editing enabled)
      )
     )
    )
   )
   (views
    (icon
     (origin 195 248)
     (extent 110 25)
    )
    (detail
     (origin 75 110)
     (extent 350 300)
     (configuration
      (connect D1:1 D0:1
       (Point 211 190)
       (Point 229 190)
      )
      (connect D2:1 D3:0
       (Point 242 280)
       (Point 310 280)
       (Point 310 313)
      )
     )
     (stackingOrder 1 0 2 3 4 5)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 88 "TOSTRING"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (output 1
     (type data)
     (name "result")
     (lock name constraints)
    )
   )
   (implementation
    (attr iopath string write "string"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (procedure
      WRITE TEXT "$",a EOL
    )
   )
   (views
    (icon
     (origin 545 128)
     (extent 110 25)
    )
    (detail
     (origin 431 108)
     (extent 308 105)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 89 "TOSTRING"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (output 1
     (type data)
     (name "result")
     (lock name constraints)
    )
   )
   (implementation
    (attr iopath string write "string"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (procedure
      WRITE CASE a OF "","One","Two","Three","Four","Five","Six","","Eight","Nine","Ten","Eleven","Twelve" EOL
    )
   )
   (views
    (icon
     (origin 545 168)
     (extent 110 25)
    )
    (detail
     (origin 431 148)
     (extent 308 105)
    )
    (terminals on)
    (active icon)
   )
  )
  (configuration
   (connect D17:0 D0:0)
   (connect D20:1 D1:1)
   (connect D14:1 D2:1)
   (connect D14:2 D3:1)
   (connect D14:6 D4:1)
   (connect D14:4 D5:1)
   (connect D1:1 D6:1)
   (connect D30:1 D7:1)
   (connect D5:1 D8:0)
   (connect D2:1 D9:0)
   (connect D3:1 D10:0)
   (connect D21:0 D11:0)
   (connect D15:1 D14:1)
   (connect D11:1 D15:0)
   (connect D14:3 D18:1)
   (connect D26:0 D19:0)
   (connect D23:1 D20:0)
   (connect D0:1 D21:0)
   (connect D21:2 D22:0)
   (connect D14:5 D24:1)
   (connect D4:1 D25:0)
   (connect D20:0 D26:0)
   (connect D29:1 D27:1)
   (connect D21:1 D28:0)
   (connect D26:1 D29:1)
   (connect D19:1 D30:1)
  )
 )
 (views
  (panel
   (origin 0 62)
   (extent 1002 668)
   (widget 3 detail
    (title on)
    (origin 825 688)
    (extent 170 33)
   )
   (widget 5 detail
    (title on)
    (origin 249 688)
    (extent 194 32)
   )
   (widget 2 detail
    (title on)
    (origin 450 688)
    (extent 192 32)
   )
   (widget 4 detail
    (title on)
    (origin 649 689)
    (extent 170 31)
   )
   (widget 24 detail
    (title on)
    (origin 12 689)
    (extent 226 29)
   )
   (widget 6 detail
    (title on)
    (origin 29 102)
    (extent 190 37)
   )
   (widget 27 detail
    (title on)
    (origin 27 177)
    (extent 190 37)
   )
   (widget 12 panel
    (title on)
    (origin 742 101)
    (extent 236 62)
    (widget 1 icon
     (title off)
     (origin 812 112)
     (extent 114 39)
     (format button)
    )
   )
   (widget 13 detail
    (title off)
    (origin 16 456)
    (extent 229 193)
    (editing disabled)
   )
   (widget 16 icon
    (title off)
    (origin 649 598)
    (extent 338 48)
    (label off)
    (iconImage "disclaim.icon")
   )
   (widget 7 detail
    (title on)
    (origin 25 256)
    (extent 190 37)
   )
   (widget 11 icon
    (title off)
    (origin 455 93)
    (extent 73 49)
   )
  )
  (detail
   (origin 0 62)
   (extent 982 643)
   (configuration
    (connect D17:0 D0:0
     (Point 80 115)
     (Point 80 125)
    )
    (connect D20:1 D1:1
     (Point 517 90)
     (Point 530 90)
     (Point 530 100)
     (Point 542 100)
    )
    (connect D14:1 D2:1
     (Point 337 350)
     (Point 370 350)
     (Point 370 320)
     (Point 350 320)
     (Point 350 230)
     (Point 379 230)
    )
    (connect D14:2 D3:1
     (Point 337 360)
     (Point 360 360)
     (Point 360 280)
     (Point 408 280)
    )
    (connect D14:6 D4:1
     (Point 337 400)
     (Point 360 400)
     (Point 360 490)
     (Point 398 490)
    )
    (connect D14:4 D5:1
     (Point 337 380)
     (Point 408 380)
    )
    (connect D1:1 D6:1
     (Point 657 100)
     (Point 682 100)
    )
    (connect D30:1 D7:1
     (Point 657 180)
     (Point 682 180)
    )
    (connect D5:1 D8:0
     (Point 531 380)
     (Point 580 380)
     (Point 580 310)
     (Point 840 310)
     (Point 840 332)
    )
    (connect D2:1 D9:0
     (Point 520 230)
     (Point 680 230)
     (Point 680 245)
    )
    (connect D3:1 D10:0
     (Point 491 280)
     (Point 510 280)
     (Point 510 250)
     (Point 570 250)
     (Point 570 265)
    )
    (connect D21:0 D11:0
     (Point 80 259)
     (Point 80 319)
    )
    (connect D15:1 D14:1
     (Point 211 380)
     (Point 222 380)
    )
    (connect D11:1 D15:0
     (Point 111 340)
     (Point 150 340)
     (Point 150 365)
    )
    (connect D14:3 D18:1
     (Point 337 370)
     (Point 350 370)
     (Point 350 330)
     (Point 400 330)
    )
    (connect D26:0 D19:0
     (Point 460 155)
     (Point 460 165)
    )
    (connect D23:1 D20:0
     (Point 362 130)
     (Point 380 130)
     (Point 380 70)
     (Point 460 70)
     (Point 460 85)
    )
    (connect D0:1 D21:0
     (Point 137 160)
     (Point 150 160)
     (Point 150 210)
     (Point 80 210)
     (Point 80 220)
    )
    (connect D21:2 D22:0
     (Point 137 240)
     (Point 180 240)
     (Point 180 285)
    )
    (connect D14:5 D24:1
     (Point 337 390)
     (Point 350 390)
     (Point 350 440)
     (Point 396 440)
    )
    (connect D4:1 D25:0
     (Point 481 490)
     (Point 520 490)
     (Point 520 505)
    )
    (connect D20:0 D26:0
     (Point 460 115)
     (Point 460 125)
    )
    (connect D29:1 D27:1
     (Point 657 140)
     (Point 682 140)
    )
    (connect D21:1 D28:0
     (Point 137 230)
     (Point 250 230)
     (Point 250 245)
    )
    (connect D26:1 D29:1
     (Point 517 130)
     (Point 530 130)
     (Point 530 140)
     (Point 542 140)
    )
    (connect D19:1 D30:1
     (Point 517 170)
     (Point 530 170)
     (Point 530 180)
     (Point 542 180)
    )
   )
   (stackingOrder 0 1 6 20 4 24 5 18 3 2
     23 11 13 16 8 12 15 14 25 21
     22 9 10 28 29 26 19 30 17 27
     7)
  )
  (active panel)
  (active panel)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
