#! /usr/lib/veetest/veetest -r
(revision "B.00.00")
(date "Fri 13/Nov/1992")
(component 0 "ROOTCONTEXT"
 (name " Curve fit using Regression")
 (interface
 )
 (implementation
  (locked no)
  (trigMode deg)
  (nextID 17)
  (component 0 "YPLOT"
   (name "XY Trace")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "data")
     (lock constraints)
    )
    (input 2
     (type data)
     (name "Exponential")
     (lock constraints)
     (optional yes)
    )
    (input 3
     (type data)
     (name "Log")
     (lock constraints)
     (optional yes)
    )
    (input 4
     (type data)
     (name "linear")
     (lock constraints)
     (optional yes)
    )
    (input 5
     (type data)
     (name "Poly-3")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
    (component tracePin 1)
    (component tracePin 2)
    (component tracePin 3)
    (component tracePin 4)
    (component tracePin 5)
    (component graphMode rectangular)
   )
   (views
    (icon
     (iconImage "display.icon")
    )
    (detail
     (origin 537 262)
     (extent 426 447)
     (displayMode scrollGraph)
     (graphType cartesian)
     (gridType grid)
     (scale 0
      (name "Y name")
      (domainName "X name")
      (pen 9)
      (show 1)
      (range -50 250 3 linear)
     )
     (domain 0 100 3 linear)
     (trace 0 onScale 0
      (name "data")
      (pen 1)
      (lineType 3)
      (pointType 1)
     )
     (trace 1 onScale 0
      (name "Exponential")
      (pen 7)
      (lineType 1)
      (pointType 0)
     )
     (trace 2 onScale 0
      (name "Log")
      (pen 6)
      (lineType 1)
      (pointType 0)
     )
     (trace 3 onScale 0
      (name "linear")
      (pen 3)
      (lineType 1)
      (pointType 0)
     )
     (trace 4 onScale 0
      (name "Poly-3")
      (pen 4)
      (lineType 1)
      (pointType 0)
     )
    )
    (active detail)
   )
  )
  (component 1 "START"
   (interface
    (sequence out)
   )
   (implementation
   )
   (views
    (icon
     (origin 36 96)
     (extent 69 39)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 2 "CONTEXT"
   (name "Random Noise")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "X")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (locked no)
    (trigMode deg)
    (nextID 3)
    (component 0 "COLLECTOR"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
       (tag "Data")
      )
      (input 2
       (type trigger)
       (name "XEQ")
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "Array")
       (tag "Array")
       (lock constraints)
      )
     )
     (implementation
      (component clearAtPrerun 1)
      (component clearAtActivate 1)
      (component output1D YES)
     )
     (views
      (icon
       (origin 165 298)
       (extent 110 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "RANDOMNUMBER"
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Rand Val")
       (lock name constraints)
      )
     )
     (implementation
      (component lowerLimit -1)
      (component upperLimit 1)
     )
     (views
      (icon
       (origin 467 258)
       (extent 127 25)
      )
      (detail
       (origin 219 210)
       (extent 222 60)
      )
      (active detail)
     )
    )
    (component 2 "FORCOUNT"
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Count")
       (lock name constraints)
      )
     )
     (implementation
      (component count 16)
     )
     (views
      (icon
       (origin 305 138)
       (extent 110 64)
       (iconImage "loop.icon")
      )
      (detail
       (origin 15 193)
       (extent 170 34)
      )
      (active detail)
     )
    )
    (configuration
     (connect D1:1 D0:1)
     (connect D2:0 D0:2)
     (connect D2:1 D1:0)
     (connect D0:1 O1:1)
    )
   )
   (views
    (icon
     (origin 11 153)
     (extent 118 25)
    )
    (detail
     (origin 6 140)
     (extent 489 181)
     (configuration
      (connect D1:1 D0:1
       (Point 443 240)
       (Point 450 240)
       (Point 450 280)
       (Point 150 280)
       (Point 150 300)
       (Point 162 300)
      )
      (connect D2:0 D0:2
       (Point 100 229)
       (Point 100 320)
       (Point 162 320)
      )
      (connect D2:1 D1:0
       (Point 187 210)
       (Point 200 210)
       (Point 200 160)
       (Point 330 160)
       (Point 330 179)
      )
      (connect D0:1 O1:1
       (Point 277 310)
       (Point 459 310)
       (Point 459 240)
       (Point 492 240)
      )
     )
     (stackingOrder 0 1 2)
    )
    (active icon)
   )
  )
  (component 3 "EXITPROCESS"
   (interface
    (sequence in)
   )
   (implementation
    (comp code 0)
   )
   (views
    (icon
     (origin 157 283)
     (extent 46 25)
    )
    (detail
     (origin 70 323)
     (extent 120 34)
    )
    (active icon)
   )
  )
  (component 4 "FORMULA"
   (name "# PTS, Start, Stop + Noise   -->")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "noise")
     (requires
      (shape "Array 1D")
     )
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "logRamp(16,16,210)+noise*10")
   )
   (views
    (icon
     (origin 31 233)
     (extent 298 25)
    )
    (detail
     (origin 87 253)
     (extent 277 54)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 5 "TOFUNCTION"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "InArray")
     (tag "InArray")
     (lock constraints)
    )
    (output 1
     (type data)
     (name "OutFunc")
     (tag "OutFunc")
     (lock constraints)
    )
   )
   (implementation
    (component numDims 1)
    (component xMappings "Linear")
    (component mapFroms "0.1")
    (component mapTos "100")
   )
   (views
    (icon
     (origin 371 213)
     (extent 118 64)
     (iconImage "build.icon")
    )
    (detail
     (origin 12 428)
     (extent 216 85)
    )
    (active icon)
   )
  )
  (component 6 "REGRESSION"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Point List")
     (tag "InCoords")
     (requires
      (datatype Coord)
     )
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Fitted Data")
     (tag "OutCoords")
     (lock name constraints)
     (optional yes)
    )
    (output 2
     (type data)
     (name "Coeffs")
     (tag "Coeffs")
     (lock name constraints)
     (optional yes)
    )
    (output 3
     (type data)
     (name "Goodness")
     (tag "Goodness")
     (lock name constraints)
     (optional yes)
    )
   )
   (implementation
    (attr fit EXP)
   )
   (views
    (icon
     (origin 185 388)
     (extent 110 34)
    )
    (detail
     (origin 136 309)
     (extent 200 83)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 7 "TEXTDISPLAY"
   (name "Goodness of Fit -->")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (origin 330 413)
     (extent 181 25)
    )
    (detail
     (origin 363 423)
     (extent 255 35)
    )
    (active icon)
   )
  )
  (component 8 "REGRESSION"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Point List")
     (tag "InCoords")
     (requires
      (datatype Coord)
     )
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Fitted Data")
     (tag "OutCoords")
     (lock name constraints)
     (optional yes)
    )
    (output 2
     (type data)
     (name "Coeffs")
     (tag "Coeffs")
     (lock name constraints)
     (optional yes)
    )
    (output 3
     (type data)
     (name "Goodness")
     (tag "Goodness")
     (lock name constraints)
     (optional yes)
    )
   )
   (implementation
    (attr fit LIN)
   )
   (views
    (icon
     (origin 185 558)
     (extent 110 34)
    )
    (detail
     (origin 126 449)
     (extent 200 83)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 9 "REGRESSION"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Point List")
     (tag "InCoords")
     (requires
      (datatype Coord)
     )
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Fitted Data")
     (tag "OutCoords")
     (lock name constraints)
    )
    (output 2
     (type data)
     (name "Coeffs")
     (tag "Coeffs")
     (lock name constraints)
    )
    (output 3
     (type data)
     (name "Goodness")
     (tag "Goodness")
     (lock name constraints)
    )
   )
   (implementation
    (attr fit LOG)
   )
   (views
    (icon
     (origin 185 478)
     (extent 110 34)
    )
    (detail
     (extent 200 83)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 10 "REGRESSION"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Point List")
     (tag "InCoords")
     (requires
      (datatype Coord)
     )
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Fitted Data")
     (tag "OutCoords")
     (lock name constraints)
     (optional yes)
    )
    (output 2
     (type data)
     (name "Coeffs")
     (tag "Coeffs")
     (lock name constraints)
     (optional yes)
    )
    (output 3
     (type data)
     (name "Goodness")
     (tag "Goodness")
     (lock name constraints)
     (optional yes)
    )
   )
   (implementation
    (attr fit POLY)
    (attr order 3)
   )
   (views
    (icon
     (origin 185 638)
     (extent 110 34)
    )
    (detail
     (origin 215 609)
     (extent 200 83)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 11 "TEXTDISPLAY"
   (name "Goodness of Fit -->")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (origin 340 683)
     (extent 181 25)
    )
    (detail
     (origin 373 673)
     (extent 255 35)
    )
    (active icon)
   )
  )
  (component 12 "TEXTDISPLAY"
   (name "Goodness of Fit -->")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (origin 330 593)
     (extent 181 25)
    )
    (detail
     (origin 363 593)
     (extent 255 35)
    )
    (active icon)
   )
  )
  (component 13 "TEXTDISPLAY"
   (name "Goodness of Fit -->")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (origin 330 513)
     (extent 181 25)
    )
    (detail
     (origin 343 513)
     (extent 255 35)
    )
    (active icon)
   )
  )
  (component 14 "NOTE"
   (name "To Operate")
   (interface
   )
   (implementation
    (component text 14 5
     Press Start to see
     the resulting curve
     fits using a log
     Ramp + some noise.
     
     The Goodness of Fit
     is shown for each
     regression type to
     indicate how well
     the curve fits the
     original data.
     
     Click on Info About
     for additional help.
    )
   )
   (views
    (icon
     (origin 5 283)
     (extent 110 64)
     (iconImage "notepad.icon")
    )
    (detail
     (origin 10 265)
     (extent 180 90)
     (editing enabled)
    )
    (active icon)
   )
  )
  (component 15 "CONTEXT"
   (name "Press For")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (locked no)
    (trigMode deg)
    (nextID 3)
    (component 0 "IFTHENELSE"
     (name "!= 0")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a!=0")
     )
     (views
      (icon
       (origin 355 340)
       (extent 46 25)
      )
      (detail
       (origin 209 308)
       (extent 73 64)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "TOGGLE"
     (name "Info About")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Reset")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Info About")
       (values range 0 1)
       (datum 0)
      )
      (component autoTrigger on)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (name "LongInt")
       (datum 0)
      )
     )
     (views
      (icon
       (origin 191 333)
       (extent 114 39)
       (format button)
      )
      (detail
       (origin 320 203)
       (extent 42 54)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "CONTEXT"
     (name "Info About This Example")
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (locked no)
      (trigMode deg)
      (nextID 2)
      (component 0 "NOTE"
       (name "NotePad")
       (description 2 8
        This notepad is displayed as a Show on Execute
        panel to present the information to the reader.
       )
       (interface
       )
       (implementation
        (component text 23 9
         PURPOSE:     To illustrate various regression methods to perform curve fitting.
         
         USER INPUT REQUIRED:  Press the START button and observe the resulting display.
         
         EXPLANATION: It is often useful to obtain a formula that closely approximates a
                      set of data gathered in an experiment.  Using the Advanced Math
                      regression objects, you can apply various curve fitting approximations
                      to your data.
         
                      In this example, we simulated some data that was primarily exponential
                      in form, then added some significant noise using a random number generator.
                      The resulting data is then used with four of the regression methods.
         
                      For each regression method, the resulting Goodness of Fit is shown, 
                      although this information can generally be deduced by looking at the
                      displayed curves.
         
                      As would be expected from the input data, the exponential regression is
                      usually a good fit to the data.  Interestingly, a third-order polynomial
                      regression often gives as good or better fit on the data.  This goes to
                      show that Goodness of Fit doesn't always guarantee a suitable indication
                      of the original data's formula.
         
        )
       )
       (views
        (icon
         (origin 160 185)
         (extent 78 25)
        )
        (detail
         (origin 36 162)
         (extent 848 437)
         (editing enabled)
        )
        (active icon)
       )
      )
      (component 1 "CONFIRM"
       (name "DONE")
       (description 7 8
        This tiny "thread" begins running when the 
        enclosing UserObject is executed.  When the user
        acknowledges the OK/DONE button, there is nothing
        left to execute, so the thread ends.  Since there
        are not other threads running, the User Object
        is completed and will exit, removing the Show on
        Execute pop-up display.
       )
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 171 252)
         (extent 58 37)
        )
        (detail
         (origin 156 253)
         (extent 79 34)
        )
        (terminals on)
        (active icon)
       )
      )
      (configuration
      )
      (ShowOnExecPanel
       (origin 55 78)
       (extent 849 571)
       (panel
        (origin 38 164)
        (extent 845 533)
        (widget 0 detail
         (title off)
         (origin 51 176)
         (extent 816 465)
         (editing disabled)
        )
        (widget 1 icon
         (title off)
         (origin 437 649)
         (extent 58 37)
        )
       )
      )
     )
     (views
      (icon
       (origin 342 408)
       (extent 217 25)
      )
      (detail
       (origin 17 140)
       (extent 866 520)
       (configuration
       )
       (stackingOrder 0 1)
      )
      (active icon)
     )
    )
    (configuration
     (connect D1:1 D0:1)
     (connect D2:0 D1:1)
     (connect D0:1 D2:0)
    )
   )
   (views
    (icon
     (origin 175 368)
     (extent 110 25)
    )
    (panel
     (origin 201 117)
     (extent 319 77)
     (widget 1 icon
      (title off)
      (origin 303 130)
      (extent 114 39)
      (format button)
     )
    )
    (detail
     (origin 4 115)
     (extent 912 591)
     (configuration
      (connect D1:1 D0:1
       (Point 307 352)
       (Point 352 352)
      )
      (connect D2:0 D1:1
       (Point 450 435)
       (Point 450 450)
       (Point 170 450)
       (Point 170 352)
       (Point 188 352)
      )
      (connect D0:1 D2:0
       (Point 403 342)
       (Point 450 342)
       (Point 450 405)
      )
     )
     (stackingOrder 0 1 2)
    )
    (active panel)
    (active panel)
   )
  )
  (component 16 "NOTE"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 4 5
     This example is provided as an illustration
     "as is", and Hewlett-Packard Company makes
     no warranty of any kind with regard to this
     example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 553 115)
     (extent 415 90)
     (editing enabled)
    )
    (active detail)
   )
  )
  (configuration
   (connect D5:1 D0:1)
   (connect D6:1 D0:2)
   (connect D9:1 D0:3)
   (connect D8:1 D0:4)
   (connect D10:1 D0:5)
   (connect D1:0 D2:0)
   (connect D4:0 D3:0)
   (connect D2:1 D4:1)
   (connect D4:1 D5:1)
   (connect D5:1 D6:1)
   (connect D6:3 D7:1)
   (connect D5:1 D8:1)
   (connect D5:1 D9:1)
   (connect D5:1 D10:1)
   (connect D10:3 D11:1)
   (connect D8:3 D12:1)
   (connect D9:3 D13:1)
  )
 )
 (views
  (panel
   (origin 0 62)
   (extent 1024 679)
   (widget 11 detail
    (title on)
    (origin 269 550)
    (extent 219 35)
    (formatter
     (realFormat standard)
     (realSigDigits 5)
     (realRadixSpec 4)
     (integerBase decimal)
    )
   )
   (widget 12 detail
    (title on)
    (origin 268 470)
    (extent 219 35)
    (formatter
     (realFormat standard)
     (realSigDigits 5)
     (realRadixSpec 4)
     (integerBase decimal)
    )
   )
   (widget 13 detail
    (title on)
    (origin 268 393)
    (extent 219 35)
   )
   (widget 7 detail
    (title on)
    (origin 270 316)
    (extent 219 35)
    (formatter
     (realFormat standard)
     (realSigDigits 5)
     (realRadixSpec 4)
     (integerBase decimal)
    )
   )
   (widget 14 detail
    (title on)
    (origin 65 318)
    (extent 191 266)
    (editing disabled)
   )
   (widget 15 panel
    (title on)
    (origin 62 108)
    (extent 189 85)
    (widget 1 icon
     (title off)
     (origin 103 126)
     (extent 114 39)
     (format button)
    )
   )
   (widget 1 icon
    (title off)
    (origin 270 74)
    (extent 214 117)
   )
   (widget 0 detail
    (title on)
    (origin 498 108)
    (extent 478 604)
    (displayMode annotGraph)
    (graphType cartesian)
    (gridType frame)
    (scale 0
     (name "Y name")
     (domainName "X name")
     (pen 9)
     (show 1)
     (range -50 250 3 linear)
    )
    (domain 0 100 3 linear)
    (trace 0 onScale 0
     (name "data")
     (pen 4)
     (lineType 1)
     (pointType 2)
    )
    (trace 1 onScale 0
     (name "Exponential")
     (pen 7)
     (lineType 1)
     (pointType 0)
    )
    (trace 2 onScale 0
     (name "Log")
     (pen 2)
     (lineType 1)
     (pointType 0)
    )
    (trace 3 onScale 0
     (name "linear")
     (pen 6)
     (lineType 1)
     (pointType 0)
    )
    (trace 4 onScale 0
     (name "Poly-3")
     (pen 3)
     (lineType 1)
     (pointType 0)
    )
   )
   (widget 4 detail
    (title on)
    (origin 64 244)
    (extent 422 28)
   )
   (widget 16 detail
    (title on)
    (origin 65 629)
    (extent 420 80)
    (editing disabled)
   )
  )
  (detail
   (origin 0 62)
   (extent 1002 656)
   (configuration
    (connect D5:1 D0:1
     (Point 491 245)
     (Point 510 245)
     (Point 510 305)
     (Point 534 305)
    )
    (connect D6:1 D0:2
     (Point 297 395)
     (Point 534 395)
    )
    (connect D9:1 D0:3
     (Point 297 485)
     (Point 534 485)
    )
    (connect D8:1 D0:4
     (Point 297 565)
     (Point 310 565)
     (Point 310 575)
     (Point 534 575)
    )
    (connect D10:1 D0:5
     (Point 297 645)
     (Point 320 645)
     (Point 320 665)
     (Point 534 665)
    )
    (connect D1:0 D2:0
     (Point 70 137)
     (Point 70 150)
    )
    (connect D4:0 D3:0
     (Point 180 260)
     (Point 180 280)
    )
    (connect D2:1 D4:1
     (Point 131 165)
     (Point 150 165)
     (Point 150 195)
     (Point 10 195)
     (Point 10 245)
     (Point 28 245)
    )
    (connect D4:1 D5:1
     (Point 331 245)
     (Point 368 245)
    )
    (connect D5:1 D6:1
     (Point 491 245)
     (Point 510 245)
     (Point 510 305)
     (Point 230 305)
     (Point 230 365)
     (Point 170 365)
     (Point 170 405)
     (Point 182 405)
    )
    (connect D6:3 D7:1
     (Point 297 415)
     (Point 310 415)
     (Point 310 425)
     (Point 327 425)
    )
    (connect D5:1 D8:1
     (Point 491 245)
     (Point 510 245)
     (Point 510 305)
     (Point 230 305)
     (Point 230 365)
     (Point 170 365)
     (Point 170 575)
     (Point 182 575)
    )
    (connect D5:1 D9:1
     (Point 491 245)
     (Point 510 245)
     (Point 510 305)
     (Point 230 305)
     (Point 230 365)
     (Point 170 365)
     (Point 170 495)
     (Point 182 495)
    )
    (connect D5:1 D10:1
     (Point 491 245)
     (Point 510 245)
     (Point 510 305)
     (Point 230 305)
     (Point 230 365)
     (Point 170 365)
     (Point 170 655)
     (Point 182 655)
    )
    (connect D10:3 D11:1
     (Point 297 665)
     (Point 310 665)
     (Point 310 695)
     (Point 337 695)
    )
    (connect D8:3 D12:1
     (Point 297 585)
     (Point 310 585)
     (Point 310 605)
     (Point 327 605)
    )
    (connect D9:3 D13:1
     (Point 297 505)
     (Point 310 505)
     (Point 310 525)
     (Point 327 525)
    )
   )
   (stackingOrder 0 1 2 3 4 5 6 7 8 9
     10 11 12 13 14 15 16)
  )
  (active panel)
  (active panel)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
