#! /usr/lib/veetest/veetest -r
(revision "A.00.00")
(date "Thu 11/Apr/1991")
(component 0 "Context"
 (name "Torsion Bar Example")
 (interface
 )
 (implementation
  (trigMode deg)
  (locked no)
  (component 0 "Constant"
   (name "Torque, in-lb.")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Torque, in-lb.")
     (datum 2500)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 2500)
    )
   )
   (views
    (description 7 5
     This is a "Data -> Constant -> Real" object.
     It is being used in this example to provide input
     for the torque (in inch-pounds) applied to the
     torsion bar to the "Formula" object.
     
     See also "Show Description" for "Length, in."
     
    )
    (icon
     (extent 136 0)
    )
    (detail
     (origin 35 466)
     (extent 210 28)
    )
    (active detail)
   )
  )
  (component 1 "Constant"
   (name "Diameter, in.")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Diameter, in.")
     (datum 1)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 1)
    )
   )
   (views
    (description 7 5
     This is a "Data -> Constant -> Real" object.
     It is being used in this example to provide input
     for the diameter of the torsion bar (in inches)
     to the "Formula" object.
     
     See also "Show Description" for "Length, in."
     
    )
    (icon
     (extent 127 0)
    )
    (detail
     (origin 40 356)
     (extent 201 28)
    )
    (active detail)
   )
  )
  (component 2 "Constant"
   (name "Length, in.")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Length, in.")
     (datum 10)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 10)
    )
   )
   (views
    (description 11 5
     This is a "Data -> Constant -> Real" object.
     It is being used to provide input for the length
     of the torsion bar (in inches) to the "Formula"
     object.
     
     The title was changed from the default title of
     "Real" to a more meaningful title for this
     example of "Length, in." by clicking on the title
     entry field  of the object and typing the desired title.
     
     
    )
    (icon
     (extent 110 0)
    )
    (detail
     (origin 49 266)
     (extent 183 28)
    )
    (active detail)
   )
  )
  (component 3 "Constant"
   (name "Shear Modulus, psi")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Shear Modulus, psi")
     (datum 12000000)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 12000000)
    )
   )
   (views
    (description 7 5
     This is a "Data -> Constant -> Real" object.
     It is being used in this example to provide input
     for the shear modulus value (in pounds per square
     inch) of the material from which the torsion bar
     may be constructed to the "Formula" object.
     
     See also "Show Description" for "Input, in."
    )
    (icon
     (extent 172 0)
    )
    (detail
     (origin 23 556)
     (extent 234 29)
    )
    (active detail)
   )
  )
  (component 4 "TextDisplay"
   (name "Deflection, Deg.")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 154 0)
    )
    (detail
     (origin 606 453)
     (extent 228 35)
     (formatter
      (realFormat fixed)
      (realSigDigits 16)
      (realRadixSpec 3)
      (integerBase decimal)
     )
    )
    (active detail)
   )
  )
  (component 5 "IfThenElse"
   (name "!= 0")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Then")
     (lock name constraints)
    )
    (output 2
     (type data)
     (name "Else")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr "a!=0")
   )
   (views
    (icon
     (origin 207 98)
     (extent 46 25)
    )
    (detail
     (origin 349 328)
     (extent 73 64)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 6 "Toggle"
   (name "Info")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type control)
     (name "Reset")
     (lock name constraints)
     (optional yes)
    )
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Int32
     (name "Info")
     (values range 0 1)
     (datum 0)
    )
    (component autoTrigger on)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Int32
     (datum 0)
    )
   )
   (views
    (icon
     (origin 120 91)
     (extent 60 39)
     (format button)
    )
    (detail
     (origin 230 334)
     (extent 20 52)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 7 "Note"
   (name "Overview of Torsion Bar Example")
   (interface
   )
   (implementation
    (component text 11 5
     This model calculates the angular
     deflection of a round shaft.
     
     Click on each data object's entry 
     field (for example, below "Length" or 
     "Diameter") and enter the necessary
     values. Then click on "Start" to run 
     the model and gain the result.
      
     For more details about this example,
     click on "Info".
    )
   )
   (views
    (description 1 5
     Object "Display, Note Pad"
    )
    (icon
     (origin 465 168)
     (extent 289 25)
    )
    (detail
     (origin 330 124)
     (extent 360 251)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 8 "Formula"
   (name "Formula")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "L")
     (optional yes)
    )
    (input 2
     (type data)
     (name "D")
     (optional yes)
    )
    (input 3
     (type data)
     (name "T")
     (optional yes)
    )
    (input 4
     (type data)
     (name "G")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "583.6*T*L/(G*(D^4))")
   )
   (views
    (description 7 5
     This is a "Math -> Formula" object.
     It is the means by which the results are
     calculated, based on the input values.  In the
     open view, the specific details of the formula
     can be observed, along with the data inputs and
     output.  Note the correlation between the data
     input names and corresponding formula values.
    )
    (icon
     (origin 431 438)
     (extent 78 64)
     (iconImage formula.icon)
    )
    (detail
     (origin 368 369)
     (extent 205 204)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 9 "Note"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 4 5
     This example is provided as an
     illustration "as is", and Hewlett-Packard
     Company makes no warranty of any kind
     with regard to this example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 362 559)
     (extent 397 82)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 10 "Note"
   (name "Result")
   (interface
   )
   (implementation
   )
   (views
    (description 5 5
     This is a "Display -> Note Pad" object.  By
     showing this object in an iconized view after
     editing the title to change "Note Pad" to
     "Result", it provides a simple means of
     annotation when added to the panel view.
    )
    (icon
     (origin 561 387)
     (extent 78 25)
    )
    (detail
     (origin 510 354)
     (extent 180 90)
     (editing disabled)
    )
    (active icon)
   )
  )
  (component 11 "Note"
   (name "Inputs")
   (interface
   )
   (implementation
   )
   (views
    (description 5 5
     This is a "Display -> Note Pad" object.  By
     showing this object in an iconized view, after
     editing the title to change "Note Pad" to
     "Input", it provides a simple means of
     annotation when added to the panel view.
    )
    (icon
     (origin 11 197)
     (extent 78 25)
    )
    (detail
     (origin 10 164)
     (extent 180 90)
     (editing disabled)
    )
    (active icon)
   )
  )
  (component 12 "Start"
   (name "Start")
   (interface
    (sequence out)
   )
   (implementation
   )
   (views
    (description 4 5
     This is a "Flow -> Start" object.  It is used as
     an alternative to "Run" in this example, since
     there is only a single thread. 
     
    )
    (icon
     (origin 107 172)
     (extent 67 37)
    )
    (detail
     (origin 87 163)
     (extent 106 54)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 13 "Context"
   (name "Details of Torsion Bar Example")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "Confirm"
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Go")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 361 372)
       (extent 58 37)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "Note"
     (name "Note Pad")
     (interface
     )
     (implementation
      (component text 19 7
       PURPOSE: This HP VEE model example shows a simple mechanical engineering 
        problem and solution.  It also shows basic data entry and display, as 
        well as the use of a calculation formula.
       
       USER INPUT REQUIRED: None to run the model.  However, you may change any
        data inputs.
       
       EXPLANATION: The model uses a simple formula to calculate the angular
        deflection of a round torsion shaft, given specified diameter, length,
        applied torque, and material shear modulus values.
       
        The model was built with a panel view to simplify entry and viewing 
        of the data.  To see more specifics of the model, click on the "Detail" 
        button.  While in the detail view, double-click on the "Formula" object 
        to see the details of "Formula" and its inputs in the open view.  Also, 
        from the object menu of each object, select "Show Description" to see 
        additional details about some objects.
       
       To exit, click on "OK" below.
      )
     )
     (views
      (icon
       (origin 285 288)
       (extent 110 25)
      )
      (detail
       (origin 224 302)
       (extent 673 376)
       (editing disabled)
      )
      (active icon)
     )
    )
    (configuration
    )
    (ShowOnExecPanel
     (origin 83 111)
     (extent 724 541)
     (panel
      (origin 10 119)
      (extent 720 503)
      (widget 1 detail
       (title off)
       (origin 15 124)
       (extent 707 449)
       (editing disabled)
      )
      (widget 0 icon
       (title off)
       (origin 356 578)
       (extent 58 37)
      )
     )
    )
   )
   (views
    (icon
     (origin 260 138)
     (extent 40 24)
     (label off)
    )
    (detail
     (origin 216 256)
     (extent 288 189)
     (configuration
     )
    )
    (active icon)
   )
  )
  (configuration
   (connect D12:0 D2:0)
   (connect D8:1 D4:1)
   (connect D6:1 D5:1)
   (connect D5:0 D6:1)
   (connect D2:1 D8:1)
   (connect D1:1 D8:2)
   (connect D0:1 D8:3)
   (connect D3:1 D8:4)
   (connect D5:1 D13:0)
  )
 )
 (views
  (panel
   (origin 0 67)
   (extent 908 644)
   (widget 3 detail
    (title on)
    (origin 55 522)
    (extent 210 28)
   )
   (widget 1 detail
    (title on)
    (origin 56 338)
    (extent 209 27)
   )
   (widget 0 detail
    (title on)
    (origin 56 428)
    (extent 210 28)
   )
   (widget 11 icon
    (title off)
    (origin 41 176)
    (extent 78 25)
   )
   (widget 6 icon
    (title off)
    (origin 82 103)
    (extent 60 39)
    (format button)
   )
   (widget 2 detail
    (title on)
    (origin 57 247)
    (extent 209 28)
   )
   (widget 12 icon
    (title off)
    (origin 179 103)
    (extent 67 37)
   )
   (widget 4 detail
    (title on)
    (origin 452 434)
    (extent 228 35)
    (formatter
     (realFormat fixed)
     (realSigDigits 4)
     (realRadixSpec 3)
     (integerBase decimal)
    )
   )
   (widget 7 detail
    (title on)
    (origin 315 111)
    (extent 356 241)
    (editing disabled)
   )
   (widget 9 detail
    (title on)
    (origin 317 528)
    (extent 397 82)
    (editing disabled)
   )
   (widget 10 icon
    (title off)
    (origin 517 365)
    (extent 78 25)
   )
  )
  (detail
   (origin 0 67)
   (extent 958 589)
   (configuration
    (connect D12:0 D2:0
     (Point 140 211)
     (Point 140 222)
     (Point 140 222)
     (Point 140 233)
    )
    (connect D8:1 D4:1
     (Point 511 470)
     (Point 603 470)
    )
    (connect D6:1 D5:1
     (Point 182 110)
     (Point 204 110)
    )
    (connect D5:0 D6:1
     (Point 230 125)
     (Point 230 150)
     (Point 100 150)
     (Point 100 110)
     (Point 117 110)
    )
    (connect D2:1 D8:1
     (Point 234 280)
     (Point 280 280)
     (Point 280 450)
     (Point 428 450)
    )
    (connect D1:1 D8:2
     (Point 243 370)
     (Point 270 370)
     (Point 270 460)
     (Point 428 460)
    )
    (connect D0:1 D8:3
     (Point 247 480)
     (Point 270 480)
     (Point 270 470)
     (Point 428 470)
    )
    (connect D3:1 D8:4
     (Point 259 570)
     (Point 280 570)
     (Point 280 480)
     (Point 428 480)
    )
    (connect D5:1 D13:0
     (Point 255 100)
     (Point 280 100)
     (Point 280 135)
    )
   )
  )
  (active panel)
  (active panel)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
