#! /usr/lib/veetest/veetest -r
(revision "B.00.00")
(date "Thu 19/Nov/1992")
(component 0 "ROOTCONTEXT"
 (name "Log In Example")
 (interface
 )
 (implementation
  (UserFunctions
   (nextID 8)
   (context 0
    (name "readNames")
    (interface
     (sequence in)
     (sequence out)
    )
    (implementation
     (locked no)
     (trigMode deg)
     (nextID 2)
     (component 0 "FROMFILE"
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "X")
        (lock constraints)
        (optional yes)
       )
      )
      (implementation
       (attr iopath file read "/usr/lib/veetest/examples/mfgtest/names.dat"
        (readTerm "\n")
        (fs " ")
        (eol "\n")
        (multiField fullSyntax)
        (arrayFormat block)
       )
       (procedure
         EXECUTE REWIND
         READ TEXT x STR ARRAY:*
       )
      )
      (views
       (icon
       )
       (detail
        (origin 193 281)
        (extent 356 169)
       )
       (terminals on)
       (active detail)
      )
     )
     (component 1 "TOGLOBAL"
      (name "Set Global")
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "Data")
        (tag "Data")
       )
      )
      (implementation
       (component globalName names)
      )
      (views
       (icon
       )
       (detail
        (origin 707 354)
        (extent 89 62)
       )
       (terminals on)
       (active detail)
      )
     )
     (configuration
      (connect D0:1 D1:1)
     )
    )
    (views
     (detail
      (origin 145 209)
      (extent 686 266)
      (configuration
       (connect D0:1 D1:1
        (Point 581 365)
        (Point 601 365)
        (Point 601 385)
        (Point 654 385)
       )
      )
      (stackingOrder 0 1)
     )
     (terminals on)
     (active detail)
    )
   )
   (context 1
    (name "readPasswds")
    (interface
     (sequence in)
     (sequence out)
    )
    (implementation
     (locked no)
     (trigMode deg)
     (nextID 2)
     (component 0 "FROMFILE"
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "X")
        (lock constraints)
        (optional yes)
       )
      )
      (implementation
       (attr iopath file read "/usr/lib/veetest/examples/mfgtest/passwd.dat"
        (readTerm "\n")
        (fs " ")
        (eol "\n")
        (multiField fullSyntax)
        (arrayFormat block)
       )
       (procedure
         EXECUTE REWIND
         READ TEXT x STR ARRAY:*
       )
      )
      (views
       (icon
       )
       (detail
        (origin 164 274)
        (extent 453 172)
       )
       (terminals on)
       (active detail)
      )
     )
     (component 1 "TOGLOBAL"
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "Data")
        (tag "Data")
       )
      )
      (implementation
       (component globalName passwd)
      )
      (views
       (icon
       )
       (detail
        (origin 738 344)
        (extent 89 62)
       )
       (terminals on)
       (active detail)
      )
     )
     (configuration
      (connect D0:1 D1:1)
     )
    )
    (views
     (detail
      (origin 105 209)
      (extent 757 266)
      (configuration
       (connect D0:1 D1:1
        (Point 649 360)
        (Point 670 360)
        (Point 670 375)
        (Point 685 375)
       )
      )
      (stackingOrder 1 0)
     )
     (terminals on)
     (active detail)
    )
   )
   (context 2
    (name "validateName")
    (description 74 5
     Note that the global "names" contains an array of 
     text values that represent valid user names.  
     This Global is set by the function "readNames".
     When we compare the array of user names to 
     the name the user supplies, we get an array of 
     values from the strPosStr() device.  
     
     The array the strPosStr() device propagates will 
     contain a 0 where the input strings exactly 
     match (i.e. str1 contains the value of str2 
     starting at position 0).  The strPosStr() object
     will return a -1 if the value the user typed in
     does not appear in the strings we supply from
     the Global.  So, if the user typed in a name
     that matched the second entry in the list of
     valid user names, the strPosStr() box would
     give us an array that looks like:
     
     -1
     0
     -1
     
     We send this array to the Comparator.
     The Comparator looks for the lack of a zero in the 
     array coming from the string device.  OK, here's
     the logic:  If 0 means that the name the user 
     typed in is the same as one of the strings coming
     from the Global, then we should have an array
     coming from the strPosStr() box that has one 0
     and the rest -1's.  In the case where the user
     types in a name that is not contained in the 
     list of valid names, the array will contain all 
     -1's.  The Comparator's "failures" data out pin
     carries a coordinate array representing the 
     points that failed to match the criteria we 
     specified.  What we are looking for is a user 
     number that matches one of the input strings.
     For instance, the following user names have
     these user numbers:
     
     User Names			Number
     ----------			------
     Joe					0
     Roger				1
     Johnnie				2
     
     Since the Comparator gives you a list of failures,
     we have set it up to look for conditions we don't
     want ... what's left over is what we do want:
     the user number where the string the user typed
     in exactly matches on of the elements in the text
     array coming from the Global.
     
     Given the list of names above, if the user typed
     a name that matched the second entry, the 
     Comparator would give us the following
     coordinates:
     
     1,0
     
     The 1 specifies that the array element numbered
     1 (the second array element where the elements
     are numbered 0 through two), and the 0 is the
     value contained in element 1.  So, the UnBuild
     Coord gives us back the value 1 ... that's our
     user number.
     
     If no matches are found, the Comparator pings its
     "Passed" output and the function returns a value
      of  -2, indicating failure.  If a zero is found
      in the array from the string device, the function
      returns the value zero, indicating success.  That
     value is stored in a Global called "userNumber"
     for later use in evaluating passwords.
    )
    (interface
     (sequence in)
     (sequence out)
     (output 1
      (type data)
      (name "X")
      (lock constraints)
      (optional yes)
     )
    )
    (implementation
     (locked no)
     (trigMode deg)
     (nextID 14)
     (component 0 "LITERALCONSTANT"
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "Text")
        (lock name constraints)
       )
      )
      (implementation
       (component value Text
        (name "Text")
        (datum "Please type your login name")
       )
       (component autoTrigger off)
       (component initializeAtPrerun off)
       (component initializeAtActivate off)
       (component initValue Text
        (name "CString")
        (datum "")
       )
      )
      (views
       (icon
       )
       (detail
        (origin -47 113)
        (extent 214 34)
       )
       (title off)
       (active detail)
      )
     )
     (component 1 "LITERALCONSTANT"
      (name "Your login")
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "Text")
        (lock name constraints)
       )
      )
      (implementation
       (component value Text
        (name "Your login")
        (datum "Roger")
       )
       (component autoTrigger off)
       (component initializeAtPrerun off)
       (component initializeAtActivate off)
       (component initValue Text
        (name "CString")
        (datum "")
       )
      )
      (views
       (icon
        (extent 112 0)
       )
       (detail
        (origin -37 283)
        (extent 214 34)
       )
       (active detail)
      )
     )
     (component 2 "CONFIRM"
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "Go")
        (lock name constraints)
       )
      )
      (implementation
      )
      (views
       (icon
        (origin 33 170)
        (extent 54 40)
       )
       (detail
       )
       (terminals on)
       (active icon)
      )
     )
     (component 3 "FORMULA"
      (name "strPosstr(str1,str2)")
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "str1")
        (lock name constraints)
       )
       (input 2
        (type data)
        (name "str2")
        (lock name constraints)
       )
       (output 1
        (type data)
        (name "index")
        (lock name constraints)
       )
      )
      (implementation
       (component isLocked yes)
       (component expr 1 "strPosStr(str1,str2)")
      )
      (views
       (icon
        (origin 202 339)
        (extent 196 43)
       )
       (detail
       )
       (terminals on)
       (active icon)
      )
     )
     (component 4 "FROMGLOBAL"
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "Data")
        (tag "Data")
        (lock name constraints)
       )
      )
      (implementation
       (component globalName names)
      )
      (views
       (icon
       )
       (detail
        (origin 36 409)
        (extent 89 62)
       )
       (terminals on)
       (active detail)
      )
     )
     (component 5 "CONSTANT"
      (name "Integer")
      (subType "Integer")
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "Int32")
        (lock name constraints)
       )
      )
      (implementation
       (component value Int32
        (name "Integer")
        (datum 0)
       )
       (component autoTrigger off)
       (component initializeAtPrerun off)
       (component initializeAtActivate off)
       (component initValue Int32
        (name "LongInt")
        (datum 0)
       )
      )
      (views
       (icon
       )
       (detail
        (origin 167 183)
        (extent 66 34)
        (showFormat int)
       )
       (title off)
       (active detail)
      )
     )
     (component 6 "COMPARATOR"
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "Ref Value")
        (tag "RefValue")
       )
       (input 2
        (type data)
        (name "Test Value")
        (tag "TestValue")
       )
       (output 1
        (type data)
        (name "Passed")
        (tag "Passed")
        (lock name constraints)
        (optional yes)
       )
       (output 2
        (type data)
        (name "Failed")
        (tag "Failed")
        (lock name constraints)
        (optional yes)
       )
       (output 3
        (type data)
        (name "Failures")
        (tag "Failures")
        (lock name constraints)
        (optional yes)
       )
      )
      (implementation
       (attr relation "!=")
      )
      (views
       (icon
       )
       (detail
        (origin 405 192)
        (extent 251 116)
       )
       (terminals on)
       (active detail)
      )
     )
     (component 7 "CONSTANT"
      (name "Integer")
      (subType "Integer")
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "Int32")
        (lock name constraints)
       )
      )
      (implementation
       (component value Int32
        (name "Integer")
        (datum -1)
       )
       (component autoTrigger off)
       (component initializeAtPrerun off)
       (component initializeAtActivate off)
       (component initValue Int32
        (name "LongInt")
        (datum 0)
       )
      )
      (views
       (icon
       )
       (detail
        (origin 937 223)
        (extent 66 34)
        (showFormat int)
       )
       (title off)
       (active detail)
      )
     )
     (component 8 "CONSTANT"
      (name "Integer")
      (subType "Integer")
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "Int32")
        (lock name constraints)
       )
      )
      (implementation
       (component value Int32
        (name "Integer")
        (datum 0)
       )
       (component autoTrigger off)
       (component initializeAtPrerun off)
       (component initializeAtActivate off)
       (component initValue Int32
        (name "LongInt")
        (datum 0)
       )
      )
      (views
       (icon
       )
       (detail
        (origin 937 343)
        (extent 66 34)
        (showFormat int)
       )
       (title off)
       (active detail)
      )
     )
     (component 9 "JUNCTION"
      (name "JCT")
      (interface
       (input 1
        (type data)
        (name "A")
        (lock name constraints)
       )
       (input 2
        (type data)
        (name "B")
        (lock name constraints)
       )
       (output 1
        (type data)
        (name "Data")
        (lock name constraints)
       )
      )
      (implementation
      )
      (views
       (icon
        (origin 1056 336)
        (extent 48 28)
       )
       (detail
       )
       (terminals on)
       (active icon)
      )
     )
     (component 10 "FROMCOORDINATE"
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "Coord Data")
        (requires
         (datatype Coord)
        )
        (lock name constraints)
       )
       (output 1
        (type data)
        (name "X Data")
        (lock name constraints)
       )
       (output 2
        (type data)
        (name "Y Data")
        (lock name constraints)
        (optional yes)
       )
      )
      (implementation
      )
      (views
       (icon
        (origin 472 436)
        (extent 116 68)
        (iconImage "unbuild.icon")
       )
       (detail
        (origin 640 645)
        (extent 34 70)
       )
       (terminals on)
       (active icon)
      )
     )
     (component 11 "TOGLOBAL"
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "Data")
        (tag "Data")
       )
      )
      (implementation
       (component globalName userNumber)
      )
      (views
       (icon
       )
       (detail
        (origin 899 496)
        (extent 122 68)
       )
       (terminals on)
       (active detail)
      )
     )
     (component 12 "JUNCTION"
      (name "JCT")
      (interface
       (input 1
        (type data)
        (name "A")
        (lock name constraints)
       )
       (input 2
        (type data)
        (name "B")
        (lock name constraints)
       )
       (output 1
        (type data)
        (name "Data")
        (lock name constraints)
       )
      )
      (implementation
      )
      (views
       (icon
        (origin 706 466)
        (extent 48 28)
       )
       (detail
       )
       (terminals on)
       (active icon)
      )
     )
     (component 13 "CONSTANT"
      (name "Integer")
      (subType "Integer")
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "Int32")
        (lock name constraints)
       )
      )
      (implementation
       (component value Int32
        (name "Integer")
        (datum -2)
       )
       (component autoTrigger off)
       (component initializeAtPrerun off)
       (component initializeAtActivate off)
       (component initValue Int32
        (name "LongInt")
        (datum 0)
       )
      )
      (views
       (icon
       )
       (detail
        (origin 659 405)
        (extent 62 31)
        (showFormat int)
       )
       (title off)
       (active detail)
      )
     )
     (configuration
      (connect D2:1 D1:0)
      (connect D1:1 D3:1)
      (connect D4:1 D3:2)
      (connect D5:1 D6:1)
      (connect D3:1 D6:2)
      (connect D6:1 D7:0)
      (connect D6:2 D8:0)
      (connect D7:1 D9:1)
      (connect D8:1 D9:2)
      (connect D6:3 D10:1)
      (connect D12:1 D11:1)
      (connect D13:1 D12:1)
      (connect D10:1 D12:2)
      (connect D7:1 D13:0)
      (connect D9:1 O1:1)
     )
     (ShowOnExecPanel
      (origin 12 77)
      (extent 262 272)
      (panel
       (origin 492 350)
       (extent 258 244)
       (widget 1 detail
        (title on)
        (origin 514 440)
        (extent 214 34)
       )
       (widget 0 detail
        (title off)
        (origin 515 368)
        (extent 214 34)
       )
       (widget 2 icon
        (title off)
        (origin 596 480)
        (extent 54 40)
       )
      )
     )
    )
    (views
     (detail
      (origin 45 99)
      (extent 875 490)
      (configuration
       (connect D2:1 D1:0
        (Point 89 190)
        (Point 100 190)
        (Point 100 220)
        (Point 70 220)
        (Point 70 252)
       )
       (connect D1:1 D3:1
        (Point 179 300)
        (Point 190 300)
        (Point 190 350)
        (Point 199 350)
       )
       (connect D4:1 D3:2
        (Point 177 440)
        (Point 200 440)
        (Point 200 400)
        (Point 190 400)
        (Point 190 370)
        (Point 199 370)
       )
       (connect D5:1 D6:1
        (Point 235 200)
        (Point 260 200)
        (Point 260 220)
        (Point 292 220)
       )
       (connect D3:1 D6:2
        (Point 400 360)
        (Point 420 360)
        (Point 420 330)
        (Point 270 330)
        (Point 270 280)
        (Point 292 280)
       )
       (connect D6:1 D7:0
        (Point 748 210)
        (Point 970 210)
        (Point 970 220)
       )
       (connect D6:2 D8:0
        (Point 748 250)
        (Point 770 250)
        (Point 770 310)
        (Point 970 310)
        (Point 970 340)
       )
       (connect D7:1 D9:1
        (Point 1005 240)
        (Point 1030 240)
        (Point 1030 340)
        (Point 1053 340)
       )
       (connect D8:1 D9:2
        (Point 1005 360)
        (Point 1053 360)
       )
       (connect D6:3 D10:1
        (Point 748 290)
        (Point 760 290)
        (Point 760 330)
        (Point 450 330)
        (Point 450 470)
        (Point 469 470)
       )
       (connect D12:1 D11:1
        (Point 756 480)
        (Point 770 480)
        (Point 770 530)
        (Point 846 530)
       )
       (connect D13:1 D12:1
        (Point 723 420)
        (Point 740 420)
        (Point 740 450)
        (Point 690 450)
        (Point 690 470)
        (Point 703 470)
       )
       (connect D10:1 D12:2
        (Point 590 450)
        (Point 610 450)
        (Point 610 490)
        (Point 703 490)
       )
       (connect D7:1 D13:0
        (Point 1005 240)
        (Point 1030 240)
        (Point 1030 320)
        (Point 910 320)
        (Point 910 350)
        (Point 690 350)
        (Point 690 402)
       )
       (connect D9:1 O1:1
        (Point 1106 350)
        (Point 1131 350)
        (Point 1131 354)
        (Point 917 354)
       )
      )
      (stackingOrder 0 1 4 2 11 12 10 13 8 7
        9 3 5 6)
     )
     (terminals on)
     (active detail)
    )
   )
   (context 3
    (name "validatePasswd")
    (description 21 5
     This function operates much the same way as the 
     function validateName.  It differs in that it not 
     only checks to see if the value the user entered 
     is a valid password.  It also checks that the 
     position of a valid password is equal to the user 
     number (which is itself a positional value).  In 
     this way, the user name has one and only one valid 
     password attached to it.  If we look at the
     layout of the "names.dat" and "passwd.dat" files 
     there is a one-to-one correspondence between user 
     names and passwords.
     
     Joe		Namath	
     Roger	Staubach
     Johnnie	Unitas
     
     "Joe" is a valid user name whose valid passowrd is 
     "Namath". "Joe" and "Staubach" will not be 
     accepted.
     
     
    )
    (interface
     (sequence in)
     (sequence out)
     (output 1
      (type data)
      (name "X")
      (lock constraints)
      (optional yes)
     )
    )
    (implementation
     (locked no)
     (trigMode deg)
     (nextID 16)
     (component 0 "LITERALCONSTANT"
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "Text")
        (lock name constraints)
       )
      )
      (implementation
       (component value Text
        (name "Text")
        (datum "Please type your password")
       )
       (component autoTrigger off)
       (component initializeAtPrerun off)
       (component initializeAtActivate off)
       (component initValue Text
        (name "CString")
        (datum "")
       )
      )
      (views
       (icon
       )
       (detail
        (origin 39 107)
        (extent 242 35)
       )
       (title off)
       (active detail)
      )
     )
     (component 1 "LITERALCONSTANT"
      (name "Your password")
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "Text")
        (lock name constraints)
       )
      )
      (implementation
       (component value Text
        (name "Your password")
        (datum "???")
       )
       (component autoTrigger off)
       (component initializeAtPrerun on)
       (component initializeAtActivate on)
       (component initValue Text
        (name "CString")
        (datum "???")
       )
      )
      (views
       (icon
        (extent 117 0)
       )
       (detail
        (origin 53 287)
        (extent 214 34)
       )
       (active detail)
      )
     )
     (component 2 "CONFIRM"
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "Go")
        (lock name constraints)
       )
      )
      (implementation
      )
      (views
       (icon
        (origin 123 164)
        (extent 54 40)
       )
       (detail
       )
       (terminals on)
       (active icon)
      )
     )
     (component 3 "FORMULA"
      (name "strPosstr(str1,str2)")
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "str1")
        (lock name constraints)
       )
       (input 2
        (type data)
        (name "str2")
        (lock name constraints)
       )
       (output 1
        (type data)
        (name "index")
        (lock name constraints)
       )
      )
      (implementation
       (component isLocked yes)
       (component expr 1 "strPosStr(str1,str2)")
      )
      (views
       (icon
        (origin 358 320)
        (extent 145 28)
       )
       (detail
        (origin 258 394)
        (extent 214 112)
       )
       (terminals on)
       (active icon)
      )
     )
     (component 4 "FROMGLOBAL"
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "Data")
        (tag "Data")
        (lock name constraints)
       )
      )
      (implementation
       (component globalName passwd)
      )
      (views
       (icon
       )
       (detail
        (origin 106 383)
        (extent 89 62)
       )
       (terminals on)
       (active detail)
      )
     )
     (component 5 "CONSTANT"
      (name "Integer")
      (subType "Integer")
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "Int32")
        (lock name constraints)
       )
      )
      (implementation
       (component value Int32
        (name "Integer")
        (datum 0)
       )
       (component autoTrigger off)
       (component initializeAtPrerun off)
       (component initializeAtActivate off)
       (component initValue Int32
        (name "LongInt")
        (datum 0)
       )
      )
      (views
       (icon
       )
       (detail
        (origin 407 187)
        (extent 66 34)
        (showFormat int)
       )
       (title off)
       (active detail)
      )
     )
     (component 6 "COMPARATOR"
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "Ref Value")
        (tag "RefValue")
       )
       (input 2
        (type data)
        (name "Test Value")
        (tag "TestValue")
       )
       (output 1
        (type data)
        (name "Passed")
        (tag "Passed")
        (lock name constraints)
        (optional yes)
       )
       (output 2
        (type data)
        (name "Failed")
        (tag "Failed")
        (lock name constraints)
        (optional yes)
       )
       (output 3
        (type data)
        (name "Failures")
        (tag "Failures")
        (lock name constraints)
        (optional yes)
       )
      )
      (implementation
       (attr relation "!=")
      )
      (views
       (icon
       )
       (detail
        (origin 633 209)
        (extent 214 110)
       )
       (terminals on)
       (active detail)
      )
     )
     (component 7 "CONSTANT"
      (name "Integer")
      (subType "Integer")
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "Int32")
        (lock name constraints)
       )
      )
      (implementation
       (component value Int32
        (name "Integer")
        (datum -1)
       )
       (component autoTrigger off)
       (component initializeAtPrerun off)
       (component initializeAtActivate off)
       (component initValue Int32
        (name "LongInt")
        (datum 0)
       )
      )
      (views
       (icon
       )
       (detail
        (origin 947 417)
        (extent 66 34)
        (showFormat int)
       )
       (title off)
       (active detail)
      )
     )
     (component 8 "CONSTANT"
      (name "Integer")
      (subType "Integer")
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "Int32")
        (lock name constraints)
       )
      )
      (implementation
       (component value Int32
        (name "Integer")
        (datum 0)
       )
       (component autoTrigger off)
       (component initializeAtPrerun off)
       (component initializeAtActivate off)
       (component initValue Int32
        (name "LongInt")
        (datum 0)
       )
      )
      (views
       (icon
       )
       (detail
        (origin 957 537)
        (extent 66 34)
        (showFormat int)
       )
       (title off)
       (active detail)
      )
     )
     (component 9 "JUNCTION"
      (name "JCT")
      (interface
       (input 1
        (type data)
        (name "A")
        (lock name constraints)
       )
       (input 2
        (type data)
        (name "B")
        (lock name constraints)
       )
       (output 1
        (type data)
        (name "Data")
        (lock name constraints)
       )
      )
      (implementation
      )
      (views
       (icon
        (origin 1046 510)
        (extent 48 28)
       )
       (detail
       )
       (terminals on)
       (active icon)
      )
     )
     (component 10 "FROMCOORDINATE"
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "Coord Data")
        (requires
         (datatype Coord)
        )
        (lock name constraints)
       )
       (output 1
        (type data)
        (name "X Data")
        (lock name constraints)
       )
       (output 2
        (type data)
        (name "Y Data")
        (lock name constraints)
        (optional yes)
       )
      )
      (implementation
      )
      (views
       (icon
        (origin 342 380)
        (extent 116 68)
        (iconImage "unbuild.icon")
       )
       (detail
        (origin 640 645)
        (extent 35 70)
       )
       (terminals on)
       (active icon)
      )
     )
     (component 11 "FROMGLOBAL"
      (name "Get Global")
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "Data")
        (tag "Data")
        (lock name constraints)
       )
      )
      (implementation
       (component globalName userNumber)
      )
      (views
       (icon
       )
       (detail
        (origin 439 535)
        (extent 143 59)
       )
       (terminals on)
       (active detail)
      )
     )
     (component 12 "IFTHENELSE"
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "A")
        (optional yes)
       )
       (input 2
        (type data)
        (name "B")
        (optional yes)
       )
       (output 1
        (type data)
        (name "Then")
        (lock name constraints)
       )
       (output 2
        (type data)
        (name "Else")
        (lock name constraints)
       )
       (output 3
        (type exception)
        (name "Error")
        (lock name constraints)
        (optional yes)
       )
      )
      (implementation
       (component isLocked no)
       (component expr "a!=b")
      )
      (views
       (icon
       )
       (detail
        (origin 715 462)
        (extent 60 104)
       )
       (terminals on)
       (active detail)
      )
     )
     (component 13 "JUNCTION"
      (name "JCT")
      (interface
       (input 1
        (type data)
        (name "A")
        (lock name constraints)
       )
       (input 2
        (type data)
        (name "B")
        (lock name constraints)
       )
       (output 1
        (type data)
        (name "Data")
        (lock name constraints)
       )
      )
      (implementation
      )
      (views
       (icon
        (origin 856 470)
        (extent 48 28)
       )
       (detail
       )
       (terminals on)
       (active icon)
      )
     )
     (component 14 "JUNCTION"
      (name "JCT")
      (interface
       (input 1
        (type data)
        (name "A")
        (lock name constraints)
       )
       (input 2
        (type data)
        (name "B")
        (lock name constraints)
       )
       (output 1
        (type data)
        (name "Data")
        (lock name constraints)
       )
      )
      (implementation
      )
      (views
       (icon
        (origin 566 450)
        (extent 48 28)
       )
       (detail
       )
       (terminals on)
       (active icon)
      )
     )
     (component 15 "CONSTANT"
      (name "Integer")
      (subType "Integer")
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "Int32")
        (lock name constraints)
       )
      )
      (implementation
       (component value Int32
        (name "Integer")
        (datum -3)
       )
       (component autoTrigger off)
       (component initializeAtPrerun off)
       (component initializeAtActivate off)
       (component initValue Int32
        (name "LongInt")
        (datum 0)
       )
      )
      (views
       (icon
       )
       (detail
        (origin 513 398)
        (extent 54 33)
        (showFormat int)
       )
       (title off)
       (active detail)
      )
     )
     (configuration
      (connect D2:1 D1:0)
      (connect D1:1 D3:1)
      (connect D4:1 D3:2)
      (connect D5:1 D6:1)
      (connect D3:1 D6:2)
      (connect D13:1 D7:0)
      (connect D12:2 D8:0)
      (connect D7:1 D9:1)
      (connect D8:1 D9:2)
      (connect D6:3 D10:1)
      (connect D14:1 D12:1)
      (connect D11:1 D12:2)
      (connect D12:1 D13:1)
      (connect D12:3 D13:2)
      (connect D15:1 D14:1)
      (connect D10:1 D14:2)
      (connect D6:1 D15:0)
      (connect D9:1 O1:1)
     )
     (ShowOnExecPanel
      (origin 11 77)
      (extent 262 272)
      (panel
       (origin 365 229)
       (extent 258 244)
       (widget 1 detail
        (title on)
        (origin 387 319)
        (extent 214 34)
       )
       (widget 2 icon
        (title off)
        (origin 469 359)
        (extent 54 40)
       )
       (widget 0 detail
        (title off)
        (origin 373 247)
        (extent 245 32)
       )
      )
     )
    )
    (views
     (detail
      (origin 45 89)
      (extent 875 530)
      (configuration
       (connect D2:1 D1:0
        (Point 179 184)
        (Point 200 184)
        (Point 200 224)
        (Point 160 224)
        (Point 160 256)
       )
       (connect D1:1 D3:1
        (Point 269 304)
        (Point 290 304)
        (Point 290 324)
        (Point 355 324)
       )
       (connect D4:1 D3:2
        (Point 247 414)
        (Point 270 414)
        (Point 270 344)
        (Point 355 344)
       )
       (connect D5:1 D6:1
        (Point 475 204)
        (Point 500 204)
        (Point 500 234)
        (Point 520 234)
       )
       (connect D3:1 D6:2
        (Point 505 334)
        (Point 520 334)
        (Point 520 294)
       )
       (connect D13:1 D7:0
        (Point 906 484)
        (Point 920 484)
        (Point 920 394)
        (Point 980 394)
        (Point 980 414)
       )
       (connect D12:2 D8:0
        (Point 837 514)
        (Point 990 514)
        (Point 990 534)
       )
       (connect D7:1 D9:1
        (Point 1015 434)
        (Point 1040 434)
        (Point 1040 474)
        (Point 1030 474)
        (Point 1030 514)
        (Point 1043 514)
       )
       (connect D8:1 D9:2
        (Point 1025 554)
        (Point 1040 554)
        (Point 1040 544)
        (Point 1030 544)
        (Point 1030 534)
        (Point 1043 534)
       )
       (connect D6:3 D10:1
        (Point 939 294)
        (Point 950 294)
        (Point 950 364)
        (Point 320 364)
        (Point 320 414)
        (Point 339 414)
       )
       (connect D14:1 D12:1
        (Point 616 464)
        (Point 630 464)
        (Point 630 484)
        (Point 672 484)
       )
       (connect D11:1 D12:2
        (Point 634 564)
        (Point 650 564)
        (Point 650 544)
        (Point 672 544)
       )
       (connect D12:1 D13:1
        (Point 837 484)
        (Point 840 484)
        (Point 840 474)
        (Point 853 474)
       )
       (connect D12:3 D13:2
        (Point 837 544)
        (Point 840 544)
        (Point 840 494)
        (Point 853 494)
       )
       (connect D15:1 D14:1
        (Point 569 414)
        (Point 580 414)
        (Point 580 444)
        (Point 550 444)
        (Point 550 454)
        (Point 563 454)
       )
       (connect D10:1 D14:2
        (Point 460 394)
        (Point 480 394)
        (Point 480 474)
        (Point 563 474)
       )
       (connect D6:1 D15:0
        (Point 939 234)
        (Point 940 234)
        (Point 940 344)
        (Point 540 344)
        (Point 540 395)
       )
       (connect D9:1 O1:1
        (Point 1096 524)
        (Point 1110 524)
        (Point 1110 380)
        (Point 910 380)
        (Point 910 364)
        (Point 917 364)
       )
      )
      (stackingOrder 5 2 10 4 1 6 7 9 8 13
        12 11 14 15 3 0)
     )
     (terminals on)
     (active detail)
    )
   )
   (context 4
    (name "IncrementCount")
    (interface
     (sequence in)
     (sequence out)
     (output 1
      (type data)
      (name "X")
      (lock constraints)
      (optional yes)
     )
    )
    (implementation
     (locked no)
     (trigMode deg)
     (nextID 5)
     (component 2 "FROMGLOBAL"
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "Data")
        (tag "Data")
        (lock name constraints)
       )
      )
      (implementation
       (component globalName attempt)
      )
      (views
       (icon
       )
       (detail
        (origin 322 270)
        (extent 97 61)
       )
       (terminals on)
       (active detail)
      )
     )
     (component 3 "FORMULA"
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "A")
        (optional yes)
       )
       (output 1
        (type data)
        (name "Result")
        (lock name constraints)
       )
      )
      (implementation
       (component isLocked no)
       (component expr 1 "a+1")
      )
      (views
       (icon
        (iconImage "formula.icon")
       )
       (detail
        (origin 566 299)
        (extent 79 62)
       )
       (terminals on)
       (active detail)
      )
     )
     (component 4 "TOGLOBAL"
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "Data")
        (tag "Data")
       )
      )
      (implementation
       (component globalName attempt)
      )
      (views
       (icon
       )
       (detail
        (origin 352 399)
        (extent 97 62)
       )
       (terminals on)
       (active detail)
      )
     )
     (configuration
      (connect D0:1 D1:1)
      (connect D1:1 D2:1)
      (connect D1:1 O1:1)
     )
    )
    (views
     (detail
      (origin 245 189)
      (extent 476 297)
      (configuration
       (connect D0:1 D1:1
        (Point 471 300)
        (Point 490 300)
        (Point 490 330)
        (Point 523 330)
       )
       (connect D1:1 D2:1
        (Point 717 330)
        (Point 740 330)
        (Point 740 380)
        (Point 500 380)
        (Point 500 350)
        (Point 280 350)
        (Point 280 430)
        (Point 299 430)
       )
       (connect D1:1 O1:1
        (Point 717 330)
        (Point 740 330)
        (Point 740 380)
        (Point 710 380)
        (Point 710 347)
        (Point 718 347)
       )
      )
      (stackingOrder 0 1 2)
     )
     (terminals on)
     (active detail)
    )
   )
   (context 5
    (name "init")
    (interface
     (sequence in)
     (sequence out)
    )
    (implementation
     (locked no)
     (trigMode deg)
     (nextID 3)
     (component 1 "CONSTANT"
      (name "Integer")
      (subType "Integer")
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "Int32")
        (lock name constraints)
       )
      )
      (implementation
       (component value Int32
        (name "Integer")
        (datum 1)
       )
       (component autoTrigger off)
       (component initializeAtPrerun off)
       (component initializeAtActivate off)
       (component initValue Int32
        (name "LongInt")
        (datum 0)
       )
      )
      (views
       (icon
       )
       (detail
        (origin 445 272)
        (extent 130 36)
        (showFormat int)
       )
       (active detail)
      )
     )
     (component 2 "TOGLOBAL"
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "Data")
        (tag "Data")
       )
      )
      (implementation
       (component globalName attempt)
      )
      (views
       (icon
       )
       (detail
        (origin 482 399)
        (extent 97 62)
       )
       (terminals on)
       (active detail)
      )
     )
     (configuration
      (connect D0:1 D1:1)
     )
    )
    (views
     (detail
      (origin 365 199)
      (extent 249 287)
      (configuration
       (connect D0:1 D1:1
        (Point 577 290)
        (Point 600 290)
        (Point 600 330)
        (Point 410 330)
        (Point 410 430)
        (Point 429 430)
       )
      )
      (stackingOrder 0 1)
     )
     (terminals on)
     (active detail)
    )
   )
   (context 6
    (name "accepted")
    (interface
     (sequence in)
     (sequence out)
    )
    (implementation
     (locked no)
     (trigMode deg)
     (nextID 2)
     (component 0 "LITERALCONSTANT"
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "Text")
        (lock name constraints)
       )
      )
      (implementation
       (component value Text
        (name "Text")
        (datum "Login and Password Accepted")
       )
       (component autoTrigger off)
       (component initializeAtPrerun off)
       (component initializeAtActivate off)
       (component initValue Text
        (name "CString")
        (datum "")
       )
      )
      (views
       (icon
       )
       (detail
        (origin 350 267)
        (extent 260 46)
       )
       (title off)
       (active detail)
      )
     )
     (component 1 "DELAY"
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "Done")
        (tag "Done")
        (lock constraints)
       )
      )
      (implementation
       (component delay 2)
      )
      (views
       (icon
       )
       (detail
        (origin 430 407)
        (extent 120 34)
       )
       (active detail)
      )
     )
     (configuration
     )
     (ShowOnExecPanel
      (origin 330 153)
      (extent 336 151)
      (panel
       (origin 378 282)
       (extent 332 123)
       (widget 0 detail
        (title off)
        (origin 417 318)
        (extent 261 37)
       )
      )
     )
    )
    (views
     (detail
      (origin 345 209)
      (extent 280 257)
      (configuration
      )
      (stackingOrder 1 0)
     )
     (terminals on)
     (active detail)
    )
   )
   (context 7
    (name "LogMeIn")
    (description 70 5
     The Sequncer in this User Function first sets
     a Global called "attempt" to one.  The reasons
     for this are as follows: We want to let our user
     have three tries at logging in successfully, so we
     need to keep track (from within the Sequencer)
     of how many attempts they have made.  We decided 
     to use a Global for this purpose.  We must always
     set a Global before we can examine its value, so
     the first transaction in the Sequencer sets
     the initial value to zero.  If the user fails to
     log in successfully, we increment the "attempt"
     Global.  If its value excedes three we exit 
     returning a negative value to indicate failure.
     The Sequencer transaction labeled "Success"
     increments the "attempt" count and checks to see
     if the value is three or less.  If so, we give the
     user another chance by branching back to the
     transaction labeled "validateName".  
     
     "validateName" calls a User Function of the same
     name.  This transaction checks to see that the
     User Function return value is zero.  Zero indi-
     cates success, and a negative value indicates 
     failure.
     
     "validatePassword" also calls a User Function if 
     this same name, and, like "validateName",
     considers zero to be a passing value, while
     negative numbers are failing values.
     
     "readNames" and "readPasswd" read the contents
     of two files which hold the valid user names and
     pass words.  
     
     Refer to the descriptions in the User Functions
     "validateName" and "validatePassword" for
     details on how these two User Functions
     operate.
     
     The Build Record object accepts input from three
     places.  The Global named "userNumber" is set 
     as a result of calling "validateName".  This
     number is used to determine if the user is valid
     for a given password.  Suppose that we had the 
     following entries in our User Name and Password
     files:
     
     User Names				Password
     ----------				--------
     Joe						Namath
     Roger					Staubach
     Johnnie					Unitas
     
     Joe would be user number 0, Roger would be
     user number 1, and Johnnie would be user number
     two.  If the user enters an invalid user name,
     we set the user number to a negative value.
     When we wanted to see if a particular user 
     typed in the correct password, we would first
     check to see that the password they typed in is
     in the list of valid passwords.  Namath would be
     password 0, Staubach (my personal favorite) would
     be password 1, and Unitas would be password 2.
     
     If the user number matches the password number, 
     then the user has successfully logged in.
     
     The Build record also contains the Sequencer
     return value (0 for success; a negative value
     for failure) and its log record.
    )
    (interface
     (sequence in)
     (sequence out)
     (output 1
      (type data)
      (name "X")
      (lock constraints)
      (optional yes)
     )
    )
    (implementation
     (locked no)
     (trigMode deg)
     (nextID 3)
     (component 0 "SEQUENCER"
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "Return")
        (tag "Return")
        (lock name constraints)
        (optional yes)
       )
       (output 2
        (type data)
        (name "Log")
        (tag "Log")
        (lock name constraints)
        (optional yes)
       )
      )
      (implementation
       (component logfields "name" "pass" "result")
       (procedure
         init EXECEX:init() 	///* initialize global counter */
         readNames EXECEX:readNames() 	///* read names into global */
         readPasswd EXECEX:readPasswds() 	///* read passwords into global */
         validateName LOGEN TESTEX:validateName() 	LIMITEX: 0 EQ 0 	///* check for valid name */
         validatePassword LOGEN TESTEX:validatePasswd() 	LIMITEX: 0 EQ 0 	PASSOP TGOTO:end 	///* valid password ? */
         Success TESTEX:incrementCount() 	LIMITEX: 3 LE 3 	PASSOP TGOTO:validateName 	FAILOP TRTN:-1 ///* third try ?  exit failed */
         end EXECEX:accepted() 	///* exit passed */
       )
      )
      (views
       (icon
        (origin 454 386)
        (extent 112 28)
       )
       (detail
        (origin 149 125)
        (extent 502 170)
       )
       (terminals on)
       (active detail)
      )
     )
     (component 1 "TORECORD"
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "Result")
        (optional yes)
       )
       (input 2
        (type data)
        (name "Log")
        (optional yes)
       )
       (input 3
        (type data)
        (name "userNumber")
        (optional yes)
       )
       (output 1
        (type data)
        (name "Record")
        (tag "Record")
        (lock constraints)
       )
      )
      (implementation
       (component outputType scalar)
      )
      (views
       (icon
        (iconImage "build.icon")
       )
       (detail
        (origin 659 413)
        (extent 123 154)
       )
       (terminals on)
       (active detail)
      )
     )
     (component 2 "FROMGLOBAL"
      (interface
       (sequence in)
       (sequence out)
       (output 1
        (type data)
        (name "Data")
        (tag "Data")
        (lock name constraints)
       )
      )
      (implementation
       (component globalName userNumber)
      )
      (views
       (icon
       )
       (detail
        (origin 295 429)
        (extent 131 63)
       )
       (terminals on)
       (active detail)
      )
     )
     (configuration
      (connect D0:1 D1:1)
      (connect D0:2 D1:2)
      (connect D2:1 D1:3)
      (connect D1:1 O1:1)
     )
    )
    (views
     (detail
      (origin 105 89)
      (extent 753 503)
      (configuration
       (connect D0:1 D1:1
        (Point 723 170)
        (Point 750 170)
        (Point 750 330)
        (Point 540 330)
        (Point 540 440)
        (Point 546 440)
       )
       (connect D0:2 D1:2
        (Point 723 250)
        (Point 740 250)
        (Point 740 320)
        (Point 530 320)
        (Point 530 490)
        (Point 546 490)
       )
       (connect D2:1 D1:3
        (Point 478 460)
        (Point 500 460)
        (Point 500 540)
        (Point 546 540)
       )
       (connect D1:1 O1:1
        (Point 854 490)
        (Point 860 490)
        (Point 860 370)
        (Point 850 370)
        (Point 850 350)
        (Point 855 350)
       )
      )
      (stackingOrder 2 0 1)
     )
     (terminals on)
     (active detail)
    )
   )
  )
  (locked no)
  (trigMode deg)
  (nextID 8)
  (component 0 "NOTE"
   (interface
   )
   (implementation
   )
   (views
    (icon
     (origin 541 256)
     (extent 338 48)
     (label off)
     (iconImage "disclaim.icon")
    )
    (detail
     (origin 830 250)
     (extent 200 100)
     (editing enabled)
    )
    (active icon)
   )
  )
  (component 1 "CONTEXT"
   (name "User Names")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Data")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (locked no)
    (trigMode deg)
    (nextID 2)
    (component 0 "FROMGLOBAL"
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Data")
       (tag "Data")
       (lock name constraints)
      )
     )
     (implementation
      (component globalName names)
     )
     (views
      (icon
      )
      (detail
       (origin 176 619)
       (extent 89 62)
      )
      (terminals on)
      (active detail)
     )
    )
    (component 1 "CALL"
     (name "Call Function")
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (component callFunc "readNames")
     )
     (views
      (icon
      )
      (detail
       (origin 111 522)
       (extent 238 36)
      )
      (terminals on)
      (active detail)
     )
    )
    (configuration
     (connect D1:0 D0:0)
     (connect D0:1 O1:1)
    )
   )
   (views
    (icon
     (origin 94 146)
     (extent 112 28)
    )
    (detail
     (origin 52 451)
     (extent 376 279)
     (configuration
      (connect D1:0 D0:0
       (Point 230 560)
       (Point 230 588)
      )
      (connect D0:1 O1:1
       (Point 317 650)
       (Point 340 650)
       (Point 340 600)
       (Point 425 600)
      )
     )
     (stackingOrder 0 1)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 2 "CONTEXT"
   (name "Passwords")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "X")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (locked no)
    (trigMode deg)
    (nextID 2)
    (component 0 "FROMGLOBAL"
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Data")
       (tag "Data")
       (lock name constraints)
      )
     )
     (implementation
      (component globalName passwd)
     )
     (views
      (icon
      )
      (detail
       (origin 186 709)
       (extent 89 62)
      )
      (terminals on)
      (active detail)
     )
    )
    (component 1 "CALL"
     (name "Call Function")
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (component callFunc "readPasswds")
     )
     (views
      (icon
      )
      (detail
       (origin 121 622)
       (extent 238 36)
      )
      (terminals on)
      (active detail)
     )
    )
    (configuration
     (connect D1:0 D0:0)
     (connect D0:1 O1:1)
    )
   )
   (views
    (icon
     (origin 94 236)
     (extent 112 28)
    )
    (detail
     (origin 62 546)
     (extent 376 269)
     (configuration
      (connect D1:0 D0:0
       (Point 240 660)
       (Point 240 678)
      )
      (connect D0:1 O1:1
       (Point 327 740)
       (Point 350 740)
       (Point 350 690)
       (Point 435 690)
      )
     )
     (stackingOrder 0 1)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 3 "SCROLLINGTEXTDISPLAY"
   (name "Valid login names")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 135 0)
    )
    (detail
     (origin 281 117)
     (extent 219 87)
     (bufferSize 256)
    )
    (active detail)
   )
  )
  (component 4 "SCROLLINGTEXTDISPLAY"
   (name "Valid Passwords")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 127 0)
    )
    (detail
     (origin 279 356)
     (extent 223 97)
     (bufferSize 256)
    )
    (active detail)
   )
  )
  (component 5 "CONTEXT"
   (name "Press For")
   (description 10 4
    This User Object is the outermost "context"
    for the InfoAbout help device.  Within this
    device is the pop-up panel containing the info
    Notepad.  If all you can see is a device with
    "Press For", you should double-click the left
    mouse button on the Press For to restore the
    Panel View of the device.  To see how this device
    operates, click on the Info About button first,
    then press the Detail button in the "Press For"
    title bar.
   )
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (locked no)
    (trigMode deg)
    (nextID 4)
    (component 0 "TOGGLE"
     (name "Info About")
     (description 24 6
      This is a toggle device with the name changed to
      reflect it's function.  The output of the device
      is "0" when the button is up, and "1" when the
      button is down.  
      
      A Reset Control Input terminal has been added to
      to always pop the button back out after showing
      the pop-up help (Info About This Example) User
      Object.
      
      The Toggle has set the "AutoExecute" option to let
      it operate even when the RUN button in the title
      bar has not been pressed.  Note, however, that
      AutoExecute only works when no other threads are
      operating, either from their Start buttons or from
      the RUN button.
      
      To allow the Toggle to operate when other threads
      are running, an Until Break device repeatedly lets
      the Toggle device output it's current value (based
      on the button state) to the If/Then.  Thus, when
      RUN is pressed, the InfoAbout toggle output is
      still monitored for "1".
      
     )
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Reset")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Info About")
       (values range 0 1)
       (datum 0)
      )
      (component autoTrigger on)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (name "LongInt")
       (datum 0)
      )
     )
     (views
      (icon
       (origin 231 333)
       (extent 114 39)
       (format button)
      )
      (detail
       (origin 320 203)
       (extent 42 54)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "REPEATUNTILBREAK"
     (description 8 6
      This object is of use only when the RUN button in
      the title bar has been pressed to cause one or
      more threads to begin execution.  Since the toggle
      button (InfoAbout) will not AutoExecute when other
      threads are running, we need the Until Break to
      continually cause the Toggle to send it's output
      value (0 if button up, 1 if button down) to the
      "If/Then" object.  
     )
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Continuous")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 155 258)
       (extent 110 64)
       (iconImage "loop.icon")
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "CONTEXT"
     (name "Info About This Example")
     (description 10 6
      This is a User Object that has both a detail view
      and a Panel view.  If this device is visible as
      an icon, you must double-click the left mouse
      button to "open up" the non-iconic view.
      
      Since the User Object has both a Panel and Detail
      view, when you double-click on the icon, you will
      first see the Panel view.  To see the components
      of the User Object, press the Detail button in
      the "Info About This Example" title bar.
     )
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (locked no)
      (trigMode deg)
      (nextID 3)
      (component 0 "NOTE"
       (name "NotePad")
       (description 11 8
        This notepad is displayed as a Show on Execute
        panel to present the information to the reader.
        
        It has been "Added to Panel" of the "Info About
        This Example" user object, thus it is not 
        necessary to keep it as an open device inside the
        Detail view; you can edit the notepad from the
        Panel view of this User Object.  You can also
        set/clear the "Enable Edit" flag in this Notepad's
        Object Menu to keep the pop-up notepad from being
        altered by the user.
       )
       (interface
       )
       (implementation
        (component text 71 9
         PURPOSE: To show one possible use of the sequencer to implement a login and password 
         	mechanism
         
         DESIGN PHILOSOPHY: We took the approach that a password mechanism is intended to 
         	prevent unwanted access to some part of a system.  Because of that, we might want 
         	to require a person using this application to identify himself or herself with a 
         	login name and verify that login name through the use of a password.  The valid 
         	user names and passwords are in the files "names.dat" and "passwd.dat" respectively.  
         	Although we show both the valid user names and passwords so that we can use the 
         	example, we might not want to to display the passwords in an actual program.  Note 
         	also that we have used global variables to hold the values representing user names 
         	and passwords.  In the detail view, we can see these values by choosing the 
         	selection "View Globals ..." under the "Edit" menu.  The "Edit" menu is not visible 
         	in the panel view of a program, so we might want to have a secured panel view of 
         	this application should we wish to employ a password mechanism in an actual 
         	application.
         
         HOW THIS EXAMPLE WORKS: We are using a Sequencer to read two files containing valid
         	user names and passwords respectively.  We save this information in global 
         	variables.  We then prompt the user to enter his/her name and check to see if the 
         	name the user typed was a valid name.  If so, we set a global variable representing 
         	the user number.  This is actually just a number representing which entry in the 
         	user name file corresponds to the name the user typed.  We then use a similar 
         	process to prompt for a password.  If the user number equals the positional value 
         	of the password entry in the "passwd.dat" file, then the user has successfully 
         	logged in.  Otherwise, we cycle through the login and password entry up to two more 
         	times.  If the user has not successfully logged in at that point, we return a -1 
         	from the sequencer.  We return a 0 when the user successfully completes the login 
         	process.  The "Show Description" field in the sequencer object explains in more 
         	detail how we cycle through this sequence.
         
         USER FUNCTIONS: The sequencer calls a number of User Functions as it processes
         	user input.  This simple explanation, with the descriptions provided in the "Show
         	Description" fields on the objects, details their implementations.
         
         	init: this function sets the initial value of a Counter object to zero.  The Counter
         		is set up with its "Clear at Activate" property unchecked.  This allows
         		The Counter to increment the value it held the last time it was activated.
         
         	readNames: This function reads from a file the valid user names.  Note that the 
         	    "From File" object has a transaction that reads a 1d array of strings to the 
         		end of the file.  This allows you to read all the available user names without 
         		needing to know how many there are.  It then stores the names in a global 
         		variable.
         
         	readPasswds:  This function is much the same as the readNames function with
         		the exception that we read a different file.
         
         	validateName: This function accepts an entry the user types into a text constant
         		and compares it to the list of known user names.  If the user's entry 
         		corresponds to an entry in the "names.dat" file, we store the number 
         		representing that user.  This function returns a -1 to indicate failure and a 
         		0 to indicate success.  The "Show Description" field goes into more detail 
         		about the implementation of this function.
         
         	validatePasswd: This function accepts an entry the user types into a text constant
         		and compares it to the entries found in the "passwd.dat" file.  If the user has
         		entered a valid password and that password corresponds to the user number
         		(the positional value of the user name in the "names.dat" file) defined 
         		previously, we return a 0 to indicate success.  Otherwise, we return a -1 to 
         		indicate failure.  This return value enables us to imbed this sequencer within
         		another.  The return value can be evaluated to determine successful login 
         		as one step in a complete application.
         	
         	incrementCount: The Sequencer calls this function if the user has not successfully
         		entered a valid user name and password.  The Counter we initialized to 0 
         		is incremented.  If the Counter's value exceeds two, the user has had three
         		chances to enter a valid name and password and has failed.
         
         	accepted: This function displays a message indicating successful entry, delays one
         		second, then exits.
        )
       )
       (views
        (icon
         (origin 440 409)
         (extent 78 25)
        )
        (detail
         (origin 55 199)
         (extent 848 437)
         (editing enabled)
        )
        (active detail)
       )
      )
      (component 1 "CONFIRM"
       (name "DONE")
       (description 7 8
        This tiny "thread" begins running when the 
        enclosing UserObject is executed.  When the user
        acknowledges the OK/DONE button, there is nothing
        left to execute, so the thread ends.  Since there
        are not other threads running, the User Object
        is completed and will exit, removing the Show on
        Execute pop-up display.
       )
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 451 472)
         (extent 58 37)
        )
        (detail
         (origin 156 253)
         (extent 79 34)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 2 "NOTE"
       (name "If You\'re Lost")
       (description 7 8
        You could remove this device totally and it 
        would have no affect on the InfoAbout help
        system -- it's only here in case you get lost.
        
        If this device is an icon, double click the
        left button on it to open up the "If you're Lost"
        Notepad.
       )
       (interface
       )
       (implementation
        (component text 22 9
         This notepad is not part
         of the device -- it just
         tells how to back out of
         this example if you are
         lost.
         
         To return to the Panel
         view of the "Info About
         This Example", press the
         Panel button in it's title
         bar. 
         
         If you hit the "iconize" dot
         in the upper right corner of
         the "Info About This Example",
         you will be able to look at
         the "Press For" user object
         Detail view again.
         
         (You must double-click on the
         device to reopen the non-iconic
         views.)
        )
       )
       (views
        (icon
         (extent 136 0)
         (iconImage "notepad.icon")
        )
        (detail
         (origin 650 413)
         (extent 301 414)
         (editing enabled)
        )
        (active detail)
       )
      )
      (configuration
      )
      (ShowOnExecPanel
       (origin 16 95)
       (extent 849 561)
       (panel
        (origin 68 154)
        (extent 845 533)
        (widget 1 icon
         (title off)
         (origin 467 639)
         (extent 58 37)
        )
        (widget 0 detail
         (title off)
         (origin 81 166)
         (extent 820 470)
         (editing disabled)
        )
       )
      )
     )
     (views
      (icon
       (origin 382 408)
       (extent 217 25)
      )
      (detail
       (origin 47 150)
       (extent 866 520)
       (configuration
       )
       (stackingOrder 1 2 0)
      )
      (active icon)
     )
    )
    (component 3 "IFTHENELSE"
     (name "!= 0")
     (description 10 6
      This device tests the value of the data input
      and either executes the "Info About This Device"
      User object when the input is "1", or terminates
      the current iteration of the Until Break device.
      
      If no threads are running, the Toggle can generate
      it's output data whenever the button is changed
      (using the Toggle's AutoExecute mode).  In this
      case, either the User Object is executed or the
      Autoexecute sequence terminates.
     )
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a!=0")
     )
     (views
      (icon
       (origin 397 338)
       (extent 46 25)
      )
      (detail
       (origin 349 328)
       (extent 73 64)
      )
      (terminals on)
      (active icon)
     )
    )
    (configuration
     (connect D1:1 D0:0)
     (connect D3:0 D0:1)
     (connect D3:1 D2:0)
     (connect D0:1 D3:1)
    )
   )
   (views
    (icon
     (origin 165 788)
     (extent 110 25)
    )
    (panel
     (origin 541 132)
     (extent 319 77)
     (widget 0 icon
      (title off)
      (origin 644 150)
      (extent 114 39)
      (format button)
     )
    )
    (detail
     (origin 34 105)
     (extent 912 591)
     (configuration
      (connect D1:1 D0:0
       (Point 267 290)
       (Point 288 290)
       (Point 288 330)
      )
      (connect D3:0 D0:1
       (Point 420 365)
       (Point 420 390)
       (Point 210 390)
       (Point 210 352)
       (Point 228 352)
      )
      (connect D3:1 D2:0
       (Point 445 340)
       (Point 490 340)
       (Point 490 405)
      )
      (connect D0:1 D3:1
       (Point 347 352)
       (Point 370 352)
       (Point 370 350)
       (Point 394 350)
      )
     )
     (stackingOrder 0 1 3 2)
    )
    (active panel)
    (active panel)
   )
  )
  (component 6 "EXITPROCESS"
   (interface
    (sequence in)
   )
   (implementation
    (comp code 0)
   )
   (views
    (icon
     (origin 110 420)
     (extent 80 68)
     (iconImage "stop.icon")
    )
    (detail
     (origin 450 722)
     (extent 120 36)
    )
    (active icon)
   )
  )
  (component 7 "CALL"
   (name "Log Me In")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "X")
     (lock name constraints)
     (optional yes)
    )
   )
   (implementation
    (component callFunc "LogMeIn")
   )
   (views
    (icon
     (origin 103 327)
     (extent 95 27)
    )
    (detail
     (origin 31 322)
     (extent 238 36)
    )
    (terminals on)
    (active icon)
   )
  )
  (configuration
   (connect D1:0 D2:0)
   (connect D1:1 D3:1)
   (connect D2:1 D4:1)
   (connect D7:0 D6:0)
   (connect D2:0 D7:0)
  )
 )
 (views
  (panel
   (origin 0 62)
   (extent 888 610)
   (widget 0 icon
    (title off)
    (origin 539 614)
    (extent 338 48)
    (label off)
    (iconImage "disclaim.icon")
   )
   (widget 5 panel
    (title on)
    (origin 548 529)
    (extent 319 77)
    (widget 0 icon
     (title off)
     (origin 651 547)
     (extent 114 39)
     (format button)
    )
   )
   (widget 3 detail
    (title on)
    (origin 45 561)
    (extent 219 96)
    (bufferSize 256)
   )
   (widget 4 detail
    (title on)
    (origin 302 562)
    (extent 223 97)
    (bufferSize 256)
   )
  )
  (detail
   (origin 0 62)
   (extent 984 657)
   (configuration
    (connect D1:0 D2:0
     (Point 150 176)
     (Point 150 233)
    )
    (connect D1:1 D3:1
     (Point 208 160)
     (Point 278 160)
    )
    (connect D2:1 D4:1
     (Point 208 250)
     (Point 230 250)
     (Point 230 404)
     (Point 276 404)
    )
    (connect D7:0 D6:0
     (Point 150 356)
     (Point 150 417)
    )
    (connect D2:0 D7:0
     (Point 150 266)
     (Point 150 324)
    )
   )
   (stackingOrder 4 6 1 2 3 0 5 7)
  )
  (active panel)
  (active panel)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
