#! /usr/lib/veetest/veetest -r
(revision "B.00.00")
(date "Mon 26/Oct/1992")
(component 0 "ROOTCONTEXT"
 (name "Accessing Environment Variables")
 (interface
 )
 (implementation
  (locked no)
  (trigMode deg)
  (nextID 7)
  (component 0 "LITERALCONSTANT"
   (name "Enter Env. Var.")
   (description 7 4
    Enter one of your environment variables here,
    or perhaps try one that doesn't exist.
    
    This is one way your programs can examine some
    environment variables and make program decisions
    based on their value.
    
   )
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Text")
     (lock name constraints)
    )
   )
   (implementation
    (component value Text
     (name "Enter Env. Var.")
     (datum "PATH")
    )
    (component autoTrigger on)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Text
     (name "CString")
     (datum "")
    )
   )
   (views
    (icon
     (extent 145 0)
    )
    (detail
     (origin 31 276)
     (extent 219 28)
    )
    (active detail)
   )
  )
  (component 1 "NOTE"
   (name "TO RUN:")
   (interface
   )
   (implementation
    (component text 4 5
          Enter the name of one                |   If the Exit Code
     <--  of your shell environ.               |   returns 1, then the
          variables and hit                    |   variable could not
          Return.                              v   be found.  
    )
   )
   (views
    (icon
     (extent 78 0)
    )
    (detail
     (origin 302 248)
     (extent 596 85)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 2 "NOTE"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 4 5
     This example is provided as an
     illustration "as is", and Hewlett-Packard
     Company makes no warranty of any kind
     with regard to this example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 492 109)
     (extent 397 82)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 3 "TEXTDISPLAY"
   (name "Variable value:")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 145 0)
    )
    (detail
     (origin 34 621)
     (extent 873 38)
    )
    (active detail)
   )
  )
  (component 4 "TEXTDISPLAY"
   (name "Exit Code")
   (description 7 4
    A return of 0 means the variable was found.  If
    it has a value, that text is returned in the value
    output pin.  If it is defined without a value,
    the output is a nil container.
    
    If the requested variable can not be located, the
    Error Code exit value is 1.
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 110 0)
    )
    (detail
     (origin 670 403)
     (extent 201 35)
    )
    (active detail)
   )
  )
  (component 5 "SHELLESCAPE"
   (name "Get Environment Variable")
   (description 54 4
    Use this device to retrieve the contents of an
    exported shell variable.  Input is a text string
    with the name of the variable to examine, such as
    "HOME".  Output value is a text string with the
    contents of the variable; an empty (nil) string is
    returned if the variable is defined but has no
    value.  The Exit Code is 0 if the named variable
    is defined, and 1 if not defined.
    
    HOW IT WORKS:
    
    The Execute Program device is used to run a copy of
    /bin/sh, using the -s option to indicate shell
    commands should be read from stdin rather than a
    script file.  The WRITE TEXT transactions in the
    escape are sent to the stdin of sh, where they
    are interpreted as if read from a file.  The READ
    TEXT transaction obtains data from the stdout of
    the sh.  The stderr of the sh is not captured
    and any error messages will be written to stderr.
    
    The following shell script is constructed from
    the WRITE transactions, where "var" is the text
    string:
    
         echo $var
         [ "$var" ] && exit 1
    
    The WRITE TEXT "echo $",var EOL transaction asks
    the shell to echo the contents of the environment
    variable constructed by prepending a $ to the text
    name supplied by the user on the var input.  The
    shell responds with the contents of the string,
    if any, followed by a newline.  (The newline from
    the echo is important, since it marks the end of
    the echoed string.)
    
    The READ TEXT into the value output pin uses the
    TOKEN read mode to construct the output token from
    all characters EXCLUDING the "\n" newline.  A text
    string read mode, since it expects at least one
    non-white-space character, would never be complete
    if the variable had a nil value.  The TOKEN read
    uses all characters up to the \n, allowing a nil
    output to properly be read.  Note:  the next char
    to be read would be the \n, so a READ TEXT null
    CHAR would be needed to position the read pointer
    at the start of the next input line.
    
    The final WRITE TEXT transaction is used to run a
    sh test "[ "$var" ]" to see if the variable was
    defined.  If not, the ksh exits with 1 as the Exit
    code.  Note the use of the \" (quoted ") to imbed
    the quotes around the $var in the test.
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "var")
     (tag "var")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Exit code")
     (lock name constraints)
    )
    (output 2
     (type data)
     (name "value")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (attr iopath pipe read "pipe"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (attr iopath pipe write "pipe"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (procedure
      WRITE TEXT "echo $",var EOL
      READ TEXT value TOKEN EXCLUDE:"\n"
      WRITE TEXT "[ \"$",var,"\" ] || exit 1" EOL
    )
    (component shell "none")
    (component command "/bin/sh -s")
    (component deathWait "Yes")
   )
   (views
    (icon
     (origin 197 438)
     (extent 226 25)
    )
    (detail
     (origin 79 391)
     (extent 463 138)
    )
    (terminals on)
    (active detail)
   )
  )
  (component 6 "CONTEXT"
   (name "Press For")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (locked no)
    (trigMode deg)
    (nextID 3)
    (component 0 "IFTHENELSE"
     (name "!= 0")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a!=0")
     )
     (views
      (icon
       (origin 365 350)
       (extent 46 25)
      )
      (detail
       (origin 209 308)
       (extent 73 64)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "TOGGLE"
     (name "Info About")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Reset")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Info About")
       (values range 0 1)
       (datum 0)
      )
      (component autoTrigger on)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (name "LongInt")
       (datum 0)
      )
     )
     (views
      (icon
       (origin 201 343)
       (extent 114 39)
       (format button)
      )
      (detail
       (origin 320 203)
       (extent 42 54)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "CONTEXT"
     (name "Info About This Example")
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (locked no)
      (trigMode deg)
      (nextID 2)
      (component 0 "NOTE"
       (name "NotePad")
       (description 2 8
        This notepad is displayed as a Show on Execute
        panel to present the information to the reader.
       )
       (interface
       )
       (implementation
        (component text 72 9
         PURPOSE:  Illustrate using Execute Program to access your shell Environment Variables.
                   (The getenv device is supplied as a library device in the Merge menu.)
         
         USER INPUT REQUIRED: Enter name of an environment variable to be displayed.
         
         EXPLANATION:  A simple example using the Execute Program device to process the WRITE 
                   transactions as an input shell script to be executed.  The benefit is that 
                   instead of requiring a separate file for the shell script, it is created 
                   dynamically each time the shell is invoked.  
         
                   One reason that the dynamically constructed shell script is useful is the
                   ease in which variables on the input data pins can be interspersed with
                   the hardcoded commands.  In the example, the Text string provided on the
                   "var" input pin is used in the first transaction to construct the shell
                   command "echo $var".  
         
                   One important caveat is needed when reading data generated by the script.
                   If, for some reason, the shell does not supply sufficient data to satisfy
                   the READ transaction, the read operation will wait indefinitely.  It is
                   always important to insure that "something" is produced by the program so
                   that a read operation can complete.  In this example, it is possible that
                   the "echo $var" command will be an empty line.  If we tried to read this
                   using the "STRING" format, the read would hang forever.  By using the "TOKEN"
                   format and setting the EXCLUDE characters to "\n" (end of line), we permit
                   the read operation to collect everything before the "\n" into the output
                   variable, thus completing the READ transaction (with an empty string).
         
                   The Show Description selection on the Get Environment Variable device has
                   some additional details.
         
                   HOW IT WORKS:
         
                   Use this device to retrieve the contents of an exported shell variable.
                   Input is a text string with the name of the variable to examine, such as
                   "HOME".  Output value is a text string with the contents of the variable;
                   an empty (nil) string is returned if the variable is defined but has no
                   value.  The Exit Code is 0 if the named variable is defined, and 1 if not
                   defined.
         
                   The Execute Program device is used to run a copy of /bin/sh, using the -s
                   option to indicate shell commands should be read from stdin rather than a
                   script file.  The WRITE TEXT transactions in the escape are sent to the
                   stdin of sh, where they are interpreted as if read from a file.  The READ
                   TEXT transaction obtains data from the stdout of the sh.  The stderr of the
                   shell is not captured and any error messages will be written to stderr.
         
                   The following shell script is constructed from the WRITE transactions,
                   where "var" is the text string passed to the device:
         
                        echo $var
                        [ "$var" ] && exit 1
                   
                   The WRITE TEXT "echo $",var EOL transaction asks the shell to echo the
                   contents of the environment variable constructed by prepending a $ to the
                   text name supplied by the user on the var input.  The shell responds with
                   the contents of the string, if any, followed by a newline.  (The newline 
                   from the echo is important, since it marks the end of the echoed string.)
                   
                   The READ TEXT into the value output pin uses the TOKEN read mode to construct
                   the output token from all characters EXCLUDING the "\n" newline.  A text
                   string read mode, since it expects at least one non-white-space character,
                   would never be complete if the variable had a nil value.  The TOKEN read
                   uses all characters up to the \n, allowing a nil output to properly be read. 
                   Note:  the next char to be read would be the \n, so a READ TEXT null CHAR 
                   would be needed to position the read pointer at the start of the next input
                   line.
                   
                   The final WRITE TEXT transaction is used to run a sh test "[ "$var" ]" to
                   see if the variable was defined.  If not, the ksh exits with 1 as the Exit
                   code.  Note the use of the \" (quoted ") to imbed the quotes around the
                   $var in the test.
         
        )
       )
       (views
        (icon
         (origin 411 408)
         (extent 78 25)
        )
        (detail
         (origin 26 202)
         (extent 848 437)
         (editing disabled)
        )
        (active detail)
       )
      )
      (component 1 "CONFIRM"
       (name "DONE")
       (description 7 8
        This tiny "thread" begins running when the 
        enclosing UserObject is executed.  When the user
        acknowledges the OK/DONE button, there is nothing
        left to execute, so the thread ends.  Since there
        are not other threads running, the User Object
        is completed and will exit, removing the Show on
        Execute pop-up display.
       )
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 421 472)
         (extent 58 37)
        )
        (detail
         (origin 156 253)
         (extent 79 34)
        )
        (terminals on)
        (active icon)
       )
      )
      (configuration
      )
      (ShowOnExecPanel
       (origin 51 0)
       (extent 849 561)
       (panel
        (origin 38 164)
        (extent 845 533)
        (widget 0 detail
         (title off)
         (origin 51 176)
         (extent 816 465)
         (editing enabled)
        )
        (widget 1 icon
         (title off)
         (origin 437 649)
         (extent 58 37)
        )
       )
      )
     )
     (views
      (icon
       (origin 352 418)
       (extent 217 25)
      )
      (detail
       (origin 17 160)
       (extent 866 520)
       (configuration
       )
       (stackingOrder 1 0)
      )
      (active icon)
     )
    )
    (configuration
     (connect D1:1 D0:1)
     (connect D2:0 D1:1)
     (connect D0:1 D2:0)
    )
   )
   (views
    (icon
     (origin 465 638)
     (extent 110 25)
    )
    (panel
     (origin 22 109)
     (extent 317 82)
     (widget 1 icon
      (title off)
      (origin 124 122)
      (extent 114 39)
      (format button)
     )
    )
    (detail
     (origin 4 115)
     (extent 912 591)
     (configuration
      (connect D1:1 D0:1
       (Point 317 362)
       (Point 362 362)
      )
      (connect D2:0 D1:1
       (Point 460 445)
       (Point 460 460)
       (Point 180 460)
       (Point 180 362)
       (Point 198 362)
      )
      (connect D0:1 D2:0
       (Point 413 352)
       (Point 460 352)
       (Point 460 415)
      )
     )
     (stackingOrder 0 1 2)
    )
    (active panel)
    (active panel)
   )
  )
  (configuration
   (connect D5:2 D3:1)
   (connect D5:1 D4:1)
   (connect D0:1 D5:1)
  )
 )
 (views
  (detail
   (origin 0 62)
   (extent 931 609)
   (configuration
    (connect D5:2 D3:1
     (Point 644 500)
     (Point 660 500)
     (Point 660 550)
     (Point 10 550)
     (Point 10 640)
     (Point 31 640)
    )
    (connect D5:1 D4:1
     (Point 644 420)
     (Point 667 420)
    )
    (connect D0:1 D5:1
     (Point 252 290)
     (Point 270 290)
     (Point 270 330)
     (Point 20 330)
     (Point 20 460)
     (Point 36 460)
    )
   )
   (stackingOrder 0 1 2 3 4 5 6)
  )
  (active detail)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
