#! /usr/lib/veetest/veetest -r
(revision "A.00.00")
(date "Thu 11/Apr/1991")
(component 0 "Context"
 (name "Pop up panel Example 2")
 (interface
 )
 (implementation
  (trigMode deg)
  (locked no)
  (component 0 "Junction"
   (name "JCT")
   (interface
    (input 1
     (type data)
     (name "A")
     (lock name constraints)
     (optional yes)
    )
    (input 2
     (type data)
     (name "B")
     (lock name constraints)
     (optional yes)
    )
    (output 1
     (type data)
     (name "Data")
     (lock name constraints)
    )
   )
   (implementation
   )
   (views
    (icon
     (origin 510 316)
     (extent 41 29)
    )
    (detail
     (origin 209 355)
     (extent 42 86)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 1 "ForCount"
   (name "100 iterations")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component count 100)
   )
   (views
    (icon
     (origin 22 258)
     (extent 136 64)
     (iconImage loop)
    )
    (detail
     (origin 195 113)
     (extent 210 34)
    )
    (active icon)
   )
  )
  (component 2 "Start"
   (name "Start")
   (interface
    (sequence out)
   )
   (implementation
   )
   (views
    (icon
     (origin 56 191)
     (extent 69 39)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 3 "Constant"
   (name "initial velocity")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "initial velocity")
     (datum 20)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
   )
   (views
    (icon
     (origin 333 296)
     (extent 154 29)
    )
    (detail
     (origin 286 276)
     (extent 228 28)
    )
    (active icon)
   )
  )
  (component 4 "Constant"
   (name "drag")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "drag")
     (datum 0.02)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
   )
   (views
    (icon
     (origin 77 338)
     (extent 46 25)
    )
    (detail
     (origin 28 355)
     (extent 165 30)
    )
    (active icon)
   )
  )
  (component 5 "Constant"
   (name "time/iteration")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "time/iteration")
     (datum 0.1)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
   )
   (views
    (icon
     (origin 6 376)
     (extent 149 29)
    )
    (detail
     (origin 1 396)
     (extent 219 28)
    )
    (active icon)
   )
  )
  (component 6 "Formula"
   (name "compute next Velocity")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "drag")
     (optional yes)
    )
    (input 2
     (type data)
     (name "delta")
     (optional yes)
    )
    (input 3
     (type data)
     (name "v")
     (optional yes)
    )
    (output 1
     (type data)
     (name " ")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "v-(9.8+drag*v^2*signof(v))*delta")
   )
   (views
    (icon
     (origin 209 358)
     (extent 203 45)
    )
    (detail
     (origin 199 310)
     (extent 312 140)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 7 "SlidingWindow"
   (name "Collect Velocity")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
     (tag "Data")
     (requires
      (shape "Scalar")
     )
    )
    (output 1
     (type data)
     (name "Array")
     (tag "Array")
     (lock constraints)
    )
   )
   (implementation
    (component vecSize 100)
    (component triggerSize 100)
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (origin 43 466)
     (extent 154 29)
    )
    (detail
     (origin 51 452)
     (extent 248 56)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 8 "EnumConstant"
   (name "Select Values to View")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Enum
     (name "Select Values to View")
     (values
      ( "Show Acceleration Values" 0)
      ( "Show Velocity Values" 1)
      ( "Show Distance Values" 2)
     )
     (datum "Show Acceleration Values")
    )
    (component autoTrigger on)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Enum
     (shared yes)
     (datum "Show Acceleration Values")
    )
   )
   (views
    (icon
     (extent 199 0)
    )
    (detail
     (origin 22 589)
     (extent 277 82)
     (format buttons)
    )
    (active detail)
   )
  )
  (component 9 "IfThenElse"
   (name "If/Then")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Then")
     (lock name constraints)
    )
    (output 2
     (type data)
     (name "Else If")
     (lock name constraints)
    )
    (output 3
     (type data)
     (name "Else")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr "ordinal(A)==0")
    (component expr "ordinal(A)==1")
   )
   (views
    (icon
     (origin 91 598)
     (extent 78 25)
    )
    (detail
     (origin 363 588)
     (extent 154 104)
    )
    (terminals on)
    (active detail)
   )
  )
  (component 10 "Formula"
   (name "compute accel")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "velocity")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "deriv(velocity,1)")
   )
   (views
    (icon
     (origin 407 438)
     (extent 127 25)
    )
    (detail
     (origin 382 400)
     (extent 196 60)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 11 "Formula"
   (name "compute distance")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "velocity")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "integral(velocity)")
   )
   (views
    (icon
     (origin 393 488)
     (extent 154 25)
    )
    (detail
     (origin 382 450)
     (extent 196 60)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 12 "Note"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 4 5
     This example is provided as an
     illustration "as is", and Hewlett-Packard
     Company makes no warranty of any kind
     with regard to this example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 569 108)
     (extent 382 84)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 13 "Context"
   (name "Acceleration Values")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
     (optional yes)
    )
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "Confirm"
     (name " OK ")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Go")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 901 592)
       (extent 58 37)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "TextDisplay"
     (name "Acceleration")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
      )
     )
     (implementation
      (component clearAtPrerun 1)
      (component clearAtActivate 1)
     )
     (views
      (icon
       (extent 118 0)
      )
      (detail
       (origin 674 497)
       (extent 192 207)
      )
      (active detail)
     )
    )
    (configuration
     (connect I1:1 D1:1)
    )
    (ShowOnExecPanel
     (origin 349 104)
     (extent 247 347)
     (panel
      (origin 719 446)
      (extent 243 309)
      (widget 0 icon
       (title off)
       (origin 812 705)
       (extent 58 37)
      )
      (widget 1 detail
       (title off)
       (origin 730 453)
       (extent 222 236)
      )
     )
    )
   )
   (views
    (icon
     (origin 720 538)
     (extent 181 25)
    )
    (detail
     (origin 637 432)
     (extent 386 317)
     (configuration
      (connect I1:1 D1:1
       (Point 639 600)
       (Point 660 600)
       (Point 660 600)
       (Point 671 600)
      )
     )
    )
    (terminals on)
    (active icon)
   )
  )
  (component 14 "Context"
   (name "Velocity Values")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
     (optional yes)
    )
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "Confirm"
     (name " OK ")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Go")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 887 672)
       (extent 58 37)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "TextDisplay"
     (name "Velocity")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
      )
     )
     (implementation
      (component clearAtPrerun 1)
      (component clearAtActivate 1)
     )
     (views
      (icon
       (extent 110 0)
      )
      (detail
       (origin 671 545)
       (extent 199 230)
      )
      (active detail)
     )
    )
    (configuration
     (connect I1:1 D1:1)
    )
    (ShowOnExecPanel
     (origin 362 129)
     (extent 221 349)
     (panel
      (origin 722 505)
      (extent 217 311)
      (widget 0 icon
       (title off)
       (origin 796 769)
       (extent 58 37)
      )
      (widget 1 detail
       (title off)
       (origin 727 511)
       (extent 208 241)
      )
     )
    )
   )
   (views
    (icon
     (origin 728 588)
     (extent 145 25)
    )
    (detail
     (origin 627 492)
     (extent 386 317)
     (configuration
      (connect I1:1 D1:1
       (Point 629 660)
       (Point 668 660)
      )
     )
    )
    (terminals on)
    (active icon)
   )
  )
  (component 15 "Context"
   (name "Distance Values")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
     (optional yes)
    )
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "Confirm"
     (name " OK ")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Go")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 907 682)
       (extent 58 37)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "TextDisplay"
     (name "Distance")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
      )
     )
     (implementation
      (component clearAtPrerun 1)
      (component clearAtActivate 1)
     )
     (views
      (icon
       (extent 110 0)
      )
      (detail
       (origin 670 565)
       (extent 200 231)
      )
      (active detail)
     )
    )
    (configuration
     (connect I1:1 D1:1)
    )
    (ShowOnExecPanel
     (origin 368 116)
     (extent 219 351)
     (panel
      (origin 713 534)
      (extent 215 313)
      (widget 0 icon
       (title off)
       (origin 786 799)
       (extent 58 37)
      )
      (widget 1 detail
       (title off)
       (origin 718 539)
       (extent 201 246)
      )
     )
    )
   )
   (views
    (icon
     (origin 728 648)
     (extent 145 25)
    )
    (detail
     (origin 647 502)
     (extent 386 317)
     (configuration
      (connect I1:1 D1:1
       (Point 649 670)
       (Point 667 680)
      )
     )
    )
    (terminals on)
    (active icon)
   )
  )
  (component 16 "Note"
   (name "Overview of \"pop2\" Example")
   (interface
   )
   (implementation
    (component text 24 5
     Purpose:
     To show one way to use the panel view
     on UserObjects to display only the 
     data requested.
     
     User Input Required:
     Press Panel to see the panel view of
     this model. Select the values to view 
     by clicking on a button on the
     "Select Values to View" Enum object.
     
     Click on Start to run the model.
     
     Explanation:
     This model calculates a trajectory
     velocity and then integrates to get
     the acceleration and differentiates
     to get the distance traveled.
     
     By setting the ordinal value of the
     "Enum", you have selected a propagation
     path.  Each path contains a different
     "UserObject" that displays different
     value.
    )
   )
   (views
    (icon
     (extent 244 0)
    )
    (detail
     (origin 170 106)
     (extent 381 149)
     (editing disabled)
    )
    (active detail)
   )
  )
  (configuration
   (connect D3:1 D0:1)
   (connect D6:1 D0:2)
   (connect D2:0 D1:0)
   (connect D1:1 D6:0)
   (connect D4:1 D6:1)
   (connect D5:1 D6:2)
   (connect D0:1 D6:3)
   (connect D0:1 D7:1)
   (connect D8:1 D9:1)
   (connect D7:1 D10:1)
   (connect D7:1 D11:1)
   (connect D9:1 D13:0)
   (connect D10:1 D13:1)
   (connect D9:2 D14:0)
   (connect D7:1 D14:1)
   (connect D9:3 D15:0)
   (connect D11:1 D15:1)
  )
 )
 (views
  (panel
   (origin 0 67)
   (extent 915 597)
   (widget 8 detail
    (title on)
    (origin 51 286)
    (extent 277 82)
    (format buttons)
   )
   (widget 2 icon
    (title off)
    (origin 142 163)
    (extent 69 39)
   )
  )
  (detail
   (origin 0 67)
   (extent 982 648)
   (configuration
    (connect D3:1 D0:1
     (Point 489 310)
     (Point 500 310)
     (Point 500 320)
     (Point 507 320)
    )
    (connect D6:1 D0:2
     (Point 414 380)
     (Point 430 380)
     (Point 430 340)
     (Point 507 340)
    )
    (connect D2:0 D1:0
     (Point 90 232)
     (Point 90 255)
    )
    (connect D1:1 D6:0
     (Point 160 290)
     (Point 310 290)
     (Point 310 355)
    )
    (connect D4:1 D6:1
     (Point 125 350)
     (Point 170 350)
     (Point 170 370)
     (Point 206 370)
    )
    (connect D5:1 D6:2
     (Point 157 390)
     (Point 170 390)
     (Point 170 380)
     (Point 206 380)
    )
    (connect D0:1 D6:3
     (Point 553 330)
     (Point 570 330)
     (Point 570 420)
     (Point 190 420)
     (Point 190 390)
     (Point 206 390)
    )
    (connect D0:1 D7:1
     (Point 553 330)
     (Point 570 330)
     (Point 570 420)
     (Point 20 420)
     (Point 20 480)
     (Point 40 480)
    )
    (connect D8:1 D9:1
     (Point 301 630)
     (Point 310 630)
     (Point 310 640)
     (Point 320 640)
    )
    (connect D7:1 D10:1
     (Point 199 480)
     (Point 220 480)
     (Point 220 500)
     (Point 370 500)
     (Point 370 450)
     (Point 404 450)
    )
    (connect D7:1 D11:1
     (Point 199 480)
     (Point 220 480)
     (Point 220 500)
     (Point 390 500)
    )
    (connect D9:1 D13:0
     (Point 599 610)
     (Point 610 610)
     (Point 610 570)
     (Point 630 570)
     (Point 630 520)
     (Point 810 520)
     (Point 810 535)
    )
    (connect D10:1 D13:1
     (Point 536 450)
     (Point 620 450)
     (Point 620 550)
     (Point 717 550)
    )
    (connect D9:2 D14:0
     (Point 599 640)
     (Point 610 640)
     (Point 610 620)
     (Point 620 620)
     (Point 620 580)
     (Point 800 580)
     (Point 800 585)
    )
    (connect D7:1 D14:1
     (Point 199 480)
     (Point 220 480)
     (Point 220 500)
     (Point 370 500)
     (Point 370 530)
     (Point 610 530)
     (Point 610 560)
     (Point 640 560)
     (Point 640 600)
     (Point 725 600)
    )
    (connect D9:3 D15:0
     (Point 599 670)
     (Point 620 670)
     (Point 620 630)
     (Point 800 630)
     (Point 800 645)
    )
    (connect D11:1 D15:1
     (Point 549 500)
     (Point 920 500)
     (Point 920 690)
     (Point 710 690)
     (Point 710 660)
     (Point 725 660)
    )
   )
  )
  (active detail)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
