#! /usr/lib/veetest/veetest -r
(revision "A.00.01")
(date "Thu 19/Sep/1991")
(component 0 "Context"
 (name "PID Control Example")
 (interface
 )
 (implementation
  (trigMode deg)
  (locked no)
  (component 0 "Formula"
   (name "Select 1st/2nd")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (input 2
     (type data)
     (name "B")
     (optional yes)
    )
    (input 3
     (type data)
     (name "LOAD")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "(ordinal(load) ? b : a)")
   )
   (views
    (icon
     (origin 472 453)
     (extent 136 34)
    )
    (detail
     (origin 540 423)
     (extent 241 154)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 1 "Formula"
   (name "2nd Order Load1")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (input 2
     (type data)
     (name "Zi")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "(A*5)+Zi")
   )
   (views
    (icon
     (origin 278 418)
     (extent 145 25)
    )
    (detail
     (origin 413 333)
     (extent 124 154)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 2 "Formula"
   (name "2nd Order Load2")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (input 2
     (type data)
     (name "Zi")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "((A*.52)+Zi)/2")
   )
   (views
    (icon
     (origin 278 468)
     (extent 145 25)
    )
    (detail
     (origin 382 383)
     (extent 187 154)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 3 "RepeatUntilBreak"
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Continuous")
     (lock name constraints)
    )
   )
   (implementation
   )
   (views
    (icon
     (origin 5 168)
     (extent 110 64)
     (iconImage "loop.icon")
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 4 "Formula"
   (name "1st Order Load")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (input 2
     (type data)
     (name "Zi")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "(A*1.7)+Zi")
   )
   (views
    (icon
     (origin 282 368)
     (extent 136 25)
    )
    (detail
     (origin 273 353)
     (extent 124 154)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 5 "Context"
   (name "Generate Input")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (output 1
     (type data)
     (name "X")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "Slider"
     (name "Setpt")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "MaxValue")
       (tag "MaxValue")
       (requires
        (datatype Real)
        (shape "Scalar")
       )
       (lock constraints)
       (optional yes)
      )
      (input 2
       (type control)
       (name "MinValue")
       (tag "MinValue")
       (requires
        (datatype Real)
        (shape "Scalar")
       )
       (lock constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Real
       (name "Setpt")
       (values range 0 1)
       (datum 0.907)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Real
       (datum 0)
      )
      (component detents 0.001)
     )
     (views
      (icon
       (extent 78 0)
      )
      (detail
       (origin 41 170)
       (extent 109 141)
      )
      (active detail)
     )
    )
    (component 1 "EnumConstant"
     (name "SETPT MODE")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Enum
       (name "SETPT MODE")
       (values
        ( "CONTROL TO SETPOINT" 0)
        ( "ALT. SETPOINT/LOWPT" 1)
       )
       (datum "ALT. SETPOINT/LOWPT")
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Enum
       (shared yes)
       (datum "CONTROL TO SETPOINT")
      )
     )
     (views
      (icon
       (origin 42 528)
       (extent 110 25)
      )
      (detail
       (origin 224 470)
       (extent 232 60)
       (format buttons)
      )
      (active detail)
     )
    )
    (component 2 "Slider"
     (name "Lowpt")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "MaxValue")
       (tag "MaxValue")
       (requires
        (datatype Real)
        (shape "Scalar")
       )
       (lock constraints)
       (optional yes)
      )
      (input 2
       (type control)
       (name "MinValue")
       (tag "MinValue")
       (requires
        (datatype Real)
        (shape "Scalar")
       )
       (lock constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Real
       (name "Lowpt")
       (values range 0 1)
       (datum 0.148)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Real
       (datum 0)
      )
      (component detents 0.001)
     )
     (views
      (icon
       (origin 181 268)
       (extent 78 25)
      )
      (detail
       (origin 46 412)
       (extent 129 157)
      )
      (active detail)
     )
    )
    (component 3 "Formula"
     (name "Operate/Tune 20 Lo, 20 Hi")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (input 2
       (type data)
       (name "B")
       (optional yes)
      )
      (input 3
       (type data)
       (name "C")
       (optional yes)
      )
      (input 4
       (type data)
       (name "TUNE")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "((a MOD 40)<20 AND ordinal(TUNE) ? c : b)")
     )
     (views
      (icon
       (origin 223 338)
       (extent 235 45)
      )
      (detail
       (origin 129 258)
       (extent 403 204)
      )
      (terminals on)
      (active icon)
     )
    )
    (configuration
     (connect I1:1 D3:1)
     (connect D0:1 D3:2)
     (connect D2:1 D3:3)
     (connect D1:1 D3:4)
     (connect D3:1 O1:1)
    )
   )
   (views
    (icon
     (origin 282 188)
     (extent 136 25)
    )
    (panel
     (origin 206 118)
     (extent 289 304)
     (widget 1 detail
      (title off)
      (origin 226 127)
      (extent 245 58)
      (format buttons)
     )
     (widget 0 detail
      (title on)
      (origin 227 230)
      (extent 108 180)
     )
     (widget 2 detail
      (title on)
      (origin 366 232)
      (extent 104 178)
     )
    )
    (detail
     (origin 66 115)
     (extent 548 470)
     (configuration
      (connect I1:1 D3:1
       (Point 68 360)
       (Point 120 360)
       (Point 120 340)
       (Point 220 340)
      )
      (connect D0:1 D3:2
       (Point 152 240)
       (Point 170 240)
       (Point 170 350)
       (Point 220 350)
      )
      (connect D2:1 D3:3
       (Point 177 490)
       (Point 200 490)
       (Point 200 360)
       (Point 220 360)
      )
      (connect D1:1 D3:4
       (Point 458 500)
       (Point 480 500)
       (Point 480 420)
       (Point 210 420)
       (Point 210 370)
       (Point 220 370)
      )
      (connect D3:1 O1:1
       (Point 460 360)
       (Point 595 360)
       (Point 595 360)
       (Point 611 360)
      )
     )
    )
    (active icon)
   )
  )
  (component 6 "YPlot"
   (name "SETPOINT vs MEASURED LOAD")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "SETPT")
     (lock constraints)
    )
    (input 2
     (type data)
     (name "ACTUAL")
     (lock constraints)
     (optional yes)
    )
    (input 3
     (type control)
     (name "Clear")
     (lock name constraints)
     (optional yes)
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 0)
    (component tracePin 1)
    (component tracePin 2)
    (component graphMode strip)
   )
   (views
    (icon
     (origin 683 438)
     (extent 235 64)
     (iconImage "display.icon")
    )
    (detail
     (origin 443 517)
     (extent 495 186)
     (displayMode annotGraph)
     (graphType cartesian)
     (gridType axis)
     (scale 0
      (name "LOAD")
      (domainName "    ")
      (pen 9)
      (show 1)
      (range -0.5 1.5 3 linear)
     )
     (domain 0 99.99999999999977 4 linear)
     (trace 0 onScale 0
      (name "SETPT")
      (pen 4)
      (lineType 1)
      (pointType 0)
     )
     (trace 1 onScale 0
      (name "ACTUAL")
      (pen 7)
      (lineType 1)
      (pointType 0)
     )
     (stepSize 1)
     (trackingEnabled 1)
    )
    (active icon)
   )
  )
  (component 7 "EnumConstant"
   (name "SIMULATED LOAD")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Enum
     (name "SIMULATED LOAD")
     (values
      ( "1st Order" 0)
      ( "2nd Order" 1)
     )
     (datum "2nd Order")
    )
    (component autoTrigger on)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Enum
     (shared yes)
     (datum "2nd Order")
    )
   )
   (views
    (icon
     (origin 282 528)
     (extent 136 25)
    )
    (detail
     (origin 245 617)
     (extent 210 26)
     (format cyclic)
    )
    (active icon)
   )
  )
  (component 8 "Note"
   (name "To Operate")
   (interface
   )
   (implementation
    (component text 2 5
     Press "Run" to operate, or
     Click "Info About" for help.
    )
   )
   (views
    (icon
     (origin 705 328)
     (extent 110 64)
     (iconImage "notepad.icon")
    )
    (detail
     (origin 647 362)
     (extent 286 36)
     (editing enabled)
    )
    (active icon)
   )
  )
  (component 9 "Note"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 2 5
     This example is provided as an illustration "as is", and Hewlett-Packard
     Company makes no warranty of any kind with regard to this example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 176 121)
     (extent 708 38)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 10 "Start"
   (interface
    (sequence out)
   )
   (implementation
   )
   (views
    (icon
     (origin 27 102)
     (extent 67 37)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 11 "ForCount"
   (name "2000")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component count 2000)
   )
   (views
    (icon
     (origin 131 218)
     (extent 78 64)
     (iconImage "loop.icon")
    )
    (detail
     (origin 95 283)
     (extent 170 34)
    )
    (active icon)
   )
  )
  (component 12 "Context"
   (name "PID Controller")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Setpt")
     (optional yes)
    )
    (input 2
     (type data)
     (name "Actual")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Output")
     (lock constraints)
     (optional yes)
    )
    (output 2
     (type data)
     (name "Locked")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "Slider"
     (name "Ki")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "MaxValue")
       (tag "MaxValue")
       (requires
        (datatype Real)
        (shape "Scalar")
       )
       (lock constraints)
       (optional yes)
      )
      (input 2
       (type control)
       (name "MinValue")
       (tag "MinValue")
       (requires
        (datatype Real)
        (shape "Scalar")
       )
       (lock constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Real
       (name "Ki")
       (values range 0 1)
       (datum 0.169)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Real
       (datum 0.226)
      )
      (component detents 0.001)
     )
     (views
      (icon
       (extent 46 0)
      )
      (detail
       (origin 218 279)
       (extent 85 143)
      )
      (active detail)
     )
    )
    (component 1 "Slider"
     (name "Kd")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "MaxValue")
       (tag "MaxValue")
       (requires
        (datatype Real)
        (shape "Scalar")
       )
       (lock constraints)
       (optional yes)
      )
      (input 2
       (type control)
       (name "MinValue")
       (tag "MinValue")
       (requires
        (datatype Real)
        (shape "Scalar")
       )
       (lock constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Real
       (name "Kd")
       (values range 0 1)
       (datum 0.37)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Real
       (datum 0.376)
      )
      (component detents 0.001)
     )
     (views
      (icon
       (extent 46 0)
      )
      (detail
       (origin 330 278)
       (extent 80 144)
      )
      (active detail)
     )
    )
    (component 2 "Slider"
     (name "Kp")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "MaxValue")
       (tag "MaxValue")
       (requires
        (datatype Real)
        (shape "Scalar")
       )
       (lock constraints)
       (optional yes)
      )
      (input 2
       (type control)
       (name "MinValue")
       (tag "MinValue")
       (requires
        (datatype Real)
        (shape "Scalar")
       )
       (lock constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Real
       (name "Kp")
       (values range 0 1)
       (datum 0.408)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Real
       (datum 0.434)
      )
      (component detents 0.001)
     )
     (views
      (icon
       (extent 46 0)
      )
      (detail
       (origin 108 279)
       (extent 84 142)
      )
      (active detail)
     )
    )
    (component 3 "Formula"
     (name " - ")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "X")
       (lock name constraints)
      )
      (input 2
       (type data)
       (name "Y")
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked yes)
      (component expr 1 "X-Y")
     )
     (views
      (icon
       (origin 107 478)
       (extent 46 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 4 "TextDisplay"
     (name "lock")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
      )
     )
     (implementation
      (component clearAtPrerun 1)
      (component clearAtActivate 0)
     )
     (views
      (icon
       (origin 567 528)
       (extent 46 25)
      )
      (detail
       (origin 667 403)
       (extent 126 34)
      )
      (active icon)
     )
    )
    (component 5 "ShiftRegister"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
      )
      (output 1
       (type data)
       (name "Current")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "1 Prev")
       (lock name constraints)
       (optional yes)
      )
     )
     (implementation
      (component clearAtPrerun 1)
      (component clearAtActivate 0)
     )
     (views
      (icon
       (origin 182 528)
       (extent 136 25)
      )
      (detail
       (origin 235 345)
       (extent 80 70)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 6 "Formula"
     (name " - ")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "X")
       (lock name constraints)
      )
      (input 2
       (type data)
       (name "Y")
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked yes)
      (component expr 1 "X-Y")
     )
     (views
      (icon
       (origin 377 488)
       (extent 46 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 7 "Formula"
     (name "Kp*P+Ki*I+Kd*D")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Kp")
       (optional yes)
      )
      (input 2
       (type data)
       (name "Ki")
       (optional yes)
      )
      (input 3
       (type data)
       (name "Kd")
       (optional yes)
      )
      (input 4
       (type data)
       (name "P")
       (optional yes)
      )
      (input 5
       (type data)
       (name "I")
       (optional yes)
      )
      (input 6
       (type data)
       (name "D")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "(Kp*P+Ki*I+Kd*D)")
     )
     (views
      (icon
       (origin 502 288)
       (extent 136 65)
      )
      (detail
       (origin 506 112)
       (extent 178 256)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 8 "Meter"
     (name "Error")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
       (requires
        (datatype Real)
        (shape "Scalar")
       )
       (lock name constraints)
      )
      (input 2
       (type control)
       (name "MinValue")
       (tag "MinValue")
       (lock constraints)
       (optional yes)
      )
      (input 3
       (type control)
       (name "MaxValue")
       (tag "MaxValue")
       (lock constraints)
       (optional yes)
      )
     )
     (implementation
      (component clearAtPrerun 1)
      (component clearAtActivate 0)
      (component range -1 1)
     )
     (views
      (icon
       (origin 491 413)
       (extent 78 34)
      )
      (detail
       (origin 641 178)
       (extent 179 124)
      )
      (active icon)
     )
    )
    (component 9 "Formula"
     (name "sum(a)/64")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "sum(a)/64")
     )
     (views
      (icon
       (origin 325 438)
       (extent 110 25)
      )
      (detail
       (origin 297 301)
       (extent 166 58)
      )
      (active icon)
     )
    )
    (component 10 "SlidingWindow"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Data")
       (tag "Data")
       (requires
        (shape "Scalar")
       )
       (lock constraints)
      )
      (output 1
       (type data)
       (name "Array")
       (tag "Array")
       (lock constraints)
      )
     )
     (implementation
      (component vecSize 64)
      (component triggerSize 1)
      (component clearAtPrerun 1)
      (component clearAtActivate 0)
     )
     (views
      (icon
       (origin 149 438)
       (extent 163 25)
      )
      (detail
       (origin 106 439)
       (extent 248 63)
      )
      (active icon)
     )
    )
    (component 11 "Formula"
     (name "Sense Lock")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (input 2
       (type data)
       (name "B")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "(abs(a)+abs(b)<0.02 ? \"LOCKED\" : \"\")")
     )
     (views
      (icon
       (origin 375 528)
       (extent 110 25)
      )
      (detail
       (origin 247 510)
       (extent 367 60)
      )
      (active icon)
     )
    )
    (configuration
     (connect I1:1 D3:1)
     (connect I2:1 D3:2)
     (connect D11:1 D4:1)
     (connect D3:1 D5:1)
     (connect D5:1 D6:1)
     (connect D5:2 D6:2)
     (connect D2:1 D7:1)
     (connect D0:1 D7:2)
     (connect D1:1 D7:3)
     (connect D3:1 D7:4)
     (connect D9:1 D7:5)
     (connect D6:1 D7:6)
     (connect D3:1 D8:1)
     (connect D10:1 D9:1)
     (connect D3:1 D10:1)
     (connect D5:1 D11:1)
     (connect D5:2 D11:2)
     (connect D7:1 O1:1)
     (connect D11:1 O2:1)
    )
   )
   (views
    (icon
     (origin 275 241)
     (extent 150 59)
    )
    (panel
     (origin 72 291)
     (extent 537 279)
     (widget 2 detail
      (title on)
      (origin 85 336)
      (extent 90 142)
     )
     (widget 0 detail
      (title on)
      (origin 186 337)
      (extent 90 143)
     )
     (widget 1 detail
      (title on)
      (origin 288 338)
      (extent 90 144)
     )
     (widget 8 detail
      (title on)
      (origin 403 340)
      (extent 179 124)
     )
     (widget 4 detail
      (title off)
      (origin 431 480)
      (extent 126 34)
     )
    )
    (detail
     (origin 77 256)
     (extent 587 329)
     (configuration
      (connect I1:1 D3:1
       (Point 79 340)
       (Point 90 340)
       (Point 90 480)
       (Point 104 480)
      )
      (connect I2:1 D3:2
       (Point 79 520)
       (Point 90 520)
       (Point 90 500)
       (Point 104 500)
      )
      (connect D11:1 D4:1
       (Point 487 540)
       (Point 564 540)
      )
      (connect D3:1 D5:1
       (Point 155 490)
       (Point 170 490)
       (Point 170 540)
       (Point 179 540)
      )
      (connect D5:1 D6:1
       (Point 320 530)
       (Point 330 530)
       (Point 330 490)
       (Point 374 490)
      )
      (connect D5:2 D6:2
       (Point 320 550)
       (Point 340 550)
       (Point 340 510)
       (Point 374 510)
      )
      (connect D2:1 D7:1
       (Point 194 350)
       (Point 200 350)
       (Point 200 300)
       (Point 430 300)
       (Point 430 290)
       (Point 499 290)
      )
      (connect D0:1 D7:2
       (Point 305 350)
       (Point 320 350)
       (Point 320 430)
       (Point 420 430)
       (Point 420 420)
       (Point 440 420)
       (Point 440 300)
       (Point 499 300)
      )
      (connect D1:1 D7:3
       (Point 412 350)
       (Point 430 350)
       (Point 430 310)
       (Point 499 310)
      )
      (connect D3:1 D7:4
       (Point 155 490)
       (Point 170 490)
       (Point 170 480)
       (Point 470 480)
       (Point 470 320)
       (Point 499 320)
      )
      (connect D9:1 D7:5
       (Point 437 450)
       (Point 450 450)
       (Point 450 330)
       (Point 499 330)
      )
      (connect D6:1 D7:6
       (Point 425 500)
       (Point 460 500)
       (Point 460 340)
       (Point 499 340)
      )
      (connect D3:1 D8:1
       (Point 155 490)
       (Point 170 490)
       (Point 170 480)
       (Point 470 480)
       (Point 470 420)
       (Point 488 420)
      )
      (connect D10:1 D9:1
       (Point 314 450)
       (Point 322 450)
      )
      (connect D3:1 D10:1
       (Point 155 490)
       (Point 170 490)
       (Point 170 470)
       (Point 140 470)
       (Point 140 450)
       (Point 146 450)
      )
      (connect D5:1 D11:1
       (Point 320 530)
       (Point 372 530)
      )
      (connect D5:2 D11:2
       (Point 320 550)
       (Point 372 550)
      )
      (connect D7:1 O1:1
       (Point 640 320)
       (Point 650 320)
       (Point 650 340)
       (Point 661 340)
      )
      (connect D11:1 O2:1
       (Point 487 540)
       (Point 550 540)
       (Point 550 510)
       (Point 630 510)
       (Point 630 520)
       (Point 661 520)
      )
     )
    )
    (terminals on)
    (active icon)
   )
  )
  (component 13 "Context"
   (name "Press For")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "IfThenElse"
     (name "!= 0")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a!=0")
     )
     (views
      (icon
       (origin 395 350)
       (extent 46 25)
      )
      (detail
       (origin 209 308)
       (extent 73 64)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "Toggle"
     (name "Info About")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Reset")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Info About")
       (values range 0 1)
       (datum 0)
      )
      (component autoTrigger on)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (datum 0)
      )
     )
     (views
      (icon
       (origin 231 343)
       (extent 114 39)
       (format button)
      )
      (detail
       (origin 320 203)
       (extent 42 54)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "RepeatUntilBreak"
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Continuous")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 155 268)
       (extent 110 64)
       (iconImage "loop.icon")
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 3 "Context"
     (name "Info About")
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Confirm"
       (name "DONE")
       (description 7 8
        This tiny "thread" begins running when the 
        enclosing UserObject is executed.  When the user
        acknowledges the OK/DONE button, there is nothing
        left to execute, so the thread ends.  Since there
        are not other threads running, the User Object
        is completed and will exit, removing the Show on
        Execute pop-up display.
       )
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 421 482)
         (extent 58 37)
        )
        (detail
         (origin 156 253)
         (extent 79 34)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "Note"
       (name "NotePad")
       (description 2 8
        This notepad is displayed as a Show on Execute
        panel to present the information to the reader.
       )
       (interface
       )
       (implementation
        (component text 85 9
         PURPOSE:      A simple Proportional-Integral-Derivative controller for closed-loop
                       process control.
         
         USER INPUT REQUIRED: After pressing RUN, you can operate the PID simulator in two modes:
                       1) CONTROL TO SETPOINT allows the Setpoint slider be moved to change the
                       operating point of the process, or 2) ALT. SETPOINTT/LOWPT alternates the
                       control point between the Setpoint and the LOW PT slider values, allowing
                       you to tune the three PID control parameters (Kp, Ki, Kd) for best loop
                       operation.
         
         EXPLANATION:  PID control is useful in systems that sample an output, compare the sample
                       to a desired result, and take corrective action to force the controlled
                       element closer to the desired result (setpoint).  In a well-tuned PID
                       control loop, the "load" reaches the desired value rapidly with minimal
                       over and undershoot. 
         
                       The words Proportional, Integral, and Derivative describe the correction
                       algorithms based on the error, the integrated error over time, and the
                       rate of change in the error term.  The general form of a PID control is:
         
                            OUTPUT = Kp * Error + Ki * sum(Error) + Kd * d(Error)/dt.  
         
                       The Kp, Ki, and Kd terms are coefficients that tune a PID loop to a
                       particular load system.  In this example, you can select either a first-
                       order load (similar to an R-C network) or a second-order load (2 cascaded
                       R-C networks).  The goal is to set Kp, Ki, and Kd to minimize the over
                       and undershoot of the simulated load, while minimizing the settling time
                       to reach stable (Locked) control.  (The values provided when the model is
                       first loaded are approximately correct for the second-order load; try to
                       tune the loop for a first order load, then try to retune the second order
                       load again.)  
         
                       To begin tuning a PID loop, set all three constants to 0.  To simulate
                       sudden setpoint changes, you can use the ALT. SETPT/LOWPT operating mode;
                       this alternates between the Setpoint value and the Lowpt value, allowing
                       you to concentrate on tuning rather than continually readjusting a setpt.
         
                       The first parameter to be adjusted is the Proportional constant, so named
                       because it's corrective action is proportional to the Error term derived
                       by subtracting the current load value from the Setpoint value.  Because
                       this coefficient operates only on the latest value, it is used to provide
                       fast correction.  When too small, the load approaches the setpoint too
                       slowly; when too large, the load overshoots the setpoint and reaches the
                       setpoint with damped oscillation. 
         
                       The second parameter to be adjusted is the Derivative constant, so named
                       because the amount of correction applied depends on the rate that the
                       error term is changing.   By adding appropriate Kd correction, the over-
                       shoot and oscillation caused by Kp can be cancelled.  Note that this
                       factor becomes unstable quickly if too large, resulting in undamped
                       oscillation itself.  One might think of this as "use sparingly and only
                       as needed".
         
                       The final parameter to be adjusted is the Integral constant, so named
                       because it represents the integrated error over a reasonable time period.
                       Because no setting of Kp and Kd can totally prevent over and undershoot,
                       the integral correction can be used to minimize the accumulated error at
                       the expense of settling time.  It is generally good to keep settling time
                       as short as possible, while also preventing excessive long-term errors
                       arising from system losses and instrument drift.
         
         
         IMPLEMENTATION:
         
                       The PID controller is implemented as a User Object that accepts the Setpt
                       and measured load values as inputs, then calculates a corrective Output
                       value based on the Kp, Ki, and Kd parameters.  The Error term is obtained
                       by subtracting the Setpoint and Actual values.  The Integral term is found
                       by summing the last 64 Error values, normalizing by dividing by 64.  The
                       derivative term is computed using the current and previous Error terms
                       with a simple delta error/delta time approximation for Error slope.  
         
                       A formula box implements the Kp, Ki, Kd coefficient multiplication and 
                       output value summing.  An absolute magnitude error monitor senses when
                       the PID loop is within 0.02 of the desired setpoint.
         
         THE SIMULATED LOADS:
         
                       Using techniques from the digitalfilter application example, the first and
                       second order loads were implemented using numeric filtering methods to
                       simulate load response to a corrective input.  With a first order load,
                       oscillation problems are usually the result of excessive Kd correction. 
                       The phase shift of the second order load lends itself to more realistic
                       instability and oscillation, representing a typical real world load.
         
        )
       )
       (views
        (icon
         (origin 410 415)
         (extent 78 25)
        )
        (detail
         (origin 25 209)
         (extent 848 437)
         (editing disabled)
        )
        (active icon)
       )
      )
      (configuration
      )
      (ShowOnExecPanel
       (origin 16 75)
       (extent 849 571)
       (panel
        (origin 68 164)
        (extent 845 533)
        (widget 0 icon
         (title off)
         (origin 467 649)
         (extent 58 37)
        )
        (widget 1 detail
         (title off)
         (origin 76 175)
         (extent 832 463)
         (editing disabled)
        )
       )
      )
     )
     (views
      (icon
       (origin 435 418)
       (extent 110 25)
      )
      (detail
       (origin 17 160)
       (extent 866 520)
       (configuration
       )
      )
      (active icon)
     )
    )
    (configuration
     (connect D1:1 D0:1)
     (connect D2:1 D1:0)
     (connect D3:0 D1:1)
     (connect D0:1 D3:0)
    )
   )
   (views
    (icon
     (origin 695 408)
     (extent 110 25)
    )
    (panel
     (origin 561 222)
     (extent 319 77)
     (widget 1 icon
      (title off)
      (origin 663 235)
      (extent 114 39)
      (format button)
     )
    )
    (detail
     (origin 34 115)
     (extent 912 591)
     (configuration
      (connect D1:1 D0:1
       (Point 347 362)
       (Point 392 362)
      )
      (connect D2:1 D1:0
       (Point 267 300)
       (Point 288 300)
       (Point 288 340)
      )
      (connect D3:0 D1:1
       (Point 490 445)
       (Point 490 460)
       (Point 210 460)
       (Point 210 362)
       (Point 228 362)
      )
      (connect D0:1 D3:0
       (Point 443 352)
       (Point 490 352)
       (Point 490 415)
      )
     )
    )
    (active panel)
    (active panel)
   )
  )
  (configuration
   (connect D7:0 D0:0)
   (connect D4:1 D0:1)
   (connect D2:1 D0:2)
   (connect D7:1 D0:3)
   (connect D4:0 D1:0)
   (connect D12:1 D1:1)
   (connect D1:1 D1:2)
   (connect D1:0 D2:0)
   (connect D1:1 D2:1)
   (connect D2:1 D2:2)
   (connect D10:0 D3:0)
   (connect D12:1 D4:1)
   (connect D4:1 D4:2)
   (connect D11:1 D5:1)
   (connect D5:1 D6:1)
   (connect D0:1 D6:2)
   (connect D11:0 D6:3)
   (connect D2:0 D7:0)
   (connect D3:1 D11:0)
   (connect D5:1 D12:1)
   (connect D0:1 D12:2)
  )
 )
 (views
  (panel
   (origin 0 67)
   (extent 884 669)
   (widget 7 detail
    (title on)
    (origin 26 286)
    (extent 265 50)
    (format buttons)
   )
   (widget 5 panel
    (title on)
    (origin 25 377)
    (extent 265 267)
    (widget 1 detail
     (title off)
     (origin 38 386)
     (extent 244 56)
     (format buttons)
    )
    (widget 0 detail
     (title on)
     (origin 39 483)
     (extent 115 154)
    )
    (widget 2 detail
     (title on)
     (origin 172 484)
     (extent 109 154)
    )
   )
   (widget 13 panel
    (title on)
    (origin 27 191)
    (extent 266 55)
    (widget 1 icon
     (title off)
     (origin 103 200)
     (extent 114 39)
     (format button)
    )
   )
   (widget 8 detail
    (title on)
    (origin 28 111)
    (extent 266 41)
    (editing disabled)
   )
   (widget 9 detail
    (title on)
    (origin 25 686)
    (extent 840 43)
    (editing disabled)
   )
   (widget 12 panel
    (title on)
    (origin 324 378)
    (extent 539 267)
    (widget 2 detail
     (title on)
     (origin 339 424)
     (extent 88 216)
    )
    (widget 0 detail
     (title on)
     (origin 442 425)
     (extent 87 213)
    )
    (widget 1 detail
     (title on)
     (origin 545 425)
     (extent 84 213)
    )
    (widget 8 detail
     (title on)
     (origin 662 426)
     (extent 179 124)
    )
    (widget 4 detail
     (title off)
     (origin 692 586)
     (extent 126 34)
    )
   )
   (widget 6 detail
    (title on)
    (origin 325 111)
    (extent 537 221)
    (displayMode annotGraph)
    (graphType cartesian)
    (gridType frame)
    (scale 0
     (name "LOAD")
     (domainName "    ")
     (pen 9)
     (show 1)
     (range -0.25 1.25 3 linear)
    )
    (domain 0 99.99999999999932 4 linear)
    (trace 0 onScale 0
     (name "SETPT")
     (pen 4)
     (lineType 1)
     (pointType 0)
    )
    (trace 1 onScale 0
     (name "ACTUAL")
     (pen 7)
     (lineType 1)
     (pointType 0)
    )
    (stepSize 1)
    (trackingEnabled 1)
   )
  )
  (detail
   (origin 0 67)
   (extent 981 635)
   (configuration
    (connect D7:0 D0:0
     (Point 350 555)
     (Point 350 570)
     (Point 480 570)
     (Point 480 430)
     (Point 540 430)
     (Point 540 450)
    )
    (connect D4:1 D0:1
     (Point 420 380)
     (Point 440 380)
     (Point 440 460)
     (Point 469 460)
    )
    (connect D2:1 D0:2
     (Point 425 480)
     (Point 440 480)
     (Point 440 470)
     (Point 469 470)
    )
    (connect D7:1 D0:3
     (Point 420 540)
     (Point 450 540)
     (Point 450 480)
     (Point 469 480)
    )
    (connect D4:0 D1:0
     (Point 350 395)
     (Point 350 415)
    )
    (connect D12:1 D1:1
     (Point 427 250)
     (Point 450 250)
     (Point 450 330)
     (Point 240 330)
     (Point 240 420)
     (Point 275 420)
    )
    (connect D1:1 D1:2
     (Point 425 430)
     (Point 450 430)
     (Point 450 340)
     (Point 250 340)
     (Point 250 440)
     (Point 275 440)
    )
    (connect D1:0 D2:0
     (Point 350 445)
     (Point 350 465)
    )
    (connect D1:1 D2:1
     (Point 425 430)
     (Point 450 430)
     (Point 450 340)
     (Point 250 340)
     (Point 250 470)
     (Point 275 470)
    )
    (connect D2:1 D2:2
     (Point 425 480)
     (Point 440 480)
     (Point 440 510)
     (Point 270 510)
     (Point 270 490)
     (Point 275 490)
    )
    (connect D10:0 D3:0
     (Point 60 141)
     (Point 60 165)
    )
    (connect D12:1 D4:1
     (Point 427 250)
     (Point 450 250)
     (Point 450 330)
     (Point 270 330)
     (Point 270 370)
     (Point 279 370)
    )
    (connect D4:1 D4:2
     (Point 420 380)
     (Point 440 380)
     (Point 440 350)
     (Point 260 350)
     (Point 260 390)
     (Point 279 390)
    )
    (connect D11:1 D5:1
     (Point 211 250)
     (Point 230 250)
     (Point 230 200)
     (Point 279 200)
    )
    (connect D5:1 D6:1
     (Point 420 200)
     (Point 440 200)
     (Point 440 240)
     (Point 460 240)
     (Point 460 320)
     (Point 630 320)
     (Point 630 450)
     (Point 680 450)
    )
    (connect D0:1 D6:2
     (Point 610 470)
     (Point 680 470)
    )
    (connect D11:0 D6:3
     (Point 170 284)
     (Point 170 590)
     (Point 640 590)
     (Point 640 490)
     (Point 680 490)
    )
    (connect D2:0 D7:0
     (Point 350 495)
     (Point 350 525)
    )
    (connect D3:1 D11:0
     (Point 117 200)
     (Point 170 200)
     (Point 170 215)
    )
    (connect D5:1 D12:1
     (Point 420 200)
     (Point 440 200)
     (Point 440 320)
     (Point 260 320)
     (Point 260 250)
     (Point 272 250)
    )
    (connect D0:1 D12:2
     (Point 610 470)
     (Point 630 470)
     (Point 630 580)
     (Point 230 580)
     (Point 230 290)
     (Point 272 290)
    )
   )
  )
  (active panel)
  (active panel)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
