#! /usr/lib/veetest/veetest -r
(revision "B.00.00")
(date "Fri 20/Nov/1992")
(component 0 "ROOTCONTEXT"
 (name "Beam Deflection Example")
 (interface
 )
 (implementation
  (locked no)
  (trigMode deg)
  (nextID 23)
  (component 0 "CONSTANT"
   (name "Elastic Modulus ")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Elastic Modulus ")
     (datum 28000000)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (name "Real")
     (datum 0)
    )
   )
   (views
    (icon
     (origin 95 158)
     (extent 154 25)
    )
    (detail
     (origin 17 405)
     (extent 187 30)
    )
    (active detail)
   )
  )
  (component 1 "CONSTANT"
   (name "Length, ft.")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Length, ft.")
     (datum 14)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (name "Real")
     (datum 0)
    )
   )
   (views
    (icon
     (origin 35 308)
     (extent 110 25)
    )
    (detail
     (origin 18 324)
     (extent 165 33)
    )
    (active detail)
   )
  )
  (component 2 "CONSTANT"
   (name "Beam Dia, in.")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Beam Dia, in.")
     (datum 6)
    )
    (component autoTrigger on)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (name "Real")
     (datum 0)
    )
   )
   (views
    (icon
     (origin 95 158)
     (extent 127 25)
    )
    (detail
     (origin 18 563)
     (extent 184 34)
    )
    (active detail)
   )
  )
  (component 3 "CONSTANT"
   (name "Wall Thickness")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Wall Thickness")
     (datum 0.1)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (name "Real")
     (datum 0)
    )
   )
   (views
    (icon
     (origin 95 158)
     (extent 127 25)
    )
    (detail
     (origin 19 644)
     (extent 183 33)
    )
    (active detail)
   )
  )
  (component 4 "FORMULA"
   (name "Deflection")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "xbeam")
     (optional yes)
    )
    (input 2
     (type data)
     (name "E")
     (optional yes)
    )
    (input 3
     (type data)
     (name "I")
     (optional yes)
    )
    (input 4
     (type data)
     (name "L")
     (optional yes)
    )
    (input 5
     (type data)
     (name "Load")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "load*xbeam^2/(24*E*I)*(xbeam^2+6*L^2-4*L*xbeam)")
   )
   (views
    (icon
     (origin 385 368)
     (extent 110 64)
     (iconImage "formula.icon")
    )
    (detail
     (origin 192 254)
     (extent 457 254)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 5 "FORMULA"
   (name "Deflection")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "xbeam")
     (optional yes)
    )
    (input 2
     (type data)
     (name "E")
     (optional yes)
    )
    (input 3
     (type data)
     (name "I")
     (optional yes)
    )
    (input 4
     (type data)
     (name "L")
     (optional yes)
    )
    (input 5
     (type data)
     (name "Load")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "load*xbeam^2/(120*L*E*I)*(10*L^3-10*L^2*xbeam+5*L*xbeam^2-xbeam^3)")
   )
   (views
    (icon
     (origin 385 468)
     (extent 110 64)
     (iconImage "formula.icon")
    )
    (detail
     (origin 93 354)
     (extent 655 254)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 6 "FORMULA"
   (name "load/12")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "a/12")
   )
   (views
    (icon
     (origin 211 488)
     (extent 78 25)
    )
    (detail
     (origin 181 454)
     (extent 79 54)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 7 "FORMULA"
   (name "Mmnt of Inertia")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "dia")
     (optional yes)
    )
    (input 2
     (type data)
     (name "thk")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "3.141592653589793/64*(dia^4-(dia-2*thk)^4)")
   )
   (views
    (icon
     (origin 228 568)
     (extent 145 64)
     (iconImage "formula.icon")
    )
    (detail
     (origin 136 542)
     (extent 269 79)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 8 "CONSTANT"
   (name "Nx")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Nx")
     (datum 168)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (name "Real")
     (datum 0)
    )
   )
   (views
    (icon
     (origin 157 218)
     (extent 46 25)
    )
    (detail
     (origin 109 194)
     (extent 102 35)
    )
    (active icon)
   )
  )
  (component 9 "CONSTANT"
   (name "BL:0")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "BL:0")
     (datum 0)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (name "Real")
     (datum 0)
    )
   )
   (views
    (icon
     (origin 157 258)
     (extent 46 25)
    )
    (detail
     (origin 96 234)
     (extent 129 35)
    )
    (active icon)
   )
  )
  (component 10 "TEXTDISPLAY"
   (name "Mmnt of Inertia")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 116 0)
    )
    (detail
     (origin 259 702)
     (extent 242 36)
     (formatter
      (realFormat engineering)
      (realSigDigits 16)
      (realRadixSpec 5)
      (integerBase decimal)
     )
    )
    (active detail)
   )
  )
  (component 11 "FORMULA"
   (name "ramp(numElem,from,thru)")
   (description 4 4
    This "ramp(numElem,from,thru)" object is used to 
    easily generate a series of uniformly spaced 
    "X values" used to represent the beam length in 
    the beam deflection calculations.
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "numElem")
     (requires
      (datatype Int32)
      (shape "Scalar")
     )
     (lock name constraints)
    )
    (input 2
     (type data)
     (name "from")
     (requires
      (datatype Real)
      (shape "Scalar")
     )
     (lock name constraints)
    )
    (input 3
     (type data)
     (name "thru")
     (requires
      (datatype Real)
      (shape "Scalar")
     )
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked yes)
    (component expr 1 "ramp(numElem,from,thru)")
   )
   (views
    (icon
     (origin 262 253)
     (extent 217 34)
    )
    (detail
     (origin 232 170)
     (extent 266 160)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 12 "TOCOORDINATE"
   (name "Build Coord")
   (description 11 4
    This "Data -> Build Data -> Coord" object is used
    to build a collection of coordinate data points
    from the arrays provided by the ramp and formula
    objects connected.  The "X values" are equivalent
    to lengths along the beam, and each equivalent
    "Y value" is the deflection at the corresponding
    position along the beam.
    
    The icon image was generated specifically to
    provide a graphic representation of the beam and
    its load, which in this case is a "uniform" load.
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "X Data")
     (tag "X")
     (requires
      (datatype Real)
     )
     (lock constraints)
    )
    (input 2
     (type data)
     (name "Y Data")
     (tag "Y")
     (requires
      (datatype Real)
     )
     (lock constraints)
    )
    (output 1
     (type data)
     (name "Coord")
     (tag "Coord")
     (lock constraints)
    )
   )
   (implementation
   )
   (views
    (icon
     (origin 521 251)
     (extent 158 79)
     (label off)
     (iconImage "uniform.icon")
    )
    (detail
     (origin 565 218)
     (extent 60 104)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 13 "FORMULA"
   (name "L*12")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "a*12")
   )
   (views
    (icon
     (origin 207 328)
     (extent 46 25)
    )
    (detail
     (origin 207 193)
     (extent 79 54)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 14 "YPLOT"
   (name "Beam Deflection (inches)")
   (description 2 4
     This is a "Display -> XY Trace" object.
    
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Uniform")
     (lock constraints)
    )
    (input 2
     (type data)
     (name "Sum")
     (lock constraints)
     (optional yes)
    )
    (input 3
     (type data)
     (name "Difference")
     (lock constraints)
     (optional yes)
    )
    (input 4
     (type data)
     (name "Ramp")
     (lock constraints)
     (optional yes)
    )
    (input 5
     (type control)
     (name "Auto Scale")
     (lock name constraints)
     (optional yes)
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
    (component tracePin 1)
    (component tracePin 2)
    (component tracePin 3)
    (component tracePin 4)
    (component graphMode rectangular)
   )
   (views
    (icon
     (origin 905 338)
     (extent 226 64)
     (iconImage "display.icon")
    )
    (detail
     (origin 733 263)
     (extent 515 455)
     (displayMode scrollGraph)
     (graphType cartesian)
     (gridType grid)
     (scale 0
      (name "Deflection")
      (domainName "Distance from Support (inches)")
      (pen 9)
      (show 1)
      (range 0 0.9999999999999999 3 linear)
     )
     (domain 0 180 3 linear)
     (trace 0 onScale 0
      (name "Uniform")
      (pen 4)
      (lineType 1)
      (pointType 0)
     )
     (trace 1 onScale 0
      (name "Sum")
      (pen 2)
      (lineType 1)
      (pointType 0)
     )
     (trace 2 onScale 0
      (name "Difference")
      (pen 7)
      (lineType 1)
      (pointType 0)
     )
     (trace 3 onScale 0
      (name "Ramp")
      (pen 3)
      (lineType 1)
      (pointType 0)
     )
     (marker 0 onTrace 0)
     (marker 1 onTrace 1)
    )
    (active detail)
   )
  )
  (component 15 "NOTE"
   (name "To Operate")
   (interface
   )
   (implementation
    (component text 4 5
     Click "Run" to view
     example results. Click
     "Info About" for more
     details.
    )
   )
   (views
    (icon
     (origin 677 158)
     (extent 110 25)
    )
    (detail
     (origin 348 122)
     (extent 224 77)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 16 "NOTE"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 4 5
     This example is provided as an illustration
     "as is", and Hewlett-Packard Company makes
     no warranty of any kind with regard to this
     example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 585 121)
     (extent 410 78)
     (editing enabled)
    )
    (active detail)
   )
  )
  (component 17 "CONSTANT"
   (name "Load lb/ft")
   (description 8 4
    This is a "Data -> Constant -> Real" object.
    It is used to enter the uniform load in pounds per
    foot acting on the beam, as well as the maximum 
    value for the ramp load.  The initial load of 20
    lb./ft. represents a value consistent with a full
    flow of water in a 6 inch pipe.
    
    
   )
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Load lb/ft")
     (datum 20)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (name "Real")
     (datum 0)
    )
   )
   (views
    (icon
     (origin 95 158)
     (extent 110 25)
    )
    (detail
     (origin 23 485)
     (extent 174 31)
    )
    (active detail)
   )
  )
  (component 18 "CONTEXT"
   (name "Press For")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (locked no)
    (trigMode deg)
    (nextID 3)
    (component 0 "IFTHENELSE"
     (name "!= 0")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a!=0")
     )
     (views
      (icon
       (origin 365 320)
       (extent 46 25)
      )
      (detail
       (origin 209 308)
       (extent 73 64)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "TOGGLE"
     (name "Info About")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Reset")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Info About")
       (values range 0 1)
       (datum 0)
      )
      (component autoTrigger on)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (name "LongInt")
       (datum 0)
      )
     )
     (views
      (icon
       (origin 201 313)
       (extent 114 39)
       (format button)
      )
      (detail
       (origin 320 203)
       (extent 42 54)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "CONTEXT"
     (name "Info About This Example")
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (locked no)
      (trigMode deg)
      (nextID 2)
      (component 0 "CONFIRM"
       (name "DONE")
       (description 7 8
        This tiny "thread" begins running when the 
        enclosing UserObject is executed.  When the user
        acknowledges the OK/DONE button, there is nothing
        left to execute, so the thread ends.  Since there
        are not other threads running, the User Object
        is completed and will exit, removing the Show on
        Execute pop-up display.
       )
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 371 702)
         (extent 58 37)
        )
        (detail
         (origin 156 253)
         (extent 79 34)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "NOTE"
       (name "Note Pad")
       (description 2 8
        This is a "Display, Note Pad" object
        
       )
       (interface
       )
       (implementation
        (component text 31 9
         PURPOSE:     Demonstrate the use of HP VEE in a cantilever beam deflection problem.
                      This model uses an "XY Trace" display to show the deflection of a beam
                      under uniform, ramp, and combined load situations. 
         
         USER DATA REQUIRED: You may change any of the displayed values; click on the value
                      and type over it to enter a new value.  Note the use of "M" for E6 (10^6)
                      and "m" for E-3 (10^-3), which you can use instead of typing zeros.  You
                      may also use other abbreviations, such as "K" for E3 (10^3).
         
         EXPLANATION: The example values are consistent with a 6" dia. pipe (cantilever
                      supported at one end) loaded with a full flow of water (uniform load),
                      and an additional ramp force acting either as a load or a support.  HP
                      VEE allows the results of an equation (in array form) to be handled with
                      the ease of a simple number.  As may be seen on the display, the two
                      basic deflection equation results can be both summed and differenced.
                      By positioning a triangular marker (click spot on graph), precise values
                      may be read at the bottom of the graph's display.  Click on a colored
                      line button to change the color of a line to which a marker is attached.
         
                      The model is built using the panel approach, which simplifies data entry
                      and viewing.  Click on the "Detail" button (left on the title bar) to
                      see the individual objects which make up the model.  Since several
                      objects have been iconized, double click on any of these to change to
                      the open view.
         
                      Additional information for some of the objects may be provided with the
                      object menu "Show Description" feature.  From the object menu, "Help" 
                      may also be  directly accessed for the object.
         
                      Click "DONE" to exit this information panel.
         
        )
       )
       (views
        (icon
         (origin 505 428)
         (extent 110 25)
        )
        (detail
         (origin 58 235)
         (extent 585 410)
         (editing disabled)
        )
        (active detail)
       )
      )
      (configuration
      )
      (ShowOnExecPanel
       (origin 79 100)
       (extent 849 571)
       (panel
        (origin 38 164)
        (extent 845 533)
        (widget 0 icon
         (title off)
         (origin 437 649)
         (extent 58 37)
        )
        (widget 1 detail
         (title off)
         (origin 49 175)
         (extent 824 451)
         (editing disabled)
        )
       )
      )
     )
     (views
      (icon
       (origin 352 418)
       (extent 217 25)
      )
      (detail
       (origin 7 190)
       (extent 866 520)
       (configuration
       )
       (stackingOrder 0 1)
      )
      (active icon)
     )
    )
    (configuration
     (connect D1:1 D0:1)
     (connect D2:0 D1:1)
     (connect D0:1 D2:0)
    )
   )
   (views
    (icon
     (origin 415 408)
     (extent 110 25)
    )
    (panel
     (origin 11 122)
     (extent 319 77)
     (widget 1 icon
      (title off)
      (origin 113 135)
      (extent 114 39)
      (format button)
     )
    )
    (detail
     (origin 4 115)
     (extent 912 591)
     (configuration
      (connect D1:1 D0:1
       (Point 317 332)
       (Point 362 332)
      )
      (connect D2:0 D1:1
       (Point 460 445)
       (Point 460 460)
       (Point 180 460)
       (Point 180 332)
       (Point 198 332)
      )
      (connect D0:1 D2:0
       (Point 413 322)
       (Point 460 322)
       (Point 460 415)
      )
     )
     (stackingOrder 0 1 2)
    )
    (active panel)
    (active panel)
   )
  )
  (component 19 "START"
   (interface
    (sequence out)
   )
   (implementation
   )
   (views
    (icon
     (origin 67 222)
     (extent 67 37)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 20 "FORMULA"
   (name " + ")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "X")
     (lock name constraints)
    )
    (input 2
     (type data)
     (name "Y")
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked yes)
    (component expr 1 "X+Y")
   )
   (views
    (icon
     (origin 637 388)
     (extent 46 25)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 21 "FORMULA"
   (name " - ")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "X")
     (lock name constraints)
    )
    (input 2
     (type data)
     (name "Y")
     (lock name constraints)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked yes)
    (component expr 1 "X-Y")
   )
   (views
    (icon
     (origin 637 478)
     (extent 46 25)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 22 "TOCOORDINATE"
   (name "Build Coord")
   (description 11 4
    This "Data -> Build Data -> Coord" object is used
    to build a collection of coordinate data points
    from the arrays provided by the ramp and formula
    objects connected.  The "X values" are equivalent
    to lengths along the beam, and each equivalent
    "Y value" is the deflection at the corresponding
    position along the beam.
    
    The icon image was generated specifically to
    provide a graphic representation of the beam and
    its load, which is a "ramp" load in this case.
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "X Data")
     (tag "X")
     (requires
      (datatype Real)
     )
     (lock constraints)
    )
    (input 2
     (type data)
     (name "Y Data")
     (tag "Y")
     (requires
      (datatype Real)
     )
     (lock constraints)
    )
    (output 1
     (type data)
     (name "Coord")
     (tag "Coord")
     (lock constraints)
    )
   )
   (implementation
   )
   (views
    (icon
     (origin 541 541)
     (extent 158 79)
     (label off)
     (iconImage "rampld.icon")
    )
    (detail
     (origin 570 589)
     (extent 60 104)
    )
    (terminals on)
    (active icon)
   )
  )
  (configuration
   (connect D19:0 D1:0)
   (connect D11:1 D4:1)
   (connect D0:1 D4:2)
   (connect D7:1 D4:3)
   (connect D13:1 D4:4)
   (connect D6:1 D4:5)
   (connect D11:1 D5:1)
   (connect D0:1 D5:2)
   (connect D7:1 D5:3)
   (connect D13:1 D5:4)
   (connect D6:1 D5:5)
   (connect D17:1 D6:1)
   (connect D2:1 D7:1)
   (connect D3:1 D7:2)
   (connect D7:1 D10:1)
   (connect D8:1 D11:1)
   (connect D9:1 D11:2)
   (connect D13:1 D11:3)
   (connect D11:1 D12:1)
   (connect D4:1 D12:2)
   (connect D1:1 D13:1)
   (connect D12:1 D14:1)
   (connect D20:1 D14:2)
   (connect D21:1 D14:3)
   (connect D22:1 D14:4)
   (connect D14:0 D14:5)
   (connect D12:1 D20:1)
   (connect D22:1 D20:2)
   (connect D12:1 D21:1)
   (connect D22:1 D21:2)
   (connect D11:1 D22:1)
   (connect D5:1 D22:2)
  )
 )
 (views
  (panel
   (origin 0 62)
   (extent 1000 644)
   (widget 16 detail
    (title on)
    (origin 572 109)
    (extent 403 79)
    (editing disabled)
   )
   (widget 15 detail
    (title on)
    (origin 339 111)
    (extent 214 76)
    (editing disabled)
   )
   (widget 18 panel
    (title on)
    (origin 30 111)
    (extent 291 77)
    (widget 1 icon
     (title off)
     (origin 126 130)
     (extent 114 39)
     (format button)
    )
   )
   (widget 2 detail
    (title on)
    (origin 32 236)
    (extent 182 28)
   )
   (widget 3 detail
    (title on)
    (origin 32 314)
    (extent 182 28)
   )
   (widget 10 detail
    (title on)
    (origin 33 394)
    (extent 182 32)
    (formatter
     (realFormat engineering)
     (realSigDigits 16)
     (realRadixSpec 5)
     (integerBase decimal)
    )
   )
   (widget 17 detail
    (title on)
    (origin 34 556)
    (extent 182 28)
   )
   (widget 0 detail
    (title on)
    (origin 35 631)
    (extent 182 28)
   )
   (widget 1 detail
    (title on)
    (origin 33 478)
    (extent 182 31)
   )
   (widget 14 detail
    (title on)
    (origin 291 227)
    (extent 688 459)
    (displayMode annotGraph)
    (graphType cartesian)
    (gridType grid)
    (scale 0
     (name "Deflection")
     (domainName "Distance from Support, inches")
     (pen 9)
     (show 1)
     (range 0 0.9999999999999999 3 linear)
    )
    (scale 1
     (name "Defl. in.")
     (domainName "Distance from Support, inches")
     (pen 1)
     (show 0)
     (range 0 1 3 linear)
    )
    (domain 0 180 3 linear)
    (trace 0 onScale 0
     (name "Uniform")
     (pen 4)
     (lineType 1)
     (pointType 0)
    )
    (trace 1 onScale 0
     (name "Sum")
     (pen 2)
     (lineType 1)
     (pointType 0)
    )
    (trace 2 onScale 0
     (name "Difference")
     (pen 7)
     (lineType 1)
     (pointType 0)
    )
    (trace 3 onScale 0
     (name "Ramp")
     (pen 3)
     (lineType 1)
     (pointType 0)
    )
    (marker 0 onTrace 0)
    (marker 1 onTrace 1)
   )
   (widget 22 icon
    (title off)
    (origin 430 271)
    (extent 158 79)
    (label off)
    (iconImage "uniform.icon")
   )
   (widget 12 icon
    (title off)
    (origin 431 446)
    (extent 158 79)
    (label off)
    (iconImage "rampld.icon")
   )
  )
  (detail
   (origin 0 67)
   (extent 980 639)
   (configuration
    (connect D19:0 D1:0
     (Point 100 261)
     (Point 100 293)
    )
    (connect D11:1 D4:1
     (Point 481 270)
     (Point 500 270)
     (Point 500 300)
     (Point 490 300)
     (Point 490 310)
     (Point 370 310)
     (Point 370 380)
     (Point 382 380)
    )
    (connect D0:1 D4:2
     (Point 206 420)
     (Point 230 420)
     (Point 230 390)
     (Point 382 390)
    )
    (connect D7:1 D4:3
     (Point 375 600)
     (Point 390 600)
     (Point 390 550)
     (Point 370 550)
     (Point 370 400)
     (Point 382 400)
    )
    (connect D13:1 D4:4
     (Point 255 340)
     (Point 280 340)
     (Point 280 410)
     (Point 382 410)
    )
    (connect D6:1 D4:5
     (Point 291 500)
     (Point 320 500)
     (Point 320 420)
     (Point 382 420)
    )
    (connect D11:1 D5:1
     (Point 481 270)
     (Point 500 270)
     (Point 500 300)
     (Point 490 300)
     (Point 490 340)
     (Point 520 340)
     (Point 520 450)
     (Point 360 450)
     (Point 360 480)
     (Point 382 480)
    )
    (connect D0:1 D5:2
     (Point 206 420)
     (Point 310 420)
     (Point 310 490)
     (Point 382 490)
    )
    (connect D7:1 D5:3
     (Point 375 600)
     (Point 390 600)
     (Point 390 550)
     (Point 370 550)
     (Point 370 500)
     (Point 382 500)
    )
    (connect D13:1 D5:4
     (Point 255 340)
     (Point 280 340)
     (Point 280 410)
     (Point 350 410)
     (Point 350 510)
     (Point 382 510)
    )
    (connect D6:1 D5:5
     (Point 291 500)
     (Point 310 500)
     (Point 310 520)
     (Point 382 520)
    )
    (connect D17:1 D6:1
     (Point 199 500)
     (Point 208 500)
    )
    (connect D2:1 D7:1
     (Point 204 580)
     (Point 225 580)
    )
    (connect D3:1 D7:2
     (Point 204 660)
     (Point 220 660)
     (Point 220 620)
     (Point 225 620)
    )
    (connect D7:1 D10:1
     (Point 375 600)
     (Point 390 600)
     (Point 390 650)
     (Point 240 650)
     (Point 240 720)
     (Point 256 720)
    )
    (connect D8:1 D11:1
     (Point 205 230)
     (Point 220 230)
     (Point 220 260)
     (Point 259 260)
    )
    (connect D9:1 D11:2
     (Point 205 270)
     (Point 259 270)
    )
    (connect D13:1 D11:3
     (Point 255 340)
     (Point 270 340)
     (Point 270 310)
     (Point 240 310)
     (Point 240 280)
     (Point 259 280)
    )
    (connect D11:1 D12:1
     (Point 481 270)
     (Point 518 270)
    )
    (connect D4:1 D12:2
     (Point 497 400)
     (Point 510 400)
     (Point 510 350)
     (Point 500 350)
     (Point 500 310)
     (Point 518 310)
    )
    (connect D1:1 D13:1
     (Point 185 340)
     (Point 204 340)
    )
    (connect D12:1 D14:1
     (Point 681 290)
     (Point 700 290)
     (Point 700 310)
     (Point 730 310)
    )
    (connect D20:1 D14:2
     (Point 685 400)
     (Point 730 400)
    )
    (connect D21:1 D14:3
     (Point 685 490)
     (Point 730 490)
    )
    (connect D22:1 D14:4
     (Point 701 580)
     (Point 730 580)
    )
    (connect D14:0 D14:5
     (Point 990 720)
     (Point 990 740)
     (Point 710 740)
     (Point 710 670)
     (Point 730 670)
    )
    (connect D12:1 D20:1
     (Point 681 290)
     (Point 700 290)
     (Point 700 350)
     (Point 620 350)
     (Point 620 390)
     (Point 634 390)
    )
    (connect D22:1 D20:2
     (Point 701 580)
     (Point 710 580)
     (Point 710 520)
     (Point 620 520)
     (Point 620 410)
     (Point 634 410)
    )
    (connect D12:1 D21:1
     (Point 681 290)
     (Point 700 290)
     (Point 700 350)
     (Point 620 350)
     (Point 620 390)
     (Point 610 390)
     (Point 610 480)
     (Point 634 480)
    )
    (connect D22:1 D21:2
     (Point 701 580)
     (Point 710 580)
     (Point 710 520)
     (Point 620 520)
     (Point 620 500)
     (Point 634 500)
    )
    (connect D11:1 D22:1
     (Point 481 270)
     (Point 500 270)
     (Point 500 300)
     (Point 490 300)
     (Point 490 340)
     (Point 520 340)
     (Point 520 560)
     (Point 538 560)
    )
    (connect D5:1 D22:2
     (Point 497 500)
     (Point 510 500)
     (Point 510 600)
     (Point 538 600)
    )
   )
   (stackingOrder 0 1 2 3 4 5 6 7 8 9
     10 11 13 14 15 16 17 18 19 20
     21 12 22)
  )
  (active panel)
  (active panel)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
