#! /usr/lib/veetest/veetest -r
(revision "B.00.00")
(date "Tue 27/Oct/1992")
(component 0 "ROOTCONTEXT"
 (name "Communicating With HP BASIC/UX")
 (interface
 )
 (implementation
  (locked no)
  (trigMode deg)
  (nextID 16)
  (component 0 "NOTE"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 4 5
     This example is provided as an
     illustration "as is", and Hewlett-Packard
     Company makes no warranty of any kind
     with regard to this example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 572 99)
     (extent 397 82)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 1 "NOTE"
   (name "Info About...")
   (interface
   )
   (implementation
    (component text 44 5
     Overview:
     This model contains two examples of how you can
     communicate with HP BASIC/UX using the 
     "Init HP BASIC/UX" and "To/From HP BASIC/UX" objects.  
     
     Details:
     You must have already purchased and installed 
     HP BASIC/UX using the standard installation 
     procedure to run this model.
     
     Refer to the "Note Pads" next to each thread for
     additional information specific to each case.
     
     Use the "Timers" to compare the execution speeds of 
     each approach.  Specific execution times will vary
     widely based on your computer configuration; these
     results are typical:
     
     * Time to execute Case #1 or 
       first iteration of Case #2       15 seconds
     
     * Time to execute subsequent 
       iterations of Case #2            150 milliseconds
     
     Note that each thread containing an "Init HP BASIC/UX"
     object creates its own HP BASIC/UX process.  
     
     When an "Init HP BASIC/UX" object executes, it checks
     to see if an HP BASIC/UX process corresponding to that 
     object exits.  It one already exits, nothing happens.
     If one does not exits, a new one is created.
     
     Note that the pipe names are different for each
     thread; this is a must.
     
     There is no ready-made way to terminate an HP BASIC/UX
     process from inside HP VEE.  You must design your
     HP BASIC/UX program so that it can QUIT at the proper
     time or you must kill it with the HP-UX command 
     rmbkill.
     
     Related Files: man34a.bas
                    man34b.bas
     
    )
   )
   (views
    (icon
     (extent 127 0)
    )
    (detail
     (origin 13 102)
     (extent 534 216)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 2 "SLIDER"
   (name "Int Slider")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Int32
     (name "Int Slider")
     (values range 0 100)
     (datum 87)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Int32
     (name "LongInt")
     (datum 0)
    )
    (component detents 1)
   )
   (views
    (icon
    )
    (detail
     (origin 389 367)
     (extent 182 127)
    )
    (active detail)
   )
  )
  (component 3 "NOTE"
   (name "Case #1")
   (interface
   )
   (implementation
    (component text 12 5
     This thread illustrates how to use
     HP BASIC/UX by running a BASIC program
     that executes only once per press of
     the "Start" button.
     
     The HP BASIC/UX program man34a.bas
     simply reads a number, adds 1 to the
     number, sends it back, and QUITs.
     
     Note that booting each new instance of
     HP BASIC/UX requires a significant
     amount of time.
    )
   )
   (views
    (icon
     (extent 78 0)
    )
    (detail
     (origin 20 358)
     (extent 360 225)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 4 "NAMEDPIPE"
   (name "To/From HP BASIC/UX")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (tag "A")
     (optional yes)
    )
    (output 1
     (type data)
     (name "X")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (attr iopath file read "/tmp/from_rmb"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (attr iopath file append "/tmp/to_rmb"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (procedure
      WRITE TEXT a INT EOL
      READ TEXT x INT
    )
   )
   (views
    (icon
     (iconImage "basic.icon")
    )
    (detail
     (origin 624 369)
     (extent 323 122)
    )
    (terminals on)
    (active detail)
   )
  )
  (component 5 "HPBASIC"
   (name "Init HP BASIC/UX")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (component command "/usr/lib/veetest/examples/rmb/man34a.bas")
   )
   (views
    (icon
    )
    (detail
     (origin 666 283)
     (extent 228 34)
    )
    (active detail)
   )
  )
  (component 6 "START"
   (name "Start")
   (interface
    (sequence out)
   )
   (implementation
   )
   (views
    (icon
     (origin 746 191)
     (extent 69 39)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 7 "TIMER"
   (name "Timer")
   (interface
    (sequence out)
    (input 1
     (type data)
     (name "Time1")
    )
    (input 2
     (type data)
     (name "Time2")
    )
    (output 1
     (type data)
     (name "T2 - T1")
     (tag "dTime")
     (lock name constraints)
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
    )
    (detail
     (origin 1046 253)
     (extent 129 34)
    )
    (active detail)
   )
  )
  (component 8 "SCROLLINGTEXTDISPLAY"
   (name "Logging AlphaNumeric")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 0)
    (component clearAtActivate 0)
   )
   (views
    (icon
    )
    (detail
     (origin 1017 368)
     (extent 267 124)
     (bufferSize 256)
    )
    (active detail)
   )
  )
  (component 9 "SLIDER"
   (name "Int Slider")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Int32
     (name "Int Slider")
     (values range -1 100)
     (datum 52)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Int32
     (name "LongInt")
     (datum 0)
    )
    (component detents 1)
   )
   (views
    (icon
    )
    (detail
     (origin 399 697)
     (extent 182 127)
    )
    (active detail)
   )
  )
  (component 10 "NAMEDPIPE"
   (name "To/From HP BASIC/UX")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (tag "A")
     (optional yes)
    )
    (output 1
     (type data)
     (name "X")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (attr iopath file read "/tmp/from_rmb2"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (attr iopath file append "/tmp/to_rmb2"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (procedure
      WRITE TEXT a INT EOL
      READ TEXT x INT
    )
   )
   (views
    (icon
     (iconImage "basic.icon")
    )
    (detail
     (origin 634 699)
     (extent 323 122)
    )
    (terminals on)
    (active detail)
   )
  )
  (component 11 "TIMER"
   (name "Timer")
   (interface
    (sequence out)
    (input 1
     (type data)
     (name "Time1")
    )
    (input 2
     (type data)
     (name "Time2")
    )
    (output 1
     (type data)
     (name "T2 - T1")
     (tag "dTime")
     (lock name constraints)
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
    )
    (detail
     (origin 1076 613)
     (extent 129 34)
    )
    (active detail)
   )
  )
  (component 12 "SCROLLINGTEXTDISPLAY"
   (name "Logging AlphaNumeric")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 0)
    (component clearAtActivate 0)
   )
   (views
    (icon
    )
    (detail
     (origin 1027 698)
     (extent 267 124)
     (bufferSize 256)
    )
    (active detail)
   )
  )
  (component 13 "START"
   (name "Start")
   (interface
    (sequence out)
   )
   (implementation
   )
   (views
    (icon
     (origin 756 521)
     (extent 69 39)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 14 "HPBASIC"
   (name "Init HP BASIC/UX")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (component command "/usr/lib/veetest/examples/rmb/man34b.bas")
   )
   (views
    (icon
    )
    (detail
     (origin 676 623)
     (extent 228 34)
    )
    (active detail)
   )
  )
  (component 15 "NOTE"
   (name "Case #2")
   (interface
   )
   (implementation
    (component text 22 5
     This thread illustrates how to use
     HP BASIC/UX by running a program
     that executes and remains active.
     
     The HP BASIC/UX program man34b.bas
     reads a number and determines its
     sign (positive or negative).  If
     the number is positive, the program
     adds 1 to the number and returns the
     incremented value.  If the number is
     negative, the program returns -1 and
     QUITs.
     
     Note that subsequent clicks on "Start"
     produce results very quickly.
     
     The first time you click on Start,
     HP VEE creates a new instance of 
     HP BASIC/UX runs the program 
     man34b.bas.  The program remains 
     active until you send it a negative
     value.
    )
   )
   (views
    (icon
     (origin 211 578)
     (extent 78 25)
    )
    (detail
     (origin 13 636)
     (extent 374 189)
     (editing disabled)
    )
    (active detail)
   )
  )
  (configuration
   (connect D5:0 D4:0)
   (connect D2:1 D4:1)
   (connect D6:0 D5:0)
   (connect D6:0 D7:1)
   (connect D4:0 D7:2)
   (connect D4:1 D8:1)
   (connect D14:0 D10:0)
   (connect D9:1 D10:1)
   (connect D13:0 D11:1)
   (connect D10:0 D11:2)
   (connect D10:1 D12:1)
   (connect D13:0 D14:0)
  )
 )
 (views
  (detail
   (origin 0 62)
   (extent 985 639)
   (configuration
    (connect D5:0 D4:0
     (Point 780 319)
     (Point 780 338)
    )
    (connect D2:1 D4:1
     (Point 573 430)
     (Point 581 430)
    )
    (connect D6:0 D5:0
     (Point 780 232)
     (Point 780 252)
    )
    (connect D6:0 D7:1
     (Point 780 232)
     (Point 780 240)
     (Point 910 240)
     (Point 910 260)
     (Point 1043 260)
    )
    (connect D4:0 D7:2
     (Point 780 493)
     (Point 780 510)
     (Point 1000 510)
     (Point 1000 280)
     (Point 1043 280)
    )
    (connect D4:1 D8:1
     (Point 979 430)
     (Point 1014 430)
    )
    (connect D14:0 D10:0
     (Point 790 659)
     (Point 790 668)
    )
    (connect D9:1 D10:1
     (Point 583 760)
     (Point 591 760)
    )
    (connect D13:0 D11:1
     (Point 790 562)
     (Point 790 570)
     (Point 930 570)
     (Point 930 620)
     (Point 1073 620)
    )
    (connect D10:0 D11:2
     (Point 790 823)
     (Point 790 840)
     (Point 1000 840)
     (Point 1000 640)
     (Point 1073 640)
    )
    (connect D10:1 D12:1
     (Point 989 760)
     (Point 1024 760)
    )
    (connect D13:0 D14:0
     (Point 790 562)
     (Point 790 592)
    )
   )
   (stackingOrder 0 1 2 3 4 5 6 7 8 9
     10 11 12 13 14 15)
  )
  (active detail)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
