#! /usr/lib/veetest/veetest -r
(revision "B.00.00")
(date "Tue 27/Oct/1992")
(component 0 "ROOTCONTEXT"
 (name " HP BASIC/UX Example")
 (interface
 )
 (implementation
  (locked no)
  (trigMode deg)
  (nextID 7)
  (component 0 "NOTE"
   (name "Overview of HP BASIC/UX example")
   (interface
   )
   (implementation
    (component text 39 5
     Purpose: Show how to start an HP BASIC/UX
     process from an "Execute Program" object.
     
     Make sure no other HP BASIC/UX process is
     running which uses the pipes used in this
     model.
     
     Explanation:
     The "Execute Program" object runs the shell 
     script called startbasic.sh.  This script 
     provides much of same functionality as an 
     "Init HP BASIC/UX" object.  Inside the 
     script, the /tmp/from_pipe is emptied.  A 
     check is made to see if the specified BASIC 
     program is already running.  If it is not 
     already running, it is started. simple.bas 
     should not be running, since it executes a 
     QUIT statement at the end of the program.
     
     The remainder of the model is the same as
     basic1.ex.
     
     Using a shell script to start HP BASIC/UX
     provides considerably more control.  The
     "Init HP BASIC/UX" does not clear any pipes,
     but this shell script does.  Other 
     housekeeping tasks could also be done.
     HP BASIC/UX provides many options on its 
     command line.  These options are available 
     using the shell escape method.
     
     Writing shell scripts does, however, require 
     knowledge of how HP/UX and the shell operate.
     
     Edit the startbasic file to see what is
     needed on the shell end.  Try starting 
     HP BASIC/UX from a shell prompt and then 
     running the model.
     
    )
   )
   (views
    (icon
     (extent 289 0)
    )
    (detail
     (origin 22 119)
     (extent 437 563)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 1 "START"
   (name "Start")
   (interface
    (sequence out)
   )
   (implementation
   )
   (views
    (icon
     (origin 706 81)
     (extent 69 39)
    )
    (detail
     (origin 586 400)
     (extent 129 20)
    )
    (active icon)
   )
  )
  (component 2 "NAMEDPIPE"
   (name "To/From HP BASIC/UX")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (output 1
     (type data)
     (name "X")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (attr iopath file read "/tmp/from_rmb"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (attr iopath file append "/tmp/to_rmb"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (procedure
      WRITE TEXT a EOL
      READ TEXT x REAL
    )
   )
   (views
    (icon
     (iconImage "basic.icon")
    )
    (detail
     (origin 595 407)
     (extent 271 167)
    )
    (active detail)
   )
  )
  (component 3 "CONSTANT"
   (name "in")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "in")
     (datum 3)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (name "Real")
     (datum 0)
    )
   )
   (views
    (icon
     (extent 46 0)
    )
    (detail
     (origin 476 477)
     (extent 88 27)
    )
    (active detail)
   )
  )
  (component 4 "TEXTDISPLAY"
   (name "out")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (origin 907 348)
     (extent 46 25)
    )
    (detail
     (origin 891 473)
     (extent 98 35)
    )
    (active detail)
   )
  )
  (component 5 "NOTE"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 4 5
     This example is provided as an
     illustration "as is", and Hewlett-Packard
     Company makes no warranty of any kind
     with regard to this example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 502 619)
     (extent 397 82)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 6 "SHELLESCAPE"
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Exit code")
     (lock name constraints)
    )
    (output 2
     (type data)
     (name "X")
     (requires
      (datatype Text)
     )
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (attr iopath pipe read "pipe"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (attr iopath pipe write "pipe"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (procedure
      READ TEXT x STR
    )
    (component shell "sh")
    (component command "(cd /usr/lib/veetest/examples/rmb;startbasic.sh simple.bas)")
    (component deathWait "Yes")
   )
   (views
    (icon
     (iconImage "c.icon")
    )
    (detail
     (origin 507 172)
     (extent 396 176)
    )
    (terminals on)
    (active detail)
   )
  )
  (configuration
   (connect D3:1 D2:1)
   (connect D6:0 D3:0)
   (connect D2:1 D4:1)
   (connect D1:0 D6:0)
  )
 )
 (views
  (detail
   (origin 0 62)
   (extent 985 639)
   (configuration
    (connect D3:1 D2:1
     (Point 566 490)
     (Point 592 490)
    )
    (connect D6:0 D3:0
     (Point 740 350)
     (Point 740 370)
     (Point 520 370)
     (Point 520 446)
    )
    (connect D2:1 D4:1
     (Point 868 490)
     (Point 888 490)
    )
    (connect D1:0 D6:0
     (Point 740 122)
     (Point 740 141)
    )
   )
   (stackingOrder 6 0 5 2 3 4 1)
  )
  (active detail)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
