#! /usr/lib/veetest/veetest -r
(revision "B.00.00")
(date "Thu 19/Nov/1992")
(component 0 "ROOTCONTEXT"
 (name "End of test reporting")
 (interface
 )
 (implementation
  (UserFunctions
   (nextID 1)
   (context 0
    (name "endOfTest")
    (description 130 5
     Overview:
     
     This function examines Data Sets that have been
     built from logging Sequencer transactions.  What
     do is read a Data Set and examine the contents in
     two ways.  We look at the total number of tests
     that were stored in the Data Set.  This includes
     every individual test performed on each DUT in
     totality.  The second thing we do is to examine
     each individual test across the DUT's we've 
     tested.  By so doing, we have an insight into the
     total testing process as well as the individual 
     parts that comprise the entire test.  The goal is
     to let ourselves know how well our products are
     performing, then give ourselves some additional 
     information that lets us zero in on any parts
     of a DUT that cause more problems than other 
     parts.  We then need three pieces of information:
     how many tests we ran, how many total tests passed,
     and how many of each individual test passed.  With
     this, we can compute overall and individual failure
     rates, and we can show a pareto diagram high-
     lighting where the biggest problems are.
     
     In order to accomplish this, we use an UnBuild
     Record object whose sole output is the Name List.
     This identifies the Record fields from the Data
     Set.  The Sequencer build a Record which contains
     additional Records. Each of the additional Records
     contains the results of an individual Sequencer
     transaction.  So, by knowing the names of the
     Sequencer transactios, which are provide by the
     UnBuild Record object, we can extract pass/fail
     information, among other things, from the 
     Sequncer Data Set.  
     
     So, we know names of the record fields we want to
     see.  The question becomes "OK, how do we get the
     pass/fail information out of those fields?"  The 
     expression "rec[*].testName.pass", if used
     in a Get Field object, will tell us that.  "rec"
     is the name of the Sequencer array of Records, 
     gotten from the Data Set, from the Get Field object's
     perspective.  "rec" is its input terminal name,
     so the value it works with is referred to as "rec".
     "rec[*]" means that we want to work with all the
     elements in the array of Records the Sequencer
     stired in a Data Set.
     
     ".testName" specifies that, out of the array of
     Records, we are interested in the record field 
     named "testName".  "testName" would correspond
     to one of the Sequencer transactions executed as 
     part of our test.  If we had three tests, for
     example, we would want to look at:
     
     	rec[*].test1
     	rec[*].test2
     	rec[*].test3
     
     Knowing that the testName field is a record
     that contains fields representing individual
     parts of the tests (i.e. pass/fail, nominal
     specs, etc.), the expression
     
     	rec[*].test1.pass
     
     would give us the contents of the field pass
     for each test1 in the array of Records.
     
     Now, we can say that we know how many tests are
     in the Sequencer Data Set (by using the UnBuild
     Record object tied to a formula that uses the 
     "totsize()" function).  The number returned from
     "totsize()" tells us how many elements are in the
     input array, in this case, it tells us how many
     tests the Sequencer contained.
     
     We dirve a for/range box with the output from 
     "totsize()".  This lets us pick out, one at a
     time, the fields we want to examine from the
     Sequencer record.  The formula a[b], where
     a is the array of Sequencer test names and b is
     driven by the for/range will pull one test 
     name at a time from our Record.  The "to string"
     object has the transaction:
     
     "WRITE TEXT "rec[*].",a,".pass" EOL
     
     The input to our "to string' is the output of
     the formula "a[b]".  We said abobe that the
     formula gives us one name at a time.  So,
     on each successive iteratio of the for/range,
     the output from the "to string" is:
     
     	rec[*].test1.pass
     	rec[*].test2.pass
     	rec[*].test3.pass
     	...
     
     until we have no more test names.
     
     This is the method we use to build the string
     that tells our "get field" object which parts
     of the record we want.  
     
     The "get field" returns an array having the 
     same number of elements as the number of times
     we ran the Sequencer.  The interseting thing
     is that the Sequencer returns a 1 in its "pass"
     Record field if the test passed.  If we run
     the output of the "get field' into a sum() box,
     it tells us how many tests passed.  We now have 
     two critical pieces of information:  the number
     of tests we ran (from the totsize() function);
     and the number of tests that passed.  We can cal-
     culate failure rate by dividing the number of 
     tests less the number tests that passed by the
     total number of tests.  This is don in another
     "to string" object for use in producing a report.
     This gives us the overall results.
     
     The "to string" objects labeled "Overall Test
     Results" and "Individual Test Results" format
     the information we recovered into an end-of-test
     report.
     
     The Pareto diagram is one of the User Objects
     we provide when you select "Merge ..." from 
     the File menu.
    )
    (interface
     (sequence in)
     (sequence out)
     (input 1
      (type data)
      (name "A")
      (optional yes)
     )
    )
    (implementation
     (locked no)
     (trigMode deg)
     (nextID 2)
     (component 0 "CONTEXT"
      (name "Analyze")
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "file Name")
        (optional yes)
       )
       (output 1
        (type data)
        (name "X")
        (lock constraints)
        (optional yes)
       )
       (output 2
        (type data)
        (name "Y")
        (lock constraints)
        (optional yes)
       )
       (output 3
        (type data)
        (name "Z")
        (lock constraints)
        (optional yes)
       )
      )
      (implementation
       (locked no)
       (trigMode deg)
       (nextID 18)
       (component 0 "FROMDATASET"
        (interface
         (sequence in)
         (sequence out)
         (input 1
          (type control)
          (name "File Name")
          (requires
           (datatype Text)
           (shape "Scalar")
          )
          (lock name constraints)
          (optional yes)
         )
         (output 1
          (type data)
          (name "Rec")
          (tag "records")
          (lock constraints)
         )
        )
        (implementation
         (attr iopath file read "/usr/lib/veetest/examples/mfgtest/demodata.dat"
          (readTerm "\n")
          (fs " ")
          (eol "\n")
          (multiField fullSyntax)
          (arrayFormat block)
         )
         (component readRecs all)
         (component expr 1 "1")
        )
        (views
         (icon
          (origin 277 68)
          (extent 127 25)
         )
         (detail
          (origin 316 263)
          (extent 229 134)
         )
         (terminals on)
         (active icon)
        )
       )
       (component 1 "FORRANGE"
        (name "DUT counter")
        (interface
         (sequence in)
         (sequence out)
         (input 1
          (type data)
          (name "Thru")
          (tag "Thru")
          (requires
           (datatype Real)
           (shape "Scalar")
          )
          (lock constraints)
          (optional yes)
          (buffer YES)
         )
         (output 1
          (type data)
          (name "Data")
          (lock name constraints)
         )
        )
        (implementation
         (component from 1)
         (component thru 3)
         (component step 1)
        )
        (views
         (icon
          (extent 110 0)
          (iconImage "loop.icon")
         )
         (detail
          (origin 345 157)
          (extent 171 86)
         )
         (active detail)
        )
       )
       (component 2 "FORMULA"
        (interface
         (sequence in)
         (sequence out)
         (input 1
          (type data)
          (name "A")
          (optional yes)
         )
         (input 2
          (type data)
          (name "B")
          (optional yes)
         )
         (output 1
          (type data)
          (name "Result")
          (lock name constraints)
         )
        )
        (implementation
         (component isLocked no)
         (component expr 1 "a[b]")
        )
        (views
         (icon
          (iconImage "formula.icon")
         )
         (detail
          (origin 580 200)
          (extent 80 61)
         )
         (title off)
         (active detail)
        )
       )
       (component 3 "FROMRECORD"
        (interface
         (sequence in)
         (sequence out)
         (input 1
          (type data)
          (name "Record Data")
          (requires
           (datatype Record)
          )
          (lock name constraints)
         )
         (output 1
          (type data)
          (name "Name List")
          (tag "Name List")
          (lock name constraints)
          (optional yes)
         )
        )
        (implementation
        )
        (views
         (icon
          (origin 592 48)
          (extent 136 64)
          (iconImage "unbuild.icon")
         )
         (detail
          (origin 790 264)
          (extent 6 132)
         )
         (terminals on)
         (active icon)
        )
       )
       (component 4 "FORMULA"
        (interface
         (sequence in)
         (sequence out)
         (input 1
          (type data)
          (name "A")
          (optional yes)
         )
         (output 1
          (type data)
          (name "Result")
          (lock name constraints)
         )
        )
        (implementation
         (component isLocked no)
         (component expr 1 "totsize(a)-1")
        )
        (views
         (icon
          (iconImage "formula.icon")
         )
         (detail
          (origin 779 59)
          (extent 142 62)
         )
         (title off)
         (active detail)
        )
       )
       (component 5 "TOSTRING"
        (interface
         (sequence in)
         (sequence out)
         (input 1
          (type data)
          (name "A")
          (optional yes)
         )
         (output 1
          (type data)
          (name "result")
          (lock name constraints)
         )
        )
        (implementation
         (attr iopath string write "string"
          (readTerm "\n")
          (fs " ")
          (eol "\n")
          (multiField fullSyntax)
          (arrayFormat block)
         )
         (procedure
           WRITE TEXT "rec[*].",a,".pass" EOL
         )
        )
        (views
         (icon
          (origin 535 328)
          (extent 110 25)
         )
         (detail
          (origin 325 361)
          (extent 310 39)
         )
         (active detail)
        )
       )
       (component 6 "TOSTRING"
        (interface
         (sequence in)
         (sequence out)
         (input 1
          (type data)
          (name "A")
          (optional yes)
         )
         (input 2
          (type data)
          (name "B")
          (optional yes)
         )
         (output 1
          (type data)
          (name "result")
          (lock name constraints)
         )
        )
        (implementation
         (attr iopath string write "string"
          (readTerm "\n")
          (fs " ")
          (eol "\n")
          (multiField fullSyntax)
          (arrayFormat block)
         )
         (procedure
           WRITE TEXT "rec[",b,"].",a,".name" EOL
         )
        )
        (views
         (icon
          (origin 275 628)
          (extent 110 25)
         )
         (detail
          (origin 294 539)
          (extent 393 42)
         )
         (active detail)
        )
       )
       (component 7 "FORMULA"
        (name "Get Field")
        (interface
         (sequence in)
         (sequence out)
         (input 1
          (type data)
          (name "Rec")
          (optional yes)
         )
         (input 2
          (type control)
          (name "Formula")
          (tag "Formula")
          (requires
           (datatype Text)
           (shape "Scalar")
          )
          (lock name constraints)
          (optional yes)
         )
         (output 1
          (type data)
          (name "Result")
          (lock name constraints)
         )
        )
        (implementation
         (component isLocked no)
         (component expr 1 "rec[3].readDcv.name")
        )
        (views
         (icon
          (origin 455 588)
          (extent 110 64)
          (iconImage "formula.icon")
         )
         (detail
          (origin 704 475)
          (extent 253 31)
         )
         (active detail)
        )
       )
       (component 8 "FORMULA"
        (name "Get Field")
        (interface
         (sequence in)
         (sequence out)
         (input 1
          (type data)
          (name "Rec")
          (optional yes)
         )
         (input 2
          (type control)
          (name "Formula")
          (tag "Formula")
          (requires
           (datatype Text)
           (shape "Scalar")
          )
          (lock name constraints)
          (optional yes)
         )
         (output 1
          (type data)
          (name "Result")
          (lock name constraints)
         )
        )
        (implementation
         (component isLocked no)
         (component expr 1 "rec[*].readDcv.pass")
        )
        (views
         (icon
          (origin 695 318)
          (extent 110 64)
          (iconImage "formula.icon")
         )
         (detail
          (origin 719 352)
          (extent 263 57)
         )
         (active detail)
        )
       )
       (component 9 "FORMULA"
        (interface
         (sequence in)
         (sequence out)
         (input 1
          (type data)
          (name "A")
          (optional yes)
         )
         (output 1
          (type data)
          (name "Result")
          (lock name constraints)
         )
        )
        (implementation
         (component isLocked no)
         (component expr 1 "totsize(a)")
        )
        (views
         (icon
          (iconImage "formula.icon")
         )
         (detail
          (origin 1048 209)
          (extent 124 62)
         )
         (title off)
         (active detail)
        )
       )
       (component 10 "TOSTRING"
        (interface
         (sequence in)
         (sequence out)
         (input 1
          (type data)
          (name "A")
          (optional yes)
         )
         (input 2
          (type data)
          (name "B")
          (requires
           (datatype Real)
          )
          (optional yes)
         )
         (input 3
          (type data)
          (name "C")
          (requires
           (datatype Real)
          )
          (optional yes)
         )
         (output 1
          (type data)
          (name "result")
          (lock name constraints)
         )
        )
        (implementation
         (attr iopath string write "string"
          (readTerm "\n")
          (fs " ")
          (eol "\n")
          (multiField fullSyntax)
          (arrayFormat block)
         )
         (procedure
           WRITE TEXT a STR FW:20 LJ
           WRITE TEXT c INT FW:3 RJ
           WRITE TEXT b-c INT FW:20 RJ
           WRITE TEXT (b-c)/b*100 REAL STD:6 FW:10 RJ EOL
         )
        )
        (views
         (icon
          (origin 1065 333)
          (extent 110 34)
         )
         (detail
          (origin 632 482)
          (extent 326 154)
         )
         (terminals on)
         (active icon)
        )
       )
       (component 11 "FORMULA"
        (name "Passes")
        (interface
         (sequence in)
         (sequence out)
         (input 1
          (type data)
          (name "X")
          (lock name constraints)
         )
         (output 1
          (type data)
          (name "Result")
          (lock name constraints)
         )
        )
        (implementation
         (component isLocked yes)
         (component expr 1 "sum(x)")
        )
        (views
         (icon
          (origin 1051 148)
          (extent 78 25)
         )
         (detail
          (origin 751 309)
          (extent 88 62)
         )
         (terminals on)
         (active icon)
        )
       )
       (component 12 "ACCUMULATOR"
        (name "Total num tests")
        (interface
         (sequence in)
         (sequence out)
         (input 1
          (type data)
          (name "Data")
          (tag "InData")
          (requires
           (shape "Scalar")
          )
          (lock name constraints)
         )
         (output 1
          (type data)
          (name "Data")
          (tag "accumData")
          (lock name constraints)
         )
        )
        (implementation
         (component clearAtPrerun 1)
         (component clearAtActivate 1)
        )
        (views
         (icon
          (origin 1268 218)
          (extent 145 25)
         )
         (detail
          (origin 757 332)
          (extent 207 36)
         )
         (active icon)
        )
       )
       (component 13 "COLLECTOR"
        (name "Individual Results")
        (interface
         (sequence in)
         (sequence out)
         (input 1
          (type data)
          (name "Data")
          (tag "Data")
         )
         (input 2
          (type trigger)
          (name "XEQ")
          (lock name constraints)
         )
         (output 1
          (type data)
          (name "Array")
          (tag "Array")
          (lock constraints)
         )
        )
        (implementation
         (component clearAtPrerun 1)
         (component clearAtActivate 1)
         (component output1D YES)
        )
        (views
         (icon
          (origin 1454 248)
          (extent 172 25)
         )
         (detail
          (origin 824 703)
          (extent 153 112)
         )
         (terminals on)
         (active icon)
        )
       )
       (component 14 "ACCUMULATOR"
        (name "Num Passes")
        (interface
         (sequence in)
         (sequence out)
         (input 1
          (type data)
          (name "Data")
          (tag "InData")
          (requires
           (shape "Scalar")
          )
          (lock name constraints)
         )
         (output 1
          (type data)
          (name "Data")
          (tag "accumData")
          (lock name constraints)
         )
        )
        (implementation
         (component clearAtPrerun 1)
         (component clearAtActivate 1)
        )
        (views
         (icon
          (origin 1265 128)
          (extent 110 25)
         )
         (detail
          (origin 755 242)
          (extent 171 36)
         )
         (active icon)
        )
       )
       (component 15 "TOSTRING"
        (name "Overall Test Results")
        (interface
         (sequence in)
         (sequence out)
         (input 1
          (type data)
          (name "A")
          (requires
           (datatype Real)
          )
          (optional yes)
         )
         (input 2
          (type data)
          (name "B")
          (requires
           (datatype Real)
          )
          (optional yes)
         )
         (output 1
          (type data)
          (name "result")
          (lock name constraints)
         )
        )
        (implementation
         (attr iopath string write "string"
          (readTerm "\n")
          (fs " ")
          (eol "\n")
          (multiField fullSyntax)
          (arrayFormat block)
         )
         (procedure
           WRITE TEXT "Total Number of Tests: " STR FW:30 LJ
           WRITE TEXT a INT FW:5 RJ EOL
           WRITE TEXT "Total Number of Tests Passed: " STR FW:30 LJ
           WRITE TEXT b INT FW:5 RJ EOL
           WRITE TEXT "Total Number of Tests Failed:" STR FW:30 LJ
           WRITE TEXT a-b INT FW:5 RJ EOL
           WRITE TEXT "Percent Failures:" STR FW:30 LJ
           WRITE TEXT (a-b)/a*100 REAL STD:4 FW:5 RJ EOL
         )
        )
        (views
         (icon
          (origin 1415 78)
          (extent 190 25)
         )
         (detail
          (origin 751 627)
          (extent 298 107)
         )
         (terminals on)
         (active icon)
        )
       )
       (component 16 "FORMULA"
        (name " - ")
        (interface
         (sequence in)
         (sequence out)
         (input 1
          (type data)
          (name "X")
          (lock name constraints)
         )
         (input 2
          (type data)
          (name "Y")
          (lock name constraints)
         )
         (output 1
          (type data)
          (name "Result")
          (lock name constraints)
         )
        )
        (implementation
         (component isLocked yes)
         (component expr 1 "X-Y")
        )
        (views
         (icon
          (origin 1247 288)
          (extent 46 25)
         )
         (detail
         )
         (terminals on)
         (active icon)
        )
       )
       (component 17 "COLLECTOR"
        (name "num passes per DUT")
        (interface
         (sequence in)
         (sequence out)
         (input 1
          (type data)
          (name "Data")
          (tag "Data")
         )
         (input 2
          (type trigger)
          (name "XEQ")
          (lock name constraints)
         )
         (output 1
          (type data)
          (name "Array")
          (tag "Array")
          (lock constraints)
         )
        )
        (implementation
         (component clearAtPrerun 1)
         (component clearAtActivate 1)
         (component output1D NO)
        )
        (views
         (icon
          (origin 1444 358)
          (extent 172 25)
         )
         (detail
          (origin 879 424)
          (extent 153 112)
         )
         (terminals on)
         (active icon)
        )
       )
       (configuration
        (connect I1:1 D0:1)
        (connect D4:1 D1:1)
        (connect D3:1 D2:1)
        (connect D1:1 D2:2)
        (connect D0:1 D3:1)
        (connect D3:1 D4:1)
        (connect D2:1 D5:1)
        (connect D2:1 D6:1)
        (connect D1:1 D6:2)
        (connect D6:0 D7:0)
        (connect D0:1 D7:1)
        (connect D6:1 D7:2)
        (connect D5:0 D8:0)
        (connect D0:1 D8:1)
        (connect D5:1 D8:2)
        (connect D8:1 D9:1)
        (connect D7:1 D10:1)
        (connect D9:1 D10:2)
        (connect D11:1 D10:3)
        (connect D8:1 D11:1)
        (connect D9:1 D12:1)
        (connect D10:1 D13:1)
        (connect D1:0 D13:2)
        (connect D11:1 D14:1)
        (connect D1:0 D15:0)
        (connect D12:1 D15:1)
        (connect D14:1 D15:2)
        (connect D9:1 D16:1)
        (connect D11:1 D16:2)
        (connect D16:1 D17:1)
        (connect D1:0 D17:2)
        (connect D15:1 O1:1)
        (connect D13:1 O2:1)
        (connect D17:1 O3:1)
       )
      )
      (views
       (icon
        (origin 291 413)
        (extent 78 34)
       )
       (detail
        (origin 240 233)
        (extent 830 434)
        (configuration
         (connect I1:1 D0:1
          (Point 242 460)
          (Point 260 460)
          (Point 260 80)
          (Point 274 80)
         )
         (connect D4:1 D1:1
          (Point 923 90)
          (Point 930 90)
          (Point 930 290)
          (Point 330 290)
          (Point 330 200)
          (Point 342 200)
         )
         (connect D3:1 D2:1
          (Point 730 80)
          (Point 740 80)
          (Point 740 120)
          (Point 570 120)
          (Point 570 210)
          (Point 577 210)
         )
         (connect D1:1 D2:2
          (Point 518 200)
          (Point 530 200)
          (Point 530 250)
          (Point 577 250)
         )
         (connect D0:1 D3:1
          (Point 406 80)
          (Point 589 80)
         )
         (connect D3:1 D4:1
          (Point 730 80)
          (Point 740 80)
          (Point 740 90)
          (Point 776 90)
         )
         (connect D2:1 D5:1
          (Point 662 230)
          (Point 680 230)
          (Point 680 280)
          (Point 300 280)
          (Point 300 380)
          (Point 322 380)
         )
         (connect D2:1 D6:1
          (Point 662 230)
          (Point 680 230)
          (Point 680 280)
          (Point 300 280)
          (Point 300 380)
          (Point 290 380)
          (Point 290 470)
          (Point 260 470)
          (Point 260 550)
          (Point 291 550)
         )
         (connect D1:1 D6:2
          (Point 518 200)
          (Point 530 200)
          (Point 530 250)
          (Point 540 250)
          (Point 540 270)
          (Point 280 270)
          (Point 280 570)
          (Point 291 570)
         )
         (connect D6:0 D7:0
          (Point 490 583)
          (Point 490 600)
          (Point 270 600)
          (Point 270 430)
          (Point 830 430)
          (Point 830 444)
         )
         (connect D0:1 D7:1
          (Point 406 80)
          (Point 580 80)
          (Point 580 130)
          (Point 690 130)
          (Point 690 360)
          (Point 680 360)
          (Point 680 480)
          (Point 701 480)
         )
         (connect D6:1 D7:2
          (Point 689 560)
          (Point 710 560)
          (Point 710 520)
          (Point 690 520)
          (Point 690 500)
          (Point 701 500)
         )
         (connect D5:0 D8:0
          (Point 480 402)
          (Point 480 420)
          (Point 670 420)
          (Point 670 300)
          (Point 850 300)
          (Point 850 321)
         )
         (connect D0:1 D8:1
          (Point 406 80)
          (Point 580 80)
          (Point 580 130)
          (Point 690 130)
          (Point 690 360)
          (Point 716 360)
         )
         (connect D5:1 D8:2
          (Point 637 380)
          (Point 660 380)
          (Point 660 400)
          (Point 716 400)
         )
         (connect D8:1 D9:1
          (Point 984 380)
          (Point 1030 380)
          (Point 1030 240)
          (Point 1045 240)
         )
         (connect D7:1 D10:1
          (Point 959 490)
          (Point 1040 490)
          (Point 1040 340)
          (Point 1062 340)
         )
         (connect D9:1 D10:2
          (Point 1174 240)
          (Point 1180 240)
          (Point 1180 290)
          (Point 1050 290)
          (Point 1050 350)
          (Point 1062 350)
         )
         (connect D11:1 D10:3
          (Point 1131 160)
          (Point 1140 160)
          (Point 1140 190)
          (Point 1020 190)
          (Point 1020 360)
          (Point 1062 360)
         )
         (connect D8:1 D11:1
          (Point 984 380)
          (Point 1030 380)
          (Point 1030 160)
          (Point 1048 160)
         )
         (connect D9:1 D12:1
          (Point 1174 240)
          (Point 1180 240)
          (Point 1180 230)
          (Point 1265 230)
         )
         (connect D10:1 D13:1
          (Point 1177 350)
          (Point 1190 350)
          (Point 1190 300)
          (Point 1250 300)
          (Point 1250 280)
          (Point 1350 280)
          (Point 1350 250)
          (Point 1451 250)
         )
         (connect D1:0 D13:2
          (Point 430 245)
          (Point 430 260)
          (Point 550 260)
          (Point 550 270)
          (Point 1000 270)
          (Point 1000 370)
          (Point 1050 370)
          (Point 1050 380)
          (Point 1430 380)
          (Point 1430 270)
          (Point 1451 270)
         )
         (connect D11:1 D14:1
          (Point 1131 160)
          (Point 1140 160)
          (Point 1140 140)
          (Point 1262 140)
         )
         (connect D1:0 D15:0
          (Point 430 245)
          (Point 430 260)
          (Point 550 260)
          (Point 550 270)
          (Point 1000 270)
          (Point 1000 370)
          (Point 1050 370)
          (Point 1050 380)
          (Point 1430 380)
          (Point 1430 270)
          (Point 1440 270)
          (Point 1440 70)
          (Point 1510 70)
          (Point 1510 75)
         )
         (connect D12:1 D15:1
          (Point 1415 230)
          (Point 1430 230)
          (Point 1430 220)
          (Point 1420 220)
          (Point 1420 90)
          (Point 1400 90)
          (Point 1400 80)
          (Point 1412 80)
         )
         (connect D14:1 D15:2
          (Point 1377 140)
          (Point 1390 140)
          (Point 1390 100)
          (Point 1412 100)
         )
         (connect D9:1 D16:1
          (Point 1174 240)
          (Point 1180 240)
          (Point 1180 290)
          (Point 1244 290)
         )
         (connect D11:1 D16:2
          (Point 1131 160)
          (Point 1140 160)
          (Point 1140 140)
          (Point 1230 140)
          (Point 1230 310)
          (Point 1244 310)
         )
         (connect D16:1 D17:1
          (Point 1295 300)
          (Point 1310 300)
          (Point 1310 360)
          (Point 1441 360)
         )
         (connect D1:0 D17:2
          (Point 430 245)
          (Point 430 260)
          (Point 550 260)
          (Point 550 270)
          (Point 1000 270)
          (Point 1000 370)
          (Point 1050 370)
          (Point 1050 380)
          (Point 1441 380)
         )
         (connect D15:1 O1:1
          (Point 1607 90)
          (Point 1640 90)
          (Point 1640 330)
          (Point 1260 330)
          (Point 1260 320)
          (Point 1060 320)
          (Point 1060 310)
          (Point 1067 310)
         )
         (connect D13:1 O2:1
          (Point 1628 260)
          (Point 1650 260)
          (Point 1650 400)
          (Point 1060 400)
          (Point 1060 460)
          (Point 1067 460)
         )
         (connect D17:1 O3:1
          (Point 1618 370)
          (Point 1630 370)
          (Point 1630 390)
          (Point 1540 390)
          (Point 1540 380)
          (Point 1520 380)
          (Point 1520 390)
          (Point 1050 390)
          (Point 1050 610)
          (Point 1067 610)
         )
        )
        (stackingOrder 2 4 9 16 10 5 8 1 7 6
          14 12 15 13 17 0 3 11)
       )
       (terminals on)
       (active icon)
      )
     )
     (component 1 "CONTEXT"
      (name "Display")
      (interface
       (sequence in)
       (sequence out)
       (input 1
        (type data)
        (name "A")
        (optional yes)
       )
       (input 2
        (type data)
        (name "B")
        (optional yes)
       )
       (input 3
        (type data)
        (name "C")
        (optional yes)
       )
      )
      (implementation
       (locked no)
       (trigMode deg)
       (nextID 10)
       (component 0 "TOSTRING"
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "result")
          (lock name constraints)
         )
        )
        (implementation
         (attr iopath string write "string"
          (readTerm "\n")
          (fs " ")
          (eol "\n")
          (multiField fullSyntax)
          (arrayFormat block)
         )
         (procedure
           WRITE TEXT "                   Individual Test Results" EOL
           WRITE TEXT "-----------------------------------------------------" EOL
           WRITE TEXT "Test" STR FW:15 LJ
           WRITE TEXT "Number Passed" STR FW:10 LJ
           WRITE TEXT "Number Failed" STR FW:18 RJ
           WRITE TEXT "%Fail" STR FW:7 RJ EOL
           WRITE TEXT "-----------------------------------------------------" EOL
         )
        )
        (views
         (icon
          (origin 235 198)
          (extent 110 25)
         )
         (detail
          (origin 96 187)
          (extent 308 107)
         )
         (terminals on)
         (active icon)
        )
       )
       (component 1 "JUNCTION"
        (name "JCT")
        (interface
         (input 1
          (type data)
          (name "A")
          (lock name constraints)
         )
         (input 2
          (type data)
          (name "B")
          (lock name constraints)
         )
         (output 1
          (type data)
          (name "Data")
          (lock name constraints)
         )
        )
        (implementation
        )
        (views
         (icon
          (origin 417 238)
          (extent 46 25)
         )
         (detail
         )
         (terminals on)
         (active icon)
        )
       )
       (component 2 "SCROLLINGTEXTDISPLAY"
        (interface
         (sequence in)
         (sequence out)
         (input 1
          (type data)
          (name "Data")
         )
        )
        (implementation
         (component clearAtPrerun 1)
         (component clearAtActivate 1)
        )
        (views
         (icon
         )
         (detail
          (origin 520 159)
          (extent 560 182)
          (bufferSize 256)
         )
         (title off)
         (active detail)
        )
       )
       (component 3 "SCROLLINGTEXTDISPLAY"
        (interface
         (sequence in)
         (sequence out)
         (input 1
          (type data)
          (name "Data")
         )
        )
        (implementation
         (component clearAtPrerun 1)
         (component clearAtActivate 1)
        )
        (views
         (icon
         )
         (detail
          (origin 520 349)
          (extent 560 182)
          (bufferSize 256)
         )
         (title off)
         (active detail)
        )
       )
       (component 4 "CONFIRM"
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "Go")
          (lock name constraints)
         )
        )
        (implementation
        )
        (views
         (icon
          (origin 261 762)
          (extent 58 37)
         )
         (detail
         )
         (terminals on)
         (active icon)
        )
       )
       (component 5 "GATE"
        (interface
         (sequence in)
         (sequence out)
         (input 1
          (type data)
          (name "A")
          (tag "InData")
         )
         (output 1
          (type data)
          (name "X")
          (tag "OutData")
          (lock name constraints)
         )
        )
        (implementation
        )
        (views
         (icon
          (origin 267 258)
          (extent 46 25)
         )
         (detail
         )
         (terminals on)
         (active icon)
        )
       )
       (component 6 "CONTEXT"
        (name "Pareto Chart Display")
        (description 25 9
         Generates and displays a bar chart using the 1-D
         array input data.  The number of bars is fixed
         at 10; the first 9 bars represent the largest
         input values, and the 10th bar represents all
         other inputs.  The "length" of each bar is set
         by the corresponding element value, which should
         be a positive real or int32 number.
         
         The display is pre-autoscaled before plotting,
         using the calculated pareto data values.
         
         The display and data labels, bar color, grid type,
         etc. can be set by clicking the Right Button over
         the display area and selecting the "Traces and
         Scales" entry from the resulting menu.  The gap
         between bars can be set using the "Spacing" box
         in the Detail view.
         
         It may prove useful to Secure the BarChart User
         Object after customizing, since this eliminates
         the Panel/Detail buttons and some menu selections
         that are no longer needed.  Be sure to save the
         unsecured object so you can make changes at a
         later date, however.
         
        )
        (interface
         (sequence in)
         (sequence out)
         (input 1
          (type data)
          (name "Ary")
          (requires
           (shape "Array 1D")
          )
          (optional yes)
         )
        )
        (implementation
         (locked no)
         (trigMode deg)
         (nextID 31)
         (component 0 "JUNCTION"
          (name "JCT")
          (interface
           (input 1
            (type data)
            (name "A")
            (lock name constraints)
           )
           (input 2
            (type data)
            (name "B")
            (lock name constraints)
           )
           (input 3
            (type data)
            (name "C")
            (optional yes)
           )
           (output 1
            (type data)
            (name "Data")
            (lock name constraints)
           )
          )
          (implementation
          )
          (views
           (icon
            (origin 567 453)
            (extent 46 34)
           )
           (detail
           )
           (terminals on)
           (active icon)
          )
         )
         (component 1 "JUNCTION"
          (name "JCT")
          (interface
           (input 1
            (type data)
            (name "A")
            (lock name constraints)
           )
           (input 2
            (type data)
            (name "B")
            (lock name constraints)
           )
           (input 3
            (type data)
            (name "C")
            (optional yes)
           )
           (output 1
            (type data)
            (name "Data")
            (lock name constraints)
           )
          )
          (implementation
          )
          (views
           (icon
            (origin 567 383)
            (extent 46 34)
           )
           (detail
           )
           (terminals on)
           (active icon)
          )
         )
         (component 2 "YPLOT"
          (name "XY Trace")
          (subType "XY_Trace")
          (interface
           (sequence in)
           (sequence out)
           (input 1
            (type data)
            (name "Ranking")
            (lock constraints)
           )
           (input 2
            (type data)
            (name "Accum %")
            (lock constraints)
            (optional yes)
           )
           (input 3
            (type control)
            (name "Auto Scale")
            (lock name constraints)
            (optional yes)
           )
           (input 4
            (type control)
            (name "Next Curve")
            (lock name constraints)
            (optional yes)
           )
          )
          (implementation
           (component clearAtPrerun 1)
           (component clearAtActivate 0)
           (component tracePin 1)
           (component tracePin 2)
           (component graphMode rectangular)
          )
          (views
           (icon
            (extent 110 0)
            (iconImage "display.icon")
           )
           (detail
            (origin 637 372)
            (extent 327 277)
            (displayMode scrollGraph)
            (graphType cartesian)
            (gridType frame)
            (scale 0
             (name "")
             (domainName "")
             (pen 1)
             (show 1)
             (range 0 3 4 linear)
            )
            (scale 1
             (name "%")
             (domainName "X name")
             (pen 1)
             (show 1)
             (range 0 100 4 linear)
            )
            (domain 0 10 4 linear)
            (trace 0 onScale 0
             (name "Ranking")
             (pen 7)
             (lineType 1)
             (pointType 6)
            )
            (trace 1 onScale 1
             (name "Accum %")
             (pen 4)
             (lineType 1)
             (pointType 0)
            )
           )
           (active detail)
          )
         )
         (component 3 "GATE"
          (interface
           (sequence in)
           (sequence out)
           (input 1
            (type data)
            (name "A")
            (tag "InData")
           )
           (output 1
            (type data)
            (name "X")
            (tag "OutData")
            (lock name constraints)
           )
          )
          (implementation
          )
          (views
           (icon
            (origin 487 468)
            (extent 46 25)
           )
           (detail
           )
           (terminals on)
           (active icon)
          )
         )
         (component 4 "CONTEXT"
          (name "Build Pareto")
          (interface
           (sequence in)
           (sequence out)
           (input 1
            (type data)
            (name "Ary")
            (optional yes)
           )
           (output 1
            (type data)
            (name "Rank")
            (lock constraints)
            (optional yes)
           )
           (output 2
            (type data)
            (name "Values")
            (lock constraints)
            (optional yes)
           )
           (output 3
            (type data)
            (name "CumPct")
            (lock constraints)
            (optional yes)
           )
          )
          (implementation
           (locked no)
           (trigMode deg)
           (nextID 9)
           (component 0 "FORMULA"
            (name "Sort Descending")
            (interface
             (sequence in)
             (sequence out)
             (input 1
              (type data)
              (name "A")
              (requires
               (datatype Coord)
              )
              (optional yes)
             )
             (output 1
              (type data)
              (name "Result")
              (lock name constraints)
             )
            )
            (implementation
             (component isLocked no)
             (component expr 1 "sort(a,0)")
            )
            (views
             (icon
              (origin 308 318)
              (extent 145 25)
             )
             (detail
              (origin 308 300)
              (extent 115 60)
             )
             (terminals on)
             (active icon)
            )
           )
           (component 1 "FORMULA"
            (name "a[0:8]")
            (interface
             (sequence in)
             (sequence out)
             (input 1
              (type data)
              (name "A")
              (optional yes)
             )
             (output 1
              (type data)
              (name "Result")
              (lock name constraints)
             )
            )
            (implementation
             (component isLocked no)
             (component expr 1 "a[0:8]")
            )
            (views
             (icon
              (origin 481 318)
              (extent 78 25)
             )
             (detail
              (origin 341 310)
              (extent 88 60)
             )
             (terminals on)
             (active icon)
            )
           )
           (component 2 "FROMCOORDINATE"
            (interface
             (sequence in)
             (sequence out)
             (input 1
              (type data)
              (name "Coord Data")
              (requires
               (datatype Coord)
              )
              (lock name constraints)
             )
             (output 1
              (type data)
              (name "X Data")
              (lock name constraints)
             )
             (output 2
              (type data)
              (name "Y Data")
              (lock name constraints)
              (optional yes)
             )
            )
            (implementation
            )
            (views
             (icon
              (origin 587 298)
              (extent 127 64)
              (iconImage "unbuild.icon")
             )
             (detail
             )
             (terminals on)
             (active icon)
            )
           )
           (component 3 "FORMULA"
            (name "[a other]")
            (interface
             (sequence in)
             (sequence out)
             (input 1
              (type data)
              (name "A")
              (optional yes)
             )
             (input 2
              (type data)
              (name "B")
              (optional yes)
             )
             (output 1
              (type data)
              (name "Result")
              (lock name constraints)
             )
            )
            (implementation
             (component isLocked no)
             (component expr 1 "concat(A,B-sum(A))")
            )
            (views
             (icon
              (origin 615 388)
              (extent 110 25)
             )
             (detail
              (origin 350 188)
              (extent 250 104)
             )
             (terminals on)
             (active icon)
            )
           )
           (component 4 "FORMULA"
            (name "percent")
            (interface
             (sequence in)
             (sequence out)
             (input 1
              (type data)
              (name "A")
              (optional yes)
             )
             (input 2
              (type data)
              (name "B")
              (optional yes)
             )
             (output 1
              (type data)
              (name "Result")
              (lock name constraints)
             )
            )
            (implementation
             (component isLocked no)
             (component expr 1 "A/B*100")
            )
            (views
             (icon
              (origin 521 468)
              (extent 78 25)
             )
             (detail
              (origin 557 338)
              (extent 97 104)
             )
             (terminals on)
             (active icon)
            )
           )
           (component 5 "FORMULA"
            (name "sum(x)")
            (interface
             (sequence in)
             (sequence out)
             (input 1
              (type data)
              (name "X")
              (lock name constraints)
             )
             (output 1
              (type data)
              (name "Result")
              (lock name constraints)
             )
            )
            (implementation
             (component isLocked yes)
             (component expr 1 "sum(x)")
            )
            (views
             (icon
              (origin 501 398)
              (extent 78 25)
             )
             (detail
              (origin 291 220)
              (extent 88 60)
             )
             (terminals on)
             (active icon)
            )
           )
           (component 6 "FORMULA"
            (name "Cum. Sum")
            (interface
             (sequence in)
             (sequence out)
             (input 1
              (type data)
              (name "A")
              (optional yes)
             )
             (output 1
              (type data)
              (name "Result")
              (lock name constraints)
             )
            )
            (implementation
             (component isLocked no)
             (component expr 1 "[a[0] sum(a[0:1]) sum(a[0:2]) sum(a[0:3]) sum(a[0:4]) sum(a[0:5]) sum(a[0:6]) sum(a[0:7]) sum(a[0:8])]")
            )
            (views
             (icon
              (origin 375 458)
              (extent 110 25)
             )
             (detail
              (origin -191 450)
              (extent 952 60)
             )
             (terminals on)
             (active icon)
            )
           )
           (component 7 "FORMULA"
            (name "[0 a 100%]")
            (interface
             (sequence in)
             (sequence out)
             (input 1
              (type data)
              (name "A")
              (optional yes)
             )
             (output 1
              (type data)
              (name "Result")
              (lock name constraints)
             )
            )
            (implementation
             (component isLocked no)
             (component expr 1 "concat(0,concat(a,100))")
            )
            (views
             (icon
              (origin 615 468)
              (extent 110 25)
             )
             (detail
              (origin 285 258)
              (extent 241 104)
             )
             (terminals on)
             (active icon)
            )
           )
           (component 8 "FORMULA"
            (name "Min. Size")
            (interface
             (sequence in)
             (sequence out)
             (input 1
              (type data)
              (name "A")
              (optional yes)
             )
             (output 1
              (type data)
              (name "Result")
              (lock name constraints)
             )
            )
            (implementation
             (component isLocked no)
             (component expr 1 "concat(a,[0 0 0 0 0 0 0 0])")
            )
            (views
             (icon
              (origin 325 388)
              (extent 110 25)
             )
             (detail
              (origin 87 200)
              (extent 277 60)
             )
             (terminals on)
             (active icon)
            )
           )
           (configuration
            (connect D8:1 D0:1)
            (connect D0:1 D1:1)
            (connect D1:1 D2:1)
            (connect D2:2 D3:1)
            (connect D5:1 D3:2)
            (connect D6:1 D4:1)
            (connect D5:1 D4:2)
            (connect D8:1 D5:1)
            (connect D2:2 D6:1)
            (connect D4:1 D7:1)
            (connect I1:1 D8:1)
            (connect D2:1 O1:1)
            (connect D3:1 O2:1)
            (connect D7:1 O3:1)
           )
          )
          (views
           (icon
            (origin 241 428)
            (extent 118 65)
           )
           (detail
            (origin 296 272)
            (extent 458 237)
            (configuration
             (connect D8:1 D0:1
              (Point 437 400)
              (Point 450 400)
              (Point 450 360)
              (Point 300 360)
              (Point 300 330)
              (Point 305 330)
             )
             (connect D0:1 D1:1
              (Point 455 330)
              (Point 478 330)
             )
             (connect D1:1 D2:1
              (Point 561 330)
              (Point 584 330)
             )
             (connect D2:2 D3:1
              (Point 716 350)
              (Point 730 350)
              (Point 730 370)
              (Point 600 370)
              (Point 600 390)
              (Point 612 390)
             )
             (connect D5:1 D3:2
              (Point 581 410)
              (Point 612 410)
             )
             (connect D6:1 D4:1
              (Point 487 470)
              (Point 518 470)
             )
             (connect D5:1 D4:2
              (Point 581 410)
              (Point 600 410)
              (Point 600 440)
              (Point 500 440)
              (Point 500 490)
              (Point 518 490)
             )
             (connect D8:1 D5:1
              (Point 437 400)
              (Point 450 400)
              (Point 450 410)
              (Point 498 410)
             )
             (connect D2:2 D6:1
              (Point 716 350)
              (Point 730 350)
              (Point 730 370)
              (Point 600 370)
              (Point 600 380)
              (Point 480 380)
              (Point 480 430)
              (Point 360 430)
              (Point 360 470)
              (Point 372 470)
             )
             (connect D4:1 D7:1
              (Point 601 480)
              (Point 612 480)
             )
             (connect I1:1 D8:1
              (Point 298 400)
              (Point 322 400)
             )
             (connect D2:1 O1:1
              (Point 716 310)
              (Point 737 310)
              (Point 737 320)
              (Point 751 320)
             )
             (connect D3:1 O2:1
              (Point 727 400)
              (Point 751 400)
             )
             (connect D7:1 O3:1
              (Point 727 480)
              (Point 751 480)
             )
            )
            (stackingOrder 0 1 2 3 4 5 6 7 8)
           )
           (terminals on)
           (active icon)
          )
         )
         (component 5 "FORMULA"
          (name "Calculate Bar coords")
          (interface
           (sequence in)
           (sequence out)
           (input 1
            (type data)
            (name "z")
            (optional yes)
           )
           (input 2
            (type data)
            (name "I")
            (optional yes)
           )
           (input 3
            (type data)
            (name "A")
            (optional yes)
           )
           (output 1
            (type data)
            (name "Result")
            (lock name constraints)
           )
          )
          (implementation
           (component isLocked no)
           (component expr 1 "[coord(I+z/2,A[i]) coord(I+1-z/2,A[i])]")
          )
          (views
           (icon
            (origin 325 353)
            (extent 190 34)
           )
           (detail
            (origin 113 143)
            (extent 385 154)
           )
           (terminals on)
           (active icon)
          )
         )
         (component 6 "CONSTANT"
          (name "Spacing")
          (subType "Real")
          (interface
           (sequence in)
           (sequence out)
           (output 1
            (type data)
            (name "Real")
            (lock name constraints)
           )
          )
          (implementation
           (component value Real
            (name "Spacing")
            (datum 0.2)
           )
           (component autoTrigger off)
           (component initializeAtPrerun off)
           (component initializeAtActivate off)
           (component initValue Real
            (name "Real")
            (datum 0)
           )
          )
          (views
           (icon
            (origin 221 348)
            (extent 78 25)
           )
           (detail
            (origin 257 286)
            (extent 147 28)
            (showFormat real)
           )
           (active icon)
          )
         )
         (component 7 "CONTEXT"
          (name "PreScale")
          (interface
           (sequence in)
           (sequence out)
           (input 1
            (type data)
            (name "A")
            (optional yes)
           )
           (output 1
            (type data)
            (name "LL")
            (lock constraints)
            (optional yes)
           )
           (output 2
            (type data)
            (name "UR")
            (lock constraints)
            (optional yes)
           )
           (output 3
            (type data)
            (name "LL")
            (lock constraints)
            (optional yes)
           )
           (output 4
            (type data)
            (name "UR")
            (lock constraints)
            (optional yes)
           )
          )
          (implementation
           (locked no)
           (trigMode deg)
           (nextID 5)
           (component 0 "FORMULA"
            (name "Upper Right")
            (interface
             (sequence in)
             (sequence out)
             (input 1
              (type data)
              (name "A")
              (optional yes)
             )
             (input 2
              (type data)
              (name "xmax")
              (optional yes)
             )
             (output 1
              (type data)
              (name "Result")
              (lock name constraints)
             )
            )
            (implementation
             (component isLocked no)
             (component expr 1 "coord(xmax,max(a))")
            )
            (views
             (icon
              (origin 425 328)
              (extent 110 25)
             )
             (detail
              (origin 312 308)
              (extent 196 104)
             )
             (terminals on)
             (active icon)
            )
           )
           (component 1 "FROMARRAY"
            (interface
             (sequence in)
             (sequence out)
             (input 1
              (type data)
              (name "Ary")
              (tag "Ary")
             )
             (output 1
              (type data)
              (name "SubAry")
              (tag "Result")
              (lock constraints)
             )
             (output 2
              (type data)
              (name "Type")
              (tag "Type")
              (lock constraints)
             )
             (output 3
              (type data)
              (name "NumDims")
              (tag "NumDims")
              (lock constraints)
             )
             (output 4
              (type data)
              (name "DimSizes")
              (tag "DimSizes")
              (lock constraints)
             )
             (output 5
              (type data)
              (name "TotSize")
              (tag "TotSize")
              (lock constraints)
             )
            )
            (implementation
             (component isLocked no)
             (component expr 1 "Ary")
            )
            (views
             (icon
              (origin 405 378)
              (extent 110 64)
              (iconImage "unbuild.icon")
             )
             (detail
             )
             (terminals on)
             (active icon)
            )
           )
           (component 2 "FORMULA"
            (name "Lower Left")
            (interface
             (sequence in)
             (sequence out)
             (input 1
              (type data)
              (name "A")
              (optional yes)
             )
             (output 1
              (type data)
              (name "Result")
              (lock name constraints)
             )
            )
            (implementation
             (component isLocked no)
             (component expr 1 "coord(0,min([min(a) 0]))")
            )
            (views
             (icon
              (origin 425 278)
              (extent 110 25)
             )
             (detail
              (origin 330 368)
              (extent 250 104)
             )
             (terminals on)
             (active icon)
            )
           )
           (component 3 "CONSTANT"
            (name "(0,0)")
            (subType "Coord")
            (interface
             (sequence in)
             (sequence out)
             (output 1
              (type data)
              (name "Coord")
              (lock name constraints)
             )
            )
            (implementation
             (component value Coord
              (name "(0,0)")
              (numCoordDims 2)
              (datum (0,0))
             )
             (component autoTrigger off)
             (component initializeAtPrerun off)
             (component initializeAtActivate off)
             (component initValue Coord
              (name "Coord")
              (numCoordDims 2)
              (datum (0,0))
             )
            )
            (views
             (icon
              (origin 571 378)
              (extent 78 25)
             )
             (detail
              (origin 445 144)
              (extent 130 32)
              (showFormat real)
             )
             (active icon)
            )
           )
           (component 4 "CONSTANT"
            (name "(10,100)")
            (subType "Coord")
            (interface
             (sequence in)
             (sequence out)
             (output 1
              (type data)
              (name "Coord")
              (lock name constraints)
             )
            )
            (implementation
             (component value Coord
              (name "(10,100)")
              (numCoordDims 2)
              (datum (10,100))
             )
             (component autoTrigger off)
             (component initializeAtPrerun off)
             (component initializeAtActivate off)
             (component initValue Coord
              (name "Coord")
              (numCoordDims 2)
              (datum (0,0))
             )
            )
            (views
             (icon
              (origin 535 428)
              (extent 110 25)
             )
             (detail
              (origin 332 364)
              (extent 156 32)
              (showFormat real)
             )
             (active icon)
            )
           )
           (configuration
            (connect D2:0 D0:0)
            (connect I1:1 D0:1)
            (connect D1:5 D0:2)
            (connect I1:1 D1:1)
            (connect I1:1 D2:1)
            (connect D2:1 O1:1)
            (connect D0:1 O2:1)
            (connect D3:1 O3:1)
            (connect D4:1 O4:1)
           )
          )
          (views
           (icon
            (origin 415 398)
            (extent 110 45)
           )
           (detail
            (origin 376 258)
            (extent 288 205)
            (configuration
             (connect D2:0 D0:0
              (Point 480 305)
              (Point 480 325)
             )
             (connect I1:1 D0:1
              (Point 378 370)
              (Point 390 370)
              (Point 390 330)
              (Point 422 330)
             )
             (connect D1:5 D0:2
              (Point 517 430)
              (Point 530 430)
              (Point 530 370)
              (Point 410 370)
              (Point 410 350)
              (Point 422 350)
             )
             (connect I1:1 D1:1
              (Point 378 370)
              (Point 390 370)
              (Point 390 410)
              (Point 402 410)
             )
             (connect I1:1 D2:1
              (Point 378 370)
              (Point 390 370)
              (Point 390 290)
              (Point 422 290)
             )
             (connect D2:1 O1:1
              (Point 537 290)
              (Point 661 290)
             )
             (connect D0:1 O2:1
              (Point 537 340)
              (Point 661 340)
             )
             (connect D3:1 O3:1
              (Point 651 390)
              (Point 661 390)
             )
             (connect D4:1 O4:1
              (Point 647 440)
              (Point 661 440)
             )
            )
            (stackingOrder 0 1 2 3 4)
           )
           (terminals on)
           (active icon)
          )
         )
         (component 8 "FORMULA"
          (name "a[0]")
          (interface
           (sequence in)
           (sequence out)
           (input 1
            (type data)
            (name "A")
            (optional yes)
           )
           (output 1
            (type data)
            (name "Result")
            (lock name constraints)
           )
          )
          (implementation
           (component isLocked no)
           (component expr 1 "a[0]")
          )
          (views
           (icon
            (origin 248 654)
            (extent 46 25)
           )
           (detail
            (origin 398 515)
            (extent 75 51)
           )
           (terminals on)
           (active icon)
          )
         )
         (component 9 "TEXTDISPLAY"
          (name "0")
          (interface
           (sequence in)
           (sequence out)
           (input 1
            (type data)
            (name "Data")
           )
          )
          (implementation
           (component clearAtPrerun 1)
           (component clearAtActivate 1)
          )
          (views
           (icon
            (origin 318 654)
            (extent 46 25)
           )
           (detail
            (origin 371 522)
            (extent 158 36)
           )
           (active icon)
          )
         )
         (component 10 "FORMULA"
          (name "a[1]")
          (interface
           (sequence in)
           (sequence out)
           (input 1
            (type data)
            (name "A")
            (optional yes)
           )
           (output 1
            (type data)
            (name "Result")
            (lock name constraints)
           )
          )
          (implementation
           (component isLocked no)
           (component expr 1 "a[1]")
          )
          (views
           (icon
            (origin 248 694)
            (extent 46 25)
           )
           (detail
            (origin 348 565)
            (extent 75 51)
           )
           (terminals on)
           (active icon)
          )
         )
         (component 11 "TEXTDISPLAY"
          (name "1")
          (interface
           (sequence in)
           (sequence out)
           (input 1
            (type data)
            (name "Data")
           )
          )
          (implementation
           (component clearAtPrerun 1)
           (component clearAtActivate 1)
          )
          (views
           (icon
            (origin 318 694)
            (extent 46 25)
           )
           (detail
            (origin 301 532)
            (extent 158 36)
           )
           (active icon)
          )
         )
         (component 12 "FORMULA"
          (name "a[2]")
          (interface
           (sequence in)
           (sequence out)
           (input 1
            (type data)
            (name "A")
            (optional yes)
           )
           (output 1
            (type data)
            (name "Result")
            (lock name constraints)
           )
          )
          (implementation
           (component isLocked no)
           (component expr 1 "a[2]")
          )
          (views
           (icon
            (origin 248 734)
            (extent 46 25)
           )
           (detail
            (origin 398 535)
            (extent 75 51)
           )
           (terminals on)
           (active icon)
          )
         )
         (component 13 "TEXTDISPLAY"
          (name "2")
          (interface
           (sequence in)
           (sequence out)
           (input 1
            (type data)
            (name "Data")
           )
          )
          (implementation
           (component clearAtPrerun 1)
           (component clearAtActivate 1)
          )
          (views
           (icon
            (origin 318 734)
            (extent 46 25)
           )
           (detail
            (origin 501 522)
            (extent 158 36)
           )
           (active icon)
          )
         )
         (component 14 "FORMULA"
          (name "a[3]")
          (interface
           (sequence in)
           (sequence out)
           (input 1
            (type data)
            (name "A")
            (optional yes)
           )
           (output 1
            (type data)
            (name "Result")
            (lock name constraints)
           )
          )
          (implementation
           (component isLocked no)
           (component expr 1 "a[3]")
          )
          (views
           (icon
            (origin 248 774)
            (extent 46 25)
           )
           (detail
            (origin 558 585)
            (extent 75 51)
           )
           (terminals on)
           (active icon)
          )
         )
         (component 15 "TEXTDISPLAY"
          (name "3")
          (interface
           (sequence in)
           (sequence out)
           (input 1
            (type data)
            (name "Data")
           )
          )
          (implementation
           (component clearAtPrerun 1)
           (component clearAtActivate 1)
          )
          (views
           (icon
            (origin 318 774)
            (extent 46 25)
           )
           (detail
            (origin 330 496)
            (extent 158 36)
           )
           (active icon)
          )
         )
         (component 16 "FORMULA"
          (name "a[4]")
          (interface
           (sequence in)
           (sequence out)
           (input 1
            (type data)
            (name "A")
            (optional yes)
           )
           (output 1
            (type data)
            (name "Result")
            (lock name constraints)
           )
          )
          (implementation
           (component isLocked no)
           (component expr 1 "a[4]")
          )
          (views
           (icon
            (origin 248 814)
            (extent 46 25)
           )
           (detail
            (origin 178 485)
            (extent 75 51)
           )
           (terminals on)
           (active icon)
          )
         )
         (component 17 "TEXTDISPLAY"
          (name "4")
          (interface
           (sequence in)
           (sequence out)
           (input 1
            (type data)
            (name "Data")
           )
          )
          (implementation
           (component clearAtPrerun 1)
           (component clearAtActivate 1)
          )
          (views
           (icon
            (origin 318 814)
            (extent 46 25)
           )
           (detail
            (origin 211 502)
            (extent 158 36)
           )
           (active icon)
          )
         )
         (component 18 "FORMULA"
          (name "a[5]")
          (interface
           (sequence in)
           (sequence out)
           (input 1
            (type data)
            (name "A")
            (optional yes)
           )
           (output 1
            (type data)
            (name "Result")
            (lock name constraints)
           )
          )
          (implementation
           (component isLocked no)
           (component expr 1 "a[5]")
          )
          (views
           (icon
            (origin 408 654)
            (extent 46 25)
           )
           (detail
            (origin 328 335)
            (extent 75 51)
           )
           (terminals on)
           (active icon)
          )
         )
         (component 19 "FORMULA"
          (name "a[6]")
          (interface
           (sequence in)
           (sequence out)
           (input 1
            (type data)
            (name "A")
            (optional yes)
           )
           (output 1
            (type data)
            (name "Result")
            (lock name constraints)
           )
          )
          (implementation
           (component isLocked no)
           (component expr 1 "a[6]")
          )
          (views
           (icon
            (origin 408 694)
            (extent 46 25)
           )
           (detail
            (origin 338 375)
            (extent 75 51)
           )
           (terminals on)
           (active icon)
          )
         )
         (component 20 "FORMULA"
          (name "a[7]")
          (interface
           (sequence in)
           (sequence out)
           (input 1
            (type data)
            (name "A")
            (optional yes)
           )
           (output 1
            (type data)
            (name "Result")
            (lock name constraints)
           )
          )
          (implementation
           (component isLocked no)
           (component expr 1 "a[7]")
          )
          (views
           (icon
            (origin 408 734)
            (extent 46 25)
           )
           (detail
            (origin 328 395)
            (extent 75 51)
           )
           (terminals on)
           (active icon)
          )
         )
         (component 21 "FORMULA"
          (name "a[8]")
          (interface
           (sequence in)
           (sequence out)
           (input 1
            (type data)
            (name "A")
            (optional yes)
           )
           (output 1
            (type data)
            (name "Result")
            (lock name constraints)
           )
          )
          (implementation
           (component isLocked no)
           (component expr 1 "a[8]")
          )
          (views
           (icon
            (origin 408 774)
            (extent 46 25)
           )
           (detail
            (origin 598 475)
            (extent 75 51)
           )
           (terminals on)
           (active icon)
          )
         )
         (component 22 "TEXTDISPLAY"
          (name "8")
          (interface
           (sequence in)
           (sequence out)
           (input 1
            (type data)
            (name "Data")
           )
          )
          (implementation
           (component clearAtPrerun 1)
           (component clearAtActivate 1)
          )
          (views
           (icon
            (origin 488 774)
            (extent 46 25)
           )
           (detail
            (origin 431 422)
            (extent 158 36)
           )
           (active icon)
          )
         )
         (component 23 "TEXTDISPLAY"
          (name "7")
          (interface
           (sequence in)
           (sequence out)
           (input 1
            (type data)
            (name "Data")
           )
          )
          (implementation
           (component clearAtPrerun 1)
           (component clearAtActivate 1)
          )
          (views
           (icon
            (origin 488 734)
            (extent 46 25)
           )
           (detail
            (origin 371 342)
            (extent 158 36)
           )
           (active icon)
          )
         )
         (component 24 "TEXTDISPLAY"
          (name "6")
          (interface
           (sequence in)
           (sequence out)
           (input 1
            (type data)
            (name "Data")
           )
          )
          (implementation
           (component clearAtPrerun 1)
           (component clearAtActivate 1)
          )
          (views
           (icon
            (origin 488 694)
            (extent 46 25)
           )
           (detail
            (origin 591 392)
            (extent 158 36)
           )
           (active icon)
          )
         )
         (component 25 "TEXTDISPLAY"
          (name "5")
          (interface
           (sequence in)
           (sequence out)
           (input 1
            (type data)
            (name "Data")
           )
          )
          (implementation
           (component clearAtPrerun 1)
           (component clearAtActivate 1)
          )
          (views
           (icon
            (origin 488 654)
            (extent 46 25)
           )
           (detail
            (origin 521 392)
            (extent 158 36)
           )
           (active icon)
          )
         )
         (component 26 "FROMARRAY"
          (interface
           (sequence in)
           (sequence out)
           (input 1
            (type data)
            (name "Ary")
            (tag "Ary")
           )
           (output 1
            (type data)
            (name "SubAry")
            (tag "Result")
            (lock constraints)
           )
           (output 2
            (type data)
            (name "Type")
            (tag "Type")
            (lock constraints)
           )
           (output 3
            (type data)
            (name "NumDims")
            (tag "NumDims")
            (lock constraints)
           )
           (output 4
            (type data)
            (name "DimSizes")
            (tag "DimSizes")
            (lock constraints)
           )
           (output 5
            (type data)
            (name "TotSize")
            (tag "TotSize")
            (lock constraints)
           )
          )
          (implementation
           (component isLocked no)
           (component expr 1 "Ary")
          )
          (views
           (icon
            (origin 246 524)
            (extent 110 64)
            (iconImage "unbuild.icon")
           )
           (detail
            (origin 252 110)
            (extent 147 160)
           )
           (terminals on)
           (active icon)
          )
         )
         (component 27 "DO"
          (interface
           (sequence in)
           (sequence out)
           (output 1
            (type data)
            (name "Do")
            (lock name constraints)
           )
          )
          (implementation
          )
          (views
           (icon
            (origin 448 504)
            (extent 46 25)
           )
           (detail
           )
           (terminals on)
           (active icon)
          )
         )
         (component 28 "FORCOUNT"
          (name "For Count")
          (interface
           (sequence in)
           (sequence out)
           (input 1
            (type data)
            (name "Count")
            (tag "Count")
            (requires
             (datatype Int32)
             (shape "Scalar")
            )
            (lock constraints)
            (optional yes)
            (buffer YES)
           )
           (output 1
            (type data)
            (name "Count")
            (lock name constraints)
           )
          )
          (implementation
           (component count 10)
          )
          (views
           (icon
            (origin 416 544)
            (extent 110 64)
            (iconImage "loop.icon")
           )
           (detail
            (origin 445 513)
            (extent 170 34)
           )
           (active icon)
          )
         )
         (component 29 "TEXTDISPLAY"
          (name "Other")
          (interface
           (sequence in)
           (sequence out)
           (input 1
            (type data)
            (name "Data")
           )
          )
          (implementation
           (component clearAtPrerun 1)
           (component clearAtActivate 1)
          )
          (views
           (icon
            (origin 512 814)
            (extent 78 25)
           )
           (detail
            (origin 526 446)
            (extent 129 29)
           )
           (active icon)
          )
         )
         (component 30 "TOSTRING"
          (name "\"Other\"")
          (interface
           (sequence in)
           (sequence out)
           (input 1
            (type data)
            (name "A")
            (optional yes)
           )
           (output 1
            (type data)
            (name "result")
            (lock name constraints)
           )
          )
          (implementation
           (attr iopath string write "string"
            (readTerm "\n")
            (fs " ")
            (eol "\n")
            (multiField fullSyntax)
            (arrayFormat linear)
           )
           (procedure
             WRITE TEXT " other" EOL
           )
          )
          (views
           (icon
            (origin 412 814)
            (extent 78 25)
           )
           (detail
            (origin 288 430)
            (extent 294 60)
           )
           (terminals on)
           (active icon)
          )
         )
         (configuration
          (connect D7:3 D0:1)
          (connect D7:4 D0:2)
          (connect D3:1 D0:3)
          (connect D5:1 D1:1)
          (connect D7:1 D1:2)
          (connect D7:2 D1:3)
          (connect D1:1 D2:1)
          (connect D0:1 D2:2)
          (connect D27:1 D2:3)
          (connect D2:0 D2:4)
          (connect D5:1 D3:0)
          (connect D4:3 D3:1)
          (connect I1:1 D4:1)
          (connect D6:1 D5:1)
          (connect D28:1 D5:2)
          (connect D4:2 D5:3)
          (connect D4:2 D7:1)
          (connect D4:1 D8:1)
          (connect D8:1 D9:1)
          (connect D4:1 D10:1)
          (connect D10:1 D11:1)
          (connect D4:1 D12:1)
          (connect D12:1 D13:1)
          (connect D4:1 D14:1)
          (connect D14:1 D15:1)
          (connect D4:1 D16:1)
          (connect D16:1 D17:1)
          (connect D4:1 D18:1)
          (connect D4:1 D19:1)
          (connect D4:1 D20:1)
          (connect D4:1 D21:1)
          (connect D21:1 D22:1)
          (connect D20:1 D23:1)
          (connect D19:1 D24:1)
          (connect D18:1 D25:1)
          (connect D4:2 D26:1)
          (connect D7:0 D27:0)
          (connect D27:0 D28:0)
          (connect D26:5 D28:1)
          (connect D30:1 D29:1)
          (connect D4:1 D30:1)
         )
        )
        (views
         (icon
          (origin 495 588)
          (extent 190 25)
         )
         (panel
          (origin 422 478)
          (extent 556 364)
          (widget 29 detail
           (title off)
           (origin 874 802)
           (extent 76 36)
          )
          (widget 22 detail
           (title off)
           (origin 832 799)
           (extent 35 39)
          )
          (widget 23 detail
           (title off)
           (origin 789 799)
           (extent 37 40)
          )
          (widget 9 detail
           (title off)
           (origin 519 800)
           (extent 35 39)
          )
          (widget 11 detail
           (title off)
           (origin 560 800)
           (extent 33 39)
          )
          (widget 15 detail
           (title off)
           (origin 639 800)
           (extent 33 39)
          )
          (widget 13 detail
           (title off)
           (origin 600 800)
           (extent 33 38)
          )
          (widget 17 detail
           (title off)
           (origin 679 800)
           (extent 33 39)
          )
          (widget 25 detail
           (title off)
           (origin 716 799)
           (extent 30 40)
          )
          (widget 24 detail
           (title off)
           (origin 750 800)
           (extent 35 39)
          )
          (widget 2 detail
           (title off)
           (origin 424 481)
           (extent 557 313)
           (displayMode annotGraph)
           (graphType cartesian)
           (gridType frame)
           (scale 0
            (name "# Failures")
            (domainName "Test Number")
            (pen 1)
            (show 1)
            (range 0 3 4 linear)
           )
           (scale 1
            (name " %")
            (domainName "")
            (pen 1)
            (show 1)
            (range 0 100 4 linear)
           )
           (domain 0 10 4 linear)
           (trace 0 onScale 0
            (name "Ranking")
            (pen 7)
            (lineType 1)
            (pointType 6)
           )
           (trace 1 onScale 1
            (name "Accum %")
            (pen 4)
            (lineType 1)
            (pointType 0)
           )
          )
         )
         (detail
          (origin 141 334)
          (extent 878 512)
          (configuration
           (connect D7:3 D0:1
            (Point 527 420)
            (Point 551 420)
            (Point 551 460)
            (Point 564 460)
           )
           (connect D7:4 D0:2
            (Point 527 430)
            (Point 541 430)
            (Point 541 470)
            (Point 564 470)
           )
           (connect D3:1 D0:3
            (Point 535 480)
            (Point 564 480)
           )
           (connect D5:1 D1:1
            (Point 517 370)
            (Point 541 370)
            (Point 541 390)
            (Point 564 390)
           )
           (connect D7:1 D1:2
            (Point 527 400)
            (Point 564 400)
           )
           (connect D7:2 D1:3
            (Point 527 410)
            (Point 564 410)
           )
           (connect D1:1 D2:1
            (Point 615 400)
            (Point 634 400)
           )
           (connect D0:1 D2:2
            (Point 615 470)
            (Point 634 470)
           )
           (connect D27:1 D2:3
            (Point 496 516)
            (Point 541 516)
            (Point 541 540)
            (Point 634 540)
           )
           (connect D2:0 D2:4
            (Point 800 651)
            (Point 800 676)
            (Point 611 676)
            (Point 611 610)
            (Point 634 610)
           )
           (connect D5:1 D3:0
            (Point 517 370)
            (Point 541 370)
            (Point 541 386)
            (Point 521 386)
            (Point 521 436)
            (Point 531 436)
            (Point 531 456)
            (Point 510 456)
            (Point 510 465)
           )
           (connect D4:3 D3:1
            (Point 361 480)
            (Point 484 480)
           )
           (connect I1:1 D4:1
            (Point 143 600)
            (Point 151 600)
            (Point 151 460)
            (Point 238 460)
           )
           (connect D6:1 D5:1
            (Point 301 360)
            (Point 322 360)
           )
           (connect D28:1 D5:2
            (Point 528 576)
            (Point 541 576)
            (Point 541 626)
            (Point 211 626)
            (Point 211 396)
            (Point 301 396)
            (Point 301 370)
            (Point 322 370)
           )
           (connect D4:2 D5:3
            (Point 361 460)
            (Point 381 460)
            (Point 381 406)
            (Point 311 406)
            (Point 311 380)
            (Point 322 380)
           )
           (connect D4:2 D7:1
            (Point 361 460)
            (Point 381 460)
            (Point 381 420)
            (Point 412 420)
           )
           (connect D4:1 D8:1
            (Point 361 440)
            (Point 391 440)
            (Point 391 636)
            (Point 231 636)
            (Point 231 666)
            (Point 245 666)
           )
           (connect D8:1 D9:1
            (Point 296 666)
            (Point 315 666)
           )
           (connect D4:1 D10:1
            (Point 361 440)
            (Point 391 440)
            (Point 391 636)
            (Point 231 636)
            (Point 231 706)
            (Point 245 706)
           )
           (connect D10:1 D11:1
            (Point 296 706)
            (Point 315 706)
           )
           (connect D4:1 D12:1
            (Point 361 440)
            (Point 391 440)
            (Point 391 636)
            (Point 231 636)
            (Point 231 746)
            (Point 245 746)
           )
           (connect D12:1 D13:1
            (Point 296 746)
            (Point 315 746)
           )
           (connect D4:1 D14:1
            (Point 361 440)
            (Point 391 440)
            (Point 391 636)
            (Point 231 636)
            (Point 231 786)
            (Point 245 786)
           )
           (connect D14:1 D15:1
            (Point 296 786)
            (Point 315 786)
           )
           (connect D4:1 D16:1
            (Point 361 440)
            (Point 391 440)
            (Point 391 636)
            (Point 231 636)
            (Point 231 826)
            (Point 245 826)
           )
           (connect D16:1 D17:1
            (Point 296 826)
            (Point 315 826)
           )
           (connect D4:1 D18:1
            (Point 361 440)
            (Point 391 440)
            (Point 391 666)
            (Point 405 666)
           )
           (connect D4:1 D19:1
            (Point 361 440)
            (Point 391 440)
            (Point 391 706)
            (Point 405 706)
           )
           (connect D4:1 D20:1
            (Point 361 440)
            (Point 391 440)
            (Point 391 746)
            (Point 405 746)
           )
           (connect D4:1 D21:1
            (Point 361 440)
            (Point 391 440)
            (Point 391 786)
            (Point 405 786)
           )
           (connect D21:1 D22:1
            (Point 456 786)
            (Point 485 786)
           )
           (connect D20:1 D23:1
            (Point 456 746)
            (Point 485 746)
           )
           (connect D19:1 D24:1
            (Point 456 706)
            (Point 485 706)
           )
           (connect D18:1 D25:1
            (Point 456 666)
            (Point 485 666)
           )
           (connect D4:2 D26:1
            (Point 361 460)
            (Point 381 460)
            (Point 381 406)
            (Point 221 406)
            (Point 221 556)
            (Point 243 556)
           )
           (connect D7:0 D27:0
            (Point 470 445)
            (Point 470 473)
            (Point 471 473)
            (Point 471 501)
           )
           (connect D27:0 D28:0
            (Point 471 531)
            (Point 471 541)
           )
           (connect D26:5 D28:1
            (Point 358 576)
            (Point 413 576)
           )
           (connect D30:1 D29:1
            (Point 492 826)
            (Point 509 826)
           )
           (connect D4:1 D30:1
            (Point 361 440)
            (Point 391 440)
            (Point 391 826)
            (Point 409 826)
           )
          )
          (stackingOrder 0 1 3 4 5 6 7 8 9 10
            11 12 13 14 15 16 17 18 19 20
            21 22 23 24 25 26 27 28 29 30
            2)
         )
         (active panel)
         (active panel)
        )
       )
       (component 7 "TOSTRING"
        (interface
         (sequence in)
         (sequence out)
         (output 1
          (type data)
          (name "result")
          (lock name constraints)
         )
        )
        (implementation
         (attr iopath string write "string"
          (readTerm "\n")
          (fs " ")
          (eol "\n")
          (multiField fullSyntax)
          (arrayFormat block)
         )
         (procedure
           WRITE TEXT "                   Overall Test Results" EOL
           WRITE TEXT "-----------------------------------------------------" EOL
         )
        )
        (views
         (icon
          (origin 245 448)
          (extent 110 25)
         )
         (detail
          (origin 166 417)
          (extent 308 107)
         )
         (terminals on)
         (active icon)
        )
       )
       (component 8 "GATE"
        (interface
         (sequence in)
         (sequence out)
         (input 1
          (type data)
          (name "A")
          (tag "InData")
         )
         (output 1
          (type data)
          (name "X")
          (tag "OutData")
          (lock name constraints)
         )
        )
        (implementation
        )
        (views
         (icon
          (origin 277 508)
          (extent 46 25)
         )
         (detail
         )
         (terminals on)
         (active icon)
        )
       )
       (component 9 "JUNCTION"
        (name "JCT")
        (interface
         (input 1
          (type data)
          (name "A")
          (lock name constraints)
         )
         (input 2
          (type data)
          (name "B")
          (lock name constraints)
         )
         (output 1
          (type data)
          (name "Data")
          (lock name constraints)
         )
        )
        (implementation
        )
        (views
         (icon
          (origin 427 488)
          (extent 46 25)
         )
         (detail
         )
         (terminals on)
         (active icon)
        )
       )
       (configuration
        (connect D0:1 D1:1)
        (connect D5:1 D1:2)
        (connect D1:1 D2:1)
        (connect D9:1 D3:1)
        (connect D0:0 D5:0)
        (connect I2:1 D5:1)
        (connect I3:1 D6:1)
        (connect D7:0 D8:0)
        (connect I1:1 D8:1)
        (connect D7:1 D9:1)
        (connect D8:1 D9:2)
       )
       (ShowOnExecPanel
        (origin 5 0)
        (extent 686 752)
        (panel
         (origin 209 138)
         (extent 682 724)
         (widget 6 panel
          (title on)
          (origin 324 492)
          (extent 561 365)
          (widget 29 detail
           (title off)
           (origin 776 816)
           (extent 76 36)
          )
          (widget 22 detail
           (title off)
           (origin 734 813)
           (extent 35 39)
          )
          (widget 23 detail
           (title off)
           (origin 691 813)
           (extent 37 40)
          )
          (widget 9 detail
           (title off)
           (origin 421 814)
           (extent 35 39)
          )
          (widget 11 detail
           (title off)
           (origin 462 814)
           (extent 33 39)
          )
          (widget 15 detail
           (title off)
           (origin 541 814)
           (extent 33 39)
          )
          (widget 13 detail
           (title off)
           (origin 502 814)
           (extent 33 38)
          )
          (widget 17 detail
           (title off)
           (origin 581 814)
           (extent 33 39)
          )
          (widget 25 detail
           (title off)
           (origin 618 813)
           (extent 30 40)
          )
          (widget 24 detail
           (title off)
           (origin 652 814)
           (extent 35 39)
          )
          (widget 2 detail
           (title off)
           (origin 326 495)
           (extent 557 313)
           (displayMode annotGraph)
           (graphType cartesian)
           (gridType frame)
           (scale 0
            (name "# Failures")
            (domainName "Test Number")
            (pen 1)
            (show 1)
            (range 0 3 4 linear)
           )
           (scale 1
            (name " %")
            (domainName "")
            (pen 1)
            (show 1)
            (range 0 100 4 linear)
           )
           (domain 0 10 4 linear)
           (trace 0 onScale 0
            (name "Ranking")
            (pen 7)
            (lineType 1)
            (pointType 6)
           )
           (trace 1 onScale 1
            (name "Accum %")
            (pen 4)
            (lineType 1)
            (pointType 0)
           )
          )
         )
         (widget 2 detail
          (title off)
          (origin 325 315)
          (extent 559 149)
          (bufferSize 256)
         )
         (widget 3 detail
          (title off)
          (origin 325 148)
          (extent 557 160)
          (bufferSize 256)
         )
         (widget 4 icon
          (title off)
          (origin 234 148)
          (extent 69 708)
         )
        )
       )
      )
      (views
       (icon
        (origin 481 413)
        (extent 78 34)
       )
       (detail
        (origin 79 114)
        (extent 923 753)
        (configuration
         (connect D0:1 D1:1
          (Point 347 210)
          (Point 360 210)
          (Point 360 240)
          (Point 414 240)
         )
         (connect D5:1 D1:2
          (Point 315 270)
          (Point 330 270)
          (Point 330 260)
          (Point 414 260)
         )
         (connect D1:1 D2:1
          (Point 465 250)
          (Point 517 250)
         )
         (connect D9:1 D3:1
          (Point 475 500)
          (Point 490 500)
          (Point 490 440)
          (Point 517 440)
         )
         (connect D0:0 D5:0
          (Point 290 225)
          (Point 290 255)
         )
         (connect I2:1 D5:1
          (Point 81 500)
          (Point 240 500)
          (Point 240 270)
          (Point 264 270)
         )
         (connect I3:1 D6:1
          (Point 81 750)
          (Point 90 750)
          (Point 90 660)
          (Point 419 660)
         )
         (connect D7:0 D8:0
          (Point 300 475)
          (Point 300 505)
         )
         (connect I1:1 D8:1
          (Point 81 250)
          (Point 250 250)
          (Point 250 520)
          (Point 274 520)
         )
         (connect D7:1 D9:1
          (Point 357 460)
          (Point 370 460)
          (Point 370 490)
          (Point 424 490)
         )
         (connect D8:1 D9:2
          (Point 325 520)
          (Point 340 520)
          (Point 340 510)
          (Point 424 510)
         )
        )
        (stackingOrder 1 2 3 5 4 8 9 7 0 6)
       )
       (active icon)
      )
     )
     (configuration
      (connect I1:1 D0:1)
      (connect D0:1 D1:1)
      (connect D0:2 D1:2)
      (connect D0:3 D1:3)
     )
    )
    (views
     (detail
      (origin 145 129)
      (extent 947 659)
      (configuration
       (connect I1:1 D0:1
        (Point 147 468)
        (Point 160 468)
        (Point 160 430)
        (Point 288 430)
       )
       (connect D0:1 D1:1
        (Point 371 420)
        (Point 478 420)
       )
       (connect D0:2 D1:2
        (Point 371 430)
        (Point 478 430)
       )
       (connect D0:3 D1:3
        (Point 371 440)
        (Point 478 440)
       )
      )
      (stackingOrder 0 1)
     )
     (terminals on)
     (active detail)
    )
   )
  )
  (locked no)
  (trigMode deg)
  (nextID 6)
  (component 0 "CALL"
   (name "Call Function")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
   )
   (implementation
    (component callFunc "endOfTest")
   )
   (views
    (icon
    )
    (detail
     (origin 155 244)
     (extent 260 54)
    )
    (terminals on)
    (active detail)
   )
  )
  (component 1 "LITERALCONSTANT"
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Text")
     (lock name constraints)
    )
   )
   (implementation
    (component value Text
     (name "Text")
     (datum "/usr/lib/veetest/examples/mfgtest/demodata.dat")
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Text
     (name "CString")
     (datum "")
    )
   )
   (views
    (icon
    )
    (detail
     (origin 22 116)
     (extent 476 48)
    )
    (active detail)
   )
  )
  (component 2 "NOTE"
   (interface
   )
   (implementation
   )
   (views
    (icon
     (origin 101 517)
     (extent 338 48)
     (label off)
     (iconImage "disclaim.icon")
    )
    (detail
     (origin 830 250)
     (extent 200 100)
     (editing enabled)
    )
    (active icon)
   )
  )
  (component 3 "CONTEXT"
   (name "Press For")
   (description 10 4
    This User Object is the outermost "context"
    for the InfoAbout help device.  Within this
    device is the pop-up panel containing the info
    Notepad.  If all you can see is a device with
    "Press For", you should double-click the left
    mouse button on the Press For to restore the
    Panel View of the device.  To see how this device
    operates, click on the Info About button first,
    then press the Detail button in the "Press For"
    title bar.
   )
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (locked no)
    (trigMode deg)
    (nextID 4)
    (component 0 "TOGGLE"
     (name "Info About")
     (description 24 6
      This is a toggle device with the name changed to
      reflect it's function.  The output of the device
      is "0" when the button is up, and "1" when the
      button is down.  
      
      A Reset Control Input terminal has been added to
      to always pop the button back out after showing
      the pop-up help (Info About This Example) User
      Object.
      
      The Toggle has set the "AutoExecute" option to let
      it operate even when the RUN button in the title
      bar has not been pressed.  Note, however, that
      AutoExecute only works when no other threads are
      operating, either from their Start buttons or from
      the RUN button.
      
      To allow the Toggle to operate when other threads
      are running, an Until Break device repeatedly lets
      the Toggle device output it's current value (based
      on the button state) to the If/Then.  Thus, when
      RUN is pressed, the InfoAbout toggle output is
      still monitored for "1".
      
     )
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Reset")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Info About")
       (values range 0 1)
       (datum 0)
      )
      (component autoTrigger on)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (name "LongInt")
       (datum 0)
      )
     )
     (views
      (icon
       (origin 201 335)
       (extent 114 39)
       (format button)
      )
      (detail
       (origin 320 203)
       (extent 42 54)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "REPEATUNTILBREAK"
     (description 8 6
      This object is of use only when the RUN button in
      the title bar has been pressed to cause one or
      more threads to begin execution.  Since the toggle
      button (InfoAbout) will not AutoExecute when other
      threads are running, we need the Until Break to
      continually cause the Toggle to send it's output
      value (0 if button up, 1 if button down) to the
      "If/Then" object.  
     )
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Continuous")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 125 260)
       (extent 110 64)
       (iconImage "loop.icon")
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "CONTEXT"
     (name "Info About This Example")
     (description 10 6
      This is a User Object that has both a detail view
      and a Panel view.  If this device is visible as
      an icon, you must double-click the left mouse
      button to "open up" the non-iconic view.
      
      Since the User Object has both a Panel and Detail
      view, when you double-click on the icon, you will
      first see the Panel view.  To see the components
      of the User Object, press the Detail button in
      the "Info About This Example" title bar.
     )
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (locked no)
      (trigMode deg)
      (nextID 2)
      (component 0 "NOTE"
       (name "NotePad")
       (description 11 8
        This notepad is displayed as a Show on Execute
        panel to present the information to the reader.
        
        It has been "Added to Panel" of the "Info About
        This Example" user object, thus it is not 
        necessary to keep it as an open device inside the
        Detail view; you can edit the notepad from the
        Panel view of this User Object.  You can also
        set/clear the "Enable Edit" flag in this Notepad's
        Object Menu to keep the pop-up notepad from being
        altered by the user.
       )
       (interface
       )
       (implementation
        (component text 15 9
         PURPOSE: To show an example end-of-test report that analyzes test results in a few 
         	different ways.
         
         DESIGN PHILOSOPHY: Basically, we read a Data Set (called "demodata.dat") and look for two 
         	different types of test results.  The first type examines pass/fail results across 
         	every test that has been stored in that Data Set.  The second type of data we look 
         	for concerns the pass/fail results of the individual tests in the data set.  We do 
         	this to show a Pareto distribution of those tests which fail most often.  
         
         	The Data Set contains the results of five successive runs of three Sequencer tests.  
         	Both the number of runs and the number of Sequencer tests can be any value.  We show 
         	how to interpret the Sequencer results record.  The Sequencer builds a record that 
         	contains a field entry for every for every item we configure in the Sequencer 
         	"Logging Config ..." menu.
         
        )
       )
       (views
        (icon
         (origin 410 405)
         (extent 78 25)
        )
        (detail
         (origin 25 199)
         (extent 848 437)
         (editing enabled)
        )
        (active icon)
       )
      )
      (component 1 "CONFIRM"
       (name "DONE")
       (description 7 8
        This tiny "thread" begins running when the 
        enclosing UserObject is executed.  When the user
        acknowledges the OK/DONE button, there is nothing
        left to execute, so the thread ends.  Since there
        are not other threads running, the User Object
        is completed and will exit, removing the Show on
        Execute pop-up display.
       )
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 421 472)
         (extent 58 37)
        )
        (detail
         (origin 156 253)
         (extent 79 34)
        )
        (terminals on)
        (active icon)
       )
      )
      (configuration
      )
      (ShowOnExecPanel
       (origin 16 16)
       (extent 849 561)
       (panel
        (origin 38 154)
        (extent 845 533)
        (widget 1 icon
         (title off)
         (origin 437 639)
         (extent 58 37)
        )
        (widget 0 detail
         (title off)
         (origin 49 167)
         (extent 816 465)
         (editing disabled)
        )
       )
      )
     )
     (views
      (icon
       (origin 352 408)
       (extent 217 25)
      )
      (detail
       (origin 17 150)
       (extent 866 520)
       (configuration
       )
       (stackingOrder 1 0)
      )
      (active icon)
     )
    )
    (component 3 "IFTHENELSE"
     (name "!= 0")
     (description 10 6
      This device tests the value of the data input
      and either executes the "Info About This Device"
      User object when the input is "1", or terminates
      the current iteration of the Until Break device.
      
      If no threads are running, the Toggle can generate
      it's output data whenever the button is changed
      (using the Toggle's AutoExecute mode).  In this
      case, either the User Object is executed or the
      Autoexecute sequence terminates.
     )
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a!=0")
     )
     (views
      (icon
       (origin 367 340)
       (extent 46 25)
      )
      (detail
       (origin 349 328)
       (extent 73 64)
      )
      (terminals on)
      (active icon)
     )
    )
    (configuration
     (connect D1:1 D0:0)
     (connect D3:0 D0:1)
     (connect D3:1 D2:0)
     (connect D0:1 D3:1)
    )
   )
   (views
    (icon
     (origin 585 349)
     (extent 110 25)
    )
    (panel
     (origin 111 433)
     (extent 319 77)
     (widget 0 icon
      (title off)
      (origin 214 451)
      (extent 114 39)
      (format button)
     )
    )
    (detail
     (origin 4 106)
     (extent 912 591)
     (configuration
      (connect D1:1 D0:0
       (Point 237 292)
       (Point 258 292)
       (Point 258 332)
      )
      (connect D3:0 D0:1
       (Point 390 367)
       (Point 390 392)
       (Point 180 392)
       (Point 180 354)
       (Point 198 354)
      )
      (connect D3:1 D2:0
       (Point 415 342)
       (Point 460 342)
       (Point 460 405)
      )
      (connect D0:1 D3:1
       (Point 317 354)
       (Point 340 354)
       (Point 340 352)
       (Point 364 352)
      )
     )
     (stackingOrder 0 1 3 2)
    )
    (active panel)
    (active panel)
   )
  )
  (component 4 "EXITPROCESS"
   (interface
    (sequence in)
   )
   (implementation
    (comp code 0)
   )
   (views
    (icon
     (iconImage "stop.icon")
    )
    (detail
     (origin 225 353)
     (extent 110 36)
    )
    (active detail)
   )
  )
  (configuration
   (connect D1:1 D0:1)
   (connect D0:0 D4:0)
  )
 )
 (views
  (panel
   (origin 0 62)
   (extent 1002 680)
   (widget 2 icon
    (title off)
    (origin 657 685)
    (extent 338 48)
    (label off)
    (iconImage "disclaim.icon")
   )
   (widget 3 panel
    (title on)
    (origin 675 595)
    (extent 319 77)
    (widget 0 icon
     (title off)
     (origin 778 613)
     (extent 114 39)
     (format button)
    )
   )
  )
  (detail
   (origin 0 62)
   (extent 1238 900)
   (configuration
    (connect D1:1 D0:1
     (Point 500 140)
     (Point 520 140)
     (Point 520 190)
     (Point 90 190)
     (Point 90 271)
     (Point 112 271)
    )
    (connect D0:0 D4:0
     (Point 280 300)
     (Point 280 322)
    )
   )
   (stackingOrder 2 0 4 3 1)
  )
  (active panel)
  (active panel)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
