#! /usr/lib/veetest/veetest -r
(revision "A.00.01")
(date "Wed 01/Jan/1992")
(component 0 "Context"
 (name "Bar Chart Example")
 (interface
 )
 (implementation
  (trigMode deg)
  (locked no)
  (component 0 "Context"
   (name "Generate Data")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Result")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "Constant"
     (name "Low Limit")
     (subType "Real")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Real")
       (lock name constraints)
      )
     )
     (implementation
      (component value Real
       (name "Low Limit")
       (datum 0)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Real
       (datum 0)
      )
     )
     (views
      (icon
       (extent 110 0)
      )
      (detail
       (origin 28 356)
       (extent 165 28)
       (showFormat real)
      )
      (active detail)
     )
    )
    (component 1 "Constant"
     (name "High Limit")
     (subType "Real")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Real")
       (lock name constraints)
      )
     )
     (implementation
      (component value Real
       (name "High Limit")
       (datum 1)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Real
       (datum 0)
      )
     )
     (views
      (icon
       (extent 110 0)
      )
      (detail
       (origin 23 426)
       (extent 174 28)
       (showFormat real)
      )
      (active detail)
     )
    )
    (component 2 "Context"
     (name "100 random #s")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Array")
       (lock constraints)
       (optional yes)
      )
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Collector"
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "Data")
         (tag "Data")
        )
        (input 2
         (type trigger)
         (name "XEQ")
         (lock name constraints)
        )
        (output 1
         (type data)
         (name "Array")
         (tag "Array")
         (lock constraints)
        )
       )
       (implementation
        (component clearAtPrerun 1)
        (component clearAtActivate 1)
       )
       (views
        (icon
         (origin 280 248)
         (extent 110 25)
        )
        (detail
         (origin 265 455)
         (extent 60 110)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "RandomNumber"
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Rand Val")
         (lock name constraints)
        )
       )
       (implementation
        (component lowerLimit 0)
        (component upperLimit 1)
       )
       (views
        (icon
         (origin 107 258)
         (extent 127 25)
        )
        (detail
         (origin 109 410)
         (extent 222 60)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 2 "ForCount"
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Count")
         (lock name constraints)
        )
       )
       (implementation
        (component count 100)
       )
       (views
        (icon
         (origin 90 168)
         (extent 110 64)
         (iconImage "loop.icon")
        )
        (detail
         (origin 60 183)
         (extent 170 34)
        )
        (active detail)
       )
      )
      (configuration
       (connect D1:1 D0:1)
       (connect D2:0 D0:2)
       (connect D2:1 D1:0)
       (connect D0:1 O1:1)
      )
     )
     (views
      (icon
       (origin 37 278)
       (extent 127 25)
      )
      (detail
       (origin 31 130)
       (extent 388 200)
       (configuration
        (connect D1:1 D0:1
         (Point 236 270)
         (Point 250 270)
         (Point 250 250)
         (Point 277 250)
        )
        (connect D2:0 D0:2
         (Point 145 219)
         (Point 145 240)
         (Point 85 240)
         (Point 85 300)
         (Point 255 300)
         (Point 255 270)
         (Point 277 270)
        )
        (connect D2:1 D1:0
         (Point 232 200)
         (Point 250 200)
         (Point 250 240)
         (Point 170 240)
         (Point 170 255)
        )
        (connect D0:1 O1:1
         (Point 392 260)
         (Point 416 240)
        )
       )
      )
      (terminals on)
      (active icon)
     )
    )
    (component 3 "Constant"
     (name "step")
     (subType "Real")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Real")
       (lock name constraints)
      )
     )
     (implementation
      (component value Real
       (name "step")
       (datum 0.1)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Real
       (datum 0)
      )
     )
     (views
      (icon
       (origin 487 708)
       (extent 46 25)
      )
      (detail
       (origin 39 496)
       (extent 122 28)
       (showFormat real)
      )
      (active detail)
     )
    )
    (component 4 "Formula"
     (name "magDist()")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "X")
       (lock name constraints)
      )
      (input 2
       (type data)
       (name "From")
       (lock name constraints)
      )
      (input 3
       (type data)
       (name "Thru")
       (lock name constraints)
      )
      (input 4
       (type data)
       (name "Step")
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked yes)
      (component expr 1 "magDist(x,from,thru,step)")
     )
     (views
      (icon
       (origin 255 388)
       (extent 110 45)
      )
      (detail
       (origin 421 305)
       (extent 259 210)
      )
      (terminals on)
      (active icon)
     )
    )
    (configuration
     (connect D2:1 D4:1)
     (connect D0:1 D4:2)
     (connect D1:1 D4:3)
     (connect D3:1 D4:4)
     (connect D4:1 O1:1)
    )
   )
   (views
    (icon
     (extent 127 0)
    )
    (detail
     (origin 20 261)
     (extent 360 278)
     (configuration
      (connect D2:1 D4:1
       (Point 166 290)
       (Point 230 290)
       (Point 230 390)
       (Point 252 390)
      )
      (connect D0:1 D4:2
       (Point 195 370)
       (Point 220 370)
       (Point 220 400)
       (Point 252 400)
      )
      (connect D1:1 D4:3
       (Point 199 440)
       (Point 220 440)
       (Point 220 410)
       (Point 252 410)
      )
      (connect D3:1 D4:4
       (Point 163 510)
       (Point 230 510)
       (Point 230 420)
       (Point 252 420)
      )
      (connect D4:1 O1:1
       (Point 367 410)
       (Point 377 410)
      )
     )
    )
    (active detail)
   )
  )
  (component 1 "TextDisplay"
   (name "Data")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 46 0)
    )
    (detail
     (origin 492 448)
     (extent 156 204)
    )
    (active detail)
   )
  )
  (component 2 "Context"
   (name "Bar Chart Display")
   (description 25 4
    Generates and displays a bar chart using the 1-D
    array input data.  The number of bars is equal to
    the number of array elements, and the "length" of
    each bar is set by the corresponding Array element
    data, which may be a positive or negative real or
    int32 number.
    
    The display is pre-autoscaled before plotting,
    using the maximum and minumum array data values
    and the number of bars.
    
    The data and display labels, bar color, grid type,
    etc. can be set by clicking the Right Button over
    the display area and selecting the "Traces and
    Scales" entry from the resulting menu.  The gap
    between bars can be set using the "Spacing" box
    in the Bar Chart Detail view.
    
    It may prove useful to Secure the BarChart User
    Object after customizing, since this eliminates
    the Panel/Detail buttons and some menu selections
    that are no longer needed.  Be sure to save the
    unsecured object so you can make changes at a
    later date, however.
    
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Ary")
     (requires
      (shape "Array 1D")
     )
     (optional yes)
    )
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "YPlot"
     (name "XY Trace")
     (subType "XY_Trace")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Trace1")
       (lock constraints)
      )
      (input 2
       (type control)
       (name "Auto Scale")
       (lock name constraints)
       (optional yes)
      )
      (input 3
       (type control)
       (name "Next Curve")
       (lock name constraints)
       (optional yes)
      )
     )
     (implementation
      (component clearAtPrerun 1)
      (component clearAtActivate 0)
      (component tracePin 1)
      (component graphMode rectangular)
     )
     (views
      (icon
       (extent 110 0)
       (iconImage "display.icon")
      )
      (detail
       (origin 457 312)
       (extent 327 277)
       (displayMode scrollGraph)
       (graphType cartesian)
       (gridType frame)
       (scale 0
        (name "Y name")
        (domainName "X name")
        (pen 1)
        (show 1)
        (range 0 14 4 linear)
       )
       (domain 0 10 4 linear)
       (trace 0 onScale 0
        (name "Trace1")
        (pen 7)
        (lineType 1)
        (pointType 6)
       )
      )
      (active detail)
     )
    )
    (component 1 "ForCount"
     (name "For Count")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Count")
       (tag "Count")
       (requires
        (datatype Int32)
        (shape "Scalar")
       )
       (lock constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (name "Count")
       (lock name constraints)
      )
      (buffers in
       (buffer "Count")
      )
     )
     (implementation
      (component count 10)
     )
     (views
      (icon
       (origin 305 548)
       (extent 110 64)
       (iconImage "loop.icon")
      )
      (detail
       (origin 615 253)
       (extent 170 34)
      )
      (active icon)
     )
    )
    (component 2 "Junction"
     (name "JCT")
     (interface
      (input 1
       (type data)
       (name "A")
       (lock name constraints)
      )
      (input 2
       (type data)
       (name "B")
       (lock name constraints)
      )
      (input 3
       (type data)
       (name "C")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Data")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 367 393)
       (extent 46 34)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 3 "FromArray"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Ary")
       (tag "Ary")
      )
      (output 1
       (type data)
       (name "SubAry")
       (tag "Result")
       (lock constraints)
      )
      (output 2
       (type data)
       (name "Type")
       (tag "Type")
       (lock constraints)
      )
      (output 3
       (type data)
       (name "NumDims")
       (tag "NumDims")
       (lock constraints)
      )
      (output 4
       (type data)
       (name "DimSizes")
       (tag "DimSizes")
       (lock constraints)
      )
      (output 5
       (type data)
       (name "TotSize")
       (tag "TotSize")
       (lock constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "Ary")
     )
     (views
      (icon
       (origin 165 548)
       (extent 110 64)
       (iconImage "unbuild.icon")
      )
      (detail
       (origin 252 110)
       (extent 147 160)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 4 "Do"
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Do")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 337 508)
       (extent 46 25)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 5 "Formula"
     (name "Upper Right")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (input 2
       (type data)
       (name "xmax")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "coord(xmax,max(a))")
     )
     (views
      (icon
       (origin 185 478)
       (extent 110 25)
      )
      (detail
       (origin 312 308)
       (extent 196 104)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 6 "Formula"
     (name "Lower Left")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "coord(0,min([min(a) 0]))")
     )
     (views
      (icon
       (origin 185 438)
       (extent 110 25)
      )
      (detail
       (origin 180 408)
       (extent 250 104)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 7 "Constant"
     (name "Spacing")
     (subType "Real")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Real")
       (lock name constraints)
      )
     )
     (implementation
      (component value Real
       (name "Spacing")
       (datum 0.2)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Real
       (datum 0)
      )
     )
     (views
      (icon
       (extent 78 0)
      )
      (detail
       (origin 157 396)
       (extent 147 28)
       (showFormat real)
      )
      (active detail)
     )
    )
    (component 8 "Formula"
     (name "Calculate Bar coords")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (input 2
       (type data)
       (name "I")
       (optional yes)
      )
      (input 3
       (type data)
       (name "z")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "[coord(I+z/2,A[i]) coord(I+1-z/2,A[i])]")
     )
     (views
      (icon
       (origin 165 283)
       (extent 190 34)
      )
      (detail
       (origin 183 443)
       (extent 385 154)
      )
      (terminals on)
      (active icon)
     )
    )
    (configuration
     (connect D2:1 D0:1)
     (connect D4:1 D0:2)
     (connect D0:0 D0:3)
     (connect D4:0 D1:0)
     (connect D3:5 D1:1)
     (connect D8:1 D2:1)
     (connect D6:1 D2:2)
     (connect D5:1 D2:3)
     (connect I1:1 D3:1)
     (connect D5:0 D4:0)
     (connect D6:0 D5:0)
     (connect I1:1 D5:1)
     (connect D3:5 D5:2)
     (connect I1:1 D6:1)
     (connect I1:1 D8:1)
     (connect D1:1 D8:2)
     (connect D7:1 D8:3)
    )
   )
   (views
    (icon
     (origin 529 318)
     (extent 163 25)
    )
    (panel
     (origin 489 140)
     (extent 382 260)
     (widget 0 detail
      (title off)
      (origin 493 145)
      (extent 374 251)
      (displayMode annotGraph)
      (graphType cartesian)
      (gridType frame)
      (scale 0
       (name "Y name")
       (domainName "X name")
       (pen 1)
       (show 1)
       (range 0 14 4 linear)
      )
      (domain 0 10 4 linear)
      (trace 0 onScale 0
       (name "Trace1")
       (pen 7)
       (lineType 1)
       (pointType 6)
      )
     )
    )
    (detail
     (origin 86 262)
     (extent 689 417)
     (configuration
      (connect D2:1 D0:1
       (Point 415 410)
       (Point 430 410)
       (Point 430 360)
       (Point 454 360)
      )
      (connect D4:1 D0:2
       (Point 385 520)
       (Point 400 520)
       (Point 400 450)
       (Point 454 450)
      )
      (connect D0:0 D0:3
       (Point 620 591)
       (Point 620 610)
       (Point 430 610)
       (Point 430 540)
       (Point 454 540)
      )
      (connect D4:0 D1:0
       (Point 360 535)
       (Point 360 545)
      )
      (connect D3:5 D1:1
       (Point 277 600)
       (Point 290 600)
       (Point 290 580)
       (Point 302 580)
      )
      (connect D8:1 D2:1
       (Point 357 300)
       (Point 370 300)
       (Point 370 340)
       (Point 350 340)
       (Point 350 400)
       (Point 364 400)
      )
      (connect D6:1 D2:2
       (Point 297 450)
       (Point 330 450)
       (Point 330 410)
       (Point 364 410)
      )
      (connect D5:1 D2:3
       (Point 297 490)
       (Point 340 490)
       (Point 340 420)
       (Point 364 420)
      )
      (connect I1:1 D3:1
       (Point 88 480)
       (Point 150 480)
       (Point 150 580)
       (Point 162 580)
      )
      (connect D5:0 D4:0
       (Point 240 505)
       (Point 240 520)
       (Point 310 520)
       (Point 310 500)
       (Point 360 500)
       (Point 360 505)
      )
      (connect D6:0 D5:0
       (Point 240 465)
       (Point 240 475)
      )
      (connect I1:1 D5:1
       (Point 88 480)
       (Point 182 480)
      )
      (connect D3:5 D5:2
       (Point 277 600)
       (Point 290 600)
       (Point 290 530)
       (Point 170 530)
       (Point 170 500)
       (Point 182 500)
      )
      (connect I1:1 D6:1
       (Point 88 480)
       (Point 150 480)
       (Point 150 450)
       (Point 182 450)
      )
      (connect I1:1 D8:1
       (Point 88 480)
       (Point 120 480)
       (Point 120 290)
       (Point 162 290)
      )
      (connect D1:1 D8:2
       (Point 417 580)
       (Point 440 580)
       (Point 440 630)
       (Point 130 630)
       (Point 130 300)
       (Point 162 300)
      )
      (connect D7:1 D8:3
       (Point 306 410)
       (Point 320 410)
       (Point 320 400)
       (Point 330 400)
       (Point 330 340)
       (Point 150 340)
       (Point 150 310)
       (Point 162 310)
      )
     )
    )
    (active panel)
    (active panel)
   )
  )
  (component 3 "Context"
   (name "Press For")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "IfThenElse"
     (name "!= 0")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a!=0")
     )
     (views
      (icon
       (origin 365 350)
       (extent 46 25)
      )
      (detail
       (origin 209 308)
       (extent 73 64)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "Toggle"
     (name "Info About")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Reset")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Info About")
       (values range 0 1)
       (datum 0)
      )
      (component autoTrigger on)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (datum 0)
      )
     )
     (views
      (icon
       (origin 201 343)
       (extent 114 39)
       (format button)
      )
      (detail
       (origin 320 203)
       (extent 42 54)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "Context"
     (name "Info About This Example")
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Confirm"
       (name "DONE")
       (description 7 8
        This tiny "thread" begins running when the 
        enclosing UserObject is executed.  When the user
        acknowledges the OK/DONE button, there is nothing
        left to execute, so the thread ends.  Since there
        are not other threads running, the User Object
        is completed and will exit, removing the Show on
        Execute pop-up display.
       )
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 421 482)
         (extent 58 37)
        )
        (detail
         (origin 156 253)
         (extent 79 34)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "Note"
       (name "NotePad")
       (description 2 8
        This notepad is displayed as a Show on Execute
        panel to present the information to the reader.
       )
       (interface
       )
       (implementation
        (component text 20 9
         PURPOSE:     Illustrates use of the BarChart library object to display an array of data.
         
         USER INPUT REQUIRED: Press Run to display the Bar Chart.
         
         EXPLANATION: To generate some interesting data to display, an array of 100 random numbers
                      between 0 and 1.0 is analyzed to get the magnitude Distribution in 10 "bins"
                      between 0 and 1.  The resulting array has 10 elements representing the number
                      of numbers in each of the 10 bins.  This array is given to the BarChart
                      library object for display.
         
         IMPLEMENTATION:  The BarChart library object provides additional usage information from
                      the Show Description choice in the object menu.  Setting colors, etc. is
                      described here, along with a description of the input requirements.  When
                      using the BarChart object in your models, you may want to place and size it,
                      then secure the User Object to prevent inadvertent changes.
         
                      Since the BarChart is a User Object, you may want to examine it to see how
                      the barchart is generated.  Some advanced techniques are used to generate
                      the bar fill using the YPlot "Traces & Scales" menu to set the "Point" style
                      to fill mode.
        )
       )
       (views
        (icon
         (origin 410 415)
         (extent 78 25)
        )
        (detail
         (origin 25 209)
         (extent 848 437)
         (editing disabled)
        )
        (active icon)
       )
      )
      (configuration
      )
      (ShowOnExecPanel
       (origin 0 41)
       (extent 849 571)
       (panel
        (origin 38 164)
        (extent 845 533)
        (widget 0 icon
         (title off)
         (origin 437 649)
         (extent 58 37)
        )
        (widget 1 detail
         (title off)
         (origin 45 175)
         (extent 832 463)
         (editing disabled)
        )
       )
      )
     )
     (views
      (icon
       (origin 352 418)
       (extent 217 25)
      )
      (detail
       (origin 17 160)
       (extent 866 520)
       (configuration
       )
      )
      (active icon)
     )
    )
    (configuration
     (connect D1:1 D0:1)
     (connect D2:0 D1:1)
     (connect D0:1 D2:0)
    )
   )
   (views
    (icon
     (origin 415 408)
     (extent 110 25)
    )
    (panel
     (origin 41 122)
     (extent 319 77)
     (widget 1 icon
      (title off)
      (origin 143 135)
      (extent 114 39)
      (format button)
     )
    )
    (detail
     (origin 4 115)
     (extent 912 591)
     (configuration
      (connect D1:1 D0:1
       (Point 317 362)
       (Point 362 362)
      )
      (connect D2:0 D1:1
       (Point 460 445)
       (Point 460 460)
       (Point 180 460)
       (Point 180 362)
       (Point 198 362)
      )
      (connect D0:1 D2:0
       (Point 413 352)
       (Point 460 352)
       (Point 460 415)
      )
     )
    )
    (active panel)
    (active panel)
   )
  )
  (component 4 "Note"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 4 5
     This example is provided as an
     illustration "as is", and Hewlett-Packard
     Company makes no warranty of any kind
     with regard to this example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 12 609)
     (extent 397 82)
     (editing disabled)
    )
    (active detail)
   )
  )
  (configuration
   (connect D0:1 D1:1)
   (connect D0:1 D2:1)
  )
 )
 (views
  (panel
   (origin 0 67)
   (extent 850 558)
   (widget 4 detail
    (title on)
    (origin 412 114)
    (extent 397 82)
    (editing disabled)
   )
   (widget 1 detail
    (title on)
    (origin 44 247)
    (extent 171 322)
   )
   (widget 3 panel
    (title on)
    (origin 41 117)
    (extent 319 77)
    (widget 1 icon
     (title off)
     (origin 143 130)
     (extent 114 39)
     (format button)
    )
   )
   (widget 2 panel
    (title on)
    (origin 237 247)
    (extent 573 320)
    (widget 0 detail
     (title off)
     (origin 242 252)
     (extent 564 310)
     (displayMode annotGraph)
     (graphType cartesian)
     (gridType frame)
     (scale 0
      (name "Y name")
      (domainName "X name")
      (pen 1)
      (show 1)
      (range 0 14 4 linear)
     )
     (domain 0 10 4 linear)
     (trace 0 onScale 0
      (name "Trace1")
      (pen 7)
      (lineType 1)
      (pointType 6)
     )
    )
   )
  )
  (detail
   (origin 0 67)
   (extent 927 646)
   (configuration
    (connect D0:1 D1:1
     (Point 402 410)
     (Point 440 410)
     (Point 440 550)
     (Point 489 550)
    )
    (connect D0:1 D2:1
     (Point 402 410)
     (Point 440 410)
     (Point 440 270)
     (Point 486 270)
    )
   )
  )
  (active panel)
  (active panel)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
