#! /usr/lib/veetest/veetest -r
(revision "A.00.00")
(date "Thu 11/Apr/1991")
(component 0 "Context"
 (name "Re-dim array example")
 (interface
 )
 (implementation
  (trigMode deg)
  (locked no)
  (component 0 "Note"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 4 5
     This example is provided as an
     illustration "as is", and Hewlett-Packard
     Company makes no warranty of any kind
     with regard to this example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 482 119)
     (extent 397 82)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 1 "Note"
   (name "Overview of Re-dim array example")
   (interface
   )
   (implementation
    (component text 27 5
     Purpose: Show how the dimensions of an array
     can be changed.
     
     Required user input: none
     
     Explanation:
     Occasionally the need arises to change the 
     shape of an array.  Using iterators and
     "Build Array" objects is one way.  The use of
     iterators in VEE, however, tends to cause
     inefficient operation.  If the data can be 
     kept as an array, the conversion is much 
     quicker.
     
     One way to keep the data together is to write
     it to a file and then read it back.  Using 
     the COUNT field in READ transaction 
     automatically builds an array of that shape 
     and size.
     
     This example starts with a vector twelve 
     elements long and converts it to a 3x4, 2D 
     array.  The To File object writes all the 
     elements sequentially in the scratch file.
     The From File object reads those numbers into
     a 3x4 array.
     
    )
   )
   (views
    (icon
     (extent 307 0)
    )
    (detail
     (origin 20 120)
     (extent 441 301)
     (editing enabled)
    )
    (active detail)
   )
  )
  (component 2 "FromArray"
   (name "UnBuild Array")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Ary")
     (tag "Ary")
    )
    (output 1
     (type data)
     (name "SubAry")
     (tag "Result")
     (lock constraints)
    )
    (output 2
     (type data)
     (name "Type")
     (tag "Type")
     (lock constraints)
    )
    (output 3
     (type data)
     (name "NumDims")
     (tag "NumDims")
     (lock constraints)
    )
    (output 4
     (type data)
     (name "DimSizes")
     (tag "DimSizes")
     (lock constraints)
    )
    (output 5
     (type data)
     (name "TotSize")
     (tag "TotSize")
     (lock constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "Ary")
   )
   (views
    (icon
     (origin 637 678)
     (extent 127 64)
     (iconImage unbuild.icon)
    )
    (detail
     (origin 368 433)
     (extent 79 154)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 3 "Formula"
   (name "a[2,*]")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "a[2,*]")
   )
   (views
    (icon
     (origin 691 518)
     (extent 78 25)
    )
    (detail
     (origin 513 413)
     (extent 88 54)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 4 "TextDisplay"
   (name "original")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 110 0)
    )
    (detail
     (origin 489 257)
     (extent 163 227)
    )
    (active detail)
   )
  )
  (component 5 "Formula"
   (name "a[1,*]")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "a[1,*]")
   )
   (views
    (icon
     (origin 691 398)
     (extent 78 25)
    )
    (detail
     (origin 503 283)
     (extent 88 54)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 6 "Formula"
   (name "a[0,*]")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "a[0,*]")
   )
   (views
    (icon
     (origin 681 278)
     (extent 78 25)
    )
    (detail
     (origin 503 153)
     (extent 88 54)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 7 "FromFile"
   (name "From File")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "X")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (attr iopath file read "/tmp/scratch"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (procedure
      READ TEXT x REAL COUNT:3,4
    )
   )
   (views
    (icon
     (origin 375 568)
     (extent 110 25)
    )
    (detail
     (origin 301 676)
     (extent 278 69)
    )
    (terminals on)
    (active detail)
   )
  )
  (component 8 "ToFile"
   (name "To File")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
   )
   (implementation
    (attr iopath file write "/tmp/scratch"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (procedure
      WRITE TEXT a EOL
    )
   )
   (views
    (icon
     (origin 401 458)
     (extent 78 25)
    )
    (detail
     (origin 337 533)
     (extent 216 94)
    )
    (terminals on)
    (active detail)
   )
  )
  (component 9 "Formula"
   (name "create vector")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "ramp(12,1,12)")
   )
   (views
    (icon
     (origin 175 538)
     (extent 127 25)
    )
    (detail
     (origin 43 514)
     (extent 135 53)
    )
    (terminals on)
    (active detail)
   )
  )
  (component 10 "Start"
   (name "Start")
   (interface
    (sequence out)
   )
   (implementation
   )
   (views
    (icon
     (origin 96 431)
     (extent 69 39)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 11 "TextDisplay"
   (name "Dim 1, index 0")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 136 0)
    )
    (detail
     (origin 780 250)
     (extent 200 81)
    )
    (active detail)
   )
  )
  (component 12 "TextDisplay"
   (name "Dim 1, index 1")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 136 0)
    )
    (detail
     (origin 785 369)
     (extent 210 82)
    )
    (active detail)
   )
  )
  (component 13 "TextDisplay"
   (name "Dim 1, index 2")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 136 0)
    )
    (detail
     (origin 785 489)
     (extent 210 82)
    )
    (active detail)
   )
  )
  (component 14 "TextDisplay"
   (name "NumDim")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 78 0)
    )
    (detail
     (origin 819 612)
     (extent 142 37)
    )
    (active detail)
   )
  )
  (component 15 "TextDisplay"
   (name "Dim Sizes")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 110 0)
    )
    (detail
     (origin 821 686)
     (extent 158 49)
    )
    (active detail)
   )
  )
  (configuration
   (connect D7:1 D2:1)
   (connect D2:1 D3:1)
   (connect D9:1 D4:1)
   (connect D2:1 D5:1)
   (connect D2:1 D6:1)
   (connect D8:0 D7:0)
   (connect D9:1 D8:1)
   (connect D10:0 D9:0)
   (connect D6:1 D11:1)
   (connect D5:1 D12:1)
   (connect D3:1 D13:1)
   (connect D2:3 D14:1)
   (connect D2:4 D15:1)
  )
 )
 (views
  (detail
   (origin 0 67)
   (extent 980 651)
   (configuration
    (connect D7:1 D2:1
     (Point 611 710)
     (Point 634 710)
    )
    (connect D2:1 D3:1
     (Point 766 690)
     (Point 790 690)
     (Point 790 660)
     (Point 670 660)
     (Point 670 530)
     (Point 688 530)
    )
    (connect D9:1 D4:1
     (Point 250 540)
     (Point 270 540)
     (Point 270 480)
     (Point 470 480)
     (Point 470 370)
     (Point 486 370)
    )
    (connect D2:1 D5:1
     (Point 766 690)
     (Point 790 690)
     (Point 790 660)
     (Point 670 660)
     (Point 670 410)
     (Point 688 410)
    )
    (connect D2:1 D6:1
     (Point 766 690)
     (Point 790 690)
     (Point 790 660)
     (Point 670 660)
     (Point 670 290)
     (Point 678 290)
    )
    (connect D8:0 D7:0
     (Point 440 629)
     (Point 440 643)
    )
    (connect D9:1 D8:1
     (Point 250 540)
     (Point 270 540)
     (Point 270 580)
     (Point 294 580)
    )
    (connect D10:0 D9:0
     (Point 130 472)
     (Point 130 481)
    )
    (connect D6:1 D11:1
     (Point 761 290)
     (Point 777 290)
    )
    (connect D5:1 D12:1
     (Point 771 410)
     (Point 782 410)
    )
    (connect D3:1 D13:1
     (Point 771 530)
     (Point 782 530)
    )
    (connect D2:3 D14:1
     (Point 766 710)
     (Point 800 710)
     (Point 800 630)
     (Point 816 630)
    )
    (connect D2:4 D15:1
     (Point 766 720)
     (Point 810 720)
     (Point 810 710)
     (Point 818 710)
    )
   )
  )
  (active detail)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
