#! /usr/lib/veetest/veetest -r
(revision "B.00.00")
(date "Fri 20/Nov/1992")
(component 0 "ROOTCONTEXT"
 (name "Waveform Data in a Record")
 (interface
 )
 (implementation
  (locked no)
  (trigMode rad)
  (nextID 11)
  (component 0 "FORMULA"
   (name "now()")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked yes)
    (component expr 1 "now()")
   )
   (views
    (icon
     (origin 71 118)
     (extent 78 25)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 1 "TORECORD"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (input 2
     (type data)
     (name "B")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Record")
     (tag "Record")
     (lock constraints)
    )
   )
   (implementation
    (component outputType scalar)
   )
   (views
    (icon
     (iconImage "build.icon")
    )
    (detail
     (origin 250 125)
     (extent 131 110)
    )
    (terminals on)
    (active detail)
   )
  )
  (component 2 "VFUNCTIONGENERATOR"
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Func")
     (lock name constraints)
    )
   )
   (implementation
    (component function Cosine)
    (component frequency 100)
    (component amplitude 1)
    (component dcOffset 0)
    (component phaseShift 0)
    (component numPoints 256)
    (component interval 0.02)
    (component degRad Rad)
    (component errorOnAlias 1)
   )
   (views
    (icon
     (origin 24 178)
     (extent 172 64)
     (iconImage "virtual.icon")
    )
    (detail
     (origin 90 242)
     (extent 201 196)
    )
    (terminals on)
    (active icon)
   )
  )
  (component 3 "FORMULA"
   (name "Get Field")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Rec")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "Rec.B")
   )
   (views
    (icon
     (iconImage "formula.icon")
    )
    (detail
     (origin 96 450)
     (extent 79 60)
    )
    (terminals on)
    (active detail)
   )
  )
  (component 4 "TOSTRING"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Rec")
     (optional yes)
    )
    (output 1
     (type data)
     (name "result")
     (lock name constraints)
    )
   )
   (implementation
    (attr iopath string write "string"
     (readTerm "\n")
     (fs " ")
     (eol "\n")
     (multiField fullSyntax)
     (arrayFormat block)
    )
    (procedure
      WRITE TEXT Rec.A DATE:WDMY TIME:HMS:H24 EOL
    )
   )
   (views
    (icon
     (origin 535 158)
     (extent 110 25)
    )
    (detail
     (origin 87 305)
     (extent 437 70)
    )
    (terminals on)
    (active detail)
   )
  )
  (component 5 "YPLOT"
   (name "Fri 20/Nov/1992 15:25:44")
   (subType "XY_Trace")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Trace1")
     (lock constraints)
    )
    (input 2
     (type control)
     (name "Title")
     (tag "Title")
     (requires
      (datatype Text)
      (shape "Scalar")
     )
     (lock name constraints)
     (optional yes)
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
    (component tracePin 1)
    (component graphMode rectangular)
   )
   (views
    (icon
     (extent 226 0)
     (iconImage "display.icon")
    )
    (detail
     (origin 353 425)
     (extent 255 230)
     (displayMode scrollGraph)
     (graphType cartesian)
     (gridType off)
     (scale 0
      (name "Y name")
      (domainName "X name")
      (pen 9)
      (show 1)
      (range -1 1 4 linear)
     )
     (domain 0 0.02 4 linear)
     (trace 0 onScale 0
      (name "Trace1")
      (pen 4)
      (lineType 1)
      (pointType 0)
     )
    )
    (terminals on)
    (active detail)
   )
  )
  (component 8 "CONTEXT"
   (name "Press For")
   (description 10 4
    This User Object is the outermost "context"
    for the InfoAbout help device.  Within this
    device is the pop-up panel containing the info
    Notepad.  If all you can see is a device with
    "Press For", you should double-click the left
    mouse button on the Press For to restore the
    Panel View of the device.  To see how this device
    operates, click on the Info About button first,
    then press the Detail button in the "Press For"
    title bar.
   )
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (locked no)
    (trigMode deg)
    (nextID 4)
    (component 0 "TOGGLE"
     (name "Info About")
     (description 17 6
      This is a toggle device with the name changed to
      reflect it's function.  The output of the device
      is "0" when the button is up, and "1" when the
      button is down.  
      
      A Reset Control Input terminal has been added to
      to always pop the button back out after showing
      the pop-up help (Info About This Example) User
      Object.
      
      The Toggle has set the "AutoExecute" option to let
      it operate even when the RUN button in the title
      bar has not been pressed.  Note, however, that
      AutoExecute only works when no other threads are
      operating, either from their Start buttons or from
      the RUN button.
      
     )
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Reset")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Info About")
       (values range 0 1)
       (datum 0)
      )
      (component autoTrigger on)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (name "LongInt")
       (datum 0)
      )
     )
     (views
      (icon
       (origin 233 331)
       (extent 114 39)
       (format button)
      )
      (detail
       (origin 320 203)
       (extent 42 54)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "CONTEXT"
     (name "Info About This Example")
     (description 10 6
      This is a User Object that has both a detail view
      and a Panel view.  If this device is visible as
      an icon, you must double-click the left mouse
      button to "open up" the non-iconic view.
      
      Since the User Object has both a Panel and Detail
      view, when you double-click on the icon, you will
      first see the Panel view.  To see the components
      of the User Object, press the Detail button in
      the "Info About This Example" title bar.
     )
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (locked no)
      (trigMode deg)
      (nextID 2)
      (component 0 "NOTE"
       (name "NotePad")
       (description 11 8
        This notepad is displayed as a Show on Execute
        panel to present the information to the reader.
        
        It has been "Added to Panel" of the "Info About
        This Example" user object, thus it is not 
        necessary to keep it as an open device inside the
        Detail view; you can edit the notepad from the
        Panel view of this User Object.  You can also
        set/clear the "Enable Edit" flag in this Notepad's
        Object Menu to keep the pop-up notepad from being
        altered by the user.
       )
       (interface
       )
       (implementation
        (component text 14 9
         PURPOSE:  Illustrates building a record containing waveform data.
         
         USER INPUT REQUIRED:  Press "Run".
         
         EXPLANATION:
         	In this example the sine wave output by a Function Generator object and the current
         	time from the now() function are built into a record.  The sine wave is the B field
         	of the record, so Rec.B in the GetField object retrieves the waveform, which is
         	output to an XY Trace object.  The time the waveform was generated is displayed
         	in the title field of the XY Trace object.  First, the "dot" syntax Rec.A in the
         	transaction in the To String object retrieves the time from field A in the record.
         	Further, the transaction is configured to output the resulting time in the format
         	DATE:WDMY TIME:HMS:H24.  Thus, the date and time in that format is output to the
         	Title control input on the XY Trace object.
        )
       )
       (views
        (icon
         (origin 440 416)
         (extent 78 25)
        )
        (detail
         (origin 56 202)
         (extent 848 437)
         (editing enabled)
        )
        (active detail)
       )
      )
      (component 1 "CONFIRM"
       (name "DONE")
       (description 7 8
        This tiny "thread" begins running when the 
        enclosing UserObject is executed.  When the user
        acknowledges the OK/DONE button, there is nothing
        left to execute, so the thread ends.  Since there
        are not other threads running, the User Object
        is completed and will exit, removing the Show on
        Execute pop-up display.
       )
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 451 472)
         (extent 58 37)
        )
        (detail
         (origin 156 253)
         (extent 79 34)
        )
        (terminals on)
        (active icon)
       )
      )
      (configuration
      )
      (ShowOnExecPanel
       (origin 16 16)
       (extent 849 563)
       (panel
        (origin 68 154)
        (extent 845 533)
        (widget 1 icon
         (title off)
         (origin 467 639)
         (extent 58 37)
        )
        (widget 0 detail
         (title off)
         (origin 83 163)
         (extent 816 465)
         (editing disabled)
        )
       )
      )
     )
     (views
      (icon
       (origin 382 408)
       (extent 217 25)
      )
      (detail
       (origin 47 150)
       (extent 866 520)
       (configuration
       )
       (stackingOrder 1 0)
      )
      (active icon)
     )
    )
    (component 3 "IFTHENELSE"
     (name "!= 0")
     (description 5 6
      If no threads are running, the Toggle can generate
      it's output data whenever the button is changed
      (using the Toggle's AutoExecute mode).  In this
      case, either the User Object is executed or the
      Autoexecute sequence terminates.
     )
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a!=0")
     )
     (views
      (icon
       (origin 407 338)
       (extent 46 25)
      )
      (detail
       (origin 349 328)
       (extent 73 64)
      )
      (terminals on)
      (active icon)
     )
    )
    (configuration
     (connect D1:0 D0:1)
     (connect D2:1 D1:0)
     (connect D0:1 D2:1)
    )
   )
   (views
    (icon
     (origin -325 2308)
     (extent 110 25)
    )
    (panel
     (origin 621 132)
     (extent 319 77)
     (widget 0 icon
      (title off)
      (origin 724 150)
      (extent 114 39)
      (format button)
     )
    )
    (detail
     (origin 34 105)
     (extent 912 591)
     (configuration
      (connect D1:0 D0:1
       (Point 490 435)
       (Point 490 450)
       (Point 210 450)
       (Point 210 350)
       (Point 230 350)
      )
      (connect D2:1 D1:0
       (Point 455 340)
       (Point 490 340)
       (Point 490 405)
      )
      (connect D0:1 D2:1
       (Point 349 350)
       (Point 404 350)
      )
     )
     (stackingOrder 0 2 1)
    )
    (active panel)
    (active panel)
   )
  )
  (component 9 "NOTE"
   (interface
   )
   (implementation
   )
   (views
    (icon
     (origin 611 226)
     (extent 338 48)
     (label off)
     (iconImage "disclaim.icon")
    )
    (detail
     (origin 830 250)
     (extent 200 100)
     (editing enabled)
    )
    (active icon)
   )
  )
  (configuration
   (connect D0:1 D1:1)
   (connect D2:1 D1:2)
   (connect D1:1 D3:1)
   (connect D1:1 D4:1)
   (connect D3:1 D5:1)
   (connect D4:1 D5:2)
  )
 )
 (views
  (detail
   (origin 0 62)
   (extent 980 653)
   (configuration
    (connect D0:1 D1:1
     (Point 151 130)
     (Point 170 130)
     (Point 170 150)
     (Point 207 150)
    )
    (connect D2:1 D1:2
     (Point 198 210)
     (Point 207 210)
    )
    (connect D1:1 D3:1
     (Point 453 180)
     (Point 470 180)
     (Point 470 260)
     (Point 30 260)
     (Point 30 340)
     (Point 20 340)
     (Point 20 480)
     (Point 53 480)
    )
    (connect D1:1 D4:1
     (Point 453 180)
     (Point 470 180)
     (Point 470 260)
     (Point 30 260)
     (Point 30 340)
     (Point 44 340)
    )
    (connect D3:1 D5:1
     (Point 247 480)
     (Point 280 480)
    )
    (connect D4:1 D5:2
     (Point 596 340)
     (Point 660 340)
     (Point 660 680)
     (Point 260 680)
     (Point 260 600)
     (Point 280 600)
    )
   )
   (stackingOrder 1 0 3 4 2 7 5 6)
  )
  (active detail)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
