#! /usr/lib/veetest/veetest -r
(revision "A.00.00")
(date "Thu 11/Apr/1991")
(component 0 "Context"
 (name "One-shot button Example")
 (interface
 )
 (implementation
  (trigMode deg)
  (locked no)
  (component 0 "IfThenElse"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Then")
     (lock name constraints)
    )
    (output 2
     (type data)
     (name "Else")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr "A")
   )
   (views
    (description 9 5
     The output of the Toggle is either 0 or 1.  This
     object repeatedly evaluates the input and fires
     the "Then" output only when A is non-zero.  
     
     Without this test, the Until Break device would
     repeatedly cause the toggle to send a 0 or 1 to
     it's controlled thread, executing the thread over
     and over without regard to whether the Toggle was
     pressed.
    )
    (icon
     (origin 281 228)
     (extent 78 25)
    )
    (detail
     (origin 303 395)
     (extent 64 70)
    )
    (terminals on)
    (active detail)
   )
  )
  (component 1 "Counter"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
    (output 1
     (type data)
     (name "Count")
     (tag "Count")
     (lock name constraints)
    )
   )
   (implementation
    (component clearAtPrerun 0)
    (component clearAtActivate 0)
   )
   (views
    (icon
    )
    (detail
     (origin 475 393)
     (extent 150 34)
    )
    (active detail)
   )
  )
  (component 2 "Toggle"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type control)
     (name "Reset")
     (lock name constraints)
     (optional yes)
    )
    (output 1
     (type data)
     (name "Toggle")
     (lock name constraints)
    )
   )
   (implementation
    (component value Int32
     (name "Toggle")
     (values range 0 1)
     (datum 0)
    )
    (component autoTrigger on)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Int32
     (datum 0)
    )
   )
   (views
    (description 17 5
     The output of the TOGGLE device is 0 when the
     button is UP, and 1 when the button is DOWN.
     
     The RESET control input resets the Toggle view
     to UP when the pin is activated.  However, it 
     does not propagate the resulting 0 to the If/Then
     device.  
     
     Autoexecute mode is enabled to allow the button to
     operate before RUN is pressed.  However, since no
     Autoexecute is permitted after any Thread begins
     running, the Toggle must be driven repeatedly by
     the Until Break iterator.  In this mode, the data
     out (0 or 1) is repeatedly tested by the If/Then
     to see when to execute the oneshot's thread (a
     counter in this case.)
     
    )
    (icon
     (origin 161 411)
     (extent 78 39)
     (format button)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 3 "RepeatUntilBreak"
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Continuous")
     (lock name constraints)
    )
   )
   (implementation
   )
   (views
    (icon
     (origin 25 358)
     (extent 110 64)
     (iconImage loop.icon)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 4 "RepeatUntilBreak"
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Continuous")
     (lock name constraints)
    )
   )
   (implementation
   )
   (views
    (icon
     (origin 755 398)
     (extent 110 64)
     (iconImage loop.icon)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 5 "Counter"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
    (output 1
     (type data)
     (name "Count")
     (tag "Count")
     (lock name constraints)
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
    )
    (detail
     (origin 735 523)
     (extent 150 34)
    )
    (active detail)
   )
  )
  (component 6 "Note"
   (name "COMPLETE ONE SHOT DEVICE")
   (interface
   )
   (implementation
    (component text 5 5
     A ONE-SHOT button is constructed from a Toggle device with a
     Reset Input control pin and an If/Then.  The Toggle is set for
     Autoexecute so it will operate before RUN is pressed.  If you
     want the toggle to work while another thread executes, you
     must add the Until Break iterator.
    )
   )
   (views
    (icon
     (extent 226 0)
     (iconImage notepad.icon)
    )
    (detail
     (origin 10 239)
     (extent 581 102)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 7 "Note"
   (name "A DO-NOTHING THREAD")
   (interface
   )
   (implementation
    (component text 5 5
     To show the effects of the
     One Shot when another thread
     is operating, this thread
     can be run by pressing RUN
     to run all.
    )
   )
   (views
    (icon
     (extent 181 0)
     (iconImage notepad.icon)
    )
    (detail
     (origin 679 241)
     (extent 263 99)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 8 "Note"
   (name "To Operate:")
   (interface
   )
   (implementation
    (component text 4 5
     Click on both of
     the Toggles several
     times, then press
     RUN and click more.
    )
   )
   (views
    (icon
     (extent 110 0)
     (iconImage notepad.icon)
    )
    (detail
     (origin 348 109)
     (extent 184 82)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 9 "Note"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 4 5
     This example is provided as an
     illustration "as is", and Hewlett-Packard
     Company makes no warranty of any kind
     with regard to this example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 552 109)
     (extent 397 82)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 10 "Context"
   (name "Press For")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "IfThenElse"
     (name "!= 0")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a!=0")
     )
     (views
      (icon
       (origin 395 380)
       (extent 46 25)
      )
      (detail
       (origin 209 308)
       (extent 73 64)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "Toggle"
     (name "Info About")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Reset")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Info About")
       (values range 0 1)
       (datum 0)
      )
      (component autoTrigger on)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (datum 0)
      )
     )
     (views
      (icon
       (origin 231 373)
       (extent 114 39)
       (format button)
      )
      (detail
       (origin 320 203)
       (extent 42 54)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "RepeatUntilBreak"
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Continuous")
       (lock name constraints)
      )
     )
     (implementation
     )
     (views
      (icon
       (origin 155 298)
       (extent 110 64)
       (iconImage loop.icon)
      )
      (detail
      )
      (terminals on)
      (active icon)
     )
    )
    (component 3 "Context"
     (name "Info About This Example")
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Note"
       (name "NotePad")
       (interface
       )
       (implementation
        (component text 36 9
         PURPOSE:	 Illustrate use of a Toggle device to create a One-Shot Button.
         
         USER INPUT REQUIRED:  Before pressing RUN, try clicking on the two "Toggle" buttons and
                      observe the connected Counters.  Then, press RUN and again click on the
                      Toggle buttons, observing that only the "Complete" method still works.
         
         EXPLANATION: Often, it is desirable to add a click button to a Panel (such as the Info
                      About button you pressed to see this text) to a model.  Since the Toggle
                      object is normally considered as a source of data (0 or 1) depending on it's
                      current state, it would not appear to be the best candidate for such a job.
         
                      The first attempt is usually to add a START button to the panel so that the
                      hosted thread will run whenever the user presses the START button.  However,
                      ALL start buttons are "pressed" when the user selects RUN from the titlebar
                      which is often not the desired action.  If you use the OK/Confirm button to
                      control a hosted thread, it works only after RUN has been pressed, since it
                      has not AutoExecute mode.
         
                      The solution to the problem is to use a Data -->Toggle object with a Reset
                      Control input and an If/Then device.  The Toggle has Autoexecute enabled so
                      it will operate before RUN has been pressed.  Since autoexecute mode does
                      not work when any other thread is operating, we need a way to continually
                      have the output of the Toggle sent to the If/Then test; an Until Break will
                      effectively query the Toggle from the time RUN is pressed until the program
                      stops.  A side effect is that although other threads may eventually stop,
                      the until break continues to run until either Stop is pressed or until a
                      Stop object is executed by one of the threads.  
         
                      You can look at the examples, trying out each one both before and after the
                      RUN button has been pressed to run all threads.  Consider how you might use
                      several Toggle One Shots in a single model, having each perform a different
                      task, and having them operate both with and without a RUN action.
         
         
         
         
        )
       )
       (views
        (description 2 9
         This notepad is displayed as a Show on Execute
         panel to present the information to the reader.
        )
        (icon
         (origin 160 185)
         (extent 78 25)
        )
        (detail
         (origin 36 162)
         (extent 848 437)
         (editing enabled)
        )
        (active icon)
       )
      )
      (component 1 "Confirm"
       (name "DONE")
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (description 7 9
         This tiny "thread" begins running when the 
         enclosing UserObject is executed.  When the user
         acknowledges the OK/DONE button, there is nothing
         left to execute, so the thread ends.  Since there
         are not other threads running, the User Object
         is completed and will exit, removing the Show on
         Execute pop-up display.
        )
        (icon
         (origin 171 252)
         (extent 58 37)
        )
        (detail
         (origin 156 253)
         (extent 79 34)
        )
        (terminals on)
        (active icon)
       )
      )
      (configuration
      )
      (ShowOnExecPanel
       (origin 55 78)
       (extent 849 571)
       (panel
        (origin 38 164)
        (extent 845 533)
        (widget 0 detail
         (title off)
         (origin 48 176)
         (extent 829 459)
         (editing disabled)
        )
        (widget 1 icon
         (title off)
         (origin 427 648)
         (extent 58 37)
        )
       )
      )
     )
     (views
      (icon
       (origin 382 448)
       (extent 217 25)
      )
      (detail
       (origin 17 140)
       (extent 866 520)
       (configuration
       )
      )
      (active icon)
     )
    )
    (configuration
     (connect D1:1 D0:1)
     (connect D2:1 D1:0)
     (connect D3:0 D1:1)
     (connect D0:1 D3:0)
    )
   )
   (views
    (icon
     (origin 175 368)
     (extent 110 25)
    )
    (panel
     (origin 11 112)
     (extent 319 77)
     (widget 1 icon
      (title off)
      (origin 113 125)
      (extent 114 39)
      (format button)
     )
    )
    (detail
     (origin 4 115)
     (extent 912 591)
     (configuration
      (connect D1:1 D0:1
       (Point 347 392)
       (Point 392 392)
      )
      (connect D2:1 D1:0
       (Point 267 330)
       (Point 288 330)
       (Point 288 370)
      )
      (connect D3:0 D1:1
       (Point 490 475)
       (Point 490 490)
       (Point 210 490)
       (Point 210 392)
       (Point 228 392)
      )
      (connect D0:1 D3:0
       (Point 443 382)
       (Point 490 382)
       (Point 490 445)
      )
     )
    )
    (active panel)
    (active panel)
   )
  )
  (component 11 "Note"
   (name "SIMPLE ONE SHOT DEVICE")
   (interface
   )
   (implementation
    (component text 5 5
     A simple ONE-SHOT device is constructed from a Toggle device with
     a Reset Input control pin set for Autoexecute.  It is not very
     robust and can be confused if clicked while another thread is
     running (the button goes down, but since Autoexec is disabled, no
     output data is sent to the counter.   This mode is not very useful.
    )
   )
   (views
    (icon
     (extent 208 0)
     (iconImage notepad.icon)
    )
    (detail
     (origin 14 539)
     (extent 612 102)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 12 "Toggle"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type control)
     (name "Reset")
     (lock name constraints)
     (optional yes)
    )
    (output 1
     (type data)
     (name "Toggle")
     (lock name constraints)
    )
   )
   (implementation
    (component value Int32
     (name "Toggle")
     (values range 0 1)
     (datum 0)
    )
    (component autoTrigger on)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Int32
     (datum 0)
    )
   )
   (views
    (icon
     (origin 51 651)
     (extent 78 39)
     (format button)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 13 "Counter"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
    (output 1
     (type data)
     (name "Count")
     (tag "Count")
     (lock name constraints)
    )
   )
   (implementation
    (component clearAtPrerun 0)
    (component clearAtActivate 0)
   )
   (views
    (icon
    )
    (detail
     (origin 415 683)
     (extent 150 34)
    )
    (active detail)
   )
  )
  (configuration
   (connect D2:1 D0:1)
   (connect D0:1 D1:1)
   (connect D3:1 D2:0)
   (connect D0:1 D2:1)
   (connect D4:1 D5:1)
   (connect D13:0 D12:1)
   (connect D12:1 D13:1)
  )
 )
 (views
  (detail
   (origin 0 67)
   (extent 986 651)
   (configuration
    (connect D2:1 D0:1
     (Point 241 430)
     (Point 260 430)
    )
    (connect D0:1 D1:1
     (Point 419 410)
     (Point 472 410)
    )
    (connect D3:1 D2:0
     (Point 137 390)
     (Point 200 390)
     (Point 200 408)
    )
    (connect D0:1 D2:1
     (Point 419 410)
     (Point 440 410)
     (Point 440 490)
     (Point 140 490)
     (Point 140 430)
     (Point 158 430)
    )
    (connect D4:1 D5:1
     (Point 867 430)
     (Point 880 430)
     (Point 880 470)
     (Point 710 470)
     (Point 710 540)
     (Point 732 540)
    )
    (connect D13:0 D12:1
     (Point 490 719)
     (Point 490 730)
     (Point 400 730)
     (Point 400 710)
     (Point 30 710)
     (Point 30 670)
     (Point 48 670)
    )
    (connect D12:1 D13:1
     (Point 131 670)
     (Point 150 670)
     (Point 150 700)
     (Point 412 700)
    )
   )
  )
  (active detail)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
