#! /usr/lib/veetest/veetest -r
(revision "A.00.00")
(date "Tue 02/Apr/1991")
(component 0 "Context"
 (name "Error Pin Example")
 (interface
 )
 (implementation
  (trigMode deg)
  (locked no)
  (component 0 "RandomNumber"
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Rand Val")
     (lock name constraints)
    )
   )
   (implementation
    (component lowerLimit -50)
    (component upperLimit 50)
   )
   (views
    (description 9 5
     This object generates random data between -1 and 1.
     If it generates a 0, the Formula object will
     generate a "Divide by Zero" error. The Random 
     Number object symbolizes any time you aren't
     exactly sure of the data you're operating on. 
     Instead of stopping the model each time an
     error is generated because of this data, you can
     use an error pin to trap the error and log, 
     process, or skip the erroneous data.
    )
    (icon
     (origin 297 388)
     (extent 127 25)
    )
    (detail
     (origin 49 420)
     (extent 222 60)
    )
    (terminals on)
    (active detail)
   )
  )
  (component 1 "RepeatUntilBreak"
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Continuous")
     (lock name constraints)
    )
   )
   (implementation
   )
   (views
    (icon
     (origin 55 298)
     (extent 110 64)
     (iconImage /usr/lib/veetest/bitmaps/loop.icon)
    )
    (detail
    )
    (terminals on)
    (active icon)
   )
  )
  (component 2 "Constant"
   (name "B")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Real")
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "B")
     (datum 10)
    )
    (component autoTrigger off)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
   )
   (views
    (icon
     (extent 46 0)
    )
    (detail
     (origin 169 556)
     (extent 122 28)
     (showFormat real)
    )
    (active detail)
   )
  )
  (component 3 "Formula"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (requires
      (datatype Int32)
     )
     (optional yes)
    )
    (input 2
     (type data)
     (name "B")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
    (output 2
     (type exception)
     (name "Error")
     (lock name constraints)
     (optional yes)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "B/A")
   )
   (views
    (icon
     (origin 281 188)
     (extent 78 64)
     (iconImage formula.icon)
    )
    (detail
     (origin 470 428)
     (extent 70 104)
    )
    (terminals on)
    (active detail)
   )
  )
  (component 4 "TextDisplay"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
    )
    (detail
     (origin 655 433)
     (extent 190 35)
    )
    (active detail)
   )
  )
  (component 5 "Counter"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
    (output 1
     (type data)
     (name "Count")
     (tag "Count")
     (lock name constraints)
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
    )
    (detail
     (origin 665 523)
     (extent 150 34)
    )
    (active detail)
   )
  )
  (component 6 "Note"
   (name "Overview of \"error\" Example")
   (interface
   )
   (implementation
    (component text 23 5
     Purpose:
     To illustrate the use of the error output
     pin to trap errors so they don't stop the 
     execution of the model.
     
     User Input Required:
     Press Run to start the model.
     
     Explanation:
     The error pins traps any errors generated
     by the Formula object.  In this case, 
     there is a potential "Divide by Zero" 
     error.  Because the error pin traps the
     error, the model continues to run and an
     error dialog box is not displayed.  
     The counter attached to the error pin 
     displays how many divide by zeros have
     occurred.
     
     Try removing the Error pin from the 
     Formula box to see what happens when you 
     get a divide by zero error.
     
    )
   )
   (views
    (icon
     (extent 253 0)
    )
    (detail
     (origin 12 121)
     (extent 417 158)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 7 "Note"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 4 5
     This example is provided as an
     illustration "as is", and Hewlett-Packard
     Company makes no warranty of any kind
     with regard to this example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 459 128)
     (extent 382 84)
     (editing disabled)
    )
    (active detail)
   )
  )
  (configuration
   (connect D1:1 D0:0)
   (connect D0:1 D3:1)
   (connect D2:1 D3:2)
   (connect D3:1 D4:1)
   (connect D3:2 D5:1)
  )
 )
 (views
  (detail
   (origin 0 67)
   (extent 866 644)
   (configuration
    (connect D1:1 D0:0
     (Point 167 330)
     (Point 190 330)
     (Point 190 387)
    )
    (connect D0:1 D3:1
     (Point 363 450)
     (Point 407 450)
    )
    (connect D2:1 D3:2
     (Point 293 570)
     (Point 310 570)
     (Point 310 510)
     (Point 407 510)
    )
    (connect D3:1 D4:1
     (Point 612 450)
     (Point 632 450)
     (Point 632 450)
     (Point 652 450)
    )
    (connect D3:2 D5:1
     (Point 612 510)
     (Point 630 510)
     (Point 630 540)
     (Point 662 540)
    )
   )
  )
  (active detail)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
