#! /usr/lib/veetest/veetest -r
(revision "A.00.01")
(date "Wed 01/Jan/1992")
(component 0 "Context"
 (name "Pass-Fail Bar Chart Example")
 (interface
 )
 (implementation
  (trigMode deg)
  (locked no)
  (component 0 "Context"
   (name "Generate Data")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Result")
     (lock constraints)
     (optional yes)
    )
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "Constant"
     (name "Low Limit")
     (subType "Real")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Real")
       (lock name constraints)
      )
     )
     (implementation
      (component value Real
       (name "Low Limit")
       (datum 0)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Real
       (datum 0)
      )
     )
     (views
      (icon
       (extent 110 0)
      )
      (detail
       (origin 23 514)
       (extent 165 28)
       (showFormat real)
      )
      (active detail)
     )
    )
    (component 1 "Constant"
     (name "High Limit")
     (subType "Real")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Real")
       (lock name constraints)
      )
     )
     (implementation
      (component value Real
       (name "High Limit")
       (datum 1)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Real
       (datum 0)
      )
     )
     (views
      (icon
       (extent 110 0)
      )
      (detail
       (origin 18 584)
       (extent 174 28)
       (showFormat real)
      )
      (active detail)
     )
    )
    (component 2 "Context"
     (name "100 random #s")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Array")
       (lock constraints)
       (optional yes)
      )
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Collector"
       (interface
        (sequence in)
        (sequence out)
        (input 1
         (type data)
         (name "Data")
         (tag "Data")
        )
        (input 2
         (type trigger)
         (name "XEQ")
         (lock name constraints)
        )
        (output 1
         (type data)
         (name "Array")
         (tag "Array")
         (lock constraints)
        )
       )
       (implementation
        (component clearAtPrerun 1)
        (component clearAtActivate 1)
       )
       (views
        (icon
         (origin 280 248)
         (extent 110 25)
        )
        (detail
         (origin 265 455)
         (extent 60 110)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "RandomNumber"
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Rand Val")
         (lock name constraints)
        )
       )
       (implementation
        (component lowerLimit 0)
        (component upperLimit 1)
       )
       (views
        (icon
         (origin 107 258)
         (extent 127 25)
        )
        (detail
         (origin 109 410)
         (extent 222 60)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 2 "ForCount"
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Count")
         (lock name constraints)
        )
       )
       (implementation
        (component count 100)
       )
       (views
        (icon
         (origin 90 168)
         (extent 110 64)
         (iconImage "loop.icon")
        )
        (detail
         (origin 60 183)
         (extent 170 34)
        )
        (active detail)
       )
      )
      (configuration
       (connect D1:1 D0:1)
       (connect D2:0 D0:2)
       (connect D2:1 D1:0)
       (connect D0:1 O1:1)
      )
     )
     (views
      (icon
       (origin 32 436)
       (extent 127 25)
      )
      (detail
       (origin 31 130)
       (extent 388 200)
       (configuration
        (connect D1:1 D0:1
         (Point 236 270)
         (Point 250 270)
         (Point 250 250)
         (Point 277 250)
        )
        (connect D2:0 D0:2
         (Point 145 219)
         (Point 145 240)
         (Point 85 240)
         (Point 85 300)
         (Point 255 300)
         (Point 255 270)
         (Point 277 270)
        )
        (connect D2:1 D1:0
         (Point 232 200)
         (Point 250 200)
         (Point 250 240)
         (Point 170 240)
         (Point 170 255)
        )
        (connect D0:1 O1:1
         (Point 392 260)
         (Point 416 240)
        )
       )
      )
      (terminals on)
      (active icon)
     )
    )
    (component 3 "Constant"
     (name "step")
     (subType "Real")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Real")
       (lock name constraints)
      )
     )
     (implementation
      (component value Real
       (name "step")
       (datum 0.1)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Real
       (datum 0)
      )
     )
     (views
      (icon
       (origin 487 708)
       (extent 46 25)
      )
      (detail
       (origin 34 654)
       (extent 122 28)
       (showFormat real)
      )
      (active detail)
     )
    )
    (component 4 "Formula"
     (name "magDist()")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "X")
       (lock name constraints)
      )
      (input 2
       (type data)
       (name "From")
       (lock name constraints)
      )
      (input 3
       (type data)
       (name "Thru")
       (lock name constraints)
      )
      (input 4
       (type data)
       (name "Step")
       (lock name constraints)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked yes)
      (component expr 1 "magDist(x,from,thru,step)")
     )
     (views
      (icon
       (origin 250 546)
       (extent 110 45)
      )
      (detail
       (origin 421 305)
       (extent 259 210)
      )
      (terminals on)
      (active icon)
     )
    )
    (configuration
     (connect D2:1 D4:1)
     (connect D0:1 D4:2)
     (connect D1:1 D4:3)
     (connect D3:1 D4:4)
     (connect D4:1 O1:1)
    )
   )
   (views
    (icon
     (extent 127 0)
    )
    (detail
     (origin 10 421)
     (extent 360 278)
     (configuration
      (connect D2:1 D4:1
       (Point 161 448)
       (Point 225 448)
       (Point 225 548)
       (Point 247 548)
      )
      (connect D0:1 D4:2
       (Point 190 528)
       (Point 215 528)
       (Point 215 558)
       (Point 247 558)
      )
      (connect D1:1 D4:3
       (Point 194 598)
       (Point 215 598)
       (Point 215 568)
       (Point 247 568)
      )
      (connect D3:1 D4:4
       (Point 158 668)
       (Point 225 668)
       (Point 225 578)
       (Point 247 578)
      )
      (connect D4:1 O1:1
       (Point 362 568)
       (Point 367 568)
       (Point 367 570)
       (Point 367 570)
      )
     )
    )
    (active detail)
   )
  )
  (component 1 "TextDisplay"
   (name "The Data")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 110 0)
    )
    (detail
     (origin 452 464)
     (extent 156 213)
    )
    (active detail)
   )
  )
  (component 2 "Slider"
   (name "Limit")
   (subType "Real_Slider")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Real")
     (lock name constraints)
    )
   )
   (implementation
    (component value Real
     (name "Limit")
     (values range 0 20)
     (datum 9)
    )
    (component autoTrigger on)
    (component initializeAtPrerun off)
    (component initializeAtActivate off)
    (component initValue Real
     (datum 0)
    )
    (component detents 0.5)
   )
   (views
    (icon
     (extent 78 0)
    )
    (detail
     (origin 372 116)
     (extent 156 229)
    )
    (active detail)
   )
  )
  (component 3 "Note"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 5 5
     This example is provided as an
     illustration "as is", and Hewlett-
     Packard Company makes no warranty
     of any kind with regard to this
     example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 639 461)
     (extent 322 99)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 4 "Note"
   (name "To Operate")
   (interface
   )
   (implementation
    (component text 5 5
     Adjust the desired threshold
     limit and observe which bars
     colored red and green.  Click
     Info About for hints on
     reversing the test sense.
    )
   )
   (views
    (icon
     (origin 105 228)
     (extent 110 64)
     (iconImage "notepad.icon")
    )
    (detail
     (origin 19 251)
     (extent 323 99)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 5 "Context"
   (name "Pass/Fail Chart")
   (description 30 4
    Generates and displays a Pass/Fail bar chart from
    the 1-D input data array and a Limit.  The number
    of bars is equal to the number of array elements,
    the "length" of each bar is set by the value of
    each element (which may be a positive or negative
    real or int32 number), and the color of each bar
    is determined by comparing to the limit threshold
    value.  
    
    The display is autoscaled after plotting the bars
    using the maximum and minumum array data values
    and the number of bars.
    
    The display and data labels, bar color, grid type,
    etc. can be set by clicking the Right Button over
    the display area and selecting the "Traces and
    Scales" entry from the resulting menu.  Changing
    the "sense" of the test is done by swapping the
    data Labels (PASS and FAIL) and the trace colors
    (Pen2 Pen3).  The gap between bars can be set
    using the "Spacing" box in the Bar Chart Detail
    view.
    
    It may prove useful to Secure the BarChart User
    Object after customizing, since this eliminates
    the Panel/Detail buttons and some menu selections
    that are no longer needed.  Be sure to save the
    unsecured object so you can make changes at a
    later date, however. 
    
   )
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Ary")
     (optional yes)
    )
    (input 2
     (type data)
     (name "B")
     (optional yes)
    )
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "YPlot"
     (name "XY Trace")
     (subType "XY_Trace")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "PASS")
       (lock constraints)
      )
      (input 2
       (type data)
       (name "FAIL")
       (lock constraints)
       (optional yes)
      )
      (input 3
       (type data)
       (name "Limit")
       (lock constraints)
       (optional yes)
      )
      (input 4
       (type control)
       (name "Auto Scale")
       (lock name constraints)
       (optional yes)
      )
      (input 5
       (type control)
       (name "Next Curve")
       (lock name constraints)
       (optional yes)
      )
     )
     (implementation
      (component clearAtPrerun 1)
      (component clearAtActivate 0)
      (component tracePin 1)
      (component tracePin 2)
      (component tracePin 3)
      (component graphMode rectangular)
     )
     (views
      (icon
       (iconImage "display.icon")
      )
      (detail
       (origin 453 415)
       (extent 315 250)
       (displayMode annotGraph)
       (graphType cartesian)
       (gridType frame)
       (scale 0
        (name "Y name")
        (domainName "X name")
        (pen 9)
        (show 1)
        (range 0 18 4 linear)
       )
       (domain 0 10 4 linear)
       (trace 0 onScale 0
        (name "PASS")
        (pen 3)
        (lineType 1)
        (pointType 6)
       )
       (trace 1 onScale 0
        (name "FAIL")
        (pen 2)
        (lineType 1)
        (pointType 6)
       )
       (trace 2 onScale 0
        (name "Limit")
        (pen 4)
        (lineType 4)
        (pointType 0)
       )
      )
      (active detail)
     )
    )
    (component 1 "Formula"
     (name "Calculate FAIL Bar coords")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (input 2
       (type data)
       (name "I")
       (optional yes)
      )
      (input 3
       (type data)
       (name "L")
       (optional yes)
      )
      (input 4
       (type data)
       (name "z")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "(a[i]<L ? [coord(I+z/2,A[i]) coord(I+1-z/2,A[i])] : [coord(I+z/2,0)])")
     )
     (views
      (icon
       (origin 193 468)
       (extent 235 45)
      )
      (detail
       (origin 113 458)
       (extent 664 204)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "Formula"
     (name "Calculate PASS Bar coords")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (input 2
       (type data)
       (name "I")
       (optional yes)
      )
      (input 3
       (type data)
       (name "L")
       (optional yes)
      )
      (input 4
       (type data)
       (name "z")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "(a[i]>=L ? [coord(I+z/2,A[i]) coord(I+1-z/2,A[i])] : [coord(I+z/2,0)])")
     )
     (views
      (icon
       (origin 193 408)
       (extent 235 45)
      )
      (detail
       (origin 113 398)
       (extent 664 204)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 3 "Formula"
     (name "Threshold Limit")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (input 2
       (type data)
       (name "B")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Result")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "[coord(0,b) coord(a,b)]")
     )
     (views
      (icon
       (origin 288 528)
       (extent 145 25)
      )
      (detail
       (origin 275 578)
       (extent 241 104)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 4 "Constant"
     (name "Spacing")
     (subType "Real")
     (interface
      (sequence in)
      (sequence out)
      (output 1
       (type data)
       (name "Real")
       (lock name constraints)
      )
     )
     (implementation
      (component value Real
       (name "Spacing")
       (datum 0.2)
      )
      (component autoTrigger off)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Real
       (datum 0)
      )
     )
     (views
      (icon
       (origin 271 268)
       (extent 78 25)
      )
      (detail
       (origin 217 354)
       (extent 147 32)
       (showFormat real)
      )
      (active detail)
     )
    )
    (component 5 "FromArray"
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Ary")
       (tag "Ary")
      )
      (output 1
       (type data)
       (name "SubAry")
       (tag "Result")
       (lock constraints)
      )
      (output 2
       (type data)
       (name "Type")
       (tag "Type")
       (lock constraints)
      )
      (output 3
       (type data)
       (name "NumDims")
       (tag "NumDims")
       (lock constraints)
      )
      (output 4
       (type data)
       (name "DimSizes")
       (tag "DimSizes")
       (lock constraints)
      )
      (output 5
       (type data)
       (name "TotSize")
       (tag "TotSize")
       (lock constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr 1 "Ary")
     )
     (views
      (icon
       (origin 135 548)
       (extent 110 64)
       (iconImage "unbuild.icon")
      )
      (detail
       (origin 252 110)
       (extent 147 160)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 6 "ForCount"
     (name "For Count")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "Count")
       (tag "Count")
       (requires
        (datatype Int32)
        (shape "Scalar")
       )
       (lock constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (name "Count")
       (lock name constraints)
      )
      (buffers in
       (buffer "Count")
      )
     )
     (implementation
      (component count 10)
     )
     (views
      (icon
       (origin 275 578)
       (extent 110 64)
       (iconImage "loop.icon")
      )
      (detail
       (origin 615 253)
       (extent 170 34)
      )
      (active icon)
     )
    )
    (configuration
     (connect D2:1 D0:1)
     (connect D1:1 D0:2)
     (connect D3:1 D0:3)
     (connect D6:0 D0:4)
     (connect D0:0 D0:5)
     (connect I1:1 D1:1)
     (connect D6:1 D1:2)
     (connect I2:1 D1:3)
     (connect D4:1 D1:4)
     (connect I1:1 D2:1)
     (connect D6:1 D2:2)
     (connect I2:1 D2:3)
     (connect D4:1 D2:4)
     (connect D5:5 D3:1)
     (connect I2:1 D3:2)
     (connect I1:1 D5:1)
     (connect D5:5 D6:1)
    )
   )
   (views
    (icon
     (origin 478 498)
     (extent 145 25)
    )
    (panel
     (origin 581 116)
     (extent 378 249)
     (widget 0 detail
      (title off)
      (origin 585 120)
      (extent 371 241)
      (displayMode annotGraph)
      (graphType cartesian)
      (gridType frame)
      (scale 0
       (name "Y name")
       (domainName "X name")
       (pen 1)
       (show 1)
       (range 0 18 4 linear)
      )
      (domain 0 10 4 linear)
      (trace 0 onScale 0
       (name "PASS")
       (pen 3)
       (lineType 1)
       (pointType 6)
      )
      (trace 1 onScale 0
       (name "FAIL")
       (pen 2)
       (lineType 1)
       (pointType 6)
      )
      (trace 2 onScale 0
       (name "Limit")
       (pen 4)
       (lineType 4)
       (pointType 0)
      )
     )
    )
    (detail
     (origin 70 353)
     (extent 720 335)
     (configuration
      (connect D2:1 D0:1
       (Point 430 430)
       (Point 440 430)
       (Point 440 440)
       (Point 450 440)
      )
      (connect D1:1 D0:2
       (Point 430 490)
       (Point 450 490)
      )
      (connect D3:1 D0:3
       (Point 435 540)
       (Point 450 540)
      )
      (connect D6:0 D0:4
       (Point 330 644)
       (Point 330 660)
       (Point 400 660)
       (Point 400 590)
       (Point 450 590)
      )
      (connect D0:0 D0:5
       (Point 610 667)
       (Point 610 680)
       (Point 430 680)
       (Point 430 640)
       (Point 450 640)
      )
      (connect I1:1 D1:1
       (Point 72 440)
       (Point 90 440)
       (Point 90 470)
       (Point 190 470)
      )
      (connect D6:1 D1:2
       (Point 387 610)
       (Point 410 610)
       (Point 410 670)
       (Point 120 670)
       (Point 120 480)
       (Point 190 480)
      )
      (connect I2:1 D1:3
       (Point 72 620)
       (Point 80 620)
       (Point 80 490)
       (Point 190 490)
      )
      (connect D4:1 D1:4
       (Point 366 370)
       (Point 380 370)
       (Point 380 400)
       (Point 170 400)
       (Point 170 500)
       (Point 190 500)
      )
      (connect I1:1 D2:1
       (Point 72 440)
       (Point 80 440)
       (Point 80 410)
       (Point 190 410)
      )
      (connect D6:1 D2:2
       (Point 387 610)
       (Point 410 610)
       (Point 410 670)
       (Point 120 670)
       (Point 120 480)
       (Point 150 480)
       (Point 150 420)
       (Point 190 420)
      )
      (connect I2:1 D2:3
       (Point 72 620)
       (Point 80 620)
       (Point 80 490)
       (Point 160 490)
       (Point 160 430)
       (Point 190 430)
      )
      (connect D4:1 D2:4
       (Point 366 370)
       (Point 380 370)
       (Point 380 400)
       (Point 170 400)
       (Point 170 440)
       (Point 190 440)
      )
      (connect D5:5 D3:1
       (Point 247 600)
       (Point 260 600)
       (Point 260 530)
       (Point 285 530)
      )
      (connect I2:1 D3:2
       (Point 72 620)
       (Point 80 620)
       (Point 80 490)
       (Point 160 490)
       (Point 160 530)
       (Point 250 530)
       (Point 250 540)
       (Point 270 540)
       (Point 270 550)
       (Point 285 550)
      )
      (connect I1:1 D5:1
       (Point 72 440)
       (Point 90 440)
       (Point 90 470)
       (Point 100 470)
       (Point 100 580)
       (Point 132 580)
      )
      (connect D5:5 D6:1
       (Point 247 600)
       (Point 260 600)
       (Point 260 610)
       (Point 272 610)
      )
     )
    )
    (active panel)
    (active panel)
   )
  )
  (component 6 "Context"
   (name "Press For")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "IfThenElse"
     (name "!= 0")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a!=0")
     )
     (views
      (icon
       (origin 365 350)
       (extent 46 25)
      )
      (detail
       (origin 209 308)
       (extent 73 64)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "Toggle"
     (name "Info About")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Reset")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Info About")
       (values range 0 1)
       (datum 0)
      )
      (component autoTrigger on)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (datum 0)
      )
     )
     (views
      (icon
       (origin 201 343)
       (extent 114 39)
       (format button)
      )
      (detail
       (origin 320 203)
       (extent 42 54)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "Context"
     (name "Info About This Example")
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Confirm"
       (name "DONE")
       (description 7 8
        This tiny "thread" begins running when the 
        enclosing UserObject is executed.  When the user
        acknowledges the OK/DONE button, there is nothing
        left to execute, so the thread ends.  Since there
        are not other threads running, the User Object
        is completed and will exit, removing the Show on
        Execute pop-up display.
       )
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 421 482)
         (extent 58 37)
        )
        (detail
         (origin 156 253)
         (extent 79 34)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "Note"
       (name "NotePad")
       (description 2 8
        This notepad is displayed as a Show on Execute
        panel to present the information to the reader.
       )
       (interface
       )
       (implementation
        (component text 27 9
         PURPOSE:     Illustrates use of the PFBarChart library object to display an array of data.
         
         USER INPUT REQUIRED: Press Run to display the Bar Chart.
         
         EXPLANATION: To generate some interesting data to display, an array of 100 random numbers
                      between 0 and 1.0 is analyzed to get the magnitude Distribution in 10 "bins"
                      between 0 and 1.  The resulting array has 10 elements representing the number
                      of numbers in each of the 10 bins.  This array is given to the PFBarChart
                      library object for display.  A slider provides the threshold/limit value for
                      determining the color of each bar.
         
                      The PFBarChart object uses the Threshold value to determine which of two
                      trace inputs to an XY should be used.  If you want to reverse the sense of
                      the test (values below the Limit will PASS), use the Traces and Scales menu
                      obtained by clicking the Right Button on the barchart graph to switch the
                      Labels (PASS and FAIL) and Trace Colors (Pen3 Pen4).
         
         IMPLEMENTATION:  The PFBarChart library object provides additional usage information from
                      the Show Description choice in the object menu.  Setting colors, etc. is
                      described here, along with a description of the input requirements.  When
                      using a BarChart object in your models, you may want to place and size it,
                      then secure the User Object to prevent inadvertent changes.  
         
                      Since the PFBarChart is a User Object, you may want to examine it to see how
                      the barchart is generated.  Some advanced techniques are used to generate
                      the bar fill using the YPlot "Traces & Scales" menu to set the "Point" style
                      to fill-mode.
        )
       )
       (views
        (icon
         (origin 410 415)
         (extent 78 25)
        )
        (detail
         (origin 25 209)
         (extent 848 437)
         (editing disabled)
        )
        (active icon)
       )
      )
      (configuration
      )
      (ShowOnExecPanel
       (origin 0 37)
       (extent 872 563)
       (panel
        (origin 26 168)
        (extent 868 525)
        (widget 0 icon
         (title off)
         (origin 425 652)
         (extent 58 37)
        )
        (widget 1 detail
         (title off)
         (origin 31 176)
         (extent 851 458)
         (editing disabled)
        )
       )
      )
     )
     (views
      (icon
       (origin 352 418)
       (extent 217 25)
      )
      (detail
       (origin 17 160)
       (extent 866 520)
       (configuration
       )
      )
      (active icon)
     )
    )
    (configuration
     (connect D1:1 D0:1)
     (connect D2:0 D1:1)
     (connect D0:1 D2:0)
    )
   )
   (views
    (icon
     (origin 415 408)
     (extent 110 25)
    )
    (panel
     (origin 21 122)
     (extent 319 77)
     (widget 1 icon
      (title off)
      (origin 123 135)
      (extent 114 39)
      (format button)
     )
    )
    (detail
     (origin 4 115)
     (extent 912 591)
     (configuration
      (connect D1:1 D0:1
       (Point 317 362)
       (Point 362 362)
      )
      (connect D2:0 D1:1
       (Point 460 445)
       (Point 460 460)
       (Point 180 460)
       (Point 180 362)
       (Point 198 362)
      )
      (connect D0:1 D2:0
       (Point 413 352)
       (Point 460 352)
       (Point 460 415)
      )
     )
    )
    (active panel)
    (active panel)
   )
  )
  (configuration
   (connect D2:0 D0:0)
   (connect D0:1 D1:1)
   (connect D0:1 D5:1)
   (connect D2:1 D5:2)
  )
 )
 (views
  (panel
   (origin 0 67)
   (extent 875 533)
   (widget 6 panel
    (title on)
    (origin 18 117)
    (extent 193 97)
    (widget 1 icon
     (title off)
     (origin 54 139)
     (extent 114 39)
     (format button)
    )
   )
   (widget 1 detail
    (title on)
    (origin 18 270)
    (extent 154 265)
   )
   (widget 3 detail
    (title on)
    (origin 526 116)
    (extent 322 99)
    (editing disabled)
   )
   (widget 4 detail
    (title on)
    (origin 226 116)
    (extent 287 99)
    (editing disabled)
   )
   (widget 5 panel
    (title on)
    (origin 375 271)
    (extent 473 264)
    (widget 0 detail
     (title off)
     (origin 379 275)
     (extent 465 256)
     (displayMode annotGraph)
     (graphType cartesian)
     (gridType frame)
     (scale 0
      (name "Y name")
      (domainName "X name")
      (pen 1)
      (show 1)
      (range 0 18 4 linear)
     )
     (domain 0 10 4 linear)
     (trace 0 onScale 0
      (name "PASS")
      (pen 3)
      (lineType 1)
      (pointType 6)
     )
     (trace 1 onScale 0
      (name "FAIL")
      (pen 2)
      (lineType 1)
      (pointType 6)
     )
     (trace 2 onScale 0
      (name "Limit")
      (pen 4)
      (lineType 4)
      (pointType 0)
     )
    )
   )
   (widget 2 detail
    (title on)
    (origin 192 270)
    (extent 162 266)
   )
  )
  (detail
   (origin 0 67)
   (extent 958 610)
   (configuration
    (connect D2:0 D0:0
     (Point 450 347)
     (Point 450 370)
     (Point 200 370)
     (Point 200 388)
    )
    (connect D0:1 D1:1
     (Point 392 570)
     (Point 449 570)
    )
    (connect D0:1 D5:1
     (Point 392 570)
     (Point 420 570)
     (Point 420 410)
     (Point 560 410)
     (Point 560 180)
     (Point 578 180)
    )
    (connect D2:1 D5:2
     (Point 530 230)
     (Point 550 230)
     (Point 550 300)
     (Point 578 300)
    )
   )
  )
  (active panel)
  (active panel)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
