#! /usr/lib/veetest/veetest -r
(revision "A.00.01")
(date "Sun 22/Sep/1991")
(component 0 "Context"
 (name "Break 1D array into 2D array Example")
 (interface
 )
 (implementation
  (trigMode deg)
  (locked no)
  (component 0 "AllocateArray"
   (name "Alloc Real")
   (subType "Alloc_Real")
   (interface
    (sequence in)
    (sequence out)
    (output 1
     (type data)
     (name "Array")
     (tag "Array")
     (lock constraints)
    )
   )
   (implementation
    (component numDims 1)
    (component dimSizes "12")
    (component type "Real")
    (component initEnum "Lin Ramp")
    (component initialValue
     (name "Init Value")
     (datum 0)
    )
    (component from 1)
    (component thru 12)
   )
   (views
    (icon
    )
    (detail
     (origin 71 269)
     (extent 189 122)
    )
    (terminals on)
    (active detail)
   )
  )
  (component 1 "TextDisplay"
   (name "1-D Input")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 110 0)
    )
    (detail
     (origin 141 465)
     (extent 178 251)
    )
    (active detail)
   )
  )
  (component 2 "Formula"
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "A")
     (optional yes)
    )
    (output 1
     (type data)
     (name "Result")
     (lock name constraints)
    )
   )
   (implementation
    (component isLocked no)
    (component expr 1 "[a[0:2] a[3:5] a[6:8] a[9:11]]")
   )
   (views
    (icon
     (iconImage "formula.icon")
    )
    (detail
     (origin 439 278)
     (extent 313 104)
    )
    (terminals on)
    (active detail)
   )
  )
  (component 3 "Context"
   (name "Press For")
   (interface
    (sequence in)
    (sequence out)
   )
   (implementation
    (trigMode deg)
    (locked no)
    (component 0 "IfThenElse"
     (name "!= 0")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type data)
       (name "A")
       (optional yes)
      )
      (output 1
       (type data)
       (name "Then")
       (lock name constraints)
      )
      (output 2
       (type data)
       (name "Else")
       (lock name constraints)
      )
     )
     (implementation
      (component isLocked no)
      (component expr "a!=0")
     )
     (views
      (icon
       (origin 335 350)
       (extent 46 25)
      )
      (detail
       (origin 209 308)
       (extent 73 64)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 1 "Toggle"
     (name "Info About")
     (interface
      (sequence in)
      (sequence out)
      (input 1
       (type control)
       (name "Reset")
       (lock name constraints)
       (optional yes)
      )
      (output 1
       (type data)
       (lock name constraints)
      )
     )
     (implementation
      (component value Int32
       (name "Info About")
       (values range 0 1)
       (datum 0)
      )
      (component autoTrigger on)
      (component initializeAtPrerun off)
      (component initializeAtActivate off)
      (component initValue Int32
       (datum 0)
      )
     )
     (views
      (icon
       (origin 171 343)
       (extent 114 39)
       (format button)
      )
      (detail
       (origin 320 203)
       (extent 42 54)
      )
      (terminals on)
      (active icon)
     )
    )
    (component 2 "Context"
     (name "Info About This Example")
     (interface
      (sequence in)
      (sequence out)
     )
     (implementation
      (trigMode deg)
      (locked no)
      (component 0 "Confirm"
       (name "DONE")
       (description 7 8
        This tiny "thread" begins running when the 
        enclosing UserObject is executed.  When the user
        acknowledges the OK/DONE button, there is nothing
        left to execute, so the thread ends.  Since there
        are not other threads running, the User Object
        is completed and will exit, removing the Show on
        Execute pop-up display.
       )
       (interface
        (sequence in)
        (sequence out)
        (output 1
         (type data)
         (name "Go")
         (lock name constraints)
        )
       )
       (implementation
       )
       (views
        (icon
         (origin 421 482)
         (extent 58 37)
        )
        (detail
         (origin 156 253)
         (extent 79 34)
        )
        (terminals on)
        (active icon)
       )
      )
      (component 1 "Note"
       (name "NotePad")
       (description 2 8
        This notepad is displayed as a Show on Execute
        panel to present the information to the reader.
       )
       (interface
       )
       (implementation
        (component text 21 9
         PURPOSE:      Illustrates use of the Formula box and Array building syntax to construct
                       a 2D array from a larger 1D input array when the array sizes are fixed.
         
         USER INPUT REQUIRED: Press Run and observe the input and output displays.
         
         EXPLANATION:  A general purpose library device (AryToMat) allows building a 2D array
                       with dimensions determined programatically.  In many cases, however,
                       the desired size is fixed by the design and need not be calculated.  In
                       these cases, use of the Formula object and the array-building expressions
                       allows construction of a 2D array very efficiently.
         
         IMPLEMENTATION:  Given the input array with 12 elements, we construct a 3 by 4 array
                      as follows.  First, recognize that the notation a[0:2] represents the sub-
                      array composed of the first 3 elements of array a.  Second, recognize that
                      the array building syntax "[x y]" constructs a 1D array if x and y are
                      scalars, a 2D array if x and y are 1D arrays, etc.
         
                      Thus, we build the 3 by 4 output array by specifying an array with 4 
                      elements that are 1D arrays, i.e. "[ a[0:2] a[3:5] a[6:8] a[9:11] ]".
                      
         
        )
       )
       (views
        (icon
         (origin 410 415)
         (extent 78 25)
        )
        (detail
         (origin 25 209)
         (extent 848 437)
         (editing disabled)
        )
        (active icon)
       )
      )
      (configuration
      )
      (ShowOnExecPanel
       (origin 48 78)
       (extent 849 571)
       (panel
        (origin 8 164)
        (extent 845 533)
        (widget 0 icon
         (title off)
         (origin 407 649)
         (extent 58 37)
        )
        (widget 1 detail
         (title off)
         (origin 15 175)
         (extent 832 463)
         (editing disabled)
        )
       )
      )
     )
     (views
      (icon
       (origin 322 418)
       (extent 217 25)
      )
      (detail
       (origin 17 160)
       (extent 866 520)
       (configuration
       )
      )
      (active icon)
     )
    )
    (configuration
     (connect D1:1 D0:1)
     (connect D2:0 D1:1)
     (connect D0:1 D2:0)
    )
   )
   (views
    (icon
     (origin 415 408)
     (extent 110 25)
    )
    (panel
     (origin 251 122)
     (extent 319 77)
     (widget 1 icon
      (title off)
      (origin 353 135)
      (extent 114 39)
      (format button)
     )
    )
    (detail
     (origin 4 115)
     (extent 912 591)
     (configuration
      (connect D1:1 D0:1
       (Point 287 362)
       (Point 332 362)
      )
      (connect D2:0 D1:1
       (Point 430 445)
       (Point 430 460)
       (Point 150 460)
       (Point 150 362)
       (Point 168 362)
      )
      (connect D0:1 D2:0
       (Point 383 352)
       (Point 430 352)
       (Point 430 415)
      )
     )
    )
    (active panel)
    (active panel)
   )
  )
  (component 4 "Note"
   (name "Warranty Disclaimer")
   (interface
   )
   (implementation
    (component text 4 5
     This example is provided as an
     illustration "as is", and Hewlett-Packard
     Company makes no warranty of any kind
     with regard to this example.
    )
   )
   (views
    (icon
     (extent 181 0)
    )
    (detail
     (origin 582 119)
     (extent 397 82)
     (editing disabled)
    )
    (active detail)
   )
  )
  (component 5 "TextDisplay"
   (name "2-D Output Array")
   (interface
    (sequence in)
    (sequence out)
    (input 1
     (type data)
     (name "Data")
    )
   )
   (implementation
    (component clearAtPrerun 1)
    (component clearAtActivate 1)
   )
   (views
    (icon
     (extent 154 0)
    )
    (detail
     (origin 408 466)
     (extent 424 209)
    )
    (active detail)
   )
  )
  (component 6 "Note"
   (name "To Operate")
   (interface
   )
   (implementation
    (component text 3 5
     Click on "Run" and
     observe the input and
     output data arrays.
    )
   )
   (views
    (icon
     (extent 110 0)
     (iconImage "notepad.icon")
    )
    (detail
     (origin 9 123)
     (extent 223 75)
     (editing disabled)
    )
    (active detail)
   )
  )
  (configuration
   (connect D0:1 D1:1)
   (connect D0:1 D2:1)
   (connect D2:1 D5:1)
  )
 )
 (views
  (detail
   (origin 0 67)
   (extent 880 413)
   (configuration
    (connect D0:1 D1:1
     (Point 322 330)
     (Point 340 330)
     (Point 340 410)
     (Point 120 410)
     (Point 120 590)
     (Point 138 590)
    )
    (connect D0:1 D2:1
     (Point 322 330)
     (Point 396 330)
    )
    (connect D2:1 D5:1
     (Point 824 330)
     (Point 840 330)
     (Point 840 400)
     (Point 390 400)
     (Point 390 570)
     (Point 405 570)
    )
   )
  )
  (active detail)
  (numberFormats
   (realFormat standard)
   (realSigDigits 4)
   (realRadixSpec 4)
   (integerBase decimal)
  )
  (waveformSettings
   (timeSpan 0.02)
   (numPoints 256)
  )
 )
)
